=head1 NAME

API::App::AccessRegistry

=head1 DESCRIPTION

    Модуль для работы с доступами приложений к АПИ

=cut
package API::App::AccessRegistry;

use strict;
use warnings;
use utf8;

use Yandex::DateTime;
use Yandex::DBTools;
use Settings;
use API::App::Access;

use Mouse;
use Mouse::Util::TypeConstraints;

subtype Access => as Object => where { $_->isa('API::App::Access') };

has accesses => (
    is => 'rw',
    isa => 'ArrayRef[Access]',
    required => 1
);


around BUILDARGS => sub {
    my ($orig, $self, $application_ids)  = @_;
    my @results;
    if (scalar @$application_ids) {
        my $accesses = get_all_sql(PPCDICT,
        ['select application_id, access_type, manager_login, comment, check_time, min_api_version_override from api_app_access',
            where => {application_id => $application_ids}
        ]);
        for my $access (@$accesses) {
            if ($access->{check_time} eq '0000-00-00 00:00:00') {
                $access->{check_time} = undef;
            } else {
                $access->{check_time} = datetime($access->{check_time});
            }
            if ($access->{access_type}) {
                $access->{found} = 1;
            }
            
            push @results, API::App::Access->new(%$access);
        }
    }

    return $self->$orig(accesses => \@results);
};

=head2 get

    Возвращает один доступ из набора

=cut

sub get {
    my ($self, $application_id) = @_;
    for my $access ($self->list()) {
        return $access if $access->application_id eq $application_id;
    }
    return;
}

=head2 list

    Возврвщает список доступов для приложений

=cut

sub list {
    my ($self) = @_;
    return @{$self->accesses};
}

__PACKAGE__->meta->make_immutable;

1;
