package API::App::CheckAccess;

use strict;
use warnings;
use utf8;

=pod

    $Id$

=head1 NAME

    API::App::CheckAccess

=head1 SYNOPSIS

    use API::App::CheckAccess;

    die 'Application not registered' unless API::App::CheckAcess($app_id);

=head1 DESCRIPTION

    Метод для проверки приложения на наличие одобренной заявки, вынесен отдельно для использования в обоих версиях API

=head1 METHODS

=cut

use EnvTools qw/is_sandbox/;

use API::App::AccessCheckResult;
use API::App::AccessRegistry;

my $NO_ACCESS = API::App::AccessCheckResult->new( has_access => 0 );

=head2 check_registration($application_id)

Проверяет есть ли у приложения доступ к API на текущей среде

Возвращает API::App::AccessCheckResult

=cut

sub check_registration($){
    my $application_id = shift;

    my $accesses = API::App::AccessRegistry->new([$application_id]);
    my $access = $accesses->get($application_id);
    if ($access && $access->found) {
        if ($access->access_type) {
            my $successful_check_result = API::App::AccessCheckResult->new(
                has_access => 1,
                min_api_version_override => $access->min_api_version_override,
            );

            return $successful_check_result if $access->access_type eq 'normal';
            return $successful_check_result if $access->access_type eq 'test' and is_sandbox();
        }
    }
    return $NO_ACCESS;
}

=head2 application_has_api_access

Как check_registration, но возвращает булевское значение "есть ли доступ к API вообще"
и выбрасывает любую дополнительную информацию.

=cut

sub application_has_api_access($) {
    my ($application_id) = @_;
    my $check_result = check_registration($application_id);
    return $check_result && $check_result->has_access;
}

1;

__END__
