package API::App::Request::CSV;

# $Id$
# API::App::Request::CSV
# Автор: Elvira Sidorova <lightelfik@yandex-team.ru>


use warnings;
use strict;
use utf8;

use Text::CSV;
use Fcntl qw(:flock);
use JSON;
use Carp;
use Direct::Storage;

use Settings;
use API::App::Request::MassMethods qw/app_requests_get_all/;

use Mouse;

has fields => (
    is => 'ro', isa => 'ArrayRef[Str]',
    default => sub {
        [qw/
            cr_id
            name
            uid
            access_type
            create_time
            end_time
            status
            check_time
            application_id
            developer_email
            company_site
            company_name
            business_type
            other_business_type
            api_logins_list
            prog_language
            protocol
            library_version
            app_goals
            other_app_goal
            app_functions
            other_app_function
            using_api_functions
            app_profit
            specifications_and_screenshots
            app_demo_access
            dev_finish
        /];
    }
);
has file_name => (is => 'ro', isa => 'Str', default => 'certification_request.csv');

my $collection = 'certification_csv';

=head2 get

    Получает файл отчета и отдает пользователю

=cut

sub get {
    my $self = shift;
    my $storage = Direct::Storage->new();
    my $result = $storage->get_file($collection, filename => $self->file_name);
    if ($result) {
        return $result->content;
    }
    return;
}

=head2 generate

    Генерирует CSV отчет со всеми заявками
    кладет в MDS

=cut

sub generate {
    my $self = shift;
    my $storage = Direct::Storage->new();
    my $csv = Text::CSV->new ( { binary => 1, sep_char => ';' } );
    $csv->eol ("\r\n");
    my $string;
    open( my $fh, '+>:encoding(UTF-8)', \$string );
    flock($fh, LOCK_EX);
    $csv->print ($fh, $self->fields);
    
    my $limit = 1000, my $i=0; 
    my $offset;
    
    while (1) {
        $offset = $limit * $i;
        my $requests = app_requests_get_all($limit, $offset);
        if (scalar @$requests) {
            $csv->print ($fh, _prepare([@{$_}{@{$self->fields}}])) for @$requests;
            $i++;
        } else {
            last;
        }
    }
    close($fh);

    $storage->save($collection, \$string, filename => $self->file_name);
    return 1;
}

sub _prepare($){
    my $row = shift;
    for my $field (@$row){
        $field = join ', ', map {_prepare_element($_)} @$field
            if ref $field eq 'ARRAY';
    }
    return $row;
}

sub _prepare_element($){
    my $element = shift;
    
    if (ref $element eq 'HASH') {
        $element = to_json($element);
    }
    return $element;
}

1;
