package API::App::Request::History;
=head1 NAME

API::App::Request::History

=head1 DESCRIPTION

=cut

use strict;
use warnings;
use utf8;

use Settings;
use Yandex::DBTools;
use API::App::Request::Tools qw/prepare_from_db/;

use base qw/Exporter/;
our @EXPORT_OK = qw/
    app_request_history_get
    app_request_history_get_last
    app_request_history_save
/;

my @fields = qw/cr_id application_id name uid access_type request_info
            other_info create_time end_time status check_time comment/;
my $fields_string = join(',' => @fields);

=head2 app_request_history_save($uid, $application_id)

    Когда пользователь пытается обновить заявку, сохраняет историю

=cut

sub app_request_history_save($$){
    my ($uid, $application_id) = @_;

    my $old_request = get_one_line_sql(PPCDICT,[
        "select $fields_string from api_app_certification_request",
        where => {application_id => $application_id, uid => $uid}]
    );
    if (%$old_request) {
        do_insert_into_table(PPCDICT, 'api_app_certification_request_history',
            $old_request);
    } else {
       return; 
    }
    return 1;
}

=head2 app_request_history_get(uid, application_id, create_time=>'2014-03-11 17:11:12')

   Получает историю заявки

=cut

sub app_request_history_get($$;@){
    my ($uid, $application_id, $create_time) = @_;
    my $where = {   application_id => $application_id,
                    uid => $uid
                };
    $where->{create_time} = $create_time if defined $create_time;
    my $requests = get_all_sql(PPCDICT, ["select $fields_string
                    from api_app_certification_request_history",
                    where => $where, 'order by create_time DESC'
    ]);
    my @result = map {prepare_from_db($_)} @$requests;
    return \@result; 
}

=head2 app_request_history_get_last(uid, application_id)

   Получает последнюю версию заявки из истории

=cut
sub app_request_history_get_last($$){
    my ($uid, $application_id) = (shift, shift);
    my $request = get_one_line_sql(PPCDICT, ["select $fields_string
                    from api_app_certification_request_history",
                    where => {
                        application_id => $application_id,
                        uid => $uid
                    },
                    'order by create_time DESC limit 1'
    ]);
    return $request ? prepare_from_db($request) : undef; 
}


1;
