=head1 NAME

API::App::Request::Normal

=head1 DESCRIPTION

=cut
package API::App::Request::Normal;

use strict;
use warnings;
use utf8;

use API::App::Specification::List;

use Yandex::Log;
use Yandex::DBShards;

use Mouse;
use Mouse::Util::TypeConstraints;

extends 'API::App::Request';
    
subtype Specifications => as Object => where { $_->isa('API::App::Specification::List') };

enum 'Protocol', [qw/json soap/];

has api_logins_list => ( is => 'rw', isa => 'Str', default => '', required => 1 );

has prog_language => ( is => 'rw', isa => 'Str', default => '' );

has protocol => ( is => 'rw', isa => 'ArrayRef[Protocol]' );

has library_version => ( is => 'rw', isa => 'Maybe[Str]', default => '' );

has using_api_functions => ( is => 'rw', isa => 'Str', default => '', required => 1);

has specifications_and_screenshots => (
    is => 'rw',
    isa => 'Specifications',
    default => sub { API::App::Specification::List->new([]) }
);

has app_demo_access => ( is => 'rw', isa => 'Maybe[Str]', default => '');

my $log = Yandex::Log->new(
    log_file_name => 'CertificationRequest.log',
    date_suf      => "%Y%m%d",
    msg_prefix    => "[$$]",
    auto_rotate => 1
);

=head2 add(self)

   Добавляет заявку на сертификацию

=cut

sub add {
    my ($self) = @_;
    my $id = get_new_id('cr_id');
    $self->specifications_and_screenshots->upload($id, $self->uid);

    return $self->SUPER::add($id);
}

=head2 update(self)

   Обновляет заявку на сертификацию

=cut

sub update($) {
    my ($self) = @_;

    my $id = get_new_id('cr_id');
    $self->specifications_and_screenshots->upload($id, $self->uid);
    
    return $self->SUPER::update($id);
}





1;
