package API::App::Specification::List;
=head1 NAME

    API::App::Specification::List
    Класс для работы с наборами файлов
    
=head1 DESCRIPTION

=cut

use strict;
use warnings;
use utf8;

use API::App::Specification::Item;

use Mouse;
use Mouse::Util::TypeConstraints;

subtype Specification => as Object => where { $_->isa('API::App::Specification::Item') };

has specifications => (
    is => 'rw',
    isa => 'ArrayRef[Specification]',
    required => 1
);

=head2 delete(self, name)

   Удалить спецификацию из списка и из Стораджа по имени

=cut

sub delete($$) {
    my ($self, $name) = @_;
    my @specifications;
    my $result = 0;
    for my $specification (@{$self->specifications}){
        if ($specification->name eq $name) {
            $specification->delete();
            $result = 1;
        } else {
            push @specifications, $specification;
        }
    }
    $self->specifications([@specifications]);
    return $result;
}

=head2 get(self, name)

    Получить спецификацию из списка по имени

=cut

sub get($$){
    my ($self, $name) = @_;
    for my $specification (@{$self->specifications}){
        if ($specification->name eq $name) {
            return $specification;
        }
    }
    return 0;
}

=head2 merge(self, list)

   После обновления формы, мержит записи об уже загруженных файлах
   и тех что пользователь загрузил только в этой версии
   
   list - API::App::Specification::List

=cut

sub merge($$){
    my ($self, $list) = @_;
    push @{$self->specifications}, @{$list->specifications};
    return 1;
}

=head2 upload(self)

    Загружает файлы с сертификатами и скриншотами в Сторадж

=cut

sub upload($$$) {
    my ($self, $cr_id, $uid) = @_;
    for my $specification (@{$self->specifications}){
        if (!$specification->is_uploaded) {
            $specification->uid($uid);
            $specification->name($cr_id.'_'.$specification->name);
            $specification->upload();
        }
    }
    return 1;
}

=head2 is_empty(self)


=cut

sub is_empty($){
    my ($self) = @_;
    if (scalar @{$self->specifications}) {
        return 0;
    } else {
        return 1;
    }
}

=head2 to_list(self)

    Получает на основе объекта API::App::Specification::List
    массив хешей

=cut

sub to_list($){
    my ($self) = @_;
    my @specifications;
    for my $specification (@{$self->specifications}){
        push @specifications, $specification->to_hash();
    }
    return \@specifications;
}


1;
