=head1 NAME

API::App::Types

=head1 DESCRIPTION

    Описание типов

=cut
package API::App::Types;

use strict;
use warnings;
use utf8;

use Mouse::Util::TypeConstraints;

subtype 'ApplicationId'
    => as 'Str'
    => where { length($_) == 32 }
    => message { "length of application_id must be equal to 32" };

subtype DateTime => as Object => where { $_->isa('DateTime') };

enum 'AccessTypeEnum' => qw(test normal advanced);

enum 'Goal', [qw/automation sync_with_inner_servise aggregation
              upload_big_campaign other
              /];

enum 'Function', [qw/get_statistics manage_campaign manage_bids
              choice_keywords other
              /];
    
1;
