package API::Authorize::PersistentToken;

use Direct::Modern;

# $Id$

use HashingTools qw/ hmac_sha256_hex /;
use IpTools;
use PrimitivesIds qw/ get_uid /;

use API::Settings;

use base qw/ Exporter /;

our @EXPORT_OK = qw/ check_token /;

=head2 check_token( $ptoken, $remote_addr )

    Авторизация по persistent token-у

=cut

sub check_token {
    my ( $ptoken, $remote_addr ) = @_;

    die 'No persistent token given'
        unless defined $ptoken;

    die 'No remote address given'
        unless defined $remote_addr;

    # проверка токена в словаре
    my $ptoken_hash = hmac_sha256_hex( $ptoken, $API::Settings::API_PERSISTENT_TOKENS_KEY );
    my $ptoken_data = $API::Settings::API_PERSISTENT_TOKENS->{ $ptoken_hash };
    return undef unless $ptoken_data;

    my $authorized_network = IpTools::check_acl( $remote_addr, $ptoken_data->{allow_to} );

    if (!$authorized_network) {
        warn qq~token for login $ptoken_data->{login} application $ptoken_data->{application_id} authorized, but not from allowed network. IP: $remote_addr~;
        return undef;
    }

    return {
        uid => get_uid( login => $ptoken_data->{login} ),
        login => $ptoken_data->{login},
        application_id => $ptoken_data->{application_id} // '',
    };
}

1;
