package API::DevelopersSubscription;

use Direct::Modern;

use base qw/ Exporter /;

our @EXPORT = qw/
    get_emails
    filter_cyrillic_domains
    send_cyrillic_email_domain_notification
/;

use Settings;
use Yandex::DBTools;
use MailService qw/send_die_letters/;
use ShardingTools;

=head2 get_emails

    Получаем email'ы разработчиков API

=cut

sub get_emails {
    my @result;
    foreach my $shard (ppc_shards()) {
        my $developers = get_one_column_sql(PPC(shard => $shard), "SELECT DISTINCT api_developer_email FROM users_api_options
            WHERE api_developer_email IS NOT NULL") || [];
        my $emails = filter_cyrillic_domains($developers);
        push @result, @$emails;
    }
    return \@result;
}

=head2 filter_cyrillic_domains

    Отфильтровываем кириллические домены

=cut

sub filter_cyrillic_domains {
    my $emails = shift;
    my (@result, @wrong_emails);
    for my $email (@$emails) {
        if ($email) {
            $email =~ s/^\s*(.*?)\s*$/$1/;
            # так как в базе должны лежать только валидные email'ы, регулярка не проверяет валидность email'а а только проверяет содержит ли валидный email кирилический домен
            if ($email =~ /^[^@]+@(?:[-a-zA-Z0-9]+\.)+[a-zA-Z]+$/) {
                push @result, $email;
            } else {
                push @wrong_emails, $email;
            }
        }
    }
    send_cyrillic_email_domain_notification(\@wrong_emails);
    return \@result;
}

=head2 send_cyrillic_email_domain_notification

    Отправляем сообщение о наличии кириллических доменов

=cut

sub send_cyrillic_email_domain_notification {
    my $wrong_emails = shift;
    send_die_letters(
        "SubscribeApiDeveloper.pl",
        sprintf('e-mails with cyrillic domain found %s', join(',', @$wrong_emails))
    );
    return;
}


1;


