package API::Limits;
## no critic (TestingAndDebugging::RequireUseWarnings)

=pod

    $Id:
    
=head1 NAME
    
    API::Limits - функции для работы с лимитами в АПИ

=head1 DESCRIPTION



=cut

use strict;

use API::Settings;

use List::Util qw( sum );

require Exporter;
our @ISA = qw(Exporter);
our @EXPORT = qw(
    has_spec_limits
    has_spec_limit
    get_spec_limit
    get_spec_method_limit
    get_clients_with_limits
    get_limit_by_spent
);

use utf8;


sub has_spec_limits($){
    my $client_id = shift;
    defined $API::Settings::SPEC_LIMITED_API_USERS{$client_id};
}

sub has_spec_limit($$){
    my ($client_id, $limit_name) = @_;
    return defined get_spec_limit($client_id, $limit_name);
}

sub get_spec_limit($$){
    my ($client_id, $limit_name) = @_;
    return $API::Settings::SPEC_LIMITED_API_USERS{$client_id}{$limit_name}
        if has_spec_limits($client_id);
    return;
}

sub get_spec_method_limit($$){
    my ($client_id, $method_name) = @_;
    return $API::Settings::SPEC_LIMITED_API_USERS{$client_id}{LIMITS}{$method_name}
        if has_spec_limits($client_id);
    return;
}

sub get_clients_with_limits(@){
    my @limits = @_;
    my @clients;
    for my $client_id (keys %API::Settings::SPEC_LIMITED_API_USERS) {
        my $number = sum( map {has_spec_limit($client_id, $_)} @limits);
        if ($number == scalar @limits) {
            push @clients, $client_id;
        }
    }
    return \@clients;
}

=head2 функция get_limit_by_spent

    расчет дневного лимита баллов API5 на основе суммы трат клиента

=cut
{
    my @ranges = sort { $a->{threshold} <=> $b->{threshold} } @{ $API::Settings::UNITS_BY_SPENT };

    sub get_limit_by_spent {
        my $spent = shift;


        my $units = 0;
        foreach my $range ( @ranges ) {
            next if ( $spent > $range->{threshold} and not exists $range->{last} );
            $units = $range->{units};
            last;
        }

        return $units;
    }
}

1;
