package API::Method::Keyword::ActionResults;

# $Id$


=head1

    Для удобства работы массивом ответов, попытка определния свойств объекта по списку 
    в декларативном виде

=cut

use strict;
use warnings;
use utf8;

use Mouse;

use List::MoreUtils qw/uniq/;
use Yandex::DBTools;

my %is_ro = (
    is => 'ro',
    lazy => 1
);

my %is_hash = (
    %is_ro,
    isa => 'HashRef',
);

my %is_array = (
    %is_ro,
    isa => 'ArrayRef',
);

has db => (is => 'ro', isa => 'HashRef');
has uid  => (is => 'ro', isa => 'Int');
has ids => (is => 'ro', isa => 'ArrayRef[Int]');

has ids_sorted => (
    %is_ro,
    isa => 'ArrayRef[Int]',
    default => sub {
        return [ sort &uniq(@{shift->ids}) ];
    }
);

has _keywords_hash_by_id => (
    %is_hash,
    default => sub {
        my $self = shift;
        return get_hashes_hash_sql($self->db, [
            "SELECT bi.id, bi.pid, p.cid, c.uid, c.type, bi.is_suspended
                  , u.ClientID
                FROM bids bi
                JOIN phrases p ON bi.pid = p.pid
                JOIN campaigns c ON p.cid = c.cid
                JOIN users u ON c.uid = u.uid
            ",
            where => { 'bi.id' => $self->ids_sorted }
        ]);
    }
);

has _results => (
    %is_hash,
    default => sub {
        my $self = shift;
        return {
            map {
                $_ => {
                    errors => [],
                    warnings => [],
                    to_update => 1,
                    keyword => $self->get_keyword($_),
                }
            } $self->list_ids_sorted
        }
    }
);

has wrong_uid_ids => (
    %is_array,
    default => sub {
        my $self = shift;
        return [
            grep {
                $self->get_keyword($_)->{uid} ne $self->uid
            } $self->list_found_ids
        ];
    }
);

has not_found_ids => (
    %is_array,
    default => sub {
        my $self = shift;
        return [ grep { !$self->get_keyword($_) } $self->list_ids_sorted ];
    }
);

has found_ids => (
    %is_array,
    default => sub {
        my $self = shift;
        return [ grep { $self->get_keyword($_) } $self->list_ids_sorted ];
    }
);

has suspended_ids => (
    %is_array,
    default => sub {
        my $self = shift;
        return [
            grep {
                $self->get_keyword($_)->{is_suspended}
            } $self->list_found_ids
        ]
    }
);

has unsuspended_ids => (
    %is_array,
    default => sub {
        my $self = shift;
        return [
            grep {
                not $self->get_keyword($_)->{is_suspended}
            } $self->list_found_ids
        ]
    }
);

has group_ids => (
    %is_array,
    default => sub {
        my $self = shift;
        return [
            map {
                $self->get_keyword($_)->{pid}
            } $self->list_found_ids
        ]
    }
);

has campaign_ids => (
    %is_array,
    default => sub {
        my $self = shift;
        return [
            map {
                $self->get_keyword($_)->{cid}
            } $self->list_found_ids
        ]
    }
);

has keywords_by_campaign_id => (
    %is_hash,
    default => sub {
        my $self = shift;
        my $campaigns = {};
        foreach my $kw (values %{$self->_keywords_hash_by_id}) {
            my $cid = $kw->{cid};
            push @{$campaigns->{$cid}}, $kw;
        }
        return $campaigns;
    }
);


foreach my $attr (qw/ids ids_sorted not_found_ids found_ids suspended_ids unsuspended_ids wrong_uid_ids group_ids campaign_ids/) {
    __PACKAGE__->meta->add_method("list_$attr" => sub {
        my $aref = shift->$attr;
        return @$aref;
    });
}

sub get_keyword {
    my $self = shift;
    my $id = shift;
    return $self->_keywords_hash_by_id->{$id};
}

sub get_result_item {
    my $self = shift;
    my $id = shift;
    return unless exists $self->_results->{$id};
    return $self->_results->{$id};
}

sub has_errors {
    my ($self, $id) = @_;
    return $self->_has_smth($id, 'errors');
}

sub has_warnings {
    my ($self, $id) = @_;
    return $self->_has_smth($id, 'warnings');
}

sub _has_smth {
    my $self = shift;
    my $id = shift;
    my $key = shift;
    my $result = $self->get_result_item($id) or die "$id not found";
    return scalar @{ $result->{$key} }?1:0;
}

sub ids_to_update {
    my $self = shift;
    return [
        grep  {
            $self->get_result_item($_)->{to_update}
            && !$self->has_errors($_)
        } $self->list_found_ids
    ];
}

__PACKAGE__->meta->make_immutable();

1;
