package API::Methods::Staff;

# $Id$

=head1 NAME
    
    API::Methods::Staff

=head1 DESCRIPTION

    Методы, доступный только для административных ролей Директа (super, support, mediaplanner, placer)

=cut

use strict;
use warnings;

use Settings;
use SearchObjects qw/search_clients/;
use PrimitivesIds;
use RBACElementary;
use APICommon qw/get_client_object/;
use API::Errors;

use utf8;

=head2 SearchLogin

    Поиск клиентов в Директе по логину, названию. (аналог cmd_search)
    На вход получает структуру:
    {
        Login =>
        UserID =>
        ClientID =>
        Name =>
        ManagerLogins => []
    }

    Все поля опциональны, но хотя бы одно заполненное обязательно, проверяется в API/Validate

=cut

sub SearchClients
{
    my ($self, $params) = @_;

    my $MAX_CLIENTS_IN_RESPONSE = 1000;

    if ($self->{rbac_login_rights}->{role} !~ /^(super|media|placer|support|superreader)$/) {
        dieSOAP('NoRights');
    }

    my $manager_filter = 'any';
    if (defined $params->{ManagerLogins}) {
        $manager_filter = 'all';
        if (scalar @{$params->{ManagerLogins}} > 0) {
            my $managers_uids = get_uids(login => $params->{ManagerLogins});

            my $managers_roles = rbac_multi_who_is($self->{rbac}, $managers_uids);

            $manager_filter = [grep {$managers_roles->{$_} eq 'manager'} keys %$managers_roles];
        }
    }

    my $query = {
        listbyuid => $params->{UserID},
        listbylogin => $params->{Login},
        listbyname => $params->{Name},
        listbyclientid => $params->{ClientID},
        listbycid => $params->{CampaignID},
        manageruidforclient => $manager_filter,
    };

    my $result_uids = search_clients( 
        $self->{rbac}, 
        {
            uids_only => 1, 
            is_direct => 1, 
            get_all_logins => ! $self->{rbac_login_rights}{manager_control}, 
            UID => $self->{uid}
        }, 
        $query,
    );

    my $result = [];
    my $count = 0;
    if (ref $result_uids eq 'ARRAY' && @$result_uids) {
        $count = scalar @$result_uids;
        if ($count > $MAX_CLIENTS_IN_RESPONSE) {
            $result_uids = [@{$result_uids}[0..$MAX_CLIENTS_IN_RESPONSE-1]]
        }
        $result = get_client_object( $self, uid => $result_uids, get_ext_params => 1 );
    }

    return { Count => $count, Clients => $result};
}

1;
