package API::ObjectRelations;

use Direct::Modern;

my %OBJECT_RELATIONS = (
    campaign => {
        text => {
            adgroup => {
                base => 1,
            },
        },
        mobile_content => {
            adgroup => {
                mobile_content => 1,
            },
        },
        dynamic => {
            adgroup => {
                dynamic => 1,
            },
        },
        performance => {
            adgroup => {
                performance => 1,
            },
        },
    },
    adgroup => {
        base => {
            banner => {
                text => 1,
            },
            keyword => 1,
            retargeting => 1,
        },
        mobile_content => {
            banner => {
                mobile_content => 1,
            },
            keyword => 1,
            retargeting => 1,
        },
        dynamic => {
            banner => {
                dynamic => 1,
            },
            dynamic_condition => 1,
        },
        performance => {
            banner => {
                performance => 1,
            },
        },
    },
    banner => {
        text => {
            image => 1,
            sitelink => 1,
            vcard => 1,
        },
        mobile_content => {
            sitelink => 1,
            vcard => 1,
        },
        dynamic => {
        },
        performance => {
        },
    }
);

my %ITEM_CLASSES; # формируем список возможных классов элементов по классам контейнеров для валидации класса элемента
foreach my $container_class (keys %OBJECT_RELATIONS) {
    foreach my $item_class (map { keys %$_ } values %{$OBJECT_RELATIONS{$container_class}}) {
        $ITEM_CLASSES{$container_class}->{$item_class} = 1;
    }
}

=head2 is_eligible_container_item($container_class, $container_type, $item_class, $item_type)

    Функция возвращает 1 если возможно добавление элемента класса $item_class ('adgroup', 'banner' и т.п.) c типом $item_type в объект класса $container_class ('campaing', 'adgroup', 'banner' и т.п.) с типом $container_type, иначе 0.

=cut

sub is_eligible_container_item {
    my ($container_class, $container_type, $item_class, $item_type) = @_;

    die "container class not specified" unless defined $container_class;
    die "container type not specified" unless defined $container_type;
    die "item class not specified" unless defined $item_class;

    if (exists $OBJECT_RELATIONS{$container_class}) {
        my $container_types = $OBJECT_RELATIONS{$container_class};
        if (ref $container_types && exists $container_types->{$container_type}) {
            my $item_classes = $container_types->{$container_type};
            die "unknown item class $item_class" unless exists $ITEM_CLASSES{$container_class}{$item_class};

            if (ref $item_classes && exists $item_classes->{$item_class}) {
                my $item_types = $item_classes->{$item_class};

                if (ref $item_types) {
                    die 'item type not specified' unless defined $item_type; # если у элемента есть типы, но в вызове тип не задан - падаем с ошибкой

                    return 1 if exists $item_types->{$item_type} && $item_types->{$item_type} == 1;
                } elsif ($item_types == 1) { # разрешены любые типы элемента
                    return 1;
                }
            }
        } else { # задан неизвестный тип контейнера
            warn "unknown container type $container_type";
        }
    } else { # задан неизвестный класс контейнера
        die "unknown container class $container_class";
    }

    return 0;
}

1;
