package API::Preprocess;

# $Id: $

=head1

    Модуль для препроцессинга входных данных

=cut

use strict;
use warnings;

use List::MoreUtils qw(any none uniq);

use Settings;
use PrimitivesIds;
use RBACElementary;

use vars qw($VERSION @ISA @EXPORT);
require Exporter;
@ISA = qw(Exporter);
@EXPORT = qw(
    preprocess_logins
);

use utf8;

=head2 preprocess_logins

    Для списка логинов вычисляет соответствия:
        login2clientid
        clientid2chiefuid
        chiefuid2login
        login2uid
        uid2role
=cut

# TODO: прикрутить к ретаргетингу
sub preprocess_logins {
    my ($self, $logins, %O) = @_;
    my $result = {};
    return $result if ! scalar @{$logins || []};

    my $login2clientid = get_login2clientid(login => $logins);

    if ($O{login2uid} || $O{uid2role}) {
        $result->{login2uid} = get_login2uid(login => $logins);
        if ($O{uid2role}) {
            my @uniqed_uids = uniq grep {$_} values %{$result->{login2uid}};
            $result->{uid2role} = rbac_multi_who_is($self->{rbac}, \@uniqed_uids) if @uniqed_uids;
        }
    }

    my $clientid2logins;
    for my $login (@$logins) {
        next if not exists $login2clientid->{$login};
        push @{$clientid2logins->{$login2clientid->{$login}}}, $login;
    }

    if (scalar keys %$login2clientid && ($O{clientid2chiefuid} || $O{chiefuid2login})) {
        $result->{clientid2chiefuid} = rbac_get_chief_reps_of_clients([uniq values %$login2clientid]);
        if ($O{chiefuid2login}) {
            $result->{chiefuid2login} = get_uid2login(uid => [uniq values %{$result->{clientid2chiefuid}}]);
        }
    }
    $result->{login2clientid} = $login2clientid;
    $result->{clientid2logins} = $clientid2logins;

    return $result;
}

1;
