package API::Reports::FormatTsv;
use Direct::Modern;

=head1 NAME

API::Reports::FormatTsv

=head1 DESCRIPTION

Инструмент для формирования TSV-файла из данных, которые в нём должны быть.

=head1 SYNOPSIS

    my $data = [ [ 1, 2, 3 ], [ 4, 5, 6 ] ];
    for my $row (@$data) {
        print tsv_line($row);
    }

=cut

use parent 'Exporter';
our @EXPORT_OK = qw(tsv_line);

my $TSV_SEPARATOR = "\t";
my $TSV_EOL = "\n";
my $TSV_SEPARATOR_RE = qr/[$TSV_SEPARATOR$TSV_EOL\r]+/;

=head2 tsv_line

Получает arrayref с данными одной строки, возвращает строковое значение для строки в TSV-файле с этими данными.

=cut

sub tsv_line {
    my ($values) = @_;

    return join($TSV_SEPARATOR, map { s/$TSV_SEPARATOR_RE/ /gr } @$values).$TSV_EOL;
}

1;
