package API::Reports::InternalRequestRepresentation;
use Mouse;

use API::Reports::ReportTypeConstraints;

has 'need_to_request_report_from_provider' => ( is => 'ro', isa => 'Bool', required => 1 );

has 'lang' => ( is => 'ro', isa => 'Str', required => 1 );

has 'provider_request_params' => ( is => 'ro', isa => 'HashRef', required => 1 );

has 'displayed_field_names' => ( is => 'ro', isa => 'ArrayRef', required => 1 );

has 'field_names_in_provider_response' => ( is => 'ro', isa => 'ArrayRef', required => 1 );

has 'return_money_in_micros' => ( is => 'ro', isa => 'Bool', required => 1 );

has 'skip_report_header' => ( is => 'ro', isa => 'Bool', default => 0 );

has 'skip_column_header' => ( is => 'ro', isa => 'Bool', default => 0 );

has 'skip_report_summary' => ( is => 'ro', isa => 'Bool', default => 0 );

has 'response_format' => ( is => 'ro', isa => 'Str', required => 1 );

has 'report_name' => ( is => 'ro', isa => 'Str', required => 1 );

has 'report_type' => ( is => 'ro', isa => 'ReportTypes', required => 1 );

=head2 to_plain_struct

Превратить объект в формат, который можно "просто" сериализовать (например, в JSON) и положить в базу,
а потом с помощью from_plain_struct сделать из него исходный.

=cut

sub to_plain_struct {
    my ($self) = @_;

    my $result = {};
    for my $field ( $self->meta->get_attribute_list ) {
        $result->{$field} = $self->$field;
    }

    return $result;
}

=head2 from_plain_struct

Превратить данные из формата, в который их превращает to_plain_struct, обратно в объект.

=cut

sub from_plain_struct {
    my ( $class, $struct ) = @_;
    return $class->new(%$struct);
}

__PACKAGE__->meta->make_immutable;

1;
