package API::Reports::Result;
use Mouse;
use Mouse::Util::TypeConstraints;

=head1 NAME

API::Reports::Result

=head1 DESCRIPTION

Результат построения отчёта. В нём есть шапка отчёта (title и header) и содержимое отчёта.
Содержимое отчёта можно получить итератором (data_iterator).

Гарантий, что все данные отчёта хранятся в памяти и доступны немедленно, нет.
При запросе данных компонент может "лениво" сходить за ними по сети. Чтобы
избежать лишних запросов, рекомендуется вызывать на объекте data_iterator только один раз.

=cut

use Yandex::I18n;

use API::Reports::ReportTypeConstraints;
use API::Reports::ResultingDataIterator;

has 'title' => ( is => 'ro', isa => 'Str' );

has 'format' => ( is => 'ro', isa => 'Str' );

has 'header' => ( is => 'ro', isa => 'ArrayRef[Str]' );

has 'stat_source' => ( is => 'ro', isa => 'Str' );

has '_lang_guard' => ( is => 'ro', isa => 'Yandex::I18n::I18nGuard' );

has '_requested_report_fields' => ( is => 'ro', isa => 'ArrayRef[Str]' );

has '_need_conversion_to_micro_units' => ( is => 'ro', isa => 'Bool' );

has '_report_type' => ( is => 'ro', isa => 'ReportTypes' );

has '_date_aggregation_by' => ( is => 'ro', isa => enum([qw/none day week month quarter year/]) );

has '_uac_oids' => ( is => 'ro', isa => 'ArrayRef[Int]' );

has '_stat_iterator' => ( is => 'ro', isa => 'Maybe[Stat::CustomizedArray::Iterator]' );

has '_total_rows' => ( is => 'ro', isa => 'Maybe[Int]' );

has '_start_date' => ( is => 'ro', isa => 'Maybe[Str]' );

has '_end_date' => ( is => 'ro', isa => 'Maybe[Str]' );

=head2 data_iterator

API::Reports::ResultingDataIterator для строк отчёта. Текущая реализация на каждый вызов возвращает новый итератор.

=cut

sub data_iterator {
    my ($self) = @_;
    return API::Reports::ResultingDataIterator->new(
        stat_iterator => $self->_stat_iterator,
        requested_report_fields => $self->_requested_report_fields,
        need_conversion_to_micro_units => $self->_need_conversion_to_micro_units,
        report_type => $self->_report_type,
        date_aggregation_by => $self->_date_aggregation_by,
        uac_oids => $self->_uac_oids,
    );
}

__PACKAGE__->meta->strict_constructor(1);
__PACKAGE__->meta->make_immutable;

1;
