<?php

    include ('SOAP/Client.php');

    // URL сервра API к Яндекс.Директ
    $url = 'https://soap.direct.yandex.ru/api';

    // Пути к сертификатам
    $path   = "_PATH_TO_CERTS_DIR_";
    $cert   = "_NAME_CERT_FILE_";
    $key    = "_NAME_KEY_FILE_";
    $passwd = '_PASSWORD_FOR_KEY_FILE_';
    $certroot = "cacert.pem";

    // Настройки соединения
    $options['curl'] = array (
        CURLOPT_SSL_VERIFYPEER => 0,
        CURLOPT_TIMEOUT => 120,
        CURLOPT_HEADER => 1,
        CURLOPT_VERBOSE => 1,
        CURLOPT_SSLVERSION => 3,
        CURLOPT_RETURNTRANSFER => 1,
        CURLOPT_SSLCERTPASSWD => $passwd, 
        CURLOPT_SSLCERT => $path.$cert,
        CURLOPT_SSLKEY => $path.$key,
        CURLOPT_CAINFO => $path.$certroot,
        CURLOPT_CAPATH => $path,
    );

    $options['uri'] = 'API';
    $options['location'] = $url;

    class SOAPStruct {
        var $cid, $date_start, $date_end;

        function SOAPStruct($cid = 123456, $date_start = NULL, $date_end = NULL) {
            $this->cid  = $cid;
            $this->date_start   = $date_start;
            $this->date_end     = $date_end;
        }

        function &__to_soap($name = 'inputStruct', $header=false, $mustUnderstand=0, $actor='http://schemas.xmlsoap.org/soap/actor/next')
        {
            $inner[] =& new SOAP_Value('cid','int', $this->cid);
            $inner[] =& new SOAP_Value('startDate','string', $this->date_start);
            $inner[] =& new SOAP_Value('endDate','string', $this->date_end);
            return new SOAP_Value($name, '{https://soap.direct.yandex.ru/api}SOAPStruct', $inner);
        }
    }

    $soap = new SOAP_Client($options['location'], false, 'API', $options, 0);
    $soap->setDefaultNamespace('API');

    // Инициализируем объект класса
    $struct = new SOAPStruct();
    $struct->cid    = 123456;
    $struct->date_start = '2007-05-01';
    $struct->date_end   = '2007-07-01';

    // Деламем запрос к серверу
    $ret = $soap->call('CreateNewReport', $p = $struct->__to_soap(), $options);

    // Для отладки удобно использовать данный метод для просмотра результирующих XML, отправляемых и получаемых от сервера
    // $messages = $soap->getWire();

    // Выводим XML на экран
    // print_r(htmlentities($messages));

    // Выодим полученные данные от сервера
    echo 'Результат:<br /><i>';
    print_r($ret);
    echo '</i>';
?>