#!/usr/bin/perl

=head1 НАЗВАНИЕ

    Пример срипта

=head1 ОПИСАНИЕ

    Содержит функции для получения статистики по рекламными кампаниям в Яндекс.Директ

=head1 ПРИНЦИП РАБОТЫ

    1. Делает запрос на создание отчета по статистике кампании в Яндекс.Директ
    2. Ждет пока отчет будет готов.
    3. Получает отчет в XML формате.

=cut

use warnings;
use strict;
use SOAP::Lite;
use Crypt::SSLeay;
use LWP::Simple;

=head1 ПРОГРАММНАЯ ЧАСТЬ

=head2 Авторизация скрипта

    Авторизация осуществляется на основе сертификата, выданного Центром Сертификации Яндекс.Директ
    Для этого необходимо инициализировать следующие переменные окружения:

        HTTPS_CERT_FILE - абсолютный путь к пользовательскому сертификату, подписанному Центром Сертификации Яндекс.Директ,
        HTTPS_KEY_FILE - абсолютный путь к файлу с секретным ключом,
        HTTPS_CA_FILE - абсолютный путь к Директ CA файлу, которым подписан пользовательский сертификат,
        HTTPS_CA_DIR - абсолютный путь в каталогу с CA сертификатами.

=cut

$ENV{HTTPS_CERT_FILE} = 'certs/my_certificate.crt';
$ENV{HTTPS_KEY_FILE} = 'certs/my_privatekey.pem';
$ENV{HTTPS_CA_FILE} = 'certs/CAcert.pem';
$ENV{HTTPS_CA_DIR} = 'certs/';

# пример данных для запроса отчета
my $data_for_stat = {
        campaignID => 123456, # ваш номер кампании
        startDate => '2006-05-05',
        endDate => '2007-01-01',
        groupByDate => 'day', # week | month
        groupByColumns => ['clBanner','clGeo'], 
        compressReport => 0 # 1
};

if( my $reportID = call_method('CreateNewReport', $data_for_stat) ) {

    my $reportInfo = {};
    my $counter = 0;

    # ждем пока отчет будет создан
    while( $reportInfo->{statusReport} ne 'Done'
                && $counter++ < 20 ) {
        sleep(10);
        $reportInfo = call_method('GetReportURL', $reportID);
    }

    if( $reportInfo->{url} ) {
        # выводим отчет в STDOUT
        print get_report( $reportInfo->{url} );
    } elsif( $counter > 20 ) {
        die "Превышено допустимое количество обращений";
    } else {
        die "Неизвестная ошибка";
    }
}

=head2 call_method(method, data)

Функция вызывает указанный метод интерфейса программирования приложений Яндекс.Директ ( API )

=cut

sub call_method
{
    my $method_name = shift || return;
    my $method_data = shift;

    my $soap = SOAP::Lite
        -> uri('API')
        -> proxy('https://soap.direct.yandex.ru/api');

    my $request = $soap->call($method_name => $method_data);
    unless ( $request->fault ) {
        # в случае успешного выполнения запроса - возвращаем результат
        return $request->result;            
    } else {
        # если возникла ошибка - выводим сообщение в STDERR и завершаем выполнение программы
        die "Error code: ".$request->faultcode.", describe error: ".$request->faultstring;
    }

    return undef;
}

=head2 get_report(reportURL)

Фукнкция загружает указанный URL( полученный с помощью метода GetReportURL ) и возвращает содержимое страницы( готовый XML отчет )

=cut

sub get_report
{
    return get(shift);
}

=head1 ВЕРСИЯ

Версия 1.0 ( 4 мая 2007 )

=cut
