#!/usr/bin/perl

# Пример работы с API сервиса Яндекс.Директ
# на языке Perl с использованием SOAP::Lite
#
# Для запуска примера нужен пакет SOAP::Lite
#
#
#

use warnings;
use strict;

use SOAP::Lite;
use LWP::Simple;
use Crypt::SSLeay;

$ENV{HTTPS_CA_DIR} = '/path_to_certs/';               #   Директория где лежат файлы с сертификатами 
$ENV{HTTPS_CERT_FILE} = $ENV{HTTPS_CA_DIR} . 'cert.crt';    #   файл содержащий сертификат пользователя
$ENV{HTTPS_KEY_FILE}  = $ENV{HTTPS_CA_DIR} . 'private.key'; #   файл содержащий приватный ключ
$ENV{HTTPS_CA_FILE}   = $ENV{HTTPS_CA_DIR} . 'cacert.pem';  #   файл содержащий корневой сертифкат
    

my $new_campaign_login = 'client-login';
my $new_campaign_fio = 'ФИО';
my $new_campaign_email = 'user@domain';

##############################################################################################################################

# создание объекта для подключения к SOAP
my $client = SOAP::Lite->service('http://soap-new.direct.yandex.ru/api-1.0.wsdl');
$client->envprefix('namesp1');

# вывод содержимого SOAP запросов и ответов
#   $client->on_debug(sub {print join(">\n", split(">", join("", @_)));});

# обработка исключений
$client->on_fault(sub{my($soap, $res) = @_; die ref $res ? $res->faultstring : $soap->transport->status, "\n";});

# Пример параметров, необходимых для создания кампании
my $params = {
    'Login' => $new_campaign_login,
    'CampaignID' => 0,
    'Name' => 'API camp: PERL',
    'AutoOptimization' => 0,
    'Email' => $new_campaign_email,
    'FIO' => $new_campaign_fio,
    'MoneyWarningValue' => 20,
    'SendWarn' => 1,
    'TimeTarget' => {
        'Days' => [1, 2, 3, 4, 5, 6],
        'Hours' => [1, 2,3,4,5,6,7,8,9,10, 11, 12, 13, 15, 17, 22, 23],
    },
    'StartDate' => '2008-05-25',
    'SmsSendWarnMoneyOut' => 1,
    'SmsSendModerate'     => 1,
    'SmsSendWarnMoneyIn'  => 1,
    'SmsTimeHourFrom' => 1,
    'SmsTimeMinFrom' => 0,
    'SmsTimeHourTo' => 22,
    'SmsTimeMinTo' => 0,
};


# вызов soap метода CreateOrUpdateCampaign
my $request = $client->CreateOrUpdateCampaign($params);
my $newCompanyId = 0;
$newCompanyId = $request;            

if($newCompanyId){
    # Параметры создания баннера
    $params = [
        {
            'CampaignID' => $newCompanyId
            , 'BannerID' => 0
            , 'Title' => 'Заголовок объявления'
            , 'Text' => 'Текст объявления'
            , 'Href' => 'http://ya.ru/?123'
            , 'Geo' => '2,183,3,5'
            , 'GeoID' => 1
            , 'Phrases' => [
                {
                    'IsRubric' => 0
                    , 'Phrase' => 'Текст фразы'
                    , 'PhraseID' => 0
                    , 'AutoBroker' => 0
                    , 'Price' => 0.11
                    , 'AutobudgetPriority' => 'Meddium'

                },
                {
                    'IsRubric' => 0
                    , 'Phrase' => 'Текст еще одной фразы'
                    , 'PhraseID' => 0
                    , 'AutoBroker' => 1
                    , 'Price' => 0.11
                    , 'AutobudgetPriority' => 'Meddium'
                },
            ]

            # contact info
            , 'ContactInfo' => {
                  'Apart' => 2
                , 'Build' => 2
                , 'City' => 'Моcква'
                , 'CityCode' => 495
                , 'ContactEmail' => 'email@ya.ru'
                , 'ContactPerson' => 'контактное лицо'
                , 'Country' => 'Россия'
                , 'CountryCode' => '+7'
                , 'ExtraMessage' => 'подробнее о товаре/услуге'
                , 'House' => '2'
                , 'IMClient' => 'jabber'
                , 'IMLogin' => 'email@ya.ru'
                , 'CompanyName' => 'ФИО2'
                , 'Phone' => '23455'
                , 'PhoneExt' => '223'
                , 'Street' => 'улица'
                , 'WorkTime' =>'0;4;10;00;18;00;5;6;13;00;16;00'
            }
        }
    ];
    
    # Вызов метода CreateOrUpdateBanners
    $request = $client->CreateOrUpdateBanners($params);
    print "Create new banner: ";
    unless ($request->fault) {
        print $request->result;            
    } else {        
        print "Error code: ".$request->faultcode.", \nDescribe error: ".$request->faultstring;
    }
}





