<?php

#
# Пример работы с API сервиса Яндекс.Директ
# на языке PHP с использованием NuSOAP
#
# Для запуска примера нужен пакет NuSOAP
#


# Информация о клиенте
$new_campaign_login = 'client-login';
$new_campaign_fio = 'ФИО';
$new_campaign_email = 'user@domain';

$cert = '/home/path_to_cert_dir/cert.crt';        # файл содержащий сертификат пользователя
$private = '/home/path_to_cert_dir/private.key';     # файл содержащий приватный ключ
$cacert = '/home/path_to_cert_dir/cacert.pem';       # файл содержащий корневой сертифкат

####################################################################################################################################################################################

require_once('nusoap073/lib/nusoap.php');

$proxyhost = '';
$proxyport = '';
$proxyusername = '';
$proxypassword = '';

# создание объекта для подключения к SOAP
$wsdlurl = 'http://soap-new.direct.yandex.ru/api-1.0.wsdl';
$client = new nusoap_client($wsdlurl, 'wsdl', $proxyhost, $proxyport, $proxyusername, $proxypassword);
$client->authtype = 'certificate';
$client->decode_utf8 = 0;
$client->soap_defencoding  = 'UTF-8';
$client->certRequest['sslcertfile'] = $cert;
$client->certRequest['sslkeyfile']  = $private;
$client->certRequest['cainfofile']  = $cacert;

# Пример параметров, необходимых для создания кампании
$params = array(
    'Login' => $new_campaign_login,
    'CampaignID' => 0,
    'Name' => 'API camp: PHP',
    'AutoOptimization' => 0,
    'Email' => $new_campaign_email,
    'FIO' => $new_campaign_fio,
    'MoneyWarningValue' => 20,
    'SendWarn' => 1,
    'TimeTarget' => array(
        'Days' => array(1, 2, 3, 4, 5, 6),
        'Hours' => array(1, 2,3,4,5,6,7,8,9,10, 11, 12, 13, 15, 17, 22, 23),
    ),
    'StartDate' => '2008-05-25',
    'SmsSendWarnMoneyOut' => 1,
    'SmsSendModerate'     => 1,
    'SmsSendWarnMoneyIn'  => 1,
    'SmsTimeHourFrom' => 1,
    'SmsTimeMinFrom' => 0,
    'SmsTimeHourTo' => 22,
    'SmsTimeMinTo' => 0,
);

# вызов soap метода CreateOrUpdateCampaign
$result = $client->call("CreateOrUpdateCampaign", array('params' => $params));
print("Create new company: ");
if ($client->fault) {
    $newCompanyId = 0;
    print "SOAP Fault: ";
} else {
    $newCompanyId = $result;
}
print "$result\n";
if($newCompanyId){

    # Параметры создания баннера
    $params = array(
        array(
            'CampaignID' => $newCompanyId
            , 'BannerID' => 0
            , 'Title' => 'Заголовок объявления'
            , 'Text' => 'Текст объявления'
            , 'Href' => 'http://ya.ru/?123'
            , 'Geo' => '2,183,3,5'
            , 'GeoID' => 1
            , 'Phrases' => array(
                array(
                    'IsRubric' => 0
                    , 'Phrase' => 'Текст фразы'
                    , 'PhraseID' => 0
                    , 'AutoBroker' => 0
                    , 'Price' => 0.11
                    , 'AutobudgetPriority' => 'Meddium'

                ),
                array(
                    'IsRubric' => 0
                    , 'Phrase' => 'Текст еще одной фразы'
                    , 'PhraseID' => 0
                    , 'AutoBroker' => 1
                    , 'Price' => 0.11
                    , 'AutobudgetPriority' => 'Meddium'
                ),
            )

            # contact info
            , 'ContactInfo' => array(
                  'Apart' => 2
                , 'Build' => 2
                , 'City' => 'Моcква'
                , 'CityCode' => 495
                , 'ContactEmail' => 'email@ya.ru'
                , 'ContactPerson' => 'контактное лицо'
                , 'Country' => 'Россия'
                , 'CountryCode' => '+7'
                , 'ExtraMessage' => 'подробнее о товаре/услуге'
                , 'House' => '2'
                , 'IMClient' => 'jabber'
                , 'IMLogin' => 'email@ya.ru'
                , 'CompanyName' => 'ФИО2'
                , 'Phone' => '23455'
                , 'PhoneExt' => '223'
                , 'Street' => 'улица'
                , 'WorkTime' =>'0;4;10;00;18;00;5;6;13;00;16;00'
            )
        )
    );

    # Вызов метода CreateOrUpdateBanners
    $result = $client->call("CreateOrUpdateBanners", array("params" => $params));
    print("Create new banner: ");
    if ($client->fault) {
        print "SOAP Fault: " . $result;
    }
    print $result;
}
