#!/usr/bin/perl

use warnings;
use strict;
use SOAP::Lite;
use Crypt::SSLeay;

=head2 Авторизация скрипта

    Авторизация осуществляется на основе сертификата, выданного Центром Сертификации Яндекс.Директ
    Для этого необходимо инициализировать следующие переменные окружения:

        HTTPS_CERT_FILE - абсолютный путь к пользовательскому сертификату, подписанному Центром Сертификации Яндекс.Директ,
        HTTPS_KEY_FILE - абсолютный путь к файлу с секретным ключом,
        HTTPS_CA_FILE - абсолютный путь к Директ CA файлу, которым подписан пользовательский сертификат,
        HTTPS_CA_DIR - абсолютный путь в каталогу с CA сертификатами.

=cut

$ENV{HTTPS_CERT_FILE} = 'certs/my_certificate.crt';
$ENV{HTTPS_KEY_FILE} = 'certs/my_privatekey.pem';
$ENV{HTTPS_CA_FILE} = 'certs/CAcert.pem';
$ENV{HTTPS_CA_DIR} = 'certs/';

my $soap = SOAP::Lite
    -> uri('API')
    -> proxy('https://soap.direct.yandex.ru/api');

my $request = $soap -> PingAPI();

unless ( $request->fault ) {
    # в случае успешного выполнения запроса - возвращаем результат
    print "Result: ".$request->result."\n";
} else {
    # если возникла ошибка - выводим сообщение в STDERR и завершаем выполнение программы
    die "Error code: ".$request->faultcode.", describe error: ".$request->faultstring;
}
