#!/usr/bin/python
# -*- coding: UTF-8 -*-

#
# Пример работы с API сервиса Яндекс.Директ
# на языке Python с использованием SOAPpy
#
# Для запуска примера нужен модифицированный пакет SOAPpy
#



import sys

from datetime import date

import SOAPpy


CERT_FILE = '/path_to_certs/cert.crt'             # файл содержащий сертификат пользователя
PKEY_FILE = '/path_to_certs/private.key'          # файл содержащий приватный ключ
client_login = u'login-client'
client_email = u'user@login'
client_fio = u'ФИО'

################################################################################################################################################

# Создание объекта для подключения к SOAP сервису
url = 'https://soap-new.direct.yandex.ru/api-1.0.wsdl';
config = SOAPpy.Config
config.debug = 0                                        # 1 - для вывода запросов и ответов сервера 
config.SSL.key_file = PKEY_FILE     
config.SSL.cert_file = CERT_FILE
proxy = SOAPpy.WSDL.Proxy(url, config)

# Пример параметров, необходимых для создания кампании
params = {
            'Login' : client_login,
            'CampaignID' : 0,
            'Name' : u'API camp: PYTHON',
            'AutoOptimization' : 0,
            'Email' : client_email,
            'FIO' : client_fio,
            'MoneyWarningValue' : 20,
            'SendWarn' : 1,
            'TimeTarget' : {
                'Days' : [1, 2, 3, 4, 5, 6],
                'Hours' : [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 15, 17, 22, 23],
            },
            'StartDate' : date(2008, 05, 25),
            'SmsSendWarnMoneyOut' : 1,
            'SmsSendModerate'     : 1,
            'SmsSendWarnMoneyIn'  : 1,
            'SmsTimeHourFrom' : 1,
            'SmsTimeMinFrom' : 0,
            'SmsTimeHourTo' : 22,
            'SmsTimeMinTo' : 0,
        }
newCompanyId = 0

# вызов soap метода CreateOrUpdateCampaign
try:
    print "Create new company: "
    newCompanyId = proxy.CreateOrUpdateCampaign(params = params)
    print newCompanyId, "\n"
except Exception, e:
    print 'SOAP Fault: ', e

if newCompanyId: 
    # Параметры создания баннера
    params = [
    {
        'CampaignID': newCompanyId
        , 'BannerID': 0         
        , 'Title': u'Заголовок объявления'
        , 'Text': u'Текст объявления'
        , 'Href': 'http://ya.ru/?123'
        , 'Geo': '2,183,3,5'
        , 'GeoID': 1
        , 'Phrases': [
            {
                'IsRubric': 0
                , 'Phrase': u'Текст фразы'
                , 'PhraseID': 0
                , 'AutoBroker': 0
                , 'Price': 0.11
                , 'AutobudgetPriority': 'Meddium'
                
            },
            {
                'IsRubric': 0
                , 'Phrase': u'Текст еще одной фразы'
                , 'PhraseID': 0
                , 'AutoBroker': 1
                , 'Price': 0.11
                , 'AutobudgetPriority': 'Meddium'
            },            
        ]

        # contact info
        , 'ContactInfo': {
              'Apart': 2
            , 'Build': 2
            , 'City': u'Моcква'
            , 'CityCode': 495
            , 'ContactEmail': 'email@ya.ru'
            , 'ContactPerson': u'контактное лицо'
            , 'Country': u'Россия'
            , 'CountryCode': '+7'
            , 'ExtraMessage': u'подробнее о товаре/услуге'
            , 'House': '2'
            , 'IMClient': 'jabber'
            , 'IMLogin': 'email@ya.ru'
            , 'CompanyName': u'ФИО2'
            , 'Phone': '23455'
            , 'PhoneExt': '223'
            , 'Street': u'улица'
            , 'WorkTime':'0;4;10;00;18;00;5;6;13;00;16;00'
        }
    }] 
    
    # Вызов метода CreateOrUpdateBanners
    try:
        print "Create new banners: \n"
        newBannarIds = proxy.CreateOrUpdateBanners(params = params)
        print newBannarIds, "\n"
    except Exception, e:
        print 'SOAP Fault: ', e
    

