package API::Serializer;
## no critic (TestingAndDebugging::RequireUseWarnings)

=pod

    $Id$
  
=head1 NAME

    API::Serializer

=head1 DESCRIPTION

    Модуль для принудительной типизации данных, возвращаемых из API

=cut

use strict;

use SOAP::Lite;

use Yandex::SOAP::UTF8Serializer;
use API::Soapize;

SOAP::Lite->soapversion('1.2');

use base 'Yandex::SOAP::UTF8Serializer::Masked';

=head2 new

=cut
sub new {
    my $class = shift;

    my $self = $class->SUPER::new( @_ );
    $self->disable_base64();

    bless $self;
}


=head2 envelope

=cut
sub envelope {

    my $self = shift;

    my ($type, $method, $data, @other_data) = @_;

    if ($type eq 'response') {
        my $api_version = shift @other_data;

        # SOAP::Lite добавляет к названию вызванного метода суффикс Response
        my ($method_name) = $method =~ m/^(.*?)Response$/;
        $data = set_soap_types($method_name, $data, $api_version);
    }# elsif ($type eq 'fault') {
     # now is empty
     # }

    # если нужно что-то проверить, можно подставить сюда нужный soap-xml
    my $enveloped_data = $self->SUPER::envelope($type, $method, $data, @other_data);
    return $enveloped_data;
}

1;
