package API::Settings;

# $Id$

use strict;
use warnings;

use utf8;

# Серкретная фраза для API
# получено как head -c 100 /dev/random|md5sum
our $API_SECRET_PHRASE = '9211fd282498c8709872d732f0c3abf5';

# постоянные токены - способ авторизации внутренних роботов (БК, Бродмач, Геоконтекст)
# ключ для HMAC
our $API_PERSISTENT_TOKENS_KEY = 'be946fb0939f7e0ea40f84eb74190521056994f104d09ce211f08c344c283bd7';
# хэши токенов и дополнительная информация:
# login - логин робота
# allow_to - список имён хостов или регекспов на имена хостов (ACL)
# токены можно генерировать так: protected/maintenance/api_generate_persistent_token.pl
our $API_PERSISTENT_TOKENS ||= {};
$API_PERSISTENT_TOKENS->{'fb9619fc2d4cca96ab005d575afcad7636c285385c0308188a47b9ab5d525a25'} = {
    # робот БродМатча
    login => 'yndx-robot-bm-direct-api',
    application_id => 'broad_match_persistent',
    allow_to => [
        "networks:catalogia.txt",
        ],
};

$API_PERSISTENT_TOKENS->{'c9e71de602c78c15db276e7131adc2b20d1fa36a5467c2a25a2fb852f547ed31'} = {
    # робот сервиса crypta
    login => 'yndx-aalogachev',
    application_id => 'crypta_persistent',
    allow_to => [
        "networks:internal.txt",
        ],
};

$API_PERSISTENT_TOKENS->{'b0d93b5574991ee33c36dbe4187e675af0818bc82f262ff7ddc09ed73945fb25'} = {
    # суперсмотрящий для CustomSolutions
    login => 'yndx-zomb-brownie-cs',
    application_id => 'custom_solutions_persistent',
    allow_to => [
        'networks:custom_solutions.txt',
    ],
};

$API_PERSISTENT_TOKENS->{'c53006082d6221910b4a782a09a53e371deb3c14623f1f8c81b6d4f95428a32f'} = {
    # аудит БК DIRECT-56714
    login => 'yndx-yabs-direct-audit',
    application_id => 'yabs_direct_audit_persistent',
    allow_to => [
        'networks:internal.txt',
    ],
};

$API_PERSISTENT_TOKENS->{'09256618bc8101ebbb077175bd7f48f93501cda7bd5fbec89505c2eb14e98c2b'} = {
    login => 'yndx-robot-crmdev',
    application_id => 'yandex-crm',
    allow_to => [
        'networks:crmwebsrv.txt',
    ],
};

# https://st.yandex-team.ru/DIRECT-63342
# https://wiki.yandex-team.ru/users/timlukin/adstencil/
$API_PERSISTENT_TOKENS->{'5ba884ef0a6bf86b16ff7b790aaa52e24313d70cab29f48688612d44be85296a'} = {
    login => 'sivkov-api',
    application_id => 'ad_stensil',
    allow_to => [
        'networks:bsdevnets.txt',
    ],
};

# https://st.yandex-team.ru/DIRECT-63342
# https://wiki.yandex-team.ru/users/timlukin/adstencil/
$API_PERSISTENT_TOKENS->{'b84094cb5d4794cd2f1687d5d39f374dd6949d65cf2226045d47870a8d71d5b2'} = {
    login => 'turkish-free-api ',
    application_id => 'ad_stensil',
    allow_to => [
        'networks:bsdevnets.txt',
    ],
};

# https://st.yandex-team.ru/DIRECT-65047
$API_PERSISTENT_TOKENS->{'b98188ea25eedc00a20fe8dd15a88f17b78e81f1f1e78c968f518fd07d9a3bc0'} = {
    login => 'yndx-robot-pafnuty',
    application_id => 'get_direct_data_for_bk',
    allow_to => [
        'networks:bsdevnets.txt',
    ],
};

# https://st.yandex-team.ru/DIRECT-65047
$API_PERSISTENT_TOKENS->{'4c7a5f6809b0ef1d8de9c9bef08bfb5f6212aeab93d588ae6da7aed4aa0a6ddc'} = {
    login => 'yndx-robot-pafnuty',
    application_id => 'get_direct_data_for_bk',
    allow_to => [
        'networks:bsnets.txt',
    ],
};

# https://st.yandex-team.ru/DIRECT-92737
$API_PERSISTENT_TOKENS->{'d07b80993d3a0bbffb925198a2dbb95dd94e325f991b6c5b6f957d620f65bace'} = {
    login => 'yndx-robot-autobudget',
    application_id => 'autobudget_audit_persistent',
    allow_to => [
        'networks:internal.txt',
    ],
};

# https://st.yandex-team.ru/DIRECT-96852
$API_PERSISTENT_TOKENS->{'3a221e901edc2d0ba3fc9952db322848ba3700fcf55d9a14d8ac9d92da4a0e58'} = {
    login => 'yndx-robot-tycoon-direct',
    application_id => 'tycoon_persistent',
    allow_to => [
        'networks:internal.txt',
    ],
};

# https://st.yandex-team.ru/DIRECT-99272
$API_PERSISTENT_TOKENS->{'614e6afb84e513257e5d13cb10079952286b6882b5bf21df481b2150db24b130'} = {
    login => 'yndx-robot-yacaredcat',
    application_id => 'yacaredcat_persistent',
    allow_to => [
        'networks:internal.txt',
    ],
};

# https://st.yandex-team.ru/DIRECT-111574
$API_PERSISTENT_TOKENS->{'2029906fa61fc825872488d12b04f071623884cea655e677080d43f81ac11a8f'} = {
    login => 'yndx-services2direct',
    application_id => 'services_persistent',
    allow_to => [
        'networks:internal.txt',
    ],
};

# https://st.yandex-team.ru/DIRECT-148889
$API_PERSISTENT_TOKENS->{'07407fb277139eef1b8cc40424a2920d2b75e5283136f4b5a5a7a7f5db560a02'} = {
    login => 'yndx-robot-supskills',
    application_id => 'chatbot_persistent',
    allow_to => [
        'networks:internal.txt',
    ],
};

# максимальное значение operation_num для финансовых операций API
our $API_MAX_FIN_OPERATION_NUM = 9223372036854775807;

# максимальное кол-во попыток создать отчет forecast или wordstat
our $MAX_PROCESSING_TIMES_REPORTS = 5;

# максимальное кол-во попыток создать отчет stat
our $MAX_PROCESSING_TIMES_STAT_REPORTS = 5;

# multicurrencies: параметры, которые уже включают НДС # неправда и не используется
our %ATTRIBUTE_INCLUDE_NDS = (
    'Sum' => 1,
    'Rest' => 1,
    'SumAvailableForTransfer' => 0,
);

our $GET_WORDSTAT_SYNC_LIMIT_KEY = 'GetWordstatSync__by_clientid';

# Методы, на которые можно установить ограничения по вызовам через веб-интерфейс
our @LIMITABLE_METHODS = sort(qw/CreateNewReport
                            CreateNewSubclient GetSummaryStat__daily GetBannersStat
                            GetKeywordsSuggestion CreateInvoice PayCampaigns TransferMoney GetCreditLimits FinOperations__daily AccountManagement__transfer AccountManagement__update other_methods sleep_min_time sleep_max_time sleep_start_time sleep_end_time sleep_probability/, $GET_WORDSTAT_SYNC_LIMIT_KEY);

# Максимальное число отчетов в API на пользователя
our $MAX_NUM_REPORTS ||= 5;

#Диапазон приоритетов которые попадают в один класс. Например, 0-24 — 1-й класс приоритета, 25-49 — 2-й
our $WORDSTAT_PRIORITY_STEP = 30;

# Дефолтное значение приоритета для запросов пользователей которым приоритет не выставлен
our $WORDSTAT_DEFAULT_PRIORITY = 50;

our $NEED_CHECK_REGISTRATION_DATE ||= '2014-11-10 00:00:00';

# Клиентские приложения с доступом к CreateNewSearchQueryReport DIRECT-48538
our %SEARCH_QUERY_ALLOWED_APPLICATIONS = map { $_ => 1 } (
    '9631c0beaa904903a59eee2ca1b4b666', # Ламода "Dmitriy Abramov" <dmitriy.abramov@lamoda.ru>
    'b78244af2e474c91868acf3bc1b4fb00', # Островок dmitry.nikonenko@ostrovok.ru OstrovokArt02
    '6eac58f2a3aa4f139ed2d9ec7746f50b', # 220Вольт: fateev@220-volt.ru app_id
    '7fb8aaa9011d4cb2a914f2a769edb112', # Агентство ArrowMedia (samoylov001) E-mail: Роман Бондаренко bondarenko.roman@bdbd.ru
    '4bf32d1fc47f4c2d810b3f8f92f5e410', # Блондинка (Blondinka4ever) e-mail AShvets@mymary.ru Швец Александр
    '96b741762b564dfbaf28f994366b3c42', # I-Media (i-media) e-mail специалиста - elena.firsova@origami-system.ru
    '07a766095dbe4948a965ecb2fead0f2b', # Игорь Карабаджак (ikarabadjak@gmail.com)" <ikarabadjak@gmail.com>, "Юлдашев Ильнур" <i.yuldashev@registratura.ru>
    '51da5caf43a84299869e3790a376184f', # Booking
);

# Пользователи со специальными правами/ограничениями. Указывать в качестве ключа - ClientID
our %SPEC_LIMITED_API_USERS = (

# клиенты с is_begun продублированы в JAVA
# https://a.yandex-team.ru/arc/trunk/arcadia/direct/libs-internal/bstransport/src/main/java/ru/yandex/direct/bsexport/query/order/OrderDataFactory.java#L35
    1618235 => { # 'begun-test-agency' - временное тестовое агентство/в будущем удалить
        'is_begun' => 1,
        'create_client_no_password' => 1,
        'auction_no_prices' => 1,
        'forecast_disallow' => 1,
        'wordstat_disallow' => 1,
        'keywords_suggestion_disallow' => 1,
        'method_special_stat_allow' => 1,
        'api_special_tech_limit' => 100_000,
    },
    1647047 => { # begun-2011 - постоянный логин агентства
        'is_begun' => 1, # ставит OrderType = 8 в БК
        'create_client_no_password' => 1,
        'auction_no_prices' => 1,
        'keywords_suggestion_disallow' => 1,
        'method_special_stat_allow' => 1,
        'api_special_tech_limit' => 100_000,
#        'web_interface_disallow' => 1,
        LIMITS => {
            CreateNewSubclient => 1000,
        }
    },
    907781 => { # 'at-direct-ag-full' - тестовое агентство отдела тестирования Директа
#         'create_client_no_password' => 1,
#         'auction_no_prices' => 1,
#         'forecast_disallow' => 1,
#         'wordstat_disallow' => 1,
#         'keywords_suggestion_disallow' => 1,
        'method_special_stat_allow' => 1,
#        'web_interface_disallow' => 1,
        'search_query_report_allow' => 1,
        LIMITS => {
            CreateNewSubclient => 1000,
        },
#        'api_special_simultaneously_conn_limit' => 2,
#        'api_special_tech_limit' => 100,
    },
    7586148 => { # lamodaru-semtm DIRECT-45129
        'api_special_auctions_limit' => 2_000_000_000
    },
    2027492 => { # discontmobile DIRECT-46441
        'api_special_auctions_limit' => 3_908_160
    },
    551730 => { # businessair DIRECT-46441
        'api_special_auctions_limit' => 10_226_529
    },
    2842508 => { # pricebegunferra3 DIRECT-46441
        'api_special_auctions_limit' => 487_733_158
    },
    405679 => { # mdgg DIRECT-46441
        'api_special_auctions_limit' => 7_016_103
    },
    7656860 => { # price-ae DIRECT-48458
        'api_special_auctions_limit' => 487_733_158
    },
    7710199 => { # price2-ae DIRECT-49265
        'api_special_auctions_limit' => 487_733_158
    },
    7121127 => { # myastia3 DIRECT-46441
        'api_special_auctions_limit' => 1_077_399
    },
    7315108 => { # priceru-alytics DIRECT-46441
        'api_special_auctions_limit' => 8_372_808
    },
    8566548 => { # workgazelkin DIRECT-52179
        'api_special_auctions_limit' => 600_000_000
    },
    8939442 => { # gazelkinwork DIRECT-52444
        'api_special_auctions_limit' => 600_000_000
    },
    9380503 => { # mirndvspb DIRECT-54551
        'api_special_auctions_limit' => 260_000_000
    },
    10471190 => { # hoff-mebel DIRECT-56605
        'api_special_auctions_limit' => 1_000_000_000
    },
    7570191 => { # at-direct-api-limit-aucts - тестовый клиент для тестирования ограничения на количество торгов
        'api_special_auctions_limit' => 1,
    },
    4644194 => { # 'booking-mcc'
        'search_query_report_allow' => 1,
    },
    5632164 => { # booking-villas-mcc
        'search_query_report_allow' => 1,
    },
    5234006 => { # booking-content
        'search_query_report_allow' => 1,
    },
    6874850 => { # 'tripadvisor-mcc'
        'search_query_report_allow' => 1,
    },
    1764807 => { # at-direct-ag-rank147 - тестовое агентство отдела тестирования
        'method_special_stat_allow' => 1,
        'create_client_no_password' => 1,
        'auction_no_prices' => 1,
        'forecast_disallow' => 1,
        'wordstat_disallow' => 1,
        'keywords_suggestion_disallow' => 1,
        'web_interface_disallow' => 1,
    },
    426452 => { # 'mirage-agency4'
#         'create_client_no_password' => 1,
#         'auction_no_prices' => 1,
#         'forecast_disallow' => 1,
#         'wordstat_disallow' => 1,
#         'keywords_suggestion_disallow' => 1,
        'method_special_stat_allow' => 1,
#        'web_interface_disallow' => 1,
#        LIMITS => {
#            CreateNewSubclient => 3,
#        }
#        'api_special_simultaneously_conn_limit' => 1,
    },
    5131 => { # icontext / ic-efrontier (Adobe) / ...
        'api_special_tech_limit' => 200_000,
    }
);

our $COMMANDER_APP_ID = "c135345132e9449dab6416f3cc34ffab"; # Директ.Коммандер (на node.js)
our $DC2_APP_ID = "c906d379328e4541a6d06e4894f2a03b"; # Директ.Коммандер
our $YNDX_SERVICES_APP_ID = "866b39c759de4008b127b4830705a81f"; # приложение сервиса Я.Услуги
our $YNDX_SERVICES_2_APP_ID = "3f807fad971b42628d53cd9f2e8e12a1"; # приложение сервиса Я.Услуги (Заполнение кампаний)
our $MOBILE_APP_IOS_OLD_APP_ID = "389dfb36ef1f4a16a2cdb47bc4510c7f"; # Мобильное приложение (IOS) - OLD
our $MOBILE_APP_IOS_APP_ID = "a4286bedd73840fb966a41277ffcbf40"; # Мобильное приложение (IOS)
our $MOBILE_APP_ANDROID_APP_ID = "74a699cdfe004d6ca576cfe4a8bfd79a"; # Мобильное приложение (Android)
our $HMEPAS_APP_ID = "c7078c35f1a549f18dc70f9371739f15"; # hmepas
our $AUTO_TESTS_APP_ID = "c4c65be43049495099bd13baafddde6b"; # автотесты
our $GEOPRODUCT_APP_ID //= "52fdbaf17bc947f3b5d3e06f00a9edab"; # Приложение Геопродукта
our $K50_1_APP_ID = "f71b01fc1d3747b9a10628a8671383f1"; # Приложение К50 №1
our $K50_2_APP_ID = "7c65e69d7c444d208f4039652cf2e361"; # Приложение К50 №2
our $EDA_APP_ID = "cfe379f646f3446ea1e6bc43e1385e3f"; # приложение Яндекс.Еды
our $ZEN_PROMO_ID = "0805843566fd423b884acafd522ecf13"; # Дзен Промо
our $ZEN_APP_ID = "949a214bfe2f4d51bece119fae54c7e0"; # Дзен Поддержка авторов

our $APP_ID_TO_CAMPAIGN_SOURCE = {
    $YNDX_SERVICES_APP_ID => 'uslugi',
    $GEOPRODUCT_APP_ID => 'geo',
    $EDA_APP_ID => 'eda',
    $COMMANDER_APP_ID => 'dc',
};

our $REARRANGE_KEYWORDS_ALLOW_APPS = [
    $COMMANDER_APP_ID,
    # Кастом солюшенс
    '80178cbcecf74dc18011681e5baa2822',
    'eb3bdf92608e4cfcb35bc66e6737f6d7',
    'a696e6e5f77e496981061f6f55a461eb',
    '1fbe8b1392304958b8440bb8f78402f0',
    '1b8dac53e0f64875912f9dc3e1600688',
    # букинг
    '51da5caf43a84299869e3790a376184f',
    # тестеры
    'ae99016820074f809e5c268e564bebad',
];


# application_id специальных приложений API
our $SPECIAL_API_APPS = {
    $DC2_APP_ID => {
        name => 'Директ.Коммандер',
    },
    $COMMANDER_APP_ID => {
        name => 'Директ.Коммандер (на node.js)',
    },
    $MOBILE_APP_IOS_OLD_APP_ID =>  {
        name => 'Мобильное приложение (iPhone)',
    },
    $MOBILE_APP_ANDROID_APP_ID => {
        name => 'Мобильное приложение (Android)',
    },
};

# Список ТОП-клиентов, для которых используем специальные мониторинги
#   выбраны по условию - скидка более 12% (для клиентов), либо расход в месяц более 100_000 у.е (для агентств)
our @TOP_CLIENTS_CLIENTID = (
    4573361		# trivago-com-mcc (agency)
    , 44418		# mos-mebel (client)
    , 13537		# Author4 (agency)
    , 817480		# otpbank-mg (client)
    , 1968037		# hoff-2012 (client)
    , 2982432		# freshm-a (agency)
    , 2752427		# unikma-reg (client)
    , 398541		# helloworld10011 (agency)
    , 1310503		# uplab-webstudio (agency)
    , 533241		# directline-market (agency)
    , 827152		# mazal-ra (agency)
    , 1094842		# oridisru (agency)
    , 413183		# mstcompany (agency)
    , 2212231		# webstellar-ru (agency)
    , 406279		# irkvins-tanya (agency)
    , 511128		# ooo-ivanochek (agency)
    , 1101599		# minsktorg (agency)
    , 554924		# armenbabayants (agency)
    , 1223799		# yevart-sergey (agency)
    , 1363862		# mediasheva1 (agency)
    , 1467960		# advshock (agency)
    , 418995		# studiobiplane (agency)
    , 887714		# t-hilchencko (agency)
    , 435416		# yanru-acr (agency)
    , 517579		# begingroup (agency)
    , 862606		# ya-webmech (agency)
    , 3432174		# performics-hp (agency)
    , 1864521		# enter-direct (client)
    , 1123134		# ddk-agency (agency)
    , 2940034		# tnxcontext2 (agency)
    , 478337		# zakaeva1456454zk (agency)
    , 807659		# apriorihuman (agency)
    , 1559058		# umi-ru (agency)
    , 1300733		# pavlik-ri (agency)
    , 3817655		# lamodasearch (client)
    , 457575		# msfera (agency)
    , 513006		# informbox-predstavitel-1 (agency)
    , 1520926		# K-NS-Trust (client)
    , 10557		# vipro-ru (agency)
    , 2921382		# marilynvivaki (agency)
    , 4644194		# booking-mcc (agency)
    , 1950801		# domusfinance2012 (client)
    , 5233971		# booking-content-mcc (agency)
    , 1332316		# Blondinkaneverdie (agency)
    , 386140		# rain-media (agency)
    , 404158		# onetouch-studio (agency)
    , 1643103		# webium-ua (agency)
    , 420430		# e-pchelincev (client)
    , 1929840		# essence-digital-api (agency)
    , 322057		# tokkipro (agency)
    , 1080701		# mks-alexandra (agency)
    , 1553144		# lamodasem (client)
    , 3264580		# Tripadvisor-Ukraine (client)
    , 816188		# mediahead (agency)
    , 411616		# prostor-200 (agency)
    , 2989751		# hotels-marin-turkey (client)
    , 1412437		# azhrtfm (agency)
    , 470581		# damir-direct (agency)
    , 461512		# Hurracomgmbh (agency)
    , 816212		# a-kitaewsckaya (agency)
    , 490106		# etodesign (agency)
    , 45978		# forexclub2005-api (client)
    , 2021848		# check-i (agency)
    , 467404		# domgroup (agency)
    , 997360		# arealsoft (agency)
    , 1283847		# marilyn-b4e (agency)
    , 446565		# oooivi (agency)
    , 2882545		# forward-uk (agency)
    , 540034		# seo-complex (agency)
    , 3005264		# fr-havasmedia-com (agency)
    , 1117524		# luk-direct (agency)
    , 1160097		# kupislova-ru (agency)
    , 1592267		# go-pxl (agency)
    , 417938		# mgkom (agency)
    , 1045572		# promogeneral (agency)
    , 346816		# techport (client)
    , 484424		# nbma2 (agency)
    , 3169630		# askona-ru2013 (client)
    , 366188		# promo-ru (agency)
    , 1051159		# utlabyd1 (agency)
    , 2103532		# michaelagentstvo (agency)
    , 461031		# hlebnikov-kinetica (agency)
    , 5702621		# polimentor-new (client)
    , 882154		# nechepurenko-medianation (agency)
    , 428689		# qseo (agency)
    , 1368332		# movenimax (agency)
    , 350201		# mirreklamy2005 (agency)
    , 1288522		# wikimartmain (client)
    , 394609		# cetis (agency)
    , 1132874		# vs-gm-iprospect (client)
    , 383105		# Support-KO-8 (agency)
    , 2981703		# dima-vosstanovlenie (agency)
    , 5131		# ConceptLine2010 (agency)
    , 371525		# webcapital (agency)
    , 496309		# e-ivanova-optimism (agency)
    , 1867183		# mediapronet (agency)
    , 1773170		# seorabbit (client)
    , 815024		# miracle-blaze (agency)
    , 1490120		# krystyna-johnson (client)
    , 1784648		# k50project (agency)
    , 1007670		# etolegko-contekst (agency)
    , 2264768		# buberru (agency)
    , 435058		# morizostudio (agency)
    , 3595119		# lamodaUA (client)
    , 1787843		# adscore (agency)
    , 1845		# realweb-latvia (agency)
    , 1437694		# sydi-ru (agency)
    , 524008		# ra-alinter (agency)
    , 2027966		# unishop2012 (agency)
    , 423910		# impulses2006 (agency)
    , 852253		# ventadirect (agency)
    , 991438		# enterneddirect (agency)
    , 1659605		# imedia-hotels (client)
    , 402110		# Ozon1112006 (client)
    , 942204		# allen-media (agency)
    , 1984976		# advredil (agency)
    , 1404335		# mecglobal-com (agency)
    , 1740565		# a1-reklama-ru (agency)
    , 2226577		# mosgorseo (agency)
    , 456838		# benefitman (agency)
    , 1309407		# profiivanovo (agency)
    , 503411		# promodo-ua (agency)
    , 2123515		# prof-advert (agency)
    , 385971		# AgentsRBS (agency)
    , 498533		# UPRAVLENIE-SVET (agency)
    , 550959		# xcapead (agency)
    , 2054492		# kontext1000clicks (agency)
    , 2206919		# adlens-mvideo (client)
    , 1041590		# myataspb (agency)
    , 48892		# adlabsdirect (agency)
    , 1617478		# mskdextra (agency)
    , 2302975		# nashstil1 (agency)
    , 935847		# alicedir (agency)
    , 1705224		# magic-of-words (agency)
    , 1098041		# willconsult (agency)
    , 2163077		# dgagency (agency)
    , 1728111		# spsrvru (agency)
    , 1559211		# tnxcontext (agency)
    , 917794		# svyaznoy-context (client)
    , 1373919		# stickguest (agency)
    , 1737170		# adidas-marin (client)
    , 1529452		# textmedia-main (agency)
    , 995850		# mediavladimir (agency)
    , 370879		# Ashmanov1919 (agency)
    , 809930		# ru-indep (client)
    , 985814		# golden-studio (agency)
    , 948317		# nissan-arch2 (client)
    , 1911806		# hotels-marin2 (client)
    , 5943554		# wikimartmgcom (client)
    , 1525656		# dyson-mshare (agency)
    , 448116		# kenguru-ra (agency)
    , 495612		# ya-smartmedia (agency)
    , 413042		# yurkov-denis1 (agency)
    , 372455		# aw-smatveeva (agency)
    , 5444523		# rd-avtomir-skoda (client)
    , 2220918		# Adlime-company (agency)
    , 1621799		# admitadGmbH (agency)
    , 484901		# minisol-agent (agency)
    , 531465		# marketingsol (agency)
    , 386153		# indicoru (agency)
    , 1188037		# pdgru (agency)
    , 917826		# renault-sem (client)
    , 1518613		# Tripadvisor-ad (client)
    , 425261		# intelsib (agency)
    , 5632164		# booking-villas-mcc (agency)
    , 4240952		# ozon-knigki (client)
    , 523581		# direct-reklama (agency)
    , 350487		# arrow-cpa (agency)
    , 3245		# agava-direct (agency)
    , 1855390		# rkamargin (agency)
    , 502269		# nadavi-advert2 (agency)
    , 2989740		# hotels-marin-prop (client)
    , 364688		# umistudio (agency)
    , 1535832		# y-jeleznyakova (agency)
    , 530828		# oleg-seenta (agency)
    , 433975		# nectarin-pool11 (agency)
    , 3310625		# ic-kukhnya (client)
    , 955260		# fertmedia (agency)
    , 527278		# fertdesign (agency)
    , 372142		# pr-pool (agency)
    , 1638416		# rek-broker (agency)
    , 1103959		# sky-adv (client)
    , 475996		# seodream2011 (agency)
    , 1233807		# stanislav-webexpert (agency)
    , 412576		# vdundik (agency)
    , 2124001		# rekmala-megagroup-ru (agency)
    , 3420611		# vw-indep (client)
    , 1421019		# itfarm (agency)
    , 844405		# denero2010 (agency)
    , 1041642		# Adventum2009 (agency)
    , 371323		# uraldextra (agency)
    , 2459717		# cubeline-k50 (agency)
    , 5473989		# shop-beeline (client)
    , 1909056		# hurracomru (agency)
    , 558608		# artem-plca (agency)
    , 506861		# saken-netpeak (agency)
    , 1083061		# vizer-host (agency)
    , 460717		# dotalfa3 (agency)
    , 1198771		# BlueSummit (agency)
    , 401186		# soluspro (agency)
    , 50537		# i-media (agency)
    , 498905		# howard-agent (agency)
);

# настройки ограничений на количество торгов
our $AUCTIONS_LIMIT_PARAMS ||= {
    # минимальный дневной лимит для любого клиента
    min_auctions_limit => 100_000,
    # количество торгов на каждый потраченный рубль за день
    auctions_per_rub => 3000,

    # количество интервалов, учитывающихся при ограничении
    interval_num => 24,
    # продолжительность одного интервала в секундах
    interval_size => 3600,

    # минимальное время, на которое задерживаем ответ
    min_sleep => 1,
    # максимальное время, на которое задерживаем ответ
    max_sleep => 3,
};

=head2 UNITS_BY_SPENT

    зависимость количества дневного лимита баллов в API5 от суммы потраченных
    денег за 28 дней

    В https://st.yandex-team.ru/DIRECT-39913 расчет сделан для среднемесячных
    трат в рублях. Скрипт основывается на данных за предыдущие активные 28
    дней - это почти месяц, поэтому таблица перевода потраченного в дневной
    лимит взята из вышеприведенного тикета без изменений.

    Баллы задаются на верхнюю границу диапазона.
    Т.е. для при
    { threshold => M1, units => U1 },
    { threshold => M2, units => U2 },
    { threshold => M3, units => U3 },
    { threshold => M4, units => U4 },

    Если открутка клиента MC лежит в диапазоне от M2 до M3, то он получит U3 баллов
    Если MC меньше M1, то клиент получает U1 баллов

    MС больше M4 клиент получает U4 баллов, соответственно M4 задан для красоты и может быть любым числом больше M3

=cut

our $UNITS_BY_SPENT //= [
    {threshold => 0,                units => 160_000},
    {threshold => 1_000,            units => 100_000},
    {threshold => 10_000,           units => 120_000},
    {threshold => 30_000,           units => 168_000},
    {threshold => 50_000,           units => 240_000},
    {threshold => 100_000,          units => 996_000},
    {threshold => 200_000,          units => 1_100_000},
    {threshold => 500_000,          units => 1_947_500},
    {threshold => 1_000_000,        units => 2_640_000},
    {threshold => 3_000_000,        units => 3_310_000},
    {threshold => 5_000_000,        units => 6_750_000},
    {threshold => 8_000_000,        units => 8_645_000},
    {threshold => 10_000_000,       units => 12_147_500},
    {threshold => 15_000_000,       units => 18_202_500},
    {threshold => 20_000_000,       units => 22_200_000},
    {threshold => 50_000_000,       units => 28_000_500},
    {threshold => 100_000_000,      units => 32_000_000},
    {threshold => 150_000_000,      units => 36_640_000},
    {threshold => 300_000_000,      units => 39_400_000},
    {threshold => 100_000_000_000,  units => 45_900_000, last => 1},
];

our $APPLICATION_GROUPS_COUNT //= 6; # количество групп приложений, которым выдается ошибка для устаревших методов
our $DEPRECATED_ERROR_SHOW_INTERVAL_PROPERTY //= 'api_deprecated_error_show_interval'; # имя свойства, в котором храниться длительность интервала показа ошибки для устаревших методов
our $DEPRECATED_ERROR_SHOW_INTERVAL_CACHE_TTL //= 300; # время в секундах, на которое кэшируется значение интервала, полученное из БД
our $DEPRECATED_ERROR_SHOW_ROUNDS_COUNT_PROPERTY //= 'api_deprecated_error_show_rounds_count'; # имя свойства, в котором храниться количество показов ошибки для устаревших методов в течении суток
our $DEPRECATED_ERROR_SHOW_ROUNDS_COUNT_CACHE_TTL //= 300;
our $DEPRECATED_ERROR_SHOW_ROUNDS_COUNT_DEFAULT //= 6; # значение по умолчанию, количества показов ошибки в течении суток

our $API_REPORTS_RATE_LIMIT_INTERVAL_SEC //= 10; # интервал в секундах, на который задаем ограничение на количество запросов
our $API_REPORTS_RATE_LIMIT_MAX_REQUESTS //= 20; # максимальное количество запросов за заданный в $API_REPORTS_RATE_LIMIT_INTERVAL_SEC период времени


our $NO_UNITS_SERVICE = {
    reports => 1,
};


our $API_REPORTS_TMPDIR //= '/opt/ppc-data/api-reports'; # куда apiReportsBuilder складывает файлы, которые не помещаются в память

our $USE_CAMP_AGGREGATED_LASTCHANGE_PROPERTY //= 'use_camp_aggregated_lastchange';
our $USE_CAMP_AGGREGATED_LASTCHANGE_PROPERTY_TTL //= 300;
our $CAMP_AGGREGATED_LASTCHANGE_LAST_TIMESTAMP_PROPERTY_PREFIX = 'camp_aggregated_lastchange_high_boundary_shard_';

our $NEED_ONLINE_REPORT_APP_ID //= { # приложения, которые должны получать отчеты в режиме online
    $MOBILE_APP_ANDROID_APP_ID => 1, # Android
    $MOBILE_APP_IOS_APP_ID => 1, # IOS
    $EDA_APP_ID => 1, # Яндекс.Еда
};

# Приложения, которым разрешено использовать автоцели без доступа
our $UNAVAILABLE_AUTO_GOALS_ALLOWED_APP_ID //= {
    $GEOPRODUCT_APP_ID => 1,
};

our $REQUIRE_OFFLINE_MODE_FOR_DATE_RANGE_TYPE_GREATER_THAN_PROPERTY //= 'days_ok_for_report_online_processing';
our $REQUIRE_OFFLINE_MODE_FOR_LIST_OF_CAMPAIGNS_LONGER_THAN_PROPERTY //= 'campaigns_ok_for_report_online_processing';


our $DK2_LIMITATION_ENABLED_PROPERTY_NAME = 'dk2_limitation_enabled'; # пропертя включения ошибки для клиентов ДК2 без фичи

our $API4_JOB_ID_SHIFT = 4000000000; # значение, на которое уменьшаем идентификатор для фикса переполнения int
our $API4_JOB_ID_THRESHOLD = 2000000000; # значение, выше которого уменьшаем job_id

1;
