package AdGroupTools;

=head1 NAME

    AdGroupTools

=head1 DESCRIPTION

    Вспомогательные ф-ции для работы с группами объявлений

=cut

use warnings;
use strict;
use List::MoreUtils qw/uniq/;

# --------------------------------------------------------------------

=head2 separate_adgroups_from_banners_struct

Выделяем из структуры с баннерами, структуру с группами объявлений
Меняем структуру по месту.

На входе:
    {
        banners => [
            {bid => 12
             , title => "dwed"
             , pid => 324
             , group_name => "..."
            }
            ...
        ]
    }
    , keep_one_banner => # 0|1 оставлять только один баннер в группе, например если нужны только фразы (иначе они будут дублироваться в группе с несколькими баннерами)
    , extract_bool_flags => ['is_accepted', 'is_declined'] # выставляем флаг на группу под заданными ключами, если они выставленны хотя бы на одном баннере в группе

Меняем структуру, добавляем ключ adgroups
    {
        adgroups => [
            { group_name => "..."
              , pid => 324
              , banners => [] # баннеры в группах
            }, ...
        ]
    }

Используется для отправки писем с уведомлениями по группам

=cut

sub separate_adgroups_from_banners_struct($;%) {
    my ($banners, %opt) = @_;

    my $adgroups = {};

    return unless ref($banners->{banners}) eq 'ARRAY' && @{$banners->{banners}};

    for my $banner (@{$banners->{banners}}) {
        die "separate_adgroups_from_banners_struct: not found pid in banners" unless $banner->{pid};

        my $group = $adgroups->{$banner->{pid}} //= {
            pid => $banner->{pid},
            group_name => $banner->{group_name},
            banners => [],
        };

        push @{$group->{minus_geo}}, @{$banner->{minus_geo}//[]};
        $group->{all_geo_disabled} = $banner->{all_geo_disabled};

        if (! $opt{keep_one_banner} || scalar(@{$adgroups->{$banner->{pid}}->{banners}}) == 0) {
            push @{$adgroups->{$banner->{pid}}->{banners}}, $banner;

            if ($opt{extract_bool_flags}) {
                for my $flag_key (@{ $opt{extract_bool_flags} }) {
                    $adgroups->{$banner->{pid}}->{$flag_key} = 1 if $banner->{$flag_key};
                }
            }
        }
    }

    $_->{minus_geo} = join ',', uniq @{$_->{minus_geo}} for values %$adgroups;

    $banners->{adgroups} = [ sort {$a->{pid} <=> $b->{pid}} values %$adgroups ] if %$adgroups;
    
    delete $banners->{banners};
}

=head2 min_price_constant_name_by_type

Какая константа минимальной ставки используется для переданного типа.
Не применимо для cpm_yndx_frontpage.
Вход:
    тип группы
Выход:
    имя константы

=cut

sub min_price_constant_name_by_type {
    my $type = shift;
    if ($type =~ /^cpm_/) {
        return 'MIN_CPM_PRICE';
    }
    return 'MIN_PRICE';
}

1;
