package Yandex::YCssJs::Debug;
## no critic (TestingAndDebugging::RequireUseWarnings)

use strict;
use base qw/Yandex::YCssJs/;

# хак для сбора списка всех посещённых файлов
# возможно, придётся поменять при изменении реализации YCssJs
sub _parse ($;$)
{   
    my $self = shift;
    my $file = $_[0] ||= $self->{file};
    push @{$self->{visited_files}}, $file;
    $self->SUPER::_parse(@_);
}

# оверрайдим Yandex::YCssJs::pwd чтобы иметь возможность запускать склейку несколько раз для разных файлов
our $PWD;
{
    no strict 'refs';
    no warnings 'redefine';
    *{"Yandex::YCssJs::pwd"} = sub {
        return $Yandex::YCssJs::Debug::PWD;
    };
}

package Apache::DebugMergeStatic;

# based on package Yandex::YCssJs::FCGI;

use strict;
use warnings;

use Yandex::YCssJs;
use Settings;
use Direct::ResponseHelper;
use Direct::Template;

use Apache2::Const qw/:common/;
use File::Basename qw/dirname/;
use File::Slurp;
use List::Util qw/max/;

# время запуска апача - чтобы запустить export_consts_to_js только один раз
my $start_time = time();
my $consts_js_file = "$Settings::ROOT/data/js/jq/const.js";

sub handler {
    my ($status, $type, $content, $path, $header);
    my $r = shift;

    eval {
        my $path_info = $r->path_info;
        $path_info =~ s/[^a-z0-9\.\/\_\-]+//gi;
        $path_info =~ s/\.+/./g;

        $path = $r->filename . $path_info;

        if ($path =~ /\.js$/) {
            $type = 'application/x-javascript;charset=utf-8';
        } elsif ($path =~ /\.css$/) {
            $type = 'text/css;charset=utf-8';
        } else {
            die("unknown content-type: $path");
        }

        $status = 200;
        if ($path =~ m#/data[23]/#) {
            if (Direct::Template::get_bemserver_port()) {
                $path =~ m#/data[23](/.*)$#;
                $content = Direct::Template::query_bemserver($1);
            } else {
                $content = read_file($path);
            }
        } elsif ($path =~ s#-c/(?!.*-c/)#/# || $path =~ s#/_(?!.*/)#/#) { # ATTN: path modified!
            # файл _direct.ie.css умеем резать на кусочки по правилу-метке ._________{color:red}
            # аналогичная логика релизована в protected/maintenance/jsbuilder/build для сборки пакетов 
            # файлы _direct.ie-00 и _direct.ie-01 на диск не пишем, потому что так проще. 
            # Если окажется, что это медленно -- придется писать
            my ($splitted, $part) = (0, 0);
            if ( $path =~ m!/direct(\.ie|)-(\d+).css$! ){
                $splitted = 1;
                $part = $2 + 0;
                $path =~ s/direct(\.ie|)(-\d+).css$/direct$1.css/;
            }
            # перегенерим файл с константами, но только раз после перезапуска апача
            if (!-f $consts_js_file || (stat($consts_js_file))[9] < $start_time) {
                system $Settings::ROOT.'/protected/maintenance/export_consts_to_js.pl';
            }
            # имя ранее сгенерированного файла
            (my $cache_file = $path) =~ s/([^\/]+)$/.$1.cache/;
            my $cache_mtime = (stat $cache_file)[9];
            # имя файла, содержащего список включённых файлов
            (my $list_file = $path) =~ s/([^\/]+)$/.$1.list/;
            my $list_mtime = (stat $list_file)[9];
            # максимальное время модификации проинклюженных файлов
            my $includes_max_mtime = 0;
            if (-f $cache_file && -f $list_file && $list_mtime > $start_time) {
                # пытаемся определить, изменилось ли что-нибудь с момента генерации .cache
                $includes_max_mtime = max map {chomp; (stat($_))[9]} read_file($list_file);
            }
            if (!$includes_max_mtime || $cache_mtime < $includes_max_mtime) {
                my $ycssjs = new Yandex::YCssJs::Debug({ naming => 'inline', freeze => 'no', minimize => 'no' });
                $Yandex::YCssJs::Debug::PWD = dirname($path);
                $content = $ycssjs->process_file($path);
                write_file($cache_file, {atomic => 1}, $content);
                write_file($list_file, {atomic => 1}, join("", map {"$_\n"} @{$ycssjs->{visited_files}||[]}));
                $header = "X-YCssJs-Generated";
            } else {
                $content = read_file($cache_file);
                $header = "X-YCssJs-Read-Cached";
            }
            if ($splitted){
                my @parts = split m/\._{10}\{color:red\}/, $content;
                $content = $parts[$part];
                my $ratio = length($parts[0])/length($parts[1]);
                die "too different sizes of _direct.ie-{00,01}.css, $ratio" if $path =~ m!/direct\.ie\.css$! && ($ratio < 0.5 or $ratio > 2);
            }
        } elsif (-e $path) {
            $content = read_file($path);
            $header = "X-YCssJs-Local";
        } else {
            $status = 405;
        }
    };
    if ($@) {
        my $error = $@;
        $content = "/*Error: $error*/";
        $type = 'text/plain;charset=utf-8';
        $status = 500;
    }

    $r->headers_out->set($header  => $path) if $header;
    $r->status($status);
    respond_text($r, $content, $type);
}

1;

