package Apache::MaskSecrets;

=head2 NAME

    Apache::MaskSecrets - маскировка секретов для логгирования

=cut

use warnings;
use strict;

use Apache2::Const qw/OK/;


=head2 mask

    Маскировка sessionid в куке - выставляем замаскированное значение в notes

=cut
sub mask {
    my ($r) = @_;
    my $cookie = $r->headers_in->{Cookie} || '';
    $cookie =~ s/(Session_id|sessionid2)=([^; ]+\|)[^; ]+/$1=${2}secret/g;
    $r->notes->set(masked_cookie => $cookie);

    return OK;
}


1;
