package BS::Export::SkipSOAPData;

=head1 NAME

    BS::Export::SkipSOAPData

=head1 DESCRIPTION

    Класс-контейнер, с помощью которого можно обозначить данные, которые нужно отправлять в БК через LogBroker,
    но в SOAP транспорте отправлять не следует, т.к. на стороне БК в SOAP транспорте они игнорируются.

    Эффект различной отправки двумя транспортами достигается тем, что объекты данного класса по-разному сериализуются
    в JSON и XML.
    При сериализации с помощью BS::Export::SOAPSerializer, объект превращается в строку-заглушку.
    При сериализации с помощью JSON, сериализуются исходные данные, переданные через конструктор.

=cut

=head1 METHODS

=head2 new($class, $value)

    Конструктор.
    Значение $value будет передано в сериализатор JSON.

=cut

use Direct::Modern;

sub new {
    my ($class, $value) = @_;

    return bless {
        value => $value
    }, $class;
}

sub value(){
    my ($self) = @_;
    return $self->{value};
}

=head2 TO_JSON

=cut

sub TO_JSON {
    my ($self) = @_;

    return $self->{value};
}

1;
