package BS::ExportQuery;

=head1 NAME

    BS::ExportQuery - формирование запроса для экспорта в БК

=head1 SYNOPSIS

=head1 DESCRIPTION

=cut

use Direct::Modern;

use Settings;
use Primitives;
use BS::Export qw(:limits get_value_for_sum is_strategy_roi_or_crr is_strategy_roi is_strategy_crr is_strategy_cpa is_strategy_cpa_per_filter is_strategy_cpc is_strategy_cpm is_strategy_avg_cpi is_strategy_autobudget get_target_type convert_template_variables_to_bs_format get_strategy_mobile_goals $BS_MOON_REGION_ID @RELEVANCE_MATCH_BIDS_BASE_TYPES);
use BS::Export::SkipSOAPData;
use BS::ExportMobileContent;
use BS::ResyncQueue;
use Campaign::Types qw/camp_kind_in camp_type_to_param/;
use Currencies ();
use Currency::Rate;
use Direct::Encrypt qw/decrypt_text/;
use IpTools qw/my_aton/;
use Retargeting;
use BannerFlags;
use BannerTemplates;
use Campaign qw//;
use TextTools;
use Tools;
use Translit;
use VCards;
use Client;
use PhrasePrice;
use TimeTarget;
use URLDomain qw /clear_banner_href/;
use Lang::Guess qw/analyze_text_lang_with_context/;
use Direct::BillingAggregates;
use Direct::Model::Banner::Measurer;
use Direct::Model::MobileContent;
use Direct::Model::Pixel qw//;
use Direct::Validation::Image;
use MinusWordsTools;
use MinusWords qw/merge_private_and_library_minus_words/;
use EnvTools qw/is_beta/;
use GeoTools;
use Campaign::Const qw/get_page_ids_by_page_types/;
use Direct::Model::BannerImageAd::Constants;
use Direct::Model::BannerCpmAudio::Constants;
use JavaIntapi::AutobudgetRestartCalculate;

use Yandex::DateTime qw/date/;
use Yandex::DBTools;
use Yandex::SendMail;
use Yandex::HashUtils;
use Yandex::ListUtils qw/enumerate_iter nsort xsort/;
use Yandex::MyGoodWords;
use Yandex::I18n;
use Yandex::IDN;
use Yandex::MirrorsTools::Hostings qw/strip_domain strip_www/;
use Yandex::Retry qw/retry/;
use Yandex::Runtime qw/need_list_context/;
use Yandex::TimeCommon;
use Yandex::Trace;
use Yandex::URL qw/get_host strip_protocol/;
use Yandex::Validate qw/is_valid_id/;

use List::MoreUtils qw(all uniq any none);
use List::Util qw/min first/;
use SOAP::Lite;
use JSON;
use Storable qw/dclone/;
use Encode qw/decode/;
use URI::Escape qw/uri_escape_utf8/;
use Hash::Util qw/lock_hash/;
use HashingTools qw/half_md5hex_hash md5_hex_utf8 url_hash_utf8/;

use API::Limits qw/has_spec_limits get_spec_limit/;

=head2 TGO_LAYOUT_ID

Значение layout_id, при котором считаем креатив performance-tgo

=cut

use constant TGO_LAYOUT_ID => 44;

use constant IN_BANNER_LOW_LAYOUT_ID => 21;
use constant IN_BANNER_HIGH_LAYOUT_ID => 31;

use constant GLOBAL_VARS_PLACEHOLDER =>'must_be_initialized_as_hashref';


use constant SPRAV_DOMAIN_ALIAS => 'sprav';
use constant COLLECTIONS_DOMAIN_ALIAS => 'collections';
use constant MAPS_DOMAIN_ALIAS => 'maps';
use constant ZEN_DOMAIN_ALIAS => 'zen';
use constant APPSTORE_DOMAIN_ALIAS => 'appstore';
use constant GOOGLEPLAY_DOMAIN_ALIAS => 'googleplay';
use constant APPGALLERY_DOMAIN_ALIAS => 'appgallery';
use constant TURBO_SITE => 'turbo.site';


=head2 GLOBAL VARS

=head3 $DOMAINS_DICT

    Словарь доменов. Должен быть ссылкой на хеш domain_id => domain.
    Заполняется в set_global_variables() данными, полученными из get_snapshot.
    $DOMAINS_DICT = BS::ExportWorker::get_snapshot(...)->{domains_dict};

=cut
my $DOMAINS_DICT = GLOBAL_VARS_PLACEHOLDER;

## Шаблоны баннеров для БК (https://st.yandex-team.ru/DIRECT-60917)
## Прежде вычислялись в БК на основе содержимого получаемых баннеров
use constant {
    PPC_TEMPLATE_ID                   => 320, # Объявление с сайтом
    PPC_TEMPLATE_ID_GEO               => 269, # Объявление региональное
    PPC_TEMPLATE_ID_NEW               => 410, # Универсальный шаблон для директа
    PERFOMANCE_PARENT_TEMPLATE_ID     => 744, # Родительский баннер перфоманса
    MEDIA_IMAGE_TEMPLATE_ID           => 921, # Объявление медийного директа с картинкой
    MEDIA_CREATIVE_TEMPLATE_ID        => 953, # Объявление медийного директа с креативом
    HTML5_CREATIVE_TEMPLATE_ID        => 3208, # Объявление медийного директа с html5-креативом
    ALL_PERIOD_FOR_CPM_BANNER         => 90, # Период размещения для cpm_banner'а, который мы передаем в БК, если пользователь выбрал весь период размещения
    AUTO_VIDEO_DEFAULT_CREATIVE_ID    => 777, # дефолтный CreativeId для videomotion
};

# Теги для БК
use constant {
    APP_METRO_TAG                     => 'app-metro', # Тег для приложения "Метро"
    APP_NAVI_TAG                      => 'app-navi', # Тег для приложения "Навигатор"
    FRONTPAGE_TAG                     => 'portal-trusted', # Тег для главной
    CONTENT_PROMOTION_VIDEO_TAG       => 'content-promotion-video', # Тег для продвижения видео-контента
    CONTENT_PROMOTION_COLLECTION_TAG  => 'content-promotion-collection', # Тег для продвижения Коллекций
    FRONTPAGE_DESKTOP_TAG             => 'portal-home-desktop',
    FRONTPAGE_MOBILE_TAG              => 'portal-home-mobile',
};

use constant DEFAULT_TARGET_TAGS_BY_ADGROUP_TYPE => {
    cpm_geoproduct => '["' . APP_METRO_TAG . '"]',
    cpm_yndx_frontpage => '["' . FRONTPAGE_TAG . '"]',
    content_promotion_video => '["' . CONTENT_PROMOTION_VIDEO_TAG . '"]',
    content_promotion => '["' . CONTENT_PROMOTION_COLLECTION_TAG . '"]'
};

use constant DEFAULT_PAGE_GROUP_TAGS_BY_ADGROUP_TYPE => {
    cpm_geoproduct => '["' . APP_METRO_TAG . '"]',
    cpm_yndx_frontpage => '["' . FRONTPAGE_TAG . '"]',
    content_promotion_video => '["' . CONTENT_PROMOTION_VIDEO_TAG . '"]',
    content_promotion => '["' . CONTENT_PROMOTION_COLLECTION_TAG . '"]'
};

use constant TURBOLANDINGS_FILTER_DOMAIN_SUFFIX => '.y-turbo';
use constant PERMALINKS_FILTER_DOMAIN_SUFFIX => '.ya-profile';

use constant ATTRIBUTION_MODEL_VALUES => {
    last_click => 1,
    last_significant_click => 2,
    first_click => 3,
    last_yandex_direct_click => 4,
    last_significant_click_cross_device => 5,
    first_click_cross_device => 6,
    last_yandex_direct_click_cross_device => 7
};

use constant AUCTION_PRIORITY => 10;

use constant DIRECT_TEMPLATE_ID_START_VALUE => 1_000_000;
use constant UNIFIED_TEMPLATE_ID => 3350;

use constant ESHOWS_VIDEO_TYPES_MAPPING => {
    long_clicks => 'LongClicks',
    completes => 'Completes',
};

use constant ALTERNATIVE_APP_STORES => {
    huawei_app_gallery   => 'AppGallery',
    xiaomi_get_apps      => 'GetApps',
    samsung_galaxy_store => 'GalaxyStore',
    vivo_app_store       => 'VivoStore',
};

# Старший байт BannerID, используется при вычислении BannerID
# Первоисточник констант - маппинг "источник данных" - "номер источника":
# https://a.yandex-team.ru/arc/trunk/arcadia/direct/libs/bstransport/proto/integration.proto
use constant BANNER_ID_SIGNIFICANT_BYTE => 1;

my %BS_SUPPORTED_LANGUAGES = map {$_ => 1} qw /ru en uk de be kk tr uz vie es pt cs pl/;

my %IMPRESSION_STANDARD_TYPES = (
    1000 => 'mrc',
    2000 => 'yandex',
);
lock_hash(%IMPRESSION_STANDARD_TYPES);

use constant APPSFLYER_S2S_TRACKING_URL_TEMPLATE => 'https://app.appsflyer.com/%s?clickid={logid}&is_retargeting=true';

=head3 $PHRASES

    Должен быть ссылкой на хеш с массивами данных по фразам/ретаргетингу (для запроса), сгруппированными по pid
    Заполняется в set_global_variables() данными, полученными из get_snapshot.
    $PHRASES = BS::ExportWorker::get_snapshot(...)->{phrases};

    {
        pid1 => [
            $row_hashref1,
            $row_hashref2,
            ...
        ],
        pid2 => [ ... ],
        ...
    }


=cut
my $PHRASES = GLOBAL_VARS_PLACEHOLDER;

=head3 $DOMAINS_WITH_BLOCKED_TITLE

    Словарь доменов, которым требуется отключить отображение в заголовке на выдаче.
    Сслыка на хеш, ключами которого являются домены, значениями - нужно ли блокировать отображение.
    Заполняется в set_global_variables().

=cut
my $DOMAINS_WITH_BLOCKED_TITLE = GLOBAL_VARS_PLACEHOLDER;


=head3 $CRYPTA_GOALS

    Словарь с некоторыми данными из PPCDICT.crypta_goals.
    Формат:
    {
        <goal_id> => { goal_id => ..., bb_keyword => ..., bb_keyword_value => ..., crypta_goal_type => ... }
    }

=cut
my $CRYPTA_GOALS = GLOBAL_VARS_PLACEHOLDER;

=head3 $DYNAMIC_CONDITIONS

    Словарь условий нацеливания - должен быть ссылкой на хеш dyn_cond_id => { condition_json => ..., ... }
    Заполняется в set_global_variables() данными, полученными из get_snapshot.
    $DYNAMIC_CONDITIONS = BS::ExportWorker::get_snapshot(...)->{dynamic_conditions};

=cut
my $DYNAMIC_CONDITIONS = GLOBAL_VARS_PLACEHOLDER;

=head3 $PERFORMANCE_CONDITIONS

    Словарь условий для перфоманс баннера - должен быть ссылкой на хеш bids_performance.perf_filter_id => { condition_json => ..., ... }
    Заполняется в set_global_variables() данными, полученными из get_snapshot
    $PERFORMANCE_CONDITIONS = BS::ExportWorker::get_snapshot(...)->{performance_conditions};

=cut
my $PERFORMANCE_CONDITIONS = GLOBAL_VARS_PLACEHOLDER;

=head3 $RETARGETING_CONDITIONS

    Словарь условий ретаргетинга - должен быть ссылкой на хеш ret_cond_id => {condition_json => ..., ret_cond_id => ..., is_interest => ...}.
    Заполняется в set_global_variables() данными, полученными из get_snapshot.
    $RETARGETING_CONDITIONS = BS::ExportWorker::get_snapshot(...)->{retargeting_conditions};

=cut
my $RETARGETING_CONDITIONS = GLOBAL_VARS_PLACEHOLDER;

=head3 $PROJECT_PARAM_CONDITIONS

    Словарь условий таргетирования на параметры поектов - должен быть ссылкой на хеш
    condition_id => {condition_json => ...}.
    Заполняется в set_global_variables() данными, полученными из get_snapshot.
    $PROJECT_PARAM_CONDITIONS = BS::ExportWorker::get_snapshot(...)->{project_param_conditions};

=cut
my $PROJECT_PARAM_CONDITIONS = GLOBAL_VARS_PLACEHOLDER;

=head3 $AB_SEGMENT_RETARGETING_CONDITIONS

    Словарь условий ретаргетинга аб-сегментов - должен быть ссылкой на хеш ret_cond_id => {condition_json => ..., ret_cond_id => ...}.
    Заполняется в set_global_variables() данными, полученными из get_snapshot.
    AB_SEGMENT_RETARGETING_CONDITIONS = BS::ExportWorker::get_snapshot(...)->{ab_segment_retargeting_conditions};

=cut
my $AB_SEGMENT_RETARGETING_CONDITIONS = GLOBAL_VARS_PLACEHOLDER;

=head3 $BRANDSAFETY_RETARGETING_CONDITIONS

    Словарь условий ретаргетинга для Brand Safety.
    Должен быть ссылкой на хеш ret_cond_id => condition_json
    Заполняется в set_global_variables() данными, полученными из get_snapshot.
    $BRANDSAFETY_RETARGETING_CONDITIONS = BS::ExportWorker::get_snapshot(...)->{brandsafety_retargeting_conditions};

=cut
my $BRANDSAFETY_RETARGETING_CONDITIONS = GLOBAL_VARS_PLACEHOLDER;

=head3 $MULTIPLIERS

    Словарь с коэффициентами к ставкам - должен быть ссылкой на хеш, как результат функции
        BS::ExportWorker::_get_empty_multipliers_dict.
    Заполняется в set_global_variables() данными, полученными из get_snapshot.
    $MULTIPLIERS = BS::ExportWorker::get_snapshot(...)->{multipliers};

=cut
my $MULTIPLIERS = GLOBAL_VARS_PLACEHOLDER;

=head3 $MOBILE_CONTENT

    Словарь с данными о мобильном контенте - должен быть ссылкой на хеш mobile_content_id => { data }
    Заполняется в set_global_variables() данными, полученными из get_snapshot.
    $MOBILE_CONTENT = BS::ExportWorker::get_snapshot(...)->{mobile_content};

=cut
my $MOBILE_CONTENT = GLOBAL_VARS_PLACEHOLDER;

=head3 $MOBAPP_INFO_BY_CID

    Словарь с данными о мобильных приложениях - должен быть ссылкой на хеш cid => { cid => 123, mobile_content_id => 456, domain_id = 789 }
    Заполняется в set_global_variables() данными, полученными из get_snapshot.
    $MOBAPP_INFO_BY_CID = BS::ExportWorker::get_snapshot(...)->{mobapp_info_by_cid};

=cut
my $MOBAPP_INFO_BY_CID = GLOBAL_VARS_PLACEHOLDER;

=head3 $FEEDS

    Словарь с данными о фидах - должен быть ссылкой на хеш feed_id => { data },
    Заполняется в set_global_variables() данными, полученными из get_snapshot.
    $FEEDS = BS::ExportWorker::get_snapshot(...)->{feeds};

=cut

my $FEEDS = GLOBAL_VARS_PLACEHOLDER;

=head3 $PERFORMANCE_COUNTERS

    Словарь с данными о счётчиках Метрики для перфоманс-кампаний - должен быть ссылкой на хеш cid => counter_id
    Заполняется в set_global_variables() данными, полученными из get_snapshot.
    $PERFORMANCE_COUNTERS = BS::ExportWorker::get_snapshot(...)->{performance_counters};

=cut
my $PERFORMANCE_COUNTERS = GLOBAL_VARS_PLACEHOLDER;

=head3 $ENABLED_DYNAMIC_CONDITIONS_BY_PID

    Словарь, содержащий массивы номеров (dyn_cond_id) включенных (не suspended) динамических условий,
    сгруппированных по pid. Нужен для того, чтобы при формировании BannerLandData не перебирать $PHRASES
    несколько раз для одной группы.

=cut
my $ENABLED_DYNAMIC_CONDITIONS_BY_PID = GLOBAL_VARS_PLACEHOLDER;

=head3 $ENABLED_PERF_CONDITIONS_BY_PID

    Словарь, содержащий массивы номеров (bids_performance.perf_filter_id) включенных (не is_deleted) условий для перфоманс баннера,
    сгруппированных по pid

=cut
my $ENABLED_PERF_CONDITIONS_BY_PID = GLOBAL_VARS_PLACEHOLDER;

=head3 $CLIENT_NDS_CACHE

    Кэш текущих значений НДС клиентов

=cut

my $CLIENT_NDS_CACHE = GLOBAL_VARS_PLACEHOLDER;

=head3 $ADDITIONS

    Должен быть ссылкой на хеш с типами дополнений в качестве ключей, и хешей со списком дополнений по каждому объекту к которому они привязаны (bid/pid/cid)
    Заполняется в set_global_variables() данными, полученными из get_snapshot.
    $ADDITIONS = BS::ExportWorker::get_snapshot(...)->{additions};

    {callout => {
            bid1 => [
                additon_hashref1,
                additon_hashref2,
                ...],
            bid2 => [...],
            ...

        },
     ...
    }

=cut

my $ADDITIONS = GLOBAL_VARS_PLACEHOLDER;

=head3 $SITELINKS_SETS

    Должен быть ссылкой на хеш с сайтлинками
    Заполняется в set_global_variables() данными, полученными из get_snapshot.
    $ADDITIONS = BS::ExportWorker::get_snapshot(...)->{sitelinks_sets};

    {
        set_id1 => [
            {
                sl_id  => ...,
                title  => ...,
                description => ...,
                href   => ...,
                hash   => ...,
            },
            ...
        ],
        ...
    }

=cut

my $SITELINKS_SETS = GLOBAL_VARS_PLACEHOLDER;

my $TURBOLANDINGS  = GLOBAL_VARS_PLACEHOLDER;

=head2 $EXPERIMENTS

    Словарь с данными о параметрах A/B тестов кампании - должен быть ссылкой на хеш cid => { data }
    Заполняется в set_global_variables() данными, полученными из get_snapshot.
    $EXPERIMENTS = BS::ExportWorker::get_snapshot(...)->{experiments};

=cut

my $EXPERIMENTS = GLOBAL_VARS_PLACEHOLDER;

=head3 $CAMPAIGNS_DESCRIPTIONS

    Словарь cid => hashref с описанием кампании с соответствующим cid.

    Заполняется в set_global_variables() данными, полученными из get_snapshot.
    $CAMPAIGNS_DESCRIPTIONS = BS::ExportWorker::get_snapshot(...)->{campaigns_descriptions};

=cut

my $CAMPAIGNS_DESCRIPTIONS = GLOBAL_VARS_PLACEHOLDER;

=head3 $CIDS_TO_BS_ORDER_ID

    Словарь cid => OrderID для новых кампаний.

    Заполняется в set_global_variables() данными, полученными из get_snapshot.
    $CIDS_TO_BS_ORDER_ID = BS::ExportWorker::get_snapshot(...)->{cid_to_bs_order_id};

=cut

my $CIDS_TO_BS_ORDER_ID = GLOBAL_VARS_PLACEHOLDER;

=head3 %BANNERS_FOR_RESYNC_WITH_CONTEXT

    Словарь, содержащий хеши с данными для ленивой переотправики баннеров с контекстами, хранящиеся на номер баннера (bid).
    Область использования - функция get_query и вложенные в нее вызовы.

=cut

my %BANNERS_FOR_RESYNC_WITH_CONTEXT;

=head3 my $CAMPAIGN_MINUS_OBJECTS

    Словарь cid => arrayref с минус-словами и минус-фразами на кампанию.

    Заполняется в set_global_variables() данными, полученными из get_snapshot.
    CAMPAIGN_MINUS_OBJECTS = BS::ExportWorker::get_snapshot(...)->{campaign_minus_objects};

=cut

my $CAMPAIGN_MINUS_OBJECTS = GLOBAL_VARS_PLACEHOLDER;

=head3 my $MINUS_PHRASES_DICT

    Словарь mw_id => arrayref с минус-словами и минус-фразами на группу.

    Заполняется в set_global_variables() данными, полученными из get_snapshot.
    MINUS_PHRASES_DICT = BS::ExportWorker::get_snapshot(...)->{minus_phrases};

=cut

my $MINUS_PHRASES_DICT = GLOBAL_VARS_PLACEHOLDER;

=head3 my $LIB_MINUS_PHRASES_DICT_BY_PID

    Словарь pid => arrayref с массивом библиотечных минус-слов и минус-фраз на группу.
    Библиотечные минус фразы не пересекаются с $MINUS_PHRASES_DICT

    Заполняется в set_global_variables() данными, полученными из get_snapshot.
    LIB_MINUS_PHRASES_DICT_BY_PID = BS::ExportWorker::get_snapshot(...)->{lib_minus_phrases_by_pid};

=cut

my $LIB_MINUS_PHRASES_DICT_BY_PID = GLOBAL_VARS_PLACEHOLDER;

=head3 my $VCARDS

    Словарь vcard_id => hashref с контактной информацией.

    Заполняется в set_global_variables() данными, полученными из get_snapshot.
    $VCARDS = BS::ExportWorker::get_snapshot(...)->{vcards};

    Имеет такую структуру
    {
        # столбцы из vcards
        phone => ..., name => ..., street => ..., house => ..., build => ..., apart => ..., metro => ...,
        contactperson => ..., worktime => ..., city => ..., country => ..., geo_id => ..., extra_message => ...,
        contact_email => ..., im_client => ..., im_login => ..., permalink => ...,

        # столбцы из org_details
        ogrn => ...,

        # столбцы из addresses
        precision => ..., map_id => ..., map_id_auto => ...,

        # столбцы из maps
        mid => ..., x => ..., y => ..., x1 => ..., y1 => ..., x2 => ..., y2 => ...,
    }

=cut

my $VCARDS = GLOBAL_VARS_PLACEHOLDER;

=head3 my $BANNER_PERMALINKS

    Словарь bid => {permalink => xxx, chain_ids => [yy,zz,...] }.

    Заполняется в set_global_variables() данными, полученными из get_snapshot.
    $BANNER_PERMALINKS = BS::ExportWorker::get_snapshot(...)->{banner_permalinks};
=cut

my $BANNER_PERMALINKS = GLOBAL_VARS_PLACEHOLDER;

=head3 my $CLIENT_PHONES

    Словарь client_phone_id => { phone => ... }.

    Заполняется в set_global_variables() данными, полученными из get_snapshot.
    $CLIENT_PHONES = $snapshot->{client_phones};
=cut

my $CLIENT_PHONES = GLOBAL_VARS_PLACEHOLDER;

=head3 $IGNORE_BS_SYNCED

    Флаг, что нужно игнорировать статусы синхронизации объектов и брать все подходящие под другие условия

=cut

my $IGNORE_BS_SYNCED;


=head2 $DONT_CALCULATE_AUTOBUDGET_RESTART

    Нужно ли пропускать расчёт времени рестарта автобюджета (для full-lb-export)

=cut

my $DONT_CALCULATE_AUTOBUDGET_RESTART;


=head3 $DISCLAIMERS

    Словарь bid => disclaimer_text.

    Заполняется в set_global_variables() данными, полученными из get_snapshot.
    DISCLAIMERS = BS::ExportWorker::get_snapshot(...)->{disclaimers};

=cut

my $DISCLAIMERS = GLOBAL_VARS_PLACEHOLDER;

=head3 $MINUS_GEO

    Словарь с минус-гео, сгруппированных по группе/баннеру/типу минус-регионов.
    По каждой группе содержит записи только по баннерам, минус-регионы от которых нужно будет (возможно) применить к группе.
    Окончательное решение о применении минус-регионов от того или иного баннера принимается после формирования запроса в get_query.
    По "старым" баннерам должны быть записи только(!) если по всем признакам этот баннер сейчас крутится в БК (текущая или предыдущая версия).
    Заполняется в set_global_variables() данными, полученными из get_snapshot.
    $MINUS_GEO = BS::ExportWorker::get_snapshot(...)->{minus_geo};

    {pid1 => {

                bid1 => {current => <minus_geo1>,
                         bs_synced => <minus_geo2>},
                bid2 => {current => <minus_geo3>,
                         is_new => 1 # для баннеров у которых BannerID=0
                         },
                ...
            },
            new => {
                bid3 => {current => <minus_geo3>},
                ...
            }

        },
     ...
    }

=cut

my $MINUS_GEO = GLOBAL_VARS_PLACEHOLDER;

=head3 my $BANNER_IMAGES_FORMATS

    Словарь image_hash => hashref с информацией по картинке.

    Заполняется в set_global_variables() данными, полученными из get_snapshot.
    BANNER_IMAGES_FORMATS = BS::ExportWorker::get_snapshot(...)->{banner_images_formats};

    Имеет структуру
    $ClientID1 => {
        $image_hash1 => {
            # столбцы из banner_images_formats, в image_mds_meta_json подмержены данные из banner_images_pool.mds_meta_user_override
            image_hash => ..., image_formats => ..., image_mds_meta_json => ..., image_type => ...,
            banner_image_mds_group_id => ..., banner_image_namespace => ..., banner_image_avatars_host => ...,
        },
        $image_hash2 => { ... }
    },
    $ClientID2 => {
        ...
    },
    ...

=cut

my $BANNER_IMAGES_FORMATS = GLOBAL_VARS_PLACEHOLDER;

=head3 $TEMPLATE_PROPERTIES

    Словарь direct_template_id => hashref со свойствами шаблона, основанного на едином шаблоне.

    Заполняется в set_global_variables() данными, полученными из get_snapshot.
    TEMPLATE_PROPERTIES = BS::ExportWorker::get_snapshot(...)->{template_properties};

    Имеет структуру:
    $direct_template_id1 => {
        # столбцы из ppcdict.direct_template
        direct_template_id => ..., format => ..., state => ...
    },
    $direct_template_id2 => { ... }

=cut

my $TEMPLATE_PROPERTIES = GLOBAL_VARS_PLACEHOLDER;

=head3 my $TEMPLATE_RESOURCES

    Словарь template_resource_id => hashref с информацией ресурса шаблона

    Заполняется в set_global_variables() данными, полученными из get_snapshot.
    TEMPLATE_RESOURCES = BS::ExportWorker::get_snapshot(...)->{template_resources};

    Имеет структуру:
    $template_resource_id1 => {
        # столбцы из ppcdict.direct_template_resource или ppcdict.template_resource
        id => ..., resource_no => ..., template_part_no => ..., is_image => ...,
        # столбцы только из ppcdict.direct_template_resource
        unified_resource_no => ..., unified_template_resource_id => ...
    },
    $template_resource_id2 => { ...}

=cut

my $TEMPLATE_RESOURCES = GLOBAL_VARS_PLACEHOLDER;

=head3 my $TEMPLATE_VARIABLES_IMAGES_FORMATS

    Словарь image_hash => hashref с информацией по картинке для картиночных переменных шаблона

    Заполняется в set_global_variables() данными, полученными из get_snapshot.
    TEMPLATE_VARIABLES_IMAGES_FORMATS = BS::ExportWorker::get_snapshot(...)->{template_variables_images_formats};

    Имеет структуру:
    $image_hash1 => {
        # столбцы из banner_images_formats
        image_hash AS banner_image => ..., width => ..., height => ...,
        banner_image_mds_group_id => ..., banner_image_namespace => ..., banner_image_avatars_host => ...,
    },
    $image_hash2 => { ... }

=cut

my $TEMPLATE_VARIABLES_IMAGES_FORMATS = GLOBAL_VARS_PLACEHOLDER;

=head3 $AGGREGATOR_DOMAINS

    Словарь для расклейки доменов-агрегаторов. Должен быть ссылкой на хеш bid => domain.
    Заполняется в set_global_variables() данными, полученными из get_snapshot.
    $AGGREGATOR_DOMAINS = BS::ExportWorker::get_snapshot(...)->{aggregator_domains};

=cut

my $AGGREGATOR_DOMAINS = GLOBAL_VARS_PLACEHOLDER;

=head3 $BILLINIG_AGGREGATES

    Биллинговые агрегаты сгруппированные по wallet_cid и типу продукта.

=cut

my $BILLINIG_AGGREGATES = GLOBAL_VARS_PLACEHOLDER;

=head3 $PRODUCTS_BY_ID

    Словарь продуктов по ProductID

=cut
my $PRODUCTS_BY_ID = GLOBAL_VARS_PLACEHOLDER;

=head3 $BANNER_PAGE_MODERATION

    Вердикты внешней модерации outdoor баннеров. Должен быть ссылкой на хеш bid => [pageId => ..., statusModerate => ...].
    Заполняется в set_global_variables() данными, полученными из get_snapshot.
    $AGGREGATOR_DOMAINS = BS::ExportWorker::get_snapshot(...)->{banner_page_moderation};

=cut

my $BANNER_PAGE_MODERATION = GLOBAL_VARS_PLACEHOLDER;


=head3 $CAMPAIGN_MEASURERS

    Измерители видимости кампании

=cut

my $CAMPAIGN_MEASURERS = GLOBAL_VARS_PLACEHOLDER;

=head3 $BANNER_MEASURERS

    Измерители видимости баннера

=cut

my $BANNER_MEASURERS = GLOBAL_VARS_PLACEHOLDER;

=head3 $MEDIASCOPE_PREFIXES

    Префикс на клиента полученный от медиаскопа

=cut

my $MEDIASCOPE_PREFIXES = GLOBAL_VARS_PLACEHOLDER;

=head3 $BANNER_TNS_ID

    TNS ID баннеров

=cut

my $BANNER_TNS_ID = GLOBAL_VARS_PLACEHOLDER;

=head3 $TURBO_APP_CONTENT

    Информация о турбо-аппах в виде хеша:
    {
        <turbo_app_info_id> => {
            TurboAppId => <turbo_app_id>,
            TurboAppContent => <content>
        },
        ...
    }

    Данные берутся из таблицы ppc.turbo_apps_info
    Для отправки в БК к этим данным нужно добавить поле TurboAppType = <banner_turbo_apps> из таблицы ppc.banner_turbo_app_type

=cut

my $TURBO_APP_CONTENT = GLOBAL_VARS_PLACEHOLDER;

=head3 $INTERNAL_AD_PRODUCTS

    Информация о продуктах внутренней рекламы в виде хеша:
    {
        $ClientID => {
            ClientID => $ClientID,
            product_name => '',
        }
    }

=cut

my $INTERNAL_AD_PRODUCTS = GLOBAL_VARS_PLACEHOLDER;

=head3 SKADNETWORK_SLOTS

    Слот - SKAdNetworkCampaignID, соответствующий кампании

=cut

my $SKADNETWORK_SLOTS = GLOBAL_VARS_PLACEHOLDER;

=head3 MOBILE_GOAL_APP_INFO

    os_type и store_content_id для мобильных целей, используемых в стратегиях кампаний

=cut

my $MOBILE_GOAL_APP_INFO = GLOBAL_VARS_PLACEHOLDER;

=head3 $BANNER_ADDITIONAL_HREFS

    Дополнительные ссылки для баннеров

=cut

my $BANNER_ADDITIONAL_HREFS = GLOBAL_VARS_PLACEHOLDER;

=head3 $ASSET_HASHES

    Словарь хешей ассетов, сгрупированных по кампаниям и баннерам
    campaign_id => banner_id => asset_hash

    {
        <campaign_id> => {
            <banner_id 1> => {
                TitleAssetHash => '395766436205812',
                TextBodyAssetHash => '395767351324926',
                ImageAssetHash => '395767741545527',
                VideoAssetHash => '395766269052275'
            },
            <banner_id 2> => {
                TitleAssetHash => '395767825866396',
                TextBodyAssetHash => '395767607000723',
            },
            ...
        },
        ...
    }

=cut

my $ASSET_HASHES = GLOBAL_VARS_PLACEHOLDER;

=head3 $CAMP_AUTOBUDGET_RESTARTS

    Данные о последних перезапусках автобюджета следующего вида:
    {
        <campaign_id> => {
            cid => <campaign_id>
            restart_time => '2020-07-14 10:50:00',
            soft_restart_time => '2020-07-14 10:50:00',
            restart_reason => 'BS_RESTART'
        },
        ...
    }

    Заполняется в set_global_variables() данными, полученными из get_snapshot(...)->{camp_autobudget_restarts};
    Загружается, только если ExportWorker запустили с параметром LOAD_AUTOBUDGET_RESTART,

=cut

my $CAMP_AUTOBUDGET_RESTARTS = GLOBAL_VARS_PLACEHOLDER;

=head2 init(%options)

    Первоначальная установка переменных, сброс кешей.
    %options:
        dbh2 - коннект к БД (в этой БД имеется временная таблица с данными, которые будут отправлены в БК)
        db - коннект к основной БД PPC
        parid - номер очереди в БК (для bsClientData.pl)
        log - объект Yandex::Log
        error_logger - обертка для Yandex::Log::Messages
        ignore_bs_synced - см. описание $IGNORE_BS_SYNCED
        dont_calculate_autobudget_restart - можно ли не пересчитывать рестарт автобюджета и взять значения, посчитанные ранее

=cut

my ($dbh2, $dbh, $PAR_ID, $PAR_TYPE, $shard);
my $json_obj;
our $log;
my $error_logger;
sub init {
    my %options = @_;

    ($dbh2, $dbh, $PAR_ID, $PAR_TYPE, $log, $error_logger, $IGNORE_BS_SYNCED, $DONT_CALCULATE_AUTOBUDGET_RESTART, $shard) =
        @options{qw/dbh2 dbh parid partype log error_logger ignore_bs_synced dont_calculate_autobudget_restart shard/};

    # чистим кеши и словари
    undef $BS::Export::CURRENT_CID;
    $TEMPLATE_PROPERTIES = GLOBAL_VARS_PLACEHOLDER;
    $TEMPLATE_RESOURCES = GLOBAL_VARS_PLACEHOLDER;
    $TEMPLATE_VARIABLES_IMAGES_FORMATS = GLOBAL_VARS_PLACEHOLDER;
    $DOMAINS_DICT = GLOBAL_VARS_PLACEHOLDER;
    $DOMAINS_WITH_BLOCKED_TITLE = GLOBAL_VARS_PLACEHOLDER;
    $CRYPTA_GOALS = GLOBAL_VARS_PLACEHOLDER;
    $DYNAMIC_CONDITIONS = GLOBAL_VARS_PLACEHOLDER;
    $PERFORMANCE_CONDITIONS = GLOBAL_VARS_PLACEHOLDER;
    $RETARGETING_CONDITIONS = GLOBAL_VARS_PLACEHOLDER;
    $PROJECT_PARAM_CONDITIONS = GLOBAL_VARS_PLACEHOLDER;
    $AB_SEGMENT_RETARGETING_CONDITIONS = GLOBAL_VARS_PLACEHOLDER;
    $BRANDSAFETY_RETARGETING_CONDITIONS = GLOBAL_VARS_PLACEHOLDER;
    $PHRASES = GLOBAL_VARS_PLACEHOLDER;
    $MULTIPLIERS = GLOBAL_VARS_PLACEHOLDER;
    $MOBILE_CONTENT = GLOBAL_VARS_PLACEHOLDER;
    $PERFORMANCE_COUNTERS = GLOBAL_VARS_PLACEHOLDER;
    $FEEDS = GLOBAL_VARS_PLACEHOLDER;
    $ADDITIONS = GLOBAL_VARS_PLACEHOLDER;
    $SITELINKS_SETS = GLOBAL_VARS_PLACEHOLDER;
    $TURBOLANDINGS = GLOBAL_VARS_PLACEHOLDER;
    $EXPERIMENTS = GLOBAL_VARS_PLACEHOLDER;
    $CAMPAIGN_MINUS_OBJECTS = GLOBAL_VARS_PLACEHOLDER;
    $MINUS_PHRASES_DICT = GLOBAL_VARS_PLACEHOLDER;
    $LIB_MINUS_PHRASES_DICT_BY_PID = GLOBAL_VARS_PLACEHOLDER;
    $CAMPAIGNS_DESCRIPTIONS = GLOBAL_VARS_PLACEHOLDER;
    $CIDS_TO_BS_ORDER_ID = GLOBAL_VARS_PLACEHOLDER;
    $VCARDS = GLOBAL_VARS_PLACEHOLDER;
    $BANNER_PERMALINKS = GLOBAL_VARS_PLACEHOLDER;
    $CLIENT_PHONES = GLOBAL_VARS_PLACEHOLDER;
    $DISCLAIMERS = GLOBAL_VARS_PLACEHOLDER;
    $MINUS_GEO = GLOBAL_VARS_PLACEHOLDER;
    $BANNER_IMAGES_FORMATS = GLOBAL_VARS_PLACEHOLDER;
    $AGGREGATOR_DOMAINS = GLOBAL_VARS_PLACEHOLDER;
    $BILLINIG_AGGREGATES = GLOBAL_VARS_PLACEHOLDER;
    $PRODUCTS_BY_ID = GLOBAL_VARS_PLACEHOLDER;
    $BANNER_PAGE_MODERATION = GLOBAL_VARS_PLACEHOLDER;
    $ASSET_HASHES = GLOBAL_VARS_PLACEHOLDER;
    $CAMP_AUTOBUDGET_RESTARTS = GLOBAL_VARS_PLACEHOLDER;
    # TODO: перенести сюда %domain2filerdomain_cache
    $ENABLED_DYNAMIC_CONDITIONS_BY_PID = {};
    $ENABLED_PERF_CONDITIONS_BY_PID = {};
    $CLIENT_NDS_CACHE = {};
    %BANNERS_FOR_RESYNC_WITH_CONTEXT = ();
    # canonical даёт сортировку ключей, которая нужна, чтобы получались одинаковые BannerLandData
    # Боря уникализирует их по сериализованному тексту
    $json_obj = JSON->new->canonical(1)->utf8(0);
    BS::ExportMobileContent::init(%options);

    _drop_order_caches();
}

=head2 set_global_variables($snapshot)

    Устанавливает значения глобальных переменных, которые будут использоваться
    в различных функциях в течение итерации.
    Часть данных берется из $snapshot (если они там есть), часть - выбирается из базы.

    Параметры:
        $snapshot   - ссылка на хеш с данными для итерации (реультат BS::ExportWorker::get_snapshot)

=cut
sub set_global_variables {
    my $snapshot = shift;

    # заполняем данными из снепшота
    if ($snapshot->{phrases} && ref $snapshot->{phrases} eq 'HASH') {
        $PHRASES = $snapshot->{phrases};
    }
    if ($snapshot->{domains_dict} && ref $snapshot->{domains_dict} eq 'HASH') {
        $DOMAINS_DICT = $snapshot->{domains_dict};
    }
    if ($snapshot->{dynamic_conditions} && ref $snapshot->{dynamic_conditions} eq 'HASH') {
        $DYNAMIC_CONDITIONS = $snapshot->{dynamic_conditions};
    }
    if ($snapshot->{performance_conditions} && ref $snapshot->{performance_conditions} eq 'HASH') {
        $PERFORMANCE_CONDITIONS = $snapshot->{performance_conditions};
    }
    if ($snapshot->{retargeting_conditions} && ref $snapshot->{retargeting_conditions} eq 'HASH') {
        $RETARGETING_CONDITIONS = $snapshot->{retargeting_conditions};
    }
    if ($snapshot->{project_param_conditions} && ref $snapshot->{project_param_conditions} eq 'HASH') {
        $PROJECT_PARAM_CONDITIONS = $snapshot->{project_param_conditions};
    }
    if ($snapshot->{ab_segment_retargeting_conditions} && ref $snapshot->{ab_segment_retargeting_conditions} eq 'HASH') {
        $AB_SEGMENT_RETARGETING_CONDITIONS = $snapshot->{ab_segment_retargeting_conditions};
    }
    if ($snapshot->{brandsafety_retargeting_conditions} && ref $snapshot->{brandsafety_retargeting_conditions} eq 'HASH') {
        $BRANDSAFETY_RETARGETING_CONDITIONS = $snapshot->{brandsafety_retargeting_conditions};
    }
    if ($snapshot->{multipliers} && ref $snapshot->{multipliers} eq 'HASH') {
        $MULTIPLIERS = $snapshot->{multipliers};
    }
    if ($snapshot->{mobile_content} && ref $snapshot->{mobile_content} eq 'HASH') {
        $MOBILE_CONTENT = $snapshot->{mobile_content};
    }
    if ($snapshot->{mobapp_info_by_cid} && ref $snapshot->{mobapp_info_by_cid} eq 'HASH') {
        $MOBAPP_INFO_BY_CID = $snapshot->{mobapp_info_by_cid};
    }
    if ($snapshot->{performance_counters} && ref $snapshot->{performance_counters} eq 'HASH') {
        $PERFORMANCE_COUNTERS = $snapshot->{performance_counters};
    }
    if ($snapshot->{feeds} && ref $snapshot->{feeds} eq 'HASH') {
        $FEEDS = $snapshot->{feeds};
    }
    if ($snapshot->{additions} && ref $snapshot->{additions} eq 'HASH') {
        $ADDITIONS = $snapshot->{additions};
    }
    if ($snapshot->{sitelinks_sets} && ref $snapshot->{sitelinks_sets} eq 'HASH') {
        $SITELINKS_SETS = $snapshot->{sitelinks_sets};
    }

    if ($snapshot->{turbolandings} && ref $snapshot->{turbolandings} eq 'HASH') {
        $TURBOLANDINGS = $snapshot->{turbolandings};
    }

    if ($snapshot->{experiments} && ref $snapshot->{experiments} eq 'HASH') {
        $EXPERIMENTS = $snapshot->{experiments};
    }
    if ($snapshot->{campaign_minus_objects} && ref $snapshot->{campaign_minus_objects} eq 'HASH') {
        $CAMPAIGN_MINUS_OBJECTS = $snapshot->{campaign_minus_objects};
    }
    if ($snapshot->{minus_phrases} && ref $snapshot->{minus_phrases} eq 'HASH') {
        $MINUS_PHRASES_DICT = $snapshot->{minus_phrases};
    }
    if ($snapshot->{lib_minus_phrases_by_pid} && ref $snapshot->{lib_minus_phrases_by_pid} eq 'HASH') {
        $LIB_MINUS_PHRASES_DICT_BY_PID = $snapshot->{lib_minus_phrases_by_pid};
    }
    if ($snapshot->{campaigns_descriptions} && ref $snapshot->{campaigns_descriptions} eq 'HASH') {
        $CAMPAIGNS_DESCRIPTIONS = $snapshot->{campaigns_descriptions};
    }
    if ($snapshot->{vcards} && ref $snapshot->{vcards} eq 'HASH') {
        $VCARDS = $snapshot->{vcards};
    }
    if ($snapshot->{banner_permalinks} && ref $snapshot->{banner_permalinks} eq 'HASH') {
        $BANNER_PERMALINKS = $snapshot->{banner_permalinks};
    }
    if ($snapshot->{client_phones} && ref $snapshot->{client_phones} eq 'HASH') {
        $CLIENT_PHONES = $snapshot->{client_phones};
    }
    if ($snapshot->{disclaimers} && ref $snapshot->{disclaimers} eq 'HASH') {
        $DISCLAIMERS = $snapshot->{disclaimers};
    }
    if ($snapshot->{minus_geo} && ref $snapshot->{minus_geo} eq 'HASH') {
        $MINUS_GEO = $snapshot->{minus_geo};
    }
    if ($snapshot->{banner_images_formats} && ref $snapshot->{banner_images_formats} eq 'HASH') {
        $BANNER_IMAGES_FORMATS = $snapshot->{banner_images_formats};
    }
    if ($snapshot->{template_properties} && ref $snapshot->{template_properties} eq 'HASH') {
        $TEMPLATE_PROPERTIES = $snapshot->{template_properties};
    }
    if ($snapshot->{template_resources} && ref $snapshot->{template_resources} eq 'HASH') {
        $TEMPLATE_RESOURCES = $snapshot->{template_resources};
    }
    if ($snapshot->{template_variables_images_formats} && ref $snapshot->{template_variables_images_formats} eq 'HASH') {
        $TEMPLATE_VARIABLES_IMAGES_FORMATS= $snapshot->{template_variables_images_formats};
    }
    if ($snapshot->{aggregator_domains} && ref $snapshot->{aggregator_domains} eq 'HASH') {
        $AGGREGATOR_DOMAINS = $snapshot->{aggregator_domains};
    }
    if ($snapshot->{billing_aggregates} && ref $snapshot->{billing_aggregates} eq 'HASH') {
        $BILLINIG_AGGREGATES = $snapshot->{billing_aggregates};
    }
    if ($snapshot->{banner_page_moderation} && ref $snapshot->{banner_page_moderation} eq 'HASH') {
        $BANNER_PAGE_MODERATION = $snapshot->{banner_page_moderation};
    }
    if ($snapshot->{banner_measurers}) {
        $BANNER_MEASURERS = $snapshot->{banner_measurers};
    }
    if ($snapshot->{camp_measurers}) {
        $CAMPAIGN_MEASURERS = $snapshot->{camp_measurers};
    }
    if ($snapshot->{mediascope_prefixes}) {
        $MEDIASCOPE_PREFIXES = $snapshot->{mediascope_prefixes};
    }
    if ($snapshot->{banner_tns_id} && ref $snapshot->{banner_tns_id} eq 'HASH') {
        $BANNER_TNS_ID = $snapshot->{banner_tns_id};
    }

    if ($snapshot->{cid_to_bs_order_id} && ref $snapshot->{cid_to_bs_order_id} eq 'HASH') {
        $CIDS_TO_BS_ORDER_ID = $snapshot->{cid_to_bs_order_id};
    }

    if ($snapshot->{turbo_app_content} && ref $snapshot->{turbo_app_content} eq 'HASH') {
        $TURBO_APP_CONTENT = $snapshot->{turbo_app_content};
    }

    if ($snapshot->{internal_ad_products} && ref $snapshot->{internal_ad_products} eq 'HASH') {
        $INTERNAL_AD_PRODUCTS = $snapshot->{internal_ad_products};
    }

    if ($snapshot->{skadnetwork_slots} && ref $snapshot->{skadnetwork_slots} eq 'HASH') {
        $SKADNETWORK_SLOTS = $snapshot->{skadnetwork_slots};
    }

    if ($snapshot->{mobile_goal_app_info} && ref $snapshot->{mobile_goal_app_info} eq 'HASH') {
        $MOBILE_GOAL_APP_INFO = $snapshot->{mobile_goal_app_info};
    }

    $BANNER_ADDITIONAL_HREFS = $snapshot->{banner_additional_hrefs} if $snapshot->{banner_additional_hrefs};

    $ASSET_HASHES = $snapshot->{asset_hashes} if $snapshot->{asset_hashes};

    $CAMP_AUTOBUDGET_RESTARTS = $snapshot->{camp_autobudget_restarts} if $snapshot->{camp_autobudget_restarts};

    $PRODUCTS_BY_ID = Primitives::product_info(hash_by_id => 1);

    # собираем словарные данные
    $DOMAINS_WITH_BLOCKED_TITLE = get_hash_sql(PPCDICT, 'SELECT domain, IF(status != "for_enabling", 1, 0) AS blocked FROM bad_domains_titles');
    $CRYPTA_GOALS = get_hashes_hash_sql(PPCDICT, 'SELECT goal_id, bb_keyword, bb_keyword_value, crypta_goal_type FROM crypta_goals');

}

=head2 get_query(%data)

    my ($query, %additional) = BS::ExportQuery::get_query(data_arrayref => $data_arrayref,
                                                          no_limits => 0,
                                                          );

    Сформировать запрос для отправки данных в БК

    Параметры именованные:
        data_arrayref      - массив хешей с данными по кампаниям/группам/баннерам
        no_limits   - не учитывать лимиты на количество объектов в запросе,
                    при этом если кампания не влезла целиком - она исключается из запроса.
    Кроме того, использует глобальные:
        $PHRASES    - данные по фразам для запроса, сгруппированные по pid
        %BANNERS_FOR_RESYNC_WITH_CONTEXT    - хеш для накопления данных для переотправки баннеров с условиями
    Результат:
        $query - сформированный запрос к БК

        wait_activization - кампании, за активизациеё в БК которых нужно будет следить
        images_sent - хеш, ключами которого являются номера (image_id) отправляемых картиночных баннеров
        campaigns_to_sync - кампании, которые будут синхронизироваться с БК
        campaigns_in_rest - хеш {cid => } кампании, которые не были добавлены в сформированный запрос к БК,
                             хотя попали в текущую выборку
        new_campaigns - хеш, ключами которго являются номера (cid) новых (без OrderID) отправляемых кампаний
        new_banners - хеш, ключами которго являются номера (bid, image_id) новых (без BannerID)
                      отправляемых баннеров (текстовых и картиночных)
        quantity => { # количество объектов с запросе к БК
                        camps contexts banners bids}
        second_query_data - ссылка на массив данных, для составления второго, "включающего" запроса
        forcedly_stopped_camps      - ссылка на хеш, ключами которого являются номера (cid) кампаний,
                                      которым в запросе принудительно проставили Stop=1 (вместо фактического Stop=0)
        forcedly_stopped_banners    - ссылка на хеш, ключами которого являются номера (bid, image_id) баннеров,
                                      которым в запросе принудительно проставили Stop=1 (вместо фактического Stop=0)
        resync_banners_with_phrases - массив хешей (для bs_resync) с данными по баннерам, которые могли быть отправлены
                                      но не сделали это из-за phrases.statusBsSynced = "Yes"
        cid_to_engine_id - хэш cid => EngineID для отправки в logbroker

=cut

sub get_query {
    my (%data) = @_;

    my $profile = Yandex::Trace::new_profile('bs_export_query:get_query');

    my (%CAMPAIGNS_IN_REST, %BANNERS_SENT, %BANNER_IMAGES_SENT, %CAMPAIGNS_SENT);
    my (%BANNER_IMAGES_MAP);
    my (%NEW_BANNERS, %NEW_CAMPAIGNS, %CID_PID_BID_TO_IMAGE_ID_AS_ONE);

    # массив для сохранения исходных строк (из $data_arrayref) с новыми данными,
    # будет использован для составления второго, "включающего" запроса
    my @SECOND_QUERY_DATA;
    # запоминаем в качестве ключей идентификаторы (cid, bid/image_id) объектов, которым делали подмену Stop
    my (%FORCEDLY_STOPPED_CAMPS, %FORCEDLY_STOPPED_BANNERS);

    %BANNERS_FOR_RESYNC_WITH_CONTEXT = ();

    # основа будущего запроса
    my $query = BS::Export::get_empty_query_struct_for_UpdateData2($PAR_TYPE);

    my $one_context_profile;


    # если выбрали $MAX_ROWS_FOR_SNAPSHOT строк, то последняя группа может быть не полной
    # про особенности выборки еще есть комментарий в BS::ExportWorker::get_snapshot
    my $last_pid_for_exclude;
    my $last_cid_for_exclude;
    if (@{ $data{data_arrayref} } == $MAX_ROWS_FOR_SNAPSHOT) {
        if ($data{no_limits}) {
            # а в режиме "без лимитов" - выкидываем последнюю кампанию
            $last_cid_for_exclude = $data{data_arrayref}->[-1]->{campaign_pId};
        } else {
            $last_pid_for_exclude = $data{data_arrayref}->[-1]->{context_pId};
        }
    }

    my (%wait_activization, %campaigns, %campaigns_to_sync, %domain2filerdomain_cache, %domain_bs_id_cache, %cid_to_engine_id);
    my ($curcid, $curpid) = (-1, -1);
    my %uniq_bids_ids = ();
    my ($camps_cnt, $contexts_cnt, $banners_cnt, $rows_cnt) = (0, 0, 0, 0);
    my ($forcedly_stopped_camps_cnt, $forcedly_stopped_banners_cnt, $forcedly_stopped_banner_images_cnt) = (0, 0, 0);
    my $it = enumerate_iter($data{data_arrayref});
    while (my (undef, $row) = $it->()) {
        $rows_cnt++;
        if (
            $curcid != $row->{campaign_pId}
            || $curpid != ($row->{context_pId} // 0)
        ) {
            undef $one_context_profile;

            if ($data{no_limits}) {
                if ($last_cid_for_exclude && $row->{campaign_pId} == $last_cid_for_exclude) {
                    $CAMPAIGNS_IN_REST{$last_cid_for_exclude} = undef;
                    while (my (undef, $row) = $it->()) {
                        # дочитываем итератором массив до конца
                    }
                    last;
                }
            } else {
                if (
                    scalar(keys %uniq_bids_ids) >= $BIDS_LIMIT # вычисление числа ключей - константно
                    || $contexts_cnt >= $CONTEXTS_LIMIT
                    || $banners_cnt >= $BANNERS_LIMIT
                    || $last_pid_for_exclude && $row->{context_pId} && $last_pid_for_exclude == $row->{context_pId}
                ) {
                    $CAMPAIGNS_IN_REST{$row->{campaign_pId}} = undef;
                    while (my (undef, $row) = $it->()) {
                        $CAMPAIGNS_IN_REST{$row->{campaign_pId}} = undef;
                    }
                    last;
                }

            }

            $BS::Export::CURRENT_CID = $curcid = $row->{campaign_pId};
            $curpid = $row->{context_pId} // 0;
            $campaigns_to_sync{$curcid} = undef;

            $one_context_profile = Yandex::Trace::new_profile('bs_export_query:get_query', tags => 'processing_rows_from_one_group');
        }

        # ВАЖНО: отсюда и до конца цикла while($it->()) не должно быть передачи управления
        # куда-либо (next, last, goto) минуя сохранение данных в @SECOND_QUERY_DATA в самом конце цикла

        $row->{search_strategy} = detect_search_strategy(_get_camp($row));
        unless (exists $campaigns{$curcid}) {
            $campaigns{$curcid} = {};
            for my $key (qw/c_type strategy ContextPriceCoef autoOptimization currency autobudget day_budget wallet_day_budget
                    ClientID send_extended_relevance_match_flag dialog_skill_id dialog_bot_guid/) {
                $campaigns{$curcid}->{$key} = _camp($row, $key);
            }
            $campaigns{$curcid}->{$_} = 1 for split ",", _camp($row, 'opts');
            $campaigns{$curcid}->{strategy} ||= '';
        }

        if ($IGNORE_BS_SYNCED
            || ( any {_camp($row, 'c_statusBsSynced') eq $_} qw(Sending No) )
        ) {
            my $is_new = extract_order($query, $row);
            $CAMPAIGNS_SENT{$row->{campaign_pId}} = undef;
            if (!_camp($row, 'campaign_Id')) {
                $NEW_CAMPAIGNS{$row->{campaign_pId}} = undef;
            }

            if ($is_new) {
                if (_camp($row, 'c_statusActive_sync')) {
                    $wait_activization{$row->{campaign_pId}} = undef;
                }
                ++$camps_cnt;
            }
        }

        state $stop_rejected_banners_prop = Property->new('BS_TRANSPORT_STOP_REJECTED_BANNERS');
        my $stop_rejected_banners = $stop_rejected_banners_prop->get(60) // 0;

        if ( defined $row->{b_statusBsSynced}
            && ($IGNORE_BS_SYNCED || $row->{b_statusBsSynced} eq 'Sending')
            && (
                    (
                        # Если у баннера statusPostModerate = Rejected, то для него нужно отправить стоп
                        (defined $row->{banner_PostModerate} && $row->{banner_PostModerate} =~ /^(Yes|Rejected)$/)
                        # Если у привязанного к баннеру креатива стоит statusModerate = AdminReject,
                        # для баннера нужно отправить стоп
                        || _is_creative_admin_rejected($row)
                    )
                    && ( # внутри этих скобок - DIRECT-47986
                        (!_is_dynamic_banner($row) && !_is_performance_banner($row))
                        || (defined $row->{phrases_PostModerate} && $row->{phrases_PostModerate} eq 'Yes')
                    )
                    && (# у баннера есть ссылка
                        $row->{Href}
                        # или промодерированная визитка с телефоном
                        || _has_moderated_vcard_with_phone_and_no_manual_permalink($row)
                        # или вручную заданный пермалинк
                        || _has_published_manual_permalink($row)
                        # или распубликованный пермалинк, который уже уходил в БК
                        || _has_unpublished_manual_permalink_sent_to_bs($row)
                        # или турболендинг
                        || _has_turbolanding($row)
                        # или это динамический баннер
                        || _is_dynamic_banner($row)
                        # или баннер рекламирует мобильный контент
                        || _is_mobile_content_banner($row)
                        # или это перфоманс-баннер
                        || _is_performance_banner($row)
                        # или РМП с картинкой
                        || _is_image_ad_mobile_content_banner($row)
                        # или РМП с видеокреативом
                        || _is_cpc_video_mobile_content_banner($row)
                        # или cpm_outdoor баннер
                        || _is_cpm_outdoor_banner($row)
                        # или internal баннер
                        || _is_internal_banner($row)
                        # или cpm_indoor баннер
                        || _is_cpm_indoor_banner($row)
                       )
                 || $row->{banner_statusShow} eq 'No'
                 # Если у баннера statusPostModerate = Rejected, то для него нужно отправить стоп
                 || ($stop_rejected_banners && defined $row->{banner_PostModerate} && $row->{banner_PostModerate} eq 'Rejected')
                 || _is_banner_with_rejected_turbolanding_only($row)
               )
            && (
                  ( # условие для новых - все составные части приняты на модерации и включены, т.е. можно сформировать валидный баннер
                    !$row->{banner_Id}
                    && defined $row->{phrases_PostModerate} && $row->{phrases_PostModerate} eq 'Yes'
                    && _are_we_can_show_current_banner($row)
                  )
                  ||
                  ( # условие для баннеров, которые уже были в БК менее строгие (допускаются показы предыдущей версии, когда postModerate != Yes)
                    $row->{banner_Id}
                    && (# баннеры НЕ графических объявлений (в том числе "старые картиночные", где картинка - отдельный баннер БК) - любые
                        !(_is_image_ad_or_mcbanner_banner($row) || _is_cpm_banner($row) || _is_cpm_outdoor_banner($row) || _is_cpm_indoor_banner($row) || _is_cpm_audio_banner($row))
                        # для графических объвлений - остановку (включая postModerate=Rejected) можно отправлять
                        # при любом состоянии картинки/креатива, т.к. UpdateInfo=0 и специфичные поля не передаются
                        || _is_image_ad_or_mcbanner_or_cpm_banner_stopped(undef, $row) # undef так как нет еще баннера
                        # если требуется отправка включенного объявления - картинка/креатив должны быть приняты на модерации, DIRECT-58058
                        || $row->{image_ad_statusModerate} eq 'Yes'
                       )
                    && ( # если у баннера есть минус-регионы, и похоже что хотим послать баннер с UpdateInfo=1
                         # (т.е. баннер принят на модерации и не остановлен), то проверяем что группа также будет отправлена с UpdateInfo=1,
                         # поскольку обновленный геотаргетинг должен отправиться на уровне группы
                         # кейс редкий, поскольку в транспорте модерации в таком случае группе должен быть
                         # проставлен statusPostModerate=Rejected, но, как минимум, полезен пока группа
                         # ожидает результатов модерации
                         # DIRECT-69547 — также можно посылать баннер, если ни группа, ни минус-регионы не поменялись
                         ($MINUS_GEO->{$row->{context_pId}}->{$row->{banner_pId}}->{current} // '') eq ($MINUS_GEO->{$row->{context_pId}}->{$row->{banner_pId}}->{bs_synced} // '')
                         || !_are_we_can_show_current_banner($row)
                         || _are_we_can_send_phrases($row)
                        )
                  )
               )
            && ( # сайтлинки отсутствуют, прошли модерацию, либо баннер надо остановить
                  ! $row->{sitelinks_set_id}
                  || $row->{statusSitelinksModerate} =~ /^(Yes|No)$/
                  || $row->{banner_statusShow} eq 'No'
                  # если отправка картинки в родительском баннере и картинка удалена 
                  || ( $row->{is_single_image_ad_to_bs} && $row->{image_statusShow} eq 'No' )
                  || ($stop_rejected_banners && defined $row->{banner_PostModerate} && $row->{banner_PostModerate} eq 'Rejected')
               )
            && ( _camp($row, 'campaign_Id') || exists $CAMPAIGNS_SENT{$row->{campaign_pId}} )
        ) {
            if (_has_valid_context($row)) {
                my $is_image_sent = _extract_banner($row, $query,
                                                    domain_cache => \%domain2filerdomain_cache,
                                                    domain_bs_id_cache => \%domain_bs_id_cache,
                                                    dialog_skill_id => $campaigns{$curcid}->{dialog_skill_id},
                                                    dialog_bot_guid => $campaigns{$curcid}->{dialog_bot_guid},
                                                    cid_pid_bid_to_image_id_as_one => \%CID_PID_BID_TO_IMAGE_ID_AS_ONE,
                                                    );

                # считаем картиночные баннеры
                $banners_cnt += $is_image_sent;
                # и обычные
                $banners_cnt++ unless exists $BANNERS_SENT{$row->{banner_pId}};

                $BANNERS_SENT{$row->{banner_pId}} = undef;
                if ($is_image_sent) {
                    $BANNER_IMAGES_SENT{$row->{image_id}} = undef;
                    if (!$row->{image_BannerID}) {
                        $NEW_BANNERS{$row->{image_id}} = undef;
                    }
                }
                if (!$row->{banner_Id}) {
                    $NEW_BANNERS{$row->{banner_pId}} = undef;
                }
                $BANNER_IMAGES_MAP{$row->{image_id}} = $row->{banner_pId}  if $row->{image_id};
            } elsif (!_are_we_want_to_send_phrases($row)) {
                _save_resync_data_for_absent_banner($row);
            }
        }

        if (_are_we_can_send_phrases($row)
            && ($row->{banner_Id} || ($row->{banner_pId} && exists $BANNERS_SENT{$row->{banner_pId}}))) {
            my $context;
            $contexts_cnt += _extract_context(
                $row, 
                $query,
                banner_images_sent => \%BANNER_IMAGES_SENT,
                context_ref => \$context,
                cid_pid_bid_to_image_id_as_one => \%CID_PID_BID_TO_IMAGE_ID_AS_ONE,
            );

            my $pid = $row->{context_pId};
            if ($context && exists $PHRASES->{$pid} && @{ $PHRASES->{$pid} }) {
                my $extracting_phrases_profile = Yandex::Trace::new_profile('bs_export_query:get_query',
                                                                            tags => 'extracting_phrases',
                                                                            obj_num => scalar(@{ $PHRASES->{$pid} }),
                                                                            );
                my $audience_segment_goal_ids = _should_send_audience_segment_goal_ids($context) ? {} : undef;

		state $content_keywordID = {content_category => 982, content_genre => 983};
		my @extra_goal_context;
		for my $ph (@{$PHRASES->{$pid}}) {
		    if ($ph->{phrase_type} eq 'adgroup_additional_targetings'
			&& $ph->{targeting_type} eq 'content_categories') {

			my @content_categories;
			for my $goal_id (@{ from_json($ph->{value}) }) {
			    my $crypta_type = $CRYPTA_GOALS->{$goal_id}->{crypta_goal_type};
			    push @content_categories, {bb_keyword => $content_keywordID->{$crypta_type}, bb_keyword_value => $goal_id, goal_id => $goal_id};
			}

			if ($ph->{value_join_type} eq 'any') {
			    push @extra_goal_context, {
				goals => \@content_categories,
				type => 'or'
			    }
			}
			elsif ($ph->{value_join_type} eq 'all') {
			    push @extra_goal_context, map {+{
				goals => [$_],
				type => 'or'
                            }} @content_categories;
			}
		    }
		}

                foreach my $ph (@{ $PHRASES->{$pid} }) {
                    # NB! неоптимально с точки зрения потребления CPU переписывать все фразы
                    # несколько раз по числу баннеров. хорошо бы это делать один раз, но так как
                    # для копирования CTR нужна информация о всех баннерах в контексте - это нужно делать
                    # для $prev_pid когда $cur_pid != $prev_pid
                    my $phrase_added = _extract_phrase($campaigns{$curcid}, $context, $ph, \%BANNER_IMAGES_MAP, $row,
                         $audience_segment_goal_ids, \@extra_goal_context);
                    if ($phrase_added) {
                        $uniq_bids_ids{$ph->{phrase_pId}} = undef;
                    }
                    if ($context->{TargetingExpression}) {
                        my $expression = $context->{TargetingExpression}->value;
                        @$expression = xsort {($_->[0]->[0])} @$expression;
                    }
                }
                if (defined $audience_segment_goal_ids) {
                    $context->{AudienceSegmentGoalIds} = _nosoap([ map {$_ + 0} nsort keys %{$audience_segment_goal_ids} ]);
                }
            }

            # AdditionalTargetings не нужен при отправке content_categories таргетингов
            # этот хеш наполняется в _extract_phrase
            $context->{AdditionalTargetings}->value(
                hash_grep { $_->{TargetingType} ne 'content_categories' } $context->{AdditionalTargetings}->value
            );
        }

        if (exists $row->{__forced_stop_camp}
            || exists $row->{__forced_stop_banner}
            || exists $row->{__forced_stop_banner_image}
        ) {
            # Кампания и/или баннер (текстовый и/или картиночный), добавленные в $query из текущей $row
            # были добавлены с принудительно выставленным Stop=1 (вместо Stop=0) - чтобы создать объект
            # выключенным и включить отдельным запросом, для которого сохраним данные:
            push @SECOND_QUERY_DATA, $row;

            # Справочно считаем статистику по объектам, для которых делали замену Stop 0->1
            # А также запоминаем идентификаторы объектов с подменой (нужно в _determine_sent_objects модуля BS::ExportWorker)
            if (exists $row->{__forced_stop_camp}) {
                ++$forcedly_stopped_camps_cnt;
                $FORCEDLY_STOPPED_CAMPS{ $row->{campaign_pId} } = undef;
            }
            if (exists $row->{__forced_stop_banner}) {
                ++$forcedly_stopped_banners_cnt;
                $FORCEDLY_STOPPED_BANNERS{ $row->{banner_pId} } = undef;
            }
            if (exists $row->{__forced_stop_banner_image}) {
                ++$forcedly_stopped_banner_images_cnt;
                $FORCEDLY_STOPPED_BANNERS{ $row->{image_id} } = undef;
            }
        }

        $cid_to_engine_id{ $row->{campaign_pId} } = $PRODUCTS_BY_ID->{ $row->{ProductID} }->{EngineID};
    }
    undef $one_context_profile;
    undef $BS::Export::CURRENT_CID;

    my $minus_geo_profile = Yandex::Trace::new_profile('bs_export_query:get_query', tags => '_apply_minus_geo_to_query');
    _apply_minus_geo_to_query($query, \%FORCEDLY_STOPPED_BANNERS);
    undef $minus_geo_profile;

    my $autobudget_restart_data;
    if ($DONT_CALCULATE_AUTOBUDGET_RESTART) {
        $autobudget_restart_data = _get_calculated_autobudget_restart($query);
    } else {
        my $profile = Yandex::Trace::new_profile('bs_export_query:get_query', tags => '_calc_autobudget_restart');
        $autobudget_restart_data = _calc_autobudget_restart($query);
    }
    apply_autobudget_restart($query, $autobudget_restart_data);

    my $resync_banners_with_phrases = [values %BANNERS_FOR_RESYNC_WITH_CONTEXT];
    %BANNERS_FOR_RESYNC_WITH_CONTEXT = ();

    $log->out("packet: camps: $camps_cnt, contexts: $contexts_cnt, banners: $banners_cnt, bids: ".scalar(keys %uniq_bids_ids));
    if (@SECOND_QUERY_DATA) {
        $log->out(sprintf('saved %d rows for second query; forced Stop for %d camps, %d banners, %d banner_images',
                          scalar(@SECOND_QUERY_DATA),
                          $forcedly_stopped_camps_cnt,
                          $forcedly_stopped_banners_cnt,
                          $forcedly_stopped_banner_images_cnt,
                          ));
    }

    # Убираем в запросе query картиночные версии баннеров, image_id которых есть в CID_PID_BID_TO_IMAGE_ID_AS_ONE
    my $deleted_image_ids = change_query_with_single_ad_image(
                                $query,
                                cid_pid_bid_to_image_id_as_one => \%CID_PID_BID_TO_IMAGE_ID_AS_ONE,
                            );
    # Если убирали картиночные версии баннеров то так же убираем их и в остальных полях
    for my $image_id ( @$deleted_image_ids ) {
        delete $NEW_BANNERS{$image_id};
        delete $BANNER_IMAGES_SENT{$image_id};
        delete $FORCEDLY_STOPPED_BANNERS{$image_id};
        --$banners_cnt;
    }

    return (
        $query,
        wait_activization => \%wait_activization,
        images_sent => \%BANNER_IMAGES_SENT,
        campaigns_to_sync => \%campaigns_to_sync,
        campaigns_in_rest => \%CAMPAIGNS_IN_REST,
        new_campaigns => \%NEW_CAMPAIGNS,
        new_banners => \%NEW_BANNERS,
        quantity => {
            camps => $camps_cnt,
            contexts => $contexts_cnt,
            banners => $banners_cnt,
            bids => scalar(keys %uniq_bids_ids),
        },
        second_query_data => \@SECOND_QUERY_DATA,
        forcedly_stopped_camps => \%FORCEDLY_STOPPED_CAMPS,
        forcedly_stopped_banners => \%FORCEDLY_STOPPED_BANNERS,
        resync_banners_with_phrases => $resync_banners_with_phrases,
        cid_to_engine_id => \%cid_to_engine_id,
        autobudget_restart_data => $autobudget_restart_data,
        cid_pid_bid_to_image_id_as_one => \%CID_PID_BID_TO_IMAGE_ID_AS_ONE,
    );
}


=head2 change_query_with_single_ad_image($query, %options)

    Меняет в запросе картиночные баннеры. Вместо 2ух (картиночный и безкартиночный) оставляет один (безкартиночный) с добавлением 
    в родительский баннер всех нужных полей от картиночной версии.
    Меняет только картиночные баннеры, переданные в options.cid_pid_bid_to_image_id_as_one

    Параметры именованные:
        cid_pid_bid_to_image_id_as_one - ссылка на хеш соответствий cid/pid/bid => image_id, с id картинки, которую удаляем из query

    Результат:
        список image_id от картиночных версий баннеров, которые были удалены из запроса

=cut
sub change_query_with_single_ad_image {
    my ($query, %options) = @_;

    my @deleted_image_id;
    if(! keys %{$options{cid_pid_bid_to_image_id_as_one}} ) {
        return \@deleted_image_id;
    }
    my $cid_pid_bid_to_image_id_as_one = $options{cid_pid_bid_to_image_id_as_one};
    my $hide_double_image_fields_enabled = _hide_double_image_fields_enabled();

    ORDERS: for my $order ( values %{$query->{ORDER}} ) {
        next ORDERS unless $order->{EID} && $cid_pid_bid_to_image_id_as_one->{$order->{EID}};
        my $pid_bid_to_image_id_as_one = $cid_pid_bid_to_image_id_as_one->{$order->{EID}};

        CONTEXTS: for my $context ( values %{$order->{CONTEXT}} ) {
            next CONTEXTS unless $context->{EID} && $pid_bid_to_image_id_as_one->{$context->{EID}};
            my $bid_to_image_id_as_one = $pid_bid_to_image_id_as_one->{$context->{EID}};

            # Собираем картиночные баннеры, которые будут отправляться в одном родительском баннере (вместо двух: картиночный и безкартиночный)
            my %bid_to_image_as_one;
            PARENT_BANNERS: for my $banner ( values %{$context->{BANNER}} ) {
                next PARENT_BANNERS unless $banner->{EID} && $banner->{ParentExportID} && $bid_to_image_id_as_one->{$banner->{ParentExportID}};
                $bid_to_image_as_one{$banner->{ParentExportID}} = $banner;
            }

            next CONTEXTS unless %bid_to_image_as_one;

            # Убираем картиночные версии баннеров, собранные в bid_to_image_as_one, с мерджем нужных полей в родительский баннер
            BANNERS: for my $banner_key ( keys %{$context->{BANNER}} ) {
                my $banner = $context->{BANNER}->{$banner_key};
                my $bid = $banner->{EID};

                # Если это картиночная версия для отправки в одном баннере - пропускаем
                if ( $banner->{ParentExportID} 
                    && $bid_to_image_as_one{$banner->{ParentExportID}} ) {
                    push @deleted_image_id, $bid;
                    delete $context->{BANNER}->{$banner_key};
                    next BANNERS;
                }

                # Если это не баннер для отправки в новом виде (в одном баннере)
                next BANNERS unless $bid && $bid_to_image_as_one{$bid};
                my $banner_image = $bid_to_image_as_one{$bid};

                # Переносим картиночные поля в родительский баннер
                # Не проверяем banner_image на Stop=1. Если баннер удален то картиночные данные с ним и так не передаются
                if ( $banner_image->{Images} ) {
                    $banner->{Images} = $banner_image->{Images};
                    
                    if ( $hide_double_image_fields_enabled ) {
                        delete $banner->{Resources}->{ImagesInfo}->{Images};
                    }
                }
                if ( $banner_image->{ImageType} ) {
                    $banner->{ImageType} = $banner_image->{ImageType};
                    
                    if ( $hide_double_image_fields_enabled ) {
                        delete $banner->{Resources}->{ImagesInfo}->{ImageType};
                    }
                }
                if ( $banner_image->{MdsMeta} ) {
                    $banner->{MdsMeta} = $banner_image->{MdsMeta};
                    
                    if ( $hide_double_image_fields_enabled ) {
                        delete $banner->{Resources}->{ImagesInfo}->{MdsMeta};
                    }
                }
                if ( $banner_image->{Resources}->{AssetHashes} ) {
                    hash_merge $banner->{Resources}->{AssetHashes}, $banner_image->{Resources}->{AssetHashes};
                }
                if ( !$banner->{Resources}->{AutoVideoCreative} && $banner_image->{Resources}->{AutoVideoCreative} ) {
                    $banner->{Resources}->{AutoVideoCreative} = $banner_image->{Resources}->{AutoVideoCreative};
                }
                if ( $banner_image->{IsAutoVideo} ) {
                    $banner->{IsAutoVideo} = $banner_image->{IsAutoVideo};
                }
            }
        }
    }
    return \@deleted_image_id;
}


=head2 get_second_query(%data)

    Сформировать второй ("включающий") запрос для отправки данных в БК

    my ($query, %additional) = get_query(...);
    ...
    my %indicators = process_bs_response($r, $query, %additional, ...);
    ...
    my ($second_query, %second_additional) = get_second_query(data_arrayref => $additional{second_query_data},
                                                              new_campaigns => $additional{new_campaigns},
                                                              new_banners => $additional{new_banners},
                                                              campaigns_in_second_query => \%SECOND_QUERY_CAMPS,
                                                              campaigns_to_sync => $additional{campaigns_to_sync},
                                                              );
    Параметры именованныые :
        data_arrayref   - ссылка на массив хешей с данными по кампаниям/группам/баннерам, дополненных флагами
                          принудительной остановки данных. Это "second_query_data" из результатов get_query.
        contexts_eid2id - ссылка на хеш соответствий pid => ContextID
        new_campaigns   - ссылка на хеш соответствий cid => OrdeID для новых кампаний.
                          при разборе данных по этому хешу определяется сам факт, что кампания была новой
                          а также берется ее БКшный идентификатор для подстановки в сформированный запрос
        new_banners     - ссылка на хеш соответствий bid/image_id => BannerID, используется аналогично new_campaigns
        campaigns_in_second_query - ссылка на хеш, в который в качестве ключей будут записаны номера (cid) кампаний
                                    попавших во второй запрос к БК. модифицируется in-place.
        campaigns_to_sync - ссылка на хеш, ключами которого являются номера кампаний, которые можно
                            синхронизировать с БК. Это "campaigns_to_sync" из результатов get_query после удаления
                            из него кампаний, по которым были получены ошибки или UnDone.
                            модифицируется in-place - из него удаляются кампании, если не по всем "новым"
                            объектам удалось сформировать запрос с данными (например нет BannerID, так как была
                            получена ошибка на предыдущем запросе)
    Результат:
        $query_hashref      - сформированный запрос к БК
        quantity => {       # количество объектов (c UpdateInfo = 1) в запросе к БК
            camps => ...,       # количество кампаний
            banners => ...,     # количество баннеров
        }

=cut
sub get_second_query {
    my %data = @_;

    my $profile = Yandex::Trace::new_profile('bs_export_query:get_second_query');

    # основа будущего запроса
    my $query = BS::Export::get_empty_query_struct_for_UpdateData2($PAR_TYPE);

    # счетчики для статистики
    my ($camps_cnt, $banners_cnt) = (0, 0);

    # времнное хранилище под-запросов, сгруппированных по cid'у
    my %QUERY_BY_CID;
    # хеш, ключами которого являются номера (cid) кампаний, которые должны быть удалены из campaigns_to_sync
    my %SKIP_SYNC;

    for my $row (@{ $data{data_arrayref} }) {
        my $cid = $row->{campaign_pId};
        $BS::Export::CURRENT_CID = $cid;

        if (!exists $data{campaigns_to_sync}->{$cid}) {
            # полностью пропускаем объекты, которые не были успешно синхронизированы при первом запросе
            next;
        }

        my $OrderID = _camp($row, 'campaign_Id') || $data{new_campaigns}->{$cid};
        if (!$OrderID) {
            # логически такой кейс не возможен
            # не будем помечать эту кампанию как успешно синхронизированную, уйдёт на "еще одну итерацию"
            $SKIP_SYNC{$cid} = undef;
            next;
        }

        # Создаем структуру для формирования запроса по одной кампании
        $QUERY_BY_CID{$cid} //= {};

        # данные по заказу
        my $order;
        if (exists $row->{__forced_stop_camp}) {
            # кампания была принудительно созданна как выключенная
            # все данные по заказу есть в строке, отправляем кампанию целиком
            extract_order($QUERY_BY_CID{$cid}, $row, ID => $OrderID, EID => $cid, order_ref => \$order);
            ++$camps_cnt;
            # ставим флажок что у нас есть хоть что-то содержательное для отправки по этой кампании
            $data{campaigns_in_second_query}->{$cid} = undef;
        } else {
            # используем минимальный набор данных по кампании
            $order = extract_base_order($QUERY_BY_CID{$cid}, $row, ID => $OrderID, EID => $cid);
        }

        if (exists $row->{__forced_stop_banner} || exists $row->{__forced_stop_banner_image}) {
            my $pid = $row->{context_pId};
            my $ContextID = $row->{context_Id} || $data{contexts_eid2id}->{$pid};
            if (!$ContextID) {
                $SKIP_SYNC{$cid} = undef;
                next;
            }

            # данные по условию
            my $context = extract_base_context($order, $row, ID => $ContextID, EID => $pid);

            # текстовый баннер
            if (exists $row->{__forced_stop_banner}) {
                my $bid = $row->{banner_pId};
                my $BannerID = $row->{banner_Id} || $data{new_banners}->{$bid};
                if ($BannerID) {
                    extract_base_banner($context, $row, ID => $BannerID, EID => $bid);
                    ++$banners_cnt;
                    # ставим флажок что у нас есть хоть что-то содержательное для отправки по этой кампании
                    $data{campaigns_in_second_query}->{$cid} = undef;
                } else {
                    $SKIP_SYNC{$cid} = undef;
                }
            }
            # картиночный баннер
            if (exists $row->{__forced_stop_banner_image}) {
                my $bid = $row->{image_id};
                my $BannerID = $row->{image_BannerID} || $data{new_banners}->{$bid};
                if ( !$BannerID && $row->{is_single_image_ad_to_bs} ) {
                    $BannerID = $row->{banner_Id} || $data{new_banners}->{$row->{banner_pId}};
                }
                if ($BannerID) {
                    extract_base_banner($context, 
                                        $row, 
                                        ID => $BannerID, 
                                        EID => $bid, 
                                        is_image => 1, 
                                        cid_pid_bid_to_image_id_as_one => $data{cid_pid_bid_to_image_id_as_one},
                                        );
                    ++$banners_cnt;
                    # ставим флажок что у нас есть хоть что-то содержательное для отправки по этой кампании
                    $data{campaigns_in_second_query}->{$cid} = undef;
                } else {
                    $SKIP_SYNC{$cid} = undef;
                }
            }
        }
    }
    undef $BS::Export::CURRENT_CID;

    # Отсеиваем заказы, по которым не извлекли баннеры, а состояние самого заказ мы менять не хотим
    # Все остальные - объединяем в один запрос
    for my $cid(keys %{ $data{campaigns_in_second_query} }) {
        hash_merge($query->{ORDER}, $QUERY_BY_CID{$cid}->{ORDER});
    }

    apply_autobudget_restart($query, $data{autobudget_restart_data});

    # Все подозрительные кампании удаляем из campaigns_to_sync, тем самым они могут быть разлочены,
    # но не удалены из очереди - и "уйдут" на следующую итерацию.
    delete @{ $data{campaigns_to_sync} }{ keys %SKIP_SYNC };

    return ($query,
            quantity => {
                camps => $camps_cnt,
                banners => $banners_cnt,
            },
            );
}

=head2 _get_strategy_data($row)

    Извлекает из row данные о стратегии и переводит json в хеш

=cut
sub _get_strategy_data($) {
    my $row = shift;

    return from_json(_camp($row, 'strategy_data') || '{}');
}

sub _calc_autobudget_restart($) {
    my ($query) = @_;

    my @orders;
    for my $order (values %{$query->{ORDER}}) {
        if (!$order->{UpdateInfo}) {
            next;
        }
        next unless $order->{ID};
        push @orders, $order;
    }
    return unless @orders;

    my $ret = eval {
        _calc_autobudget_restart_internal(\@orders);
    };
    if (!$ret) {
        my $msg = "Can't get autobudget restart data: $@";
            $log->die($msg);
    } else {
        return $ret;
    }
}

sub _calc_autobudget_restart_internal($) {
    my ($orders) = @_;

    my @campaigns;
    for my $order (@$orders) {
        eval {
            my $row = { campaign_pId => $order->{EID} };

            my $strategy;
            if (!(my $strategy_data = _camp($row, 'strategy_data'))) {
                my $camp_type = _camp($row, 'c_type');
                if (!Campaign::is_wallet_camp(type => $camp_type)) {
                    $log->warn("Problem with autobudget restart, cid=$order->{EID}: empty strategy, set default");
                }
                $strategy = {name => 'default'};
            } else {
                $strategy = from_json($strategy_data);
            }

            my %opts = map {$_ => 1} split ",", _camp($row, 'opts');

            my $start_time = _camp($row, 'Start_time');
            $start_time = "2000-01-01" if !$start_time || $start_time =~ /^0000/;

            my $finish_time = _camp($row, 'finish_date');
            $finish_time = undef if !$finish_time || $finish_time =~ /^0000/;

            my $has_money = _calculate_has_money($row);

            push @campaigns, {
                cid          => $order->{EID},
                strategy_dto => {
                    strategy           => $strategy->{name},
                    manual_strategy    => _camp($row, 'strategy'),
                    platform           => _camp($row, 'platform'),

                    start_time         => unix2human(mysql2unix($start_time), "%Y-%m-%d"),
                    finish_time        => $finish_time ? unix2human(mysql2unix($finish_time), "%Y-%m-%d") : undef,
                    day_budget         => _camp($row, 'day_budget'),
                    auto_budget_sum    => $strategy->{'sum'},
                    enable_cpc_hold    => $opts{enable_cpc_hold},
                    time_target        => _camp($row, 'timeTarget'),
                    status_show        => _camp($row, 'Stop') eq 'Yes' ? 1 : 0,

                    pay_for_conversion => $strategy->{pay_for_conversion} ? 1 : 0,
                    goal_id            => $strategy->{goal_id},
                    roi_coef           => $strategy->{roi_coef},
                    limit_clicks       => $strategy->{limit_clicks},
                    avg_cpm            => $strategy->{avg_cpm},
                    avg_bid            => $strategy->{avg_bid},
                    avg_cpa            => $strategy->{avg_cpa},
                    avg_cpv            => $strategy->{avg_cpv},
                    strategy_start     => $strategy->{start},
                    strategy_finish    => $strategy->{finish},

                    # calculated
                    has_combined_goals => _camp($row, 'autobudget_goal_expression') ? 1 : 0,
                    has_money          => $has_money ? 1 : 0,

                    strategy_id        => _camp($row, 'strategy_id'),
                }
            };
        };
        if ($@) {
            $log->warn("Can't make request to autobudget restart, cid=$order->{EID}: $@");
        }
    }
    if (!@campaigns) {
        return;
    }

    return retry tries => 3, sub {
        my $result = JavaIntapi::AutobudgetRestartCalculate->new(campaigns => \@campaigns)->call;
        my %ret;
        for my $cid (keys %$result) {
            my $restart_props = $result->{$cid};
            if ($restart_props->{error}) {
                $log->warn("Error of calculation autobudget restart, cid=$cid: $restart_props->{error}");
            } else {
                $ret{$cid} = _format_autobudget_restart($restart_props);
            }
        }
        return \%ret;
    };
}

sub _get_calculated_autobudget_restart($) {
    my ($query) = @_;
    my %ret;
    for my $order (values %{$query->{ORDER}}) {
        my $cid = $order->{EID};
        if (exists $CAMP_AUTOBUDGET_RESTARTS->{$cid}) {
            my $restart_props = $CAMP_AUTOBUDGET_RESTARTS->{$cid};
            $ret{$cid} = _format_autobudget_restart($restart_props);
        }
    }
    return \%ret;
}

sub _format_autobudget_restart($) {
    my ($restart_props) = @_;
    return {
        AutoBudgetRestartTime     =>  unix2human(mysql2unix($restart_props->{restart_time}), "%Y%m%d%H%M%S"),
        AutoBudgetSoftRestartTime =>  unix2human(mysql2unix($restart_props->{soft_restart_time}), "%Y%m%d%H%M%S"),
        AutoBudgetRestartReason   =>  $restart_props->{restart_reason},
    };
}

=head2 _calculate_has_money

    Считаем, есть ли на кампании (или общем счёте) средства

=cut
sub _calculate_has_money {
    my ($row) = @_;

    my $camp = _get_camp($row);

    return 1 if $camp->{sum} - $camp->{sum_spent} > $Currencies::EPSILON;


    my $client_info = {
        clientID            => $camp->{ClientID},
        debt                => $camp->{client_debt},
        overdraft_lim       => $camp->{overdraft_lim},
        auto_overdraft_lim  => $camp->{auto_overdraft_lim},
        statusBalanceBanned => $camp->{statusBalanceBanned}
    };

    my $wallet_sum = (_is_wallet_campaign($row) ? $camp->{sum} : $camp->{wallet_sum}) // 0;
    my $debt = $camp->{wallet_sum_debt} // $camp->{wallet_sum_debt_for_camp} // 0;
    my $wallet_info = {
        type            => "wallet",
        currency        => $camp->{currency},
        sum             => $wallet_sum,
        wallet_sum_debt => $debt
    };
    my $auto_overdraft_addition = WalletUtils::get_auto_overdraft_addition($wallet_info, $client_info);

    # debt - отрицательный, поэтому +debt
    my $sum_total = $wallet_sum + $debt + $auto_overdraft_addition;

    return $sum_total > $Currencies::EPSILON ? 1 : 0;
}

=head2 apply_autobudget_restart

    Прописать в запрос БК данные о рестарте автобюджета

=cut
sub apply_autobudget_restart {
    my ($query, $autobudget_restart_data) = @_;
    return unless $autobudget_restart_data;
    for my $order (values %{$query->{ORDER}}) {
        if (my $data = $autobudget_restart_data->{$order->{EID}}) {
            $order->{$_} = $data->{$_} for qw/AutoBudgetRestartTime AutoBudgetSoftRestartTime AutoBudgetRestartReason/;
        }
    }
}

=head2 _apply_minus_geo_to_query($query, $row, %options)

    Пробегается по всем CONTEXT из запроса, и применяет минус-регионы от баннеров, которые нужно применить

=cut

sub _apply_minus_geo_to_query($;$) {
    my ($query, $forcedly_stopped_banners) = @_;
    $forcedly_stopped_banners //= {};

    return unless keys %$MINUS_GEO;

    foreach my $o (values %{$query->{ORDER}}) {
        foreach my $c (values %{$o->{CONTEXT}}) {
            # Geo не обновлялось
            next unless $c->{UpdateInfo};

            # пропускаем группу, если по ней нет баннеров с минус-регионами
            next unless $MINUS_GEO->{$c->{EID}};

            my %group_minus_geo = ();
            my %processed_banners = ();
            foreach my $banner (values %{$c->{BANNER}}) {
                # пропускаем баннер, если по нему нет минус-регионов
                next unless $MINUS_GEO->{$c->{EID}}->{$banner->{EID}};
                # к группе применяем минус-регионы только по неостановленным баннерам (или тем, которые будут запущены вторым запросом)
                # но надо не забыть про старые, активные, не попавшие в запрос
                $processed_banners{$banner->{EID}} = undef;
                if ( !$banner->{Stop} || exists $forcedly_stopped_banners->{$banner->{EID}} ) {
                    my $minus_geo_type = $banner->{UpdateInfo} ? 'current' : 'bs_synced';
                    for my $region_id (grep { /^\d+$/} split /[\s,]+/, $MINUS_GEO->{$c->{EID}}->{$banner->{EID}}->{$minus_geo_type} // '') {
                        $group_minus_geo{$region_id} = undef;
                    }
                }
            }

            foreach my $mg_bid (keys %{$MINUS_GEO->{$c->{EID}}}) {
                # добавляем минус-регионы от "старых" активных баннеров, которые не обработаны в предыдущем цикле
                next if $MINUS_GEO->{$c->{EID}}->{$mg_bid}->{is_new} || exists $processed_banners{$mg_bid};
                for my $region_id (grep { /^\d+$/} split /[\s,]+/, $MINUS_GEO->{$c->{EID}}->{$mg_bid}->{bs_synced} // '') {
                    $group_minus_geo{$region_id} = undef;
                }
            }

            if (keys %group_minus_geo) {
                my $group_geo = $c->{Geo} ? join(',', @{$c->{Geo}}) : '0';

                my ($new_group_geo) = GeoTools::exclude_region($group_geo, [nsort keys %group_minus_geo], {tree => 'api'});
                if ($new_group_geo eq '0') {
                    delete $c->{Geo};
                } else {
                    if ($new_group_geo eq '') {
                        # случай когда минус-регионы перекрыли все регионы указанные в геотаргетинге, и баннер не должен показываться нигде
                        # таргетируем баннеры на условную "Луну"
                        $c->{Geo} = [ $BS_MOON_REGION_ID ];
                    } else {
                        $c->{Geo} = [ split ',', $new_group_geo ];
                    }
                }
            }
        }
    }
}

=head2 _apply_minus_geo_by_bid($geo, $bid, $pid)

    По строке $geo и $bid баннера применяет минус-регионы баннера к гео-таргетингу, и возвращает результат в форме строки.
    Считаем что функция вызывается только при UpdateInfo=1 на баннере (используется для при формировании данных для BannerLand).

=cut

sub _apply_minus_geo_by_bid($$$) {
    my ($geo, $bid, $pid) = @_;

    if (my $banner_minus_geo = $MINUS_GEO->{$pid}->{$bid}->{current}) {
        $geo = GeoTools::exclude_region($geo || 0, [grep { /^\d+$/ } split /[\s,]+/, $banner_minus_geo], {tree => 'api'});
        $geo = "$BS_MOON_REGION_ID" if $geo eq '';
    }

    return $geo;
}


{
# кеш поклиентной истории НДС и скидок; используются в рамках одной итерации
my (%client_nds_history_cache, %client_discount_history_cache);

=head2 _drop_order_caches

    сбрасываем кеши в замыкании

=cut

sub _drop_order_caches {
    %client_nds_history_cache = ();
    %client_discount_history_cache = ();
}

=head2 extract_order($query, $row, %options)

    Создать заказ в крутилошном запросе или достать существующий, если есть.
    Заполнить ВСЕ поля.

    my $is_new = extract_order($query, $row);
    my $order;
    my $is_new = extract_order($query, $row, ID => 20063, EID => 263, order_ref => \$order);

    Параметры:
        $query          - hashref с данными, которые будут отправлены в БК
        $row            - hashref с данными о заказе/условии/баннере (элемент данных "снепшота")
        %options    - дополнительные именованные параметры:
          order_ref     - scalarref, который нужно сделать ссылкой на хеш - структуру с извлеченным заказом
          ID            - использовать указанный ID при извлечении/создании заказа вместо данных
                          о БКшном идентификаторе кампании (OrderID), содержащихся в $row.
                          работает ТОЛЬКО при совместном указании ID и EID
          EID           - использовать указанный EID при извлечении/создании заказа вместо данных
                          о Директовском идентификаторе кампани (cid), содержащихся в $row.
                          работает ТОЛЬКО при совместном указании ID и EID
    Результат:
        $is_order_extracted - 0/1 признак "были ли извлечены данные по заказу"

    Использует глобальные переменные:
        $CLIENT_NDS_CACHE
        $PERFORMANCE_COUNTERS

=cut
sub extract_order {
    my ($query, $row, %options) = @_;

    # вытаскиваем запись о текущем заказе, создаем её при необходимости
    my $order = extract_base_order($query, $row, ID => $options{ID}, EID => $options{EID});

    if (defined $options{order_ref}) {
        ${ $options{order_ref} } = $order;
    }

    # если все данные по заказу уже добавили - просто возвращаемся
    return 0 if $order->{uid};

    $order->{uid} = _camp($row, 'uid');
    $order->{statusOpenStat} = _camp($row, 'campaign_openstat') eq 'Yes' ? 1 : 0; # флаг для интеграции с внешними системами статистики( SpyLog, ... )
    # флаг, означающий, что реклама "своя" и будет показываться
    # только на контекстных площадках
    $order->{statusYandexAdv} = _camp($row, 'statusYandexAdv') eq 'Yes' ? 1 : 0;

    $order->{statusNoBehav} = 0; # флаг учёта предпочтений пользователя; учитывается всегда (0 - учёт, 1 - нет)
    $order->{Archive} = _camp($row, 'campaign_arc') eq 'Yes' ? 1 : 0;
    if ($order->{Stop} && _camp($row, 'stopTime') && _camp($row, 'stopTime') !~ /^0000/) {
        # время остановки кампании
        $order->{StopTime} = _camp($row, 'stopTime');
    }

    my $strategy_id = _camp($row, 'strategy_id');
    if ($strategy_id) {
        $order->{StrategyID} = _nosoap($strategy_id);
    }

    # передаем идентификатор региона кампании
    $order->{CountryRegionID} = TimeTarget::cached_tz_by_id(_camp($row, 'timezone_id'))->{country_id};

    # передаём список доменов конкурентов, если есть
    my @competitors_domains = _camp($row, 'competitors_domains') ? grep {$_} split(/[\s,]+/, _camp($row, 'competitors_domains')) : ();
    $order->{CompetitorsDomains} = {
        List => \@competitors_domains,
        ShowStrategy => scalar(@competitors_domains) > 0 ? 1 : 0
    };

    # передаём ключевые цели, если есть
    my $meaningful_goals = from_json(_camp($row, 'meaningful_goals') || '[]');
    if (@$meaningful_goals) {
        #IsMetrikaSourceOfValue отправляем только при наличии его в базе
        $order->{MeaningfulGoals} = [
            map {
                exists $_->{is_metrika_source_of_value} ?
                    { GoalID => $_->{goal_id}, Value => $_->{value} + 0, IsMetrikaSourceOfValue => $_->{is_metrika_source_of_value} ? 1 : 0} :
                    { GoalID => $_->{goal_id}, Value => $_->{value} + 0 }
            } @$meaningful_goals,
        ];
        $order->{AutoBudgetPaidMeaningfulGoalsHash} = url_hash_utf8(_camp($row, 'meaningful_goals')) + 0;
    }

    # передаем хеш счетчиков метрики
    state $metrika_counters_hash_bs_export_enabled_prop = Property->new('bs_export_metrika_counters_hash_enabled');
    if ($metrika_counters_hash_bs_export_enabled_prop->get(60) || 0) {
        if (_camp($row, 'metrika_counters')) {
            my @metrika_counters = split /\s*,\s*/, _camp($row, 'metrika_counters');

            # Хеш выгружается вместе с счетчиками через ESS в таблицу DirectMetrikaCounters
            # При изменении хеша стоит продумать, как его поменять в обоих местах, не сломав ничего в БК
            my $counters_for_hash = join ",", nsort(@metrika_counters);
            $order->{MetrikaCountersHash} = half_md5hex_hash(md5_hex_utf8($counters_for_hash));
        }
    }

    # передаём флаг который требует передачи id клика из БК в метрику
    $order->{statusClickTrack} = _camp($row, 'status_click_track');

    # в базе: 0 - авто, 254 - показы запрещены, 255 - не ограничивать
    # передаём: 0 - авто, 254 -> 0 - авто, -1 - не ограничивать
    if (_camp($row, 'ContextLimit') == 255) {
        $order->{ContextLimit} = -1;
    } elsif (_camp($row, 'ContextLimit') == 254) {
        $order->{ContextLimit} = 0;
    } else {
        $order->{ContextLimit} = _camp($row, 'ContextLimit');
    }

    # коэффициенты к ставкам
    _merge_mobile_price_coef($row, order => $order);
    _merge_desktop_price_coef($row, order => $order);
    _merge_product_type_coef($row, order => $order, video => 'Video');
    if (_is_performance_campaign($row)) {
        _merge_product_type_coef($row, order => $order, performance_tgo => 'PerformanceTgo');
    }
    _merge_socdem_coef($row, order => $order);
    _merge_retargeting_coef($row, order => $order);
    _merge_geo_coef($row, order => $order);
    _merge_ab_segment_coef($row, order => $order);
    _merge_weather_coef($row, order => $order);
    _merge_expression_coefs($row, order => $order);
    _merge_inventory_coef($row, order => $order);
    _merge_trafaret_position_coef($row, order => $order);

    # параметры A/B тестирования
    _merge_experiments_data($order, $row);

    # стоимость потраченных на кампанни фишек в реальных деньгах
    $order->{CostPcs} = _camp($row, 'chips_cost');

    my $strategy_params = {};
    eval {
        if (!_is_wallet_campaign($row)) {
            $strategy_params = from_json(_camp($row, 'strategy_data'));
        }
        1;
    } or do {
        $log->warn("Cannot decode JSON string in strategy_data in cid $row->{campaign_pId}");
    };
    if (ref($strategy_params) ne 'HASH') {
        $log->warn("Not a hash reference when decoding JSON string in strategy_data in cid $row->{campaign_pId}");
        $strategy_params = {};
    }

    $order->{StrategyParams} = $strategy_params;

    # Работа с автобюджетом
    if ( _camp($row, 'autobudget') eq 'Yes') {
        $order->{AutoBudget} = 1;
        # сумма недельного бюджета для кампаний с "Быстрым привлечением" вычисляется нами,
        # поэтому если она слишком большая -- посылаем такое значение, чтобы не потратить все имеющиеся на кампании деньги меньше, чем за день
        my $autobudget_week_limit = $strategy_params->{sum};

        ($order->{AutoBudgetWeekLimit}, $order->{AutoBudgetWeekLimitCur}) = _get_conv_units_and_currency_values_for_sum(
            $autobudget_week_limit, _camp($row, 'currency'), _camp($row, 'future_currency'),
            with_nds => 1, ClientID => _camp($row, 'ClientID'), client_nds_cache => $CLIENT_NDS_CACHE,
            min_constant => 'MIN_AUTOBUDGET', max_constant => 'MAX_AUTOBUDGET',
        );

        if (my $cpa_value = $strategy_params->{avg_cpi} || $strategy_params->{avg_cpa} || $strategy_params->{filter_avg_cpa}) {
            ($order->{AutoBudgetAvgCPA}, $order->{AutoBudgetAvgCPACur}) = _get_conv_units_and_currency_values_for_sum(
                $cpa_value, _camp($row, 'currency'), _camp($row, 'future_currency'),
                with_nds => 1, ClientID => _camp($row, 'ClientID'), client_nds_cache => $CLIENT_NDS_CACHE,
                min_constant => 'MIN_AUTOBUDGET_AVG_CPA',
            );
        }

        if ($strategy_params->{avg_bid}) {
            ($order->{AutoBudgetAvgBid}, $order->{AutoBudgetAvgBidCur}) = _get_conv_units_and_currency_values_for_sum(
                $strategy_params->{avg_bid}, _camp($row, 'currency'), _camp($row, 'future_currency'),
                with_nds => 1, ClientID => _camp($row, 'ClientID'), client_nds_cache => $CLIENT_NDS_CACHE,
                min_constant => 'MIN_AUTOBUDGET_AVG_PRICE', max_constant => 'MAX_AUTOBUDGET_BID',
            );
        }

        if ((is_strategy_cpa(_get_camp($row)) || _get_camp($row)->{strategy_name} eq 'autobudget_avg_cpi') && $strategy_params->{pay_for_conversion}) {
            $order->{AutoBudgetPaidActions} = 1;
            if (is_strategy_cpa_per_filter(_get_camp($row))) {
                $order->{AutoBudgetPaidActionsPerFilter} = 1;
            }
        }

        if ($strategy_params->{avg_cpm}) {
            ($order->{AutoBudgetAvgCPM}, $order->{AutoBudgetAvgCPMCur}) = _get_conv_units_and_currency_values_for_sum(
                $strategy_params->{avg_cpm}, _camp($row, 'currency'), _camp($row, 'future_currency'),
                with_nds => 1, ClientID => _camp($row, 'ClientID'), client_nds_cache => $CLIENT_NDS_CACHE,
                min_constant => 'MIN_AUTOBUDGET_AVG_CPM', max_constant => 'MAX_CPM_PRICE',
            );
            $order->{AutoBudgetAvgCPM} = Currencies::round_to_currency_digit_count($order->{AutoBudgetAvgCPM} / $Settings::CPM_SHOWS_COEF, 'YND_FIXED');
            $order->{AutoBudgetAvgCPMCur} = Currencies::round_to_currency_digit_count($order->{AutoBudgetAvgCPMCur} / $Settings::CPM_SHOWS_COEF, _camp($row, 'future_currency') // _camp($row, 'currency'));
        }

        if ($strategy_params->{avg_cpv}) {
            ($order->{AutoBudgetAvgCPV}, $order->{AutoBudgetAvgCPVCur}) = _get_conv_units_and_currency_values_for_sum(
                $strategy_params->{avg_cpv}, _camp($row, 'currency'), _camp($row, 'future_currency'),
                with_nds => 1, ClientID => _camp($row, 'ClientID'), client_nds_cache => $CLIENT_NDS_CACHE,
                min_constant => 'MIN_AVG_CPV', max_constant => 'MAX_AVG_CPV',
            );
            if ($strategy_params->{pay_for_conversion}) {
                $order->{AutoBudgetPaidActions} = 1;
            }
        }

        state $calculate_cpa_max_bid = Property->new('calculate_implicit_cpa_max_bid_in_transport');
        my $do_calculate_cpa_max_bid = $calculate_cpa_max_bid->get(60) || 0;
        if ($strategy_params->{bid}) {
            ($order->{AutoBudgetMaxBid}, $order->{AutoBudgetMaxBidCur}) = _get_conv_units_and_currency_values_for_sum(
                $strategy_params->{bid}, _camp($row, 'currency'), _camp($row, 'future_currency'),
                min_constant => 'MIN_AUTOBUDGET_BID', max_constant => 'MAX_AUTOBUDGET_BID',
            );
        } elsif ($do_calculate_cpa_max_bid && $autobudget_week_limit && is_strategy_cpa(_get_camp($row))) {
            ($order->{AutoBudgetMaxBid}, $order->{AutoBudgetMaxBidCur}) = _get_conv_units_and_currency_values_for_sum(
                $autobudget_week_limit * 0.1, _camp($row, 'currency'), _camp($row, 'future_currency'),
                min_constant => 'MIN_AUTOBUDGET_BID', max_constant => 'MAX_AUTOBUDGET_BID',
            );
        }

        if ($strategy_params->{budget}) {
            ($order->{AutoBudgetPeriodBudgetLimit}, $order->{AutoBudgetPeriodBudgetLimitCur}) = _get_conv_units_and_currency_values_for_sum(
                $strategy_params->{budget}, _camp($row, 'currency'), _camp($row, 'future_currency'),
                with_nds => 1, ClientID => _camp($row, 'ClientID'), client_nds_cache => $CLIENT_NDS_CACHE,
            );
        }

        if (is_strategy_roi(_get_camp($row))) {
            $order->{AutoBudgetROILevel} = 1 / (1 + $strategy_params->{roi_coef});
            $order->{AutoBudgetReserveReturn} = ($strategy_params->{reserve_return} // $Campaign::AUTOBUDGET_RESERVE_RETURN_DEFAULT) / 100;
            $order->{AutoBudgetProfitability} = 1 - ($strategy_params->{profitability} // $Campaign::AUTOBUDGET_PROFITABILITY_DEFAULT) / 100;
        } elsif (is_strategy_crr(_get_camp($row))) {
            $order->{AutoBudgetROILevel} = $strategy_params->{crr} / 100;
            $order->{AutoBudgetReserveReturn} = 1;
            $order->{AutoBudgetProfitability} = 1;
            if ($strategy_params->{pay_for_conversion}) {
                $order->{AutoBudgetPaidActions} = 1;
                $order->{AutoBudgetPaidCrr} = 1;
            }
        } else {
            $order->{AutoBudgetROILevel} = 0;
            $order->{AutoBudgetReserveReturn} = 0;
            $order->{AutoBudgetProfitability} = 0;
        }

        # explicit string
        $order->{AutoBudgetWeekLimitClicks} = defined $strategy_params->{limit_clicks}
            ? "" . $strategy_params->{limit_clicks}
            : undef;

        if (($strategy_params->{name} eq 'autobudget_avg_cpi' && !defined $strategy_params->{goal_id}) ||
            (defined $strategy_params->{goal_id} && $strategy_params->{goal_id} == $Settings::DEFAULT_CPI_GOAL_ID)) {
            # БК пока не понимает BIGINT идентификаторы целей (BSDEV-49134)
            # для стратегии CPI договорились, что пока посылаем GoalID=4 (раньше было 3).
            $order->{AutoBudgetGoalID} = $BS::Export::BS_AVG_CPI_GOAL_ID;
        } elsif (defined $strategy_params->{goal_id}) {
            $order->{AutoBudgetGoalID} = $strategy_params->{goal_id};
        }

        #значения параметров для cpm-стратегий описаны в https://st.yandex-team.ru/DIRECT-69250
        if (any {$strategy_params->{name} eq $_} qw (autobudget_max_reach autobudget_max_reach_custom_period)){
            $order->{AutoBudgetOptimizeRF} = 1;
            $order->{RFDecay} = 0.16;
            $order->{RFMinCPM} = 0;
        }

        if (any {$strategy_params->{name} eq $_} qw (autobudget_max_impressions autobudget_max_impressions_custom_period autobudget_avg_cpv_custom_period)){
            $order->{AutoBudgetOptimizeRF} = 1;
            $order->{RFDecay} = 0;
            $order->{RFMinCPM} = 1;
        }

        if (any {$strategy_params->{name} eq $_} qw (autobudget_max_reach_custom_period autobudget_max_impressions_custom_period autobudget_avg_cpv_custom_period)){
            _use_start_time_from_strategy_params($order, $strategy_params);
            _merge_autobudget_period($order, $strategy_params);
        }
        $order->{AutoBudgetDayWeight} = TimeTarget::get_day_weight(_camp($row, 'timeTarget'));

    } elsif ( _camp($row, 'day_budget') && _camp($row, 'day_budget') > 0 ) {
        # дневной бюджет (YABS-18066) -- реализован в БК как подмножество автобюджета, совместим только с неавтобюджетными стратегиями
        $order->{AutoBudget} = 1;
        ($order->{AutoBudgetDayLimitMoney}, $order->{AutoBudgetDayLimitMoneyCur}) = _get_conv_units_and_currency_values_for_sum(
            _camp($row, 'day_budget'), _camp($row, 'currency'), _camp($row, 'future_currency'),
            with_nds => 1, ClientID => _camp($row, 'ClientID'), client_nds_cache => $CLIENT_NDS_CACHE,
            min_constant => 'MIN_DAY_BUDGET',
        );
        $order->{AutoBudgetRegularSpent} = (_camp($row, 'day_budget_show_mode') eq 'stretched' ? 1 : 0);
        $order->{AutoBudgetDayWeight} = TimeTarget::get_day_weight(_camp($row, 'timeTarget'));
    } elsif (($strategy_params->{name} // '') eq 'period_fix_bid') {
        $order->{AutoBudget} = 1;
        _use_start_time_from_strategy_params($order, $strategy_params);
        _merge_autobudget_period($order, $strategy_params);

        ($order->{AutoBudgetPeriodBudgetLimit}, $order->{AutoBudgetPeriodBudgetLimitCur}) = _get_conv_units_and_currency_values_for_sum(
            $strategy_params->{budget}, _camp($row, 'currency'), _camp($row, 'future_currency'),
            with_nds => 1, ClientID => _camp($row, 'ClientID'), client_nds_cache => $CLIENT_NDS_CACHE,
        );

        $order->{AutoBudgetOptimizeRF} = 0;
        $order->{AutoBudgetRegularSpent} = 1;
        $order->{RFDecay} = 0;
        $order->{RFMinCPM} = 1;
        $order->{AutoBudgetStrategy} = 'period-fix-bid';
        $order->{AutoBudgetDayWeight} = TimeTarget::get_day_weight(_camp($row, 'timeTarget'));
    } else {
        $order->{AutoBudget} = 0;
    }

    $order->{AutoBudgetGoalExpression} = _camp($row, 'autobudget_goal_expression') if _camp($row, 'autobudget_goal_expression');

    if (($strategy_params->{name} || '') eq 'no_premium') {
        # стратегия "показ справа" описание в YABS-16372
        if ($strategy_params->{place} eq 'highest_place') {
            $order->{Strategy} = 'highest_pos_gar';
        }
    }

    if (($strategy_params->{name} || '') eq 'cpm_default') {
        $order->{AutoBudgetOptimizeRF} = 0;
        $order->{RFDecay} = 0;
        $order->{RFMinCPM} = 1;
    }

    # эксперимент с рулением RFDecay и RFMinCPM из интерфейса
    if ($strategy_params->{rf_decay}) {
        $order->{RFDecay} = $strategy_params->{rf_decay};
    }
    if ($strategy_params->{rf_min_cpm}) {
        $order->{RFMinCPM} = $strategy_params->{rf_min_cpm};
    }
    # эксперимент окончен

    # автобюджетные стратегии не должны пересекаться с неавтобюджетными
    if (_camp($row, 'autobudget') eq 'Yes' && $order->{Strategy}) {
        delete $order->{Strategy};
        send_alert("autobudget and non-autobudget strategy in cid $row->{campaign_pId}");
    }

    # по-умолчанию передается стратегия "наивасшая доступная позиция в любом месте"
    $order->{Strategy} ||= '';

    $order->{AutoBudgetPromotions} = _nosoap(_camp($row, 'campaigns_promotions')) if _camp($row, 'campaigns_promotions');

    # для автобюджета нет коэффициентов временного таргетинга
    # '' - нет временных коэффициентов
    # TODO: клёво бы было внести TimeTargetCoef в ShowCondition, чтобы весь таймтаргетинг рядом лежал
    my $has_timetarget_coef;
    if (_camp($row, 'autobudget') eq 'Yes') {
        $order->{TimeTargetCoef} = '';
        $has_timetarget_coef = 0;
    } else {
        $order->{TimeTargetCoef} = TimeTarget::bs_timetarget_coef(_camp($row, 'timeTarget'));
        $has_timetarget_coef = 1;
    }

    # Условия на заказ
    $order->{ShowCondition} = _get_show_condition($row, $has_timetarget_coef);

    # НДС, скидки и дату перевода выбираем/отправляем только для кампаний в валюте или собирающихся переводиться
    if ($order->{CurrencyISOCode} != -1) {
        # история НДС клиента
        my $client_id_for_nds_graph = (_camp($row, 'AgencyID') && _camp($row, 'AgencyID') > 0 && !_camp($row, 'non_resident')) ? _camp($row, 'AgencyID') : _camp($row, 'ClientID');
        if (!exists $client_nds_history_cache{$client_id_for_nds_graph}) {
            # EXP 2013.01.15: для турецких лир изменился график НДС, временно возвращаем его к старому
            # TODO - подумать как развязать проблему с шардингом и поменьше ходить в метабазу
            my $client_nds = get_all_sql(PPC(ClientID => $client_id_for_nds_graph), q/
                SELECT DATE_FORMAT(IF(date_from = "1985-01-01", "2013-01-01", date_from), "%Y%m%d") AS date_from
                     , DATE_FORMAT(date_to, "%Y%m%d") AS date_to
                     , nds
                FROM client_nds
                WHERE ClientID = ?/, $client_id_for_nds_graph);
            if ($client_nds && @$client_nds) {
                $client_nds_history_cache{$client_id_for_nds_graph} = $client_nds;
            } else {
                BS::Export::buggy_cid($order->{EID});
                $error_logger->({
                        message  => "No NDS known for ClientID and AgencyID",
                        ClientID => _camp($row, 'ClientID'),
                        AgencyID => _camp($row, 'AgencyID'),
                        cid      => $order->{EID},
                        type     => "buggy",
                        stage    => "request",
                    });
                $log->die(sprintf("No NDS known for ClientID %s and AgencyID %s", _camp($row, 'ClientID'), _camp($row, 'AgencyID')));
            }
        }
        $order->{NDSHistory} = $client_nds_history_cache{$client_id_for_nds_graph};

        # история скидок клиента
        if (!exists $client_discount_history_cache{_camp($row, 'ClientID')}) {
            my $discount_history = get_all_sql($dbh, q/
                SELECT DATE_FORMAT(date_from, "%Y%m%d") AS date_from
                     , DATE_FORMAT(date_to, "%Y%m%d") AS date_to
                     -- БК принимает только целые значения скидок
                     , ROUND(discount) AS discount
                FROM client_discounts
                WHERE ClientID = ?/, _camp($row, 'ClientID'));
            if ($discount_history && @$discount_history) {
                $client_discount_history_cache{_camp($row, 'ClientID')} = $discount_history;
            } else {
                # нулевые скидки мы не храним, поэтому при отсутствии скидок отправляем нулевую скидку
                # кроме уменьшения количества хранящихся данных, это покрывает случай нового валютного клиента:
                # первый раз ему скидка может быть расчитана лишь спустя сутки
                $client_discount_history_cache{_camp($row, 'ClientID')} = [{date_from => today(), date_to => mysql_round_day($Settings::END_OF_TIME), discount => 0}];
            }
        }
        $order->{DiscountHistory} = $client_discount_history_cache{_camp($row, 'ClientID')};

        # средняя скидка за домультивалютный период в процентах
        $order->{AvgDiscount} = _camp($row, 'avg_discount');
    }

    $order->{StatusEasy} = 0;

    $order->{HideMarketRating} = _need_to_hide_market_rating($row);

    my $counter_id = $PERFORMANCE_COUNTERS->{ $row->{campaign_pId} };
    if (defined $counter_id && $counter_id > 0) {
        $order->{CounterID} = $counter_id;
    }

    $order->{UpdateInfo} = 1; # в заказе мы всегда передаем все возможные поля

    if (_is_cpm_price_campaign($row)) {
        # Проставить флаги IsCPD и AutoBudgetPaidActions если необходимо
        if (_camp($row, 'package_is_cpd')) {
            $order->{IsCPD} = 1;
            $order->{AutoBudgetPaidActions} = 1;
            $order->{AutoBudget} = 1;
        }
    }

    if (_camp($row, 'calltracking_settings_id')) {
        # отправляем параметр только если настройки заданы
        $order->{CalltrackingOnSite} = _nosoap(1);
    }

    # блокировка вывода фавиконок на СЕРП
    $order->{BlockFavicon} = _camp($row, 'is_favicon_blocked') || 0;

    $order->{CheckBannersAvailability} = (_camp($row, 'statusMetricaControl') && _camp($row, 'statusMetricaControl') eq 'Yes') ? 1 : 0;

    $order->{Resources} //= {};

    my %opts = map {$_ => 1} split ",", _camp($row, 'opts');

    if ($opts{is_order_phrase_length_precedence_enabled}) {
        # отправляем параметр только если настройки заданы
        $order->{EnableOrderPhraseLengthPrecedence} = _nosoap(1);
    }
    $order->{DisableTitleSubstitute} = ($opts{no_title_substitute}) ? 1 : 0;
    my $no_extended_geotargeting = ($opts{no_extended_geotargeting}) ? 1 : 0;
    $order->{statusNoExtendedGeotargeting} = $no_extended_geotargeting;

    state $send_advanced_geotargeting_data_prop = Property->new('BS_TRANSPORT_SEND_ADVANCED_GEOTARGETING_DATA');
    my $send_advanced_geotargeting_data = $send_advanced_geotargeting_data_prop->get(60) || 0;

    if ($send_advanced_geotargeting_data &&
        (_is_text_campaign($row) || _is_content_promotion_campaign($row) ||
            _is_cpm_banner_campaign($row) || _is_mobile_content_campaign($row) ||
            _is_dynamic_campaign($row) || _is_mcbanner_campaign($row) || _is_smart_campaign($row))
    ) {
        my $use_current_region = ($opts{use_current_region}) ? 1 : 0;
        my $use_regular_region = ($opts{use_regular_region}) ? 1 : 0;

        if (!$use_current_region && !$use_regular_region) {
            $use_current_region = 1;
            if (!$no_extended_geotargeting) {
                $use_regular_region = 1;
            }
        }

        $order->{statusUseCurrentRegion} = $use_current_region;
        $order->{statusUseRegularRegion} = $use_regular_region;
    }

    $order->{Resources}->{HidePermalinkInfo} = ($opts{hide_permalink_info}) ? 1 : 0;

    $order->{StatDimensions} = _get_ab_segments_statistics($row) || [];
    $order->{TargetDimensions} = _get_ab_segments_retargeting($row) || [];

    $order->{InternalTargetDimensions} = (_camp($row, 'brand_survey_id') || _camp($row, 'is_search_lift_enabled') || _camp($row, 'is_cpm_global_ab_segment')) ? $order->{TargetDimensions} : [];

    $order->{AutoBudgetNetCPCOptimize} //= 0;

    if (_camp($row, 'autobudget') ne 'Yes' && !$order->{IndependentBids} && $opts{enable_cpc_hold} && _camp($row, 'platform') ne 'search') {
        $order->{AutoBudgetNetCPCOptimize} = 1;
        $order->{AutoBudget} = 1;
        $order->{AutoBudgetDayWeight} = TimeTarget::get_day_weight(_camp($row, 'timeTarget'));
    }

    if (_is_performance_campaign($row)) {
        # performance: кампании всегда автобюджетные, поэтому AutoBudgetNetCPCOptimize всегда 0
        $order->{AutoBudgetNetCPCOptimize} = 0;
    }

    if (_is_cpm_banner_campaign($row) || _is_cpm_deals_campaign($row) || _is_cpm_yndx_frontpage_campaign($row) ||
            _is_cpm_price_campaign($row) || _is_text_campaign($row)) {
        $order->{MaxRF} = _camp($row, 'rf');
        if (_camp($row, 'rf') == 0) {
            $order->{RFDays} = 0;
        } elsif (_camp($row, 'rfReset') == 0) {
            $order->{RFDays} = ALL_PERIOD_FOR_CPM_BANNER; #магическая константа - бесконечность (весь период размещения)
        } else {
            $order->{RFDays} = _camp($row, 'rfReset');
        }
    }

    if (_is_internal_campaign($row)){
        $order->{IsMobileApp} = _camp($row, 'is_mobile');
        $order->{RestrictionType} = _camp($row, 'restriction_type');
        $order->{RestrictionValue} = _camp($row, 'restriction_value');
        $order->{PageIDS} = _camp($row, 'page_ids') ? [split(/,/, _camp($row, 'page_ids'))] : [];

        if (_is_rf_export_for_internal_campaigns_enabled($order)) {
            $order->{MaxRF} = _camp($row, 'rf');

            if (_camp($row, 'rf') == 0) {
                $order->{RFDays} = 0;
            } else {
                $order->{RFDays} = _camp($row, 'rfReset');
            }
        }

        $order->{RfCloseByClick} = _camp($row, 'rf_close_by_click');
    }

    if (_camp($row, 's2s_tracking_enabled')) {
        my $mobile_goals = get_strategy_mobile_goals(_camp($row, 'strategy_data'), _camp($row, 'meaningful_goals'));

        my $s2s_tracking_urls = {};
        foreach my $mobile_goal (@$mobile_goals) {
            next if !defined $MOBILE_GOAL_APP_INFO->{$mobile_goal};
            my $os_type = $MOBILE_GOAL_APP_INFO->{$mobile_goal}->{os_type};
            my $tracking_url = sprintf(
                APPSFLYER_S2S_TRACKING_URL_TEMPLATE, $MOBILE_GOAL_APP_INFO->{$mobile_goal}->{store_content_id});
            $s2s_tracking_urls->{ucfirst $os_type} = _convert_href_params(
                BS::ExportMobileContent::add_params_to_tracking_href($tracking_url, $os_type, 1),
                $row
            );
        }
        if (%$s2s_tracking_urls) {
            $order->{S2STrackingURLs} = _nosoap($s2s_tracking_urls);
        }
    }

    # Новые кампании создаем принудительно остановленными
    if (!_second_query_disabled($row)
        && !_camp($row, 'campaign_Id')
        && !exists $row->{__forced_stop_camp}
        && !$order->{Stop}
        && !_is_wallet_campaign($row)
    ) {
        $row->{__forced_stop_camp} = undef;
        $order->{Stop} = 1;
        # при этом StopTime не передаем
    }

    return 1;
}
}

=head2 _is_rf_export_for_internal_campaigns_enabled

    Включена ли для данной кампании отправка старого RF

=cut
sub _is_rf_export_for_internal_campaigns_enabled {
    my ($row) = @_;

    state $rf_disabled_place_ids_property = Property->new('BS_EXPORT_OLD_RF_DISABLED_PLACE_IDS');
    my @place_ids_with_rf_export_disable = split(/,/, $rf_disabled_place_ids_property->get(300) // '');

    return all {$row->{PlaceID} != $_} @place_ids_with_rf_export_disable;
}

=head2 _second_query_disabled

    Включена ли для данной кампании функциональность "второго запроса в БК"

=cut
sub _second_query_disabled {
    my ($row) = @_;

    state $percent_prop //= Property->new('BS_EXPORT_SECOND_QUERY_DISABLE_PERCENT');
    my $percent = $percent_prop->get(60) || 0;
    if ($row->{campaign_pId} && $row->{campaign_pId} % 100 < $percent) {
        return 1;
    }

    state $clients_prop //= Property->new('BS_EXPORT_SECOND_QUERY_DISABLE_CLIENT_IDS');
    my %CLIENT_IDS = map {$_ => 1} grep {$_} split /[\s,]+/, $clients_prop->get(60) // '';
    if ($row->{ClientID} && $CLIENT_IDS{$row->{ClientID}}) {
        return 1;
    }

    return 0;
}

=head2 _hide_double_image_fields_enabled

    Включено ли скрытие дублирующих полей баннерной картинки, в одном родительском баннере (без безкартиночной версии)

=cut
sub _hide_double_image_fields_enabled {
    state $hide_double_image_fields_enabled = Property->new('HIDE_DOUBLE_IMAGE_FIELDS_TO_BS_ENABLED');
    return $hide_double_image_fields_enabled->get(120) ? 1 : 0;
}

=head2 merge_banner_flags($row)

    $banner->{Flags} = merge_banner_flags($row);
    Собрать строку с флагами баннера в понятном БК формате.
    Параметры:
        $row    - хеш с данными по баннеру/группе/кампании
    Резльтат:
        $flags  - строка с флагами, разделенными запятыми

=cut
sub merge_banner_flags {
    my $row = shift;

    my $flags = BannerFlags::get_banner_flags_as_hash($row->{flags} || "", all_flags => 1, no_children => 1);
    my $additional_flags = BannerFlags::get_banner_flags_as_hash($row->{multicards_flags} || "", all_flags => 1, no_children => 1);
    foreach my $flag_name (keys %$additional_flags) {
        if (!defined $flags->{$flag_name}
            || $additional_flags->{$flag_name} > $flags->{$flag_name}) {
            $flags->{$flag_name} = $additional_flags->{$flag_name};
        }
    }
    delete $flags->{age};

    # флаг про детское питание преобразуем в формат baby_food_N (N in [ 0 .. 12 ])
    if (defined $flags->{baby_food}) {
        $flags->{ "baby_food_".$flags->{baby_food} } = 1;
        delete $flags->{baby_food};
    }
    if (is_business_unit_client($row->{ClientID})) {
        $flags->{"business_unit"} = 1;
    }

    return join(",", sort keys(%$flags));
}

=head2 create_creative_object($row)

    $banner->{CreativesWithStatus} = create_creative_object($row);
    собирает структуру-объект creativesWithStatus

    $row - хеш с данными из базы

=cut
sub create_creative_object($) {
    my ($row) = @_;
    my $creative_status = $row->{CreativeStatus} eq 'Yes' ? 'accepted' : 'declined';

    my $creative_hash = {
        CreativeID => $row->{CreativeID},
        Status => $creative_status,
        CreativeType => (_is_smart_tgo_creative($row)) ? 'performance-tgo' : 'performance',
    };
    $creative_hash->{Version} = $row->{CreativeVersion} if (defined($row->{CreativeVersion}));

    return [ $creative_hash ];
}

=head _merge_skadnetwork_params($order, $row)

    Добавляет в $order->{SKAdNetworkCampaignID} номер слота для SkAdNetwork

=cut

sub _merge_skadnetwork_params {
    my ($order, $row) = @_;
    if (exists $SKADNETWORK_SLOTS->{$row->{campaign_pId}}) {
        $order->{SKAdNetworkCampaignID} = _nosoap($SKADNETWORK_SLOTS->{$row->{campaign_pId}});
    }
}

=head2 _use_start_time_from_strategy_params($order, $strategy_params)

    Заменяет $order->{Start_time} заказа на $strategy_params->{start} и форматирует его в формат YYYYMMdd000000

    $order - заказ
    $strategy_params - параметры стратегии

=cut

sub _use_start_time_from_strategy_params($$) {
    my ($order, $strategy_params) = @_;
    ($order->{Start_time} = $strategy_params->{start}) =~ s/(\d{4})-(\d{2})-(\d{2})/${1}${2}${3}000000/;
}

=head2 _merge_autobudget_period($order, $strategy_params)

    Добавляет в $order поля
        AutoBudgetPeriodBudgetFinish - дата окончания периода в формате YYYYMMdd235959
        AutoBudgetPeriodBudgetProlongation - прологация

    $order - заказ
    $strategy_params - параметры стратегии

=cut
sub _merge_autobudget_period($$) {
    my ($order, $strategy_params) = @_;

    ($order->{AutoBudgetPeriodBudgetFinish} = $strategy_params->{finish}) =~ s/(\d{4})-(\d{2})-(\d{2})/${1}${2}${3}235959/;
    $order->{AutoBudgetPeriodBudgetProlongation} = $strategy_params->{auto_prolongation};
}

=head2 _merge_content_promotion_data($banner, $content_data, $content_promotion_type)

    Добавляет в $banner->{Resources} поля
        Metadata - json строкой, который содержит метаданные контента
        VisitHref - строка, содержащая кликовую ссылку для перехода на сайт рекламодателя

    $banner - баннер
    $content_data - хэш данных контента
    $content_promotion_type - тип контента

=cut
sub _merge_content_promotion_data($$$) {
    my ($banner, $content_data, $content_promotion_type) = @_;
    my $metadata = $content_data->{metadata};

    state $json //= JSON->new->utf8(1);
    my $metadata_hash = $metadata ? $json->decode($metadata) : undef;

    if ($content_promotion_type eq 'collection') {
        if ($metadata) {
            my $decoded_metadata = decode("UTF-8", $metadata); # устанавливаем флаг utf8
            if ($decoded_metadata) {
                $banner->{Resources}->{Metadata} = _nosoap($decoded_metadata);
            }
            $banner->{Title} = $metadata_hash->{name};
            $banner->{Body} = $metadata_hash->{name};
        }

        $banner->{Title} ||= "collection";
        $banner->{Body} ||= "collection";

        if ($content_data->{visit_url}) {
            $banner->{Resources}->{VisitHref} = _nosoap($content_data->{visit_url});
        }

    } elsif ($content_promotion_type eq 'video') {
        if ($metadata) {
            $metadata_hash->{Title} = $banner->{Title};
            $metadata_hash->{Passage} = [split(/\n/, $banner->{Body})];

            $banner->{Resources}->{VideoMetadata} = _nosoap($json_obj->encode($metadata_hash));
        }

        if ($content_data->{visit_url}) {
            $banner->{Resources}->{PackshotHref} = _nosoap($content_data->{visit_url});
        }
    } elsif ($content_promotion_type eq 'service') {
        if ($metadata) {
            $banner->{Resources}->{Metadata} = _nosoap($metadata)
        }

        $banner->{Title} //= 'service';
        $banner->{Body} = $banner->{Title};
    } elsif ($content_promotion_type eq 'eda') {
        if ($metadata) {
            $banner->{Resources}->{Metadata} = _nosoap($metadata)
        }

        $banner->{Body} //= $banner->{Title};
    }
}

=head3 get_banner_lang($row, $texts, $fallback_lang)

    Возвращает язык баннера для отправки в БК. Язык вычисляется одним из следующих способов (в порядке приоритета):
    1. Взять язык с кампании
    2. Взять язык с баннера
    3. Вычислить язык по тексту баннера
    4. Воспользоваться $fallback_lang

    Параметры:
        $row             # hashref с данными о заказе/условии/баннере (элемент данных "снепшота")
        $texts           # тексты, по которым можно определить язык
        $fallback_lang   # язык, который нужно отправить в БК, если вычислить язык по данным баннера нельзя
=cut
sub get_banner_lang {
    my ($row, $texts, $fallback_lang) = @_;

    my $language;
    my $campaign_lang = _camp($row, 'CampLang');
    my $banner_lang = $row->{banner_language};

    if ($campaign_lang) {
        $language = $campaign_lang;
    } elsif (exists $BS_SUPPORTED_LANGUAGES{$banner_lang}) {
        $language = $banner_lang;
    } elsif (@$texts) {
        $language = analyze_text_lang_with_context($row->{ClientID}, @$texts);
    }
    $language //= $fallback_lang;

    return _normalize_banner_lang_for_bs($language);
}

=head2 create_banner_price_object($row)

    $banner->{BannerPrice} = create_banner_price_object($row, $lang);
    собирает структуру объект bannerPrice

    $row - хеш с данными базы

=cut
sub create_banner_price_object($) {
    my ($row) = @_;

    my $banner_price_hash = {
        Price => $row->{price},
        OldPrice => $row->{price_old},
        Prefix => BS::Export::priceprefix2bscode($row->{prefix}),
        Currency => $row->{currency},
    };

    return $banner_price_hash;
}

=head3 _extract_banner($row, $query, %options)

    $is_image_sent = _extract_banner($row, $query,
                                     domain_cache => \%domain_cache,
                                     domain_bs_id_cache => \%%domain_bs_id_cache,
                                     );

    Извлекает из "строки" с данными $row баннеры (текстовый и картиночный) в соответствующие
    вложенные структуры запроса $query

    Параметры:
        $row,       # hashref с данными о заказе/условии/баннере (элемент данных "снепшота")
        $query,     # hashref с данными, которые будут отправлены в БК
        domain_cache => \%domain_cache,     # кеш связей "домен - фильтр_домен"
        domain_bs_id_cache => \%%domain_bs_id_cache, # кэш связей "домен - id домена из БК"
        dialog_skill_id => информация о чате привязанном к кампании
        dialog_bot_guid => берется из объекта кампании
    Результат:
        $is_image_sent - 0/1 - был ли добавлен в запрос к БК картиночный баннер

=cut
sub _extract_banner {
    my ($row, $query, %O) = @_;

    my $order = extract_base_order($query, $row);

    my $banner_auto_video = {
        text => {
            banner => undef,
            banner_data => undef,
            creative_id => undef,
        },
        image => {
            banner => undef,
            banner_data => undef,
            creative_id => undef,
        },
    };

    # извлекаем/создаем баннер в текущем заказе
    my $context = extract_base_context($order, $row);
    my $banner = extract_base_banner($context, $row);
    unless ($banner->{Stop}) {
        # еще ниже тоже самое делаем для старых картиночных баннеров
        _extract_target_flat($banner, $row);
        if (_is_performance_banner($row)) {
            # для перфоманса заполняем только ограниченный набор полей, не делаем _merge_banner_data
            _merge_bannerland_data_performance($banner, $row, domain_cache => $O{domain_cache});
            #TODO: поле Creative лишнее, т.к. уже есть CreativesWithStatus[0] -> CreativeID
            #Но БК требует наличия как старого, так и нового поля.(см. коммент BSDEV-62156#1501511112000 в st)
            #Со временем старое поле надо выпилить(после того как БК перестанет на него смотреть)
            #аналогично для второй пары Creative/CreativesWithStatus далее по коду

            if ($row->{banner_type} eq 'performance') {
                $banner->{Creative} = [ $row->{CreativeID} ];
                $banner->{CreativesWithStatus} = create_creative_object($row);
            } elsif ($row->{banner_type} eq 'performance_main') {
                # в новом родительском performance-баннере нет креативов
                $banner->{IsPerformanceMain} = 1;
                # шлём пустые списки, т.к. БК нуждается в них, в будущем можно будет вообще не слать
                $banner->{Creative} = [];
                $banner->{CreativesWithStatus} = [];
            }
            $banner->{UpdateInfo} = 1;
            #единственный шаблон для смартов.
            $banner->{TemplateID} = PERFOMANCE_PARENT_TEMPLATE_ID;
            # DIRECT-88450 временно откатываем фичу
            if ($row->{banner_type} eq 'performance' && _is_smart_tgo_creative($row) && _is_auto_video_allowed($row)) {
                $banner->{IsAutoVideo} = 1;
                $banner->{Resources} = {AutoVideoCreative => AUTO_VIDEO_DEFAULT_CREATIVE_ID};
            }
            my $lang = get_banner_lang($row, [], 'ru');
            if($lang ne 'ru'){
                $banner->{Lang} = $lang;
            }
        }
        else {
            _merge_banner_data($banner, $row,
                               PriorityID => $row->{PriorityID},
                               domain_cache => $O{domain_cache},
                               domain_bs_id_cache => $O{domain_bs_id_cache},
                               );
        }

        if (_is_text_banner($row) || _is_dynamic_banner($row) || _is_mobile_content_banner($row)) {
            if ($ADDITIONS->{callout}) {
                my $addition_target_id = $row->{$BS::Export::ADDITION_TARGET_TO_SNAPSHOT_COLUMN{ $BS::Export::ADDITION_TYPES{callout}->{get_by} }};
                if ($ADDITIONS->{callout}->{$addition_target_id} && @{$ADDITIONS->{callout}->{$addition_target_id}}) {
                    my (%callouts, @calloutslist);
                    # модель Direct::BannersAdditions уже отдаёт callout'ы отсортированные по sequence_num
                    for my $callout (@{$ADDITIONS->{callout}->{$addition_target_id}}) {
                        $callouts{ $callout->id } = $callout->callout_text;
                        push @calloutslist, $callout->callout_text;
                    }
                    $banner->{CalloutSet} = {
                        Callouts     => \%callouts,
                        CalloutsList => \@calloutslist,
                    };
                }
            }
        }

        if (_is_text_banner($row) || _is_mobile_content_banner($row) || _is_cpm_banner($row)
            || _is_cpc_video_banner($row) || _is_cpm_outdoor_banner($row) || _is_cpm_indoor_banner($row)
            || _is_cpm_audio_banner($row))
        {
            my ($video_creative_id, $banner_video_data) = _get_auto_video_creative_id($row);
            if ($video_creative_id) {
                $banner_auto_video->{text}->{banner} = $banner;
                $banner_auto_video->{text}->{banner_data} = $banner_video_data;
                $banner_auto_video->{text}->{creative_id} = $video_creative_id;
            } else {
                if (_is_brand_lift($row)) {
                    if (_is_cpm_banner($row)) {
                        $banner->{IsMediaCreativeReachSurvey} = 1;
                    } elsif (_is_text_banner($row)) {
                        $banner->{IsMediaCreativeSurvey} = 1;
                    }
                }
            }
        }

        if (_is_cpm_yndx_frontpage_adgroup($row) || # Если это группа cpm_yndx_frontpage (а она может быть только в кампании cpm_yndx_frontpage или cpm_price)
            (_is_cpm_price_campaign($row) &&  # ИЛИ если это cpm_price кампания с видео-объявлениями на главной
             _is_cpm_video_adgroup($row) &&
             _camp($row, 'package_is_frontpage'))) {

                 $banner->{IsMainPage} = 1;

        }

        # отправка картинок в ТГО и мобильных объявлениях, приходит на замену отдельным баннерам-картинкам
        if (_is_text_banner($row) || _is_mobile_content_banner($row)) {
            if (defined $row->{image_id}
                && _is_banner_image_resource_enabled($row)
                # Отправляем картинку только если она промодерирована. Если картинка сейчас в процессе
                # модерации, делаем вид что картинки нет.
                # Сделано так, потому что при отправке картинки ресурсом, нет возможность сказать БК
                # "используй предыдущую версию картинки", как это можно было делать с дочерними баннерами
                # https://st.yandex-team.ru/DIRECT-81844#1531744974000
                && _can_show_banner_image_resource($row)
            ) {
                $banner->{Resources}->{ImagesInfo} = _get_banner_image_resource($row);
            } else {
                $banner->{Resources}->{ImagesInfo} = {};
            }
        }

        #  отправка картинки для царь-баннера
        if (_is_cpm_banner($row)) {
            my $big_king_image_info = _get_banner_big_king_image_resource($row);
            $banner->{Resources}->{ImagesInfo} = $big_king_image_info if %$big_king_image_info;
        }

        if (_is_cpm_outdoor_banner($row)) {
            #вердикты внешней модерации
            $banner->{PageModeration} = [];
            my $banner_page_moderation = $BANNER_PAGE_MODERATION->{$row->{banner_pId}};
            if ($banner_page_moderation) {
                for my $page_mod (@$banner_page_moderation) {
                    my $status = $page_mod->{statusModerate} eq 'Yes' ? 'Yes'
                        : $page_mod->{statusModerate} eq 'No' ? 'No'
                        : $page_mod->{statusModerate} eq 'Maybe' ? 'Maybe'
                        : 'None';
                    push @{$banner->{PageModeration}}, { PageId => int $page_mod->{pageId}, StatusModerate => $status, Version => $page_mod->{Version}, TaskURL =>  $page_mod->{TaskURL}  };
                }
            }
        }

        my %measurers;
        if (exists $BANNER_MEASURERS->{$row->{banner_pId}}) {
            for my $measurer (@{$BANNER_MEASURERS->{$row->{banner_pId}}}) {
                next if $measurer->measurer_system =~ /^(omi|mediascope)$/ && $measurer->has_integration;
                $measurers{$measurer->measurer_system} = $measurer->expand_params;
            }
        }

        if (exists $CAMPAIGN_MEASURERS->{$row->{campaign_pId}}) {
            my @camp_measurers = @{$CAMPAIGN_MEASURERS->{$row->{campaign_pId}}};

            my ($ias) = grep { $_->{measurer_system} eq 'ias' } @camp_measurers;

            if ($ias) {
                my $cloned_ias = dclone($ias);
                $cloned_ias->{measurer_system} = 'omid';
                push @camp_measurers, $cloned_ias;
            }

            for my $measurer (@camp_measurers) {
                next if defined($measurers{$measurer->{measurer_system}});
                my $banner_measurer = Direct::Model::Banner::Measurer->new(
                    banner_id => $row->{banner_pId},
                    measurer_system => $measurer->{measurer_system},
                    params => $measurer->{params},
                    client_id => $row->{ClientID},
                    campaign_id => $row->{campaign_pId},
                    adgroup_id => $row->{context_pId},
                    adgroup_type => $row->{adgroup_type});

                my $rc = $banner_measurer->expand_params;

                if (defined $rc) {
                    $measurers{$measurer->{measurer_system}} = $rc;
                }
            }
        }

        if ($BANNER_TNS_ID->{$row->{banner_pId}}) {
            $measurers{mediascope} //= {};
            # осознанно перезаписываем tnsid, который пользователь мог сам указать в JSON banner_measurers для mediascope
            $measurers{mediascope}{tnsid} = ''.$BANNER_TNS_ID->{$row->{banner_pId}};
        }

        $banner->{Measurers} = _nosoap(\%measurers);

        if (_is_in_banner_creative($row)) {
            my $canvas_id = $row->{$BS::Export::ADDITION_TARGET_TO_SNAPSHOT_COLUMN{ $BS::Export::ADDITION_TYPES{canvas}->{get_by} }};
            my $creative = $ADDITIONS->{canvas}->{$canvas_id};

            $banner->{IsMediaCreative} = 1;

            # переделать как в канвасах, если из модерации будет приходить extracted_texts
            $banner->{Title} = "";
            $banner->{Body} = "";

            # язык нужно будет вычислять по title+body, если таковые появятся
            $banner->{Lang} = get_banner_lang($row, [], 'ru');
            $banner->{TemplateID} = MEDIA_CREATIVE_TEMPLATE_ID;

            $banner->{CreativesWithStatus} = create_creative_object($creative);
            $banner->{Resources}->{Creative} = $banner->{Creative} = [ $creative->{CreativeID} ];
            $banner->{Resources}->{CreativeHref1} = $banner->{Href};
            $banner->{Resources}->{Body} = "";
            $banner->{Resources}->{Title} = "";
        }
        elsif (_is_image_ad_or_mcbanner_banner($row) || _is_cpm_banner($row) || _is_cpm_geo_pin_banner($row)) {
            if ($row->{image_ad_type} eq 'image_ad' && $row->{banner_type} ne 'cpm_banner') {  # еще одна защитная подпорка
                # обычный графический баннер
                $banner->{IsMediaImage} = 1;
                $banner->{TemplateID} = MEDIA_IMAGE_TEMPLATE_ID;

                my $image_ad_id = $row->{$BS::Export::ADDITION_TARGET_TO_SNAPSHOT_COLUMN{ $BS::Export::ADDITION_TYPES{image_ad}->{get_by} }};
                if (%{$ADDITIONS->{image_ad}} && $ADDITIONS->{image_ad}->{$image_ad_id}) {
                    my $image_ad = $ADDITIONS->{image_ad}->{$image_ad_id};
                    my $url = _generate_mds_avatars_url($image_ad, 'orig');

                    my ($width, $height) = ($image_ad->{width}, $image_ad->{height});
                    my $size = "${width}x${height}";
                    # Размеры для ретины передаем уменьшенными в два раза
                    if (any {$size eq $_} @Direct::Validation::Image::VALID_RETINA_SIZES) {
                        $width /= 2;
                        $height /= 2;
                    };
                    $banner->{Resources}->{MediaImage} = $banner->{MediaImage} = [ $url, $width, $height ];
                    $banner->{Resources}->{Domain} = $banner->{Site};
                    $banner->{Resources}->{Url} = $banner->{Href};

                    _set_image_text_to_banner($banner, $image_ad->{image_text});

                    if (_is_mcbanner_banner($row)) {
                        # хотя Lang был заполнен выше (при вызове _merge_banner_data), делаем это явно еще раз.
                        # отличие в том, что здесь не пытаемся смотреть на body/title и берем либо CampLang
                        # либо ставим умолчание для ГО - 'ru'
                        $banner->{Lang} = _camp($row, 'CampLang') || 'ru';
                    } else {
                        # У баннеров графических объявлений язык объявления всегда должен быть ru
                        # https://wiki.yandex-team.ru/users/a-balakina/Media-ads/ пункт 33
                        $banner->{Lang} = 'ru';
                    }
                }
            } elsif ($row->{image_ad_type} eq 'canvas' && $row->{banner_type} ne 'mcbanner' && ($row->{creative_type}//'') eq 'canvas') {  # ставим защитную подпорку
                # графический баннер с креативом
                $banner->{IsMediaCreative} = 1;
                $banner->{TemplateID} = MEDIA_CREATIVE_TEMPLATE_ID;

                my $canvas_id = $row->{$BS::Export::ADDITION_TARGET_TO_SNAPSHOT_COLUMN{ $BS::Export::ADDITION_TYPES{canvas}->{get_by} }};
                if (%{$ADDITIONS->{canvas}} && $ADDITIONS->{canvas}->{$canvas_id}) {
                    my $creative = $ADDITIONS->{canvas}->{$canvas_id};

                    $banner->{CreativesWithStatus} = create_creative_object($creative);
                    $banner->{Resources}->{Creative} = $banner->{Creative} = [ $creative->{CreativeID} ];
                    $banner->{Resources}->{Domain} = $banner->{Site};
                    $banner->{Resources}->{Url} = $banner->{Href};

                    _set_image_text_to_banner($banner, Tools::get_clean_text($creative->{extracted_text}));

                    my $texts = eval { $json_obj->decode($creative->{moderate_info} // '')->{texts} } // [];
                    if ($@) {
                        $error_logger->({
                                message     => "Can't decode JSON moderate_info for creative",
                                creative_id => $creative->{CreativeID},
                                cid         => $row->{campaign_pId},
                                bid         => $row->{banner_pId},
                                type        => "banner",
                                reason      => $@,
                                stage       => "request",
                            });
                    }
                    $banner->{Lang} = get_banner_lang($row, [ map { $_->{text} // '' }  @{ $texts } ], 'ru');
                }
            } elsif (($row->{creative_type}//'') eq 'html5_creative') {
                # CPM баннер с HTML5 креативом
                $banner->{IsMediaCreative} = 1;
                $banner->{TemplateID} = HTML5_CREATIVE_TEMPLATE_ID;
                my $canvas_id = $row->{$BS::Export::ADDITION_TARGET_TO_SNAPSHOT_COLUMN{ $BS::Export::ADDITION_TYPES{html5_creative}->{get_by} }};
                if (%{$ADDITIONS->{html5_creative}} && $ADDITIONS->{html5_creative}->{$canvas_id}) {
                    my $creative = $ADDITIONS->{html5_creative}->{$canvas_id};

                    # переделать как в канвасах, если из модерации будет приходить extracted_texts
                    $banner->{Title} = "";
                    $banner->{Body} = "";

                    # язык нужно будет вычислять по title+body, если таковые появятся
                    $banner->{Lang} = get_banner_lang($row, [], 'ru');

                    $banner->{CreativesWithStatus} = create_creative_object($creative);
                    $banner->{Resources}->{Creative} = $banner->{Creative} = [ $creative->{CreativeID} ];
                    $banner->{Resources}->{CreativeHref1} = $banner->{Href};

                    # прописываем множественные ссылки html5 креативов.
                    if (exists $BANNER_ADDITIONAL_HREFS->{$row->{banner_pId}}) {
                        my @hrefs = xsort {$_->index} @{$BANNER_ADDITIONAL_HREFS->{$row->{banner_pId}}};
                        foreach my $i (0 .. scalar(@hrefs)-1) {
                            $banner->{Resources}->{"CreativeHref".($i+2)} = $hrefs[$i]->href;
                        }
                    }

                    if (_has_turbolanding($row)){
                        $banner->{Resources}->{CreativeTurboLandingHref1} = $TURBOLANDINGS->{$row->{banner_tl_id}};
                        $banner->{Resources}->{CreativeTurboLandingId1} = $row->{banner_tl_id};
                    }

=off
                    # FIXME
                    # Тут будет полноценная поддержка ссылок
                    # https://st.yandex-team.ru/BSDEV-66577#1511249731000
                    $banner->{Resources}->{CreativeTurboLandingHref1..3} = ..
=cut
                    $banner->{Resources}->{RenderInfo} = $creative->{RenderInfo};
                    $banner->{Resources}->{CreativeComposedFrom} = $creative->{CreativeComposedFrom} if $creative->{CreativeComposedFrom};
                }
            } elsif (($row->{creative_type}//'') eq 'video_addition' || ($row->{creative_type}//'') eq 'bannerstorage') {
                # CPM баннер с видео-креативом
                if (!$banner->{Title}) {
                    $banner->{IsFakeTitle} = 1;
                    $banner->{Title} = $Direct::Model::BannerImageAd::Constants::TITLE_PLACEHOLDER;
                }

                if (!$banner->{Body}) {
                    $banner->{IsFakeBody} = 1;
                    $banner->{Body} = $Direct::Model::BannerImageAd::Constants::BODY_PLACEHOLDER;
                }
            } else {
                die 'unknown image banner subtype';
            }
        }

        if (_is_cpm_banner($row) || _is_cpm_audio_banner($row)) {
            if ($ADDITIONS->{pixel}) {
                my $addition_target_id = $row->{$BS::Export::ADDITION_TARGET_TO_SNAPSHOT_COLUMN{ $BS::Export::ADDITION_TYPES{pixel}->{get_by} }};
                if ($ADDITIONS->{pixel}->{$addition_target_id} && @{$ADDITIONS->{pixel}->{$addition_target_id}}) {
                    my @pixels;
                    for my $pixel (@{$ADDITIONS->{pixel}->{$addition_target_id}}) {
                        push @pixels, $pixel->url_with_subst_random;
                    }
                    $banner->{ViewNoticeHrefs} = \@pixels;
                }
            }

            if (exists $BANNER_MEASURERS->{$row->{banner_pId}}) {
                my %integrated_measurers_system =
                    map { $_->measurer_system => 1}
                        grep {$_->has_integration} @{ $BANNER_MEASURERS->{$row->{banner_pId}} };

                if ($integrated_measurers_system{mediascope}) {
                    unless ($MEDIASCOPE_PREFIXES->{$row->{ClientID}}) {
                        $error_logger->({message => 'Empty mediascope tmsec_prefix for ClientID ' . $row->{ClientID}});
                    }
                    my $pixel = Direct::Model::Pixel::build_mediascope_audit_pixel($MEDIASCOPE_PREFIXES->{$row->{ClientID}}, $row->{campaign_pId}, $row->{banner_pId}, $row->{adgroup_type});
                    $banner->{ViewNoticeHrefs} ||= [];
                    push @{$banner->{ViewNoticeHrefs}}, $pixel->url_with_subst_random;
                }
                if ($integrated_measurers_system{omi}) {
                    my $pixel = Direct::Model::Pixel::build_omi_audit_pixel($row->{campaign_pId}, $row->{banner_pId}, $row->{adgroup_type});
                    $banner->{ViewNoticeHrefs} ||= [];
                    push @{$banner->{ViewNoticeHrefs}}, $pixel->url_with_subst_random;
                }
            }

            state $fake_pixel_prop //= Property->new('FAKE_PIXEL_CPM_BANNER_PERCENT');
            my $fake_pixel_percent = $fake_pixel_prop->get(60) || 0;

            if (_is_cpm_banner($row) && $row->{campaign_pId} % 100 < $fake_pixel_percent
                && _camp($row, 'strategy_name') ne 'cpm_default') {

                my $strategy = _get_strategy_data($row);
                if (($strategy->{budget} || $strategy->{sum} || 0) >= 70_000) {
                    $banner->{ViewNoticeHrefs} ||= [];
                    my $pixel_url = sprintf 'https://{DRND}.verify.yandex.ru/verify?platformid=1&msid=yndx_5-%d-%d', $row->{campaign_pId}, $row->{banner_pId};
                    my $pixel = Direct::Model::Pixel->new(
                        banner_id => $row->{banner_pId}, id => 1,
                        url => $pixel_url,
                        kind => 'audit', provider => 'mediascope',
                        campaign_id => $row->{campaign_pId}, adgroup_type => $row->{adgroup_type}
                    );
                    push @{$banner->{ViewNoticeHrefs}}, $pixel->url_with_subst_random;
                }
            }
        }

        # добавляем данные о чате для ТГО баннера
        if (_is_text_banner($row) && $O{dialog_skill_id} && $O{dialog_bot_guid}) {
            $banner->{Resources}->{Dialog} = {
                Id    => $O{dialog_skill_id},
                BotId => $O{dialog_bot_guid},
            }
        }

        # Добавляем данные о контенте
        if (_is_content_promotion_banner($row)) {
            if ($ADDITIONS->{content_promotion}) {
                my $addition_target_id = $row->{$BS::Export::ADDITION_TARGET_TO_SNAPSHOT_COLUMN{ $BS::Export::ADDITION_TYPES{content_promotion}->{get_by}}};
                my $content_data = $ADDITIONS->{content_promotion}->{$addition_target_id};
                if ($content_data) {
                    $banner->{Stop} ||= ($content_data->{is_inaccessible} ? 1 : 0);
                    _merge_content_promotion_data($banner, $content_data, $row->{content_promotion_type});
                }
            }
        }

        # Добавляем данные о ценах
        if (_is_text_banner($row)) {
            if ($ADDITIONS->{banner_price}) {
                my $addition_target_id = $row->{$BS::Export::ADDITION_TARGET_TO_SNAPSHOT_COLUMN{ $BS::Export::ADDITION_TYPES{banner_price}->{get_by} }};
                my $banner_price = $ADDITIONS->{banner_price}->{$addition_target_id};
                if (defined $banner_price && defined $banner_price->{price}) {
                    $banner->{BannerPrice} = _nosoap(create_banner_price_object($banner_price));
                }
            }
        }

        if (_is_cpc_video_banner($row)) {
            # у CPC video баннеров может не быть текста, если пользователь загрузил своё видео
            # https://st.yandex-team.ru/DIRECT-101912
            my $addition = _get_auto_video_addition($row);
            if ($addition && (!$banner->{Title} || !$banner->{Body})) {
                # текст от модерации
                my ($mod_title, $mod_body) = TextTools::extract_first_words(
                    $addition->{extracted_text} // '',
                    $Settings::MAX_TITLE_LENGTH
                );
                if (!$banner->{Title} && !$banner->{Body}) {
                    $banner->{Title} = $mod_title || $Direct::Model::BannerImageAd::Constants::TITLE_PLACEHOLDER;
                    $banner->{Body} = $mod_body || $Direct::Model::BannerImageAd::Constants::BODY_PLACEHOLDER;
                    $banner->{IsFakeTitle} = 1;
                    $banner->{IsFakeBody} = 1;
                } else {
                    if (!$banner->{Title}) {
                        $banner->{Title} = $Direct::Model::BannerImageAd::Constants::TITLE_PLACEHOLDER;
                        $banner->{IsFakeTitle} = 1;
                    }
                    if (!$banner->{Body}) {
                       $banner->{Body} = $Direct::Model::BannerImageAd::Constants::BODY_PLACEHOLDER;
                       $banner->{IsFakeBody} = 1;
                    }
                }
            }
        }

        # Добавляем хеши ассетов
        my $asset_hashes = _get_asset_hashes($row->{campaign_pId}, $row->{banner_pId});
        if ($asset_hashes) {
            $banner->{Resources}->{AssetHashes} = $asset_hashes;
        }

        # новые баннеры создаем принудительно остановленными
        if (!_second_query_disabled($row) && !$row->{banner_Id} && !exists $row->{__forced_stop_banner}) {
            $banner->{Stop} = 1;
            $row->{__forced_stop_banner} = undef;
        }

        _merge_dynamic_disclaimer($banner, $row);
        _merge_banner_template_id($banner, $row);
        _merge_banner_experiments_data($banner, $row);
        _merge_banner_turbo_app_content($banner, $row);
    }

    my $is_image_sent = 0;
    # баннер с картинкой
    if (defined $row->{image_id}
        # у перфоманс баннеров нет картинок
        && !_is_performance_banner($row)
        # если баннер отправляли раньше - то отсылаем его снова, если он побывал на модерации ИЛИ остановлен пользователем
        && ( ( defined $row->{image_statusModerate} && $row->{image_statusModerate} =~ /^(Yes|No)$/ )
             || ( $row->{image_BannerID} && ( $row->{banner_statusShow} eq 'No' || $row->{image_statusShow} eq 'No' ) )
           )
        # если image_BannerID не 0 - значит мы уже отправляли этот баннер в БК, в этом случае нужно отправлять Stop, если баннер отклонен или остановлен
        # а если BannerID = 0, то отправляем только если баннер будет показываться (расшифровка ниже)
        && ( $row->{image_BannerID}
             || ( # не выключен клиентом или метрикой основной (текстовый) баннер
                  $row->{banner_statusShow} eq 'Yes'
                  # заголовок/текст баннера (они общие у текстового/картиночного) - приняты на модерации
                  && defined $row->{phrases_PostModerate} && $row->{phrases_PostModerate} eq 'Yes'
                  # принято на модерации условие баннера (оно тоже общее у текстового/картиночного)
                  && defined $row->{banner_PostModerate} && $row->{banner_PostModerate} eq 'Yes'
                  # включен картиночный баннер
                  && $row->{image_statusShow} eq 'Yes'
                  # картинка принята на модерации
                  && $row->{image_statusModerate} eq 'Yes'
                )
           )
    ) {
        if (_has_valid_context($row, is_image => 1)) {
            my $banner_image = extract_base_banner($context, 
                                                   $row, 
                                                   is_image => 1, 
                                                   cid_pid_bid_to_image_id_as_one => $O{cid_pid_bid_to_image_id_as_one},
                                                   );
            $is_image_sent = 1;

            unless ($banner_image->{Stop}) {
                _extract_target_flat($banner_image, $row);
                _merge_banner_data($banner_image, $row,
                                   PriorityID => $row->{image_PriorityID},
                                   domain_cache => $O{domain_cache},
                                   domain_bs_id_cache => $O{domain_bs_id_cache},
                                   );

                # новые баннеры создаем принудительно остановленными
                if (!_second_query_disabled($row) && !$row->{image_BannerID} && !exists $row->{__forced_stop_banner_image}) {
                    $banner_image->{Stop} = 1;
                    $row->{__forced_stop_banner_image} = undef;
                }

                _merge_dynamic_disclaimer($banner_image, $row);
                _merge_banner_template_id($banner_image, $row);
                _merge_banner_experiments_data($banner_image, $row);
                _merge_banner_turbo_app_content($banner_image, $row);

                # даже если никаких форматов не найдется, явно делаем баннер картиночным
                # чтобы на стороне БК работала валидация на "картинки без картинок"
                $banner_image->{Images} //= {};
                my $image_resource = _get_banner_image_resource($row, need_old_smart_center => 1);
                hash_merge($banner_image, $image_resource);

                my ($video_creative_id, $banner_video_data) = _get_auto_video_creative_id($row, is_image => 1);
                if ($video_creative_id && _is_text_banner($row)) {
                    $banner_auto_video->{image}->{banner} = $banner_image;
                    $banner_auto_video->{image}->{banner_data} = $banner_video_data;
                    $banner_auto_video->{image}->{creative_id} = $video_creative_id;
                }

                # Добавляем хеши ассетов
                my $asset_hashes = _get_asset_hashes($row->{campaign_pId}, $row->{banner_pId}, "with_image_hash");
                if ($asset_hashes) {
                    $banner_image->{Resources}->{AssetHashes} = $asset_hashes;
                }
            }
        } elsif (!_are_we_want_to_send_phrases($row)) {
            _save_resync_data_for_absent_banner($row, 'image');
        }
    }

    my ($banner_with_video, $banner_video_data, $video_creative_id);
    if ($banner_auto_video->{image}->{creative_id}) {
        $banner_with_video = $banner_auto_video->{image}->{banner};
        $banner_video_data = $banner_auto_video->{image}->{banner_data};
        $video_creative_id = $banner_auto_video->{image}->{creative_id};
    }
    elsif ($banner_auto_video->{text}->{creative_id}) {
        $banner_with_video = $banner_auto_video->{text}->{banner};
        $banner_video_data = $banner_auto_video->{text}->{banner_data};
        $video_creative_id = $banner_auto_video->{text}->{creative_id};
    }
    if ($banner_with_video) {
        $banner_with_video->{Resources}->{AutoVideoCreative} = $video_creative_id;
        if ($banner_video_data) {
            hash_merge $banner_with_video, $banner_video_data;
        }
    }

    return $is_image_sent;
}

=head3 _get_asset_hashes

    Возвращает хеши ассетов для добавления в баннер
    Либо undef если хешей для переданного id баннера нет

=cut

sub _get_asset_hashes {
    my ($campaign_id, $banner_id, $with_image_hash) = @_;

    return undef if !exists $ASSET_HASHES->{$campaign_id}->{$banner_id};

    my $banner_assets =  $ASSET_HASHES->{$campaign_id}->{$banner_id};
    my $asset_hashes = {};
    foreach my $key (keys %$banner_assets) {
        next if !$with_image_hash && $key eq 'ImageAssetHash';
        $asset_hashes->{$key} = int($banner_assets->{$key});
    }
    return $asset_hashes;
}

=head3 _set_image_text_to_banner

    Заполняет заголовок и тело баннера переданным текстом, если они пустые
    В Title идут первые несколько слов текста картинки, влезающие в $Settings::MAX_TITLE_LENGTH символов
    в Body - все остальное.

=cut

sub _set_image_text_to_banner {
    my ($banner, $text) = @_;

    if ((!$banner->{Title} || $banner->{Title} eq $Direct::Model::BannerImageAd::Constants::TITLE_PLACEHOLDER)
        && (!$banner->{Body} || $banner->{Body} eq $Direct::Model::BannerImageAd::Constants::BODY_PLACEHOLDER)) {

        my ($title, $body) = TextTools::extract_first_words($text // '', $Settings::MAX_TITLE_LENGTH);
        $banner->{Title} = $title;
        $banner->{Resources}->{Title} = SOAP::Data->type('string')->value($title);
        $banner->{IsFakeTitle} = 1;
        $banner->{Body} = $body;
        $banner->{Resources}->{Body} = SOAP::Data->type('string')->value($body);
        $banner->{IsFakeBody} = 1;
    }
}

=head3 _generate_mds_avatars_url

    Сгенерировать URL изображения для аватарницы MDS

=cut

sub _generate_mds_avatars_url {
    my ($row, $id) = @_;

    # первый случай - это картиночные баннеры, а второй - го, у которых нужные данные уже есть внутри
    my $bif = _get_banner_images_formats_data($row) // $row;
    my $avatars = get_mds_avatars_handler($bif->{banner_image_namespace}, $bif->{banner_image_avatars_host});
    my $mds_group_id = $bif->{banner_image_mds_group_id} // '0'; # DIRECT-108344
    return $avatars->avatars_url('get', short => 1)."/$mds_group_id/$row->{banner_image}/$id";
}

=head3 _get_domain_filter

    Получает DomainFilter для отправки в БК. Это главный домен (с учётом редиректов) без www и в нижнем регистре.
    Результаты умеет кешировать.

    $main_domain = _get_domain_filter($domain_ascii, domain_cache => \%domain_cache);

=cut

sub _get_domain_filter {
    my ($domain, %O) = @_;

    if ($O{domain_cache} && exists $O{domain_cache}->{$domain}) {
        return $O{domain_cache}->{$domain};
    } else {
        my $main_domain = BS::Export::get_domain_filter($domain);
        $O{domain_cache}->{$domain} = $main_domain if $O{domain_cache};
        return $main_domain;
    }
}

=head3 _get_domain_bs_id

    Возвращает для домена его id из БК. Результаты умеет кешировать.

    $domain_bs_id = _get_domain_bs_id($domain, domain_bs_id_cache => \%domain_bs_id_cache);

=cut

sub _get_domain_bs_id {
    my ($cid, $domain, %O) = @_;

    if ($O{domain_bs_id_cache} && exists $O{domain_bs_id_cache}->{$domain}) {
        return $O{domain_bs_id_cache}->{$domain};
    } else {
        my $domain_bs_id = eval{ BS::Export::get_domain_bs_id($domain) };
        if ($@) {
            BS::Export::buggy_cid($cid);
            $error_logger->({
                    message  => "Can't get domain_bs_id",
                    cid      => $cid,
                    domain   => $domain,
                    type     => "buggy",
                    reason   => $@,
                    stage    => "request",
                });
            $log->die(sprintf("Can't get domain_bs_id for cid %s and domain %s", $cid, $domain));
        }
        $O{domain_bs_id_cache}->{$domain} = $domain_bs_id if $O{domain_bs_id_cache};

        return $domain_bs_id;
    }
}

=head3 _is_show_reflected_attrs_enabled

    Проверяет, включены ли отображаемые аттрибуты для клиента

=cut

sub _is_show_reflected_attrs_enabled {
    my $client_id = shift;
    state $show_reflected_attrs_for_all_mobile_banners_for_clients_property = Property->new('show_reflected_attrs_for_all_mobile_banners_for_clients');
    state $show_reflected_attrs_for_all_mobile_banners_property = Property->new('show_reflected_attrs_for_all_mobile_banners');
    my %client_ids = map {$_ => 1} split ",", $show_reflected_attrs_for_all_mobile_banners_for_clients_property->get(60) || "";
    my $show_reflected_attrs_for_all_mobile_banners = $show_reflected_attrs_for_all_mobile_banners_property->get(60) // 0;
    return ($client_ids{$client_id}) ? 1 : $show_reflected_attrs_for_all_mobile_banners;
}

=head3 _merge_banner_data($banner, $row, %options)

    Общий код для баннера с картинкой и без: заполняет необходимые поля в $banner данными из $row

    _merge_banner_data($banner, $row,
                       PriorityID => $PriorityID,
                       domain_cache => \%domain_cache,
                       domain_bs_id_cache => \%domain_bs_id_cache,
                       );

    Параметры:
        $banner,        # hashref с данными по баннеру, которые будут отправлены в БК
        $row,           # hashref с данными о заказе/условии/баннере (элемент данных "снепшота")
        domain_cache => \%domain_cache,     # кеш связей "домен - фильтр_домен"
        domain_bs_id_cache => \%domain_bs_id_cache, # кэш связей "домен - id домена из БК"
        PriorityID => $PriorityID,          # PriorityID этого баннера (само поле устарело, используется
                                            # только как маркер "баннер был/не был в БК"), но передается
                                            # в некоторых случаях как StartPriorityID
    Кроме того, использует глобальные:
        $DOMAINS_WITH_BLOCKED_TITLE     - словарь доменов, которым нужно выставить флаг отключения загловка на выдаче
        $DOMAINS_DICT - словарь доменов (domain_id => domain)
        $FEEDS - словарь с данными по фиду
        $SITELINKS_SETS - словарь с сайтлинками
        $error_logger - для логирования ошибок

=cut
sub _merge_banner_data {
    my ($banner, $row, %O) = @_;

    # баннер идет не с минимальным набором полей, поэтому возводим флаг обновления данных в БК.
    $banner->{UpdateInfo} = 1;

    # признак "мобильный баннер"
    $banner->{Mobile} = $row->{b_type} eq 'mobile' ? 1 : 0;
    # признак "динамический баннер"
    $banner->{Dynamic} = _is_dynamic_banner($row);

    if ($row->{strategy_id}) {
        $banner->{StrategyID} = _nosoap($row->{strategy_id});
    }

    if (_is_text_banner($row) || _is_image_ad_text_banner($row)
        || _is_mcbanner_banner($row) || _is_cpm_banner($row)
        || _is_cpc_video_banner_non_mobile_content($row) || _is_cpm_outdoor_banner($row) || _is_cpm_indoor_banner($row)
        || _is_cpm_audio_banner($row) || _is_content_promotion_banner($row)
        || _is_cpm_geo_pin_banner($row)) {
        # Только для текстовых баннеров
        state $send_turbo_site_as_domain_prop = Property->new('SEND_TURBO_SITE_AS_DOMAIN_PLACEHOLDER');
        my $use_turbo_site_placeholder_for_turbohref_domain = $send_turbo_site_as_domain_prop->get(60) // 0;
        if ( $row->{Href} ) {
            $banner->{Href} = _get_href_with_campaign_tracking_params(_prepare_href($row->{Href}), $row);
            # Если ссылку на турбостраницу вбили в качестве ссылки на баннер, и домен был обработан неправильно,
            # костылим отправку site, похожего на правильный
            if ($use_turbo_site_placeholder_for_turbohref_domain && _is_turbo_href($row->{Href}) && !_is_turbo_site_domain($row->{Site})) {
                $banner->{Site} = TURBO_SITE;
            } elsif ( $row->{Site} && Yandex::IDN::is_valid_domain($row->{Site}) ) {
                $banner->{Site} = $row->{Site};
            } else {
                $banner->{Site} = get_host($row->{Href});
            }
            my $site_ascii = Yandex::IDN::idn_to_ascii($banner->{Site});
            $banner->{SiteFilter} = strip_www($site_ascii);
            $banner->{DomainFilter} = _get_domain_filter($banner->{Site}, domain_cache => $O{domain_cache});
            if ($row->{banner_pId} && $AGGREGATOR_DOMAINS->{ $row->{banner_pId} }) {
                $banner->{ClusterDomain} = $AGGREGATOR_DOMAINS->{ $row->{banner_pId} };
            }

            $banner->{HideDomain} = $row->{Site} && $DOMAINS_WITH_BLOCKED_TITLE->{ strip_www($row->{Site}) } ? 1 : 0;
            if (defined $row->{display_href}
                    && $row->{display_href} ne ''
                    && $row->{dh_statusModerate} eq 'Yes'
                    && !_camp($row, 'no_display_hrefs') ) {
                $banner->{HrefText} = $row->{display_href};
            }
            my $displayed_domain_alias = _parse_displayed_domain_alias($banner->{Href});
            $banner->{DisplayedDomainAlias} = $displayed_domain_alias if $displayed_domain_alias;
        } elsif (_has_turbolanding($row)){
            #если есть только турболендинг - в качестве DomainFilter используем его id
            my $tl_id = $row->{banner_tl_id};
            $banner->{DomainFilter} = $tl_id.TURBOLANDINGS_FILTER_DOMAIN_SUFFIX;
            $banner->{Href} = _get_href_with_campaign_tracking_params(_extend_tl_url($TURBOLANDINGS->{ $tl_id }, $row), $row);
            $banner->{Site} = $use_turbo_site_placeholder_for_turbohref_domain ? TURBO_SITE : get_host($banner->{Href});
        } elsif ( _has_moderated_vcard_with_phone_and_no_manual_permalink($row) ) {
            # если нет ссылки - то в качестве фильтра доменов используем номер телефона без дополнительного номера
            my $phone_domain = TextTools::phone_domain(_get_vcard_data($row)->{phone}); # 74951234567.phone

            $banner->{DomainFilter} = _get_domain_filter($phone_domain, domain_cache => $O{domain_cache});
            $banner->{Href} = '';
            $banner->{Site} = '';
        } elsif (_is_image_ad_text_banner($row) && _has_published_manual_permalink($row) || _is_cpm_geo_pin_banner($row)) {
            # image_ad надо переводить на TemplateID => 410
            # для cpm_geo_pin менять шаблон не планируем
            my $manual_permalink = _get_active_manual_permalink($row);
            my $permalink = $manual_permalink->{permalink};
            $banner->{Href} = sprintf 'https://yandex.ru/profile/%s', $permalink;
            $banner->{Site} = get_host( $banner->{Href} );
            $banner->{DomainFilter} = $permalink.PERMALINKS_FILTER_DOMAIN_SUFFIX;
            $banner->{DisplayedDomainAlias} = SPRAV_DOMAIN_ALIAS;
        } elsif (_has_published_manual_permalink($row)) {
            my $manual_permalink = _get_active_manual_permalink($row);
            my $permalink = $manual_permalink->{permalink};
            $banner->{DomainFilter} = "$permalink";
            $banner->{DisplayedDomainAlias} = SPRAV_DOMAIN_ALIAS;
        }

    } elsif (_is_dynamic_banner($row)) {
        # Только для динамических баннеров

        # проверка на кривые данные - должен быть или фид, или домен
        if (!$row->{dyn_adgroup_feed_id} && !$row->{dynamic_main_domain_id} && !$row->{text_adgroup_feed_id}
            || $row->{dyn_adgroup_feed_id} && $row->{dynamic_main_domain_id}
            || $row->{dyn_adgroup_feed_id} && $row->{text_adgroup_feed_id}
            || $row->{dynamic_main_domain_id} && $row->{text_adgroup_feed_id}
        ) {
            $log->die({
                error => "bad dynamic banner",
                dyn_adgroup_feed_id => $row->{dyn_adgroup_feed_id},
                dynamic_main_domain_id => $row->{dynamic_main_domain_id},
                text_adgroup_feed_id => $row->{text_adgroup_feed_id},
                EID => $banner->{EID},
            });
        }

        # внутри _merge_bannerland_data_dynamic есть такая же пара условий для заполнения данных
        if ($row->{dynamic_main_domain_id}) {
            # ДО по сайту

            my $dynamic_main_domain = $DOMAINS_DICT->{ $row->{dynamic_main_domain_id} };
            unless ($dynamic_main_domain) {
                # какая-то совсем нештатная ситуация, если домена не нашлось
                $log->die({
                    error => "no main_domain for dynamic banner",
                    EID => $banner->{EID},
                    dynamic_main_domain_id => $row->{dynamic_main_domain_id},
                });
            }

            # флаг вычисляется по другим данным.
            $banner->{HideDomain} = $DOMAINS_WITH_BLOCKED_TITLE->{ strip_www($dynamic_main_domain) } ? 1 : 0;


        } elsif ($row->{dyn_adgroup_feed_id}) {
            # ДО по фиду

            unless (exists $FEEDS->{ $row->{dyn_adgroup_feed_id} }) {
                # не должно быть такого
                $log->die({
                    error => "no feed data for dynamic banner",
                    EID => $banner->{EID},
                    dyn_adgroup_feed_id => $row->{dyn_adgroup_feed_id},
                });
            }

            # не поддерживаем черный список доменов, потому что нет домена.
            $banner->{HideDomain} = 0;
        } elsif ($row->{text_adgroup_feed_id}) {
            # не заполняем домен, как в смартах
        } else {
            die "UNREACHABLE";
        }

        # Данные для BannerLand
        _merge_bannerland_data_dynamic($banner, $row, domain_cache => $O{domain_cache});

    } elsif (_is_mobile_content_banner($row) || _is_image_ad_mobile_content_banner($row) || _is_cpc_video_mobile_content_banner($row)) {
        # Только для баннеров типа "реклама мобильного контента"
        my $banner_mobile_content = $MOBILE_CONTENT->{ $row->{mobile_content_id} };
        my $banner_mobile_app = $MOBAPP_INFO_BY_CID->{ $row->{campaign_pId} } // {};

        $banner->{MobileAppID} = $row->{mobile_content_id};
        $banner->{ContentAction} = $row->{b_primary_action} // 'download';

        # Какие части баннера скрывать на выдаче
        my %banner_reflected_attrs;
        if (defined $row->{reflected_attrs}) {
            for my $attr (split(qr/,/, $row->{reflected_attrs})) {
                $banner_reflected_attrs{$attr} = undef;
            }
        }
        $banner->{HideContentIcon} = !exists $banner_reflected_attrs{icon} ? 1 : 0;
        $banner->{HideStoreContentRating} = !exists $banner_reflected_attrs{rating} ? 1 : 0;
        $banner->{HideStoreContentPrice} = !exists $banner_reflected_attrs{price} ? 1 : 0;
        $banner->{HideContentReviewCount} = !exists $banner_reflected_attrs{rating_votes} ? 1 : 0;

        if (_is_show_reflected_attrs_enabled($row->{ClientID}) && (_is_image_ad_mobile_content_banner($row) || _is_cpc_video_mobile_content_banner($row))) {
            $banner->{HideContentIcon} = 0;
            $banner->{HideStoreContentRating} = 0;
            $banner->{HideStoreContentPrice} = 0;
            $banner->{HideContentReviewCount} = 0;
        }

        if (!defined $banner_mobile_content->{os_type}
            || none { $_ eq $banner_mobile_content->{os_type} } @{Direct::Model::MobileContent->meta->find_attribute_by_name('os_type')->params->{values}}) {

            $log->die("undefined mobile OS type " . join "-", map { $_ // '' } @{$banner_mobile_content}{qw/os_type store_content_id bundle_id/});
        }

        # трекинговая система
        $banner->{MobileTracker} = BS::ExportMobileContent::get_mobile_tracker($row->{Href});

        # трекинговая ссылка из баннера или ссылка на стор
        $banner->{Href} = _prepare_href(
            # к трекинговым ссылкам пытаемся дописать некоторые параметры
            BS::ExportMobileContent::add_params_to_tracking_href($row->{Href}, $banner_mobile_content->{os_type}, 0)
            || $row->{store_content_href}
        );
        if (BS::ExportMobileContent::is_s2s_enabled($row->{Href})) {
            $banner->{HrefS2S} = _prepare_href(
                # к трекинговым ссылкам пытаемся дописать некоторые параметры
                BS::ExportMobileContent::add_params_to_tracking_href($row->{Href}, $banner_mobile_content->{os_type}, 1)
                    || $row->{store_content_href}
            );
        }

        # трекинговая ссылка для учёта показа
        if (defined $row->{impression_url} || defined $row->{mobile_app_impression_url}) {
            my $impression_url = $row->{impression_url} || $row->{mobile_app_impression_url};
            if ($impression_url ne "") {
                $banner->{ImpressionUrl} = _prepare_href(
                    # к трекинговым ссылкам пытаемся дописать некоторые параметры
                    BS::ExportMobileContent::add_params_to_tracking_href($impression_url, $banner_mobile_content->{os_type}, 2)
                );
            }
        }

        # альтернативные сторы
        # если alternative_app_stores в таблице NULL или '', то будем отправлять пустой лист
        state $enable_alternative_app_stores_prop = Property->new('ENABLE_ALTERNATIVE_APP_STORES');
        my $enable_alternative_app_stores = $enable_alternative_app_stores_prop->get(60) // 0;

        if ($enable_alternative_app_stores && defined $row->{alternative_app_stores}) {
            my @alt_app_stores = split(/,/, $row->{alternative_app_stores} // '');
            my @bs_alt_app_stores = ();
            for my $store (@alt_app_stores) {
                if (exists(ALTERNATIVE_APP_STORES->{$store})) {
                    push @bs_alt_app_stores, {'StoreName' => ALTERNATIVE_APP_STORES->{$store}};
                } else {
                    $log->warn("Unexpected alternative app store: $store");
                }
            }
            $banner->{AltAppStores} = \@bs_alt_app_stores;
        }

        # ссылка для перехода в стор
        $banner->{ContentStoreHref} = $row->{store_content_href};
        if (BS::ExportMobileContent::is_s2s_enabled($row->{Href})) {
            my $content_store_href_s2s =  BS::ExportMobileContent::add_params_to_s2s_store_href($row->{store_content_href}, $banner->{MobileTracker}, $banner_mobile_content->{os_type});
            if (defined $content_store_href_s2s) {
                $banner->{ContentStoreHrefS2S} = _prepare_href($content_store_href_s2s);
            }
        }

        # displayed_domain_alias
        if ( $row->{store_content_href}) {
            my $displayed_domain_alias = _parse_displayed_domain_alias($row->{store_content_href});
            $banner->{DisplayedDomainAlias} = $displayed_domain_alias if $displayed_domain_alias;
        }


        my $store_app_id = Direct::Model::MobileContent->get_store_app_id($banner_mobile_content);
        $banner->{SiteFilter} = Yandex::IDN::idn_to_ascii($store_app_id);
        $banner->{Site} = get_host($row->{store_content_href});

        my $publisher_domain_id;
        if (defined $banner_mobile_app->{mobile_content_id} && $banner_mobile_app->{mobile_content_id} == $banner_mobile_content->{mobile_content_id}) {
            $publisher_domain_id = $banner_mobile_app->{domain_id} // $banner_mobile_content->{publisher_domain_id} // 0;
        } else {
            $publisher_domain_id = $banner_mobile_content->{publisher_domain_id} // 0;
        }
        my $publisher_domain = $DOMAINS_DICT->{ $publisher_domain_id };
        my $main_domain;
        if ($publisher_domain) {
            # Если есть домен издателя - берем его главный домен по базе зеркал
            $main_domain = _get_domain_filter($publisher_domain, domain_cache => $O{domain_cache});
        }

        # если $publisher_domain некорректный, то его главное зеркало может быть пустым
        if ($main_domain) {
            # Если есть домен издателя - берем его главный домен по базе зеркал
            $banner->{DomainFilter} = $main_domain;
        } elsif ($banner->{SiteFilter}) {
            # иначе - package_name / bundle_id
            $banner->{DomainFilter} = $banner->{SiteFilter};
        } else {
            # а если и его нет - фиктивный домен ClientID.mobapp
            $banner->{DomainFilter} = _camp($row, 'ClientID') . '.mobapp';
        }
        # если домен приклеен к общеизвестному, но package_name / bundle_id не совпадает с ним, заменяем
        if (BS::ExportMobileContent::is_glued_domain($banner->{DomainFilter}, $banner->{SiteFilter})) {
            my $store_prefix = 'UnknownStore_';
            if ($banner_mobile_content->{os_type} eq 'Android') {
                $store_prefix = 'GooglePlay_';
            } elsif ($banner_mobile_content->{os_type} eq 'iOS') {
                $store_prefix = 'ITunes_';
            }
            if ($banner->{SiteFilter}) {
                $banner->{DomainFilter} = $store_prefix . $banner->{SiteFilter};
            } else {
                $banner->{DomainFilter} = $store_prefix . $banner->{DomainFilter};
            }
        }

        $banner->{AppData} = _nosoap(BS::ExportMobileContent::get_app_data($banner_mobile_content, $banner_mobile_app));

        # для рекламы мобильных приложений отображение домена в заголовке не предусмотрено.
        $banner->{HideDomain} = 1;
    } elsif (_is_internal_banner($row)) {
        _set_template_variables($banner, $row);
        if ($row->{template_id} >= DIRECT_TEMPLATE_ID_START_VALUE) {
            $banner->{TemplateID} = UNIFIED_TEMPLATE_ID;
        } else {
            $banner->{TemplateID} = $row->{template_id};
        }
        $banner->{DistributionFormatID} = _nosoap($row->{template_id});
    }

    if (_is_text_banner($row)
        || _is_mobile_content_banner($row)
        || _is_image_ad_or_mcbanner_banner($row)
        || _is_cpm_banner($row)
        || _is_cpc_video_banner($row)
        || _is_cpm_audio_banner($row)
    ) {
        # обработка шаблонов
        if (is_template_banner( { title => $row->{Title},
                                  title_extension => $row->{TitleExtension},
                                  body  => $row->{Body},
                                  href => $banner->{Href},
                                  display_href => $banner->{HrefText}, } )
        ) {
            $row->{Title} =~ s/$TEMPLATE_METKA/{PHRASE$1}/gsi;
            $row->{TitleExtension} =~ s/$TEMPLATE_METKA/{PHRASE$1}/gsi if defined $row->{TitleExtension};
            $banner->{Href} =~ s/$TEMPLATE_METKA/{PHRASE$1}/gsi;
            $row->{Body} =~ s/$TEMPLATE_METKA/{PHRASE$1}/gsi;
            $banner->{HrefText} =~ s/$TEMPLATE_METKA/{PHRASE$1}/gsi if defined $banner->{HrefText};

            # support old format template metka
            $row->{Title} =~ s/$TEMPLATE_METKA_OLD/{PHRASE}/gsi;
            $row->{TitleExtension} =~ s/$TEMPLATE_METKA_OLD/{PHRASE}/gsi if defined $row->{TitleExtension};
            $row->{Body} =~ s/$TEMPLATE_METKA_OLD/{PHRASE}/gsi;
        }
        # обработка параметров в url
        if ($banner->{Href}) {
            $banner->{Href} = _convert_href_params($banner->{Href}, $row);
        }
        if ($banner->{HrefS2S}) {
            $banner->{HrefS2S} = _convert_href_params($banner->{HrefS2S}, $row);
        }
        if ($banner->{ImpressionUrl}) {
            $banner->{ImpressionUrl} = _convert_href_params($banner->{ImpressionUrl}, $row);
        }
    }

    # в рекламе мобильного контента сайтлинков нет, поэтому зададим их явно
    if (_is_mobile_content_banner($row)) {
        state $sitelinks_percent_prop = Property->new('MOBILE_APP_BANNERS_SITELINKS_ENABLED_PERCENT');
        my $sitelinks_percent = $sitelinks_percent_prop->get(60) // 0;
        if ($sitelinks_percent && $sitelinks_percent > $row->{campaign_pId} % 100) {
            my @mobile_app_sitelinks = BS::ExportMobileContent::generate_sitelinks($banner->{Href});
            $banner->{Sitelinks} = \@mobile_app_sitelinks;
        }
    } elsif ($row->{sitelinks_set_id}
        # отправляем только если приняли сайтлинки или отсылаем баннер без них если отклонили
        && $row->{statusSitelinksModerate} eq 'Yes'
    ) {
        $banner->{Sitelinks} = [];

        if (exists $SITELINKS_SETS->{ $row->{sitelinks_set_id} }) {
            my $sitelinks = dclone($SITELINKS_SETS->{ $row->{sitelinks_set_id} });
            my $is_dynamic_or_performance_banner = _is_dynamic_banner($row) || _is_performance_banner($row);
            foreach my $sl_item (@$sitelinks) {
                my $sl_url_processed = '';
                if (defined $sl_item->{href} && $sl_item->{href} gt '') {
                    my $sl_url = $is_dynamic_or_performance_banner
                        ? _prepare_href($sl_item->{href})
                        : _get_href_with_campaign_tracking_params(_prepare_href($sl_item->{href}), $row);
                    $sl_url_processed = _convert_href_params($sl_url, $row);
                }
                my $sitelink_data = {
                    Title => $sl_item->{title},
                    Description => $sl_item->{description},
                    ($sl_url_processed gt ''  ? (Href => $sl_url_processed) : ()),
                    $sl_item->{turbolanding}  ? (
                            TurboLandingHref => _extend_tl_url($sl_item->{turbolanding}->{href}, $row),
                            TurboLandingId   => $sl_item->{turbolanding}->{id},
                    ) : (),
                };
                if (($sitelink_data->{TurboLandingHref} // '') gt '') {
                    $sitelink_data->{Href} //= $is_dynamic_or_performance_banner
                        ? $sitelink_data->{TurboLandingHref}
                        : _get_converted_href_with_campaign_tracking_params($sitelink_data->{TurboLandingHref}, $row);
                }
                push @{$banner->{Sitelinks}}, $sitelink_data;
            }
        } else {
            $error_logger->({
                message     => "sitelinks set is absent in dict",
                cid         => $row->{campaign_pId},
                bid         => $row->{banner_pId},
                sitelinks_set_id => $row->{sitelinks_set_id},
                type        => "banner",
                stage       => "request",
            });
        }
    }

    if (_has_turbolanding($row)) {
        $banner->{TurboLandingHref} = _extend_tl_url($TURBOLANDINGS->{ $row->{banner_tl_id} }, $row);
        $banner->{TurboLandingId}   = $row->{banner_tl_id};
        if (_is_cpm_geoproduct_adgroup($row)) {
            $banner->{Href} = $banner->{TurboLandingHref};
        }
    }

    if (_is_text_banner($row) && $row->{banner_turbo_gallery_href}) {
        $banner->{Resources}->{TurboGalleryHref} = _nosoap($row->{banner_turbo_gallery_href});
    }

    $banner->{Body} = html2string($row->{Body});
    if (!_is_dynamic_banner($row)) {
        $banner->{Title} = html2string($row->{Title});
        $banner->{TitleExtension} = html2string($row->{TitleExtension}) if defined $row->{TitleExtension};
        $banner->{Lang} = get_banner_lang($row, [$row->{Title}, $row->{TitleExtension}, $row->{Body}]);
    }

    # если баннер не остановлен — отправляем предыдущий PriorityID
    if (!$banner->{Stop} && $O{PriorityID}) {
        $banner->{StartPriorityID} = $O{PriorityID};
    }
    $banner->{PriorityID} = $O{PriorityID};

    $banner->{GeoFlag} = ($row->{GeoFlag}) ? 1 : 0;

    if ( _camp($row, 'metrika_counters') ) {
        my @counters = split /\s*,\s*/, _camp($row, 'metrika_counters');
        $banner->{MetrikaCounter} = $counters[0];
    }
    else {
        $banner->{MetrikaCounter} = undef;
    }

    if (_has_moderated_vcard_with_phone_and_no_manual_permalink($row)
        # для рекламы мобильных приложений и перфомас - визиток нет
        && !_is_mobile_content_banner($row)
        && !_is_performance_banner($row)
    ) {
        my %contact_hash = ();
        my $vcard_data = _get_vcard_data($row);

        $contact_hash{Phone} = $vcard_data->{phone};

        $contact_hash{Country} = $vcard_data->{country};
        $contact_hash{City} = $vcard_data->{city};
        $contact_hash{Name} = $vcard_data->{name};

        Yandex::I18n::init_i18n(($banner->{Lang} // '') eq 'uk' ? 'ua' : ($banner->{Lang} // ''));

        my @addr = ();
        push @addr, $vcard_data->{street} if $vcard_data->{street};
        push @addr, iget('д. %s', $vcard_data->{house}) if $vcard_data->{house};
        push @addr, iget('корп. %s', $vcard_data->{build}) if $vcard_data->{build};
        push @addr, iget('офис %s', $vcard_data->{apart}) if $vcard_data->{apart};
        $contact_hash{Address} = join( ", ", @addr);
        $contact_hash{GeoID} = $vcard_data->{geo_id} if $vcard_data->{geo_id};
        $contact_hash{ContactPerson} = $vcard_data->{contactperson};
        $contact_hash{Metro} = $vcard_data->{metro} ? $vcard_data->{metro} : undef; # 0 - клиент выбрал "не показывать станцию"
        $contact_hash{OGRN} = $vcard_data->{ogrn};

        if ( $vcard_data->{im_client} && $vcard_data->{im_login} ) {
            $contact_hash{IMClient} = $vcard_data->{im_client};
            $contact_hash{IMLogin} = $vcard_data->{im_login};
        }

        $contact_hash{ExtraMessage} = $vcard_data->{extra_message};
        $contact_hash{ContactEmail} = $vcard_data->{contact_email};

        # WorkTimeRaw как машиночитаемый формат используется для формирования факторов про элементы дизайна (YABS-61208)
        $contact_hash{WorkTimeRaw} = $vcard_data->{worktime};
        $contact_hash{WorkTime} = VCards::get_worktime_for_bs($vcard_data->{worktime}, $banner->{Lang});

        # отправляем координаты точки на карте, а также рекомендуемые границы области карты
        if ($vcard_data->{mid}) {
            map { $contact_hash{Map}->{uc $_} = $vcard_data->{$_} } qw/x1 y1 x2 y2/;

            my $precision = $vcard_data->{precision} || '';
            if ($vcard_data->{precision} && ($vcard_data->{precision} eq 'exact' || $vcard_data->{precision} eq 'number')
                || $vcard_data->{map_id} && $vcard_data->{map_id_auto} && $vcard_data->{map_id} != $vcard_data->{map_id_auto}
               )
            {
                # если точное совпадение(=поиск), то отправляем в БК центральную точку или установленна ручная точка не совпадающая с найденной
                map { $contact_hash{Map}->{uc $_} = $vcard_data->{$_} } qw/x y/;
                $precision = 'exact';
            }

            $contact_hash{Map}->{Precision} = $precision;
        }

        $banner->{ContactInfo} = \%contact_hash;
    }

    if (my $permalink_data = _get_permalink_data($row)) {
        my $manual_permalink = $permalink_data->{permalinks}{manual};
        if ($manual_permalink && $manual_permalink->{status_publish} eq 'published') {
            $banner->{Permalink} = $manual_permalink->{permalink};
            if ($manual_permalink->{prefer_vcard_over_permalink}) {
                $banner->{PermalinkAssignType} = _nosoap('auto');
            } else {
                $banner->{PermalinkAssignType} = _nosoap('manual');

                my $client_phone_data = _get_client_phone_data($row);
                if ($client_phone_data && $client_phone_data->{phone}) {
                    $banner->{PermalinkAdPhone} = $client_phone_data->{phone};
                }
            }
        } elsif ($permalink_data->{permalinks}{auto}) {
            $banner->{Permalink} = $permalink_data->{permalinks}{auto}{permalink} // 0;
            $banner->{PermalinkAssignType} = _nosoap('auto');
        }
        $banner->{PermalinkChainIDs} = $permalink_data->{chain_ids};

        delete $banner->{ContactInfo} if $banner->{ContactInfo} && $manual_permalink && !$manual_permalink->{prefer_vcard_over_permalink};
    }

    if(defined $banner->{DomainFilter} && $banner->{DomainFilter} ne '') {
        $banner->{DomainFilter} = lc $banner->{DomainFilter};
        $banner->{DomainFilterID} = _get_domain_bs_id($row->{campaign_pId}, $banner->{DomainFilter}, domain_bs_id_cache => $O{domain_bs_id_cache});
    }

    if(defined $banner->{SiteFilter} && $banner->{SiteFilter} ne '') {
        $banner->{SiteFilter} = lc $banner->{SiteFilter};
        $banner->{SiteFilterID} = _get_domain_bs_id($row->{campaign_pId}, $banner->{SiteFilter}, domain_bs_id_cache => $O{domain_bs_id_cache});
    }
}

sub _set_template_variables {
    my ($banner, $row) = @_;

    my $template_variables = _get_template_variables($row);
    my $template_properties = _get_template_properties($row);

    if ($template_properties && $template_properties->{state} ne 'default') {
        my $unified_template_variables = convert_template_variables_to_bs_format($template_variables, unified => 1);
        if ($template_properties->{format_name}) {
            push @$unified_template_variables, _template_format_resource($template_properties->{format_name});
        }

        if ($row->{template_id} < DIRECT_TEMPLATE_ID_START_VALUE) {
            push @$unified_template_variables, _template_original_id_resource($row->{template_id});
        }

        $banner->{Resources}->{UnifiedTemplateVariables} = _nosoap($unified_template_variables);
    }

    if (!$template_properties || $template_properties->{state} ne 'unified') {
        $banner->{Resources}->{TemplateVariables} = _nosoap(convert_template_variables_to_bs_format($template_variables, unified => 0));
    }
}

sub _template_format_resource {
    my ($format) = @_;
    return {
        Value => $format,
        TemplateResourceID => 6152,
        TemplateResourceNo => 94,
        TemplatePartNo => 0,
    };
}

sub _template_original_id_resource {
    my ($template_id) = @_;
    return {
        Value => $template_id,
        TemplateResourceID => 6153,
        TemplateResourceNo => 95,
        TemplatePartNo => 0,
    };
}

sub _extract_target_flat {
    my ($data, $row) = @_;

    if (!_is_dynamic_banner($row) && !_is_target_flat_disabled($row)) {
        $data->{TargetFlat} = [] if !exists $data->{TargetFlat};

        # добавляем рубрики Каталогии
        if ($row->{catalogia_categories}) {
            # в любом случае добавляем сами рубрики Каталогии, если они есть
            my @catalogia_categories = split(/,/, $row->{catalogia_categories});
            push @{$data->{TargetFlat}}, @catalogia_categories;
        }
        $data->{TargetFlat} = [uniq @{$data->{TargetFlat}}];
    }
}

sub _is_target_flat_disabled {
    my ($row) = @_;

    state $percent_prop = Property->new("BS_EXPORT_TARGET_FLAT_DISABLED_PERCENT");
    my $percent = $percent_prop->get(60) || 0;

    if ($row->{campaign_pId} && $row->{campaign_pId} % 100 < $percent) {
        return 1;
    }

    return 0;
}

sub _extract_context {

    my ($row, $query, %options) = @_;

    my $quantity = 0;
    my $order = extract_base_order($query, $row);
    my $context = extract_base_context($order, $row);

    # при обновлении контекста - внутри должны быть перечислены все баннеры, заполняем:
    # текстовый баннер  # NB: подозрительно, могут попадать баннеры без BannerID
    extract_base_banner($context, $row);
    # картинка
    if ($row->{image_BannerID}) {
        extract_base_banner($context, 
                            $row, 
                            is_image => 1,
                            cid_pid_bid_to_image_id_as_one => $options{cid_pid_bid_to_image_id_as_one},
                            );
        $options{banner_images_sent}->{$row->{image_id}} = undef;
    }

    # создаем пустые блоки для фраз/ретаргетинга/нацеливаний
    $context->{PHRASE} //= {};
    $context->{GOAL_CONTEXT} //= SOAP::Data->type(map => {});
    $context->{DYNAMIC} //= SOAP::Data->type(map => {});
    $context->{FILTER} //= SOAP::Data->type(map => {});
    $context->{RELEVANCE_MATCH} //= SOAP::Data->type(map => {});
    $context->{AdditionalTargetings} //= SOAP::Data->type(map => {});
    $context->{OFFER_RETARGETING} //= _nosoap({});

    unless ($context->{UpdateInfo}) {
        ++$quantity;

        my @geo = split(/,/, $row->{Geo});
        $context->{Geo} = \@geo if ($row->{Geo} ne '0');

        my $minus_phrases = _extract_group_minus_words($row);
        $context->{MinusPhrases} = _process_minus_phrases($minus_phrases);

        if (_is_internal_adgroup($row)) {
            $context->{AdGroupLevel} = $row->{adgroups_internal_level};
            $context->{MaxRF} = $row->{adgroups_internal_rf};
            if ($row->{adgroups_internal_rf} == 0) {
                $context->{RFDays} = 0;
            } else {
                $context->{RFDays} = $row->{adgroups_internal_rfReset};
            }
            $context->{StartTime} = $row->{adgroups_internal_start_time};
            $context->{FinishTime} = $row->{adgroups_internal_finish_time};
        }

        if (_is_cpm_yndx_frontpage_adgroup($row)
            || (_is_cpm_price_campaign($row) && _is_cpm_video_adgroup($row))
        ) {
            #если приоритета нет, то ставим дефолтный
            $context->{MatchPriority} = $row->{adgroup_priority_pr} || 0;
        }

        # коэффициенты к ставкам
        _merge_mobile_price_coef($row, context => $context);
        _merge_desktop_price_coef($row, context => $context);
        _merge_product_type_coef($row, context => $context, video => 'Video');
        if (_is_performance_adgroup($row)) {
            _merge_product_type_coef($row, context => $context, performance_tgo => 'PerformanceTgo');
        }
        _merge_socdem_coef($row, context => $context);
        _merge_retargeting_coef($row, context => $context);
        _merge_weather_coef($row, context => $context);
        _merge_expression_coefs($row, context => $context);
        if (_is_mobile_content_adgroup($row)) {
            _merge_mobile_content_targetings($context, $row);
            BS::ExportMobileContent::merge_content_store_data($context, $MOBILE_CONTENT->{ $row->{mobile_content_id} });
        }
        if (_is_cpm_outdoor_adgroup($row) || _is_cpm_indoor_adgroup($row)) {
            _merge_page_blocks($context, $row);
        }

        _merge_page_group_tags($context, $row);
        _merge_target_tags($context, $row);
    }

    $context->{Resources} //= {};
    if ((($row->{adgroup_href_params} // '') ne '') || ((_camp($row, 'campaign_href_params') // '') ne '')) {
        if (_is_performance_adgroup($row) || _is_dynamic_adgroup($row)) {
            $context->{Resources}->{ClickUrlTail} = SOAP::Data->type('string')->value(_get_hrefparams($row));
        }
    }

    $context->{UpdateInfo} ||= 1;

    ${$options{context_ref}} = $context if $options{context_ref};
    return $quantity;
}

=head3 _extract_phrase($camp, $context, $row, $banner_images_map, $extra_goal_context)

    $bids_cnt += _extract_phrase($camp, $context, $row, $banner_images_map);

    Извлекает из "строки" с данными $row "фразу" в контекст $context
    Параметры:
        $camp       - hashref с данными по кампании (автооптимизация, автобюджет, стратегия, валюта, ...)
        $context    - hashref - данные (для отправки) по контексту, в него будет добавлена фраза
        $row        - hashref - "строка" с данными про фразу ($PHRASES->{$pid}->[...])
        $banner_images_map      - хеш соответствия bi.image_id => bi.bid
        $data_row  - "строка" с данными с предыдущего уровня (ORDER/CONTEXT) из базы
        $audience_segment_goal_ids - hashref, если не undef то в него нужно будет сложить условия нацеливания на Я.Аудиторию
        $extra_goal_context - массив дополнительных retargeting_condition которые будут по И объединены со всеми условия ретаргетинга
    Кроме того, использует глобальные:
        $RETARGETING_CONDITIONS - хеш со словарем условий ретаргетинга
        $DYNAMIC_CONDITIONS — хеш со словарём условий нацеливания
        $PERFORMANCE_CONDITIONS — хеш со словарём фильтров
        $CLIENT_NDS_CACHE
    Результат:
        $extracted_phrases_cnt  - количество добавленных в контекст "фраз" (0 или 1)

=cut

sub _extract_phrase {
    my ($camp, $context, $row, $banner_images_map, $data_row, $audience_segment_goal_ids, $extra_goal_context) = @_;

    # фраза остановлена, не отсылаем её (в БК удалится)
    return 0 if $row->{phrase_is_suspended};

    my $phrase;
    if ($row->{phrase_type} eq 'bids') {
        $phrase = BS::Export::get_query_data($context, 'PHRASE', [$row->{phrase_Id}, $row->{phrase_pId}], [qw/ID EID/]);
    } elsif ($row->{phrase_type} eq 'retargetings') {
        # код вызывается для каждого баннера группы, но обрабатываем GOAL_CONTEXT один раз
        if (!exists $context->{GOAL_CONTEXT}->value->{$row->{phrase_Id}}) {
            $phrase = $context->{GOAL_CONTEXT}->value->{$row->{phrase_Id}} = {
                ID  => $row->{phrase_Id},  # ret_cond_id
                EID => $row->{phrase_pId}  # ret_id
            };
            if (_is_internal_campaign($data_row)) {
                # Для кампаний внутренней рекламы goalContext должен быть привязан к
                # контексту явно (BSDEV-78816)
                my $targeting_expression = _get_or_create_context_targeting_expression($context);
                push @{$targeting_expression}, [["goal-context-id", "match goal context", "" . $row->{phrase_Id}]];
            }
        }
    } elsif ($row->{phrase_type} eq 'dynamic') {
        $phrase = $context->{DYNAMIC}->value->{$row->{phrase_Id}} = {
            ID => $row->{phrase_Id},
            EID => $row->{phrase_pId},
        };
    } elsif ($row->{phrase_type} eq 'performance') {
        $phrase = $context->{FILTER}->value->{"F_".$row->{phrase_Id}} = {
            EID => $row->{phrase_Id},
        };
    } elsif (any {$row->{phrase_type} eq $_} @RELEVANCE_MATCH_BIDS_BASE_TYPES) {
        $phrase = $context->{RELEVANCE_MATCH}->value->{$row->{phrase_pId}} = {
            EID => $row->{phrase_pId},
        };
    } elsif ($row->{phrase_type} eq 'adgroup_additional_targetings') {
        if (!exists $context->{AdditionalTargetings}->value->{$row->{phrase_pId}}) {
            _merge_additional_targetings($context, $row);
            # _extract_phrase вызывается для каждого баннера группы,
            # данной проверкой избегаем дублирование таргетингов в TargetingExpression
        }
        $phrase = $context->{AdditionalTargetings}->value->{$row->{phrase_pId}} = {
            EID => $row->{phrase_pId},
        };
    } elsif ($row->{phrase_type} eq 'offer_retargeting') {
        $phrase = $context->{OFFER_RETARGETING}->value->{$row->{phrase_pId}} = {
            EID => $row->{phrase_pId},
        };
    } else {
        $log->die("invalid phrase_type: " . ($row->{phrase_type} // 'undef') . ' for EID: ' . ($row->{phrase_pId} // 'undef'));
    }

    $phrase->{UpdateInfo} = 1;

    # Заполняем поля, относящиеся к ставке
    _extract_price_fields($phrase, $camp, $row, $data_row);
    my %Params;

    if (any { $row->{phrase_type} eq $_ } (qw/bids offer_retargeting/, @RELEVANCE_MATCH_BIDS_BASE_TYPES)) {
        foreach my $pn (1..2) {
            $Params{$pn} = $row->{"UrlParam$pn"};
        }
        if ($row->{has_phraseid_href}) {
            $Params{127} = $row->{'phrase_pId'};
        }

        # исправление warning - прописываем тип map
        # TODO: разделить формирование данных и их сериализацию
        $phrase->{Params} = SOAP::Data->type(map => \%Params);
    }

    if ($row->{phrase_type} eq 'bids') {
        # текстовая фраза
        if ($camp->{autoOptimization} eq 'Yes' && $row->{phrase_type} eq 'bids') {
            $phrase->{optimizeTry} = $row->{optimizeTry};
        }
        $phrase->{Text} = Yandex::MyGoodWords::process_quoted_phrases($row->{Phrase});
        $phrase->{Hits} = defined $row->{showsForecast} ? $row->{showsForecast} : -1;
    }  elsif ($row->{phrase_type} eq 'retargetings') {
        # ретаргетинг
        my $r_condition = $RETARGETING_CONDITIONS->{ $row->{phrase_Id} };

        my $condition = from_json($r_condition->{condition_json}) // [];
        if (ref $condition eq 'ARRAY') {
            push @$condition, @$extra_goal_context;
        } else {
            $log->warn(sprintf("Unexpected data format. Expected ARRAY, but got %s", ref $condition));
        }
        $r_condition->{condition_json} = to_json($condition);

        my @project_param_conditions = defined $data_row->{project_param_conditions}
            ? grep {defined $_} map {$PROJECT_PARAM_CONDITIONS->{ $_ }} @{from_json($data_row->{project_param_conditions})} : ();

        $phrase->{Expression} = Retargeting::retargeting_condition_json_to_bs(
            \$r_condition->{condition_json}, _is_internal_campaign($data_row), \@project_param_conditions);

        if ($audience_segment_goal_ids) {
            foreach my $record (@$condition) {
                foreach my $goal (@{ $record->{goals} }) {
                    if (Primitives::get_goal_type_by_goal_id($goal->{goal_id}) eq 'audience') {
                        $audience_segment_goal_ids->{$goal->{goal_id}} = undef;
                    }
                }
            }
        }

        if ($r_condition->{is_interest}) {
            $Params{125} = $r_condition->{interest_id};
            $Params{126} = $r_condition->{interest_name};
        } elsif ($row->{has_phraseid_href}) {
            $Params{126} = $row->{'phrase_pId'};
        }

        if (%Params) {
            $phrase->{Params} = SOAP::Data->type(map => \%Params);
        }
    } elsif ($row->{phrase_type} eq 'dynamic') {
        # нацеливание
        $Params{127} = $row->{'phrase_Id'};
        $Params{126} = $DYNAMIC_CONDITIONS->{$row->{phrase_Id}}->{condition_name};
        $phrase->{Params} = SOAP::Data->type(map => \%Params);
    } elsif ($row->{phrase_type} eq 'performance') {
        unless (is_strategy_roi_or_crr(_get_camp($data_row))) {
            # В BS::ExportWorker::get_snapshot bids_performance.price_cpc выбирается как Price, а price_cpa как PriceContext"

            my $price_cpc = (($row->{Price} // 0) > 0) ? $row->{Price} : _camp($data_row, 'filter_avg_bid');
            $phrase->{AutoBudgetAvgBid} = get_value_for_sum($price_cpc, _camp($data_row, 'currency'),
                    with_nds => 1, ClientID => _camp($data_row, 'ClientID'), client_nds_cache => $CLIENT_NDS_CACHE,
                    keep_zero => 1, undef_is_zero => 1,
            );

            if (is_strategy_cpa(_get_camp($data_row))) {
                my $price_cpa = (($row->{PriceContext} // 0) > 0) ? $row->{PriceContext} : _camp($data_row, 'filter_avg_cpa');
                $phrase->{AutoBudgetAvgCPA} = get_value_for_sum($price_cpa, _camp($data_row, 'currency'),
                    with_nds => 1, ClientID => _camp($data_row, 'ClientID'), client_nds_cache => $CLIENT_NDS_CACHE,
                    keep_zero => 1, undef_is_zero => 1,
                );
            } else {
                $phrase->{AutoBudgetAvgCPA} = 0;
            }

        }

        hash_merge $phrase, BS::Export::target_funnel_for_BS($row->{target_funnel});

        $Params{127} = $row->{'phrase_pId'};
        $Params{126} = $PERFORMANCE_CONDITIONS->{$row->{phrase_Id}}->{name};
        $phrase->{Params} = SOAP::Data->type(map => \%Params);

        $phrase->{GOAL_CONTEXT} = {};
        if ($PERFORMANCE_CONDITIONS->{$row->{phrase_Id}}->{ret_cond_id}) {
            my $perf_filter = $PERFORMANCE_CONDITIONS->{$row->{phrase_Id}};
            $phrase->{GOAL_CONTEXT}->{ $perf_filter->{ret_cond_id} } = {ID => $perf_filter->{ret_cond_id},
                                                                        Expression => Retargeting::retargeting_condition_json_to_bs(\$perf_filter->{retargeting_condition_json}) };
        }
    } elsif (any {$row->{phrase_type} eq $_} @RELEVANCE_MATCH_BIDS_BASE_TYPES) {
        $phrase->{Type} = $camp->{send_extended_relevance_match_flag} ? 'relevance_match' : 'relevance_match_search';
        $phrase->{RelevanceMatchType} = $BS::Export::BOTH
            if $camp->{send_extended_relevance_match_flag};
    } elsif ($row->{phrase_type} eq 'offer_retargeting') {
        $phrase->{Type} = 'offer_retargeting';
    } elsif ($row->{phrase_type} eq 'adgroup_additional_targetings') {
        $phrase->{TargetingType} = $row->{targeting_type};
        $phrase->{TargetingMode} = $row->{targeting_mode};
        $phrase->{ValueJoinType} = $row->{value_join_type};
        $phrase->{Value} = $row->{value};
    } else {
        # проверка на тип есть в самом начале функции, это место - недостижимо
        $log->die('unreachable code');
    }

    return 1;
}

=head2 $order = extract_base_order($query, $row, %options)

    Создать заказ в крутилошном запросе или достать существующий, если есть.
    Заполнить обязательные поля

    my $order = extract_base_order($query, $row);
    my $order = extract_base_order($query, $row, ID => 20063, EID => 263);

    Параметры:
        $query          - hashref с данными, которые будут отправлены в БК
        $row            - hashref с данными о заказе/условии/баннере (элемент данных "снепшота")
        %options    - дополнительные именованные параметры:
          ID            - использовать указанный ID при извлечении/создании заказа вместо данных
                          о БКшном идентификаторе кампании (OrderID), содержащихся в $row.
                          работает ТОЛЬКО при совместном указании ID и EID
          EID           - использовать указанный EID при извлечении/создании заказа вместо данных
                          о Директовском идентификаторе кампани (cid), содержащихся в $row.
                          работает ТОЛЬКО при совместном указании ID и EID
    Результат:
        $order_data     - hashref с данными (для отправки в БК) по заказу. Берутся либо уже существующие
                          в $query данные по этому заказу, либо заполняются из $row и добавляются в $query.

=cut
sub extract_base_order {
    my ($query, $row, %options) = @_;

    my ($ID, $EID);
    if (defined $options{ID} && defined $options{EID}) {
        ($ID, $EID) = @options{qw/ID EID/};
    } else {
        if (defined $CIDS_TO_BS_ORDER_ID->{$row->{campaign_pId}}) {
            $ID = $CIDS_TO_BS_ORDER_ID->{$row->{campaign_pId}};
        } else {
            $ID = _camp($row, 'campaign_Id');
        }
        $EID = $row->{campaign_pId};
    }

    my $order = BS::Export::get_query_data($query, 'ORDER', [$ID, $EID], [qw/ID EID/]);
    return $order if exists $order->{UpdateInfo};

    $order->{UpdateInfo} //= 0;

    # тип заказа
    # JAVA-EXPORT: OrderDataFactory#getOrderType
    $order->{OrderType} = _calculate_or_get_order_type($row);

    # JAVA-EXPORT OrderDataFactory#getContentType
    $order->{ContentType} = _calculate_content_type($row);

    $order->{GroupOrder} = _is_wallet_campaign($row); # флаг - заказ "общий счет" или нет
    $order->{GroupOrderID} = _camp($row, 'wallet_campaign_Id') ? _camp($row, 'wallet_campaign_Id') : 0; # OrderID общего счета если он включен на заказе

    $order->{ClientID} = _camp($row, 'ClientID');
    $order->{isExtendedRelevanceMatchEnabled} = _camp($row, 'send_extended_relevance_match_flag') ? 1 : 0;
    $order->{ManagerUID} = _camp($row, 'ManagerUID') ? _camp($row, 'ManagerUID') : 0;
    $order->{AgencyID} = _camp($row, 'AgencyID') || 0;
    $order->{IndependentBids} = ( (_camp($row, 'strategy') || '') eq 'different_places' )  ? 1 : 0;
    $order->{ContextPriceCoef} = _camp($row, 'ContextPriceCoef');

    if (_camp($row, 'create_time') && _camp($row, 'create_time') !~ /^0000/) {
        # время создания кампании
        my $create_time_ts = mysql2unix(_camp($row, 'create_time'));
        $order->{OrderCreateTime} = _nosoap("$create_time_ts");
    }

    # Заполняем поля, относящиеся к сумме и её валюте
    my $camp = _get_camp($row);
    my $client_info = {
        clientID            => $camp->{ClientID},
        debt                => $camp->{client_debt},
        overdraft_lim       => $camp->{overdraft_lim},
        auto_overdraft_lim  => $camp->{auto_overdraft_lim},
        statusBalanceBanned => $camp->{statusBalanceBanned}
    };
    BS::Export::extract_sum($order, $camp, $camp->{c_type}, $client_info);

    $order->{Stop} = _is_campaign_stopped($row);
    $order->{AutoOptimization} = _camp($row, 'autoOptimization') eq 'Yes' ? 1 : 0;
    $order->{Start_time} = _camp($row, 'Start_time');
    $order->{Description} = $row->{campaign_pId}.": ". _clean_campaign_name(_camp($row, 'Description')); #EXPIRES DIRECT-60408
    $order->{QueueSetTime} = _camp($row, 'queue_time_for_bs');

    $order->{MaxCPC} = 0;
    $order->{isVirtual} = _camp($row, 'is_virtual') ? 1 : 0;
    if (_camp($row, 'is_alone_trafaret_allowed')) {
        # В случае отсутствия флага ничего не отправляем
        $order->{AllowAloneTrafaret} = _nosoap(1);
    }
    if (_camp($row, 'require_filtration_by_dont_show_domains')) {
        # В случае отсутствия флага ничего не отправляем
        $order->{RequireFiltrationByDontShowDomains} = _nosoap(1);
    }
    if (_camp($row, 'has_turbo_app')) {
        # В случае отсутствия флага ничего не отправляем
        $order->{HasTurboApp} = _nosoap(JSON::true);
    }
    if (_camp($row, 'asap')) {
        # В случае отсутствия флага ничего не отправляем
        $order->{IsPriorityCampaign} = 1;
    }
    if (_is_performance_campaign($row)){
        $order->{UseTurboUrl} = _camp($row, 'has_turbo_smarts') ? 1 : 0;
    }
    _merge_order_targeting_expression($order, $row);

    # Модель аттрибуции.
    # Дефолтная логика по приему поля в БК описана тут https://st.yandex-team.ru/BSDEV-55630 (теперь ее можно удалить)
    # update: меняем дефолт на last_yandex_direct_click. https://st.yandex-team.ru/DIRECT-101085
    # в случае если поле не задано, отправляем дефолт
    my $attribution_model = _camp($row, 'attribution_model') || Primitives::get_attribution_model_default();
    $order->{AttributionType} = ATTRIBUTION_MODEL_VALUES->{$attribution_model};
    ######

    #Данные по сделкам
    if (_camp($row, 'deals')){
        $order->{DirectDeals} = [map { {ID => $_} } @{_camp($row, 'deals')}];
        my $AgencyCoef = int(10_000 * _camp($row, 'preferred_deal_fee_percent'));
        #FIXME - в БД должно лежать актуальное значение процента, убрать установку дефолта после реализации DIRECT-73577)
        $order->{AgencyCoef} = $AgencyCoef || 150_000;
    }

    if (_is_cpm_deals_campaign($row)){
        $order->{PrivateDeal} = 1;
    }

    my $wallet_cid = _camp($row, 'wallet_campaign_pId');
    if (_can_have_billing_aggregates($wallet_cid, _camp($row, 'is_sum_aggregated'))) {
        my $camp_type = _camp($row, 'c_type');
        my $ba = _extract_billing_aggregates($wallet_cid, $camp_type);
        if (defined($ba)) {
            $order->{BillingOrders} = _nosoap($ba);
        }
    }
    $order->{ProductId} = $row->{ProductID};

    if (_is_internal_campaign($row)){
        $order->{PlaceID} = _camp($row, 'place_id');

        my $ClientID = _camp($row, 'ClientID');
        unless (exists $INTERNAL_AD_PRODUCTS->{$ClientID} &&
                exists $INTERNAL_AD_PRODUCTS->{$ClientID}->{product_name} &&
                $INTERNAL_AD_PRODUCTS->{$ClientID}->{product_name} ne '') {
            $log->die("no product_name found for ClientID=$ClientID, EID=$EID");
        }

        $order->{ServiceName} = $INTERNAL_AD_PRODUCTS->{$ClientID}->{product_name};

        if (_camp($row, 'c_type') =~ /^(internal_distrib|internal_autobudget)$/) {
            $order->{RotationGoalID} = _camp($row, 'cint_rotation_goal_id');
        }
    }

    # параметры для SkAdNetwork могут быть только для РМП кампаний
    if (_is_mobile_content_campaign($row)) {
        _merge_skadnetwork_params($order, $row);
    }

    if (_is_cpm_price_campaign($row)) {
        $order->{IsFixPrice} = 1;
        _merge_auction_priority($order, $row);
        _merge_partner_share($order, $row);
    }

    _merge_allowed_domains($order, $row);
    # Стандарт определения видимости
    _merge_impression_standard_time($order, $row);

    if (_is_cpm_banner_campaign($row)) {
        _merge_eshows_params($row, $order);
    }

    if (_camp($row, 'source')) {
        $order->{SourceInterface} = _nosoap(_camp($row, 'source'));
    } else {
        $order->{SourceInterface} = _nosoap('direct_unclassified');
    }

    return $order;
}

sub _calculate_content_type {
    my $row = shift;
    if (_is_cpm_banner_campaign($row) || _is_cpm_deals_campaign($row) || _is_cpm_yndx_frontpage_campaign($row) || _is_cpm_price_campaign($row)) {
        return 'reach';
    }
    if (_is_content_promotion_campaign($row)) {
        return 'text';
    }
    if (_is_zen_campaign($row)) {
        return 'zen';
    }
    return _camp($row, 'c_type')
}

sub _merge_partner_share {
    my ($order, $row) = @_;
    my $val = _camp($row, 'partner_share');

    if (defined $val) {
        $order->{BusinessUnitPartnerShare} = int($val * 1000000);
    }
}

sub _clean_campaign_name {
    my $campaign_name = shift;
    return ($campaign_name =~ s/$Settings::DISALLOW_BANNER_LETTER_RE//gr);
}

=head2 extract_base_context($order, $row, %options)

    my $context = extract_base_context($order, $row);
    my $context = extract_base_context($order, $row, ID => $ContextID, EID => $pid);

    Создать контекст в заказе крутилошного запроса или достать существующий, если есть.
    Заполнить обязательные поля.

    Параметры:
        $order      - hashref - заказ, внутри которого будет сформирован контекст
        $row        - hashref - данные (исходные) по заказу/условию/баннеру
        %options    - дополнительные именованные параметры:
          ID            - использовать указанный ID при извлечении/создании контекста вместо данных
                          о БКшном идентификаторе условия, содержащихся в $row.
                          работает ТОЛЬКО при совместном указании ID и EID
          EID           - использовать указанные EID при извлечении/создании контекста вместо данных
                          о Директовском идентификаторе условия (pid), содержащихся в $row.
                          работает ТОЛЬКО при совместном указании ID и EID
    Результат:
        $context_data   - hashref - данные (для отправки) по контексту

=cut
sub extract_base_context {
    my ($order, $row, %options) = @_;

    my ($ID, $EID);
    if (defined $options{ID} && defined $options{EID}) {
        ($ID, $EID) = @options{qw/ID EID/};
    } else {
        ($ID, $EID) = @{ $row }{qw/context_Id context_pId/};
    }

    my $context = BS::Export::get_query_data($order, 'CONTEXT', [$ID, $EID], [qw/ID EID/]);
    return $context if exists $context->{UpdateInfo};

    $context->{UpdateInfo} //= 0;

    $context->{Type} = (any { $row->{adgroup_type} eq $_ } qw/cpm_video cpm_yndx_frontpage cpm_geoproduct/) ? 'cpm_banner' :
                       (($row->{adgroup_type} eq 'content_promotion_video' || $row->{adgroup_type} eq 'content_promotion') ? 'base' :
                       $row->{adgroup_type});

    return $context;
}

=head2 extract_base_banner($context, $row, %options)

    my $banner = extract_base_banner($context, $row);
    my $banner_image = extract_base_banner($context, $row, is_image => 1);

    Создать баннер в контексте крутилошного запроса или достать существующий, если есть.
    Заполнить обязательные поля. Некоторые подробности есть в DIRECT-23796.

    Параметры:
        $context    - hashref - условие (контекст), внутри которого будет сформирован баннер
        $row        - hashref - данные (исходные) по заказу/условию/баннеру
        %options    - дополнительные именованные параметры:
          is_image      - флаг (в булевом смысле) о том, что требуется извлечь картичноный баннер,
                          вместо текстового. Параметр опциональный, по умолчанию - ложь (будет
                          извлечен текстовый баннер)
          ID            - использовать указанный ID при извлечении/создании баннера вместо данных
                          о БКшном идентификаторе баннера, содержащихся в $row.
                          работает ТОЛЬКО при совместном указании ID и EID
          EID           - использовать указанные EID при извлечении/создании баннера вместо данных
                          о Директовском идентификаторе баннера, содержащихся в $row.
                          работает ТОЛЬКО при совместном указании ID и EID
    Результат:
        $banner     - hashref - данные (для отправки) по баннеру

=cut
sub extract_base_banner {
    my ($context, $row, %options) = @_;

    my ($ID, $EID);
    if (defined $options{ID} && defined $options{EID}) {
        ($ID, $EID) = @options{qw/ID EID/};
    } elsif ($options{is_image}) {
        ($ID, $EID) = @{ $row }{qw/image_BannerID image_id/};
    } else {
        ($ID, $EID) = @{ $row }{qw/banner_Id banner_pId/};
    }

    if ($options{is_image}) {
        # Отправлять ли картиночный баннер по новой схеме (в одном баннере)
        # TODO: Добавить отправку по новой схеме для остальных условий из https://st.yandex-team.ru/DIRECT-162106#6287a8a070c1b8388016a5b5
        # Если баннер ранее уже был отправлен по новой схеме то уже не даем ему отправляться по старой, т.к. можем сломать отправку в БК.
        # Если все же нужно отправить по старой - есть ваншот ResendImageBannersInOldSchemeOneshot
        if ( $row->{is_single_image_ad_to_bs} ) {
            $options{cid_pid_bid_to_image_id_as_one}->{$row->{campaign_pId}}->{$row->{context_pId}}->{$row->{banner_pId}} = $row->{image_id};
        }
    }

    my $is_new_banner = 0;
    if ( !is_valid_id($ID) ) {
        $is_new_banner = 1;
        $ID = _calculate_banner_id($EID);
    }

    # важно отпрвлять $ID как строку, иначе данные не будут приняты контент-системой БК
    my $banner = BS::Export::get_query_data($context, 'BANNER', ["$ID", $EID, undef], [qw/ID EID TYPE/]);
    $banner->{IsNewBanner} = 1 if $is_new_banner;

    return $banner if exists $banner->{UpdateInfo};

    # так как мы можем отправлять не весь баннер, а только некоторые из его полей
    $banner->{UpdateInfo} //= 0;

    # Пытаемся определить остановлен баннер или нет. Способ различен для текстового и картиночного баннеров
    # остановка outdoor баннера происходит без учета PostModerate
    if ($options{is_image}) {
        $banner->{Stop} = _is_image_banner_stopped($banner, $row);
    } elsif (_is_image_ad_or_mcbanner_banner($row) || _is_cpm_banner($row) || _is_cpc_video_banner($row)
        || _is_cpm_outdoor_banner($row) || _is_cpm_indoor_banner($row) || _is_cpm_audio_banner($row)) {
        $banner->{Stop} = _is_image_ad_or_mcbanner_or_cpm_banner_stopped($banner, $row);
    } else {
        $banner->{Stop} = _is_banner_stopped($row);
    }

    # для перфоманс больше никакие поля не заполняем
    return $banner if _is_performance_banner($row);

    # если нет флагов, то Flags => ""
    # если возрастное ограничение не задано, то Age => undef
    if (_is_dynamic_banner($row)) {
        # Для динамических баннеров не отправляем флаги и возрастную метку
        $banner->{Flags} = '';
        $banner->{Age} = undef;
    } else {
        $banner->{Flags} = merge_banner_flags($row);
        $banner->{Age} = BannerFlags::get_age_limits($row->{flags}, $row->{multicards_flags});
    }
    $banner->{Archive} = (($row->{banner_statusArch} // '') eq 'Yes') ? 1 : 0;

    # для картиночных баннеров всегда отправляем номер соответствующего текстового баннера (DIRECT-39893)
    if ($options{is_image}) {
        $banner->{ParentExportID} = $row->{banner_pId};
    }

    # если идут показы предыдущей версии у баннера с автовидео и выставлен флаг media_disclaimer, то останавливаем баннер полностью
    if ($options{is_image}
        && $banner->{Stop} == 0 && $row->{image_BannerID}
        && ($row->{image_statusModerate} eq 'No' || $row->{banner_statusModerate} eq 'No')
        && defined $row->{flags} && $row->{flags} =~ /\bmedia_disclaimer\b/
    ) {
        $banner->{Stop} = 1;
    }

    return $banner;
}

=head3 _get_conv_units_and_currency_values_for_sum

    Делает из одного значения в валюте кампания два: в фишках и в реальной валюте.
    Опционально умеет формировать сумму с учётом НДС.

    _get_conv_units_and_currency_values_for_sum($sum, $currency, $future_currency, %O);
    %O => (
        ClientID => $client_id,
        client_nds_cache => \%cache,
        with_nds => 1/0,
        min_constant => 'MIN_PRICE',
        max_constant => 'MAX_PRICE',
    )

    ($sum_conv_units, $sum_currency) = _get_conv_units_and_currency_values_for_sum($sum, $currency, $future_currency);
    ($sum_conv_units, $sum_currency) = _get_conv_units_and_currency_values_for_sum($sum, $currency, $future_currency, with_nds => 1, ClientID => $client_id, client_nds_cache => $CLIENT_NDS_CACHE);

=cut

sub _get_conv_units_and_currency_values_for_sum {
    need_list_context();
    my ($sum, $currency, $future_currency, %O) = @_;

    return (undef, undef) unless defined $sum;

    my ($sum_conv_units, $sum_currency);
    if ($currency eq 'YND_FIXED') {
        $sum_conv_units = $sum;
        if ($future_currency) {
            my $sum_without_nds = convert_currency($sum, 'YND_FIXED', $future_currency);
            my $opts = hash_cut \%O, qw(with_nds ClientID client_nds_cache min_constant max_constant);
            $sum_currency = get_value_for_sum($sum_without_nds, $future_currency, %$opts);
        }
    } else {
        my $opts = hash_cut \%O, qw(with_nds ClientID client_nds_cache);
        my $sum_with_nds = get_value_for_sum($sum, $currency, %$opts);
        $sum_currency = $sum_with_nds;

        $sum_conv_units = convert_currency($sum_with_nds, $currency, 'YND_FIXED', with_nds => $O{with_nds});

        $opts = hash_cut \%O, qw/min_constant max_constant/;
        $sum_conv_units = Currencies::inscribe_to_constants($sum_conv_units, 'YND_FIXED', %$opts);
    }

    # DIRECT-47149: в базе встречаются значения с большим количеством знаков, чем допустимо для валюты
    # изменение параметров автобюджета вызывает его рестарт, даже если поменялись незначащие знаки после запятой
    $sum_conv_units = Currencies::round_to_currency_digit_count($sum_conv_units, 'YND_FIXED');
    $sum_currency = Currencies::round_to_currency_digit_count($sum_currency, $future_currency // $currency);

    return ($sum_conv_units, $sum_currency);
}

=head3 _parse_displayed_domain_alias($href)

    Вычислить по ссылке DisplayedDomainAlias для отправки в БК.

    $banner->{DisplayedDomainAlias} = _parse_displayed_domain_alias($row->{Href})

=cut
sub _parse_displayed_domain_alias {
    my $href = shift;
    return undef if !$href;
    $href = strip_protocol($href);
    return COLLECTIONS_DOMAIN_ALIAS if $href =~ /^(collections\.yandex\.(ru|uk|kz|by|uz|com|com\.tr)|yandex\.(ru|uk|kz|by|uz|com|com\.tr)\/collections)\/.*/;
    return SPRAV_DOMAIN_ALIAS if $href =~ /^(sprav\.yandex\.(ru|uk|kz|by|uz|com|com\.tr)|yandex\.(ru|uk|kz|by|uz|com|com\.tr)\/sprav)\/.*/;
    return MAPS_DOMAIN_ALIAS if $href =~ /^(maps\.yandex\.(ru|uk|kz|by|uz|com|com\.tr)|yandex\.(ru|uk|kz|by|uz|com|com\.tr)\/maps|yandex\.(ru|uk|kz|by|uz|com|com\.tr)\/web-maps)\/.*/;
    return ZEN_DOMAIN_ALIAS if $href =~ /^(zen\.yandex\.(ru|uk|kz|by|uz|com|com\.tr)|yandex\.(ru|uk|kz|by|uz|com|com\.tr)\/zen)\/.*/;
    return APPSTORE_DOMAIN_ALIAS if $href =~ /^(apps\.apple\.com|itunes\.apple\.com)\/.*/;
    return GOOGLEPLAY_DOMAIN_ALIAS if $href =~ /^(play\.google\.com)\/.*/;
    return APPGALLERY_DOMAIN_ALIAS if $href =~ /^(appgallery\.huawei\.com)\/.*/;
    return undef;
}

=head3 _prepare_href($href)

    Преобразовать ссылку для отправки в БК.

    $banner->{Href} = _prepare_href($row->{Href})

=cut
sub _prepare_href {
    return Yandex::IDN::idn_to_ascii(clear_banner_href(shift));
}

=head3 _is_banner_stopped($row)

    $banner->{Stop} = _is_banner_stopped($row);

    Вычисляет значение Stop (признак остановки) для баннера
    Параметры:
        $row        - хеш с данными по заказу/условию/баннеру
    Результат
        $stopped    - 0/1 - остановлен ли баннер

=cut
sub _is_banner_stopped {
    my $row = shift;

    if ($row->{banner_statusShow} ne 'Yes'
        || ($row->{banner_PostModerate} && $row->{banner_PostModerate} eq 'Rejected')
        || ($row->{phrases_PostModerate} && $row->{phrases_PostModerate} eq 'Rejected')
        || (_has_unpublished_manual_permalink_sent_to_bs($row) && !_has_turbolanding($row) && !$row->{Href})
        || _is_banner_with_rejected_turbolanding_only($row)
    ) {
        return 1;
    } else {
        return 0;
    }
}

=head3 _is_image_banner_stopped($image_banner, $row)

    $banner_image->{Stop} = _is_image_banner_stopped($banner_image, $row);

    Вычисляет значение Stop (признак остановки для картиночного баннера)
    Параметры:
        $image_banner   - хеш с данными (для отправки) по картиночному баннеру
                            нужен для того, чтобы не сбросить признак остановки,
                            если он уже проставлен при извлечении контекста
        $row            - хеш с данными (исходными) по заказу/условию/баннеру
    Результат:
        $stopped    - 0/1 - остановлен ли баннер

=cut
sub _is_image_banner_stopped {
    my ($image_banner, $row) = @_;

    if (_is_banner_stopped($row)
        || $image_banner->{Stop}
        || $row->{image_statusModerate} eq 'No'
        || $row->{image_statusShow} eq 'No'
    ) {
        return 1;
    } else {
        return 0;
    }
}

=head3 _is_image_ad_or_mcbanner_or_cpm_banner_stopped($image_ad_banner, $row)

    $image_ad_banner->{Stop} = _is_image_ad_or_mcbanner_or_cpm_banner_stopped($image_ad_banner, $row);

    Вычисляет значение Stop (признак остановки для графического объявления).
    Остановка нужна если:
        - баннер остановлен
        - у картинки для картиночного баннера статус модерации отличается от Yes
        - у картиночного баннера выставлен флаг Stop
        - у креатива медийного баннера статус модерации равен AdminReject
    Параметры:
        $image_ad_banner - хеш с данными (для отправки) по картиночному баннеру
                            нужен для того, чтобы не сбросить признак остановки,
                            если он уже проставлен при извлечении контекста
        $row             - хеш с данными (исходными) по заказу/условию/баннеру
    Результат:
        $stopped    - 0/1 - остановлен ли баннер

=cut
sub _is_image_ad_or_mcbanner_or_cpm_banner_stopped {
    my ($image_ad_banner, $row) = @_;

    if (_is_banner_stopped($row)
        || $image_ad_banner->{Stop}
        || $row->{image_ad_statusModerate} ne 'Yes'
        || _is_creative_admin_rejected($row)
    ) {
        return 1;
    } else {
        return 0;
    }
}


=head3 _has_valid_context($row, %options)

    Проверить, что к текущему баннеру удастся собрать "правильное" условие.
    В общем случае для текстового и картиночного баннеров проверяется следующее:
        - условие вообще выбралось из базы (т.е. имеет подходящие статусы модерации/отправки в БК)
        - оно уже было в БК (есть ContextID) и баннер не новый (есть BannerID)
            или (т.е. если условие или баннер новые) в нем есть хотя бы одна не отключенная фраза/ретаргетинг

    Почему так - в Директе условие общее между баннером и картинкой, в БК условие - вложено в баннер.
        При создании в БК нового баннера им нужен полный контекст (не умеют брать его по ContextID
        от текстового баннера; NB: актуализировать после DIRECT-30677 - ExpressionMD5 на уровне контекста).
        Пример (DIRECT-39912) - добавление картинки к баннеру с пустым контекстом (нет активных
        фраз / условие ретарегтинга недоступно) - создать баннер-картинку в БК просто не получится
        из-за ошибки "Not enough params to create Context"

    Параметры:
        $row        - хеш с данными (исходными) по заказу/условию/баннеру
        %options    - дополнительные именованные параметры:
          is_image      - флаг (в булевом смысле) о том, что требуется проверить контекст для
                          картиночного баннера, вместо текстового. Параметр опциональный,
                          по умолчанию - ложь (будет проверено как для текстового баннера)
    Кроме того, использует глобальные:
        $PHRASES    - хеш с массивами данных по фразам/ретаргетингу (для запроса), сгруппированные по pid
    Результат:
        $has_valid_context - ''/1 - нет данных/есть данные для составления правильного условия

=cut
sub _has_valid_context {
    my ($row, %options) = @_;

    return ($row->{context_pId}
            && ( $row->{PriorityID} && ( !$options{is_image} && $row->{banner_Id} || $row->{image_BannerID} )
                 || _are_we_want_to_send_phrases($row)
                     && (
                            (exists $PHRASES->{ $row->{context_pId} }
                                && any {$_->{phrase_is_suspended} == 0} @{ $PHRASES->{ $row->{context_pId} } })
                            #группы внутренних объявлений могут быть без "фраз". Например, только с гео.
                            || _is_internal_adgroup($row)
                        )
               )
           );
}

=head3 _is_campaign_stopped($row)

    Определить, остановена ли кампания

    Параметры:
        $row    - хеш с данными (исходными) по заказу
    Результат:
        0/1 - отправлять ли остановку кампании

=cut
sub _is_campaign_stopped {
    my $row = shift;
    # Stop - в базе Директа соответствует statusShow на кампании. Если Stop = Yes это значит, что кампания активна и показываем ее.
    # Если Stop = No, то кампания остановлена и в БК отправляется остановка
    if (_camp($row, 'Stop') ne 'Yes') {
        return 1;
    } elsif (_camp($row, 'c_type') eq 'cpm_price' && (_camp($row, 'status_correct') ne 'Yes' || _camp($row, 'status_approve') ne 'Yes')) {
        return 1;
    } elsif (_camp($row, 'cpm_price_is_cpd_paused') || (_camp($row, 'cpm_yndx_frontpage_is_cpd_paused'))) {
        return 1;
    } else {
        return 0;
    }
}

=head3 _is_geo_campaign($row)

    Определить, является ли тип кампании - "гео" (геоконтекст, справочник)

    Параметры:
        $row    - хеш с данными (исходными) по заказу/условию/баннеру
    Результат:
        $is_wallet  - 0/1 - является ли кампания "гео"

=cut
sub _is_geo_campaign {
    return _camp(shift, 'c_type') eq 'geo' ? 1 : 0;
}

=head3 _is_wallet_campaign($row)

    Определить, является ли тип кампании - "кошелек"

    Параметры:
        $row    - хеш с данными (исходными) по заказу/условию/баннеру
    Результат:
        $is_wallet  - 0/1 - является ли кампания "кошельком"

=cut
sub _is_wallet_campaign {
    return Campaign::Types::is_wallet_camp(type => _camp(shift, 'c_type'));
}

=head3 _is_performance_campaign

=cut

sub _is_performance_campaign {
    return _camp(shift, 'c_type') eq 'performance';
}

=head3 _is_cpm_banner_campaign($row)

    Определить, является ли тип кампании - cpm_banner

    Параметры:
        $row    - хеш с данными (исходными) по заказу/условию/баннеру
    Результат:
        $is_cpm_banner_campaign  - 0/1 - является ли кампания cpm_banner

=cut
sub _is_cpm_banner_campaign {
    return _camp(shift, 'c_type') eq 'cpm_banner' ? 1 : 0;
}

=head3 _is_dynamic_campaign($row)

    Определить, является ли тип кампании - dynamic

    Параметры:
        $row    - хеш с данными (исходными) по заказу/условию/баннеру
    Результат:
        $_is_dynamic_campaign  - 0/1 - является ли кампания dynamic

=cut
sub _is_dynamic_campaign {
    return _camp(shift, 'c_type') eq 'dynamic' ? 1 : 0;
}


=head3 _is_content_promotion_campaign($row)

    Определить, является ли тип кампании - content_promotion

    Параметры:
        $row    - хеш с данными (исходными) по заказу/условию/баннеру
    Результат:
        $is_content_promotion_campaign  - 0/1 - является ли кампания content_promotion

=cut
sub _is_content_promotion_campaign {
    return _camp(shift, 'c_type') eq 'content_promotion' ? 1 : 0;
}

=head3 _is_cpm_deals_campaign($row)

    Определить, является ли тип кампании - cpm_deals

    Параметры:
        $row    - хеш с данными (исходными) по заказу/условию/баннеру
    Результат:
        $is_cpm_deals  - 0/1 - является ли кампания cpm_deals

=cut
sub _is_cpm_deals_campaign {
    return _camp(shift, 'c_type') eq 'cpm_deals' ? 1 : 0;
}

=head3 _is_cpm_yndx_frontpage_campaign($row)

    Определить, является ли тип кампании - cpm_yndx_frontpage

    Параметры:
        $row    - хеш с данными (исходными) по заказу/условию/баннеру
    Результат:
        $is_cpm_yndx_frontpage  - 0/1 - является ли кампания cpm_yndx_frontpage

=cut
sub _is_cpm_yndx_frontpage_campaign {
    return _camp(shift, 'c_type') eq 'cpm_yndx_frontpage' ? 1 : 0;
}

=head3 _is_internal_campaign($row)

    Определить, является ли кампания кампанией с внутренними объявлениями (типы internal_autobudget, internal_free, internal_distrib)

    Параметры:
        $row    - хеш с данными (исходными) по заказу/условию/баннеру
    Результат:
        _is_internal_campaign  - 0/1 - является ли кампания внутренней

=cut
sub _is_internal_campaign {
    my $c_type = _camp(shift, 'c_type');
    return (any {$c_type eq $_} qw(internal_autobudget internal_distrib internal_free)) ? 1 : 0;
}

=head3 _is_cpm_price_campaign($row)

    Определить, является ли тип кампании - cpm_price

    Параметры:
        $row    - хеш с данными (исходными) по заказу/условию/баннеру
    Результат:
        $is_cpm_price  - 0/1 - является ли кампания cpm_price

=cut
sub _is_cpm_price_campaign {
    return _camp(shift, 'c_type') eq 'cpm_price' ? 1 : 0;
}

=head3 _is_zen_campaign($row)

Определить, является ли кампания кампанией Дзена

Параметры:
    $row    - хеш с данными (исходными) по заказу
Результат:
    $_is_zen_campaign  - 0/1 - является ли кампания кампанией Дзена

=cut

sub _is_zen_campaign {
    return _camp(shift, 'source') eq 'zen' ? 1 : 0;
}

=head3 _is_mobile_content_campaign($row)

    Определить, является ли тип кампании - mobile_content

    Параметры:
        $row    - хеш с данными (исходными) по заказу/условию/баннеру
    Результат:
        $is_mobile_content  - 0/1 - является ли кампания mobile_content

=cut
sub _is_mobile_content_campaign {
    return _camp(shift, 'c_type') eq 'mobile_content' ? 1 : 0;
}

=head3 _is_mcbanner_campaign($row)

    Определить, является ли тип кампании - mcbanner

    Параметры:
        $row    - хеш с данными (исходными) по заказу/условию/баннеру
    Результат:
        $_is_mcbanner_campaign  - 0/1 - является ли кампания mcbanner

=cut
sub _is_mcbanner_campaign {
    return _camp(shift, 'c_type') eq 'mcbanner' ? 1 : 0;
}

=head3 _is_smart_campaign($row)

    Определить, является ли тип кампании - performance(smart)

    Параметры:
        $row    - хеш с данными (исходными) по заказу/условию/баннеру
    Результат:
        $_is_smart_campaign  - 0/1 - является ли кампания smart

=cut
sub _is_smart_campaign {
    return _camp(shift, 'c_type') eq 'performance' ? 1 : 0;
}

=head3 _is_text_campaign($row)

    Определить, является ли тип кампании - text

    Параметры:
        $row    - хеш с данными (исходными) по заказу/условию/баннеру
    Результат:
        $is_text  - 0/1 - является ли кампания text

=cut
sub _is_text_campaign {
    return _camp(shift, 'c_type') eq 'text' ? 1 : 0;
}

=head3 _is_mobile_content_adgroup($row)

    $context->{MobileContentAdGroup} = _is_mobile_content_adgroup($row);

    Определить, является ли тип группы - "рекламой мобильного контента"

    Параметры:
        $row    - хеш с данными (исходными) по заказу/условию/баннеру
    Результат:
        $is_mobile_content  - 0/1 - является ли группа "рекламой мобильного контента"

=cut
sub _is_mobile_content_adgroup {
    return shift->{adgroup_type} eq 'mobile_content' ? 1 : 0;
}

=head3 _is_performance_adgroup($row)

=cut

sub _is_performance_adgroup {
    return shift->{adgroup_type} eq 'performance' ? 1 : 0;
}

=head3 _is_dynamic_adgroup($row)

Проверяем, что группа от ДТО

=cut

sub _is_dynamic_adgroup {
    return shift->{adgroup_type} eq 'dynamic' ? 1 : 0;
}

=head3 _is_cpm_outdoor_adgroup($row)

=cut

sub _is_cpm_outdoor_adgroup {
    return shift->{adgroup_type} eq 'cpm_outdoor' ? 1 : 0;
}

=head3 _is_cpm_indoor_adgroup($row)

=cut

sub _is_cpm_indoor_adgroup {
    return shift->{adgroup_type} eq 'cpm_indoor' ? 1 : 0;
}

=head3 _is_cpm_yndx_frontpage_adgroup($row)

=cut

sub _is_cpm_yndx_frontpage_adgroup {
    return shift->{adgroup_type} eq 'cpm_yndx_frontpage' ? 1 : 0;
}

=head3 _is_cpm_video_adgroup($row)

=cut

sub _is_cpm_video_adgroup {
    return shift->{adgroup_type} eq 'cpm_video' ? 1 : 0;
}

=head3 _is_cpm_geoproduct_adgroup($row)

Проверяем, что группа предназначена для геопродукта

=cut

sub _is_cpm_geoproduct_adgroup {
    return shift->{adgroup_type} eq 'cpm_geoproduct' ? 1 : 0;
}

=head3 _is_internal_adgroup($row)

=cut

sub _is_internal_adgroup {
    return shift->{adgroup_type} eq 'internal' ? 1 : 0;
}

=head3 _is_text_banner($row)

    Определить, является ли тип баннера обычным "текстовым"

    Параметры:
        $row    - хеш с данными (исходными) по заказу/условию/баннеру
    Результат:
        $is_text_banner  - 0/1 - является ли баннер текстовым

=cut
sub _is_text_banner {
    return shift->{banner_type} eq 'text' ? 1 : 0;
}

=head3 _is_performance_banner($row)

=cut

sub _is_performance_banner {
    my $banner_type = shift->{banner_type};
    return ($banner_type eq 'performance' || $banner_type eq 'performance_main') ? 1 : 0;
}


=head3 _is_image_ad_or_mcbanner_banner($row)

    Определить, является ли тип баннера "графическим" или "mcbanner"
    (тоже графическое, но с другим типом)

    Параметры:
        $row    - хеш с данными (исходными) по заказу/условию/баннеру
    Результат:
        0/1     - является ли баннер графическим

=cut

sub _is_image_ad_or_mcbanner_banner {
    my $banner_type = shift->{banner_type};
    return ($banner_type eq 'image_ad' || $banner_type eq 'mcbanner') ? 1 : 0;
}

=head3 _is_mcbanner_banner($row)

    Определить, является ли тип баннера - "графические объявления на поиске".

    Метод понадобился в пару к _is_image_ad_text_banner,
    во всех остальных случаях достаточно _is_image_ad_or_mcbanner_banner

    Параметры:
        $row    - хеш с данными (исходными) по заказу/условию/баннеру
    Результат:
        0/1 - является ли баннер "графическим объявлением на поиске"

=cut

sub _is_mcbanner_banner {
    return shift->{banner_type} eq 'mcbanner' ? 1 : 0;
}

=head3 _is_cpm_banner($row)

    Определить, является ли тип баннера - cpm_banner.

    Параметры:
        $row    - хеш с данными (исходными) по заказу/условию/баннеру
    Результат:
        0/1 - является ли баннер cpm_banner'ом

=cut

sub _is_cpm_banner {
    return shift->{banner_type} eq 'cpm_banner' ? 1 : 0;
}

=head3 _is_non_skippable_cpm_video($addition)

    Определить, содержит ли баннер непропускаемый видео-креатив.

    Параметры:
        $row    - хеш с данными (исходными) по заказу/условию/баннеру
    Результат:
        0/1 - содержит ли баннер непропускаемый видео-креатив

=cut

sub _is_non_skippable_cpm_video {
    return shift->{is_non_skippable} // 0;
}

=head3 _is_brand_lift($addition)

    Определить, содержит ли баннер BrandLift.

    Параметры:
        $row    - хеш с данными (исходными) по заказу/условию/баннеру
    Результат:
        0/1 - содержит ли баннер BrandLift

=cut

sub _is_brand_lift {
    return shift->{is_brand_lift} // 0;
}

=head3 _is_cpc_video_banner($row)

    Определить, является ли тип баннера - cpc_video.

    Параметры:
        $row    - хеш с данными (исходными) по заказу/условию/баннеру
    Результат:
        0/1 - является ли баннер cpc_video

=cut

sub _is_cpc_video_banner {
    return shift->{banner_type} eq 'cpc_video' ? 1 : 0;
}

=head3 _is_cpm_outdoor_banner($row)

    Определить, является ли тип баннера - cpm_outdoor.

    Параметры:
        $row    - хеш с данными (исходными) по заказу/условию/баннеру
    Результат:
        0/1 - является ли баннер cpm_outdoor'ом

=cut

sub _is_cpm_outdoor_banner {
    return shift->{banner_type} eq 'cpm_outdoor' ? 1 : 0;
}

=head3 _is_cpm_indoor_banner($row)

    Определить, является ли тип баннера - cpm_indoor.

    Параметры:
        $row    - хеш с данными (исходными) по заказу/условию/баннеру
    Результат:
        0/1 - является ли баннер cpm_indoor'ом

=cut

sub _is_cpm_indoor_banner {
    return shift->{banner_type} eq 'cpm_indoor' ? 1 : 0;
}

=head3 _is_cpm_audio_banner($row)

    Определить, является ли тип баннера - cpm_audio.

    Параметры:
        $row    - хеш с данными (исходными) по заказу/условию/баннеру
    Результат:
        0/1 - является ли баннер cpm_audio

=cut

sub _is_cpm_audio_banner {
    return shift->{banner_type} eq 'cpm_audio' ? 1 : 0;
}

=head3 _is_cpm_geo_pin_banner($row)

    Определить, является ли тип баннера - cpm_geo_pin.

    Параметры:
        $row    - хеш с данными (исходными) по заказу/условию/баннеру
    Результат:
        0/1 - является ли баннер cpm_geo_pin

=cut

sub _is_cpm_geo_pin_banner {
    return shift->{banner_type} eq 'cpm_geo_pin' ? 1 : 0;
}

=head3 _is_image_ad_mobile_content_banner($row)

    Определить, является ли тип баннера "графическим" и при этом рекламой мобильного контента

    Параметры:
        $row    - хеш с данными (исходными) по заказу/условию/баннеру
    Результат:
        is_image_mobile_content_banner - 0/1

=cut
sub _is_image_ad_mobile_content_banner {
    my $row = shift;
    return ($row->{banner_type} eq 'image_ad' && $row->{adgroup_type} eq 'mobile_content') ? 1 : 0;
}

=head3 _is_cpc_video_mobile_content_banner($row)

    Определить, является ли тип баннера "видеокреативом" и при этом рекламой мобильного контента

    Параметры:
        $row    - хеш с данными (исходными) по заказу/условию/баннеру
    Результат:
        is_image_mobile_content_banner - 0/1

=cut
sub _is_cpc_video_mobile_content_banner {
    my $row = shift;
    return ($row->{banner_type} eq 'cpc_video' && $row->{adgroup_type} eq 'mobile_content') ? 1 : 0;
}

=head3 _is_cpc_video_banner_non_mobile_content($row)

    Определить, является ли тип баннера "видеокреативом" и при этом НЕ рекламой мобильного контента

    Параметры:
        $row    - хеш с данными (исходными) по заказу/условию/баннеру
    Результат:
        0/1 - является ли баннер cpc_video

=cut

sub _is_cpc_video_banner_non_mobile_content {
    my $row = shift;
    return ($row->{banner_type} eq 'cpc_video' && $row->{adgroup_type} ne 'mobile_content') ? 1 : 0;
}

=head3 _is_image_ad_text_banner($row)

    Определить, является ли тип баннера "графическим" и при этом НЕ рекламой мобильного контента

    Параметры:
        $row    - хеш с данными (исходными) по заказу/условию/баннеру
    Результат:
        is_image_mobile_content_banner - 0/1

=cut
sub _is_image_ad_text_banner {
    my $row = shift;
    return ($row->{banner_type} eq 'image_ad' && $row->{adgroup_type} eq 'base') ? 1 : 0;
}


=head3 _is_mobile_content_banner($row)

    $banner->{MobileContent} = _is_mobile_content_banner($row);

    Определить, является ли тип баннера - "рекламой мобильного контента".

    Параметры:
        $row    - хеш с данными (исходными) по заказу/условию/баннеру
    Результат:
        $is_mobile_content  - 0/1 - является ли баннер "рекламой мобильного контента"

=cut
sub _is_mobile_content_banner {
    return shift->{banner_type} eq 'mobile_content' ? 1 : 0;
}

=head3 _is_dynamic_banner($row)

    $banner->{Dynamic} = _is_dynamic_banner($row);
    Определить, является ли баннер "динамическим".

    Параметры:
        $row    - хеш с данными (исходными) по заказу/условию/баннеру
    Результат:
        $is_dynamic - 0/1 - является ли баннер динамическим

=cut
sub _is_dynamic_banner {
    return shift->{banner_type} eq 'dynamic' ? 1 : 0;
}

=head3 _is_internal_banner($row)

    Определить, является ли тип баннера - internal.

    Параметры:
        $row    - хеш с данными (исходными) по заказу/условию/баннеру
    Результат:
        0/1 - является ли баннер cpm_outdoor'ом

=cut

sub _is_internal_banner {
    return shift->{banner_type} eq 'internal' ? 1 : 0;
}

=head3 _is_content_promotion_banner($row)

    Определить, является ли тип баннера - "продвижением контента".

    Параметры:
        $row    - хеш с данными (исходными) по заказу/условию/баннеру
    Результат:
        $is_content_promotion - 0/1 - является ли баннер "продвижением контента"

=cut
sub _is_content_promotion_banner {
    return shift->{banner_type} eq 'content_promotion' ? 1 : 0;
}

=head3 _extract_price_fields($phrase, $camp, $row);

    Заполнить в "фразе" поля, относящиеся к ставке (с учетом типа "фразы" и стратегии):
        - AutoBudgetPriority
    или
        - Price (кроме ретаргетинга)
        - PriceContext

    Параметры:
        $phrase - хеш с данными (для отправки) по "фразе"
        $camp   - хеш с данными по кампании
        $row    - hashref - "строка" с данными про фразу ($PHRASES->{$pid}->[...])
        $data_row  - "строка" с данными с предыдущего уровня (ORDER/CONTEXT) из базы

=cut
sub _extract_price_fields {
    my ($phrase, $camp, $row, $data_row) = @_;

    # Передаем всегда: в большинстве случаев совпадает с ORDER.CurrencyISOCode,
    # но может отличаться для конвертирующихся фишечных заказов с момента, когда
    # стала известна дата перехода до изменения c.currency на новое значение
    $phrase->{CurrencyISOCode} = BS::Export::currency2bsisocode($camp->{currency});

    my $min_price_constant;
    if ($camp->{c_type} eq 'cpm_yndx_frontpage') {
        my $min_price_constant = Currencies::get_currency_constant($camp->{currency}, 'MIN_CPM_FRONTPAGE_PRICE');
    } else {
        $min_price_constant = Campaign::is_cpm_campaign($camp->{c_type})
            ? Currencies::get_currency_constant($camp->{currency}, 'MIN_CPM_PRICE')
            : Currencies::get_currency_constant($camp->{currency}, 'MIN_PRICE');
    }

    if ($camp->{autobudget} eq 'Yes') {
        if (!_is_performance_campaign($data_row)
            || (_is_performance_campaign($data_row) && is_strategy_roi_or_crr(_get_camp($data_row)))
        ) {
            # Для стратегии ROI и CRR в фильтрах у нас нет ни CPC ставок, ни CPA. Но есть приоритет автобюджета.
            # На странице фильтра его изменять нельзя, а вот на странице кампании — можно.
            $phrase->{AutoBudgetPriority} = $row->{autobudgetPriority} || 3;
        }
    } else {
        if (any { $row->{phrase_type} eq $_ } (qw/bids dynamic offer_retargeting/, @RELEVANCE_MATCH_BIDS_BASE_TYPES)) {
            $phrase->{Price} = Currencies::round_price_to_currency_step($row->{Price}, $camp->{currency}, down => 1);
        }
        if (any { $row->{phrase_type} eq $_ } (qw/bids dynamic offer_retargeting/, @RELEVANCE_MATCH_BIDS_BASE_TYPES)) {
            unless ($camp->{autobudget} ne 'Yes' && $camp->{strategy} ne 'different_places' && $camp->{enable_cpc_hold}) {
                my $reset_price_context = !$camp->{send_extended_relevance_match_flag} && (any { $_ eq $row->{phrase_type} } @RELEVANCE_MATCH_BIDS_BASE_TYPES);

                # price/price_context (в нижнем регистре) используются в PhrasePrice::phrase_camp_price_context
                local $row->{price} = $row->{Price};
                local $row->{price_context} = $reset_price_context ? $min_price_constant : $row->{PriceContext};
                $phrase->{PriceContext} = Currencies::round_price_to_currency_step(phrase_camp_price_context($camp, $row), $camp->{currency}, down => 1);
        }
        } elsif ($row->{phrase_type} eq 'retargetings') {
            $phrase->{PriceContext} = Currencies::round_price_to_currency_step($row->{PriceContext}, $camp->{currency}, down => 1);
        }
        if ( Campaign::is_cpm_campaign($camp->{c_type}) ){
            if (defined $phrase->{Price}){
                $phrase->{Price} = $phrase->{Price} / $Settings::CPM_SHOWS_COEF;
            }
            if (defined $phrase->{PriceContext}){
                $phrase->{PriceContext} = $phrase->{PriceContext} / $Settings::CPM_SHOWS_COEF;
            }
        }

        # ограничиваем максимальную ставку уровнем установленного дневного бюджета на кампанию или общий счет
        # NB! Аналогичный код есть в транспорте цен в ExportWorker.pm, можно найти поиском по DIRECT-105756
        #     При любых изменениях этого кода правки нужно вносить и туда
        my @day_budgets = grep { defined $_ && $_ > $Currencies::EPSILON } $camp->{day_budget}, $camp->{wallet_day_budget};
        if (PhrasePrice::is_bids_limited_by_day_budget() && @day_budgets) {
            my $day_budget = min(@day_budgets);
            if (defined $phrase->{Price} && $phrase->{Price} > $day_budget) {
                $phrase->{temp_PriceBeforeLimitByDayBudget} = $phrase->{Price};
                $phrase->{Price} = $day_budget;
            }
            if (defined $phrase->{PriceContext} && $phrase->{PriceContext} > $day_budget) {
                $phrase->{temp_PriceContextBeforeLimitByDayBudget} = $phrase->{PriceContext};
                $phrase->{PriceContext} = $day_budget;
            }
        }
    }
}

=head3 _need_to_hide_market_rating($row)

    Вычисляет значение флага HideMarketRating, отвечаюшего за скрытие "рейтинга маркета" на выдаче

    Параметры:
        $row    - хеш с данными (исходными) по заказу/условию/баннеру
    Результат:
        $hide_market_rating - 0/1 - нужно ли скрывать рейтинг маркета

=cut
sub _need_to_hide_market_rating {
    my $row = shift;
    my $result;

    if (_is_internal_campaign($row)) {
        $result = 0;
    } elsif (!camp_kind_in(type => _camp($row, 'c_type'), "market_ratings")) {
        # выставляем принудительно флаг "скрывать звездочки", если тип кампании их не предусматривает
        $result = 1;
    } elsif (_is_performance_campaign($row)) {
        $result = 0;
    } else {
        $result = _camp($row, 'hide_market_rating');
    }
    $result //= 0;

    return $result;
}

=head3 _merge_bannerland_data_dynamic($banner, $row)

    Добавляет в $banner поле BannerLandData (строка с данными),
    формируется частично из $row, частично из словарей.

    Параметры:
        $banner     - hashref - данные (для отправки) по баннеру
        $row        - hashref - данные (исходные) по заказу/условию/баннеру
    Кроме того, использует глобальные:
        $DOMAINS_DICT - словарь доменов (domain_id => domain)
        $MINUS_PHRASES_DICT - словарь с минус-фразами на группу
        $CAMPAIGN_MINUS_OBJECTS - словарь с минус-фразами на кампанию
        $json_obj - для json'ификации

=cut
sub _merge_bannerland_data_dynamic {
    my ($banner, $row, %O) = @_;

    my $group_minus_phrases = _extract_group_minus_words($row);

    my $bannerland_data = {
        # общая часть данных
        AdGroupMinusWords => MinusWordsTools::minus_words_array2str_with_brackets($group_minus_phrases // []),
        Body => $row->{Body},
        CampaignMinusWords => MinusWordsTools::minus_words_array2str_with_brackets($CAMPAIGN_MINUS_OBJECTS->{$row->{campaign_pId}} // []),
        HrefParams => _get_hrefparams($row),
        Geo => _apply_minus_geo_by_bid($row->{Geo}, $row->{banner_pId}, $row->{context_pId}),
    };

    if ($row->{dynamic_main_domain_id}) {
        $bannerland_data->{Domain} = $DOMAINS_DICT->{ $row->{dynamic_main_domain_id} };
        $bannerland_data->{Targets} = _get_targets_dynamic($row);
        if ($row->{dyn_adgroup_use_as_name}) {
            $bannerland_data->{UseAsName} = $row->{dyn_adgroup_use_as_name};
        }
        if ($row->{dyn_adgroup_use_as_body}) {
            $bannerland_data->{UseAsBody} = $row->{dyn_adgroup_use_as_body};
        }
    } elsif ($row->{dyn_adgroup_feed_id}) {
        $bannerland_data->{SubstituteURLParams} = _get_bannerland_substitute_url_params($row);
        $bannerland_data->{Targets} = _get_targets_dynamic_based_on_feed($row);
        _merge_feed_params($bannerland_data, $row->{dyn_adgroup_feed_id});
        if ($row->{dyn_adgroup_use_as_name}) {
            $bannerland_data->{UseAsName} = $row->{dyn_adgroup_use_as_name};
        }
        if ($row->{dyn_adgroup_use_as_body}) {
            $bannerland_data->{UseAsBody} = $row->{dyn_adgroup_use_as_body};
        }
    } elsif ($row->{text_adgroup_feed_id}) {
        _merge_feed_params($bannerland_data, $row->{text_adgroup_feed_id});
        $bannerland_data->{Filter} = _get_filter_based_on_feed($row);
        $bannerland_data->{SubstituteURLParams} = _get_bannerland_substitute_url_params($row);
        if ($row->{text_adgroup_use_as_name}) {
            $bannerland_data->{UseAsName} = $row->{text_adgroup_use_as_name};
        }
        if ($row->{text_adgroup_use_as_body}) {
            $bannerland_data->{UseAsBody} = $row->{text_adgroup_use_as_body};
        }
        my $bl_domain = $FEEDS->{$row->{text_adgroup_feed_id}}->{target_domain};
        if ($bl_domain && Yandex::IDN::is_valid_domain($bl_domain)) {
            $banner->{TargetDomain} = lc(_get_domain_filter($bl_domain, domain_cache => $O{domain_cache}) || '');
            $banner->{Site} = strip_domain(Yandex::IDN::idn_to_unicode(lc($bl_domain)));
        } else {
            $banner->{TargetDomain} = '';
            $banner->{Site} = '';
        }
        $banner->{TargetDomainID} = _get_domain_bs_id($row->{campaign_pId}, $banner->{TargetDomain}, domain_bs_id_cache => $O{domain_bs_id_cache});
    } else {
        die "UNREACHABLE";
    }

    $banner->{BannerLandData} = $json_obj->encode($bannerland_data);
}

=head3 _get_hrefparams

    Возвращает HrefParams для отправки Боре в составе BannerLandData и в БК.
    HrefParams это дополнительный кусок ссылки, задаваемый рекламодателем,
    добавляемый ко всем генерируемым Борей ссылкам.
    HrefParams может быть задан на группе или/и на кампании - берется более узкий вариант.
    Параметры аля {campaign_id} возвращаются уже раскрытыми.

    HrefParams => _get_hrefparams($row);

=cut

sub _get_hrefparams {
    my ($row) = @_;

    my $href_params = $row->{adgroup_href_params} // '';
    if ($href_params eq '') {
        $href_params = _camp($row, 'campaign_href_params') // '';
    }
    if ($href_params ne '') {
        $href_params = _convert_href_params($href_params, $row);
    }

    return $href_params;
}

=head3 _get_href_params_for_substitute

    Возвращает значения для подставляемых параметров из @SUBSTITUTE_PARAMS*

    $row - запись из базы

=cut

sub _get_href_params_for_substitute {
    my ($row) = @_;

    my $campaign_name = _clean_campaign_name(_camp($row, 'Description'));
    my ($campaign_cost_type, $campaign_cost) = _campaign_cost($row);
    my ($campaign_currency, $campaign_currency_code) = _campaign_currency($row);

    return {
        campaignid => $row->{campaign_pId},
        campaigntype => camp_type_to_param(_camp($row, 'c_type')),
        bannerid => $row->{banner_pId},
        adid => $row->{banner_pId},
        adgroupid => $row->{context_pId},
        campaignname => _campaign_name($campaign_name),
        campaignnamelat => _campaign_name_lat($campaign_name),
        campaigncurrency => $campaign_currency,
        campaigncurrencycode => $campaign_currency_code,
        campaigncosttype => $campaign_cost_type,
        campaigncost =>  $campaign_cost
    };
}

sub _campaign_currency {
    my $currency = shift->{campaign_currency};
    return ($currency, BS::Export::currency2bsisocode($currency)) unless $currency eq 'YND_FIXED';
    return ('', '');
}

sub _campaign_cost {
    my $row = shift;
    my $strategy_data = _get_strategy_data($row);
    if (is_strategy_cpc($row)) {
        return ('CPC', $strategy_data->{avg_bid});
    } elsif (is_strategy_avg_cpi($row) && !$strategy_data->{goal_id}) {
        # CPI strategy with goal_id is really a CPA strategy for mobile app campaigns
        return ('CPI', $strategy_data->{avg_cpi});
    } elsif (is_strategy_cpm($row)) {
        return ('CPM', $strategy_data->{avg_cpm});
    } else {
        return ('', '');
    }
}

sub _campaign_name_lat {
    my $campaign_name = shift;
    $campaign_name = translit($campaign_name);
    $campaign_name = TextTools::truncate_text($campaign_name, 60, '');
    $campaign_name =~ s/[^a-zA-Z0-9_]/_/gi;
    return uri_escape_utf8($campaign_name);
}

sub _campaign_name {
    my $campaign_name = shift;
    return uri_escape_utf8( TextTools::truncate_text($campaign_name, 60, '') );
}

=head3 _convert_href_params

    Преобразование и подстановка параметров в URL

=cut
sub _convert_href_params {
    my ($params, $row) = @_;

    my $href_params = $params;
    $href_params = BS::Export::process_href_params($href_params, _camp($row, 'c_type'));
    $href_params = BS::Export::substitute_href_params(
        $href_params,
        _get_href_params_for_substitute($row),
        _camp($row, 'c_type'),
    );

    return $href_params;
}

=head3 _is_turbo_href

    Проверка ссылки на турбовость для извлечения параметра Site из ссылки

=cut

sub _is_turbo_href {
    my $href = shift;
    return $href && $href =~ /^(http:\/\/|https:\/\/)?yandex\.ru\/turbo\?.*/;
}

=head3 _is_turbo_site_domain

    Проверка домена на вид *turbo.site

=cut

sub _is_turbo_site_domain {
    my $site = shift;
    return $site && $site =~ /.*turbo\.site$/;
}

=head3  _extend_tl_url

    Добавляет к переданному url пользовательские параметры для url турболендингов
    Если они не заданы - возвращает исходный url

=cut

sub _extend_tl_url {
    my ($url, $row) = @_;
    return $url unless defined $row->{banner_tl_hrefParams} && $row->{banner_tl_hrefParams} gt '';

    my $converted_params = _convert_href_params($row->{banner_tl_hrefParams}, $row);
    return $url =~ /\?./ ? join('&', $url, $converted_params) : join('?', $url, $converted_params);
}

=head3  _get_href_with_campaign_tracking_params

    Добавляет в переданный url пользовательские параметры с кампании.
    Если они не заданы - возвращает исходный url.

=cut

sub _get_href_with_campaign_tracking_params {
    my ($href, $row) = @_;

    my $campaign_href_params = _camp($row, 'campaign_href_params');
    return $href unless defined $campaign_href_params && $campaign_href_params gt '' && defined $href && $href gt '';

    return BS::Export::merge_href_with_template_params($href, $campaign_href_params);
}

=head3  _get_converted_href_with_campaign_tracking_params

    Добавляет в переданный url пользовательские параметры с кампании, преобразовывая их с помощью _convert_href_params.
    Если они не заданы - возвращает исходный url.

=cut

sub _get_converted_href_with_campaign_tracking_params {
    my ($href, $row) = @_;

    my $campaign_href_params = _camp($row, 'campaign_href_params');
    return $href unless defined $campaign_href_params && $campaign_href_params gt '' && defined $href && $href gt '';

    return _convert_href_params(BS::Export::merge_href_with_template_params($href, $campaign_href_params), $row);
}

=head2 _merge_bannerland_data_performance($banner, $row, %O)

    Добавляет в $banner поле BannerLandData - json строка, которая собирается из данных из $row и словарей

    Использует глобальный $json_obj - для json'ификации

=cut

sub _merge_bannerland_data_performance
{
    my ($banner, $row, %O) = @_;
    my @geo = @{get_signed_num_array_by_str(_apply_minus_geo_by_bid($row->{Geo}, $row->{banner_pId}, $row->{context_pId}))};
    my $bannerland_data = {
        ( scalar(@geo) == 1 && $geo[0] eq '0' ? () : (Geo => \@geo) ),
        HrefParams => _get_hrefparams($row),
        SubstituteURLParams => _get_bannerland_substitute_url_params($row),
    };
    if ($row->{perf_adgroup_feed_id}) {
        _merge_feed_params($bannerland_data, $row->{perf_adgroup_feed_id});
        if ($row->{perf_adgroup_use_as_name}) {
            $bannerland_data->{UseAsName} = $row->{perf_adgroup_use_as_name};
        }
        if ($row->{perf_adgroup_use_as_body}) {
            $bannerland_data->{UseAsBody} = $row->{perf_adgroup_use_as_body};
        }
        $bannerland_data->{Targets} = _get_targets_performance($row);
        $bannerland_data->{TargetsParams} = _get_targets_params_performance($row);

        my $bl_domain = $FEEDS->{$row->{perf_adgroup_feed_id}}->{target_domain};
        if ($bl_domain && Yandex::IDN::is_valid_domain($bl_domain)) {
            $banner->{TargetDomain} = lc(_get_domain_filter($bl_domain, domain_cache => $O{domain_cache}) || '');
            $banner->{Site} = strip_domain(Yandex::IDN::idn_to_unicode(lc($bl_domain)));
        } else {
            $banner->{TargetDomain} = '';
            $banner->{Site} = '';
        }

    } elsif ($row->{text_adgroup_feed_id}) {
        _merge_feed_params($bannerland_data, $row->{text_adgroup_feed_id});
        $bannerland_data->{Filter} = _get_filter_based_on_feed($row);
        if ($row->{text_adgroup_use_as_name}) {
            $bannerland_data->{UseAsName} = $row->{text_adgroup_use_as_name};
        }
        if ($row->{text_adgroup_use_as_body}) {
            $bannerland_data->{UseAsBody} = $row->{text_adgroup_use_as_body};
        }

        my $bl_domain = $FEEDS->{$row->{text_adgroup_feed_id}}->{target_domain};
        if ($bl_domain && Yandex::IDN::is_valid_domain($bl_domain)) {
            $banner->{TargetDomain} = lc(_get_domain_filter($bl_domain, domain_cache => $O{domain_cache}) || '');
            $banner->{Site} = strip_domain(Yandex::IDN::idn_to_unicode(lc($bl_domain)));
        } else {
            $banner->{TargetDomain} = '';
            $banner->{Site} = '';
        }
    }

    $banner->{BannerLandData} = $json_obj->encode($bannerland_data);
    $banner->{TargetDomainID} = _get_domain_bs_id($row->{campaign_pId}, $banner->{TargetDomain}, domain_bs_id_cache => $O{domain_bs_id_cache});
}

=head3 _merge_feed_params($bl_data, $feed_id)

    Добавляет в хеш $bl_data данные по фиду с $feed_id

    Кроме того, использует глобальные:
        $FEEDS  - словарь с данными о фидах

=cut

sub _merge_feed_params {
    my ($bl_data, $feed_id) = @_;

    $bl_data->{BusinessType} = $FEEDS->{$feed_id}->{business_type};
    $bl_data->{LastValidFeedType} = $FEEDS->{$feed_id}->{feed_type};
    $bl_data->{FeedUrl} = $FEEDS->{$feed_id}->{url};
    $bl_data->{Login} = $FEEDS->{$feed_id}->{login};
    $bl_data->{Password} =  $FEEDS->{$feed_id}->{encrypted_password} ? decrypt_text($FEEDS->{$feed_id}->{encrypted_password}) : undef;
    $bl_data->{RemoveUtm} = ($FEEDS->{$feed_id}->{is_remove_utm} // 0) == 1 ? 'Yes' : 'No';
}

=head3 _get_targets_dynamic($row)

    Получить для текущего баннера структуру Targets (с нацеливаниями).
    Список включенных в группе условий умеет кешировать по pid в $ENABLED_DYNAMIC_CONDITIONS_BY_PID.

    Параметры:
        $row    - hashref с данными о заказе/условии/баннере (элемент данных "снепшота")
    Кроме того, использует глобальные:
        $PHRASES                - данные по фразам для запроса, сгруппированные по pid
        $DYNAMIC_CONDITIONS     - хранилище условий по dyn_cond_id
        $ENABLED_DYNAMIC_CONDITIONS_BY_PID   - кеширует в этом хеше список включенных условий (dyn_cond_id) по pid
        $json_obj - для json'ификации
    Результат:
        $targets    - ссылка на массив нацеливаний, каждое из которых является хешом следующего вида:
        {
            DynamicConditionID => M,# номер условия (но не ставки)
            Condition =>            # условие нацеливания, является
                [ {...}, ...]       # массивом целей при ДО по сайту (старый формат)
                                    # https://beta.wiki.yandex-team.ru/Direkt/technicaldesign/DynamicBanners/#tipycelejj
        },

    TODO: после перевода формата ДО по сайту к новому виду (как ДО по фиду и Смарт)
    заменить код на содержимое _get_targets_dynamic_based_on_feed
    и вызывать _get_targets_dynamic безусловно для заполнения BannerLandData внутри _merge_bannerland_data_dynamic

=cut

sub _get_targets_dynamic {
    my $row = shift;

    my $pid = $row->{context_pId};

    _ensure_filled_enabled_dynamic_conditions($pid);

    my @targets;
    for my $dyn_cond_id (@{ $ENABLED_DYNAMIC_CONDITIONS_BY_PID->{$pid} }) {
            my $condition_json = $DYNAMIC_CONDITIONS->{$dyn_cond_id}->{condition_json};
            unless ($condition_json) {
                # нарушена консистентность bids_dynamic <=> dynamic_conditions ?
                $log->die('no condition_json for dyn_cond_id ' . ($dyn_cond_id // 'undef') . ' and pid ' . ($pid // 'undef'));
            }

            push @targets, {
                DynamicConditionID => int($dyn_cond_id),
                Condition => $json_obj->decode($condition_json),
            };
    }

    return \@targets;
}

=head3 _common_ensure_filled_enabled_phrases($pid, $dict, $phrase_type)

    Заполняет (если еще не) словарь $dict для указанного $pid id'шниками включенных "фраз" типа $phrase_type

    Содержит общий код для _ensure_filled_enabled_*

    Параметры:
        $pid            - номер группы, для которой нужно проверить или заполнить словарь
        $dict           - словарь, который заполняем
        $phrase_type    - тип фраз, которыми заполняем
    Кроме того, использует глобальные:
        $PHRASES    - хеш с массивами данных по фразам/ретаргетингу/..., сгруппированные по pid

=cut

sub _common_ensure_filled_enabled_phrases {
    my ($pid, $dict, $phrase_type) = @_;

    unless (defined $dict->{$pid}) {
        my @cond_ids;
        for my $phrase (@{ $PHRASES->{$pid} // [] }) {
            next if $phrase->{phrase_type} ne $phrase_type;
            next if $phrase->{phrase_is_suspended};

            push @cond_ids, $phrase->{phrase_Id};
        }

        $dict->{$pid} = \@cond_ids;
    }
}

=head3 _ensure_filled_enabled_perf_conditions($pid)

    Заполняет (если еще не) словарь $ENABLED_PERF_CONDITIONS_BY_PID для указанного $pid

    Параметры:
        $pid - номер группы, для которой нужно проверить или заполнить словарь
    Кроме того, использует глобальные:
        $ENABLED_PERF_CONDITIONS_BY_PID

=cut

sub _ensure_filled_enabled_perf_conditions {
    return _common_ensure_filled_enabled_phrases(shift, $ENABLED_PERF_CONDITIONS_BY_PID, 'performance');
}

=head3 _ensure_filled_enabled_perf_conditions($pid)

    Заполняет (если еще не) словарь $ENABLED_DYNAMIC_CONDITIONS_BY_PID для указанного $pid

    Параметры:
        $pid - номер группы, для которой нужно проверить или заполнить словарь
    Кроме того, использует глобальные:
        $ENABLED_DYNAMIC_CONDITIONS_BY_PID

=cut

sub _ensure_filled_enabled_dynamic_conditions {
    return _common_ensure_filled_enabled_phrases(shift, $ENABLED_DYNAMIC_CONDITIONS_BY_PID, 'dynamic');
}

=head3 _get_targets_performance($row)

Для перфоманс баннеров вернуть данные для BannerLandData -> Targets

$row - запись из базы

Возвращает ссылку на хеш
 { bids_performance.perf_filter_id => from_json(bids_performance.condition_json) }

Использует глобальные
    $ENABLED_PERF_CONDITIONS_BY_PID
    $PERFORMANCE_CONDITIONS

=cut

sub _get_targets_performance {
    return _common_get_targets_dict(shift, $PERFORMANCE_CONDITIONS, $ENABLED_PERF_CONDITIONS_BY_PID, 'performance');
}

=head3 _get_targets_dynamic_based_on_feed($row)

    Получить для текущего баннера структуру Targets (с условиями фильтрации по фиду).
    Список включенных в группе условий умеет кешировать по pid в $ENABLED_DYNAMIC_CONDITIONS_BY_PID.

    Параметры:
        $row    - hashref с данными о заказе/условии/баннере (элемент данных "снепшота")
    Кроме того, использует глобальные:
        $DYNAMIC_CONDITIONS     - хранилище условий по dyn_cond_id
        $ENABLED_DYNAMIC_CONDITIONS_BY_PID   - кеширует в этом хеше список включенных условий (dyn_cond_id) по pid
    Результат:
        $targets    - ссылка на хеш { bids_dynamic.dyn_cond_id => from_json(dynamic_conditions.condition_json) }

=cut

sub _get_targets_dynamic_based_on_feed {
    return _common_get_targets_dict(shift, $DYNAMIC_CONDITIONS, $ENABLED_DYNAMIC_CONDITIONS_BY_PID, 'dynamic');
}

sub _get_filter_based_on_feed {
    my ($row) = @_;
    my %filter = ();
    my %parsed_filter = ();
    my $filter_json = $json_obj->decode($row->{text_filter_data});

    for my $cond (@{$filter_json->{conditions}}) {
        my $key;
        if (defined $cond->{operator}) {
            $key = $cond->{fieldName} . ' ' . $cond->{operator};
        } else {
            $key = $cond->{fieldName};
        }
        my $value = _parse_filter_value($cond->{value});
        $parsed_filter{$key} = $value;
    }

    $filter{Condition} = \%parsed_filter;

    return \%filter;
}

sub _parse_filter_value {
    my ($value) = @_;

    my $val;
    for my $key (qw/bool exists [long] [str] [double] [range] []/) {
        if (!defined $value->{$key}) {
            next;
        }
        $val = $value->{$key};
    }
    if (!defined $val) {
        die "Unknown key for value " . to_json($value);
    }
    return $val;
}

=head3 _common_get_targets_dict($pid, $conditions_dict, $enabled_dict, $phrase_type)

    Содержит общий код для получения BannerLandData.Targets в "новом" формате, где Targets - словарь (не массив).

    Параметры:
        $row    - hashref с данными о заказе/условии/баннере (элемент данных "снепшота")
        $conditions_dict    - словарь с условиями/фильтрами, из него берется condition_json
                              { id => {condition_json => '...', ...}, ... }
        $enabled_dict       - словарь, в котором кешируем включенные в группе "фразы" типа $phrase_type
                              { pid => [id1, id2, ...], ... }
        $phrase_type        - тип фраз с которыми работаем
                              performance/dynamic

    Кроме того, использует глобальные:
        $json_obj   - для json'ификации
    Результат:
        $targets    - ссылка на хеш, где ключ - id условия/фильтра, значение - распакованный json c условием

=cut

sub _common_get_targets_dict {
    my ($row, $conditions_dict, $enabled_phrases_dict, $phrase_type) = @_;
    my $pid = $row->{context_pId};

    _common_ensure_filled_enabled_phrases($pid, $enabled_phrases_dict, $phrase_type);

    my %targets;
    for my $id (@{ $enabled_phrases_dict->{$pid} }) {
        my $condition_json = $conditions_dict->{$id}->{condition_json};
        unless ($condition_json) {
            $log->die("no condition_json for id " . ($id // 'undef') . ' and pid ' . ($pid // 'undef') . "; phrase_type $phrase_type");
        }

        $targets{$id} = $json_obj->decode($condition_json);
    }

    return \%targets;

}

=head3 _get_targets_params_performance

    Для перфоманс баннеров вернуть данные для BannerLandData -> TargetsParams

    $row - запись из базы

    Возвращает ссылку на хеш вида:
         {
            $perf_filter_id_1 : {
               "target_funnel" : "same_products"
            },
            $perf_filter_id_2 : {
               "target_funnel" : "product_page_visit"
            }
            $perf_filter_id_3 : {
               "target_funnel" : "new_auditory"
            }
            ...
         }

    Использует глобальные:
        - $ENABLED_PERF_CONDITIONS_BY_PID
        - $PERFORMANCE_CONDITIONS

=cut

sub _get_targets_params_performance
{
    my ($row) = @_;
    my $pid = $row->{context_pId};

    _ensure_filled_enabled_perf_conditions($pid);

    my %targets_params;
    for my $perf_id (@{ $ENABLED_PERF_CONDITIONS_BY_PID->{$pid} }) {
        my $perf_filter = $PERFORMANCE_CONDITIONS->{$perf_id};
        $targets_params{$perf_id} = {
            target_funnel => $perf_filter->{target_funnel} || 'same_products',
            $perf_filter->{ret_cond_id} ? (goal_context_id => $perf_filter->{ret_cond_id}) : (),
        },
    }

    return \%targets_params;
}


=head2 _get_bannerland_substitute_url_params

    Возвращает списки замены подстрок для замены директовских подстановочных
    параметров на макросы движка или на реальные значения.
    Используется и передаётся через BannerLandData, чтобы Боря подставлял
    параметры в ссылки из клиентских фидов.

    $row - запись из базы

    Возвращает ссылку на хеш вида:
    {
        'campaignid' => 666,
        'adgroupid' => 777,
        'campaigntype' => 'type4',
        'position_type' => '{PTYPE}',
        'device_type' => '{DEVICE_TYPE}',
        ...
    }

=cut

sub _get_bannerland_substitute_url_params {
    my ($row) = @_;

    my %params;

    for my $direct_param_name (keys %{$BS::Export::TRANSLATE_PARAMS_GENERATED_BANNERS}) {
        my $bs_param_name = $BS::Export::TRANSLATE_PARAMS_GENERATED_BANNERS->{$direct_param_name};
        $params{'{' . $direct_param_name . '}'} = '{' . $bs_param_name . '}';
    }

    my $substitute_values = _get_href_params_for_substitute($row);
    for my $direct_param_name (@BS::Export::SUBSTITUTE_PARAMS_GENERATED_BANNERS) {
        my $norm_param_name = BS::Export::normalize_href_param_name($direct_param_name);
        my $value = $substitute_values->{$norm_param_name};
        $params{'{' . $direct_param_name . '}'} = $value;
    }

    return \%params;
}


=head3 _merge_mobile_price_coef($row, $object_type, $object)

    _merge_mobile_price_coef($row, order => $order);
    _merge_mobile_price_coef($row, context => $context);

    Заполнить в объекте $object типа $object_type коэффициент к ставке для мобильных устройств.
    Используются данные из таблицы hierarchical_multipliers.

    Параметры:
        $row            - hashref с данными о заказе/условии/баннере (элемент данных "снепшота")
        $object_type    - для кого объекта нужен коэффициент.
                          допустимые значения: order, context
        $object         - hashref с данными по заказу или контексту для отправки в БК
    Кроме того, использует глобальные:
        $MULTIPLIERS    - словарь с коэффициентами

=cut
sub _merge_mobile_price_coef {
    my ($row, $object_type, $object) = @_;
    my $mobile_multiplier;
    if ($object_type eq 'context') {
        $mobile_multiplier = $MULTIPLIERS->{mobile}->{for_pid}->{ $row->{context_pId} };
    } elsif ($object_type eq 'order') {
        $mobile_multiplier = $MULTIPLIERS->{mobile}->{for_cid}->{ $row->{campaign_pId} };
    } else {
        $log->die("_merge_mobile_price_coef: invalid object_type: $object_type");
    }
    $object->{MobilePriceCoef} = undef;
    $object->{MobileIOSPriceCoef} = undef;
    $object->{MobileAndroidPriceCoef} = undef;
    my $os_type = $mobile_multiplier->{os_type};
    if (!$os_type){
        $object->{MobilePriceCoef} = $mobile_multiplier->{multiplier_pct};
    } elsif ($os_type eq 'ios'){
        $object->{MobileIOSPriceCoef} = $mobile_multiplier->{multiplier_pct};
    } elsif ($os_type eq 'android'){
        $object->{MobileAndroidPriceCoef} = $mobile_multiplier->{multiplier_pct};
    }
}

=head3 _merge_desktop_price_coef($row, $object_type, $object)

    _merge_desktop_price_coef($row, order => $order);
    _merge_desktop_price_coef($row, context => $context);

    Заполнить в объекте $object типа $object_type коэффициент к ставке для мобильных устройств.
    Используются данные из таблицы hierarchical_multipliers.

    Параметры:
        $row            - hashref с данными о заказе/условии/баннере (элемент данных "снепшота")
        $object_type    - для кого объекта нужен коэффициент.
                          допустимые значения: order, context
        $object         - hashref с данными по заказу или контексту для отправки в БК
    Кроме того, использует глобальные:
        $MULTIPLIERS    - словарь с коэффициентами

=cut
sub _merge_desktop_price_coef {
    my ($row, $object_type, $object) = @_;
    my $multiplier_pct;

    if ($object_type eq 'context') {
        $multiplier_pct = $MULTIPLIERS->{desktop}->{for_pid}->{ $row->{context_pId} };
    } elsif ($object_type eq 'order') {
        $multiplier_pct = $MULTIPLIERS->{desktop}->{for_cid}->{ $row->{campaign_pId} };
    } else {
        $log->die("_merge_desktop_price_coef: invalid object_type: $object_type");
    }

    $object->{DesktopPriceCoef} = $multiplier_pct;
    $object->{TabletPriceCoef} = $multiplier_pct;
}

=head3 _merge_product_type_coef($row, $object_type, $object, $multiplier_type, $bs_multiplier_name)

    _merge_product_type_coef($row, order => $order, video => 'Video');
    _merge_product_type_coef($row, context => $context, performance_tgo => 'PerformanceTgo');

    Заполнить в объекте $object->{ProductTypeCoef} коэффициент к ставке типа $multiplier_type.
    Используются данные из таблицы hierarchical_multipliers.

    Параметры:
        $row            - hashref с данными о заказе/условии/баннере (элемент данных "снепшота")
        $object_type    - для кого объекта нужен коэффициент.
                          допустимые значения: order, context
        $object         - hashref с данными по заказу или контексту для отправки в БК
        $multiplier_type
        $bs_multiplier_name
    Кроме того, использует глобальные:
        $MULTIPLIERS    - словарь с коэффициентами

=cut
sub _merge_product_type_coef
{
    my ($row, $object_type, $object, $multiplier_type, $bs_multiplier_name) = @_;

    my $multiplier_pct;
    if ($object_type eq 'context') {
        $multiplier_pct = $MULTIPLIERS->{$multiplier_type}->{for_pid}->{ $row->{context_pId} };
    } elsif ($object_type eq 'order') {
        $multiplier_pct = $MULTIPLIERS->{$multiplier_type}->{for_cid}->{ $row->{campaign_pId} };
    } else {
        $log->die("_merge_product_type_coef: invalid object_type: $object_type");
    }

    $object->{ProductTypeCoef} //= {};
    $object->{ProductTypeCoef}{$bs_multiplier_name} = defined($multiplier_pct) ? int($multiplier_pct) : undef;
}


sub _get_multiplier_data {
    my ($row, $object_type, $object, $multiplier_type) = @_;

    my $json_data;
    if ($object_type eq 'context') {
        $json_data = $MULTIPLIERS->{$multiplier_type}->{for_pid}->{ $row->{context_pId} };
    } elsif ($object_type eq 'order') {
        $json_data = $MULTIPLIERS->{$multiplier_type}->{for_cid}->{ $row->{campaign_pId} };
    } else {
        $log->die("_resolve_multiplier_data: invalid object_type for $multiplier_type: $object_type");
    }
    return undef if !$json_data;
    return $json_obj->decode($json_data);
}


=head3 _merge_socdem_coef($row, $object_type, $object)

    _merge_socdem_coef($row, order => $order);
    _merge_socdem_coef($row, context => $context);

    Заполнить в объекте $object типа $object_type коэффициенты к ставкам по соцдему.

    Параметры:
        $row            - hashref с данными о заказе/условии/баннере (элемент данных "снепшота")
        $object_type    - для кого объекта нужен коэффициент.
                          допустимые значения: order, context
        $object         - hashref с данными по заказу или контексту для отправки в БК
    Кроме того, использует глобальные:
        $MULTIPLIERS    - словарь с коэффициентами
        $json_obj - для json'ификации

=cut

sub _merge_socdem_coef {
    my ($row, $object_type, $object) = @_;

    $object->{SocdemCoef} = _get_multiplier_data($row, $object_type, $object, 'demography');

    state $new_style_propetry = Property->new('BS_NEW_STYLE_MULTIPLIERS_PERCENT');
    my $percent = $new_style_propetry->get(60) || 0;
    if ($percent && $percent > ($row->{campaign_pId} % 100)) {
        $object->{ExpressionCoefs} //= _nosoap({});
        $object->{ExpressionCoefs}->value->{Socdem} = _get_multiplier_data($row, $object_type, $object, 'demography_new');
    }
}


=head3 _merge_weather_coef($row, $object_type, $object)

    _merge_weather_coef($row, order => $order);
    _merge_weather_coef($row, context => $context);

    Заполняет коэффициенты корректировок по погоде для объекта $object типа $object_type.

    Параметры:
        $row            - hashref с данными о заказе/условии/баннере (элемент данных "снепшота")
        $object_type    - для какого объекта нужен коэффициент.
                          допустимые значения: order, context
        $object         - hashref с данными по заказу или контексту для отправки в БК
    использует глобальные:
        $MULTIPLIERS    - словарь с коэффициентами
        $json_obj - для json'ификации

    Исходящий формат корректировок:
      ExpressionCoefs : {
           Weather: [
                {
                  "Expression": [
                    [["temp", "greater or equal", 20]],
                    [["temp", "less or equal", 30]],
                    [["cloudness", "less or equal", 25]],
                    [["prec_type", "equal", 0]]
                  ],
                  "Coef": 1200
                },
              ]
      }
=cut

sub _merge_weather_coef {
    my ($row, $object_type, $object) = @_;

    $object->{ExpressionCoefs} //= _nosoap({});
    $object->{ExpressionCoefs}->value->{Weather} = _get_multiplier_data($row, $object_type, $object, 'weather');
}

=head3 _merge_expression_coefs($row, $object_type, $object)

    Заполняет коэффициенты корректировок, заданных формулами, для объекта $object типа $object_type.
    Формат полностью совпадает с _merge_weather_coef

=cut

sub _merge_expression_coefs {
    my ($row, $object_type, $object) = @_;

    $object->{ExpressionCoefs} //= _nosoap({});

    for my $type ( keys(%BS::Export::EXPRESSION_MULTIPLIER_TYPES) ) {
        my $info_ref = $BS::Export::EXPRESSION_MULTIPLIER_TYPES{ $type };
        my $direct_property_name = $info_ref->{direct_property};
        my $bs_property_name = $info_ref->{bs_property};
        $object->{ExpressionCoefs}->value->{$bs_property_name} =
            _get_multiplier_data($row, $object_type, $object, $direct_property_name);
    }
}

=head3 _merge_retargeting_coef($row, $object_type, $object)

    _merge_retargeting_coef($row, order => $order);
    _merge_retargeting_coef($row, context => $context);

    Заполнить в объекте $object типа $object_type коэффициенты к ставкам по условиям ретаргетинга.

    Параметры:
        $row            - hashref с данными о заказе/условии/баннере (элемент данных "снепшота")
        $object_type    - для кого объекта нужен коэффициент.
                          допустимые значения: order, context
        $object         - hashref с данными по заказу или контексту для отправки в БК
    Кроме того, использует глобальные:
        $MULTIPLIERS            - словарь с коэффициентами
        $RETARGETING_CONDITIONS - словарь с условиями ретаргетинга
        $json_obj - для json'ификации

=cut
sub _merge_retargeting_coef {
    my ($row, $object_type, $object) = @_;

    my $retargeting_multipliers_data = _get_multiplier_data($row, $object_type, $object, 'retargeting');
    my $retargeting_filter_multipliers_data = _get_multiplier_data($row, $object_type, $object, 'retargeting_filter');

    my $retargeting_multipliers;
    my @retargeting_multipliers_new;
    my %result;
    foreach my $multipliers_data ($retargeting_filter_multipliers_data, $retargeting_multipliers_data) {
        if ($multipliers_data) {
            for my $one_ret_multiplier (@$multipliers_data) {
                my $ret_cond_id = $one_ret_multiplier->{ret_cond_id};
                $result{ $ret_cond_id } = {
                    Coef => $one_ret_multiplier->{multiplier_pct},
                    Expression => Retargeting::retargeting_condition_json_to_bs(\$RETARGETING_CONDITIONS->{ $ret_cond_id }->{condition_json}),
                };
                if ($one_ret_multiplier->{type} eq 'retargeting_multiplier') {
                    push @retargeting_multipliers_new, {
                        Expression => [ [["goal-context-id", "match goal context", "".$ret_cond_id]] ],
                        Coef => 0+$one_ret_multiplier->{multiplier_pct},
                    };
                }
            }
        }
    }
    if ($retargeting_multipliers_data || $retargeting_filter_multipliers_data) {
        $retargeting_multipliers = \%result;
    }

    $object->{RetargetingCoef} = $retargeting_multipliers;

    state $new_style_propetry = Property->new('BS_NEW_STYLE_MULTIPLIERS_PERCENT');
    my $percent = $new_style_propetry->get(60) || 0;
    if ($percent && $percent > ($row->{campaign_pId} % 100)) {
        $object->{ExpressionCoefs} //= _nosoap({});
        $object->{ExpressionCoefs}->value->{Goal} = @retargeting_multipliers_new ? \@retargeting_multipliers_new : undef;
    }
}

=head3 _merge_geo_coef($row, $object_type, $object)

    _merge_geo_coef($row, order => $order);

    Заполнить в объекте $object типа $object_type коэффициенты к ставкам по регионам.

    Параметры:
        $row            - hashref с данными о заказе/условии/баннере (элемент данных "снепшота")
        $object_type    - для кого объекта нужен коэффициент.
                          допустимые значения: order. Context не поддерживается БК
        $object         - hashref с данными по заказу для отправки в БК
    Кроме того, использует глобальные:
        $MULTIPLIERS    - словарь с коэффициентами

=cut
sub _merge_geo_coef {
    my ($row, $object_type, $object) = @_;
    if ($object_type ne 'order') {
        $log->die("_merge_geo_coef: invalid object_type: $object_type");
    }
    my $geo_coefs = $MULTIPLIERS->{geo}->{for_cid}->{ $row->{campaign_pId} };

    if ($geo_coefs) {
        my %result;
        for my $one_geo_multiplier (@$geo_coefs) {
            $result{ $one_geo_multiplier-> {region_id} } = $one_geo_multiplier-> {multiplier_pct};
        };
        $object->{RegionCoef} = \%result;
    } else {
        $object->{RegionCoef} = undef;
    }

    state $new_style_propetry = Property->new('BS_NEW_STYLE_MULTIPLIERS_GEO_PERCENT');
    my $percent = $new_style_propetry->get(60) || 0;
    if ($percent && $percent > ($row->{campaign_pId} % 100)) {
        $object->{ExpressionCoefs} //= _nosoap({});
        $object->{ExpressionCoefs}->value->{Geo} = _get_multiplier_data($row, $object_type, $object, 'geo_new');
    }
}

=head3 _merge_ab_segment_coef($row, $object_type, $object)

    _merge_ab_segment_coef($row, order => $order);

    Заполнить в объекте $object типа $object_type коэффициенты к ставкам по аб-сегментам.

    Параметры:
        $row            - hashref с данными о заказе/условии/баннере (элемент данных "снепшота")
        $object_type    - для кого объекта нужен коэффициент.
                          допустимые значения: order. Context не поддерживается БК
        $object         - hashref с данными по заказу для отправки в БК
    Кроме того, использует глобальные:
        $AB_SEGMENT_RETARGETING_CONDITIONS - список условий ретаргетинга аб-серментов
        $MULTIPLIERS                       - словарь с коэффициентами

=cut
sub _merge_ab_segment_coef {
    my ($row, $object_type, $object) = @_;
    if ($object_type ne 'order') {
        $log->die("_merge_ab_segment_coef: invalid object_type: $object_type");
    }
    my $ab_segment_coefs = $MULTIPLIERS->{ab_segment}->{for_cid}->{ $row->{campaign_pId} };

    if ($ab_segment_coefs) {
        my %segments_by_section_id;
        for my $one_ab_segment_multiplier (@$ab_segment_coefs) {
            my $ret_cond = from_json($AB_SEGMENT_RETARGETING_CONDITIONS->{$one_ab_segment_multiplier->{ab_segment_ret_cond_id}});
            for my $cond (@$ret_cond) {
                push @{$segments_by_section_id{$cond->{section_id}}},
                    map {{SegmentID => $_->{goal_id}, Coef => $one_ab_segment_multiplier->{multiplier_pct}}} @{$cond->{goals}}
            }
        }
        $object->{CoefDimensions} = [map {{DimensionID => int($_), Segments => $segments_by_section_id{$_}}} keys %segments_by_section_id];
    } else {
        $object->{CoefDimensions} = [];
    }
}

=head3 _merge_trafaret_position_coef($row, $object_type, $object)

    _merge_trafaret_position_coef($row, order => $order);

    Заполнить в объекте $object типа $object_type коэффициенты к ставкам по регионам.

    Параметры:
        $row            - hashref с данными о заказе/условии/баннере (элемент данных "снепшота")
        $object_type    - для кого объекта нужен коэффициент.
                          допустимые значения: order. Context не поддерживается БК
        $object         - hashref с данными по заказу для отправки в БК
    Кроме того, использует глобальные:
        $MULTIPLIERS    - словарь с коэффициентами

=cut
sub _merge_trafaret_position_coef {
    my ($row, $object_type, $object) = @_;
    if ($object_type ne 'order') {
        $log->die("_merge_trafaret_position_coef: invalid object_type: $object_type");
    }
    my $trafaret_position_coefs = $MULTIPLIERS->{trafaret_position}->{for_cid}->{ $row->{campaign_pId} };

    if ($trafaret_position_coefs) {
        my %result;
        for my $one_trafaret_position_multiplier (@$trafaret_position_coefs) {
            $result{ $BS::Export::TRAFARET_POSITION_TO_BS{$one_trafaret_position_multiplier-> {trafaret_position}} } = $one_trafaret_position_multiplier-> {multiplier_pct} / 100;
        };
        $object->{TrafaretPositionBidCorrections} = _nosoap(\%result);
    }
}

=head3 _merge_order_targeting_expression($order, $row)

    Заполнить в объекте $order КНФ выражение TargetingExpression, если оно не пустое.

    Параметры:
        $order          - hashref с данными по заказу для отправки в БК
        $row            - hashref с данными о заказе
    Кроме того, вызываемые функции используют глобальные словари.

=cut
sub _merge_order_targeting_expression {
    my ($order, $row) = @_;

    my $cid = $order->{EID};
    # CNF - Conjunctive Normal Form
    my @targeting_expression_cnf;

    # в этот список добавляются дтзъюнкции (ИЛИ) литералов (оттого суффикс disj)
    # а элементы этого списка будут соединены через конъюнкцию (И)
    push @targeting_expression_cnf,
        _get_order_brandsafety_exclusion_cnf_disj(_camp($row, 'brandsafety_ret_cond_id'), $cid);

    push @targeting_expression_cnf, _get_order_ios_cnf_disj($row);

    push @targeting_expression_cnf, _get_order_pageids_cnf_disj($row);

    if (@targeting_expression_cnf) {
        $order->{TargetingExpression} = _nosoap(\@targeting_expression_cnf);
    }
}

=head2 _is_conversion_strategy_for_mobile_content

    Проверка является ли стратегия конверсионной для РМП

=cut
sub _is_conversion_strategy_for_mobile_content {
    my $row = shift;
    my $camp = _get_camp($row);
    my $strategy_data = _get_strategy_data($row);
    return is_strategy_avg_cpi($camp) || is_strategy_autobudget($camp) && defined $strategy_data->{goal_id};
}

=head2 _get_order_brandsafety_exclusion_cnf_disj($cid, $brs_ret_cond_id)

    Возвращает список (не arrayref!) дизъюнкций (ИЛИ) литералов для КНФ выражения Brand Safety
    Элементы списка будут соединены конъюнкцией (И) в вызывающей функции.

    Параметры:
        $brs_ret_cond_id - campaigns.brandsafety_ret_cond_id
        $cid             - номер кампании для сообщений об ошибках
    Кроме того использует глобальные словари:
        $BRANDSAFETY_RETARGETING_CONDITIONS - мапа ret_cond_id => condition_json
        $CRYPTA_GOALS - некоторые параметры целей из PPCDICT.crypta_goals

=cut
sub _get_order_brandsafety_exclusion_cnf_disj {
    my ($brs_ret_cond_id, $cid) = @_;

    my @cnf_disj;
    if (!$brs_ret_cond_id) {
        return ();
    }

    if (!$BRANDSAFETY_RETARGETING_CONDITIONS->{$brs_ret_cond_id}) {
        $log->die({
            error => "brandsafety_ret_cond_id not found in retargeting conditions",
            cid => $cid,
            brandsafety_ret_cond_id => $brs_ret_cond_id,
        });
    }
    my $conditions = from_json($BRANDSAFETY_RETARGETING_CONDITIONS->{$brs_ret_cond_id});
    for my $condition (@$conditions) {
        if ($condition->{type} ne 'not') {
            $log->die({
                error => "brandsafety retargeting condition has unsupported type '".$condition->{type}."'",
                cid => $cid,
                brandsafety_ret_cond_id => $brs_ret_cond_id,
                condition_type => $condition->{type},
            });
        }
        for my $goal (@{$condition->{goals}}) {
            my $goal_id = $goal->{goal_id} // 0;
            if (!$CRYPTA_GOALS->{$goal_id}) {
                $log->die({
                    error => "brandsafety goal_id not found in crypta_goals",
                    cid => $cid,
                    brandsafety_ret_cond_id => $brs_ret_cond_id,
                    goal => $goal,
                });
            }
            if (($CRYPTA_GOALS->{$goal_id}->{crypta_goal_type} // '') ne 'brandsafety') {
                $log->die({
                    error => "found non-brandsafety goal in brandsafety retargeting condition",
                    cid => $cid,
                    brandsafety_ret_cond_id => $brs_ret_cond_id,
                    goal => $goal,
                });
            }
            my $crypta_goal = $CRYPTA_GOALS->{$goal_id};
            push @cnf_disj, [[$crypta_goal->{bb_keyword}.'', "not equal", $crypta_goal->{bb_keyword_value}.'']];
        }
    }

    return @cnf_disj;
}

=head3 _get_order_ios_cnf_disj

    Возвращает список (не arrayref!) дизъюнкций (ИЛИ) литералов для КНФ выражения для iOS
    Элементы списка будут соединены конъюнкцией (И) в вызывающей функции.

    Применимо для РМП кампаний
    если выбрана конверсионная стратегия, то отправляем антитаргетинг для iOS >= 14.5
    если выбрана кликовая кампания и стоит флаг на поддержку SkAdNetwork, отправляем таргетинг для iOS >= 14
    если выбрана кликовая кампания, не стоит флаг на поддержку SkAdNetwork и не стоит флаг показов на iOS >= 14.5,
    отправляем антитаргетинг для iOS >= 14.5

    Параметры:
        $row - hashref с данными о заказе/условии/баннере (элемент данных "снепшота")

=cut
sub _get_order_ios_cnf_disj {
    my $row = shift;

    my %opts = _camp_opts($row);

    my @cnf_disj = ();

    if (_is_mobile_content_campaign($row)) {
        if (_is_conversion_strategy_for_mobile_content($row)) {
            push @cnf_disj, [
                [
                    $BS::Export::DIRECT_TO_BS_TARGETING_FORMAT->{os_families}->{bs_name},
                    $BS::Export::DIRECT_TO_BS_TARGETING_FORMAT->{os_families}->{filtering_operation},
                    "3:14005:"
                ]
            ];
        } elsif ($opts{is_skadnetwork_enabled}) {
            push @cnf_disj, [
                [
                    $BS::Export::DIRECT_TO_BS_TARGETING_FORMAT->{os_families}->{bs_name},
                    $BS::Export::DIRECT_TO_BS_TARGETING_FORMAT->{os_families}->{targeting_operation},
                    "3:14000:"
                ]
            ];
        } elsif (!$opts{is_new_ios_version_enabled}) {
            push @cnf_disj, [
                [
                    $BS::Export::DIRECT_TO_BS_TARGETING_FORMAT->{os_families}->{bs_name},
                    $BS::Export::DIRECT_TO_BS_TARGETING_FORMAT->{os_families}->{filtering_operation},
                    "3:14005:"
                ]
            ];
        }
    }
    return @cnf_disj;
}

=head3 _get_order_pageids_cnf_disj

    Возвращает список (не arrayref!) дизъюнкций (ИЛИ) литералов для КНФ выражения для PageId
    Элементы списка будут соединены конъюнкцией (И) в вызывающей функции.


    Параметры:
        $row - hashref с данными о заказе/условии/баннере (элемент данных "снепшота")

=cut
sub _get_order_pageids_cnf_disj {
    my $row = shift;

    my @disallowed_page_ids = grep { $_ } @{from_json(Encode::decode('UTF-8', _camp($row, 'disallowed_page_ids')) || '[]')};
    return map {[['page-id', 'not equal', "".$_ ]]} @disallowed_page_ids;
}

=head3 _merge_inventory_coef($row, $object_type, $object)

    _merge_inventory_coef($row, order => $order);

    Заполнить в объекте $object типа $object_type коэффициенты к ставкам по типу инвентаря.

    Параметры:
        $row            - hashref с данными о заказе (элемент данных "снепшота")
        $object_type    - для кого объекта нужен коэффициент.
                          допустимые значения: order. Context не поддерживается БК
        $object         - hashref с данными по заказу для отправки в БК
    Кроме того, использует глобальные:
        $MULTIPLIERS    - словарь с коэффициентами

=cut
sub _merge_inventory_coef {
    my ($row, $object_type, $object) = @_;
    if ($object_type ne 'order') {
        $log->die("_merge_inventory_coef: invalid object_type: $object_type");
    }

    # inventory type в как это желает принимать БК
    my %INVENTORY_TYPE_DICT = (
        instream_web => 'InStream',
        inpage       => 'InPage',
        inapp        => 'InApp',
        interstitial => 'InApp',
        inbanner => 'InBanner',
        rewarded => 'Rewarded',
    );

    my %inventory_coefs = map {$_->{inventory_type} => $_->{multiplier_pct}}
            @{$MULTIPLIERS->{inventory}->{for_cid}->{ $row->{campaign_pId} }};
    my %banner_type_coefs = map {$_->{banner_type} => $_->{multiplier_pct}}
            @{$MULTIPLIERS->{banner_type}->{for_cid}->{ $row->{campaign_pId} }};

    my %inventory_result;
    my $product_type_result;
    if (%banner_type_coefs) {
        if ($banner_type_coefs{cpm_banner}) {
            $product_type_result = int($banner_type_coefs{cpm_banner});
        }
        if ($banner_type_coefs{cpm_video}) {
            %inventory_result = map {$_ => $banner_type_coefs{cpm_video}} values %INVENTORY_TYPE_DICT;
        }
    }
    if (%inventory_coefs) {
        for my $key (keys %INVENTORY_TYPE_DICT) {
                $inventory_result{$INVENTORY_TYPE_DICT{$key}} = $inventory_coefs{$key} if (defined $inventory_coefs{$key});
                # если ни из cpm_video, ни из inventory_coefs не пришло значение - принудительно ставим undef
                $inventory_result{$INVENTORY_TYPE_DICT{$key}} = undef if (!exists $inventory_result{$INVENTORY_TYPE_DICT{$key}});

        }
    }

    $object->{ProductTypeCoef} //= {};
    $object->{ProductTypeCoef}{MediaCreativeReach} = ($product_type_result) ? $product_type_result : undef;

    $object->{InventoryTypeCoef} = (%inventory_result) ? \%inventory_result : undef;
}

=head3 _merge_mobile_content_targetings($context, $row)

    Заполнить в контексте $context поля, определяющие специфичный
        для групп типа "реклама мобильного контента" таргетинг:
          DeviceTypeTargeting   - тип устройства
          NetworkTargeting      - тип соединения
          MobileOSMinVersion    - минимальная версия ОС устройства

    Параметры:
        $context    - hashref - данные (для отправки) по контексту, в него будет добавлены поля
        $row        - hashref с данными о заказе/условии/баннере (элемент данных "снепшота")
    Кроме того, использует глобальные:
        $MOBILE_CONTENT    - словарь с данными о мобильном контенте

=cut
sub _merge_mobile_content_targetings {
    my ($context, $row) = @_;

    # Таргетинг по типу устройства
    my %adgroup_device_type_targeting = map { $_ => undef } split(qr/,/, $row->{p_device_type_targeting} // '');
    my %bs_device_type_targeting;
    for my $device_type (qw/Phone Tablet/) {
        $bs_device_type_targeting{$device_type} = exists $adgroup_device_type_targeting{lc($device_type)} ? 1 : 0;
    }
    $context->{DeviceTypeTargeting} = \%bs_device_type_targeting;

    # Таргетинг по типу соединения
    my %adgroup_network_targeting = map { $_ => undef } split(qr/,/, $row->{network_targeting} // '');
    my %bs_network_targeting;
    for my $network_type (qw/Cell WiFi/) {
        $bs_network_targeting{$network_type} = exists $adgroup_network_targeting{lc($network_type)} ? 1 : 0;
    }
    $context->{NetworkTargeting} = \%bs_network_targeting;

    # Таргетинг на версию операционной системы
    $context->{MobileOSMinVersion} = BS::ExportMobileContent::get_min_os_version_for_bs(
        $row->{p_min_os_version},
        $MOBILE_CONTENT->{ $row->{mobile_content_id} },
    );
}

=head3 _merge_experiments_data($order, $row)

    Заполнить в объекте $order данные, относящиеся к параметрам AB-теста на заказе

    Параметры:
        $order      - hashref с данными по заказу для отправки в БК
        $row        - hashref с данными о заказе/условии/баннере (элемент данных "снепшота")
    Кроме того, использует глобальные:
        $EXPERIMENTS    - словарь с данными по кампаниям, участвующим в A/B-тестировании

=cut

sub _merge_experiments_data {
    my ($order, $row) = @_;
    my $result;

    if (!_is_wallet_campaign($row) && exists $EXPERIMENTS->{ $row->{campaign_pId} }) {
        my $camp_experiments_data = $EXPERIMENTS->{ $row->{campaign_pId} };

        $result = { ExperimentID => $camp_experiments_data->{experiment_id} };
        if ($camp_experiments_data->{role} eq "primary") {
            $result->{From} = 0;
            $result->{To} = $camp_experiments_data->{percent} - 1;
        } elsif ($camp_experiments_data->{role} eq "secondary") {
            $result->{From} = $camp_experiments_data->{percent};
            $result->{To} = 99;
        } else {
            $log->die({error => "unsupported campaign role in experiments", cid => $row->{campaign_pId}, experiments_data => $camp_experiments_data});
        }
    }

    $order->{ExperimentOnPercentageOfUsers} = $result;
}

=head3 _merge_impression_standard_time($order, $row)

    Заполнить в $order данные по стандарту определения видимости.

=cut
sub _merge_impression_standard_time {
    my ($order, $row) = @_;

    return if !camp_kind_in(type => _camp($row, 'c_type'), "cpm");
    my $time = _camp($row, "impression_standard_time") || 1000;

    if (!exists($IMPRESSION_STANDARD_TYPES{$time})) {
        BS::Export::buggy_cid($order->{EID});
        $log->die({error => "unsupported impression standard time", time => $time, cid => $order->{EID}});
    }
    my $type = $IMPRESSION_STANDARD_TYPES{$time};
    $order->{ImpressionStandardTime} = _nosoap($time + 0);
    $order->{ImpressionStandardType} = _nosoap($type);
}

=head3 _merge_eshows_params($row, $order)

    Заполнить в заказе поля, относящиеся к Eshows:
        EshowsBannerRate
        EshowsVideoRate
        EshowsVideoType

    Значения этих параметров из БД валидируются, и если неправильные, кампания уносится в багги,
    а транспорт падает.

=cut

sub _merge_eshows_params {
    my ($row, $order) = @_;

    _merge_eshow_rate($row, $order, 'eshows_banner_rate', 'EshowsBannerRate');
    _merge_eshow_rate($row, $order, 'eshows_video_rate', 'EshowsVideoRate');

    my $eshows_video_type = _camp($row, 'eshows_video_type');
    if (defined($eshows_video_type)) {
        my $bs_value = ESHOWS_VIDEO_TYPES_MAPPING->{$eshows_video_type};
        if (!defined($bs_value)) {
            BS::Export::buggy_cid($order->{EID});
            $log->die({error => "invalid eshows video type: $eshows_video_type", eshows_video_type => $eshows_video_type, cid => $order->{EID}});
        }
        $order->{EshowsVideoType} = _nosoap($bs_value);
    }
}

=head3 _merge_eshow_rate($row, $order, $name, $bs_name)

    см _merge_eshows_params

=cut

sub _merge_eshow_rate {
    my ($row, $order, $name, $bs_name) = @_;

    my $value = _camp($row, $name);
    if (defined($value)) {
        if ($value < 0 || $value > 1) {
            BS::Export::buggy_cid($order->{EID});
            $log->die({error => "invalid eshows rate '$name': $value", $name => $value, cid => $order->{EID}});
        }
        $order->{$bs_name} = _nosoap(sprintf("%0.2f", $value) + 0);
    }
}

=head3 _merge_auction_priority($order, $row)

    Заполнить в контексте $order полe AuctionPriority

=cut
sub _merge_auction_priority {
    my ($order, $row) = @_;

    my $auction_priority = _camp($row, 'camp_auction_priority') || _camp($row, 'package_auction_priority');
    if ($auction_priority) {
        $order->{AuctionPriority} = int($auction_priority);
    } else {
        my $value = _camp($row, 'available_ad_group_types');
        if (defined $value) {
            my %adgroup_types = map {$_ => 1} split(qr/,/, $value);

            if ($adgroup_types{cpm_yndx_frontpage}) {
                $order->{AuctionPriority} = AUCTION_PRIORITY;
            }
        }
    }
}

=head3 _merge_allowed_domains($order, $row)
    Заполнить в контексте $order поле AllowedDomains данными с кампании или пакета
    Параметры:
        $order      - hashref - данные (для отправки) по заказу, в него будет добавлено поле
        $row        - hashref с данными о заказе/условии/баннере (элемент данных "снепшота")
=cut

sub _merge_allowed_domains {
    my ($order, $row) = @_;

    my @camp_allowed_domains = _get_domains_from_json($row, 'camp_allowed_domains');

    if (_is_cpm_banner_campaign($row) && !@camp_allowed_domains) {
        @camp_allowed_domains = _get_domains_from_json($row, 'default_allowed_domains');
    } elsif (_is_cpm_price_campaign($row)) {
        @camp_allowed_domains = _get_domains_from_json($row, 'package_allowed_domains');
    }

    if (@camp_allowed_domains) {
        $order->{AllowedDomains} = _nosoap([uniq @camp_allowed_domains]);
    }
}

=head3 _get_domains_from_json ($row, $field_name)

    Извлечь из $row для кампании значение поля $field_name, привести в punnycode

=cut

sub _get_domains_from_json {
    my ($row, $field_name) = @_;
    return map { Yandex::IDN::idn_to_ascii($_) } grep { $_ } @{from_json(Encode::decode('UTF-8', _camp($row, $field_name)) || '[]')};
}

=head3 _merge_page_blocks($context, $row)

    Заполнить в контексте $context поля, определяющие специфичный
        для групп типа cpm_outdoor, cpm_indoor таргет

    Параметры:
        $context    - hashref - данные (для отправки) по контексту, в него будет добавлены поля
        $row        - hashref с данными о заказе/условии/баннере (элемент данных "снепшота")

=cut

sub _merge_page_blocks {
    my ($context, $row) = @_;
    my $result = [];

    if ($row->{adgroup_page_blocks}) {
        for my $page (@{from_json($row->{adgroup_page_blocks})}) {
            push @$result, {
                    PageId => int($page->{pageId}),
                    ImpId  => int($page->{impId})
                };
        }
    }

    $context->{PageBlocks} = $result;
}

=head3 _merge_target_tags($context, $row)

    Добавляет Target-теги на группу.
    Эти теги ограничивают набор площадок, на которых может быть показан баннер.

    Параметры:
        $context    - hashref - данные (для отправки) по контексту, в него будет добавлены поля
        $row        - hashref с данными о заказе/условии/баннере (элемент данных "снепшота")

=cut

sub _merge_target_tags {
    my ($context, $row) = @_;

    my $target_tags_value = _calc_target_tags($row);
    if ($target_tags_value) {
        $context->{TargetTags} = from_json($target_tags_value);
    }
}

=head3 _get_or_create_context_targeting_expression($context)

    Создаёт TargetingExpression в контексте

=cut
sub _get_or_create_context_targeting_expression {
    my ($context) = @_;

    my $expression;
    if ($context->{TargetingExpression}) {
        $expression = $context->{TargetingExpression}->value;
    } else {
        $expression = [];
        $context->{TargetingExpression} = _nosoap($expression);
    }
    return $expression;
}

=head3 _merge_additional_targetings($context, $targeting)

    Заполняет TargetingExpression таргетингами из adgroup_additional_targetings

=cut

sub _merge_additional_targetings {
    my ($context, $targeting) = @_;

    my $expression = _get_or_create_context_targeting_expression($context);

    unless (exists $BS::Export::DIRECT_TO_BS_TARGETING_FORMAT->{$targeting->{targeting_type}}) {
        return;
    }

    my $targeting_format = $BS::Export::DIRECT_TO_BS_TARGETING_FORMAT->{$targeting->{targeting_type}};
    my $operation = $targeting->{targeting_mode} eq 'targeting'
        ? $targeting_format->{targeting_operation}
        : $targeting_format->{filtering_operation};
    my $bs_name = $targeting_format->{bs_name};

    if ($targeting_format->{type} eq 'list') {
        my $values = [];
        if ($targeting->{targeting_type} eq 'content_categories') {
            push @$values, _make_bs_content_categories_expr($context, $targeting->{value}, $operation);
        } else {
            for my $value (@{from_json($targeting->{value})}) {
                if (exists $targeting_format->{list_values_mapping}) {
                    if ($targeting->{targeting_type} eq 'mobile_installed_apps') {
                         # для mobile_installed_apps нужно проставить ContentStoreAppID, ContentStoreName.
                         # см BS:Export::_convert_mobile_installed_apps_targeting_value_to_bs_format
                         BS::ExportMobileContent::merge_content_store_data($value, $MOBILE_CONTENT->{ $value->{mobileContentId} });
                    }
                    $value = $targeting_format->{list_values_mapping}->($value);
                }
                push @$values, [ $bs_name, $operation, "" . $value ];
            }
        }
        @$values = xsort {($_->[0], $_->[1], $_->[2])} @$values;
        if ($targeting->{value_join_type} eq 'any') {
            push @{$expression}, $values;
        }
        elsif ($targeting->{value_join_type} eq 'all') {
            for my $value (@$values) {
                my @array = [ $value ];
                push @{$expression}, @array;
            }
        }
        else {
            $log->die(sprintf("Unexpected value_join_type in adgroup_additional_targetings: ", $targeting->{value_join_type} // 'undef'));
        }
    }

    if ($targeting_format->{type} eq 'boolean') {
        my $value = ($targeting->{targeting_mode} eq 'targeting' )
            ? $targeting_format->{targeting_value}
            : $targeting_format->{filtering_value};
        push @{$expression}, [[ $bs_name, $operation, "" . $value ]];
    }
}

=head3 _make_bs_content_categories_expr($context, $json_value, $operation)
    Возвращает список (не ArrayRef!) выражений TargetingExpression из переданного
    значения adgroup_additional_targetings.value таргетинга с типом content_categories
    Этому таргетингу нужно такое костыльное вычисление, т.к. в одной дизъюнкции могут
    встречаться условия с разными кейвордами.
    Кейворд определяется по типу crypta_goal
=cut

sub _make_bs_content_categories_expr {
    my ($context, $json_value, $operation) = @_;

    my @values;
    for my $goal_id (@{from_json($json_value)}) {
        my $crypta_type = $CRYPTA_GOALS->{$goal_id}->{crypta_goal_type};
        if (!defined($crypta_type)) {
            $log->die({error => "unknown crypta goal type", goal_id => $goal_id, pid => $context->{EID}});
        }
        my $bs_name = $BS::Export::DIRECT_TO_BS_TARGETING_FORMAT->{content_categories}->{bs_name_by_crypta_type}->{$crypta_type};
        if (!defined($bs_name)) {
            $log->die({error => "unsupported crypta_goal_type", goal_id => $goal_id, crypta_goal_type => $crypta_type, pid => $context->{EID}});
        }
        push @values, [ $bs_name, $operation, "" . $goal_id ];
    }
    return @values;
}

=head3 _calc_target_tags($row)

    Описание

=cut

sub _calc_target_tags {
    my $row = shift;

    # Значения в ряде случаев могут совпадать с _merge_page_group_tags,
    # но при добавлении нужно рассматривать каждый случай отдельно
    return $row->{target_tags_json}
        // DEFAULT_TARGET_TAGS_BY_ADGROUP_TYPE->{$row->{adgroup_type}};
}

=head3 _merge_page_group_tags($context, $row)

    Добавляет PageGroup-теги на группу.
    Эти теги расширяют доступный набор площадок, на которых может быть показан баннер, включая
        в него спецплощадки, без тега недоступные.

    Параметры:
        $context    - hashref - данные (для отправки) по контексту, в него будет добавлены поля
        $row        - hashref с данными о заказе/условии/баннере (элемент данных "снепшота")

=cut

sub _merge_page_group_tags {
    my ($context, $row) = @_;

    my $page_group_tags_value = _calc_page_group_tags($row);
    if ($page_group_tags_value) {
        $context->{PageGroupTags} = from_json($page_group_tags_value);
    }
}

=head3 _calc_page_group_tags($row)

    Описание

=cut

sub _calc_page_group_tags {
    my $row = shift;

    # Значения в ряде случаев могут совпадать с _merge_target_tags,
    # но при добавлении нужно рассматривать каждый случай отдельно
    return $row->{page_group_tags_json}
        // DEFAULT_PAGE_GROUP_TAGS_BY_ADGROUP_TYPE->{$row->{adgroup_type}};
}

=head3 _should_send_audience_segment_goal_ids($context)

    Возвращает 1 если для данной группы нужно передавать поле AudienceSegmentGoalIds.

    https://st.yandex-team.ru/DIRECT-94695

    Параметры:
        $context    - hashref - данные (для отправки) по контексту, в него будет добавлены поля

=cut

sub _should_send_audience_segment_goal_ids {
    my ($context) = @_;

    my %tags_to_process = (
        APP_METRO_TAG() => 1,
        APP_NAVI_TAG()  => 1,
    );

    return $context->{PageGroupTags} && any { exists $tags_to_process{$_} } @{ $context->{PageGroupTags} };
}

=head3 _get_show_condition($row)

    Получить хэш с условием показа

    $order->{ShowCondition} = _get_show_condition($row, $has_timetarget_coef);

    Параметры:
        $row    - hashref с данными о заказе/условии/баннере (элемент данных "снепшота")
        $has_timetarget_coef — 1/0, есть ли почасовые коэффициенты корректировки ставок
    Результат:
        $show_condition - hashref с данными для БК об условиях показа заказа

=cut
sub _get_show_condition {
    my ($row, $has_timetarget_coef) = @_;

    my $show_condition = {};

    $show_condition->{TargetType} = get_target_type(
        _camp($row, 'c_type'),
        _camp($row, 'platform'),
        _camp($row, 'statusYandexAdv'),
        _camp($row, 'showOnYandexOnly'));
    $show_condition->{DontShowDomains} = [ map { Yandex::IDN::idn_to_ascii($_) } map { s/(^\s+|\s+$)//gr } split(/,/, _camp($row, 'DontShowDomains')) ] if (defined _camp($row, 'DontShowDomains'));
    state $use_fake_rmp_show_condition_property = Property->new('use_fake_rmp_show_condition');
    if (_is_mobile_content_campaign($row) && $use_fake_rmp_show_condition_property->get(30)) {
        # временный хак по добавлению безвредной фильтрации в ShowConditions,
        # чтобы БК на своей стороне не скипала TargetingExpression.
        # Уберем в https://st.yandex-team.ru/DIRECT-152373
        if (!$show_condition->{DontShowDomains} || !@{ $show_condition->{DontShowDomains} }) {
            $show_condition->{DontShowDomains} = ["notexistingdomain.ru"];
        }
    }
    $show_condition->{DontShowSSP} = [ grep { $_ } @{ $json_obj->decode(_camp($row, 'disabled_ssp')) } ] if _camp($row, 'disabled_ssp');

    if (_is_cpm_banner_campaign($row) || _is_cpm_price_campaign($row)) {
        my $disabled_video_placements = defined _camp($row, 'disabled_video_placements')
                                         ? $json_obj->decode(Encode::decode('UTF-8', _camp($row, 'disabled_video_placements')))
                                         : [];
        $show_condition->{DontShowVideoDomains} = [ map { Yandex::IDN::idn_to_ascii($_) } @$disabled_video_placements ];
    }

    $show_condition->{DisabledIps} = [ map {my_aton($_)} (split(/,/, _camp($row, 'disabledIps'))) ] if (defined _camp($row, 'disabledIps'));
    # см. https://st.yandex-team.ru/BSDEV-70571

    my @allowed_frontpage_pageids = _get_allowed_frontpage_pageids($row);
    my @allowed_pageids = _get_allowed_pageids($row);
    if (@allowed_frontpage_pageids || @allowed_pageids) {
        $show_condition->{PageID} = [ uniq(@allowed_frontpage_pageids, @allowed_pageids) ];
    }

    $show_condition->{BroadMatchLimit} = 0;

    my $bs_timetarget = TimeTarget::bs_timetarget(_camp($row, 'timeTarget'));
    hash_copy $show_condition, $bs_timetarget, qw(TargetTime TargetTimeLike TargetTimeWorking);
    $show_condition->{MinusPhrases} = _process_minus_phrases($CAMPAIGN_MINUS_OBJECTS->{$row->{campaign_pId}});
    $show_condition->{DeviceType} = [ defined(_camp($row, 'device_targeting')) ? split(/\,/, _camp($row, 'device_targeting')) : () ];

    $show_condition->{StopTime} = (check_mysql_date(_camp($row, 'finish_date'))) ? _camp($row, 'finish_date') : '';
    my $strategy_data = _get_strategy_data($row);
    if ($show_condition->{StopTime} &&
        _is_cpm_price_campaign($row) &&
        ($strategy_data->{name} || '') eq 'period_fix_bid' &&
        $strategy_data->{auto_prolongation}) {

            $show_condition->{StopTime} = date($show_condition->{StopTime})->add(days => 2)->strftime("%Y%m%d");
    }

    if ($has_timetarget_coef || any { exists $bs_timetarget->{$_} } qw(TargetTime TargetTimeLike)) {
        $show_condition->{TimeZone} = TimeTarget::cached_tz_name_by_id(_camp($row, 'timezone_id'));
    }

    return $show_condition;
}

=head3 _get_allowed_frontpage_pageids($row)

    Возвращает список PageID площадок из campaigns_cpm_yndx_frontpage.allowed_frontpage_types
    Или пустой список

=cut
sub _get_allowed_frontpage_pageids {
    my ($row) = @_;

    my $allowed_types = _camp($row, 'allowed_frontpage_types');
    if (defined($allowed_types)) {
        my @page_types = split(',', $allowed_types);
        return @{get_page_ids_by_page_types(\@page_types)};
    }
    return ();
}

=head3 _get_allowed_pageids($row)

    Возвращает список PageID из camp_options.allowed_page_ids
    Или пустой список

=cut
sub _get_allowed_pageids {
    my ($row) = @_;

    if (_camp($row, 'allowed_page_ids')) {
        return map { $_+0 } grep { /^\d+$/ && $_ > 0 } @{ $json_obj->decode(_camp($row, 'allowed_page_ids')) };
    }
    return ();
}

=head3 _get_ab_segments_statistics($row)

    Получить аб-сегменты

    $order->{StatDimensions} = _get_ab_segments_statistics($row);

    Параметры:
        $row    - hashref с данными о заказе/условии/баннере (элемент данных "снепшота")
    Результат:
        $stat_dimension_expression - строка с данными для БК об аб-сегментами
    Кроме того, использует глобальные:
        $AB_SEGMENT_RETARGETING_CONDITIONS    - словарь с условиями ретаргетинга аб-сегментов

=cut
sub _get_ab_segments_statistics {
    my ($row) = @_;

    my $stat_dimension_expression = [];
    my $ab_segment_stat_ret_cond_id = _camp($row, 'ab_segment_stat_ret_cond_id');
    if (!defined $ab_segment_stat_ret_cond_id) {
        return undef;
    }
    my $ret_cond = $AB_SEGMENT_RETARGETING_CONDITIONS->{$ab_segment_stat_ret_cond_id};

    if ($ret_cond) {
        for my $cond (@{from_json($ret_cond)}) {
            push @$stat_dimension_expression, {
                    DimensionID => int($cond->{section_id}),
                    Segments    => [ map {int($_->{goal_id})} @{$cond->{goals}} ]
                };
        }
        return $stat_dimension_expression;
    } else {
        return undef;
    }
}

=head3 _get_ab_segments_retargeting($row)

    Получить аб-сегменты

    $order->{TargetDimensions} = _get_ab_segments_retargeting($row);

    Параметры:
        $row    - hashref с данными о заказе/условии/баннере (элемент данных "снепшота")
    Результат:
        $retargeting_dimension_expression - список аб-сегментов
    Кроме того, использует глобальные:
        $AB_SEGMENT_RETARGETING_CONDITIONS    - словарь с условиями ретаргетинга аб-сегментов

=cut
sub _get_ab_segments_retargeting {
    my ($row) = @_;

    my $retargeting_dimension_expression = [];
    my $ab_segment_ret_cond_id = _camp($row, 'ab_segment_ret_cond_id');
    if (!defined $ab_segment_ret_cond_id) {
        return undef;
    }
    my $ret_cond = $AB_SEGMENT_RETARGETING_CONDITIONS->{$ab_segment_ret_cond_id};

    if ($ret_cond) {
        for my $cond (@{from_json($ret_cond)}) {
            push @$retargeting_dimension_expression, {
                    DimensionID => int($cond->{section_id}),
                    Segments    => [ map {int($_->{goal_id})} @{$cond->{goals}} ]
                };
        }
        return $retargeting_dimension_expression;
    } else {
        return undef;
    }
}

=head3 _are_we_want_to_send_phrases($row)

    Проверить, хотели ли мы отправлять фразы в БК.
    Подробнее описано в секции 'общий комментарий про все $SQL_JOIN_BIDS*'
        модуля BS::ExportWorker

    Логика про статусы модерации фраз - все еще лежит в sql-условиях выборки

    Параметры:
        $row    - hashref с данными о заказе/условии/баннере (элемент данных "снепшота")
    Кроме того, использует глобальные:
        $IGNORE_BS_SYNCED - не учитывать реальный statusBsSynced
    Результат:
        $wanted_to_send - 0/1 - нужно ли отправлять в БК фразы

=cut
sub _are_we_want_to_send_phrases {
    my $p_statusBsSynced = shift->{p_statusBsSynced};
    return ($IGNORE_BS_SYNCED || defined $p_statusBsSynced && $p_statusBsSynced eq 'Sending') ? 1 : 0;
}

=head3 _are_we_can_send_phrases($row)

    Проверить, на основе статусов группы, можем и хотим ли отправлять фразы в БК.

    Параметры:
        $row    - hashref с данными о заказе/условии/баннере (элемент данных "снепшота")
    Результат:
        $can_send - 0/1 - можем и хотим ли отправить в БК фразы

=cut

sub _are_we_can_send_phrases {
    my $row = shift;

    return defined $row->{phrases_PostModerate} && $row->{phrases_PostModerate} =~ /^(Yes|Rejected)$/
            && _are_we_want_to_send_phrases($row)
}

=head3 _are_we_can_show_current_banner

    Проверить, можно ли отправить для показов текущую в Директе версию баннера.
    Логика про статусы модерации и статус показов.

    Параметры:
        $row    - hashref с данными о заказе/условии/баннере (элемент данных "снепшота")
    Результат:
        $can_show - 0/1 - можно ли отправить для показов текущую в Директе версию баннера
=cut

sub _are_we_can_show_current_banner {
    my $row = shift;

    return $row->{banner_statusShow} eq 'Yes'
        && defined $row->{banner_PostModerate} && $row->{banner_PostModerate} eq 'Yes'
        # у графических объявлений - еще одна неотъемлемая часть - сама картинка/креатив
        && (
            !(
                _is_image_ad_or_mcbanner_banner($row)
                || _is_cpm_banner($row)
                || _is_cpm_outdoor_banner($row)
                || _is_cpm_indoor_banner($row)
                || _is_cpm_audio_banner($row)
            )
            || ($row->{image_ad_statusModerate} eq 'Yes' && !_is_creative_admin_rejected($row))
        );
}

=head3 _save_resync_data_for_absent_banner($row, $is_image)

    Добавить (если там еще нет) в глобальный хеш %BANNERS_FOR_RESYNC_WITH_CONTEXT данные для переотправки баннера вместе с условием

    Параметры:
        $row    - hashref с данными о заказе/условии/баннере (элемент данных "снепшота")
        $is_image - признак того, что причиной добавления является картиночный баннер.
                    используется только для логирования
    Кроме того, использует глобальные:
        %BANNERS_FOR_RESYNC_WITH_CONTEXT    - хеш для накопления данных для переотправки баннеров с условиями
        $error_logger - для логирования ошибок

=cut

sub _save_resync_data_for_absent_banner {
    my ($row, $is_image) = @_;

    if (all { $row->{$_} } qw/campaign_pId context_pId banner_pId/) {
        $BANNERS_FOR_RESYNC_WITH_CONTEXT{ $row->{banner_pId} } //= {
            cid         => $row->{campaign_pId},
            bid         => $row->{banner_pId},
            pid         => $row->{context_pId},
            priority    => BS::ResyncQueue::PRIORITY_RESYNC_WHOLE_CONTEXT_FOR_ABSENT_BID,
        };
        $error_logger->({
                message     =>
                "skip sending banner: context is synced; Banner + AdGroup will be added into resync queue",
                banner_type => $is_image ? 'picture' : 'base',
                cid         => $row->{campaign_pId},
                bid         => $row->{banner_pId},
                type        => "banner",
                stage       => "request",
            });
    }
}

=head3 _process_minus_phrases($minus_objects)

    Подготовить минус-слова и минус фразы к отправке в БК в формате списка.
    Для зафиксированных фраз заменяем кавычки на специсимволы (https://st.yandex-team.ru/BSDEV-53166#1472469543000)

    Параметры:
        $minus_objects - arrayref с минус-словами и минус-фразами

    Возвращает arrayref обработанных минус-фраз

=cut

sub _process_minus_phrases {
    my ($minus_objects,) = @_;

    return [] unless $minus_objects;

    return [map { Yandex::MyGoodWords::process_quoted_phrases($_) } @$minus_objects]
}

=head3 _normalize_lang_for_bs($lang)

    Возвращает правильное значение языка для отправки в БК

=cut

sub _normalize_banner_lang_for_bs {
    my $lang = shift;

    if (($lang // '') eq 'kk') {
        $lang = 'kz';
    } elsif (($lang // '') eq 'be') {
        $lang = 'by';
    }

    return $lang;
}

=head3 _camp($row, $field)

    Получить значение поля с именем $field из описания кампании, соответствующей ряду данных $row

=cut

sub _camp {
    my ($row, $field) = @_;

    my $camp = _get_camp($row);

    if (exists $camp->{$field}) {
        return $camp->{$field};
    } else {
        $error_logger->({
                message => "Attempt to get unexistsant field from camp",
                field   => $field,
                cid     => $row->{campaign_pId},
                camp    => $camp,
                stage   => 'request',
                type    => 'order',
            } );
        if (is_beta()) {
            die "Attempt to get unexistent field '" . $field . "' from camp";
        } else {
            return undef;
        }
    }
}

=head3 _camp_opts($row)

    Получить хеш опций из описания кампании

=cut
sub _camp_opts {
    return map {$_ => 1} split ",", _camp(shift, 'opts');
}

=head3 _get_camp($row)

    Получить описание кампании, соответствующей ряду данных $row

=cut

sub _get_camp {
    my ($row) = @_;

    my $camp = $CAMPAIGNS_DESCRIPTIONS->{$row->{campaign_pId}};
    if (! defined $camp) {
        if (is_beta()) {
            die "Attempt to use unfetched camp with cid " . $row->{campaign_pId};
        } else {
            return {}
        }
    }
    return $camp;
}

=head3 _get_vcard_data($row)

    Возвращает hashref с контактной информацией из словаря $VCARDS для баннера из $row.
    Функция должна вызываться только в случае, если есть уверенность, что у баннера есть визитка
    Если ее нет (или если она не была предварительно подгружена в словарь), функция помирает (только на бете).

=cut

sub _get_vcard_data {
    my ($row) = @_;

    my $vcard_data = $VCARDS->{$row->{vcard_id}};
    unless ($vcard_data) {
        if (is_beta()) {
            die "Attempt to use unfetched vcard with vcard_id " . $row->{vcard_id};
        } else {
            return {};
        }
    }

    return $vcard_data;
}

=head3 _has_published_manual_permalink($row)

    Возвращает 1, если у баннера в $row есть заданный вручную опубликованный пермалинк

=cut

sub _has_published_manual_permalink {
    my ($row) = @_;

    my $manual_permalink = _get_active_manual_permalink($row);
    return $manual_permalink && ($manual_permalink->{status_publish} eq 'published') ? 1 : 0;
}

=head3 _has_unpublished_manual_permalink_sent_to_bs($row)

    Возвращает 1, если у баннера в $row есть заданный вручную неопубликованный пермалинк,
    связка с которым хоть раз уходила в БК. Такая ситуация может произойти если
    организацию распубликовали

=cut

sub _has_unpublished_manual_permalink_sent_to_bs {
    my ($row) = @_;

    my $manual_permalink = _get_active_manual_permalink($row);
    return ($manual_permalink
            && ($manual_permalink->{status_publish} eq 'unpublished')
            && ($manual_permalink->{is_sent_to_bs} == 1) ) ? 1 : 0;
}

=head3 _has_moderated_vcard_with_phone_and_no_manual_permalink($row)

    Возвращает 1, если у баннера в $row есть промодерированная визитка, и у этой визитки есть телефон
    из $row смотрит на значение phoneflag и на наличие vcard_id, а телефон подсматривает в словаре $VCARDS

=cut

sub _has_moderated_vcard_with_phone_and_no_manual_permalink {
    my ($row) = @_;

    my $has_manual_permalink = _get_active_manual_permalink($row);

    return ($row->{phoneflag} eq 'Yes'
            && $row->{vcard_id}
            && _get_vcard_data($row)->{phone}
            && !$has_manual_permalink) ? 1 : 0;
}

=head3 _has_turbolanding($row)

    Возвращает 1, если у баннера в $row есть промодерированный турболендинг

=cut

sub _has_turbolanding {
    my ($row) = @_;

    return $row->{banner_tl_id}
        && $TURBOLANDINGS->{ $row->{banner_tl_id}}
        && $row->{banner_tl_statusModerate} eq 'Yes'
    ? 1 : 0;
}

=head3 _is_banner_with_rejected_turbolanding_only($row)

    Возвращает 1, если у баннера, который отправлен в показы  есть только отклоненный привязанный турболендинг

=cut

sub _is_banner_with_rejected_turbolanding_only {
    my ($row) = @_;

    return ($row->{banner_Id}
        && $row->{banner_tl_id} && $row->{banner_tl_statusModerate} eq 'No'
        && !$row->{Href} && !_has_moderated_vcard_with_phone_and_no_manual_permalink($row) && !_has_published_manual_permalink($row)) ? 1 : 0;
}

=head3 _get_active_manual_permalink($row)

    Возвращает ручную привязку организации из справочника к баннеру, если ее данные должны показываться в рекламе (если выключен флага приоритета визитки над организацией, то есть организация приоритетнее визитки).

=cut

sub _get_active_manual_permalink {
    my ($row) = @_;
    my $permalink_data = _get_permalink_data($row);
    if (!$permalink_data) {
        return undef;
    }
    my $manual_permalink = $permalink_data->{permalinks}{manual};
    return ($manual_permalink
            && ($manual_permalink->{prefer_vcard_over_permalink} == 0) ) ? $manual_permalink : undef;
}

=head3 _get_permalink_data($row)

    Возвращает hashref с данными по привязкам организаций из справочника к баннеру.

=cut

sub _get_permalink_data {
    my ($row) = @_;

    if (!$row->{banner_pId}) {
        return undef;
    }

    return $BANNER_PERMALINKS->{$row->{banner_pId}};
}

=head3 _get_client_phone_data($row)

    Возвращает hashref с данными по привязкам телефонов к баннеру.

=cut

sub _get_client_phone_data {
    my ($row) = @_;

    if (!$row->{banner_pId} || !$row->{client_phone_id}) {
        return undef;
    }

    return $CLIENT_PHONES->{$row->{client_phone_id}};
}

=head3 _get_banner_images_formats_data($row)

    Возвращает hashref с информацией из словаря $BANNER_IMAGES_FORMATS для баннера из $row.

=cut

sub _get_banner_images_formats_data {
    my ($row) = @_;

    if (!$row->{banner_image} || !$row->{ClientID}) {
            return undef;
    }

    return $BANNER_IMAGES_FORMATS->{$row->{ClientID}}->{$row->{banner_image}};
}

=head3 _get_template_properties($row)

    Возвращает свойства шаблона внутренней рекламы — формат (format_name) и состояние переведённости на единый формат (state)

=cut

sub _get_template_properties {
    my ($row) = @_;

    if (!$row->{template_id}) {
        return undef;
    }

    return $TEMPLATE_PROPERTIES->{$row->{template_id}};
}

=head3 _get_template_resource_data($row)

    Возвращает hashref с информацией по ресурсу из словаря $TEMPLATE_RESOURCES для переменной шаблона

=cut

sub _get_template_resource_data {
    my ($variable) = @_;

    if (!$variable->{template_resource_id}) {
        return undef;
    }

    return $TEMPLATE_RESOURCES->{ $variable->{template_resource_id} };
}

=head3 _get_template_variables_images_formats_data($row)

    Возвращает hashref с информацией по картинке из словаря $TEMPLATE_VARIABLES_IMAGES_FORMATS для переменной шаблона

=cut

sub _get_template_variables_images_formats_data {
    my ($variable) = @_;

    if (!$variable->{internal_value}) {
        return undef;
    }

    return $TEMPLATE_VARIABLES_IMAGES_FORMATS->{ $variable->{internal_value} };
}

=head3 _get_template_variables($row)

    Возвращает arrayref с информацией по переменным шаблона для баннера из $row.
    Функция должна вызываться только для баннера внутренней рекламы

    Параметры:
        $row - hashref с данными о заказе/условии/баннере (элемент данных "снепшота")
    Кроме того, использует глобальные:
        $TEMPLATE_RESOURCES - словарь с ресурсами шаблона
        $TEMPLATE_VARIABLES_IMAGES_FORMATS - словарь с форматом картинок для переменных шаблона

=cut

sub _get_template_variables {
    my ($row) = @_;

    my $template_variables = $json_obj->decode(Encode::decode('UTF-8', $row->{template_variables}));
    my @result;

    for my $variable (@$template_variables) {
        # пропускаем переменные без значения. Такое может быть если переменная not required
        next unless defined $variable->{internal_value};

        my $resource_data = _get_template_resource_data($variable);
        if ($resource_data) {
            $variable->{template_resource_no} = $resource_data->{resource_no};
            $variable->{unified_template_resource_no} = $resource_data->{unified_resource_no};
            $variable->{unified_template_resource_id} = $resource_data->{unified_template_resource_id};
            $variable->{template_part_no} = $resource_data->{template_part_no};

            if ($resource_data->{is_image}) {
                # если ресурс картиночный, то проставляем переменной информацию по картинке
                my $image_formats = _get_template_variables_images_formats_data($variable);
                if ($image_formats) {
                    my $url = _generate_mds_avatars_url($image_formats, 'orig');

                    $variable->{value} = 'https:'.$url;
                    $variable->{width} = $image_formats->{width};
                    $variable->{height} = $image_formats->{height};
                } else {
                    # buggy-очереди нет для внутренней рекламы
                    # поэтому двигаем кампанию дальше в очереди, чтобы при следующем запуске получилось взять пачку других кампаний
                    BS::Export::delay_cid($row->{campaign_pId});
                    $error_logger->({
                        message              => "image formats is absent in dict",
                        cid                  => $row->{campaign_pId},
                        bid                  => $row->{banner_pId},
                        image_hash           => $variable->{internal_value},
                        template_resource_id => $variable->{template_resource_id},
                        type                 => "banner",
                        stage                => "request",
                    });

                    $log->die(sprintf("Image formats for hash=%s is absent in dict", $variable->{internal_value} // 'undef'));
                }
            } else {
                $variable->{value} = $variable->{internal_value};
            }

            push @result, $variable;
        } else {
            # buggy-очереди нет для внутренней рекламы
            # поэтому двигаем кампанию дальше в очереди, чтобы при след. запуске получилось взять пачку других кампаний
            BS::Export::delay_cid($row->{campaign_pId});
            $error_logger->({
                message              => "template resource is absent in dict",
                cid                  => $row->{campaign_pId},
                bid                  => $row->{banner_pId},
                template_resource_id => $variable->{template_resource_id},
                type                 => "banner",
                stage                => "request",
            });

            $log->die(sprintf("Template resource with id=%s is absent in dict", $variable->{template_resource_id} // 'undef'));
        }
    }

    return \@result;
}

=head3 _merge_dynamic_disclaimer($banner, $row)

    _merge_dynamic_disclaimer($banner, $row);

    Записать в баннер информацию о динамическом дисклеймере

    Параметры:
        $banner         - баннер
        $row            - hashref с данными о заказе/условии/баннере (элемент данных "снепшота")
    Кроме того, использует глобальные:
        DISCLAIMERS    - словарь со дисклеймерами

=cut

sub _merge_dynamic_disclaimer {
    my ($banner, $row) = @_;

    if ($DISCLAIMERS->{$row->{banner_pId}}){
        $banner->{DynamicDisclaimer} = $DISCLAIMERS->{$row->{banner_pId}};
    } else {
        $banner->{DynamicDisclaimer} = undef;
    }
}

=head3 _merge_banner_experiments_data($banner, $row)

    _merge_banner_experiments_data($banner, $row);

    Записать в баннер информацию о динамическом дисклеймере

    Параметры:
        $banner         - баннер
        $row            - hashref с данными о заказе/условии/баннере (элемент данных "снепшота")
    Кроме того, использует глобальные:
        $ADDITIONS->{experiment} - словарь с экспериментами на баннер

=cut

sub _merge_banner_experiments_data {
    my ($banner, $row) = @_;

    if ($ADDITIONS->{experiment}->{$row->{banner_pId}}) {
        my $experiment = eval { $json_obj->decode(Encode::decode('UTF-8', $ADDITIONS->{experiment}->{$row->{banner_pId}})) };
        if ($@) {
            $error_logger->({
                    experiment_json => $ADDITIONS->{experiment}->{$row->{banner_pId}},
                    message     => "Can't decode JSON experiment_json for banner",
                    cid         => $row->{campaign_pId},
                    bid         => $row->{banner_pId},
                    type        => "banner",
                    reason      => $@,
                    stage       => "request",
                });
        } else {
            foreach my $key (keys %$experiment) {
                if ($key =~ m/^href_/) {
                    $experiment->{$key} = _convert_href_params($experiment->{$key}, $row);
                }
            }
            $banner->{Resources}->{Experiment} = $experiment;
        }
    }
}

sub _merge_banner_turbo_app_content {
    my ($banner, $row) = @_;

    if(    defined $row->{banner_turbo_app_info_id}
        && $TURBO_APP_CONTENT->{$row->{banner_turbo_app_info_id}}
        && _camp($row, 'has_turbo_app'))
    {
        $banner->{Resources}->{TurboAppId} = _nosoap($TURBO_APP_CONTENT->{$row->{banner_turbo_app_info_id}}->{TurboAppId});
        $banner->{Resources}->{TurboAppContent} = _nosoap(Encode::decode('UTF-8', $row->{turbo_app_content}));
        $banner->{Resources}->{TurboAppType} = _nosoap(ucfirst $row->{banner_turbo_app_type});
    }
}

=head2 _is_in_banner_creative
    Определяет, является ли баннер IN-Banner
    Параметры:
        $row    - хеш с данными (исходными) по заказу/условию/баннеру
    Результат:
        0/1 - является ли баннер - смарт in_banner
=cut
sub _is_in_banner_creative {
    my $row = shift;

    if (($row->{perf_creative_type} // '') ne 'canvas') {
        return 0;
    }

    my $layout_id = $row->{perf_layout_id} // 0;
    return ($layout_id >= IN_BANNER_LOW_LAYOUT_ID && $layout_id < IN_BANNER_HIGH_LAYOUT_ID) ? 1 : 0;
}


=head3 _merge_banner_template_id($banner, $row)

   Метод  используется для баннеров c типом text(обычный и картиночный) | dynamic | mobile_content.
   Определяет один из 3х возможных шаблонов для баннера. Заполняет поле TemplateID.
   Требования https://st.yandex-team.ru/DIRECT-60917

   Параметры:
       $banner      - баннер для отправки
       $row         - снепшот БД
       использует глобальные идентификаторы шаблонов PPC_TEMPLATE_ID_GEO, PPC_TEMPLATE_ID_NEW, PPC_TEMPLATE_ID

=cut

sub _merge_banner_template_id {
    my ($banner, $row) = @_;
    unless ( defined($banner->{TemplateID}) ) {
        if (_is_dynamic_banner($row) || _is_mobile_content_banner($row) || _is_text_banner($row)
            || _is_content_promotion_banner($row))
        {
            $banner->{TemplateID} = PPC_TEMPLATE_ID;

            if (defined($banner->{GeoFlag}) && $banner->{GeoFlag} > 0) {
                $banner->{TemplateID} = PPC_TEMPLATE_ID_GEO;
            }
            if (any { defined($banner->{$_}) } qw/ContactInfo GeoInfo/) {
                $banner->{TemplateID} = PPC_TEMPLATE_ID_NEW;
            }
            if ($banner->{Permalink} && UNIVERSAL::can($banner->{PermalinkAssignType}, 'value') && ($banner->{PermalinkAssignType}->value() eq 'manual')) {
                # для объявления с ручной организацией используем шаблон с контактной информацией
                $banner->{TemplateID} = PPC_TEMPLATE_ID_NEW;
            }
        }
    }
}

=head2 _get_auto_video_creative_id

Функция возвращает AutoVideoCreative для баннера, либо undef, если для данного баннера нельзя показывать автовидео
Второй возвращаемый параметр - дополнительные параметры для баннера

$row - строка из базы
%opt:
    flags - переопределить флаги баннера вместо $row->{flags}
    is_image - получить creativeId для картиночного баннера

=cut

sub _get_auto_video_creative_id
{
    my ($row, %opt) = @_;
    my $flags = exists $opt{flags} ? $opt{flags} : $row->{flags};
    $flags //= '';
    my $addition = _get_auto_video_addition($row);
    if ($addition) {
        my $creative_id = $addition->{stock_creative_id};
        my $banner_data;
        if (_is_cpm_banner($row)) {
            if (_is_non_skippable_cpm_video($addition)) {
                $banner_data = {
                    IsVideoCreativeNonSkippable => 1,
                };
            } else {
                $banner_data = {
                    IsVideoCreative => 1,
                };
            }
            if (_is_brand_lift($row)) {
                $banner_data->{IsVideoCreativeReachSurvey} = 1;
            }
        } elsif (_is_cpc_video_banner($row)) {
            my $moderate_info = eval { from_json($addition->{moderate_info}//'') } || {};
            my %text_data = map { ( $_->{type} => $_->{text} ) } @{$moderate_info->{texts}//[]};
            $banner_data = {
                # предполагается, что title и body уже скопированы из креатива в баннер
                # Title => $text_data{title},
                # Body => $text_data{body},
                # Site => $text_data{domain},
                Age => defined $text_data{age} ? $text_data{age} . "+" : undef,
                IsVideoCreative => 1,
            };
            # для видеобаннеров в РМП домен из конструктора не заполняем. Потому что его там нет. (DIRECT-99892)
            if (!_is_mobile_content_adgroup($row)) {
                $banner_data->{Site} = $text_data{domain};
            }
            if (_is_brand_lift($row)) {
                $banner_data->{IsVideoCreativeSurvey} = 1;
            }
        } elsif (_is_cpm_outdoor_banner($row)) {
            my ($title, $body) = TextTools::extract_first_words($addition->{extracted_text} // '', $Settings::MAX_TITLE_LENGTH);
            $banner_data = {
                Title => $title || $Direct::Model::BannerImageAd::Constants::TITLE_PLACEHOLDER,
                Body => $body || $Direct::Model::BannerImageAd::Constants::BODY_PLACEHOLDER,
                IsVideoCreativeOutdoor => 1,
            };
        } elsif (_is_cpm_indoor_banner($row)) {
            my ($title, $body) = TextTools::extract_first_words($addition->{extracted_text} // '', $Settings::MAX_TITLE_LENGTH);
            $banner_data = {
                Title => $title || $Direct::Model::BannerImageAd::Constants::TITLE_PLACEHOLDER,
                Body => $body || $Direct::Model::BannerImageAd::Constants::BODY_PLACEHOLDER,
                IsVideoCreativeIndoor => 1,
            };
        } elsif (_is_cpm_audio_banner($row)) {
            my ($title, $body) = TextTools::extract_first_words($addition->{extracted_text} // '', $Settings::MAX_TITLE_LENGTH);
            $banner_data = {
                Title => $title || $Direct::Model::BannerCpmAudio::Constants::TITLE_PLACEHOLDER,
                Body => $body || $Direct::Model::BannerCpmAudio::Constants::BODY_PLACEHOLDER,
                IsAudioCreative => 1,
            };
        } else {
            $banner_data = {
                IsAutoVideo => 1,
            };
        }

        return ($creative_id, $banner_data);
    }

    if ($opt{is_image}) {
        if ($flags !~ /\bmedia_disclaimer\b/) {
            return (AUTO_VIDEO_DEFAULT_CREATIVE_ID, { IsAutoVideo => 1 });
        }
    }
    return;
}

=head2 _get_auto_video_addition($row)

    Возвращает auto_video дополнение для баннера $row из $ADDITIONS->{auto_video}.

    Если оно не найдено, возвращает undef.

=cut
sub _get_auto_video_addition {
    my ($row) = @_;

    if ($ADDITIONS->{auto_video}) {
        my $addition_target_id = $row->{$BS::Export::ADDITION_TARGET_TO_SNAPSHOT_COLUMN{ $BS::Export::ADDITION_TYPES{auto_video}->{get_by} }};
        if ($ADDITIONS->{auto_video}->{$addition_target_id}) {
            my $addition = $ADDITIONS->{auto_video}->{$addition_target_id};
            if ($addition->{extracted_text}) {
                $addition->{extracted_text} = Tools::get_clean_text($addition->{extracted_text});
            }
            return $addition;
        }
    }
    return undef;
}

=head2 _is_banner_image_resource_enabled($row)

    Можно ли отправлять картинку в ресурсах ТГО/мобильного баннера.
    Зависит от того, на какой процент баннеров включили фичу в ppc_properties

=cut
sub _is_banner_image_resource_enabled {
    my ($row) = @_;

    state $enable_pct_prop //= Property->new('ENABLE_BANNER_IMAGE_RESOURCES_PCT');

    my $pct = $enable_pct_prop->get(60) // 0;
    return ($row->{banner_pId} % 100) < $pct;
}

=head2 _can_show_banner_image_resource($row)

    Можно ли показывать картинку в ТГО/мобильном баннере.
    Можно, если она прошла модерацию и пользователь ее не отключил.

=cut
sub _can_show_banner_image_resource {
    my ($row) = @_;

    return $row->{image_statusModerate} eq 'Yes'
            && $row->{image_statusShow} eq 'Yes';
}

=head2 _get_banner_image_resource($row)

    Получение картинки-ресурса для ТГО/мобильных баннеров.
    Значение MdsMeta передается c отметкой неотправки через SOAP транспорт.

    need_old_smart_center => 1/0    Нужно ли передавать Images => {SmartCenter => ...}

=cut
sub _get_banner_image_resource {
    my ($row, %O) = @_;

    my $image = {};
    # картинка из аватарницы. Формат: Images => { $format_id => { Width => $width, Height => $height, URL => $url } }
    my $bif = _get_banner_images_formats_data($row);
    if ($bif && $bif->{image_formats}) {
        my $image_formats = from_json($bif->{image_formats});
        my %export_formats;
        for my $id (keys %$image_formats) {
            my %export_format = (
                Width => int($image_formats->{$id}->{width}),
                Height => int($image_formats->{$id}->{height}),
                URL => _generate_mds_avatars_url($row, $id),
            );
            if ($O{need_old_smart_center} && exists $image_formats->{$id}->{'smart-center'}) {
                $export_format{SmartCenter} = $image_formats->{$id}->{'smart-center'};
            }
            $export_formats{ uc($id) } = \%export_format;
        }
        $image->{Images} = \%export_formats;
        $image->{ImageType} = $bif->{image_type};
    }
    if ($bif && $bif->{image_mds_meta_json}) {
        $image->{MdsMeta} = _nosoap($bif->{image_mds_meta_json});
    }

    return $image;
}

=head2 _get_banner_big_king_image_resource($row)

    Получение картинки-ресурса для царь-баннера.

=cut
sub _get_banner_big_king_image_resource {
    my $row = shift;
    my $tmp_row = {
        ClientID => $row->{ClientID},
        banner_image => $row->{big_king_banner_image}
    };

    return _get_banner_image_resource($tmp_row);
}

=head2 _is_smart_tgo_creative
    Определить, является ли баннер - смарт ТГО

    Параметры:
        $row    - хеш с данными (исходными) по заказу/условию/баннеру
    Результат:
        0/1 - является ли баннер - смарт ТГО

=cut
sub _is_smart_tgo_creative {
    my $row = shift;

    return ( ($row->{perf_creative_type} // '') eq 'performance'
            && ($row->{perf_layout_id}//0) == TGO_LAYOUT_ID) ? 1 : 0;
}

=head2 _is_auto_video_allowed
    Определить, доступна ли опция auto_video для кампании, которой принадлежит данное объявление

    Параметры:
        $row    - хеш с данными сырыми данными баннера
    Результат:
        0/1 -  доступна ли опция auto_video

=cut

sub _is_auto_video_allowed {
    my $row = shift;
    state $is_auto_video_allowed_by_property = Property->new('AUTO_VIDEO_ENABLED');

    return ($is_auto_video_allowed_by_property->get(60) || $row->{is_auto_video_allowed}) ? 1 : 0;
}


=head2 _nosoap($value)

    Отметка, что значение $value не должно отправляться через SOAP транспорт, т.к.
    принимающая сторона его игнорирует.

    Возвращает объект, который по-разному сериализуется в JSON и XML.
    При сериализации в JSON, сериализуется исходное значение $value,
    При сериализации в XML, объект превращается в строку-заглушку, но только если
    сериализация производится с помощью BS::Export::SOAPSerializer.

=cut
sub _nosoap {
    my ($value) = @_;

    return BS::Export::SkipSOAPData->new($value);
}


=head2 _can_have_billing_aggregates($row)

    Можно ли использовать биллинговые агрегаты для откруток из этой кампании?
    Можно, если кампания под ОС, и этот ОС перешел на схему учета зачислений, когда
    открученные зачисления не переносятся на дочерние кампании, а остаются на ОС.

=cut
sub _can_have_billing_aggregates {
    # JAVA-EXPORT: BillingAggregatesFactory#canHaveBillingAggregates
    my ($wallet_cid, $is_sum_aggregated) = @_;

    return $wallet_cid && ($is_sum_aggregated // 'No') eq 'Yes';
}

=head2 _extract_billing_aggregates($wallet_cid, $camp_type)

    Возвращает коллекцию биллинговых агрегатов, привязаннык к общему счету $wallet_cid,
    на которые нужно записывать открутки кампаний типа $camp_type.
    Или undef, если открутки нужно записывать как раньше - на саму кампанию.
    Коллекция возвращается в формате, пригодном для отправки в БК.

    В коллекции всегда есть агрегат для откруток по умолчанию, и может быть несколько
    других агрегатов, на которые записываются открутки согласно условию, специфичному
    агрегату.

    Например,
    {
        Default => 123456,
        Rules => [
            {
                ProductTypes => ["VideoCreativeReach"],
                Result => 654321
            }
        ]
    }
    - если открутка произошла по продукту охватного видео, то ее записывают на агрегат 654321.
    Иначе - на 123456.

    Если под общим счетом не нашлось биллингового агрегата по умолчанию, возвращается undef.

=cut
sub _extract_billing_aggregates {
    # JAVA-EXPORT: BillingAggregatesFactory#internalGetBillingAggregates
    my ($wallet_cid, $camp_type) = @_;

    my $ba_by_type = $BILLINIG_AGGREGATES->{$wallet_cid};
    if (!$ba_by_type) {
        # под общим счетом нет биллинговых агрегатов
        return undef;
    }

    my $default_product_type = Campaign::Types::default_product_type_by_camp_type($camp_type);
    if (!$default_product_type) {
        return undef;
    }
    my $default_ba = $ba_by_type->{$default_product_type};
    # если не найден агрегат по умолчанию, считаем, что для данного типа кампаний
    # пока не нужно отправлять никаких агрегатов
    if (!$default_ba) {
        return undef;
    }

    my $billing_orders = {
        # важно, чтобы ID агрегата был числом
        Default => $default_ba->id + 0,
        ProductId => $default_ba->product_id,
    };

    my $additional_product_types = Direct::BillingAggregates::get_special_product_types_by_camp_type($camp_type);
    if ($additional_product_types && @$additional_product_types) {
        for my $type (@$additional_product_types) {
            my $ba = $ba_by_type->{$type};
            if (!$ba) {
                next;
            }

            my $rules = _get_billing_aggregate_product_type_rule($type);
            if (!$rules) {
                $error_logger->({
                        message         => "Billing Aggregate rule not found",
                        camp_type       => $camp_type,
                        product_type    => $type,
                        ba_id           => $ba->id,
                        stage           => 'request',
                        type            => 'order',
                    } );
                next;
            }

            push @{$billing_orders->{Rules}}, {
                %$rules,
                Result => $ba->id + 0,
                ProductId => $ba->product_id,
            };
        }
    }

    return $billing_orders;
}

=head2 _get_billing_aggregate_product_type_rule($product_type)

    Возвращает по типу продукта правило выбора биллингового агрегата.

    Это правило согласовывается с БК. Там, согласно этому правилу, принимается решение,
    можно ли записывать открутку на биллинговый агрегат с этим типом продукта.

=cut

sub _get_billing_aggregate_product_type_rule {
    my ($product_type) = @_;

    state $RULES_BY_PRODUCT_TYPE = {
        cpm_video => {
            ProductTypes => ["VideoCreativeReach", "VideoCreativeReachNonSkippable"],
        },
        cpm_outdoor => {
            ProductTypes => ["VideoCreativeReachOutdoor"],
        },
        cpm_indoor => {
            ProductTypes => ["VideoCreativeReachIndoor"],
        },
        cpm_audio => {
            ProductTypes => ["AudioCreativeReach"],
        },
    };

    return $RULES_BY_PRODUCT_TYPE->{$product_type};
}

=head2 _extract_group_minus_words($row)

    Объединяет частные минус-фразы с библиотечными и возвращает общий список минус фраз.
    Параметры:
        $row        -  hashref с данными о заказе/условии/баннере (элемент данных "снепшота")
    Кроме того, использует глобальные:
        $MINUS_PHRASES_DICT - словарь с минус-фразами на группу
        $LIB_MINUS_PHRASES_DICT_BY_PID - словарь с списком библиотечных минус-фраз на группу
=cut
sub _extract_group_minus_words {
    my ($row) = @_;

    my $private_minus_phrases = exists $MINUS_PHRASES_DICT->{ $row->{mw_id} // 'NE' } ? $MINUS_PHRASES_DICT->{ $row->{mw_id} } : undef;
    my $lib_minus_phrases =  exists $LIB_MINUS_PHRASES_DICT_BY_PID->{ $row->{context_pId} // 'NE' } ? $LIB_MINUS_PHRASES_DICT_BY_PID->{ $row->{context_pId} } : undef;

    return merge_private_and_library_minus_words($private_minus_phrases, $lib_minus_phrases);
}

=head2 _is_creative_admin_rejected

    Возвращает 1 если у строки-баннера есть креатив и его статус модерации равен AdminReject

=cut
sub _is_creative_admin_rejected {
    my ($row) = @_;

    return defined $row->{CreativeStatus} && $row->{CreativeStatus} eq 'AdminReject' ? 1 : 0;
}

=head2 _calculate_banner_id

    Вычисляет идентификатор баннера в БК на основе переданного EngineID и bid-a

=cut
sub _calculate_banner_id {
    my ($EID) = @_;

    # Идентификатор баннера в БК (ID) вычисляется из идентификатора баннера в Директе (EID) по схеме SIGNIFICANT_BYTE в старшем байте + EID.
    # Для Директа SIGNIFICANT_BYTE = 1:
    # 0x00FFFFFFFFFFFFFF
    #  & EID
    # +
    # 0x0100000000000000
    if (($EID & ((1 << 56) - 1)) != $EID) {
        $log->die('_calculate_banner_id: EID must be positive and less than 72057594037927935');
    }
    return ($EID & ((1 << 56) - 1)) + BANNER_ID_SIGNIFICANT_BYTE * (1 << 56);
}

=head2 drop_logbroker_only_keys()

    Удаляем данные, которые нужны только в LB-транспорте

=cut
sub drop_logbroker_only_keys {
    my ($query) = @_;
    state $percents_prop = Property->new('BS_EXPORT_SOAP_STRIP_KEYS_PERCENT');
    my %percents = map {/^\s*(\w+)\s*=\s*(\d+)\s*$/ ? ($1, $2) : ()} split /,/, $percents_prop->get(60) // "";

    foreach my $order (values %{$query->{ORDER}}) {
        my $OrderID = $order->{ID};
        foreach my $context (values %{$order->{CONTEXT}}) {
            foreach my $banner (values %{$context->{BANNER}}) {
                for my $key (qw/Resources Sitelinks CalloutSet Images ImagesInfo/) {
                    if ($percents{$key} && $OrderID % 100 < $percents{$key}) {
                        delete $banner->{$key};
                    }
                }
            }
        }
    }
}

=head2

    Вычисляет OrderType или берёт его из таблицы camp_order_types

=cut
sub _calculate_or_get_order_type {
    my ($row) = @_;

    state $prop = Property->new('BS_EXPORT_FIX_ORDER_TYPE_PERCENT');
    my $enable_percent = $prop->get(60) // 0;

    if ($row->{campaign_pId} % 100 < $enable_percent && defined _camp($row, 'order_type')) {
        return int(_camp($row, 'order_type'));
    }

    return
        # геоконтекст
        _is_geo_campaign($row) ? 7
        # реклама бизнес-юнитов
        : _camp($row, 'is_business_unit') ? 9
        # социальная реклама
        : _camp($row, 'social_advertising') || _camp($row, 'social_advertising_agency') ? 10
        # внутренняя реклама
        : _is_internal_campaign($row) || _camp($row, 'statusYandexAdv') eq 'Yes' || _camp($row, 'paid_by_certificate') eq 'Yes' || (_camp($row, 'wallet_paid_by_certificate') // '') eq 'Yes' ? 6
        # специальные агентские кампании
        : has_spec_limits(_camp($row, 'AgencyID')) && get_spec_limit(_camp($row, 'AgencyID'), 'is_begun') || $row->{campaign_pId} == 2834265 ? 8
        # обычный Директ - коммерция
        : 1;
}

1;
