package BS::ExportWorker::LogBrokerBufferNewProto;

=encoding utf8

=head1 NAME

    BS::ExportWorker::LogBrokerBufferNewProto

=head1 DESCRIPTION

    Объект для накапливания данных на отправку в БК через logbroker.
    Такой же, как LogBrokerBufferPipeWhole, только отправка происходит по новому
    протоколу и с tvm

=cut

use Direct::Modern;

use BS::Export ();
use Settings ();

use parent 'BS::ExportWorker::LogBrokerBufferPipeWhole';

sub _get_pushclient_params {
    my $self = shift;
    return join ' ', (
    	$self->_get_pushclient_common_params(),
    	'--cron',
    	'--network:proto=pq',
        '--network:threads=2',
    	"--network:tvm-client-id=$Settings::TVM2_APP_ID{scripts}",
    	"--network:tvm-secret-file=$Settings::TVM2_SECRET_PATH{scripts}",
    	"--network:tvm-server-id=$BS::Export::LOGBROKER_TVM_ID",
    	'--logger:remote=0', # из-за включенного tvm логи не могут отправляться
    	'--files="[{name: \"/proc/self/fd/0\", partition_group: '.$self->{source_id}.'}]"',
        "--watcher:storage=null",
    );
}

1;
