package BS::ExportWorker::LogBrokerBufferPipeWhole;

=encoding utf8

=head1 NAME

    BS::ExportWorker::LogBrokerBufferPipeWhole

=head1 DESCRIPTION

    !!! Запись по старому протоколу закрыта, используйте LogBrokerBufferNewProto !!!

    Объект для накапливания данных на отправку в БК через logbroker.
    Копит строку с байтами и по достижению в буфере MAX_BUFFER_LENGTH байт
    отправляет весь буфер в logbroker через push-client (один открытый пайп на все отправки).

=cut

use Direct::Modern;

use Carp qw(croak);

use BS::Export ();
use Settings ();

use parent 'BS::ExportWorker::LogBrokerBufferPipeEach';

=head2

    время, которое считаем "плохим" для итерации отправки (после 5 плохих итераций умираем)

=cut

my $BAD_ITERATION_TIME = 20;

sub new {
    my ($class, %O) = @_;

    my $self = $class->SUPER::new(%O);

    $self->_open_pushclient();

    $self->{bad_iter_nums} = 0;
    return $self;
}

=head2

    Проверяем время, прошедшее с начала другой итерации
    Если оно больше, чем $BAD_ITERATION_TIME, то считаем прошедшую итерацию плохой.
    После пяти плохих итераций умираем.

=cut

sub _check_iteration_time {
    my $self = shift;

    my $current_time = time;

    if (defined $self->{last_start_time}) {

        if ($current_time - $self->{last_start_time} > $BAD_ITERATION_TIME) {
            $self->{bad_iter_nums}++;
        } else {
            $self->{bad_iter_nums} = 0;
        }

        if ($self->{bad_iter_nums} > 5) {
            $self->_log_fail_and_croak("happend 5 bad iterations (> ${BAD_ITERATION_TIME}s)");
        }
    }

    $self->{last_start_time} = $current_time;
}

sub _get_push_client {
    my $self = shift;
    # empty
}

sub _after_print {
    my $self = shift
    # empty
}

sub DESTROY {
    my $self = shift;

    $self->close(skip_flush => 1);
}

1;
