package BS::Search;

=head1 NAME

    BS::Search - утилиты для поиска по баннерам на стороне БК

=head1 SYNOPSIS

=head1 DESCRIPTION

=cut

use strict;
use warnings;

use Settings;

use Yandex::Trace;
use Yandex::HTTP;
use JSON;

=head2 fulltext_search

  Делает запрос к API БК для осуществления полнотекстового поиска по тексту объявлений.

  Принимает на вход следующие параметры
    $text - поисковая фраза

  Возвращает массив из bid'ов
=cut

sub fulltext_search {

    my ( $text ) = @_;
    my @bids = ();
    my $profile = Yandex::Trace::new_profile('bs:bansearch');
    my $response = eval {
        Yandex::HTTP::http_fetch(
            'GET',
            $Settings::BS_FULLTEXT_SEARCH_URL,
            { 'text' => $text },
            'timeout' => $Settings::BS_FULLTEXT_SEARCH_TIMEOUT,
            'headers' => {
                "Accept"          => 'text/json',
                "Accept-Charset"  => 'utf-8',
                "Host"            => $Settings::BSRANK_HOST,
            },
        );
    };

    if (!defined $response) {
        die( sprintf( "SearchBanners::search_banners: response code from %s is not OK: %s", $Settings::BS_FULLTEXT_SEARCH_URL, $@ ) );
    }

    my $resultBanners = ( eval { JSON::from_json( $response ) } || {} )->{ 'banners' } || [];

    die( "SearchBanners::search_banners: couldn't convert response to JSON.\n $@" ) if ( $@ );

    # возьмём срез полученного массива в пределах заданнных offset и limit
    # grep нужен для фильтрации - иногда БК возвращает пустые хеши
    #  @bids = grep { defined( $_ ); } map { $_->{'bid'}; } @{ $resultBanners }[ $params->{'offset'} || 0 .. $params->{ 'limit' } || scalar( @{$resultBanners} ) ];
    @bids = map { $_->{'bid'}; } @{ $resultBanners };

    return( @bids );
}

1;
__END__
