package BSAuction;

=head1 NAME

    BSAuction - получение цен в аукционе БК. Старая версия, оставлена только для bs_get_phrases_statuses

=head1 SYNOPSIS

=head1 DESCRIPTION

=cut

use Direct::Modern;

use HTTP::Request;
use HTTP::Request::Common;
use List::Util qw/min max/;
use List::MoreUtils qw/uniq/;
use Yandex::HashUtils;

use Settings;
use BannerTemplates;
use JavaIntapi::GetShowConditionsStatistic qw//;
use PrimitivesIds qw/get_pid2cid/;
use LogTools qw/log_stacktrace/;

use base qw/Exporter/;
our @EXPORT = qw/bs_get_phrases_statuses/;

=head2 bs_get_phrases_statuses([@banners], $options);

    Получить статусы фраз отдельным вызовом.

    Полученные значение записываются в $banners
    ничего не возвращается. В случае неудачи, завершаемся с die

    Дополнительные опции:
        update_all => 1 -- получить статусы для всех объектов (типы см. ниже)
        update_phrases => 1 -- получаем статусы для фраз
        update_retargetings => 1 -- получаем статусы для условий ретаргетинга
        update_dynamic_conditions => получить статусы для условий нацеливания
        update_performance => 1 -- получить статусы для условий из фильтров (для performance групп)
        update_relevance_matches => 1 -- получить статусы для автотаргетинга

=cut

sub bs_get_phrases_statuses($;$) {
    my ($banners, $options) = @_;
    $options ||= {};

    my @data;
    my $show_conditions_by_pid = {};
    for my $banner (@$banners) {
        if (!exists $banner->{PriorityID} && !exists $banner->{BannerID}) {
            # в рамках спиливания отсюда ContextID, который просто проверялся на наличие
            # заменяем на PriorityID. верю, что он сюда приходит, но так как это perl и на 100% не отгрепать
            # откуда/какие данные приходят — "намазываем" логирование и делаем фоллбек на BannerID
            log_stacktrace("PhraseID", "no BannerID or PriorityID");
        }
        my $was_in_bs = ($banner->{PriorityID} || $banner->{BannerID} ) ? 1 : 0;

        if ($options->{update_all} || $options->{update_phrases}) {
            for my $phrase (@{$banner->{phrases} // []}) {
                hash_merge $phrase, {
                    rank  => $Settings::DEFAULT_RANK,
                    context_stop_flag => 0,
                };
                push @{ $show_conditions_by_pid->{ $banner->{pid} }->{phrases} }, $phrase; 

                next unless $phrase->{id};
                push @data, {type => 'phrase', id => $phrase->{id}, pid => $banner->{pid}, cid => $banner->{cid}};
            }
        }

        # обрабатываем автотаргетинг
        if ($options->{update_all} || $options->{update_relevance_matches}) {
            for my $relevance_match (@{$banner->{relevance_match} // []}) {
                hash_merge $relevance_match, {
                    rank  => $Settings::DEFAULT_RANK,
                    context_stop_flag => 1,
                };
                push @{ $show_conditions_by_pid->{ $banner->{pid} }->{relevance_match} }, $relevance_match; 
                push @data, {type => 'relevance_match', id => $relevance_match->{bid_id}, pid => $banner->{pid}, cid => $banner->{cid}};
            }
        }

        # обрабатываем условия ретаргетинга
        # https://jira.yandex-team.ru/browse/YABS-33561
        if ($options->{update_all} || $options->{update_retargetings}) {
            for my $ret (@{$banner->{retargetings} // []}, @{$banner->{target_interests} // []}) {
                hash_merge $ret, {
                    rank  => $Settings::DEFAULT_RANK,
                    context_stop_flag => 0,
                };
                push @{ $show_conditions_by_pid->{ $banner->{pid} }->{retargetings} }, $ret; 

                my $GoalContextID = $ret->{ret_cond_id};
                next unless $was_in_bs && $GoalContextID;
                push @data, {type => 'retargeting', id => $GoalContextID, pid => $banner->{pid}, cid => $banner->{cid}};
            }
        }

        # обрабатываем условия нацеливания для баннеров, которые были в БК
        if ($options->{update_all} || $options->{update_dynamic_conditions}) {
            for my $dyn_cond (@{$banner->{dynamic_conditions} // []}) {
                hash_merge $dyn_cond, {
                    rank => $Settings::DEFAULT_RANK,
                    context_stop_flag => 0,
                };
                push @{ $show_conditions_by_pid->{ $banner->{pid} }->{dynamic_conditions} }, $dyn_cond; 

                my $dyn_cond_id = $dyn_cond->{dyn_cond_id};
                next unless $was_in_bs && $dyn_cond_id;
                push @data, {type => 'dynamic', id => $dyn_cond_id, pid => $banner->{pid}, cid => $banner->{cid}};
            }
        }

        # обрабатываем условия из фильтров для performance-групп
        if ($options->{update_all} || $options->{update_performance}) {
            for my $filter (@{$banner->{performance_filters} // []}) {
                hash_merge $filter, {
                    rank  => $Settings::DEFAULT_RANK,
                    context_stop_flag => 0,
                };
                push @{ $show_conditions_by_pid->{ $banner->{pid} }->{performance_filters} }, $filter; 

                my $perf_filter_id = $filter->{perf_filter_id};
                # если баннер был в БК ($BannerID) то БК знает id группы
                next unless $was_in_bs && $perf_filter_id;
                push @data, {type => 'performance', id => $perf_filter_id, pid => $banner->{pid}, cid => $banner->{cid}};
            }
        }
    }

    my $items = {};
    foreach my $show_condition (@data) {
        my $type = delete $show_condition->{type};
        push @{ $items->{ $type } }, $show_condition;
    }

    my $statistic = {};
    foreach my $type (keys %$items) { # qw/phrase relevance_match retargeting dynamic performance/
        $statistic->{ $type } = get_show_conditions_statistic($type, $items->{ $type });
    }

    foreach my $pid (keys %$show_conditions_by_pid) {
        my $show_conditions = $show_conditions_by_pid->{ $pid };

        foreach my $phrase (@{ $show_conditions->{phrases} // [] }) {
            my $s = $statistic->{phrase}->{ $pid // '' }->{ $phrase->{id} // '' } // {};
            _set_statistic($phrase, $s, [qw/ctx_shows ctx_clicks ctx_ctr/]);
        }

        # автотаргетинг
        foreach my $relevance_match (@{ $show_conditions->{relevance_match} // [] }) {
            my $s = $statistic->{relevance_match}->{ $pid // '' }->{ $relevance_match->{bid_id} // '' } // {};
            _set_statistic($relevance_match, $s, [qw/shows clicks ctr ctx_shows ctx_clicks ctx_ctr/]);
        }

        # условия ретаргетинга
        foreach my $retargeting (@{ $show_conditions->{retargetings} // [] }) {
            my $s = $statistic->{retargeting}->{ $pid // '' }->{ $retargeting->{ret_cond_id} // '' } // {};
            _set_statistic($retargeting, $s, [qw/ctx_shows ctx_clicks ctx_ctr/]);
        }

        # условия нацеливания
        foreach my $dyn_cond (@{ $show_conditions->{dynamic_conditions} // [] }) {
            my $s = $statistic->{dynamic}->{ $pid // '' }->{ $dyn_cond->{dyn_cond_id} // '' } // {};
            _set_statistic($dyn_cond, $s, [qw/shows clicks ctr/]);
            # DIRECT-58212 PROD: Нули в статистике на странице кампании
            # после объединения на фронтенде кода для ДО и performance-фильтров из-за разницы в именах полей данные по кликам на странице не отображаются
            $dyn_cond->{'ctx_'.$_} = $dyn_cond->{$_} foreach qw/shows clicks ctr/;
        }

        # условия для фильтров для performance групп
        foreach my $filter (@{ $show_conditions->{performance_filters} // [] }) {
            my $s = $statistic->{performance}->{ $pid // '' }->{ $filter->{perf_filter_id} // '' } // {};
            # DIRECT-111375: для смартов отдаём на фронт статистику в полях context_shows/clicks
            $s->{context_shows} = ($s->{context_shows} // 0) + ($s->{shows} // 0);
            $s->{context_clicks} = ($s->{context_clicks} // 0) + ($s->{clicks} // 0);
            _set_statistic($filter, $s, [qw/ctx_shows ctx_clicks ctx_ctr/]);
        }
    }
}

=head2 get_show_conditions_statistic

    для переданных условий показа получает количество показов, кликов из java intapi
=cut

sub get_show_conditions_statistic {
    my ($type, $show_conditions) = @_;
    return {} unless $show_conditions && @$show_conditions;

    my $pid2cid = get_pid2cid(pid => [uniq map { $_->{pid} } grep { $_->{pid} && !$_->{cid} } @$show_conditions]);

    my $items_by_cid = {};
    foreach my $row (@$show_conditions) {
        next unless $row->{pid} && $row->{id};
        my $cid = $row->{cid} || $pid2cid->{ $row->{pid} };
        next unless $cid;
        push @{ $items_by_cid->{ $cid } }, {id => $row->{id}, pid => $row->{pid}, cid => $cid};
    }

    my $statistic = {};
    my @to_process = ();
    my $MAX_PHRASES_COUNT = 1_000;

    # обрабатываем по одной кампании
    for my $cid (keys %$items_by_cid) {
        if (@to_process >= $MAX_PHRASES_COUNT) {
            # обстукиваем yt кусками примерно по N фраз
            my $response = JavaIntapi::GetShowConditionsStatistic->new(
                show_condition_type => $type, items => \@to_process)->call();
            hash_merge($statistic, $response);
            @to_process = ();
        }
        push @to_process, @{ $items_by_cid->{ $cid } };
    }
    if (@to_process) {
        my $response = JavaIntapi::GetShowConditionsStatistic->new(
            show_condition_type => $type, items => \@to_process)->call();
        hash_merge($statistic, $response);
    }

    return $statistic;
}

sub _set_statistic {
    my ($show_condition, $statistic, $fields) = @_;

    my $el = {};
    $el->{shows} = $statistic->{shows} || 0;
    $el->{clicks} = $statistic->{clicks} || 0;
    $el->{ctr} = sprintf("%.2f", ($el->{shows} > 0.001) ? (100 * $el->{clicks} / $el->{shows}) : 0);

    $el->{ctx_shows} = $statistic->{context_shows} || 0;
    $el->{ctx_clicks} = $statistic->{context_clicks} || 0;
    $el->{ctx_ctr} = sprintf("%.2f", ($el->{ctx_shows} > 0.001) ? (100 * $el->{ctx_clicks} / $el->{ctx_shows}) : 0);

    $show_condition->{$_} = $el->{$_} for @$fields;
}


1;
