package BalanceWrapper;

=head1 NAME
    
BalanceWrapper

=head1 DESCRIPTION

Обертка над функциями Yandex::Balance с добавлением Директовской специфики

=cut

use Direct::Modern;

use Yandex::Balance ();
use Yandex::HashUtils;

use Currencies ();

=head1 SUBROUTINES

=head2 get_firm_country_currency($client_id, %options)

    Обертка над Yandex::Balance::balance_get_firm_country_currency.
    Исключает из балансового результата все данные с валютами, не описанными в %Currencies::_CURRENCY_DESCRIPTION.

=cut

sub get_firm_country_currency {
    my $balance_result = Yandex::Balance::balance_get_firm_country_currency(@_);
    my @result;

    for my $row (@$balance_result) {
        next if !exists $Currencies::_CURRENCY_DESCRIPTION{ $row->{currency} };

        push @result, $row;
    }
    return \@result;
}

=head2 get_firm_country_currency_for_new_clients()

    Версия get_firm_country_currency, возврающая данные, которые мы хотим использовать для новых клиентов.
    От get_firm_country_currency отличается применением check_contry_currency_restrictions

=cut

sub get_firm_country_currency_for_new_clients {
    my ($client_id, %O) = @_;
    my $original = get_firm_country_currency($client_id, \%O);
    my $check_restrictions_params = hash_cut(\%O, qw/uid AgencyID/);
    return [ grep { Currencies::check_contry_currency_restrictions($_, $check_restrictions_params) } @$original ];
}

1;
