package BannerStorage::Dict;

=head1 DESCRIPTION

Достает из БД словарь макетов, шаблонов и тем для смарт-баннеров.

=cut

use Settings;
use Direct::Modern;
use JSON;
use Cache::SizeAwareMemoryCache;

use Yandex::DBTools;


my $CACHE = Cache::SizeAwareMemoryCache->new({namespace => 'BannerStorage::Dict', default_expires_in => 600});


=head2 get_dict($name)

Отдаёт кешированную версию словаря BS в виде { $id => $value }

=cut

sub get_dict {
    my $name = shift;

    my $result = $CACHE->get($name);
    return $result  if $result;

    my $dicts_json = get_all_sql(PPCDICT, [
            "SELECT id, json_content FROM banner_storage_dict",
            where => { type => $name },
        ]);
    croak "invalid dict name '$name'"  if !@$dicts_json;

    my %result = map {($_->{id} => from_json($_->{json_content}))} @$dicts_json;
    $CACHE->set($name => \%result);
    return \%result;
}

1;
