package CGIParams;

=head1 NAME

  CGIParams - сохранение данных в веденных формах при потере авторизации

  $Id$

=cut

use strict;
use warnings;

use base qw/Exporter/;
our @EXPORT = qw/
    save_cgi_params
    load_cgi_params
/;

use POSIX qw/strftime/;
use JSON;

use Yandex::Compress;

use Settings;
use HashingTools;
use HttpTools;
use DirectRedis;

our $param_name = 'cgi_form_id';
our $MAX_FORM_COMPRESSED_LENGTH //= 1024 * 1024;
our $KEY_PREFIX //= 'cgi_params_store.';
our $EXPIRE //= 3600;

#======================================================================

=head2 save_cgi_params

    сохраняем переданную форму в таблицу monitor.cgi_params_store, возвращаем id записи, или undef если формы не было

=cut

sub save_cgi_params
{
    my %params = @_;
    my $additional_key = $params{additional_key} || '';
    my $method = $params{method} || 'POST';

    my %form = parse_form();
    return undef unless %form;
    return undef unless $form{cmd};
    return undef if $form{cmd} =~ /^ajax/;

    my $save_time = strftime("%Y%m%d%H%M%S", localtime);
    my $data = {form => \%form, method => $method, save_time => $save_time};
    my $compressed_data = mysql_compress(to_json($data, {utf8 => 1}));
    die "save_cgi_params: FORM too long (> $MAX_FORM_COMPRESSED_LENGTH)" if length($compressed_data) > $MAX_FORM_COMPRESSED_LENGTH;

    my $cmd = $form{cmd} || '';
    my $id = url_hash($$ . $cmd . $method . $compressed_data);
    my $key = "$save_time$id";

    DirectRedis::get_cache_redis()->setex($KEY_PREFIX . $key, $EXPIRE, $compressed_data);

    return $key;
}

#======================================================================

=head2 load_cgi_params

    возвращаем сохраненную форму из таблицы monitor.cgi_params_store
    форма должна быть сохранена не более 1 часа назад

=cut

sub load_cgi_params($)
{
    my $key = shift;

    my $compressed = DirectRedis::get_cache_redis()->get($KEY_PREFIX . $key);

    return (undef, undef) unless $compressed;
    DirectRedis::get_cache_redis()->del($KEY_PREFIX . $key);

    my $data = from_json(mysql_uncompress($compressed), {utf8 => 1});

    return ($data->{form}, $data->{method});
}

1;

