package CSRFCheck;

# $Id$

=head1 NAME

CSRFCheck

=head1 DESCRIPTION

    Функции для работы с csrf-токенами: генерация, проверка


=cut

use warnings;
use strict;

use base qw/Exporter/;
our @EXPORT = qw/
    get_csrf_token
    check_csrf_token
/;

use HashingTools;

use utf8;

 
=head2 $CSRF_CHECK_ENABLE

    Если установить эту переменную в истинное значение -- проверка csrf-токенов отключается, 
    check_csrf_token всегда возвращает успех

=cut
our $CSRF_CHECK_DISABLE;

# время валидности CSRF токена (секунды)
our $CSRF_TOKEN_LIFETIME ||= 24 * 60 * 60;


=head2 get_csrf_token

    generate token for check CSRF
    my $csrf_token = get_csrf_token($UID);

    Можно вторым параметром передать время, на которое генерируется токен(иначе будет использоваться time)

=cut
sub get_csrf_token
{
    my $UID = shift;
    my $TIME = shift // time();

    my $sign = url_hash_utf8(join ":", $TIME, $UID, $Settings::SECRET_PHRASE);
    return encode_64ya(pack("NNN", $TIME ^ $sign, $sign >> 32, $sign & (2 ** 32 - 1)));
}


=head2 check_csrf_token

    check CSRF token
    my $csrf_token_is_valid = check_csrf_token($csrf_token, $UID);

=cut
sub check_csrf_token
{
    my ($csrf_token, $UID) = @_;

    return 1 if $CSRF_CHECK_DISABLE;

    return 0 unless $csrf_token;

    my ($time_signed, $sign_high, $sign_low) = unpack("NNN", decode_64ya($csrf_token));
    my $sign = $sign_high << 32 | $sign_low;
    my $time_from_token = $time_signed ^ $sign_low;
    my $check_sign = url_hash_utf8(join ":", $time_from_token, $UID, $Settings::SECRET_PHRASE);

    if (time() - $time_from_token < $CSRF_TOKEN_LIFETIME && $check_sign eq $sign) {
        return 1;
    } else {
        return 0;
    }
}

1;
