package Campaign;

# $Id$

=head1 NAME

    Campaign

=head1 DESCRIPTION

    Работа с сущностью "кампания"
    идентификатор -- cid, таблицы -- campaigns, camp_options

    Кандидаты на переезд сюда:
        favorite_camp

Другие функции про кампанию, которые не совсем сюда, но куда-то из Common'а надо (в модули-контроллеры вроде EditCamp?)
    validate_camp
    get_user_camp
    get_user_camps
    get_user_camps_by_sql
    get_user_camps_for_yamoney
    get_agency_camps
    get_user_camps_name_only
    order_camp
    validate_pay_camp
    arc_camp
    unarc_camp
    camps_add_rbac_actions
    get_camp_banners_status
    check_mcb_geo_min_shows
    get_campaigns_with_context_limit
    update_camp_auto_optimization

=cut

use Direct::Modern;

use List::Util qw/min max sum pairs first/;
use List::MoreUtils qw/uniq any none part all/;
use Params::Validate qw/validate_with/;
use JSON;
use Carp;

use Yandex::I18n;
use Yandex::HashUtils;
use Yandex::MirrorsTools::Hostings qw/strip_www/;
use Yandex::URL qw/get_num_level_domain/;
use Yandex::Balance;
use Yandex::TimeCommon;
use Yandex::Validate;
use Yandex::SendMail qw/send_alert/;
use Yandex::ListUtils qw/chunks xisect xdiff xminus/;
use Yandex::ScalarUtils;
use Yandex::Overshard;
use Yandex::DateTime;
use Yandex::Clone qw/yclone/;
use Encode qw/decode/;

use AutobudgetAlerts;
use Settings;
use Yandex::DBTools;
use Yandex::DBShards;
use Experiments qw/stop_experiment_on_delete_campaign/;
use TextTools;
use LogTools;
use Tools;
use MailNotification;
use Primitives;
use PrimitivesIds;
use TimeTarget;
use Currencies qw/get_currency_constant get_min_price campaign_remove_nds_and_add_bonus currency_price_rounding/;
use Currency::Format;
use Rbac qw/:const get_perminfo has_role/;
use RBACElementary;
use RBACDirect;
use Client;
use User;
use OrgDetails;
use MTools;
use MinusWords;
use MinusWordsTools;
use BannersCommon;
use Tag;
use Stat::OrderStatDay;
use LockObject;
use Notification;
use DeviceTargeting qw/can_save_camp_device_targeting/;
use PhrasePrice;
use VCards;
use Geo qw/explain_common_geo get_common_geo_for_camp get_merged_geo_str geo_changes_to_string/;
use BalanceQueue;
use BS::CheckUrlAvailability ();
use BS::Export::Queues;
use BS::ResyncQueue;
use WalletUtils;
use HierarchicalMultipliers qw/delete_camp_hierarchical_multipliers/;
use JavaIntapi::GetBidModifiers;
use Campaign::Types;
use MetrikaIntapi;
use MetrikaCounters;
use PlacePrice;
use EnvTools qw/is_beta/;
use Yandex::Audience;
use Yandex::Trace;

use Models::AdGroup;
use Models::AdGroupFilters;
use Models::Banner;
use Models::CampaignOperations;

use CampaignTools;
use Stat::Tools qw//;
use Stat::OrderStatDay;

use Direct::Strategy qw//;
use Direct::Strategy::Tools qw/ strategy_from_strategy_app_hash strategy_from_campaign_hash strategy_from_strategy_hash /;
use Direct::Validation::Strategy;
use Direct::Campaigns;
use Direct::Campaigns::Text;
use Direct::Campaigns::MobileContent;
use Direct::Campaigns::Dynamic;
use Direct::Campaigns::Performance;
use Direct::Campaigns::Mcbanner;
use Direct::Campaigns::CpmBanner;
use Direct::Campaigns::CpmDeals;
use Direct::Campaigns::CpmYndxFrontpage;
use Direct::Campaigns::Media;
use Direct::Campaigns::InternalDistrib;
use Direct::Campaigns::InternalFree;
use Direct::Campaigns::ContentPromotion;
use Direct::Campaigns::CpmPrice;
use Direct::Model::Campaign;
use Direct::Model::BidRelevanceMatch::Helper qw//;

use Direct::AbSegmentConditions;
use Direct::Model::AbSegmentCondition;

use JavaIntapi::UpdateBidModifiers;
use base qw/Exporter/;
our @EXPORT = qw/
  save_camp
  get_camp_info
  is_campaign_archived
  are_campaigns_archived
  is_campaign_heavy
  camp_delayed_arc
  get_default_timezone
  get_camp_min_rest
  get_camp_sum_available
  create_campaigns_balance
  check_method_pay
  is_camp_deletable_by_hash
  mass_is_camp_deletable_by_hash
  is_camp_deletable
  del_camp
  del_camp_data
  queue_camp_operation
  get_mcb_camp_min_shows
  validate_pay_camp
  convert_dates_for_template
  convert_dates_for_db
  is_campaign_finished
  separate_day_budget
  camp_save_metrika_counters
  has_broad_match_flag
  have_banners_stopped_by_metrica
  campaign_manager_changed
  campaign_strategy_changed
  init_edit_campaign_tags_form
  camp_has_banners
  mass_camps_has_banners
  can_create_camp
  create_empty_camp
  get_camp_status_info
  CalcCampStatus
  CheckCreateCamp
  campaign_strategy
  mass_campaign_strategy
  campaign_strategy_to_strategy_name
  count_campaign_items
  take_strategy_notify
  send_camp_to_service
  process_FA_request_on_set_servicing
  change_status_moderate_pay
  restore_manual_prices
  get_total_banners_count
  stop_camp
  resume_camp
  validate_camp_mobile_content
  mass_get_servicing
  mass_get_source_ids_by_cid
  is_cpm_campaign
  is_internal_campaign
  is_internal_distrib_camp
  is_internal_free_camp
  save_ab_segment_retargeting_cond
  save_ab_segment_sections_stat_retargeting_cond
  is_campaign_strategy_use_meaningful_goals_optimization
  save_brand_safety_ret_cond
  update_campaign_statuses_is_obsolete
  mass_is_universal_campaign
  is_strategy_change_ignore_platform
  get_strategies
  get_campaigns_type_by_strategy_id
/;

our @EXPORT_OK = qw/
    is_autobudget
    validate_camp_strategy
    prevalidate_cpm_strategy
/;


=head2 $HEAVY_CAMP_BIDS_BORDER

    Количество фраз в кампании, после которого считаем кампанию "тяжёлой"

=cut
our $HEAVY_CAMP_BIDS_BORDER = 1_000;


our $BRAND_LIFT_EXPERIMENT_THRESHOLD = 90;
our $BRAND_LIFT_SURVEYS_LOGIN = "yndx-robot-pythia-brndlft";


=head2 %TLD_DEFAULT_TIMEZONE

    таймзоны по умолчанию для доменов

=cut

our %TLD_DEFAULT_TIMEZONE = (
    '' => {     # for unknown domains
            group_nick  => 'russia',
            timezone    => 'Europe/Moscow',
        },
    ru  => {
            group_nick  => 'russia',
            timezone    => 'Europe/Moscow',
        },
    ua  => {
            group_nick  => 'cis',
            timezone    => 'Europe/Kiev',
        },
);

=head2 @STRATEGY_FILEDS

    поля в campaigns которые относятся к стратегиям

=cut

our @STRATEGY_FILEDS = qw/
    strategy_name
    strategy_data
    autobudget
    autobudgetForecast
    autobudgetForecastDate
    autobudget_date
    campaign_goals
    count_all_goals
    manual_autobudget_sum
    statusAutobudgetForecast
    search_strategy
    strategy
    day_budget
    day_budget_show_mode
/;

=head2 @MANUAL_PRICE_STRATEGIES

    Список самостоятельных стратегий (т.е. с ручным управлением ставками).
    Названия соответствуют возвращаемым функцией Primitives::detect_strategy.

=cut

our @MANUAL_PRICE_STRATEGIES = qw/
    default
    no_premium
    strategy_no_premium
    different_places
    cpm_default
/;

=head2 @MANUAL_PRICE_STRATEGIES

    Список доступных моделей атрибуции

=cut

our @ATTRIBUTION_MODELS = qw/
    last_click
    first_click
    last_significant_click
    last_yandex_direct_click
    first_click_cross_device
    last_significant_click_cross_device
    last_yandex_direct_click_cross_device
/;

# страгегии показа
our %STRATEGY_NAME = (
    default => iget_noop('Наивысшая доступная позиция'),
    maximum_coverage => iget_noop('Максимально доступный охват'),
    no_premium => {
        name => iget_noop('Показ под результатами поиска'),
        highest_place => iget_noop('Показ под результатами поиска на наивысшей доступной позиции'),
    },
    autobudget => iget_noop('Недельный бюджет'),
    autobudget_avg_click => iget_noop('Средняя цена клика (за неделю)'),
    autobudget_avg_cpa => iget_noop('Средняя цена конверсии (за неделю)'),
    autobudget_avg_cpi => iget_noop('Средняя цена установки'),
    autobudget_week_bundle => iget_noop('Недельный пакет кликов'),
    autobudget_crr => iget_noop('Доля рекламных расходов'),
    autobudget_roi => iget_noop('Рентабельность рекламы'),
    strategy_no_premium_highest => iget_noop('Показ под результатами поиска'),
    different_places => iget_noop('Независимое управление для разных типов площадок'),
    stop => iget_noop('Показы отключены'),
    Direct::Strategy::Tools::strategy_names_human(),
);


# исходная структура стратегии 'Наивысшая доступная позиция'
use constant STRATEGY_DEFAULT => {
    name => '',
    is_search_stop => 0,
    search => {name => 'default'},
    is_net_stop => 0,
    net => {name => 'default'}
};

use constant ORDER_ID_OFFSET => 100_000_000;

=head2

    Значения по умолчанию для атрибутов для стратегии ROI:
        autobudget_reserve_return - Процент возврата в рекламу от сэкономленного бюджета
        autobudget_profitability  - Процент доходов, являющихся себестоимостью товаров или услуг

    Используется при экспорте в БК


=cut

our $AUTOBUDGET_RESERVE_RETURN_DEFAULT = 100;
our $AUTOBUDGET_PROFITABILITY_DEFAULT = 0;

=head2 @EMAIL_NOTIFICATIONS

    Список возможных значений поля email_notifications в таблице camp_options.

=cut

our @EMAIL_NOTIFICATIONS = qw/
    paused_by_day_budget
    feed_status_change
/;

=head2 BROAD_MATCH_* параметры

    Параметры, относящиеся к показам по дополнительным релевантным фразам

    BROAD_MATCH_DEFAULT      => процент расхода от общего расхода кампании

=cut

our $BROAD_MATCH_DEFAULT //= 40;
our $BROAD_MATCH_LIMIT_MIN //= 1;
our $BROAD_MATCH_LIMIT_MAX //= 100;

our @CAMPAIGN_CONTENT_LANGS = qw/ua kz tr en de ru be uz/;

=head2 $DAILY_BUDGET_STOP_STATS_DAYS

    Количество дней включая текущий, за которые нужно показывать статистику остановок по дневному бюджету
    Используется в get_day_budget_stop_history

=cut
our $DAILY_BUDGET_STOP_STATS_DAYS = 14;

=head2 IMPRESSION_STANDARD_TIME_*

    Cтандарты определения видимости и оптимизации показов%
    YANDEX - 2 сек
    MRC    - 1 сек

=cut
our $IMPRESSION_STANDARD_TIME_YANDEX //= 2000;
our $IMPRESSION_STANDARD_TIME_MRC //= 1000;

=head2 ESHOWS_BANNER_RATE_*

    Коэффициент включения eshows для баннеров

=cut
our $ESHOWS_BANNER_RATE_ON //= 1.0;
our $ESHOWS_BANNER_RATE_OFF //= 0.0;

=head2 ESHOWS_VIDEO_RATE_*

    Коэффициент включения eshows для видео

=cut
our $ESHOWS_VIDEO_RATE_ON //= 1.0;
our $ESHOWS_VIDEO_RATE_OFF //= 0.0;

=head2 ESHOWS_VIDEO_RATE_*

    Тип оптимизации для видео:
    LONG_CLICKS - длинные клики
    COMPLETES - досмотры

=cut
our $ESHOWS_VIDEO_TYPE_LONG_CLICKS //= 'long_clicks';
our $ESHOWS_VIDEO_TYPE_COMPLETES //= 'completes';

=head2 get_broad_match_default
    Возвращает дефолтное значение ограничения расхода бюджета по автоматически добавленным фразам

=cut

sub get_broad_match_default {
    return $BROAD_MATCH_DEFAULT;
}

=head2 get_default_timezone

    Возвращает параметры таймзоны для хоста по умолчанию
    Для неизвестных доменов - таймзону по умолчанию (Москву).

    my %tz = get_default_timezone( 'yandex.ru' );

=cut

sub get_default_timezone {
    my ( $host ) = @_;

    my $tld = get_num_level_domain( $host, 1 );
    return %{ $TLD_DEFAULT_TIMEZONE{ $tld } || $TLD_DEFAULT_TIMEZONE{''} };
}

=head2 default_values_for_new_camp

    default_values_for_new_camp($c, %O);
    %O = (
        media_type =>
        r =>
        domain =>
        client_currencies => get_client_currencies(...) # валюты клиента, которому будет создаваться кампания
    );

=cut

sub default_values_for_new_camp
{
    my ($c, %O) = @_;

    my $camp = {};

    $camp->{mediaType} = $O{media_type} || 'text';

    $camp->{name} = iget("Новая");

    $camp->{start_time} = unix2mysql( ts_round_day(time) );
    $camp->{finish_time} = '0000-00-00' if camp_kind_in(type => $camp->{mediaType}, "web_edit_base");
    convert_dates_for_template($camp, keep_source_data => 1, with_old_start_date_format => 1);

    # растягиваем показы медийным автобюджетом на 28 дней. фактически, дата окончания для медийных кампаний.
    # нужно только для Баяна, хорошо бы убрать под соответствующее условие. но вначале надо убрать под такое же условие использования этого поля в серверном коде и шаблонах.
    $camp->{autobudget_date} = unix2human(time + 60*60*24 * 28, '%Y-%m-%d');

    $camp->{multipliers_meta} = Direct::Validation::HierarchicalMultipliers::get_metadata($camp->{mediaType});

    # TODO хорошо бы в cmd_editCamp сначала получать свойства пользователя, и сюда передавать их готовые.
    # Аккуратно распутать узел: в свойствах пользователя нужен тип кампании (чтобы выбирать Директовых/Баяновых менеджеров),
    # тип кампании известен только после получения свойств кампании,
    # а при получении свойств кампании в случае новой кампании (default_values_for_new_camp) нужны данные о пользователе
    my $user = get_user_data($c->uid, [qw/email fio/]);
    my $is_just_client = $c->login_rights->{is_any_client} || $c->login_rights->{client_role} eq 'empty';
    $user->{fio}   = $O{r}->pnotes('user_fio')   if $is_just_client && ! defined $user->{fio} && defined $O{r};
    $user->{email} = $O{r}->pnotes('user_email') if $is_just_client && ! defined $user->{email} && defined $O{r};

    my $currency;
    if (camp_kind_in(type => $camp->{mediaType}, "web_edit_base")) {
        die 'no client_currencies given' unless $O{client_currencies};
        $currency = $O{client_currencies}->{work_currency};
    } else {
        # баян и геоконтекст продолжают работать в у.е.
        $currency = 'YND_FIXED';
    }

    $camp->{email} = $user->{email} || '';
    $camp->{fio} = $user->{fio} || '';
    $camp->{currency} = $currency;
    $camp->{sendWarn} = 0;
    $camp->{sendAccNews} = 1;
    $camp->{warnPlaceInterval} = $Settings::DEF_WARN_PLACE_INTERVAL;
    $camp->{money_warning_value} = $Settings::DEFAULT_MONEY_WARNING_VALUE;

    $camp->{geo} = '';
    $camp->{camp_with_common_geo} = 0;

    $camp->{offlineStatNotice} = 1;
    $camp->{email_notifications} = {
        paused_by_day_budget => 1,
        feed_status_change => 1,
    };

    if (is_cpm_campaign($camp->{mediaType}) || is_internal_campaign($camp->{mediaType})) {
        $camp->{rf} = 0;
        $camp->{rfReset} = undef;
    } else {
        $camp->{rf} = $Settings::DEFAULT_RF;
        $camp->{rfReset} = $Settings::DEFAULT_RF_RESET;
    }

    $camp->{autoOptimization} = 1;
    $camp->{ContextLimit} = camp_kind_in(type => $camp->{mediaType}, 'context_limited') ? 254 : 0;
    $camp->{broad_match_limit} = get_broad_match_default();

    $camp->{platform} = Direct::Model::Campaign->default_platform($camp->{mediaType});

    # получаем умолчальный часовой пояс для домена
    $camp->{timetargeting} = TimeTarget::get_timezone_form_params( get_default_timezone( $O{r}->hostname ) );
    $camp->{timetargeting}->{time_target_working_holiday} = 1;


    $camp->{day_budget} = 0;
    $camp->{day_budget_show_mode} = 'default';
    $camp->{day_budget_daily_change_count} = 0;
    $camp->{day_budget_stop_time} = undef;

    $camp->{broad_match_flag} = 1;
    if (Tools::is_turkish_domain($O{domain})) {
        $camp->{broad_match_flag} = 0;
        $camp->{timetargeting}->{time_target_working_holiday} = 0;
    }

    $camp->{enable_cpc_hold} = 1;

    my $operator_client_id = get_clientid(uid => $c->{UID});
    my $strategy = get_default_strategy_by_mediaType(
        $camp->{mediaType},
        is_default_avg_cpa_feature_enabled => Client::ClientFeatures::has_default_avg_cpa_feature($operator_client_id),
        is_default_autobudget_avg_click_with_week_budget_enabled => Client::ClientFeatures::has_default_autobudget_avg_click_with_week_budget_feature($operator_client_id),
        is_default_autobudet_roi_feature_enabled => Client::ClientFeatures::has_default_autobudget_roi_feature($operator_client_id),
        %O
    );
    $camp->{strategy} = $strategy;
    $camp->{strategy_decoded} = $camp->{mediaType} eq 'performance' || $strategy->{is_search_stop} ? $strategy->{net} : $strategy->{search};

    # Разметка ссылок для метрики включена по умолчанию
    $camp->{status_click_track} = 1;

    my $client_data = get_client_data($c->client_client_id, [qw/common_metrika_counters/]);

    # Счетчик метрики по умолчанию для новых кампаний
    # для performance кампаний будет первый из списка
    my @common_metrika_counters = split(/\s*,\s*/, $client_data->{common_metrika_counters} // '');
    if ($camp->{mediaType} eq 'performance') {
        $camp->{metrika_counters} = $common_metrika_counters[0] // '';
    } elsif ($camp->{mediaType} =~ /^(mcb|mobile_content)$/) {
        $camp->{metrika_counters} = '';
    } else {
        $camp->{metrika_counters} = join(', ', @common_metrika_counters);
    }

    # Модель атрибуции по умолчанию
    $camp->{attribution_model} = get_attribution_model_or_default_by_type($camp);

    return $camp;
}

=head2 get_default_strategy_by_mediaType

    get_default_strategy_by_mediaType($mediaType, %params);

    Возвращает дефолтную стратегию для кампании с указанным mediaType

=cut

sub get_default_strategy_by_mediaType {
    my ($mediaType, %params) = @_;

    $mediaType //= '';

    my $strategy;
    if ($mediaType eq 'performance') {
        $strategy =  {
            is_search_stop => 1,
            search => {name => ''},
            is_net_stop => 0,
            name => 'autobudget_avg_cpc_per_filter',
            net => {name => 'autobudget_avg_cpc_per_filter', filter_avg_bid => undef, bid => undef, sum => undef},
            is_autobudget => 1
        };
        if ($params{is_feature_smart_at_search_enabled}){
            $strategy->{is_search_stop} = 0;
            $strategy->{search} = {%{$strategy->{net}}};
        }
    } elsif ($mediaType eq 'dynamic') {
        if ($params{is_default_autobudget_avg_click_with_week_budget_enabled}) {
            $strategy = {
                is_search_stop => 0,
                search => {name => 'autobudget', bid => undef , sum => undef, goal_id => undef},
                is_net_stop => 1,
                name => 'autobudget',
                net => { name => "stop" },
                is_autobudget => 1
            };
        } elsif ($params{is_default_avg_cpa_feature_enabled}) {
            $strategy = {
                is_search_stop => 0,
                search => {name => 'autobudget_avg_cpa', avg_cpa => undef, sum => undef},
                is_net_stop => 1,
                name => 'autobudget_avg_cpa',
                net => { name => "stop" },
                is_autobudget => 1
            };
        } elsif($params{is_default_autobudet_roi_feature_enabled}) {
            $strategy = {
                is_search_stop => 0,
                search => {name => 'autobudget_roi', bid => undef, roi_coef => undef, reserve_return => 100, sum => undef},
                is_net_stop => 1,
                name => 'autobudget_roi',
                net => { name => "stop" },
                is_autobudget => 1
            };
        } else {
            $strategy =  {
                is_autobudget => 0,
                is_net_stop => 1,
                is_search_stop => 0,
                name => '',
                net => { name => "stop" },
                search => { name => "default"},
            };
        }
    } elsif ($mediaType eq 'mcbanner' || $mediaType eq 'content_promotion') {
        $strategy =  {
            is_search_stop => 0,
            search => {name => 'default'},
            is_net_stop => 1,
            name => '',
            net => {name => 'stop'},
            is_autobudget => 0
        };
    } elsif ($mediaType eq 'cpm_banner') {
        $strategy =  {
            is_search_stop => 1,
            search => {name => 'stop'},
            is_net_stop => 0,
            name => 'different_places',
            net => {name => 'autobudget_max_impressions_custom_period', auto_prolongation => 1},
            is_autobudget => 1
        };
    } elsif ($mediaType eq 'cpm_deals') {
        $strategy =  {
            is_search_stop => 1,
            search => {name => 'stop'},
            is_net_stop => 0,
            name => 'different_places',
            net => {name => 'cpm_default'},
            is_autobudget => 0
        };
    } elsif ($mediaType eq 'cpm_yndx_frontpage') {
        $strategy =  {
            is_search_stop => 1,
            search => {name => 'stop'},
            is_net_stop => 0,
            name => 'different_places',
            net => {name => 'autobudget_max_impressions_custom_period', auto_prolongation => 1},
            is_autobudget => 0
        };
    } elsif ($mediaType eq 'cpm_price') {
        $strategy =  {
            is_search_stop => 1,
            search => {name => 'stop'},
            is_net_stop => 0,
            name => 'different_places',
            net => {name => 'cpm_default'},
            is_autobudget => 0,
        };
    } elsif ($mediaType eq 'text' && $params{is_default_autobudget_avg_click_with_week_budget_enabled}) {
        $strategy = {
            is_search_stop => 0,
            search => {name => 'autobudget', bid => undef , sum => undef, goal_id => undef},
            is_net_stop => 0,
            name => 'autobudget',
            net=> {name => 'autobudget', bid => undef , sum => undef, goal_id => undef},
            is_autobudget => 1
        };
    } elsif ($mediaType eq 'text' && $params{is_default_avg_cpa_feature_enabled}) {
        $strategy = {
            is_search_stop => 0,
            search => {name => 'autobudget_avg_cpa', avg_cpa => undef, sum => undef},
            is_net_stop => 0,
            name => 'autobudget_avg_cpa',
            net=> {name => 'autobudget_avg_cpa', avg_cpa => undef, sum => undef},
            is_autobudget => 1
        };
    } elsif ($mediaType eq 'text' && $params{is_default_autobudet_roi_feature_enabled}) {
        $strategy = {
            is_search_stop => 0,
            search => {name => 'autobudget_roi', bid => undef, roi_coef => undef, reserve_return => 100, sum => undef},
            is_net_stop => 0,
            name => 'autobudget_roi',
            net=> {name => 'autobudget_roi', bid => undef, roi_coef => undef, reserve_return => 100, sum => undef},
            is_autobudget => 1
        };
    } else {
        $strategy = {
            is_search_stop => 0,
            search => {name => 'default'},
            is_net_stop => 0,
            name => 'different_places',
            net=> {name => 'maximum_coverage'},
            is_autobudget => 0
        };
    };

    if ($mediaType eq 'mobile_content') {
        $strategy = {
            is_search_stop => 0,
            search => {name => 'autobudget_avg_click', avg_bid => undef, sum => undef},
            is_net_stop => 0,
            name => 'autobudget_avg_click',
            net => {name => 'autobudget_avg_click', avg_bid => undef, sum => undef},
            is_autobudget => 1
        };
    }
    return $strategy;
}

=head2 _deserialize_camp_fields

    Десереализация json-сериализованных полей при выборке из campaigns

=cut

sub _deserialize_camp_fields {
    my $camp = shift;

    # склеиваем домены и ssp
    if (exists $camp->{DontShow}) {
        # assertion
        croak "Incomplete camp"  if !exists $camp->{disabled_ssp};

        my $ssps = from_json($camp->{disabled_ssp} || '[]');
        my @domains = split /,/ => $camp->{DontShow} || '';
        my $merged = Direct::Validation::Domains::merge_disabled_platforms({ssps => $ssps, rest => \@domains});
        $camp->{DontShow} = join q{,}, grep {$_} @$merged;
    }

    $camp->{disabled_video_placements} = decode(utf8 => $camp->{disabled_video_placements});
    if (exists $camp->{disabled_video_placements}) {
        $camp->{disabled_video_placements} = from_json($camp->{disabled_video_placements} || '[]');
    }

    if (my $strategy_data = delete $camp->{strategy_data}) {
        my $strategy = $camp->{strategy_decoded} = from_json $strategy_data;

        # костыль для фронта: пробрасываем поля в старом формате
        $camp->{autobudget_sum} = $strategy->{sum};
        $camp->{autobudget_bid} = $strategy->{bid};
        $camp->{autobudget_avg_bid} = $strategy->{avg_bid};
        $camp->{autobudget_avg_cpa} = $strategy->{avg_cpi} || $strategy->{avg_cpa};
        $camp->{autobudget_limit_clicks} = $strategy->{limit_clicks};
        $camp->{autobudget_goal_id} = $strategy->{goal_id};

        $camp->{dontShowYacontext} = ($camp->{platform} || 'both') eq 'search' ? 'Yes' : 'No';
        $camp->{is_search_stop} = ($camp->{platform} || 'both') eq 'context' ? 1 : 0;
    }

    if (defined $camp->{placement_types}) {
        $camp->{placement_types} = [split ',', $camp->{placement_types}];
    }

    if (exists $camp->{meaningful_goals}) {
        $camp->{meaningful_goals} = from_json($camp->{meaningful_goals} || '[]');
    }

    if (exists $camp->{allowed_page_ids}) {
        $camp->{allowed_page_ids} = from_json($camp->{allowed_page_ids} || '[]');
    }

    if ($camp->{allowed_frontpage_types}) {
        $camp->{allowed_frontpage_types} = [split ',', $camp->{allowed_frontpage_types}];
    }

    return;
}



=head2 strategy_struct_sample($strategy)

    Возвращает образец структуры данных о стратегии.
    (Исходный набор полей которые должны присутствовать в структуре данных)

=cut

{
my %strategy_fields = (
    no_premium => 'place',
    default => undef,
    maximum_coverage => undef,
    stop => undef,
    autobudget => [qw/sum bid goal_id/],
    autobudget_week_bundle => [qw/limit_clicks bid avg_bid/],
    autobudget_avg_click => [qw/avg_bid sum/],
    autobudget_avg_cpa => [qw/avg_cpa bid sum goal_id/],
    autobudget_crr => [qw/sum goal_id crr/],
    autobudget_roi => [qw/sum bid goal_id roi_coef reserve_return profitability/],
    Direct::Strategy::Tools::strategy_params_lists(),
);

sub strategy_struct_sample {
    my $strategy = shift;

    my $sample = {
        name => 1,
        is_net_stop => undef,
        is_search_stop => undef,
        search => {},
        net => {},
    };
    return $sample unless ref $strategy eq 'HASH';
    foreach my $kind (qw/search net/) {
        next unless exists $strategy->{$kind}
            && $strategy->{$kind}->{name} && exists $strategy_fields{$strategy->{$kind}->{name}};

        my $fields = $strategy_fields{$strategy->{$kind}->{name}};
        $sample->{$kind}->{$_} = 1 foreach 'name', defined $fields ? (ref $fields ? @$fields : ($fields)) : ();
    }

    return $sample;
}
}


=head2 get_canonical_strategy

Заполняем недостающие поля хеша стратегий

=cut

# TODO: unit-test
sub get_canonical_strategy {
    my $strategy = yclone(shift);

    $strategy->{net}->{name} //= !$strategy->{is_net_stop} ? 'default' : 'stop';
    $strategy->{is_net_stop} = 0 + ($strategy->{net}->{name} eq 'stop');

    $strategy->{search}->{name} //= !$strategy->{is_search_stop} ? 'default' : 'stop';
    $strategy->{is_search_stop} = 0 + ($strategy->{search}->{name} eq 'stop');

    my @strategy_names = uniq grep {$_ ne 'default' && $_ ne 'stop'} ($strategy->{search}->{name}, $strategy->{net}->{name});

    # fix broken name
    if ($strategy->{name} ne 'different_places') {
        $strategy->{name} =
            @strategy_names > 1     ? 'different_places' :
            @strategy_names == 1    ? $strategy_names[0] :
                                      $strategy->{name} || '';
    }

    return $strategy;
}


sub _get_campaigns_class {
    my ($type) = @_;

    state $class_by_type = {
        text               => 'Direct::Campaigns::Text',
        mobile_content     => 'Direct::Campaigns::MobileContent',
        dynamic            => 'Direct::Campaigns::Dynamic',
        performance        => 'Direct::Campaigns::Performance',
        mcb                => 'Direct::Campaigns::Media',
        wallet             => 'Direct::Campaigns',
        geo                => 'Direct::Campaigns',
        mcbanner           => 'Direct::Campaigns::Mcbanner',
        cpm_banner         => 'Direct::Campaigns::CpmBanner',
        cpm_deals          => 'Direct::Campaigns::CpmDeals',
        cpm_yndx_frontpage => 'Direct::Campaigns::CpmYndxFrontpage',
        internal_distrib   => 'Direct::Campaigns::InternalDistrib',
        internal_free      => 'Direct::Campaigns::InternalFree',
        content_promotion  => 'Direct::Campaigns::ContentPromotion',
        cpm_price          => 'Direct::Campaigns::CpmPrice',
    };

    my $class = $class_by_type->{$type};
    croak "Unknown type <$type>"  if !$class;
    return $class;
}


sub _query_campaign {
    my ($type, $cid) = @_;

    my $class = _get_campaigns_class($type);
    my $campaigns = $class->get($cid);
    return $campaigns;
}


sub _get_quasi_campaign {
    my ($camp) = @_;

    my $type = $camp->{type} || $camp->{mediaType} || get_camp_type(cid => $camp->{cid});
    my $class = Direct::Campaigns->get_model_class_by_type($type, skip_unknown => 1);

    # hack for api data
    my $strategy_name = $camp->{strategy};
    $strategy_name = ''  if !$strategy_name || $strategy_name eq 'cpa_optimizer' || ($type ne 'performance' && $strategy_name ne 'different_places');

    my %camp_params = (
        campaign_type => $type,
        currency => $camp->{currency},
        _strategy_name => $strategy_name,
        platform => $camp->{platform} || Direct::Model::Campaign->default_platform($type),
    );

    my $qcamp = $class->new(%camp_params);
    return $qcamp;
}

=head2 mark_placement_types_change($cid, $UID, $uid, $new_placement_types, $old_placement_types)

    Если значение изменилось, делает запись об изменении включенных видов размещения в лог (ppclog_cmd)

=cut

sub mark_placement_types_change {
    my ($cid, $UID, $uid, $new_placement_types, $old_placement_types) = @_;

    return if defined $old_placement_types && !@{ xdiff($new_placement_types, $old_placement_types) };

    log_cmd({
        cmd => '_save_placement_types',
        cid => $cid,
        UID => $UID // 1,
        uid => $uid,
        old_placement_types => [map { uc $_ } @$old_placement_types],
        new_placement_types => [map { uc $_ } @$new_placement_types]
    });
}


=head2 validate_camp_strategy($camp, $new_strategy, $options)

    Валидация стратегии на кампанию
    $camp - хеш кампании
    $new_strategy - проверяемая стратегия
    $options
        login_rights - права текущего пользователя
        is_api - использовать апишные тексты ошибок
        defect_description_field_map - ссылка на хэш с данными по полем для подстановки в детализацию ошибок
        new_camp - признак создания новой кампании
        request_meaningful_goals - провалидированные ключевые цели из запроса
        has_edit_avg_cpm_without_restart_enabled - возможность редактирования параметров стратегии без рестарта
        has_cpa_pay_for_conversions_extended_mode_allowed - расширенные возможности валидации в оплате конверсий
        has_cpa_pay_for_conversions_mobile_apps_allowed - возможность использования оплаты за конверсии для РМП
        has_mobile_app_goals_for_text_campaign_allowed - возможность указывать для ТГО-кампании специальные цели для РМП (не используется)
        has_mobile_app_goals_for_text_campaign_strategy_enabled - фича для использования целей РМП в стратегиях ТГО-кампаний
        has_disable_all_goals_optimization_for_dna_enabled - запрет использовать оптимизацию по всем целям
        has_increased_cpa_limit_for_pay_for_conversion - утроение максимальной цены конверсий
        has_disable_autobudget_week_bundle_feature - отключение стратегии `Пакет кликов`
        has_all_meaningful_goals_for_pay_for_conversion_strategies_allowed - разрешает выбор оптимизации "по нескольким целям" при выборе оплаты за конверсии для дрр
        has_flat_cpc_disabled - отключение стратегии совместного управления ставками
        has_flat_cpc_adding_disabled - отключение добавления стратегии совместного управления ставками
=cut

sub validate_camp_strategy {
    my ($camp, $new_strategy, $options) = @_;

    $options ||= {};
    my $old_strategy = $camp->{strategy};
    my $actual_meaningful_goals = $options->{request_meaningful_goals};

    #В ручных стратегиях с раздельным управлением ставками поле name выставляется different_places
    my $is_flat_cpc = !$new_strategy->{is_net_stop} && !$new_strategy->{is_search_stop} && $new_strategy->{name} eq 'default';

    return iget('Настройка стратегии "Показывать на поиске только под результатами" больше не поддерживается')
        if defined $new_strategy->{search}->{name} && $new_strategy->{search}->{name} eq 'no_premium';
    # pre-validation
    my $is_media_camp = is_media_camp(type => $camp->{type});
    if ($is_media_camp) {
        return iget('Стратегия не указана')  if $new_strategy->{search}->{name} !~ /^(default|autobudget)$/;
    }
    else {
        return iget('Стратегии не совместимы')
            if ($new_strategy->{net}{name} =~ /autobudget/ && $new_strategy->{search}{name} ne 'stop') && $camp->{type} ne 'performance' ||
                ($new_strategy->{net}{name} !~ /^(default|stop)$/ && $new_strategy->{search}{name} =~ /autobudget/) ||
                ($new_strategy->{net}{name} eq 'default' && $new_strategy->{search}{name} eq 'stop') ||
                ($new_strategy->{net}{name} eq 'stop' && $new_strategy->{search}{name} eq 'stop');
    }

    my $strategy_object = strategy_from_strategy_app_hash($new_strategy, skip_unknown => 1);
    return iget('Стратегия не определена')  if !$strategy_object;

    my $campaign;
    if ($camp->{cid}) {
        my $campaigns = _query_campaign($camp->{type} => $camp->{cid});
        $campaign = $campaigns->items->[0];
        $actual_meaningful_goals //= $campaign->meaningful_goals;
    }
    else {
        $campaign = _get_quasi_campaign($camp);
        if ($options->{is_api} && $options->{new_camp} && $options->{client_id} && !$campaign->has_client_id) {
            $campaign->client_id($options->{client_id});
        }
    }

    if ($camp->{type} eq 'performance') {
        $campaign->metrika_counters(get_num_array_by_str($camp->{metrika_counters}));
    }

    $campaign->start_date($camp->{start_date}) if $camp->{start_date};
    $campaign->finish_date($camp->{finish_date}) if $camp->{finish_date};

    $campaign->platform($campaign->detect_platform(
            is_search_stop => $new_strategy->{is_search_stop},
            is_net_stop => $new_strategy->{is_net_stop},
        ));

    $campaign->{strategy} = strategy_from_strategy_app_hash($old_strategy, skip_unknown => 1);

    if ($camp->{type} eq 'cpm_yndx_frontpage' || $camp->{type} eq 'cpm_price') {
        prepare_cpm_yndx_frontpage_params($campaign, $camp->{geo}, $camp->{allowed_frontpage_types}, $camp->{ClientID});
    }

    my $vr = validate_strategy_for_campaign($strategy_object, $campaign,
        new_camp                                     => $options->{new_camp},
        is_flat_cpc                          => $is_flat_cpc,
        meaningful_goals                             => $actual_meaningful_goals // [],
        prefetched_goals                             => $options->{prefetched_goals},
        has_cpa_pay_for_conversions_extended_mode_allowed => $options->{has_cpa_pay_for_conversions_extended_mode_allowed},
        has_cpa_pay_for_conversions_mobile_apps_allowed => $options->{has_cpa_pay_for_conversions_mobile_apps_allowed},
        has_edit_avg_cpm_without_restart_enabled          => $options->{has_edit_avg_cpm_without_restart_enabled},
        has_mobile_app_goals_for_text_campaign_allowed    => $options->{has_mobile_app_goals_for_text_campaign_allowed},
        has_mobile_app_goals_for_text_campaign_strategy_enabled => $options->{has_mobile_app_goals_for_text_campaign_strategy_enabled},
        has_disable_all_goals_optimization_for_dna_enabled  => $options->{has_disable_all_goals_optimization_for_dna_enabled},
        has_increased_cpa_limit_for_pay_for_conversion  => $options->{has_increased_cpa_limit_for_pay_for_conversion},
        has_disable_autobudget_week_bundle_feature  => $options->{has_disable_autobudget_week_bundle_feature},
        has_all_meaningful_goals_for_pay_for_conversion_strategies_allowed  => $options->{has_all_meaningful_goals_for_pay_for_conversion_strategies_allowed},
        has_flat_cpc_disabled => $options->{has_flat_cpc_disabled},
        has_flat_cpc_adding_disabled => $options->{has_flat_cpc_adding_disabled},
    );

    if (!$vr->is_valid) {
        $vr->process_descriptions(%{$options->{defect_description_field_map}}) if $options->{defect_description_field_map};
        return $vr->get_errors()->[0]->description;
    }

    # check rights for some actions
    my $login_rights = $options->{login_rights} || {};
    if (camp_kind_in(type => $camp->{type}, 'context_limited')) {
        if(
            (
                ($new_strategy->{is_net_stop} || 0) != ($old_strategy->{is_net_stop} || 0)
                || ($new_strategy->{is_search_stop} || 0) != ($old_strategy->{is_search_stop} || 0)
            )
            # разрешаем возврат в "только на поиске"
            && !($new_strategy->{is_net_stop} && !$new_strategy->{is_search_stop})
            && !$login_rights->{super_control}
            && !$login_rights->{manager_control}
            && !$login_rights->{support_control}
            && !$login_rights->{placer_control}
        ) {
            return iget('Управление показами в сети недоступно');
        }
    }

    if ($camp->{type} eq 'mobile_content' && $new_strategy->{name} eq "autobudget_avg_cpi" &&
        (
            (defined $new_strategy->{search}{goal_id} &&
                $new_strategy->{search}{goal_id} != $Settings::DEFAULT_CPI_GOAL_ID &&
                $new_strategy->{search}{goal_id} != $old_strategy->{search}{goal_id} &&
                !Stat::Tools::operator_has_mobile_app_special_goal_permission(
                    $new_strategy->{search}{goal_id},
                    operator_is_manager => $login_rights->{manager_control},
                    operator_has_internal_role => $login_rights->{is_internal_user},
                    operator_client_id => $login_rights->{ClientID},
                    only_features => ['in_app_events_in_rmp_enabled']
                )
            ) ||
            (defined $new_strategy->{net}{goal_id}  &&
                $new_strategy->{net}{goal_id} != $Settings::DEFAULT_CPI_GOAL_ID &&
                $new_strategy->{net}{goal_id} != $old_strategy->{net}{goal_id} &&
                !Stat::Tools::operator_has_mobile_app_special_goal_permission(
                    $new_strategy->{net}{goal_id},
                    operator_is_manager => $login_rights->{manager_control},
                    operator_has_internal_role => $login_rights->{is_internal_user},
                    operator_client_id => $login_rights->{ClientID},
                    only_features => ['in_app_events_in_rmp_enabled']
                )
            )
        )
    ) {
        return iget('Установка цели, отличной от цели по умолчанию, недоступна');
    }

    return undef;
}


sub _is_strategy_change {
    my ($new, $old) = @_;

    my %ignore_fields = (last_update_time => 1, daily_change_count => 1, last_bidder_restart_time => 1);
    my %is_change = map { ## no critic (ProhibitComplexMappings)
        my $diff = 0;
        foreach my $st (keys %{$old->{$_}}) {
            next if $ignore_fields{$st};
            if (!exists $new->{$_}->{$st}
                || (defined $new->{$_}->{$st} ? $new->{$_}->{$st} : '')
                    ne (defined $old->{$_}->{$st} ? $old->{$_}->{$st} : '')) {

                $diff = 1;
                last;
            }
        }
        ($_ => $diff)
    } qw/net search/;
    return $is_change{search} || $is_change{net};
}

sub is_strategy_change_ignore_platform {
    my ($new, $old) = @_;

    my $old_strategy = $old->{is_search_stop} ? 'net' : 'search';
    my $new_strategy = $new->{is_search_stop} ? 'net' : 'search';

    my %ignore_fields = (last_update_time => 1, daily_change_count => 1, last_bidder_restart_time => 1);
    my $diff = 0;
    foreach my $st (keys %{$old->{$old_strategy}}) {
        next if $ignore_fields{$st};

        if ($st eq 'name'
            && $old_strategy eq 'net'
            && $old->{$old_strategy}  eq 'maximum_coverage'
            && $new_strategy eq 'search'
            && $new->{$new_strategy}->{$st} eq 'default') {
            next;
        }

        if ($st eq 'name'
            && $new_strategy eq 'net'
            && $new->{$new_strategy}->{$st} eq 'maximum_coverage'
            && $old_strategy eq 'search'
            && $old->{$old_strategy}->{$st} eq 'default') {
            next;
        }

        if (!exists $new->{$new_strategy}->{$st}
            || (defined $new->{$new_strategy}->{$st} ? $new->{$new_strategy}->{$st} : '')
            ne (defined $old->{$old_strategy}->{$st} ? $old->{$old_strategy}->{$st} : '')) {
            $diff = 1;
            last;
        }
    }
    return $diff;
}

=head2 prepare_cpm_yndx_frontpage_params($campaign)

    Дабавляет в кампанию cpm_yndx_frontpage параметры необходимые для валидации
    $campaign - объект кампании

=cut

sub prepare_cpm_yndx_frontpage_params {
    my ($campaign, $geo, $frontpage_types, $ClientID) = @_;

    $campaign->allowed_frontpage_types($frontpage_types);
    my $is_merge_geo;
    if (ref $geo) {
        $is_merge_geo = defined $geo->{merge_geo} ? delete $geo->{merge_geo} : 1;
    } else {
        $is_merge_geo = 0;
    }
    my $merged_geo = get_merged_geo_str($campaign->id, $geo, ClientID => $ClientID, merge_geo => $is_merge_geo);
    $campaign->geo($merged_geo);

    return;
}

=head2 camp_set_strategy($camp, $strategy, $options)

    Установка стратегии на кампанию
    $camp - хеш кампании
    $strategy - новая стратегия
    $options
        send_notifications - отправлять? уведомление о смене стратегии
        uid - id пользователя


=cut
sub camp_set_strategy {
    my ($camp, $strategy, $options) = @_;
    #для конверсионных стратегий записываем в стратегию информацию о времени рестарта при изменении модели аттрибуции
    my $strategy_has_changes = _is_strategy_change($strategy, $camp->{strategy});
    my $package_strategy_is_changed = $options->{package_strategy_is_changed};
    return 0 unless $strategy_has_changes || $options->{is_attribution_model_changed} || $options->{need_to_create_new_package};

    my $is_media_camp = is_media_camp(cid => $camp->{cid});

    my $type = get_camp_type(cid => $camp->{cid});

    my $strategy_object = strategy_from_strategy_app_hash($strategy, skip_unknown => 1);
    croak 'Strategy is not defined' if !$strategy_object;

    my $campaigns = _query_campaign($type => $camp->{cid});
    my $campaign = $campaigns->items->[0];

    if ($type eq 'performance') {
        $campaign->metrika_counters(get_num_array_by_str($camp->{metrika_counters}));
    }

    my %strategy_set_opt = (
        is_search_stop                           => $strategy->{is_search_stop},
        is_net_stop                              => $strategy->{is_net_stop},
        is_different_places                      => $strategy->{name} eq 'different_places',
        has_edit_avg_cpm_without_restart_enabled => Client::ClientFeatures::has_edit_avg_cpm_without_restart_feature($camp->{ClientID}),
        has_conversion_strategy_learning_status_enabled => Client::ClientFeatures::has_conversion_strategy_learning_status_enabled($camp->{ClientID}),
        is_attribution_model_changed => $options->{is_attribution_model_changed}
    );

    $campaigns->set_strategy($options->{uid}, $strategy_object, %strategy_set_opt);

    $campaigns->save();

    my $strategy_id = $campaign->strategy_id;
    my $strategy_values = {
        strategy_id                 => $strategy_id,
        strategy_data               => $strategy_object->get_strategy_json,
        type                        => $campaign->strategy_name
    };

    if ($strategy_id && !$package_strategy_is_changed){
        do_update_table(PPC(cid => $camp->{cid}), 'strategies', $strategy_values, where => {strategy_id => $strategy_id});
    }

    if (!$strategy_has_changes) {
        return 0;
    }

    my $new_strategy = $campaign->get_strategy_app_hash($strategy_object);

    my $new_camp = {
        strategy => $strategy,
        ContextPriceCoef => $camp->{ContextPriceCoef},
        ClientID => $camp->{ClientID}
    };
    if ($type eq 'cpm_yndx_frontpage') {
        my $is_merge_geo;
        if (ref $camp->{geo}) {
            $is_merge_geo = defined $camp->{geo}{merge_geo} ? delete $camp->{geo}{merge_geo} : 1;
        } else {
            $is_merge_geo = 0;
        }
        my $geo = get_merged_geo_str($camp->{cid}, $camp->{geo}, ClientID => $camp->{ClientID}, merge_geo => $is_merge_geo);
        $new_camp->{geo} = $geo;
        $new_camp->{allowed_frontpage_types} = $camp->{allowed_frontpage_types};
    }

    campaign_strategy_changed($new_camp, $camp) unless $is_media_camp;

    mark_strategy_change($camp->{cid}, $options->{uid}, $strategy, $camp->{strategy});
    if ($options->{send_notifications}) {
        my $notify_text = take_strategy_notify($camp->{cid}, $strategy, $camp->{strategy}, $camp->{currency});
        if ($notify_text) {
            mail_notification( 'camp', 'c_strategy', $camp->{cid}, '', $notify_text, $options->{uid} );
        }
    }

    $camp->{strategy} = $new_strategy;

    return 1;
}


=head2 get_strategy_fields()

    Возвращает ссылку на массив со списком полей параметров стратегии кампании

    !!! Используется для логирования смены стратегии, тут названия полей старые

=cut

sub get_strategy_fields {
    my @strategy_fields = qw/cid
      strategy_name
      strategy_data
      autobudget
      autobudget_avg_bid
      autobudget_bid
      autobudget_date
      autobudget_goal_id
      autobudget_limit_clicks
      autobudget_sum
      autobudget_avg_cpa
      autobudget_avg_cpi
      autobudget_crr
      autobudget_roi_coef
      autobudget_reserve_return
      autobudget_profitability
      filter_avg_cpc
      filter_avg_cpa
      strategy_no_premium
      platform
      strategy
      start
      finish
      budget
      auto_prolongation
      _strategy_name/;

    return \@strategy_fields;
}

sub mark_strategy_change {

    my ( $cid, $uid, $new_strategy, $old_strategy, $UID ) = @_;

    $UID //= 1;
    my $strategy_fields = get_strategy_fields();

    my $old_name = $old_strategy->{name} || $old_strategy->{search}->{name};
    my $new_name = $new_strategy->{name} || $new_strategy->{search}->{name};

    my %flat_strategy = _flat_strategy($cid, $new_strategy);
    LogTools::log_messages('autobudget_changes', join ';', map {"$_: " . ($flat_strategy{$_} || '')} @$strategy_fields);

    # отдельно в ppclog_cmd
    log_cmd({
        cmd => '_save_strategy',
        cid => $cid,
        UID => 1,
        uid => $uid,
        old => to_json({_strategy_name_human => _strategy_name_human($old_strategy), %$old_strategy}, utf8 => 1),
        new => to_json({_strategy_name_human => _strategy_name_human($new_strategy), %$new_strategy}, utf8 => 1)
    });
}


=head3 _strategy_name_human

    $strategy_names = _strategy_name_human($strategy, no_details => 1);
    $strategy_names => {
        search_name => 'Показ по минимальной цене в спецразмещениии',
        net_name => 'Максимально доступный охват',
    }

=cut

sub _strategy_name_human {
    my ($strategy, %O) = @_;

    my @platforms = $strategy->{name} eq 'different_places'
        ? (qw/ search net /)
        : $strategy->{is_search_stop} ? ('net') : ('search');

    my %platform_names = map { $_.'_name' => one_strategy_name_human($strategy->{$_}, %O) } @platforms;
    return \%platform_names;
}

=head3 one_strategy_name_human

    $strategy_text_name = one_strategy_name_human($strategy->{search}, no_details => 1);

=cut

sub one_strategy_name_human {
    my ($strategy, %O) = @_;

    my $strategy_name = (ref($strategy)) ? $strategy->{name} : $strategy;
    my $strategy_name_text_data = $STRATEGY_NAME{$strategy_name};
    if (!$strategy_name_text_data) {
        return undef;
    } elsif (ref $strategy_name_text_data) {
        if ($O{no_details} || !ref($strategy)) {
            return iget($strategy_name_text_data->{name});
        } else {
            my $strategy_place = $strategy->{place};
            return iget($strategy_name_text_data->{$strategy_place});
        }
    } else {
        return iget($strategy_name_text_data);
    }
}

sub _flat_strategy {
    my ($cid, $strategy) = @_;

    my $strategy_model = strategy_from_strategy_app_hash($strategy);
    # !!! dirty hack: собираем модель псевдо-кампании для полей применения стратеги
    my $platform = Direct::Model::Campaign->detect_platform(
        is_search_stop => $strategy->{is_search_stop},
        is_net_stop => $strategy->{is_net_stop},
    );
    my $qcamp = Direct::Model::Campaign->new(platform => $platform);
    my $flat = $qcamp->get_flat_strategy_app_hash($strategy_model);
    return %$flat;
}


=head2 take_strategy_notify

    сгенерировать текст, о том что у кампании изменилась стратегии

    my $scalar_text = take_strategy_notify($cid, $new_strategy, $old_strategy, $currency, %O);

    $scalar_text - тестовой скаляр или undef, если не удалось отдетектить стратегию
    Необязательные параметры
        short => 1 - не писать Включена/Изменена ...

    i18n: экзотических языков интернационализация со сбором фраз из отдельных предложений не переживёт.

=cut

sub take_strategy_notify {
    my ( $cid, $new_strategy, $old_strategy, $currency, %opt ) = @_;

    die 'no currency given' unless $currency;

    my @text;
    my $new_name = $new_strategy->{name} || $new_strategy->{search}->{name};
    my $old_name = $old_strategy->{name} || $old_strategy->{search}->{name};
    if ( is_media_camp(cid => $cid) ) {
        if ( $new_name eq 'autobudget' ) {
            if (!$opt{short}) {
                if ($new_name ne $old_name) {
                    push @text, iget('Включен АВТОБЮДЖЕТ с параметрами');
                } else {
                    push @text, iget('Изменены параметры АВТОБЮДЖЕТА');
                }
            }
            # i18n: работать с датой по-нормальному
            my $date_str = join '.', reverse split /\D+/, $new_strategy->{search}->{date};
            push @text, iget('Показывать до %s', $date_str);
        }
        elsif ( $new_name ne $old_name ) {
            push @text, iget('Выключен АВТОБЮДЖЕТ');
        }
    } else {
        my $is_different_places = $new_name eq 'different_places';
        my %prefix =
          $is_different_places
          ? ( search => sprintf("\t%s: ", iget("На поиске")), net => sprintf("\t%s: ", iget("В сетях")) )
          : ( search => '' );

        my $strategy_name = one_strategy_name_human($new_strategy) || one_strategy_name_human($new_strategy->{search});
        if ($opt{short}) {
            push @text, $strategy_name;
        } else {
            if ($new_name eq $old_name) {
                push @text, iget('Изменены параметры стратегии «%s»', $strategy_name);
            } else {
                push @text, iget('Включена стратегия «%s»', $strategy_name);
            }
        }

        while (my ($platform, $prefix_str) = each %prefix) {
            next unless $is_different_places || $new_strategy->{$platform}->{name} =~ /autobudget/;
            if ($new_strategy->{$platform}->{name} =~ /autobudget/) {
                push @text, _autobudget_notify( $prefix_str, $new_strategy->{$platform}, $currency, %opt );
            } else {
                push @text, _prof_notify( $prefix_str, $new_strategy->{$platform}, $currency );
            }
        }
    }

    return join "\n", @text;
}

=head3 _autobudget_notify

    @texts = _autobudget_notify($prefix, $strategy, $currency, short => 1);

=cut

sub _autobudget_notify {
    my ($prefix, $strategy, $currency, %opt) = @_;

    die 'no currency given' unless $currency;

    my @text;
    if ($strategy->{name} eq 'autobudget') {
        if (defined $strategy->{goal_id} && length($strategy->{goal_id})) {
            if ( $strategy->{goal_id} > 0 ) {
                my $goal_name = CampaignTools::get_metrika_goals(where => {goal_id => [$strategy->{goal_id}]})->{$strategy->{goal_id}}->{name};
                push @text, iget('Максимальная конверсия по цели: "%s"', $goal_name);
            } else {
                push @text, iget('Максимальная конверсия по всем целям');
            }
        }
        my $sum_str = format_sum_of_money($currency, $strategy->{sum});
        if ($strategy->{bid}) {
            my $bid_sum_str = format_sum_of_money($currency, $strategy->{bid});
            push @text, iget('Тратить %s в неделю при максимальной ставке %s', $sum_str, $bid_sum_str);
        } else {
            push @text, iget('Тратить %s в неделю', $sum_str);
        }
    }
    elsif ($strategy->{name} eq 'autobudget_week_bundle') {
        my $t = "Привлекать $strategy->{limit_clicks} кликов в неделю";
        if ( $strategy->{bid} ) {
            my $bid_sum_str = format_sum_of_money($currency, $strategy->{bid});
            push @text, iget('Привлекать %d кликов в неделю при максимальной ставке %s', $strategy->{limit_clicks}, $bid_sum_str);
        }
        elsif ( $strategy->{avg_bid} ) {
            my $avg_bid_sum_str = format_sum_of_money($currency, $strategy->{avg_bid});
            push @text, iget('Привлекать %d кликов в неделю при средней цене клика %s', $strategy->{limit_clicks}, $avg_bid_sum_str);
        } else {
            push @text, iget('Привлекать %d кликов в неделю', $strategy->{limit_clicks});
        }
    }
    elsif ($strategy->{name} eq 'autobudget_avg_click') {
        my $avg_bid_sum_str = format_sum_of_money($currency, $strategy->{avg_bid});
        if ($strategy->{sum}) {
            my $sum_str = format_sum_of_money($currency, $strategy->{sum});
            push @text, iget('Удерживать цену клика %s в среднем за неделю при недельном бюджете не более %s', $avg_bid_sum_str, $sum_str);
        } else {
            push @text, iget('Удерживать цену клика %s в среднем за неделю', $avg_bid_sum_str);
        }
    }
    elsif ($strategy->{name} eq 'autobudget_avg_cpa') {
        # !!! TODO
    }
    elsif ($strategy->{name} eq 'autobudget_roi') {
        my $desc = iget('Удерживать рентабельность инвестиций на уровне %s', $strategy->{roi_coef});
        if ($strategy->{goal_id} > 0) {
            $desc .= ' '.iget('по цели: "%s"', get_one_field_sql(PPCDICT, "select name from metrika_goals where goal_id = ?", $strategy->{goal_id}));
        } else {
            $desc .= ' '.iget('по всем целям');
        }
        if (is_valid_float($strategy->{reserve_return})) {
            $desc .= ', '.iget('возвращать в рекламу %s%% сэкономленного бюджета', $strategy->{reserve_return});
        }
        if (is_valid_float($strategy->{sum})) {
            $desc .= ', '.iget('при недельном бюджете не более %s', format_sum_of_money($currency, $strategy->{sum}));
        }
        if (is_valid_float($strategy->{bid})) {
            $desc .= ', '.iget('при максимальной ставке не более %s', format_sum_of_money($currency, $strategy->{bid}));
        }
        if (is_valid_float($strategy->{profitability})) {
            $desc .= ', '.iget('учитывать, что %s%% доходов является себестоимостью товаров или услуг', $strategy->{profitability});
        }
        push @text, $desc;
    }

    my @ret;
    if ($prefix) {
        my $strategy_name = one_strategy_name_human($strategy, no_details => !$opt{short});    # XXX: short не такой уж short :)
        push @ret, $prefix . $strategy_name;
    }
    my $tab = $prefix ? "\t\t" : "\t";
    push @ret, map { "$tab$_" } @text;
    return @ret;
}

=head3 _prof_notify

    $text = _prof_notify($prefix, $strategy);

=cut

sub _prof_notify {
    my ($prefix, $strategy) = @_;

    return $prefix . one_strategy_name_human($strategy);
}

=head2 build_mcb_strategy($form)

    Из плоских данных(как правило %FORM) построить структуру "стратегии"
    для МКБ

=cut

# необходимо для того что бы иметь одинаковый формат данных для validate_camp_strategy и camp_set_strategy
# для директовых и МКБ кампаний
sub build_mcb_strategy {

    my $form = shift;

    return {
        is_search_stop => 0,
        search => {
            $form->{autobudget} && $form->{autobudget} eq 'Yes'
                ? (name => 'autobudget', date => $form->{autobudget_date})
                : (name => 'default')
        },
        is_net_stop => 1,
        net => {},
    }
}


=head2 campaign_strategy($campaign)

    Определение стратегии кампании + параметры стратегии
        $campaign - id кампании или ссылка на хеш с параметрами кампании

    Результат:
    {
        search => {
            name => 'название поисковой стратегии'
            # параметры стратегии(avg_bid sum bid goal_id)
        },
        net => {
            name => 'название стратегии для сети'
            # параметры стратегии(avg_bid sum bid goal_id)
        },
        name => 'общее название стратегии'
        # different_places - Независимое управление для разных типов площадок
        # '' - общего названия стратегии нет
    }

=cut

sub campaign_strategy {
    my $campaign = shift;

    unless (ref $campaign) {
        return mass_campaign_strategy($campaign)->{$campaign};
    }

    _compose_campaign_strategy_object($campaign);
}

sub mass_campaign_strategy {
    my $cids = shift;

    my $campaigns = Direct::Campaigns->get_by(campaign_id => $cids)->items;
    my %result = map {$_->id => $_->get_strategy_app_hash} @$campaigns;
    return \%result;
}


sub _compose_campaign_strategy_object {
    my $campaign = shift;

    my $camp_media_type = $campaign->{type} || $campaign->{mediaType} || get_camp_type(cid => $campaign->{cid});
    return undef if $camp_media_type eq 'wallet';

    return is_media_camp(type => $camp_media_type)
        ? build_mcb_strategy($campaign)
        : define_strategy($campaign);
}

=head2 campaign_strategy_to_strategy_name

    Определение названия стратегии кампании по описанию стратегии (campaign_strategy/mass_campaign_strategy)

=cut

sub campaign_strategy_to_strategy_name {
    my $st = shift;

    my $camp_strategy_name = 'default';

    if($st->{name} eq 'different_places'){
        # раздельное размещение
        $camp_strategy_name = 'different_places';
    } else {
        # не раздельное размещение
        if(!$st->{is_search_stop}){
            # поисковая стратегия
            $camp_strategy_name = $st->{search}->{name};
            # подгоняем под название в %Campaign::STRATEGY_NAME;
            if($camp_strategy_name eq 'no_premium' && $st->{search}->{place} eq 'highest_place'){
                $camp_strategy_name = 'strategy_no_premium_highest';
            } elsif(exists $st->{search}->{place}){
                $camp_strategy_name .= '_' . $st->{search}->{place};
            } elsif($camp_strategy_name eq 'autobudget') {
                $camp_strategy_name = defined $st->{search}->{goal_id} ? 'week_autobudget_avg_cpa' : 'week_autobudget_avg_click';
            }
        } else {
            # стратегия РСЯ
            $camp_strategy_name = $st->{net}->{name};
        }
    }

    return  $camp_strategy_name;
}

=head2 define_strategy($campaign)
	Исходя из параметров переданной компании формирует структуру, описывающую стратегию
	Возвращает hashref:
	{
        	name           => string,
        	search         => hashref,
        	is_search_stop => $search->{name} eq 'stop',
        	net            => hashref,
        	is_net_stop    => $net->{name} eq 'stop',
        	is_autobudget  => 0|1
    	}

=cut

sub define_strategy {
    my $camp = shift;

    my $strategy = strategy_from_campaign_hash($camp, skip_unknown => 1);

    # если стратегию не определили (= невалидная комбинация полей) - назначаем дефолтную
    $strategy ||= Direct::Strategy::HighestPosition->new();

    if ( $strategy->name eq "autobudget_avg_cpi" && !defined $strategy->goal_id ) {
        $strategy->goal_id($Settings::DEFAULT_CPI_GOAL_ID);
    }
    # !!! dirty hack: собираем модель псевдо-кампании для полей применения стратеги
    my $qcamp = _get_quasi_campaign($camp);
    return $qcamp->get_strategy_app_hash($strategy) if defined $strategy;
}

sub define_strategy_from_package {
    my ($strategy_data, $type, $currency, $platform) = @_;

    my $strategy = strategy_from_strategy_hash($strategy_data, skip_unknown => 1);

    # если стратегию не определили (= невалидная комбинация полей) - назначаем дефолтную
    $strategy ||= Direct::Strategy::HighestPosition->new();

    if ( $strategy->name eq "autobudget_avg_cpi" && !defined $strategy->goal_id ) {
        $strategy->goal_id($Settings::DEFAULT_CPI_GOAL_ID);
    }
    # !!! dirty hack: собираем модель псевдо-кампании для полей применения стратеги
    my $class = Direct::Campaigns->get_model_class_by_type($type, skip_unknown => 1);

    # hack for api data
    my $strategy_name = $strategy_data->{name};
    $strategy_name = ''  if !$strategy_name || $strategy_name eq 'cpa_optimizer' || ($type ne 'performance' && $strategy_name ne 'different_places');

    my %camp_params = (
        campaign_type => $type,
        currency => $currency,
        _strategy_name => $strategy_name,
        platform => $platform || Direct::Model::Campaign->default_platform($type),
    );

    my $qcamp = $class->new(%camp_params);
    return $qcamp->get_strategy_app_hash($strategy) if defined $strategy;
}


=head2 is_autobudget($strategy)

    Возвращает true если стратегия автобюджетная
    $strategy - хэш с полями
        search = { name => .. }
        или
        net = { name => .. }

=cut

sub is_autobudget {
    my $strategy = shift;
    if ($strategy->{search}{name} =~ /autobudget/ ||
        $strategy->{net}{name} =~ /autobudget/
    ) {
        return 1;
    }
    return 0;
}



=head2 get_camp_info

    Возвращает данные по кампании, включая параметры из camp_options
        Опции: short - получить данные только из таблицы campaigns
               client_nds - НДС клиента в процентах
                            если указан, sum/sum_spent в мультивалютных кампаниях будут без НДС
               client_discount - текущая скидка клиента в процентах
                                 если указан, total будет с учётом скидочного бонуса (сумма которого вернётся в поле bonus)
               with_strategy => 0|1 - сформировать хеш статегии (по умолчанию 0); не совместимо с опцией short
               types - какие типы кампаний нужно выбрать
               without_multipliers => 0|1 - не формировать информацию про корректировки ставок (по умолчанию 0);
                                            если указана опция short, корректировки также не читаются
               favorite_camp_uid => 123 - представитель клиента, по которому нужно выбирать флаг "избранности" кампании

    ВНИМАНИЕ! В возвращаемых данных ключ с ФИО называется FIO, а save_camp ожидает его под именем fio.
    Т.е. напрямую результат get_camp_info передавать в save_camp нельзя, нужно разбираться с FIO
    и логическими полями ('Yes'/'No' vs true/false).

=cut

sub get_camp_info
{
    my ($cid, $uid, %O) = @_;

    return undef if ! defined $cid;
    my $where_clause = {'c.cid' => $cid};

    if (defined $uid) {
        $where_clause->{'c.uid'} = $uid;
    }

    if (my $types = delete $O{types}) {
        $where_clause->{'c.type'} = $types;
    }

    my $sql;
    if ($O{short}) {
        $sql = qq[
            SELECT
                c.*,
                c.type,
                c.sum - c.sum_spent AS total,
                IF(c.wallet_cid > 0, 1, 0) as wallet_is_enabled,
                IF(c.wallet_cid > 0, wc.sum, 0) as wallet_sum,
                IF(c.wallet_cid > 0, wc.sum_spent, 0) as wallet_sum_spent,
                IF(c.wallet_cid > 0, wc.sum - wc.sum_spent, 0) as wallet_total,
                IF(c.wallet_cid > 0, wc.sum_last, 0) as wallet_sum_last,
                IF(c.wallet_cid > 0, wc.sum_to_pay, 0) as wallet_sum_to_pay,
                c.wallet_cid,
                c.autobudget,
                c.ContextPriceCoef,
                IFNULL(s.type, '') as strategies_strategy_name,
                s.strategy_data as strategies_strategy_data,
                s.ContextLimit as strategies_ContextLimit,
                s.enable_cpc_hold,
                s.meaningful_goals as strategies_meaningful_goals,
                u.ClientID,
                IFNULL(c.currency, "YND_FIXED") as currency,
                co.strategy,
                co.placement_types,
                co.meaningful_goals,
                c.type as mediaType,
                perf_camp.now_optimizing_by
            FROM
                campaigns c
                JOIN users u ON u.uid = c.uid
           LEFT JOIN camp_options co USING(cid)
           left join strategies s on c.strategy_id = s.strategy_id
           left join campaigns wc on c.wallet_cid = wc.cid
           left join campaigns_performance perf_camp on perf_camp.cid = c.cid
        ];
    } else {
        my $join_fav_camp = sprintf("left join user_campaigns_favorite ufc on ufc.cid = c.cid and ufc.uid = %s", sql_quote($O{favorite_camp_uid} || $uid));

        $sql = "select
                                            c.*
                                          , c.type
                                          , c.sum - c.sum_spent as total
                                          , IFNULL(c.currency, 'YND_FIXED') as currency
                                          , IF(c.wallet_cid > 0, 1, 0) as wallet_is_enabled
                                          , IF(c.wallet_cid > 0, wc.sum, 0) as wallet_sum
                                          , IF(c.wallet_cid > 0, wc.sum_spent, 0) as wallet_sum_spent
                                          , IF(c.wallet_cid > 0, wc.sum - wc.sum_spent, 0) as wallet_total
                                          , IF(c.wallet_cid > 0, wc.sum_last, 0) as wallet_sum_last
                                          , IF(c.wallet_cid > 0, wc.sum_to_pay, 0) as wallet_sum_to_pay
                                          , c.wallet_cid
                                          , s.type as strategies_strategy_name
                                          , s.strategy_data as strategies_strategy_data
                                          , s.ContextLimit as strategies_ContextLimit
                                          , s.enable_cpc_hold
                                          , s.meaningful_goals as strategies_meaningful_goals
                                          , co.FIO, co.lastnews, co.sendNews, co.sendWarn
                                          , co.sendAccNews
                                          , IF(co.contactinfo != '', co.contactinfo, NULL) as contactinfo
                                          , co.money_warning_value
                                          , co.banners_per_page, co.sms_time, co.sms_flags
                                          , co.warnPlaceInterval, co.statusMetricaControl, co.status_click_track, co.last_pay_time
                                          , co.stopTime
                                          , co.strategy
                                          , co.placement_types
                                          , co.auto_optimize_request
                                          , co.statusPostModerate
                                          , co.statusContextStop
                                          , co.fairAuction = 'Yes' as fairAuction
                                          , co.offlineStatNotice = 'Yes' as offlineStatNotice
                                          , co.placement_types
                                          , co.broad_match_flag = 'Yes' as broad_match_flag
                                          , co.broad_match_limit, co.broad_match_goal_id
                                          , co.minus_words
                                          , co.statusContextStop
                                          , IFNULL(co.valid, u.valid) as valid, IFNULL(co.email, u.email) as email
                                          , co.mediaplan_status, co.stopTime, (c.sum_units - c.sum_spent_units) as total_units
                                          , caq.operation as delayed_arc
                                          , af.autobudgetForecastClicks
                                          , IFNULL(cdc.domains_count, 0) as compaign_domains_count
                                          , co.day_budget_daily_change_count, co.day_budget_stop_time
                                          , co.email_notifications
                                          , co.competitors_domains
                                          , co.device_targeting
                                          , co.status_click_track
                                          , co.mobile_app_goal
                                          , wc.day_budget as wallet_day_budget
                                          , wc.day_budget_show_mode as wallet_day_budget_show_mode
                                          , wco.day_budget_stop_time as wallet_day_budget_stop_time
                                          , mc.metrika_counters
                                          , u.ClientID
                                          , c.opts
                                          , cmc.device_type_targeting
                                          , cmc.network_targeting
                                          , cmc.mobile_app_id
                                          , cdmo.now_optimizing_by
                                          , c.type as mediaType
                                          , if(ufc.cid, 1, 0) is_favorite
                                          , co.create_time
                                          , co.manual_autobudget_sum
                                          , co.brand_survey_id
                                          , co.meaningful_goals
                                          , co.impression_standard_time
                                          , co.eshows_banner_rate
                                          , co.eshows_video_rate
                                          , co.eshows_video_type
                                          , experiment_id
                                          , cf.allowed_frontpage_types
                                          , (SELECT is_lego_mediaplan FROM mediaplan_stats ms WHERE ms.cid = c.cid ORDER BY create_time DESC LIMIT 1) as is_lego_mediaplan
                                          , ci.is_mobile as is_mobile
                                          , ci.restriction_type as restriction_type
                                          , ci.restriction_value as restriction_value
                                          , ci.page_ids as page_ids
                                          , ci.place_id as place_id
                                          , ci.rotation_goal_id as rotation_goal_id
                                     from campaigns c
                                          left join camp_options co on co.cid = c.cid
                                          left join strategies s on c.strategy_id = s.strategy_id
                                          left join campaigns wc on wc.cid = c.wallet_cid
                                          left join camp_options wco on wco.cid = c.wallet_cid
                                          left join users u on c.uid = u.uid
                                          left join camp_operations_queue caq on caq.cid=c.cid
                                          left join autobudget_forecast af on c.cid = af.cid
                                          left join camp_metrika_counters mc on mc.cid = c.cid
                                          left join camp_domains_count cdc on cdc.cid = c.cid
                                          left join campaigns_mobile_content cmc on cmc.cid = c.cid
                                          left join campaigns_performance cdmo on cdmo.cid = c.cid
                                          left join campaigns_experiments ce on ce.cid = c.cid
                                          left join campaigns_cpm_yndx_frontpage cf on cf.cid = c.cid
                                          left join campaigns_internal ci on ci.cid = c.cid
                                          $join_fav_camp";
    }

    my $res = get_all_sql(PPC(cid => $cid), [ $sql, where => $where_clause ]);

    my $sum_debt_all = WalletUtils::get_sum_debt_for_wallets_by_uids($uid ? [$uid] : [uniq map { $_->{uid} } @$res]);
    my $clients_info;
    if (@$res) {
        $clients_info = Client::get_clients_auto_overdraft_info([uniq map { $_->{ClientID} } @$res]);
    }
    for my $camp (@{$res || []}) {
        unless ($O{short} || $O{without_multipliers}) {
            $camp->{hierarchical_multipliers} = JavaIntapi::GetBidModifiers->new(campaign_id => $camp->{cid})->call();
            $camp->{multipliers_meta} = Direct::Validation::HierarchicalMultipliers::get_metadata($camp->{mediaType});
        }

        if ($camp->{strategies_strategy_name}) {
            $camp->{strategy_name} = $camp->{strategies_strategy_name};
        }

        if ($camp->{strategies_strategy_data}) {
            $camp->{strategy_data} = $camp->{strategies_strategy_data};
        }

        if ($camp->{strategies_ContextLimit}) {
            $camp->{ContextLimit} = $camp->{strategies_ContextLimit};
        }

        if ($camp->{strategies_meaningful_goals}) {
            $camp->{meaningful_goals} = $camp->{strategies_meaningful_goals};
        }

        _deserialize_camp_fields($camp);

        $camp->{currency} ||= 'YND_FIXED'; #currency_defaults
        $camp->{email_notifications} = {map {$_ => 1} split ',', ($camp->{email_notifications}||'')};

        WalletUtils::calc_camp_uni_sums_with_wallet($camp, $sum_debt_all, $clients_info->{$camp->{ClientID}});
        # TODO: не совсем корректно здесь использовать client_nds
        #       т.к. формально запрос может прийти для кампаний разных клиентов - а кейс работает только в рамках одного клиента
        campaign_remove_nds_and_add_bonus($camp, %{hash_cut \%O, qw/client_nds client_discount/});
        unless ($O{short}) {
            my $product_info = product_info(ProductID => $camp->{ProductID});
            $camp->{product_info} = $product_info;
            $camp->{product_type} = $product_info->{product_type};
            if (($product_info->{daily_shows}||0) > 0 && $camp->{sum_units} > 0) {
                $camp->{till_date} = unix2human( mysql2unix($camp->{start_time}) +
                    24*60*60*(($camp->{sum_units} - $camp->{sum_spent_units})/$product_info->{daily_shows}));
            }
            $camp->{strategy} = campaign_strategy($camp) if $O{with_strategy};
            $camp->{opts} = {map {$_ => 1} split ',', $camp->{opts}};
            if ($camp->{enable_cpc_hold} && $camp->{enable_cpc_hold} eq 'Yes') {
                $camp->{opts}->{enable_cpc_hold} = 1;
            }
            $camp->{sms_flags} = campaign_sms_flags($camp->{sms_flags});
            $camp->{$_} = int($camp->{$_}) for (qw/wallet_is_enabled broad_match_flag/);
        }

        # Минус-слова на кампанию должны называться campaign_minus_words
        if (defined $camp->{minus_words}) {
            $camp->{campaign_minus_words} = $camp->{minus_words} = MinusWordsTools::minus_words_str2array($camp->{minus_words});
        }

        # Удаляем поля, несоответствующие типу кампании
        my $type = $camp->{mediaType};
        state $type_specific_fields = {
            mobile_content => [qw/ device_type_targeting network_targeting /],
            performance => [qw/ now_optimizing_by /],
            internal_distrib => [qw/ is_mobile restriction_type page_ids place_id rotation_goal_id /],
            internal_free => [qw/ is_mobile restriction_type restriction_value page_ids place_id /],
        };
        state $fields_to_delete = {};
        if (!$fields_to_delete->{$type}) {
            my %is_used_field = map {($_ => 1)} @{$type_specific_fields->{$type} || []};
            my @unused_fields = uniq grep {!$is_used_field{$_}} map {@$_} values %$type_specific_fields;
            $fields_to_delete->{$type} = \@unused_fields;
        }
        delete $camp->{$_} for @{$fields_to_delete->{$type}};

        if ($type eq 'mobile_content' && !$O{short}) {
            for my $target (qw/device_type_targeting network_targeting/) {
                $camp->{$target} = [split /\s*,\s*/, $camp->{$target} || ''];
            }
        }
    }

    if ($O{with_content_promotion_type}) {
        my @content_promotion_cids = map {$_->{cid}} grep { $_->{type} eq 'content_promotion' } @$res;
        my $content_promotion_types = CampaignTools::mass_get_content_promotion_content_type(\@content_promotion_cids);
        for my $camp (@{$res || []}) {
            $camp->{content_promotion_type} = $content_promotion_types->{$camp->{cid}} if $content_promotion_types->{$camp->{cid}};
        }
    }
    # Посчитаем признак has_ecommerce для performance кампаний
    if (my @perf_camps = grep { $_->{type} eq 'performance' } @$res) {
        my @perf_cids_with_metrika = map { $_->{cid} } grep { $_->{metrika_counters} } @perf_camps;
        my $has_ecommerce_by_cid = get_hash_sql(PPC(cid => \@perf_cids_with_metrika), [
            "SELECT cid, MIN(has_ecommerce) FROM metrika_counters", WHERE => {cid => SHARD_IDS}, "GROUP BY cid"
        ]);
        $_->{metrika_has_ecommerce} = !!$has_ecommerce_by_cid->{$_->{cid}} for @perf_camps;
    }

    if (ref $cid eq 'ARRAY') {
        return $res;
    } else {
        return ($res && ref($res) eq 'ARRAY' && @$res > 0) ? $res->[0] : undef;
    }
}

=head2 save_camp

  Сохраняет кампанию

  параметры позиционные:
    c - context
    campaign - ссылка на хэш с "сырой кампанией"
    uid - uid главного представителя
  параметры именованные:
    validEmails => не используется
    dont_sort_disabled_ips => не сортируем забанненные ip по алфавиту (не нужно в API)
    is_new_camp
    ignore_minus_words
    ignore_hierarchical_multipliers => пропустить обновление корректировок
    remove_statusEmpty - убирать ли с кампании statusEmpty или оставить её пустой
    package_strategy_is_changed - кампанию необходимо перенести в другой существующий пакет
    need_to_create_new_package - для кампании неободимо создать новый пакет, и перенести ее в него

  ВНИМАНИЕ! В $campaign ФИО на кампанию ожидается в ключе с именем fio. Не из всех функций кампаний возвращается именно в таком виде.
  Например, get_camp_info возвращает ФИО в ключе FIO. Т.е. напрямую её результат передавать в save_camp нельзя.
  Также нужно учитывать различие в формате значений логических полей ('Yes'/'No' vs true/false).

=cut

sub save_camp
{
    my ($c, $campaign, $uid, %PARAMS) = @_;
    my $valid = 2;

    my $cid = $campaign->{cid};
    $campaign->{mediaType} //= 'text';
    die "Saving camp without cid." unless $cid && is_valid_id($cid);
    my $old_camp = get_camp_info($cid, $uid);
    if (!$old_camp) {
        die "user $uid doesn't have campaign $cid";
    }

    my $old_strategy_id = $old_camp->{strategy_id};
    my $strategy_id = $campaign->{strategy_id};
    my $has_strategy_changes = $campaign->{has_strategy_changes};
    my $package_strategy_is_changed = $PARAMS{package_strategy_is_changed};
    my $need_to_create_new_package = $PARAMS{need_to_create_new_package};
    my $new_package;

    my $client_id = get_clientid(uid => $uid);

    if ($package_strategy_is_changed) {
        my $where = {strategy_id => $strategy_id};
        $new_package = get_strategies($client_id, $where)->{$strategy_id};
        my $strategy_data = from_json($new_package->{strategy_data});
        $campaign->{strategy} = define_strategy_from_package($strategy_data, $campaign->{type}, $campaign->{currency}, $campaign->{platform});
        $campaign->{day_budget} = $new_package->{day_budget};
        $campaign->{day_budget_show_mode} = $new_package->{day_budget_show_mode};
        $campaign->{meaningful_goals} = from_json($new_package->{meaningful_goals} || '[]');
        $campaign->{attribution_model} = $new_package->{attribution_model};
    }

    my $strategy_values = {
        strategy_id => $strategy_id
    };

    if ($need_to_create_new_package){
        $strategy_id = get_new_id('strategy_id', ClientID => $client_id);
        $strategy_values->{strategy_id} = $strategy_id;
        $strategy_values->{ClientID} = $client_id;
        $strategy_values->{wallet_cid} = $campaign->{wallet_cid};
        $strategy_values->{archived} = 'No';
        $strategy_values->{is_public} = 'No';
        $strategy_values->{type} = 'default';
        $strategy_values->{LastChange__dont_quote} = 'NOW()';
        $campaign->{strategy_id} = $strategy_id;
    }

    Campaign::convert_dates_for_db($campaign, keep_source_data => 1, with_old_start_date_format => 1);

    my ($new_start_ts, $new_finish_ts);
    $new_start_ts = eval { ts_round_day( mysql2unix($campaign->{start_time}) ) } if $campaign->{start_time};
    $new_finish_ts = eval { ts_round_day( mysql2unix($campaign->{finish_time}) ) } if $campaign->{finish_time};
    if ( !$PARAMS{is_new_camp} ) {
        # если изменилась дата начала кампании, то отражаем этот факт в рассылаемых уведомлениях
        # дата начала кампании должна обязательно присутствовать, но в базе может быть всякое, поэтому лучше перестраховаться
        my $old_start_ts;
        $old_start_ts = eval { ts_round_day( mysql2unix($old_camp->{start_time}) ) } if $old_camp->{start_time};
        if ( (!$new_start_ts && $old_start_ts)
           || ($new_start_ts && !$old_start_ts)
           || ($new_start_ts && $old_start_ts && $new_start_ts != $old_start_ts)
        ) {
            my $old_start_time_text = ( $old_start_ts ) ? human_date($old_start_ts) : iget('<не указана>');
            my $new_start_time_text = ( $new_start_ts ) ? human_date($new_start_ts) : iget('<не указана>');
            mail_notification('camp', 'c_start', $campaign->{cid}, $old_start_time_text, $new_start_time_text, $uid);
        }

        if (camp_kind_in(type => $campaign->{mediaType}, "web_edit_base", 'camp_finish')) {
            # если изменилась/исчезла/появилась дата окончания текстовой кампании, то отражаем этот факт в рассылаемых уведомлениях
            # дата окончания кампании может и отсутствовать
            my $old_finish_ts;
            $old_finish_ts = eval { ts_round_day( mysql2unix($old_camp->{finish_time}) ) } if $old_camp->{finish_time};

            if ( (!$new_finish_ts && $old_finish_ts)
               || ($new_finish_ts && !$old_finish_ts)
               || ($new_finish_ts && $old_finish_ts && $new_finish_ts != $old_finish_ts)
            ) {
                my $old_finish_time_text = ( $old_finish_ts ) ? human_date($old_finish_ts) : iget('<не указана>');
                my $new_finish_time_text = ( $new_finish_ts ) ? human_date($new_finish_ts) : iget('<не указана>');
                mail_notification('camp', 'c_finish', $campaign->{cid}, $old_finish_time_text, $new_finish_time_text, $uid);
            }

            if (($old_camp->{day_budget} || 0) != ($campaign->{day_budget} || 0)) {
                my $old_day_budget_text = $old_camp->{day_budget} > 0 ? "$old_camp->{day_budget}:$old_camp->{currency}" : 0;
                my $new_day_budget_text = defined $campaign->{day_budget} && $campaign->{day_budget} > 0
                                          ? "$campaign->{day_budget}:$old_camp->{currency}" : 0;
                mail_notification('camp', 'c_day_budget_multicurrency', $campaign->{cid}, $old_day_budget_text, $new_day_budget_text, $uid);

                # Сохраняем фейковую запись в логи об изменении дневного бюджета
                log_cmd({
                    cmd => '_save_day_budget',
                    cid => $cid,
                    UID => 1,
                    uid => $uid,
                    old_day_budget => $old_camp->{day_budget} || 0,
                    currency => $old_camp->{currency},
                    new_day_budget => $campaign->{day_budget} || 0,
                });
            }
        }
    }

    #TODO: $campaign->{strategy} приходит в друх разных видах - строка (из API) или хеш. Было бы неплохо привести к единому виду
    my $is_different_places = (($campaign->{strategy} && (ref $campaign->{strategy} eq 'HASH'))
            ? $campaign->{strategy}->{name}
            : ($campaign->{json_strategy} && (ref $campaign->{json_strategy} eq 'HASH'))
            ? $campaign->{json_strategy}->{name}
            : $campaign->{strategy}) eq 'different_places';
    unless ($is_different_places && $campaign->{search_strategy} && $campaign->{search_strategy} eq 'stop') {
        my $old_broad_match_flag = $old_camp->{broad_match_flag};
        if (!$campaign->{broad_match_flag}) {
            # Если есть менеджер у кампании и broad_match_flag был раньше взведен, и действия производит обычный клиент, то нужно отправить письмо менеджеру с уведомлением.
            if ($old_camp->{ManagerUID} && $old_broad_match_flag && $c->login_rights->{is_any_client}) {
                add_notification(undef, 'broad_match_uncheck', {
                    cid             => $cid,
                    ManagerUID      => $old_camp->{ManagerUID},
                    client_login    => get_login(uid => $uid),
                    client_id       => $client_id,
                });
            }
        }
    } else {
        delete @{$campaign}{qw/broad_match_flag broad_match_limit broad_match_goal_id/};
    }

    if (defined $campaign->{disabledIps}) {
        my @disabled_ips = grep {$_} split /[\s,]+/, $campaign->{disabledIps};
        @disabled_ips = sort @disabled_ips unless $PARAMS{dont_sort_disabled_ips};
        $campaign->{disabledIps} = join ',', @disabled_ips;
    }

    my $ContextLimit = $old_camp->{ContextLimit};
    my $ContextPriceCoef = 100;

    my $is_autobudget = ($campaign->{strategy} && (ref $campaign->{strategy} eq 'HASH'))
        ? is_autobudget($campaign->{strategy})
        : ($campaign->{json_strategy} && (ref $campaign->{json_strategy} eq 'HASH'))
        ? is_autobudget($campaign->{json_strategy})
        : ($campaign->{strategy} =~ /autobudget/);

    if ($is_different_places || $is_autobudget) {
        $ContextLimit = 0;
    } else{
        # настройки показов на тематических площадках
        if (defined $campaign->{ContextLimit}) {
            if (
                $campaign->{ContextLimit} <= 100 || (
                    $campaign->{ContextLimit} == 255 &&
                    $campaign->{ContextLimit} != $old_camp->{ContextLimit} &&
                    $c->login_rights && $c->login_rights->{super_control}
                )
            ) {
                $ContextLimit = $campaign->{ContextLimit};
            }
        }
    }

    # TODO: Удалить после решения DIRECT-27618
    # DIRECT-27575: Не учитываем флаги `time_target_holiday` и `time_target_working_holiday` если `time_target_preset` eq 'all' (круглосуточно)
    @$campaign{qw/time_target_holiday time_target_working_holiday/} = (undef, undef) if ($campaign->{time_target_preset} // '') eq 'all';
    my $new_timeTarget = TimeTarget::pack_timetarget($campaign);

    my $camp_values = {
        name => $campaign->{name},
        start_time => ($new_start_ts) ? unix2mysql($new_start_ts) : 0,
        finish_time => ($new_finish_ts) ? unix2mysql($new_finish_ts) : 0,
        statusEmpty => $PARAMS{is_new_camp} && !$PARAMS{remove_statusEmpty} && ($old_camp->{statusEmpty} // '') ne 'No' ? 'Yes' : 'No',
        statusBsSynced => 'No',
        ContextLimit => $ContextLimit,
        ContextPriceCoef => $ContextPriceCoef,
        timeTarget => $new_timeTarget,
        timezone_id => $campaign->{timezone_id},
        statusOpenStat => $campaign->{statusOpenStat} || 'No',
        disabledIps => $campaign->{disabledIps},
        rf => (is_cpm_campaign($campaign->{mediaType}) || is_internal_campaign($campaign->{mediaType})) ? $campaign->{rf} : $campaign->{rf} || 3,
        LastChange__dont_quote => 'now()',
        ProductID => $old_camp->{ProductID},
        ab_segment_stat_ret_cond_id => $campaign->{ab_segment_stat_ret_cond_id},
        ab_segment_ret_cond_id => $campaign->{ab_segment_ret_cond_id},
        brandsafety_ret_cond_id => $campaign->{brandsafety_ret_cond_id},
        strategy_id => $campaign->{strategy_id},
    };

    if ($PARAMS{is_new_camp} && defined $campaign->{source}) {
        $camp_values->{source} = $campaign->{source};
    }

    if ($campaign->{attribution_model}) { # не затираем attribution_model = null для существующих кампаний
        $camp_values->{attribution_model} = $campaign->{attribution_model};
    } elsif ($PARAMS{is_new_camp}) { # для вновь созданных заполняем значение по умолчанию
        $camp_values->{attribution_model} = get_attribution_model_default();
    }

    $camp_values->{statusModerate} = $campaign->{statusModerate} if defined $campaign->{statusModerate};

    # if exists $campaign->{DontShow} - ?
    my $client_limits = get_client_limits($c->client_client_id);
    my $split = Direct::Validation::Domains::split_disabled_platforms (
              [ split /\s*,\s*/ => $campaign->{DontShow} || '' ],
              disable_any_domains_allowed => Client::ClientFeatures::has_disable_any_domains_allowed_feature($client_id),
              disable_number_id_and_short_bundle_id_allowed => Client::ClientFeatures::has_disable_number_id_and_short_bundle_id_allowed_feature($client_id),
              disable_mail_ru_domain_allowed => Client::ClientFeatures::has_disable_mail_ru_domain_allowed_feature($client_id),
              blacklist_size_limit => $client_limits->{general_blacklist_size_limit}
    );

    $camp_values->{disabled_ssp} = to_json($split->{ssps});
    $camp_values->{DontShow} = join q{,} => sort grep {$_} map {strip_www($_)} @{$split->{rest}};

    if ( defined $campaign->{disabled_video_placements}
        && @{$campaign->{disabled_video_placements}} ) {

        $camp_values->{disabled_video_placements} = to_json([sort @{$campaign->{disabled_video_placements}}]);
    } else {
        $camp_values->{disabled_video_placements} = undef;
    }

    $camp_values->{rfReset} = $campaign->{rfReset} if defined $campaign->{rfReset};

    if (camp_kind_in(type => $campaign->{mediaType}, "web_edit_base")) {
        hash_copy $camp_values, $campaign, qw/day_budget day_budget_show_mode/;
        hash_copy $strategy_values, $campaign, qw/day_budget day_budget_show_mode/;
    }

    # Проставляем все флаги campaigns.opts
    my $campaign_opts_field = $old_camp->{opts};
    $campaign_opts_field->{no_title_substitute} = 0 + !!(
        $campaign->{opts}->{no_title_substitute}
        || camp_kind_in(type => $campaign->{mediaType}, "no_title_substitute")
    );

    if ($is_autobudget) {
        $campaign_opts_field->{enable_cpc_hold} = 0;
    } else {
        $campaign_opts_field->{enable_cpc_hold} = 0 + !!$campaign->{opts}->{enable_cpc_hold};
    }
    $strategy_values->{enable_cpc_hold} = $campaign_opts_field->{enable_cpc_hold} ? 'Yes' : 'No';
    if ($package_strategy_is_changed){
        $campaign_opts_field->{enable_cpc_hold} = $new_package->{enable_cpc_hold} eq 'Yes' ? 1 : 0;
    }
    $campaign_opts_field->{no_extended_geotargeting} = 0 + !!$campaign->{opts}->{no_extended_geotargeting} if (exists $campaign->{opts}->{no_extended_geotargeting});
    $campaign_opts_field->{hide_permalink_info} = 0 + !!$campaign->{opts}->{hide_permalink_info};
    $campaign_opts_field->{has_turbo_smarts} = 0 + !!$campaign->{opts}->{has_turbo_smarts};
    $campaign_opts_field->{is_alone_trafaret_allowed} = 0 + !!$campaign->{opts}->{is_alone_trafaret_allowed};
    $campaign_opts_field->{require_filtration_by_dont_show_domains} = 0 + !!$campaign->{opts}->{require_filtration_by_dont_show_domains};
    $campaign_opts_field->{has_turbo_app} = 0 + !!$campaign->{opts}->{has_turbo_app};
    $campaign_opts_field->{is_order_phrase_length_precedence_enabled} = 0 + !!$campaign->{opts}->{is_order_phrase_length_precedence_enabled};

    my $strategy_available_for_simple_view = 0;

    my $has_strategy_field = $campaign->{strategy} && (ref $campaign->{strategy} eq 'HASH');
    my $is_allowed_to_use_value_from_metrika = 1;
    if ($has_strategy_field) {
        my $is_attribution_model_changed = $old_camp->{attribution_model} ne $campaign->{attribution_model};

        my $is_strategy_available_for_simple_view_for_network =
            $campaign->{strategy}{is_search_stop} &&
            !$campaign->{strategy}{is_net_stop} &&
            $campaign->{strategy}{name} eq "different_places" &&
            $campaign->{strategy}{search}{name} eq "stop" &&
            $campaign->{strategy}{net}{name} eq "autobudget" &&
            (!(defined $campaign->{strategy}{net}{avg_cpa}) || $campaign->{strategy}{net}{avg_cpa} eq '') &&
            (!(defined $campaign->{strategy}{net}{bid}) || $campaign->{strategy}{net}{bid} eq '') &&
            $campaign->{strategy}{net}{pay_for_conversion} == 0;

        my $is_strategy_available_for_simple_view_for_not_network =
            !$campaign->{strategy}{is_search_stop} &&
            $campaign->{strategy}{search}{name} eq "autobudget" &&
            ($campaign->{strategy}{net}{name} eq "default" || $campaign->{strategy}{net}{name} eq "stop") &&
            (!(defined $campaign->{strategy}{search}{avg_cpa}) || $campaign->{strategy}{search}{avg_cpa} eq '') &&
            (!(defined $campaign->{strategy}{search}{bid}) || $campaign->{strategy}{search}{bid} eq '') &&
            $campaign->{strategy}{search}{pay_for_conversion} == 0;

        $strategy_available_for_simple_view = !$PARAMS{is_new_camp} &&
            $campaign->{mediaType} eq "text" &&
            !$is_attribution_model_changed &&
            ($is_strategy_available_for_simple_view_for_network || $is_strategy_available_for_simple_view_for_not_network);

        $is_allowed_to_use_value_from_metrika = is_allowed_to_use_value_from_metrika($campaign->{strategy});
    }

    $campaign_opts_field->{is_simplified_strategy_view_enabled} = $strategy_available_for_simple_view ? $old_camp->{opts}->{is_simplified_strategy_view_enabled} : 0;

    $camp_values->{opts} = join(",", grep {$campaign_opts_field->{$_}} keys(%$campaign_opts_field));

    my @sms_flags_arr = grep {$campaign->{$_}} qw/active_orders_money_out_sms notify_order_money_in_sms moderate_result_sms notify_metrica_control_sms camp_finished_sms paused_by_day_budget_sms/;

    # strange flag - active_orders_money_warning_sms - not using...
    push @sms_flags_arr, 'active_orders_money_warning_sms' if $campaign->{active_orders_money_out_sms};

    if (! defined $campaign->{warnPlaceInterval} || ! grep { $campaign->{warnPlaceInterval} eq $_} @Settings::DEF_WARN_PLACE_INTERVAL_VALUES){
        $campaign->{warnPlaceInterval} = $Settings::DEF_WARN_PLACE_INTERVAL;
    }

    my $sms_time = sms_time2string($campaign->{sms_time_hour_from}, $campaign->{sms_time_min_from}, $campaign->{sms_time_hour_to}, $campaign->{sms_time_min_to});

    smartstrip ( $campaign->{email} );

    my $minus_words = MinusWords::polish_minus_words_array($campaign->{campaign_minus_words} // []);

    my $old_minus_words = MinusWords::get_campaign_minus_words($campaign->{cid});
    # save in camp_options
    my $camp_options = {
          FIO => $campaign->{fio} // ''
        , email => $campaign->{email}
        , valid => $valid
        , sendWarn => (defined $campaign->{sendWarn} ? 'Yes' : 'No')
        , sendAccNews => (defined $campaign->{sendAccNews} ? 'Yes' : 'No')
        , money_warning_value => (defined $campaign->{money_warning_value} ? $campaign->{money_warning_value} : $Settings::DEFAULT_MONEY_WARNING_VALUE)
        , sms_time => $sms_time
        , sms_flags => join(',', @sms_flags_arr)
        , warnPlaceInterval => $campaign->{warnPlaceInterval}
        , statusMetricaControl => ($campaign->{statusMetricaControl} ? 'Yes' : 'No')
        , fairAuction => (defined $campaign->{fairAuction} ? 'Yes' : 'No')
        , statusContextStop => ($campaign->{statusContextStop} ? 'Yes' : 'No')
        , broad_match_flag => ($campaign->{broad_match_flag} ? 'Yes' : 'No')
    };

    if ($campaign->{brand_survey_id}) {
        $camp_options->{brand_survey_id} = $campaign->{brand_survey_id};
    }

    if(exists $campaign->{allowed_page_ids}) {
        $camp_options->{allowed_page_ids} = @{$campaign->{allowed_page_ids}//[]} ? to_json($campaign->{allowed_page_ids}) : undef;
    }
      if(exists $campaign->{offlineStatNotice}) {
        $camp_options->{offlineStatNotice} = $campaign->{offlineStatNotice} ? 'Yes' : 'No';
    }

    if ($c->login_rights->{super_control}) {
        # Записываем язык кампании. В случае, если значение недопустимое, пишем NULL
        $camp_options->{content_lang} = (defined $campaign->{content_lang} &&
                                         camp_kind_in(type=> $campaign->{mediaType}, 'camp_lang') &&
                                         {map { $_=>1 } @CAMPAIGN_CONTENT_LANGS}->{content_lang_to_view($campaign->{content_lang})})
                                        ? content_lang_to_save($campaign->{content_lang})
                                        : undef;
    }
    # Разметка ссылок для метрики: yclid
    if (camp_kind_in(type => $campaign->{mediaType}, 'yclid_enabled')) {
        $camp_options->{status_click_track} = 1;
    } elsif (defined $campaign->{status_click_track}) {
        # из API может не прийти этого поля
        $camp_options->{status_click_track} = $campaign->{status_click_track} ? 1 : 0;
    }

    # Таргетинг на устройства пока могут задавать не все роли.
    if (can_save_camp_device_targeting($c)) {
        $camp_options->{device_targeting} = $campaign->{device_targeting};
    }

    if ( $PARAMS{is_new_camp} && $campaign->{mediaType} eq 'mobile_content' ) {
        $camp_options->{mobile_app_goal} = 'installs';
    }

    if ($c->login_rights->{super_control}) {
        $camp_options->{competitors_domains} = $campaign->{competitors_domains};
    }

    if ($campaign->{email_notifications} && ref($campaign->{email_notifications}) eq 'HASH') {
        $camp_options->{email_notifications} = join ',', keys %{$campaign->{email_notifications}};
    }

    # Если minus_words не заданы и выставлен флаг - не чистим их (используется в API)
    if ($PARAMS{ignore_minus_words}) {
        delete $camp_options->{minus_words};
    }

    if ($old_camp->{ManagerUID} || $old_camp->{AgencyUID}) {
        # allow pay wihout blocking for serviced camps
        $camp_options->{statusPostModerate} = 'Accepted';
    }

    if (exists $campaign->{placement_types} && ref($campaign->{placement_types}) eq 'ARRAY') {
        $camp_options->{placement_types} = join ',', @{ $campaign->{placement_types} };

        mark_placement_types_change($cid, $uid, $LogTools::context{UID}, $campaign->{placement_types}, $old_camp->{placement_types});
    }

    $camp_options->{broad_match_limit} = $campaign->{broad_match_limit} if defined $campaign->{broad_match_limit};
    $camp_options->{broad_match_goal_id} = $campaign->{broad_match_goal_id} if exists $campaign->{broad_match_goal_id};

    # ключевые цели меняем, только если их передали
    if (exists $campaign->{meaningful_goals}) {
        $camp_options->{meaningful_goals} = Direct::Model::Campaign::_serialize_meaningful_goals(
            $campaign->{meaningful_goals},
            is_allowed_to_use_value_from_metrika => $is_allowed_to_use_value_from_metrika
        );
        $strategy_values->{meaningful_goals} = $camp_options->{meaningful_goals};
    }

    # save campaign description
    if ($campaign->{use_camp_description}) {
        my $camp_description = $campaign->{camp_description};
        $camp_description = substr($camp_description, 0, $Settings::MAX_CAMPAIGN_DESCRIPTION_LENGTH) if $camp_description && length($camp_description) > $Settings::MAX_CAMPAIGN_DESCRIPTION_LENGTH;
        $camp_options->{camp_description} = $camp_description;
    }

    # Cохраняем кол-во объявлений на страницу кампании
    # пустое значение или 0 - это "оптимальное кол-во объявлений на странице"
    if (defined $campaign->{banners_per_page}) {
        $camp_options->{banners_per_page} = $campaign->{banners_per_page} =~ m/^\d+$/
                                           ? $campaign->{banners_per_page}
                                           : 0;
    }

    if (camp_kind_in(type => $campaign->{mediaType}, "web_edit_base")) {
        my $old_day_budget = $old_camp->{day_budget} || 0;
        my $new_day_budget = $campaign->{day_budget} || 0;

        # сбрасываем время остановки кампании и факт отправки уведомления, если новый дневной бюджет больше старого или вообще выключен (== ∞)
        if ( ($old_day_budget > 0 && $new_day_budget == 0) || ($new_day_budget > 0 && $old_day_budget > 0 && $new_day_budget > $old_day_budget) ) {
            $camp_options->{day_budget_stop_time} = 0;
            $camp_options->{day_budget_notification_status} = 'Ready';
        }
        # сбрасываем установленные ранее отметки о приостановке показов автобюджетом если включили дневной бюджет или переключили режим показа
        if (($old_day_budget == 0 && $new_day_budget > 0)
            ||
            ($new_day_budget > 0 && ($old_camp->{day_budget_show_mode} // '') ne $campaign->{day_budget_show_mode})
           )
        {
            reset_statusAutobudgetShow($cid);
        }
        if ($new_day_budget > 0 && $old_day_budget != $new_day_budget) {
            $camp_options->{day_budget_daily_change_count} = ($old_camp->{day_budget_daily_change_count} || 0) + 1;
        }
        if ($old_day_budget != $new_day_budget) {
            $camp_options->{day_budget_last_change} = Yandex::DateTime->now();
        }
        hash_copy $strategy_values, $camp_options, qw/day_budget_daily_change_count day_budget_last_change/;
        if ($need_to_create_new_package || $package_strategy_is_changed){
            $camp_options->{day_budget_daily_change_count} = $new_package->{day_budget_daily_change_count};
            $camp_options->{day_budget_last_change} = $new_package->{day_budget_last_change};
        }
    }

    # Если это сделочная (cpm_deals) или медийная (cpm_banner) кампании
    # с включенной фичей impression_standard_time
    # тогда использвать параметр, иначе не добавлять в хеш, чтобы он не затирал данные в БД.
    if (defined $campaign->{impression_standard_time} &&
        (any {$campaign->{mediaType} eq $_} qw/cpm_deals cpm_banner/) &&
        Client::ClientFeatures::has_impression_standard_time_feature($client_id)) {

        $camp_options->{impression_standard_time} = $campaign->{impression_standard_time};
    }

    hash_copy $camp_options, $campaign, qw/eshows_banner_rate eshows_video_rate eshows_video_type/;

    if (!$PARAMS{ignore_hierarchical_multipliers}) {
        my %params_data = (campaign_id => $cid, campaign_type => $campaign->{mediaType});
        my $multipliers = hash_cut(
            $campaign->{hierarchical_multipliers},
            HierarchicalMultipliers::get_types_allowed_on_camp()
        );
        hash_merge \%params_data, $multipliers;
        # TODO(DIRECT-99589): логировать провал вызова
        JavaIntapi::UpdateBidModifiers->new(%params_data)->call();
    }

    # Сохраним минус-слова отдельно, чтобы еще проставились нужные статусы у зависимых объектов
    MinusWords::save_campaign_minus_words($cid, $minus_words);

    do_update_table(PPC(cid => $cid), 'camp_options', $camp_options, where => {cid => $cid});
    do_update_table(PPC(cid => $cid), 'campaigns', $camp_values, where => {cid => $cid});
    $strategy_values->{attribution_model} = $camp_values->{attribution_model};
    if ($has_strategy_changes){
        $strategy_values->{LastChange__dont_quote} = 'NOW()';
    }
    if ($package_strategy_is_changed){
        my $new_package_strategy_values = {
            LastChange__dont_quote => 'NOW()'
        };
        if ($new_package->{is_public} eq 'No'){
            $new_package_strategy_values->{is_public} = 'Yes';
            $new_package_strategy_values->{name} = "Strategy ".$strategy_id." dated ".Yandex::DateTime->now()->strftime("%Y-%m-%d");
        }
        do_update_table(PPC(cid => $cid), 'strategies', $new_package_strategy_values, where => { strategy_id => $strategy_id });
        do_update_table(PPC(cid => $cid), 'strategies', {LastChange__dont_quote => 'NOW()'}, where => { strategy_id => $old_strategy_id });
    } elsif ($need_to_create_new_package){
        do_insert_into_table(PPC(cid => $cid), 'strategies', $strategy_values);
        do_update_table(PPC(cid => $cid), 'strategies', {LastChange__dont_quote => 'NOW()'}, where => { strategy_id => $old_strategy_id });
    } elsif ($strategy_id && $has_strategy_changes) {
        do_update_table(PPC(cid => $cid), 'strategies', $strategy_values, where => { strategy_id => $strategy_id });
    }

    if ($package_strategy_is_changed) {
        do_update_table(PPC(cid => $cid), 'banners', {statusBsSynced => 'No'}, where => {cid => $cid});
    }

    # параметры кампаний для рекламы мобильного контента
    if ($campaign->{mediaType} eq 'mobile_content') {
        my $campaigns_mobile_content_values = {
            cid => $cid,
            device_type_targeting => (ref $campaign->{device_type_targeting} eq 'ARRAY'
                ? join(q{,}, @{$campaign->{device_type_targeting}})
                : $campaign->{device_type_targeting}
            ),
            network_targeting => ( ref $campaign->{network_targeting} eq 'ARRAY'
                ? join(q{,}, @{$campaign->{network_targeting}})
                : $campaign->{network_targeting}
            ),
            is_installed_app => $campaign->{is_installed_app} ? 1 : 0,
            mobile_app_id => $campaign->{mobile_app_id} // 0,
        };

        do_replace_into_table(PPC(cid => $cid), 'campaigns_mobile_content', $campaigns_mobile_content_values);

        if (!$PARAMS{is_new_camp} && ($old_camp->{name}//'') ne $campaign->{name}) {
            on_campaing_name_update_resync_banners($campaign->{cid});
        }
    }

    if (($campaign->{mediaType} eq 'cpm_yndx_frontpage' || $campaign->{mediaType} eq 'cpm_price') && exists $campaign->{allowed_frontpage_types}) {
        my $allowed_frontpage_types = join ',', @{$campaign->{allowed_frontpage_types}};
        if ($PARAMS{is_new_camp}) {
            do_insert_into_table(PPC(cid => $cid), 'campaigns_cpm_yndx_frontpage', {cid => $cid, allowed_frontpage_types => $allowed_frontpage_types });
        } else {
            do_update_table(PPC(cid => $cid), 'campaigns_cpm_yndx_frontpage',
                { allowed_frontpage_types => $allowed_frontpage_types }, where => {cid => $cid});
        }
    }

    if (camp_kind_in(type => $campaign->{mediaType}, 'internal')) {
        my $campaign_internal_values = {
            cid => $cid,
            page_ids => $campaign->{page_ids},
            place_id => $campaign->{place_id},
            is_mobile => $campaign->{is_mobile},
            restriction_type => $campaign->{restriction_type},
            restriction_value => $campaign->{restriction_value} // 0
        };

        if ( $campaign->{mediaType} eq 'internal_distrib' ) {
            $campaign_internal_values->{rotation_goal_id} = $campaign->{rotation_goal_id};
        }

        do_replace_into_table(PPC(cid => $cid), 'campaigns_internal', $campaign_internal_values);
    }

    my $timeTarget_changed = ($old_camp->{timeTarget}||'') ne ($camp_values->{timeTarget}||'') || ($camp_values->{timezone_id}||0) ne ($old_camp->{timezone_id}//0);

    if ( $timeTarget_changed ) {
        schedule_forecast($cid);
    }

    # Если кампания была пустой, обновляем LastChange в баннерах
    if ( ($old_camp->{statusEmpty} // '') eq 'Yes' ) {
        if (camp_kind_in(type => $campaign->{mediaType}, "web_edit_base")) {
            do_sql(PPC(cid => $cid), "UPDATE banners b join phrases p on p.pid = b.pid SET b.LastChange=now(), p.LastChange=now() WHERE p.cid=?", $cid );
        } else {
            do_sql(PPC(cid => $cid), "UPDATE media_groups g join media_banners b on b.mgid = g.mgid SET b.LastChange=now() WHERE g.cid=?", $cid );
        }
    }

    # Если изменился язык, то необходимо перепослать все баннеры кампании.
    if ($old_camp->{OrderID} && (($old_camp->{lang} || '') ne ($campaign->{content_lang} || ''))) {
        my @to_resync = map { {cid=>$old_camp->{cid}, bid=>$_, priority=>BS::ResyncQueue::PRIORITY_CHANGE_CAMP_CONTENT_LANG} } @{get_bids(cid=>$old_camp->{cid})};
        BS::ResyncQueue::bs_resync(\@to_resync);
    }

    smartstrip($campaign->{email});

    my $user_data = get_user_data($uid, [qw/fio email/]);

    if ($user_data && scalar grep {! $user_data->{$_}} qw/fio email/) {

        create_update_user( $uid,  { fio => $campaign->{fio}, email => $campaign->{email}, valid => $valid } );

    }

    if (!$PARAMS{is_new_camp} && str($campaign->{name}) ne str($old_camp->{name})) {
        BalanceQueue::add_to_balance_info_queue($c->UID, 'cid', $cid, BalanceQueue::PRIORITY_CAMP_ON_CHANGED_NAME);
    }

    return $old_camp;
}

=head2 on_campaing_name_update_resync_banners($cid)

    При изменении имени кампании, перепосылаем все ее объявления в БК
    Реализовано только для РМП кампаний

    https://st.yandex-team.ru/DIRECT-78409

=cut

sub on_campaing_name_update_resync_banners {
    my $cid = shift;

    my $banner_hrefs = get_all_sql(PPC(cid => $cid), ["SELECT bid, href FROM banners", where => {cid => $cid}]);
    my @bids_to_resync = map { $_->{bid} } grep {
        $_->{href} =~ /\{campaign_?name(_?lat)?\}/
    } @$banner_hrefs;

    return unless @bids_to_resync;

    my @to_resync = map { {cid => $cid, bid => $_, priority=>BS::ResyncQueue::PRIORITY_MOBILE_ADS_ON_CAMP_NAME_UPDATE} } @bids_to_resync;

    BS::ResyncQueue::bs_resync(\@to_resync);

    return;
}

# --------------------------------------------------------------------

=head2 save_day_budget

Сохранение дневного бюджета
    $new_camp, $old_camp - структуры кампаний

=cut

sub save_day_budget($$$$$) {
    my ($new_camp, $old_camp, $UID, $uid, $cid) = @_;

    my $strategy_id = $old_camp->{strategy_id} || 0;
    my $old_day_budget = $old_camp->{day_budget} || 0;
    my $old_day_budget_show_mode = $old_camp->{day_budget_show_mode} // '';
    my $old_day_budget_daily_change_count = $old_camp->{day_budget_daily_change_count} || 0;
    #может прийти из API DIRECT-108938
    if (ref($old_camp->{day_budget}) eq 'HASH' && $old_camp->{day_budget}) {
        $old_day_budget = $old_camp->{day_budget}{sum} || 0;
        $old_day_budget_show_mode = $old_camp->{day_budget}{show_mode} // '';
        $old_day_budget_daily_change_count = $old_camp->{day_budget}{daily_change_count} || 0;
    }
    if ($old_day_budget != ($new_camp->{day_budget} || 0) || str($new_camp->{day_budget_show_mode}) ne str($old_day_budget_show_mode)) {
        my $old_day_budget_text = $old_day_budget > 0 ? "$old_day_budget:$old_camp->{currency}" : 0;
        my $new_day_budget_text = $new_camp->{day_budget} > 0 ? "$new_camp->{day_budget}:$old_camp->{currency}" : 0;
        mail_notification('camp', 'c_day_budget_multicurrency', $cid, $old_day_budget_text, $new_day_budget_text, $uid);

        # Сохраняем фейковую запись в логи об изменении дневного бюджета
        log_cmd({
            cmd => '_save_day_budget',
            cid => $cid,
            UID => $UID,
            uid => $uid,
            old_day_budget => $old_day_budget,
            currency => $old_camp->{currency},
            new_day_budget => $new_camp->{day_budget} || 0,
        });

        my $camp_values = {
            day_budget => $new_camp->{day_budget},
            day_budget_show_mode => $new_camp->{day_budget_show_mode},
            statusBsSynced => 'No',
            LastChange__dont_quote => 'NOW()'
        };

        my $strategy_values = {
            day_budget => $new_camp->{day_budget},
            day_budget_show_mode => $new_camp->{day_budget_show_mode},
            LastChange__dont_quote => 'NOW()'
        };

        do_update_table(PPC(cid => $cid), 'campaigns', $camp_values, where => {cid => $cid, uid => $uid});

        my $new_day_budget = $new_camp->{day_budget} || 0;

        # сбрасываем время остановки кампании и факт отправки уведомления, если новый дневной бюджет больше старого или вообще выключен (== ∞)
        my $camp_options = {};

        if (($old_day_budget > 0 && $new_day_budget == 0)
            ||
            ($new_day_budget > 0 && $old_day_budget > 0 && $new_day_budget > $old_day_budget)
        )
        {
            my $reset_stop_time = 1;
            if ($new_day_budget > 0 && $old_camp->{day_budget_stop_time} !~ /^0000/ && $old_camp->{type} && $old_camp->{OrderID}) {
                my $spent_today;
                if ($old_camp->{type} eq 'wallet') {
                    $spent_today = WalletUtils::get_wallet_spent_today($cid);
                } else {
                    $spent_today = Stat::OrderStatDay::get_order_spent_today($old_camp->{OrderID});
                }
                if ($spent_today >= $new_day_budget) {
                    $reset_stop_time = 0;
                }
            }
            if ($reset_stop_time) {
                $camp_options->{day_budget_stop_time} = 0;
                $camp_options->{day_budget_notification_status} = 'Ready';
            }
        }
        if (($old_camp->{type} // '') eq 'wallet') {
            AutobudgetAlerts::update_on_wallet_day_budget_change($cid, $old_day_budget, $new_day_budget);
        }

        # сбрасываем установленные ранее отметки о приостановке показов автобюджетом если включили дневной бюджет или переключили режим показа
        if (($old_day_budget == 0 && $new_day_budget > 0)
            ||
            ($new_day_budget > 0 && $old_day_budget_show_mode ne $new_camp->{day_budget_show_mode})
        )
        {
            reset_statusAutobudgetShow($cid, is_wallet => (($old_camp->{type} // '') eq 'wallet' ? 1 : 0));
        }
        if ($new_day_budget > 0 && $old_day_budget != $new_day_budget) {
            $camp_options->{day_budget_daily_change_count} = $old_day_budget_daily_change_count + 1;
            $strategy_values->{day_budget_daily_change_count} = $camp_options->{day_budget_daily_change_count};
        }

        $camp_options->{day_budget_last_change} = Yandex::DateTime->now();
        $strategy_values->{day_budget_last_change} = Yandex::DateTime->now();
        do_update_table(PPC(cid => $cid), 'camp_options', $camp_options, where => {cid => $cid}) if %$camp_options;
        my $client_id = get_clientid(uid => $uid);
        if ($strategy_id){
            do_update_table(PPC(cid => $cid), 'strategies', $strategy_values, where => {strategy_id => $strategy_id});
        }
    }
}

# --------------------------------------------------------------------

=head2 campaign_manager_changed

 функция вызывается после смены менеджера на кампании
 ManagerUID = 0 - кампанию рассервисировали

 Перенесен в  CampaignTools, Campaign::campaign_manager_changed оставлен для совместимости

=cut

sub campaign_manager_changed {
        return CampaignTools::campaign_manager_changed(@_);
}

=head2 is_ctx_price_correction_allowed
    Возвращает флаг допустимости задания price_context при данной стратегии
=cut

sub is_ctx_price_correction_allowed {
    my ($strategy) = @_;

    return ($strategy->{name} || '') eq 'different_places' && !$strategy->{is_net_stop};
}

=head2 campaign_strategy_changed($new_camp, $old_camp)

    Действия при изменения стратегии на кампанию

 Что и когда может произойти при смене стратегии:
 * при переходе с ручной на авто: сохранение ручных ставок (save_manual_prices)
   * сохраняются ставки с учетом текущей стратегии. например, для стратегии "только в сети" сохраняется только price_context

 * при переходе с авто на ручную:
   * восстановление ручных ставок (restore_manual_prices)
   * установка умолчальных значений (_set_phrases_initial_prices)
     * происходит пересчет price с учетом context_price_coef
     * делается запрос в bs_auction и ставится ставка guarantee+30%
   * копирование цены с сети на поиск (_set_phrases_initial_prices)
     - также происходит при переходе "ручная/сеть" на "ручная/(везде|поиск)"
     - цена копируется только в том случае, если текущий price равен 0, нужно сохранять этот инвариант при смене стратегий


=cut
sub campaign_strategy_changed {

    my ($new, $old) = @_;

    my $new_strategy = $new->{strategy}->{name} || $new->{strategy}->{search}->{name};
    my $old_strategy = $old->{strategy}->{name} || $old->{strategy}->{search}->{name};
    my $cid = $old->{cid};

    my $currency = $old->{currency};
    die 'no currency given' unless $currency;
    my $camp_type = $old->{mediaType};
    my $is_cpm_campaign = is_cpm_campaign($camp_type);

    my ($min_price, $max_price);
    if ($camp_type eq 'cpm_yndx_frontpage') {
        $min_price = get_min_price($currency, $new->{geo}, $new->{allowed_frontpage_types}, $new->{ClientID});
        $max_price = get_currency_constant($currency,'MAX_CPM_PRICE');
    } else {
        $min_price = get_currency_constant($currency, $is_cpm_campaign ? 'MIN_CPM_PRICE' : 'MIN_PRICE');
        $max_price = get_currency_constant($currency, $is_cpm_campaign ? 'MAX_CPM_PRICE' : 'MAX_PRICE');
    }
    my $default_price = 0 + get_currency_constant($currency, 'DEFAULT_PRICE');
    my $min_price_quoted = sql_quote($min_price);
    my $max_price_quoted = sql_quote($max_price);

    my $is_autobudget_new = any {$new->{strategy}->{$_}->{name} =~ /autobudget/} qw/net search/;
    my $is_autobudget_old = any {$old->{strategy}->{$_}->{name} =~ /autobudget/} qw/net search/;
    my $is_different_places_new = $new_strategy eq 'different_places';
    my $is_ctx_price_correction_allowed = is_ctx_price_correction_allowed($new->{strategy});

    my $has_extended_relevance_match = has_context_relevance_match_feature($camp_type, $new->{ClientID});
    my $is_stop_changed = any {($old->{strategy}->{$_}->{name} // '') eq 'stop' && ($new->{$_}->{name} // '') ne 'stop' }
        qw/net search/;
    my $bids_to_reset = {};
    if (!$is_autobudget_new && $is_autobudget_old) {
        # уходим с автобюджета на ручное управление ставками
        unless (is_media_camp(cid => $cid)) {
            my $restore_result = restore_manual_prices($cid);
            $bids_to_reset = {
                map { $_ => 1 } @{$restore_result->{bid_ids_no_manual_prices}},
            };
        }
        do_delete_from_table(PPC(cid => $cid), 'autobudget_forecast', where => {cid => $cid});
    }

    # Для перфоманса при переходе на ROI просто выставим autobudgetPriority на фильтрах в значение по умолчанию
    if ($camp_type eq 'performance') {
        if ($new->{strategy}->{net}->{name} eq 'autobudget_roi') {
            do_sql(PPC(cid => $cid), q{
                UPDATE bids_performance bperf JOIN phrases p USING (pid)
                SET bperf.statusBsSynced = 'No', bperf.autobudgetPriority = 3
                WHERE bperf.autobudgetPriority IS NULL AND p.cid = ?
            }, $cid);
        }
    }

    # обновляем ставки, если переходим на автобюджет с неавтобюджетной стратегии ИЛИ
    # если переходим с поискового автобюджета на контекстный или наоборот
    if (($is_autobudget_new && !$is_autobudget_old) ||
        ($is_autobudget_new && ( $is_different_places_new || $old_strategy eq 'different_places') && $new_strategy ne $old_strategy)) {

        schedule_forecast($cid);

        # включаем автобюджет и сбрасываем установленные ранее отметки о приостановке показов,
        # если переходим на автобюджет с неавтобюджетной стратегии
        unless ($is_autobudget_old) {
            save_manual_prices($cid);
            reset_statusAutobudgetShow($cid);
        }

        my $price_cond;
        if ($is_cpm_campaign) {
            $price_cond = 0;
        } else {
            # оставляем текущие цены, ограниченные сверху максимальной ставкой автобюджета, а снизу минимальной ставкой
            # в дальнейшем автобюджет их подкорректирует
            $price_cond = "GREATEST(IF(price>0, price, $default_price), $min_price_quoted)";
            if ($new->{strategy}{search}{bid} && $new->{strategy}{search}{bid} > 0) {
                $price_cond = "LEAST($price_cond, " . sql_quote($new->{strategy}{search}{bid}) . ')';
            }
            $price_cond = sprintf 'LEAST(%s, %s)', $price_cond, $max_price_quoted;
            $price_cond = "IF(price > 0, $price_cond, 0)";
        }
        my $price_context_cond = "GREATEST(IF(price_context>0, price_context, $default_price), $min_price_quoted)";
        if ($new->{strategy}{net}{bid} && $new->{strategy}{net}{bid} > 0) {
            $price_context_cond = "LEAST($price_context_cond, " . sql_quote($new->{strategy}{net}{bid}) . ')';
        }
        $price_context_cond = sprintf 'LEAST(%s, %s)', $price_context_cond, $max_price_quoted;
        $price_context_cond = "IF(price_context > 0, $price_context_cond, 0)";

        my $bids_to_be_updated = get_all_sql(PPC(cid => $cid), ["
            SELECT id, pid, $price_cond AS new_price, $price_context_cond AS new_price_context
            FROM bids
            WHERE (
                price <> $price_cond OR price_context <> $price_context_cond
            )
            AND", {cid => $cid}]);
        if ($bids_to_be_updated && @$bids_to_be_updated) {
            my (@ids, @log);
            for my $row(@$bids_to_be_updated) {
                push @log, {
                    cid => $cid, pid => $row->{pid},
                    id => $row->{id}, type => 'autobudget_setup',
                    price => $row->{new_price},
                    price_ctx => $row->{new_price_context},
                    currency    => $currency,
                };
                push @ids, $row->{id};
            }
            LogTools::log_price(\@log);
            do_update_table(PPC(cid => $cid),
                bids => {
                    statusBsSynced => 'No',
                    price__dont_quote => $price_cond,
                    price_context__dont_quote => $price_context_cond,
                },
                where => {cid => $cid, id => \@ids},
            );
        }
        do_update_table(PPC(cid => $cid), 'bids', { autobudgetPriority => 3 }, where => { cid => $cid, autobudgetPriority__is_null => 1 });
        # Так же выставляем autobudgetPriority для беcфразного таргетинга (исключая удаленный)
        do_update_table(PPC(cid => $cid), 'bids_base', { autobudgetPriority => 3 }, where => { cid => $cid, autobudgetPriority__is_null => 1, bid_type__ne => 'keyword', _TEXT => 'NOT FIND_IN_SET("deleted", opts)'});

        do_insert_into_table(PPC(cid => $cid), 'autobudget_forecast', {
            cid => $cid,
            autobudgetForecastDate => undef,
            autobudgetForecast => 0,
            autobudgetForecastClicks => 0,
            statusAutobudgetForecast => 'New'
        }, on_duplicate_key_update => 1, key => ['cid']);
    }

    if (!$is_autobudget_new) {
        my %set_phrases_initial_prices_options;
        if ($is_different_places_new) {
            $set_phrases_initial_prices_options{set_price_context} = 1;
            $set_phrases_initial_prices_options{context_price_coef} = $new->{ContextPriceCoef};

            # при переключении с автостратегии на ручную, если есть ограничение цены клика в сети, пересчитываем
            # ставки в сети относительно ставки на поиске: DIRECT-70107
            if ($is_autobudget_old && $new->{ContextPriceCoef} != 100) {
                $set_phrases_initial_prices_options{recalc_price_context} = 1;
            }
        }

        if( (all { $_ eq 'default' } ($new_strategy, $old_strategy))
                && !$new->{strategy}->{is_search_stop}
                && !$new->{strategy}->{is_net_stop}
                && !$is_different_places_new)
        {
            $set_phrases_initial_prices_options{set_min_price_context} = 1;
        }

        # если кампания создаётся с отключенным поиском, то в ней нет цен на поиске. выставляем их
        if (!$new->{strategy}->{is_search_stop} && ($is_autobudget_old || $old->{strategy}->{is_search_stop})) {
            $set_phrases_initial_prices_options{set_price} = 1;
        }

        if (%set_phrases_initial_prices_options) {
            _set_phrases_initial_prices($cid, $currency, %set_phrases_initial_prices_options, bids_to_reset => $bids_to_reset);
        }
        # переход на поисковую стратегию со статегии "неависимое управление"
        if (!$is_different_places_new && ($old_strategy eq 'different_places' || $is_autobudget_old)) {
            reset_price_context($cid);
        }
    }

    # Для ретаргетинга и автотаргетинга: поправим нулевые ставки при переходе с автобюджета на ручное управление
    if (!$is_autobudget_new && $is_autobudget_old) {
        my $price_context_cond = "LEAST(GREATEST(price_context, $min_price_quoted), $max_price_quoted)";
        my $bids_ret_to_be_updated = get_all_sql(PPC(cid => $cid), [
                "SELECT br.ret_id, br.pid, $price_context_cond AS new_price_context
                FROM phrases g
                JOIN bids_retargeting br ON (br.pid = g.pid)",
                WHERE => {
                    'g.cid' => $cid,
                    'g.adgroup_type' => [qw/base mobile_content/],
                    'br.price_context__ne__dont_quote' => $price_context_cond,
                },
            ]);
        if (@$bids_ret_to_be_updated) {
            my (@ids, @log);
            for my $row (@$bids_ret_to_be_updated) {
                push @log, {
                    cid       => $cid,
                    pid       => $row->{pid},
                    type      => 'update_zero_context_prices',
                    id        => $row->{ret_id},
                    price     => 0,
                    price_ctx => $row->{new_price_context},
                    currency  => $currency,
                };
                push @ids, $row->{ret_id};
            }
            LogTools::log_price(\@log);
            do_update_table(PPC(cid => $cid), 'bids_retargeting', {
                price_context__dont_quote => $price_context_cond,
            }, where => {ret_id => \@ids});
        }

        do_update_table(PPC(cid => $cid), 'bids_retargeting', {
            statusBsSynced => 'No',
            }, where => {cid => $cid}
        );

        if ($is_cpm_campaign) { # в кампаниях охватного продукта для фраз и ретаргетингов без ставки проставляем среднюю цену за тыс показов из автобюджетной стратегии
            my $avg_cpm = $old->{strategy}{net}{avg_cpm} // $min_price_quoted;
            my $price_context_cond = "LEAST(GREATEST(IF(price_context>0, price_context, $avg_cpm), $min_price_quoted), $max_price_quoted)";
            my $bids_to_be_updated = get_all_sql(PPC(cid => $cid), [
                "SELECT b.id, b.pid, $price_context_cond AS new_price_context
                FROM phrases g
                JOIN bids b ON (b.pid = g.pid)",
                WHERE => {
                    'g.cid' => $cid,
                    'g.adgroup_type' => 'cpm_banner',
                    'b.price_context__ne__dont_quote' => $price_context_cond,
                },
            ]);
            if (@$bids_to_be_updated) {
                my (@ids, @log);
                for my $row (@$bids_to_be_updated) {
                    push @log, {
                        cid       => $cid,
                        pid       => $row->{pid},
                        type      => 'update_zero_context_prices',
                        id        => $row->{id},
                        price     => 0,
                        price_ctx => $row->{new_price_context},
                        currency  => $currency,
                    };
                    push @ids, $row->{id};
                }
                LogTools::log_price(\@log);
                do_update_table(PPC(cid => $cid), 'bids', {
                    statusBsSynced => 'No',
                    price_context__dont_quote => $price_context_cond,
                }, where => {id => \@ids});
            }

            my $bids_ret_to_be_updated = get_all_sql(PPC(cid => $cid), [
                "SELECT br.ret_id, br.pid, $price_context_cond AS new_price_context
                FROM phrases g
                JOIN bids_retargeting br ON (br.pid = g.pid)",
                WHERE => {
                    'g.cid' => $cid,
                    'g.adgroup_type' => [ 'cpm_banner', 'cpm_video', 'cpm_outdoor', 'cpm_yndx_frontpage', 'cpm_indoor', 'cpm_audio' ],
                    'br.price_context__ne__dont_quote' => $price_context_cond,
                },
            ]);
            if (@$bids_ret_to_be_updated) {
                my (@ids, @log);
                for my $row (@$bids_ret_to_be_updated) {
                    push @log, {
                        cid       => $cid,
                        pid       => $row->{pid},
                        type      => 'update_zero_context_prices',
                        id        => $row->{ret_id},
                        price     => 0,
                        price_ctx => $row->{new_price_context},
                        currency  => $currency,
                    };
                    push @ids, $row->{ret_id};
                }
                LogTools::log_price(\@log);
                do_update_table(PPC(cid => $cid), 'bids_retargeting', {
                    statusBsSynced => 'No',
                    price_context__dont_quote => $price_context_cond,
                }, where => {ret_id => \@ids});
            }
        }

        # Для автотаргетинга: сбросим статус синхронизации ставок, невалидные ставки пересчитаем
        _relevance_match_bids_resync_and_fix($cid, $currency, $is_cpm_campaign, $is_ctx_price_correction_allowed, $has_extended_relevance_match, $new->{ContextPriceCoef});
    }
    elsif(($is_different_places_new && $old_strategy ne 'different_places') || $is_stop_changed){
        #при включении независимого управления проверим и пересчитаем невалидные ставки и если раньше была ручная стратегия
        _relevance_match_bids_resync_and_fix($cid, $currency, $is_cpm_campaign, $is_ctx_price_correction_allowed, $has_extended_relevance_match, $new->{ContextPriceCoef});
    }

    # Для условий нацеливания: проверим и, если нужно, поправим ставки или приоритет автобюджета
    if (!$is_autobudget_new) {
        my $price_cond = $new->{strategy}->{search}->{name} ne 'stop'
            ? "LEAST(GREATEST(IF(price + price_context > 0, IF(price = 0, price_context, price), $default_price), $min_price_quoted), $max_price_quoted)"
            : "price";
        # Зануляем ставки на сети до решения DIRECT-42984
        my $context_price_coef = $old->{ContextPriceCoef} // 0;
        my $price_context_cond = $new->{strategy}->{name} eq 'different_places' && $new->{strategy}->{net}->{name} ne 'stop'
            ? "LEAST(GREATEST(IF(price_context = 0, IF (price > 0, CEIL(price * $context_price_coef) / 100, $default_price), price_context), $min_price_quoted), $max_price_quoted)"
            : "0";

        my $dynamic_adgroup_ids = get_one_column_sql(PPC(cid => $cid), "SELECT pid FROM phrases WHERE adgroup_type = 'dynamic' AND cid = ?", $cid);
        my $bids_dynamic_to_be_updated = get_all_sql(PPC(cid => $cid), ["
            SELECT dyn_id, pid, $price_cond AS new_price, $price_context_cond AS new_price_context
            FROM bids_dynamic
            WHERE (price <> $price_cond OR price_context <> $price_context_cond) AND", {pid => $dynamic_adgroup_ids}]);
        if (@$bids_dynamic_to_be_updated) {
            my (%new_prices, @log);
            for my $row(@$bids_dynamic_to_be_updated) {
                push @log, {
                    cid       => $cid,
                    pid       => $row->{pid},
                    type      => 'update2',
                    id        => $row->{dyn_id},
                    price     => $row->{new_price},
                    price_ctx => $row->{new_price_context},
                    currency  => $currency,
                };
                $new_prices{$row->{dyn_id}} = {
                    price => $row->{new_price},
                    price_context => $row->{new_price_context},
                };
            }
            LogTools::log_price(\@log);

            for my $ids_chunk (chunks([keys %new_prices], 3_000)) {
                do_update_table(PPC(cid => $cid), 'bids_dynamic', {
                    statusBsSynced => 'No',
                    price__dont_quote => sql_case('dyn_id', {
                            map {$_ => $new_prices{$_}{price}}
                            grep {defined $new_prices{$_}{price}} @$ids_chunk
                        }, default__dont_quote => 'price'),
                    price_context__dont_quote => sql_case('dyn_id', {
                            map {$_ => $new_prices{$_}{price_context}}
                            grep {defined $new_prices{$_}{price_context}} @$ids_chunk
                        }, default__dont_quote => 'price_context'),
                }, where => {
                    dyn_id => $ids_chunk,
                });
            }
        }
    } else {
        do_sql(PPC(cid => $cid), q{
            UPDATE bids_dynamic bd JOIN phrases p USING (pid)
            SET bd.statusBsSynced = 'No', bd.autobudgetPriority = 3
            WHERE bd.autobudgetPriority IS NULL AND p.cid = ?
        }, $cid);
    }

    return;
}

=head2 reset_price_context($cid)

    Обнулить ставки на сеть (далее будут расчитываться в процентах от поисковой ставки).
    Выполняется при переходе со стратегии независимое размещение на поисковую стратегию.
    Не изменяются ставки для сети у фраз, у которых отключены показы на поиске.

=cut

sub reset_price_context {
    my ($cid) = @_;

    my $banners;
    ($banners) = get_banners({
        cid => $cid
        , adgroup_types => ["base", "mobile_content"]
    });
    my (@zero_bids, @log);
    foreach my $banner (@$banners) {
        foreach my $phrase (@{$banner->{phrases}}, @{$banner->{relevance_match} // []}) {

            push @zero_bids, $phrase->{id} // $phrase->{bid_id};
            push @log, {
                cid => $cid, bid => $banner->{bid}, pid => $banner->{pid},
                id => $phrase->{id} // $phrase->{bid_id}, type => 'update2',
                price => $phrase->{price},
                price_ctx => 0,
                currency    => $banner->{currency},
            }
        }
    }
    LogTools::log_price(\@log);
    while (my @bids = splice @zero_bids, 0, 3000) {
        do_update_table(PPC(cid => $cid), 'bids', {
            warn => 'Yes',
            statusBsSynced => 'No',
            price_context => 0
        }, where => {id => \@bids});
    }
}

=head2 _set_phrases_initial_prices

    Установка начальных цен на поиске и в сети

    В сети:
    Используется для единичной установки цен(например при переходе
    к стратегии "независимое управление")

    На поиске:
    Установка первоначальных поисковых цен на фразы для которых цена не задавалась ни разу.
    (Кампания с изначально отключенной поисковой стратегией)
    Заменяет во всей кампании нулевые ставки на поиске на цену 1-го места + 30% (DIRECT-13851)

    _set_phrases_initial_prices(
        $cid, $currency, set_price => 1, set_price_context => 1, context_price_coef => 70
    );

    Именованные параметры
        set_price => 1/0                    - инициализировать нулевые ставки в поиске на умолчальные
        set_price_context => 1/0            - инициализировать нулевые ставки в сетях на умолчальные
        set_min_price_context => 1/0        - установить минимальную ставку в сетях
        context_price_coef => 10..100       - ограничение ставки в сетях относительно поисковой, в процентах
        recalc_price_context => 1/0         - пересчитать все ставки в сетях и явно выставить их в базе
        bids_to_reset => { bid_id => 1, }   - хеш с id ставок, которые нужно сбросить в умолчальные

=cut

sub _set_phrases_initial_prices {
    my ($cid, $currency, %O) = @_;

    my @or_conditions;
    if (!$O{recalc_price_context}) {
        if ($O{set_price}) {
            push @or_conditions, ('b.price' => 0);
        }
        if ($O{set_price_context}) {
            push @or_conditions, ('b.price_context' => 0);
        }
    }

    unless ($O{set_price} || $O{set_price_context} || $O{set_min_price_context}) {
        return;
    }

    my $bids_to_reset = $O{bids_to_reset};
    if (%$bids_to_reset && @or_conditions) {
        my @ids_to_reset = keys %$bids_to_reset;
        if (@ids_to_reset < 1000) {
            push @or_conditions, ('b.id' => \@ids_to_reset);
        } else {
            @or_conditions = ();
        }
    }

    my %phrase_filters = (
        (@or_conditions ? (_OR => \@or_conditions) : ()),
    );

    my $banners;
    ($banners, undef) = get_banners({
        cid => $cid
        , adgroup_types => ["base", "mobile_content", 'mcbanner', 'content_promotion']
    }, {
        get_all_phrases => 1,
        get_auction => 1,
        no_pokazometer_data => 1,
        get_add_camp_options => (($O{set_price}) ? 1 : 0),
        phrase_filters => \%phrase_filters,
    });

    my $min_price_constant = get_currency_constant($currency, 'MIN_PRICE');
    my $default_price = get_currency_constant($currency, 'DEFAULT_PRICE');
    my $min_image_price_constant = get_currency_constant($currency, 'MIN_IMAGE_PRICE');

    my (%new_prices, @log);
    foreach my $banner (@$banners) {
        foreach my $phrase (@{$banner->{phrases}}) {
            my $bid_id = $phrase->{id};
            my $price = 0 + ($phrase->{price} || 0);
            my $price_context = 0 + ($phrase->{price_context} || 0);

            if ($bids_to_reset->{$bid_id}) {
                $price = $price_context = 0;
                $new_prices{$bid_id}{price} = 0;
                $new_prices{$bid_id}{price_context} = 0;
            }

            my $old_price = $price;
            my $old_price_context = $price_context;

            if ($O{set_price} && $price < $min_image_price_constant && $banner->{adgroup_type} eq 'mcbanner') {
                # https://st.yandex-team.ru/DIRECT-69662#1503574623000
                $price = $min_image_price_constant;
                $new_prices{$bid_id}{price} = $price;
            }
            if ($O{set_price} && $price < $min_price_constant) {
                # если на поиске нет ставки, а в сетях она есть, копируем ставку с сети
                if ($price_context >= $min_price_constant) {
                    $price = $price_context;
                } else {
                    # DIRECT-66663 Прогноз первого места в Гарантии + 30%
                    my $guarantee = ($phrase->{bs_data_exists} ? (PlacePrice::get_bid_price_by_place($phrase, $PlacePrice::PLACES{GUARANTEE1}) // 0) : 0) / 1e6 * 1.3;
                    # если статистики по фразе нет то выставляется ставка по умолчанию
                    my $new_price = $guarantee || $default_price;
                    $price = currency_price_rounding($new_price, $currency);
                }
                $new_prices{$bid_id}{price} = $price;
            }

            if ($O{set_min_price_context} && $price_context < $min_price_constant) {
                $new_prices{$bid_id}{price_context} = $min_price_constant;
            } elsif ($O{set_price_context} && $O{recalc_price_context} && $price && $old_price_context >= $min_price_constant) {
                $price_context = PhrasePrice::phrase_price_context($price, $O{context_price_coef}, $currency);
                $price_context = max($price_context, get_currency_constant($currency, 'MIN_PRICE'));
                $price_context = min($price_context, get_currency_constant($currency, 'MAX_PRICE'));
                $new_prices{$bid_id}{price_context} = $price_context;
            } elsif ($O{set_price_context} && $price_context < $min_price_constant) {
                # если выставляем начальные цены и для поиска, и для сети, то в сети должна быть умолчальная ставка
                $price_context = $old_price == 0
                                  ? $default_price
                                  : PhrasePrice::phrase_price_context($price, $O{context_price_coef}, $currency);
                $price_context = max($price_context, get_currency_constant($currency, 'MIN_PRICE'));
                $price_context = min($price_context, get_currency_constant($currency, 'MAX_PRICE'));
                $new_prices{$bid_id}{price_context} = $price_context;
            }

            push @log, {
                cid => $cid,
                bid => $banner->{bid}, pid => $banner->{pid},
                id => $bid_id, type => 'set_initial_prices',
                price => $price,
                price_ctx => $price_context,
                currency    => $banner->{currency},
            };
        }
    }

    for my $ids_chunk (chunks([keys %new_prices], 3_000)) {
        do_update_table(PPC(cid => $cid), 'bids', {
            warn => 'Yes',
            statusBsSynced => 'No',
            price__dont_quote => sql_case('id', {
                    map {$_ => $new_prices{$_}{price}}
                    grep {defined $new_prices{$_}{price}} @$ids_chunk
                }, default__dont_quote => 'price'),
            price_context__dont_quote => sql_case('id', {
                    map {$_ => $new_prices{$_}{price_context}}
                    grep {defined $new_prices{$_}{price_context}} @$ids_chunk
                }, default__dont_quote => 'price_context'),
        }, where => {
            id => $ids_chunk,
        });
    }

    LogTools::log_price(\@log);
}

=head2 _relevance_match_bids_resync_and_fix($cid, $currency, $is_cpm_campaign, $is_different_places_new, $has_extended_relevance_match)

    Проверить ставки автотаргетинга при смене стратегии с автобюджетной на ручную:
      - если ставки не выходят за пределы допустимых, сбрасываем им статус синхронизации
      - если выходят, то пересчитать ставки по какому-то перцентилю от ставок на ключевых фразах


=cut
sub _relevance_match_bids_resync_and_fix {
    my ($cid, $currency, $is_cpm_campaign, $is_ctx_price_correction_allowed, $has_extended_relevance_match, $context_price_coef, %opts) = @_;

    my $force_price_context_rewriting = $opts{rewrite_price_context} ? 1 : 0;

    my $default_price = get_currency_constant($currency, 'DEFAULT_PRICE');
    my $min_price = get_currency_constant($currency, $is_cpm_campaign ? 'MIN_CPM_PRICE' : 'MIN_PRICE');
    my $max_price = get_currency_constant($currency, $is_cpm_campaign ? 'MAX_CPM_PRICE' : 'MAX_PRICE');

    my $relevance_matches = get_all_sql(
        PPC(cid => $cid),
        [
            'SELECT b.bid_id, b.pid, b.price, b.price_context, p.bid FROM bids_base b JOIN phrases p USING(pid)',
            WHERE => [ 'b.cid' => $cid, 'b.bid_type' => [qw/relevance_match relevance_match_search/], _TEXT => 'NOT FIND_IN_SET("deleted", b.opts)' ],
        ]
    );

    my ($relevance_matches_need_price, $relevance_matches_need_price_context, $relevance_matches_only_sync) = ([],[],[]);
    foreach my $rm (@$relevance_matches){
        my $rm_need_price_correction = $rm->{price} < $min_price || $rm->{price} > $max_price;
        my $rm_need_ctx_price_correction = $has_extended_relevance_match &&
                $is_ctx_price_correction_allowed &&
                ($rm->{price_context} < $min_price || $rm->{price_context} > $max_price || $force_price_context_rewriting);
        if (!$rm_need_price_correction && !$rm_need_ctx_price_correction){
                push @$relevance_matches_only_sync, $rm;
                next;
        }
        push @$relevance_matches_need_price, $rm if $rm_need_price_correction;
        push @$relevance_matches_need_price_context, $rm if $rm_need_ctx_price_correction;
    }
    if (@$relevance_matches_only_sync) {
        LogTools::log_price(
            [ map {; {
                cid => $cid,
                bid => $_->{bid},
                pid => $_->{pid},
                id => $_->{bid_id},
                type => 'restore_manual_prices',
                price => $_->{price},
                price_ctx => $_->{price_context},
                currency => $currency
            } } @$relevance_matches_only_sync ]
        );
        do_update_table(PPC(cid => $cid), 'bids_base',
            { statusBsSynced => 'No', LastChange__dont_quote => 'LastChange' },
            where => { cid => $cid, bid_id => [ map { $_->{bid_id} } @$relevance_matches_only_sync] }
        );
    }

    unless (@$relevance_matches_need_price || @$relevance_matches_need_price_context ) {
        return;
    }

    my @relevance_match_pids = uniq map { $_->{pid} } @$relevance_matches_need_price, @$relevance_matches_need_price_context;
    my ($stat_fields, $stat_join);
    if (@$relevance_matches_need_price_context) {
        $stat_fields = 'st.clicks,';
        $stat_join   = 'LEFT JOIN bs_auction_stat st ON (b.pid = st.pid AND b.PhraseID = st.PhraseID)';
    }

    my $pids_prices_rows = get_all_sql(PPC(cid => $cid), ["
        SELECT b.pid, $stat_fields b.price, b.price_context
        FROM bids b $stat_join",
        WHERE => [
            'b.cid' => $cid,
            'b.pid' => \@relevance_match_pids,
        ]
    ]);
    my (%pid2prices, %pid2prices_and_clicks);
    foreach my $row (@$pids_prices_rows){
        push @{$pid2prices{$row->{pid}}}, $row->{price}
                if @$relevance_matches_need_price;
        push @{$pid2prices_and_clicks{$row->{pid}}}, { price => $row->{price_context} || $row->{price}, clicks => $row->{clicks}}
                if @$relevance_matches_need_price_context;
    }
    _update_relevance_match_price($cid, $currency, $default_price, $relevance_matches_need_price, \%pid2prices, 0, $context_price_coef)
        if @$relevance_matches_need_price;
    _update_relevance_match_price($cid, $currency, $default_price, $relevance_matches_need_price_context, \%pid2prices_and_clicks, 1, $context_price_coef)
        if @$relevance_matches_need_price_context;
}

sub _update_relevance_match_price {
        my ($cid, $currency, $default_price, $relevance_matches, $kw_prices, $is_ctx_price, $context_price_coef) = @_;

        return unless @$relevance_matches;

        my $field = $is_ctx_price ? 'price_context' : 'price';
        my $calc_price_method = $is_ctx_price ?
                  \&Direct::Model::BidRelevanceMatch::Helper::calc_average_price
                : \&Direct::Model::BidRelevanceMatch::Helper::calc_price;

        my (@data_for_log_price, %relevance_matches_price_data);
        for my $relevance_match (@$relevance_matches) {
            my $data = {
                cid => $cid,
                bid => $relevance_match->{bid},
                pid => $relevance_match->{pid},
                id => $relevance_match->{bid_id},
                type => 'restore_manual_prices',
                price => $relevance_match->{price},
                price_ctx => $relevance_match->{price_context},
                currency    => $currency,
            };
            if ($kw_prices->{$relevance_match->{pid}}) {
                $data->{$field} = $relevance_matches_price_data{$relevance_match->{bid_id}} = &$calc_price_method(
                    $kw_prices->{$relevance_match->{pid}},
                    $currency,
                    ($is_ctx_price ? $context_price_coef : undef )
                );
            } else {
                $data->{$field} = $default_price;
            }
            push @data_for_log_price, $data;
        }
        LogTools::log_price(\@data_for_log_price);
        for my $chunk (chunks([sort {$a <=> $b} map {$_->{bid_id}} @$relevance_matches], 5_000)) {
            do_update_table(
                PPC(cid => $cid),
                'bids_base',
                {
                    $field.'__dont_quote' => sql_case('bid_id', hash_cut(\%relevance_matches_price_data, $chunk), default => $default_price),
                    statusBsSynced => 'No',
                },
                where => {cid => $cid, bid_id => $chunk}
            );
        }

        return;
}

=head2 is_campaign_archived($cid)

    Определяет, заархивирована ли кампания с указанным идентификатором.

    Входные параметры:
    - номер кампании

    На выходе:
    - 1, если кампания архивная
    - 0, если не архивная
    - undef, если кампания не найдена или поле архивности не заполнено

=cut

sub is_campaign_archived($) {
    my ($cid) = @_;
    return are_campaigns_archived([$cid])->{$cid};
}

=head2 are_campaigns_archived($cids)

    Определяет, заархивирована ли кампания с указаннымы идентификаторами

    Входные параметры:
    - ссылка на массив с номерами кампаний

    На выходе:
    хэш cid => value, где value:
    - 1, если кампания архивная
    - 0, если не архивная
    - undef, если кампания не найдена или поле архивности не заполнено

=cut

sub are_campaigns_archived($) {
    my ($cids) = @_;

    my $archived = get_hashes_hash_sql(PPC(cid => $cids), ['SELECT cid, IF(archived="Yes", 1, 0) as camp_is_arch FROM campaigns', where => {cid => SHARD_IDS}]);
    foreach (@$cids) {
        $archived->{$_} = defined $archived->{$_} ? $archived->{$_}{camp_is_arch} : undef;
    }

    return $archived;
}

=head2 is_campaign_heavy($cid)

    Определить, является ли кампания "тяжёлой" - имеет она много фраз
    Используется при архивации для того чтобы понять, выполнять операцию в момент запроса, или в фоне

    Входные параметры:
    - номер кампании

    На выходе логическое значение

=cut

sub is_campaign_heavy($) {
    my ($cids) = @_;

    $cids = [$cids] if ref $cids ne 'ARRAY';

    my $archived = are_campaigns_archived($cids);

    my @not_found_cids = grep { !defined $archived->{$_} } @$cids;
    if (scalar @not_found_cids) {
        die "campaigns @not_found_cids not found";
    }

    my $unarc_cids = [grep { !$archived->{$_} } @$cids];
    my $arc_cids = [grep { $archived->{$_} } @$cids];

    # Определяем количество фраз в кампании
    my $bids_num = get_one_field_sql(PPC(cid => $unarc_cids), ["SELECT count(*) FROM bids", WHERE => { cid => SHARD_IDS }]) // 0;
    $bids_num += get_one_field_sql(PPC(cid => $arc_cids), ["SELECT count(*) FROM bids_arc", WHERE => { cid => SHARD_IDS }]) // 0;

    return $bids_num > $HEAVY_CAMP_BIDS_BORDER;
}

=head2 camp_delayed_arc($cid)

    Если кампания стоит в очереди на архивацию/разархивацию - функция возвращает
    arc или unarc соответственно.
    Иначе - undef

=cut

sub camp_delayed_arc($) {
    my $cids = shift;

    my $cids_search = ref $cids eq 'ARRAY' ? $cids : [$cids];
    return {} if !@$cids_search;

    my $operations = get_hashes_hash_sql(PPC(cid => $cids), [ 'SELECT cid, operation FROM camp_operations_queue', where => { cid => SHARD_IDS } ] );

    my $result;
    foreach my $cid (@$cids_search) {
        $result->{$cid} = ! $operations->{$cid} || $operations->{$cid}{operation} !~ /^(?:arc|unarc)$/ ? undef : $operations->{$cid}{operation} ;
    }

    if (ref $cids eq 'ARRAY') {
        return $result;
    } else {
        return $result->{$cids};
    }
}

=head2 is_all_money_transfer_available($camp)

    Определяет, доступен ли перенос всех денег с кампании

=cut

sub is_all_money_transfer_available
{
    my $camp = shift;

    confess "invalid param: \$camp" unless ref($camp) eq 'HASH';

    my $stopping =
        $camp->{statusShow} eq 'No' &&
        check_mysql_date($camp->{stopTime}) &&
        (time - mysql2unix($camp->{stopTime})) < $Settings::TRANSFER_DELAY_AFTER_STOP
    ;
    my $type = $camp->{mediaType} || $camp->{type};
    my $finished = !$type || camp_kind_in(type => $type, "web_edit_base") ? is_campaign_finished(cid => $camp->{cid}, finish_time => $camp->{finish_time}) : 0;

    if (
        ($camp->{statusShow} eq 'No' && !$stopping) ||
        $camp->{statusModerate} eq 'New' ||
        $finished ||
        ($camp->{statusModerate} eq 'No' && $camp->{statusActive} eq 'No') ||
        camp_kind_in(type => $type, "billing_aggregate")
    ) {
        # Кампания полностью остановлена, черновик, или отклонена на модерации, и не активна в крутилке
        return 1;
    }

    # Вероятно, кампания еще показывается в БК
    return 0;
}

=head2 has_camp_weekly_autobudget($campaign)

    Определяет задан ли у кампании недельный бюджет

=cut

sub has_camp_weekly_autobudget {
    my ($camp) = @_;

    return undef unless defined $camp;

    return ($camp->{autobudget} eq 'Yes' && $camp->{strategy_decoded}->{sum} && $camp->{statusBsSynced} eq 'Yes') ? 1 : 0;
}

=head2 get_camp_min_rest($cid, %O)

    Получить минимально возможный остаток на кампании (чтобы хватило на $TRANSFER_DELAY_AFTER_STOP секунд)
    В случае наличия стратегии с указанным недельным бюджетом, прогноз считаем по формуле:
    недельная ставка/количество получасов в неделю, в противном случае считаем грубый прогноз

    Для мультивалютных кампаний минимальный остаток на кампании возвращается без НДС.

    Именованные параметры:
      forecast => если передано значение - прогноз не вычисляем и используем переданное значение (прогноз на день)
      only_forecast => вернуть только прогноз, без учета MIN_TRANSFER_MONEY
      dont_round => не округлять возвращяемое значение

=cut

sub get_camp_min_rest {
    my ($cid, %O) = @_;

    my $forecast = 0;

    my $camp_info = $O{camp_info} || get_camp_info($cid, undef, short => 1);

    # для кампании общего счета прогноза нет и минимальный остаток всегда = 0
    return 0 if camp_kind_in(type => $camp_info->{mediaType} || $camp_info->{type}, "wallet");

    my $currency = $camp_info->{currency};

    if (has_camp_weekly_autobudget($camp_info)) {
        my $SECONDS_IN_WEEK = 7 * 24 * 60 * 60;
        $forecast = $Settings::TRANSFER_DELAY_AFTER_STOP * $camp_info->{strategy_decoded}->{sum} / $SECONDS_IN_WEEK;
    } else {
        if ($camp_info->{platform} eq 'context') {
            $forecast = $O{forecast} || get_max_bid($camp_info->{cid}, $currency)->{price_context};
        } else {
            # определяем максимальный прогноз за последние $interval секунд
            my $day_forecast;

            if (defined $O{forecast}) {
                $day_forecast = $O{forecast};
            } else {
                $day_forecast = Stat::OrderStatDay::get_camp_bsstat_forecast([$cid], $currency)->{$cid};
            }

            $forecast = $Settings::TRANSFER_DELAY_AFTER_STOP * $day_forecast / 24 / 3600;
        }

        # если задан дневной бюджет и кампания синхронизировалась с БК, даём переносить деньги сверх дневного бюджета
        if ($camp_info->{statusBsSynced} eq 'Yes' && $camp_info->{day_budget} && $camp_info->{day_budget} > 0) {
            $forecast = min($forecast, $camp_info->{day_budget});
        }
    }

    my $min_rest = $O{only_forecast} ? $forecast : max($forecast, get_currency_constant($currency, 'MIN_TRANSFER_MONEY'));

    return $O{dont_round} ? $min_rest : round2s($min_rest);
}

=head2 get_camp_sum_available($camp, fast => 0|1)

    Определяет сумму доступную для переноса средств
    для мультивалютных кампаний минимальный остаток возвращается без НДС и без скидочного бонуса
    на вход поступают данные о кампании с суммами с НДС (sums_without_nds => 0) или без НДС (sums_without_nds => 1)

    Для кампаний с sums_uni автоматически определяет, указана ли сумма с НДС / Скидочным бонусом или без

    При расчете суммы на кампании общем счете:
        сумма, которую нельзя переносить, складывается из таких сумм для всех кампаний
        для кампании она равна (задолженнось + расход на ближайшие полчаса)
        если задолженность минусовая (total > 0), т.е. на кампании есть ее собственные деньги, соответственно они покроют часть расхода.
        для остановленных кампаний расход на полчаса соответственно нулевой

    именованные параметры:
      sums_without_nds -- означает, что в переданных суммах уже нет НДС
      client_nds -- процент НДС клиента (функция умеет получать и сама, но лучше передавать)
      dont_round - не округлять ответ — затем с этой суммой будут проходить операции (например, конвертация в у.е.)
      wallet_group -- список кампаний, которые привязаны к общему счету,
                      если передели кампанию общий счет (ссылка на массив элементов, аналогичный $camp)

    тестирование:
    perl -Iprotected -MCampaign -ME -E 'my $camps = get_user_camps(174230881); my $camp = (grep {$_->{cid} == 8734773} @{$camps->{campaigns}})[0]; my $sum_available = get_camp_sum_available($camp, sums_without_nds => 1); p $sum_available'

=cut

sub get_camp_sum_available {
    my ($camp, %O) = @_;
    my $sum_available = 0;

    my $currency = $camp->{currency};
    my $sums_uni = $camp->{sums_uni};

    confess 'no currency given' unless $currency;
    confess 'no sums_uni found' unless $sums_uni;

    # Кеш НДС для мультивалютных клиентов
    my $client_nds = $O{client_nds};

    my $min_transfer_sum = $O{custom_min_transfer_money} ? calc_min_pay_sum($camp->{ClientID}, $currency) : get_currency_constant($currency, 'MIN_TRANSFER_MONEY');

    # Приведем остаток на кампании к виду: без НДС и скидочного бонуса
    my $total = $sums_uni->{total};
    if ($currency ne 'YND_FIXED' && $total > 0) {
        unless (defined $sums_uni->{total_include_nds} && !$sums_uni->{total_include_nds}) {
            $client_nds //= get_client_NDS($camp->{ClientID});
            $total = Currencies::remove_nds($total, $client_nds);
        }
        $total = Currencies::remove_bonus($total, $sums_uni->{discount}) if $sums_uni->{discount};
    }

    my $camp_type = $camp->{mediaType} || $camp->{type};
    if (camp_kind_in(type => $camp_type, "wallet")) {
        # Сейчас в $total - реальный остаток на ОС с учетом минусов на кампаниях внутри

        my $rough_forecasts_by_cid = {};
        my @campaign_ids = map { $_->{cid} } @{$O{wallet_group}};
        if ((scalar @campaign_ids) > 0) {
            $rough_forecasts_by_cid = Stat::OrderStatDay::get_camp_bsstat_forecast(\@campaign_ids, $currency);
        }

        # Будем считать кол-во показывающихся кампаний внутри ОС и прогноз суммы работы всех кампаний внутри ОС за 30 мин
        my ($shown_count, $sum_forecast) = (0, 0);
        for my $subcamp (@{$O{wallet_group}}) {
            # Вычислим положительный(!) остаток на кампании под ОС и приведем к форме без НДС и скидочного бонуса
            my $subtotal = $subcamp->{sums_uni}->{sum} - $subcamp->{sums_uni}->{sum_spent};
            if ($currency ne 'YND_FIXED' && $subtotal > 0) {
                unless (defined $subcamp->{sums_uni}->{total_include_nds} && !$subcamp->{sums_uni}->{total_include_nds}) {
                    $client_nds //= get_client_NDS($camp->{ClientID});
                    $subtotal = Currencies::remove_nds($subtotal, $client_nds);
                }
                $subtotal = Currencies::remove_bonus($subtotal, $subcamp->{sums_uni}->{discount}) if $subcamp->{sums_uni}->{discount};
            }
            $subtotal = 0 if $subtotal < 0;

            # Вычислим прогноз расхода за 30 мин
            my $forecast = 0;
            if (!is_all_money_transfer_available($subcamp)) {
                $forecast = get_camp_min_rest($subcamp->{cid}, camp_info => $subcamp, dont_round => 1, only_forecast => 1,
                    forecast => $rough_forecasts_by_cid->{$subcamp->{cid}});
                $shown_count++;
            }

            # Положительный остаток идет на погашение прогноза, но не переносится
            $sum_forecast += $subtotal - $forecast > 0 ? 0 : $forecast - $subtotal;
        }

        $sum_available = $total;
        if ($shown_count) {
            $sum_available -= max($sum_forecast, $min_transfer_sum);
            $sum_available = 0 if $sum_available < $min_transfer_sum;
        }
        if (defined($camp->{sum_balance})) {
            $sum_available = min($sum_available, $camp->{sum_balance});
        }
    }
    # Кампании внутри ОС тут фигурировать не должны, по ним всегда возвращяем ноль
    elsif (!$camp->{wallet_cid}) {
        if (!is_all_money_transfer_available($camp)) {
            # Перенос всех денег не доступен, вероятно кампания еще показывается в БК
            # Зарезервируем предполагаемую сумму расхода за 30 минут работы или MIN_TRANSFER_MONEY (большее из)
            my $sum_reserve = max(
                get_camp_min_rest($camp->{cid}, camp_info => $camp, dont_round => 1, only_forecast => 1, forecast => $O{forecast}),
                $min_transfer_sum
            );
            $sum_available = $total - $sum_reserve;
            $sum_available = 0 if $sum_available < $min_transfer_sum;
        } else {
            # Доступны все деньги для перевода
            $sum_available = $total if $total > 0;
        }

        $sum_available = 0 if defined $camp->{money_type} && $camp->{money_type} ne 'real';
    }


    return $O{dont_round}? $sum_available : round2s($sum_available);
}

=head2 create_campaigns_balance

    На входе - массив из cid

    Опции:
        is_enable_wallet -- перенос для включения общего счета (используется для определения промодерированности кампании общего счета)
        force_group_order_transfer -- принудительно перенести деньги деньги с подключенных к общему счёту заказов
        dont_create_wallets -- не создавать кошельки в Балансе
        force_lock_wallet -- при отправке в Баланс кошелька, делать его неотключаемым даже если валюта указана в фишках
                             обычно фишечные кошельки делать неотключаемыми нельзя, но при конвертации модификацией - можно
        beta_unlink_wallet -- только для бет: сделать вид что у кампаний в базе записан wallet_cid=0

    Возвращает один из вариантов ссылки на хеш:
        {balance_res => $balance_res, client_id => $client_id}
        {error => $error_message}

=cut

sub create_campaigns_balance {
    my (undef, $UID, $cids, %OPT) = @_;

    my @req;
    $cids = [grep {defined && /^\d+$/} @$cids];
    return {error => "Empty list of campaigns"} if !@$cids;

    my $camps_info = get_all_sql(PPC(cid => $cids),
        ["SELECT c.cid, c.uid, c.type, c.name, c.ManagerUID, c.AgencyUID
               , IFNULL(c.AgencyID, 0) as AgencyID
               , c.sum, c.sum_to_pay, c.wallet_cid
               , u.ClientID
               , c.ProductID
               , ccmc.new_cid
               , ccmc.old_cid
               , c.currency
          FROM campaigns c
          INNER JOIN users u ON c.uid = u.uid
          LEFT JOIN currency_convert_money_correspondence ccmc ON ccmc.ClientID = u.ClientID AND ccmc.old_cid = c.cid",
          WHERE => {'c.cid' => SHARD_IDS}]
    );
    return {error => iget("Указаны несуществующие кампании")} if @$cids != @$camps_info;

    my $agency_uid = $camps_info->[0]->{AgencyUID};
    # Проверки всяческие
    if ( !$agency_uid && scalar(uniq map{$_->{uid}} @$camps_info) > 1) {
        return {error => iget("Недопустима оплата за нескольких пользователей.")};
    }
    my $agencie_ids = get_uid2clientid(uid => [grep {defined} map {$_->{AgencyUID}} @$camps_info]);

    my $client_id;
    my $wallet_cids = {};

    for my $data ( @$camps_info ) {
        if (camp_kind_in(type => $data->{type}, 'no_send_to_billing')){
            return {error => iget('Оплата кампании запрещена')}
        }

        my $cid = $data->{cid};
        my $product = product_info(ProductID => $data->{ProductID});

        # Определяем id клиента
        $client_id = $data->{ClientID};

        die "No ClientID for cid = $data->{cid}, uid = $data->{uid}" unless $client_id;

        my $camp_manager_uid = $data->{ManagerUID} || 0;
        if ($agency_uid) {
            my $camp_type = $data->{type};
            $camp_manager_uid = rbac_get_manager_of_agency(undef, $agency_uid, $camp_type);
            return {error => iget('Невозможно найти менеджера агентства.')} if !$camp_manager_uid;
        }

        my $pay_method_flag = 0;
        if (!camp_kind_in(type => $data->{type}, 'billing_aggregate')) {
            my $pay_method = check_method_pay($cid, is_enable_wallet => $OPT{is_enable_wallet});
            if ($pay_method eq 'with_block') {
                $pay_method_flag = 1;
            }
        }

        if (is_beta() && $OPT{beta_unlink_wallet}) {
            $data->{wallet_cid} = 0;
        }
        # Создаём хеш для кампании
        my $r = {
                    ServiceID => $product->{EngineID},
                    ProductID => $product->{ProductID},
                    ServiceOrderID => $cid+0,
                    ClientID => $client_id+0,
                    Text => $data->{name},
                    unmoderated => $pay_method_flag,
                    # сконвертированные копированием кампании перевешиваем на их валютные копии
                    GroupServiceOrderID => ($data->{new_cid} && $data->{new_cid} != $data->{old_cid}) ? $data->{new_cid} : $data->{wallet_cid},
                    (!$OPT{force_group_order_transfer}) ? (GroupWithoutTransfer => 1) : (),
        };
        # все общие счета, кроме фишечных и агентстких, становятся неотключаемыми
        my $is_agency = $data->{AgencyUID} && $agencie_ids->{$data->{AgencyUID}};
        if (!$is_agency && $data->{type} eq 'wallet' && ($data->{currency} ne 'YND_FIXED' || $OPT{force_lock_wallet})) {
            $r->{is_ua_optimize} = 1;
        }

        if ( $is_agency ) {
            $r->{AgencyID} = $agencie_ids->{$data->{AgencyUID}};
        }
        if ( $camp_manager_uid ) {
            $r->{ManagerUID} = $camp_manager_uid+0;
        }
        if (defined($r->{Text})){
            $r->{Text} = $r->{Text} =~ s/$Settings::DISALLOW_CAMP_LETTER_RE//gr;
            if ($r->{Text} eq '') {
                $r->{Text} = iget("Новая");
            }
        }
        push @req, $r;

        # если есть включенный общий счет у кампании, то дополнительно отсылаем сам заказ общий счет
        if ($data->{wallet_cid}) {
            $wallet_cids->{$data->{wallet_cid}} = 1;
        }
    }
    # Если это кампании субклиентов - передаём ClientID агентства
    if ( $agency_uid ) {
        $client_id = $agencie_ids->{$agency_uid};
        if ( !$client_id ) {
            send_alert("create_campaigns_balance: No ClientID for agency $agency_uid", 'create_campaigns_balance');
            return {error =>  "ClientID for agency not found"};
        }
    }

    return {error => "No data for export to balance"} if !@req;

    # return {balance_res => 1, client_id => $client_id}; # for test transfer money

    if (!$OPT{dont_create_wallets} && %$wallet_cids) {
        # перед тем как обновлять кампании, обновляем кампании счета, если они есть у кампаний
        my $passthrough_opts = hash_cut \%OPT, qw(force_group_order_transfer);
        my $wallet_balance_result = create_campaigns_balance(undef, $UID, [keys %$wallet_cids], %$passthrough_opts);
        return $wallet_balance_result if exists $wallet_balance_result->{error};
    }

    my $balance_res = balance_create_update_orders($UID, \@req);

    return {balance_res => $balance_res, client_id => $client_id};
}

=head2 check_method_pay(cid)

    Проверяем, возможные способы оплаты кампании в текущий момент

    Опции:
        is_enable_wallet -- перенос для включения общего счета (используется для определения промодерированности кампании общего счета)

=cut

sub check_method_pay($;)
{
    my ($cid, %OPT) = @_;

    my $res = get_one_line_sql(PPC(cid => $cid),
        "select c.ManagerUID, c.AgencyUID, c.sum, c.statusModerate, co.statusPostModerate, c.OrderID
                , c.cid
                , c.wallet_cid
                , c.uid
                , c.type
         from campaigns c
           left join camp_options co using(cid)
         where cid = ?", $cid
    );

    my $money_with_block = check_block_money_camp($res, type_only => 1, is_enable_wallet => $OPT{is_enable_wallet});

    if ($money_with_block) {
        return 'with_block';
    } elsif ($res->{ManagerUID} || $res->{AgencyUID}) {
         return 'any';
    } elsif ($res->{statusModerate} ne 'Yes') {
        return 'blocked';
    }

    return 'any';
}

=head2 queue_camp_operation

    Добавление в очередь задания на выполнение одной из операций над кампанией:
        - архивирование
        - разархивирование
        - удаление
        - копирование
        - копирование с генерацией отчетов по скопированным баннерам и фразам

    Имеет смысл для больших кампаний/сложных операций

    Принимает в качестве обязательных параметров тип операции (arc/unarc/del/copy) и массив кампаний.
    Также принимает необязательный именованный параметр params, содержащий ссылку на хеш. Для операции copy
    в хеше лежат параметры копирования, для остальных операций - необязательный параметр UID.

    $operation = 'copy';
    $cid = 123456;
    $params = {
        UID => $uid,
        new_uid => $new_uid,
        manager_uid => $manager_uid,
        agency_uid => $agency_uid,
        new_login => $new_login,
        old_login => $old_login,
        new_wallet_cid => $wallet_cid,
        flags => {
            ... # см. описание flags в Campaign::Copy::copy_camp
        },
    };
    hash_copy $params, \%FORM, @fields_directly_from_form;
    queue_camp_operation($operation, $cids, params => $params);

=cut

sub queue_camp_operation {
    my ($operation, $cids, %O) = @_;

    $cids = [$cids] if ref $cids ne 'ARRAY';

    if ( $operation eq 'copy' ) {
        my $params_json;
        if ($O{params}) {
            $params_json = to_json( hash_cut($O{params}, qw/UID new_uid manager_uid agency_uid flags override campaign_name_prefix/),
                                    utf8 => 1
            );
        }

        #Достанем из clients_options накопленное время копирования кампаний за учетный период
        #Т.к. передаем ela=0 - сохраненное значение обновляться не будет
        my $time_shift = update_and_get_total_camp_copy_ela($O{params}->{UID}, 0);
        foreach_shard cid => $cids, sub {
        	my ($shard, $shard_cids) = @_;
        	do_mass_insert_sql(
        	   PPC(shard => $shard),
        	   "INSERT INTO camp_operations_queue_copy(cid, params) VALUES %s",
        	   [map { [$_, $params_json] } @$shard_cids]
        	);

            # Обновим effective_queue_time отдельным запросом, т.к. в do_mass_insert_sql конструкцию NOW() + x добавить нельзя
            if ($time_shift > 0) {
                do_update_table(PPC(shard => $shard), 'camp_operations_queue_copy', {effective_queue_time__dont_quote => "TIMESTAMPADD(SECOND, $time_shift, queue_time)"},
                where => {cid => $shard_cids});
            }
        };
    } elsif ( $operation eq 'copy_with_reports') {
        die 'no params for copy_with_reports' unless $O{params};
        $O{params}->{cids} = $cids;
        my $params_json = to_json hash_cut $O{params}, qw/UID new_uid manager_uid agency_uid flags cids new_login old_login new_wallet_cid/;
        my $ClientID = get_clientid(uid => $O{params}->{UID});
        do_insert_into_table(PPC(ClientID => $ClientID), 'camp_copy_reports_queue', {ClientID => $ClientID, params_json => $params_json});
    } else {
        my $params_json;
        if ($O{params}) {
            $params_json = to_json(hash_cut($O{params}, qw/UID/), utf8 => 1);
        }

        foreach_shard cid => $cids, sub {
            my ($shard, $shard_cids) = @_;
            do_mass_insert_sql(
               PPC(shard => $shard),
               "INSERT IGNORE INTO camp_operations_queue(cid, operation, params) VALUES %s",
               [map { [$_, $operation, $params_json] } @$shard_cids]
            );
        };
    }
}

=head2 is_camp_deletable_by_hash

    $camp = get_camp_info($cid, $uid, short => 1);
    $res = is_camp_deletable_by_hash($camp, uid => $uid);
    $res => 1|0

=cut

sub is_camp_deletable_by_hash {
    my ($camp, %O) = @_;

    my $is_camps_deletable = mass_is_camp_deletable_by_hash([$camp], %O);
    return $is_camps_deletable->{$camp->{cid}};
}

=head2 mass_is_camp_deletable_by_hash

    $camp1 = get_camp_info($cid1, $uid, short => 1);
    $res = mass_is_camp_deletable_by_hash([$camp1, $camp2, ...], uid => $uid);
    $res => {
        $cid1 => 1|0,
        ...
    }

=cut

sub mass_is_camp_deletable_by_hash {
    my ($camps, %O) = @_;

    return {} unless $camps && @$camps;

    my @wallet_cids = uniq grep { ($_ || 0) > 0 } map { $_->{wallet_cid} } @$camps;
    my %wallet_data;
    if (@wallet_cids) {
        my $wallets_raw_data = get_wallets_by_cid(\@wallet_cids);
        for my $wallet (@$wallets_raw_data) {
            $wallet_data{$wallet->{wallet_cid}} = $wallet;
        }
    }

    my %camp_deletable;
    for my $camp (@$camps) {
        my $cid = $camp->{cid};

        $camp_deletable{$cid} = 0;
        my $sum = ($camp->{sum_counted_with_wallet}) ? ($camp->{sum} - $camp->{wallet_sum}) : $camp->{sum};

        if ( ($sum || 0) == 0
          && ($camp->{sum_to_pay} || 0) == 0
          && ($camp->{sum_last} || 0) == 0
          && ($camp->{OrderID} || 0) == 0
          && ($O{force_converted} || !(($camp->{currencyConverted} || 'No') eq 'Yes' && ($camp->{currency} || 'YND_FIXED') eq 'YND_FIXED'))
          && (!$O{uid} || ($O{uid} && ($camp->{uid} || 0) == $O{uid}))
          && ($camp->{status_approve} || 'No') ne 'Yes'
          && ($camp->{source} || 'direct') ne 'zen'
        ) {
            $camp_deletable{$cid} = 1;
        }
    }

    # проверяем кампании по bs_export_queue и bs_export_candidates на случай, если кампанию уже поставили в очередь или собираемся поставить
    my @deletable_cids = grep { $camp_deletable{$_} } keys %camp_deletable;
    if (@deletable_cids) {
        my $cids_in_bs_export = get_one_column_sql(PPC(cid => \@deletable_cids), [
            'SELECT cid FROM bs_export_candidates', WHERE => {cid => SHARD_IDS},
            'UNION SELECT cid FROM bs_export_queue', WHERE => {
                    cid => SHARD_IDS,
                    _OR => [
                        par_id__ne => $BS::Export::Queues::SPECIAL_PAR_TYPES{nosend_for_drop_sandbox_client},
                        par_id__is_null => 1,
                    ],
                },
        ]) || [];

        for my $cid (@$cids_in_bs_export) {
            $camp_deletable{$cid} = 0;
        }
    }

    return \%camp_deletable;
}

=head2 is_camp_deletable(cid, uid)

    вовзращает 1, если кампанию можно удалять, иначе - 0

=cut
sub is_camp_deletable {
    my ($cid, $uid, %O) = @_;

    my $camp_info = get_camp_info($cid, undef, short => 1);
    return is_camp_deletable_by_hash($camp_info, uid => $uid, force_converted => $O{force_converted});
}

=head2 del_camp(rbac, cid, client_uid, | force => 1, ignore_rbac_errors => 1, force_converted => 0)

    Удаление кампании - проверка текущего её состояния, удаление из RBAC,
    установка пустого статуса, добавление задания на удаление в очередь.

    Позиционные параметры:
    - rbac
    - cid
    - client_uid
    Именованные параметры:
    - force - булевский параметр, если истина, то задача на удаление
        не ставится в очередь, а выполняется сразу.
    - ignore_rbac_errors - булевский параметр, если истина, то игнорируются ошибки,
        возникающие при удалении из rbac
    - force_converted - булевский параметр, если истина, удаляет архивные сконвертированные кампании,
        работает только в комплекте с force
    - dont_queue_deletion — не ставить в очередь задание на удаление кампании
                            кампани при этом помечается statusEmpty=Yes и будет
                            когда-нибудь удалена скриптом ppcClearEmptyCampaigns.pl
                            не совместимо с force
    - UID - опциональный параметр. Если проставлен, то передаётся в queue_camp_operation.

=cut
sub del_camp {
    my ($rbac, $cid, $client_uid, %O) = @_;
    validate_with(params => [%O], spec => {
        force => 0,
        ignore_rbac_errors => 0,
        silent_rbac_errors => 0,
        force_converted => 0,
        dont_queue_deletion => 0,
        UID => 0,
    });
    $O{force_converted} = $O{force_converted} && $O{force};

    unless ( is_camp_deletable($cid, $client_uid, force_converted => $O{force_converted}) ) {
        warn "cant delete campaign (cid: $cid)";
        return;
    }

    my $errcode = eval {rbac_delete_campaign($rbac, $cid, $client_uid);};
    if ($@) {
        warn "rbac die on delete campaign: $@" if !$O{silent_rbac_errors};
        return if !$O{ignore_rbac_errors};
    } elsif ($errcode) {
        warn "rbac error on delete campaign (cid: $cid, code: $errcode)" if !$O{silent_rbac_errors};
        return if !$O{ignore_rbac_errors};
    }

    my $cids = get_one_column_sql(PPC(cid => $cid), 'SELECT cid FROM subcampaigns WHERE master_cid = ?', $cid);
    push @$cids, $cid;

    my $result = 1;
    if (!$O{force}) {
        do_update_table(PPC(cid => $cids), 'campaigns', {
            statusEmpty => 'Yes',
        }, where => { cid => $cids });
        if (!$O{dont_queue_deletion}) {
            my $params = {};
            if ($O{UID}) {
                $params->{UID} = $O{UID};
            }
            queue_camp_operation('del', $cids, params => $params);
        }
    } else {
        foreach my $cur_cid (@$cids) {
            $result = $result & del_camp_data($cur_cid, $client_uid, force_converted => $O{force_converted});
        }
    }

    return $result;
}

=head2 del_camp_data(cid, uid, force_converted => 0)

    Удаляет кампанию и связанные с ней сущности.
    Проверки на доступ пользователя к удалению этой кампании не происходит,
    она должна быть сделана где-то выше.
    Считается, что удаление из RBAC уже произведено.

    Именованные параметры:
    - force_converted - булевский параметр, если истина, удаляет архивные сконвертированные кампании

=cut

# key_delete_by => ['table1'] # delete from table1 where key_delete_by IN ($key_delete_by)
# key_delete_by => [['table1'], new_key => {filter => 123}] # delete from table1 where new_key IN ($key_delete_by) AND filter == 123

use constant DELETE_RULES => (
    # delete banners
    bid => [qw/banner_images banners_mobile_content banners_performance banners_additions banner_display_hrefs images banner_resources
               banners_minus_geo aggregator_domains moderate_banner_pages banner_moderation_versions
               banner_measurers banners_tns banner_permalinks banner_phones banner_additional_hrefs banner_turbolandings
               banner_names banner_logos banner_buttons banner_display_href_texts banner_leadform_attributes
               banner_multicards banner_multicard_sets banners_performance_main banner_user_flags_updates banner_publisher
               /],
    cid => [qw/banners/],
    # delete show conditions
    cid => [qw/bids_href_params bids_manual_prices bids_arc bids bids_base/],
    pid => [qw/bids_retargeting bids_dynamic dynamic_conditions bids_performance/],
    # delete adgroups
    pid => [qw/group_params adgroups_mobile_content adgroups_text adgroups_performance adgroups_dynamic adgroups_cpm_banner adgroups_cpm_video adgroups_internal adgroup_additional_targetings adgroup_project_params adgroup_page_targets adgroups_minus_words video_segment_goals phrases/],
    # delete mediaplans
    mbid => [qw/mediaplan_bids_retargeting/],
    cid => [qw/mediaplan_bids mediaplan_banners_original mediaplan_banners autobudget_forecast/],
    bid => [[qw/redirect_check_queue/], object_id => {object_type => 'banner'}],

    bid => [['mod_object_version'], obj_id => {obj_type => [qw/banner contactinfo sitelinks_set image display_href/]}],
    pid => [['mod_object_version'], obj_id => {obj_type => ['phrases']}],

    # delete dialogs links
    cid => [qw/camp_dialogs/],
);

sub del_camp_data {
    my ($cid, $uid, %O) = @_;

    return unless ( $cid =~ m/^\d+$/ && $uid );
    return unless ( is_camp_deletable($cid, $uid, force_converted => $O{force_converted}) );

    my $camp = get_one_line_sql(
        PPC(cid => $cid), "
        SELECT IFNULL(type, 'text') AS mediaType
        FROM campaigns
        WHERE cid = ?
        ", $cid
    );

    # снимаем кампанию с обслуживания в Балансе, если она сервисируемая
    unservice_orders_in_balance([$cid]);

    my $client_id = get_clientid(cid => $cid);

    # останавливаем АВ-эксперименты
    Experiments::stop_experiment_on_delete_campaign($client_id, $cid);

    my $vcards_to_delete = get_one_column_sql(PPC(cid => $cid), 'SELECT DISTINCT vcard_id FROM vcards WHERE cid = ?', $cid) || [];

    # ВАЖНО: добавляя сюда таблицы нужно подумать над добавлением их также в
    # почти аналогичный список внутри SandboxCommon::_drop_sandbox_client
    my @delete_by_cid = qw/
        campaigns_mobile_content
        camp_options
        user_campaigns_favorite
        camp_metrika_counters
        metrika_counters
        campaigns_performance
        campaigns_internal
        warn_pay
        camp_payments_info
        camp_promocodes
        bs_export_specials
        campaigns
        campaigns_deals
        campaign_permalinks
        campaign_phones
        camp_calltracking_settings
        camp_additional_data
        campaign_promoactions
        camp_secondary_options
        subcampaigns
        campaigns_promotions
        camp_order_types
    /;
    for my $table (@delete_by_cid) {
        do_delete_from_table(PPC(cid => $cid), $table, where => { cid => $cid });
    }
    # Удаляем метки;
    Tag::delete_campaign_tags($cid);

    # Удаляем результаты модерации
    do_delete_from_table(PPC(cid => $cid), 'mod_reasons', where => {clientid => $client_id, cid => $cid});

    if (camp_kind_in(type => $camp->{mediaType}, "web_edit_base")) {

        my $pids = get_pids(cid => $cid);
        my $bids = get_bids(cid => $cid);
        my $mbids = get_one_column_sql(PPC(cid => $cid), "select mbid from mediaplan_banners where cid = ?", $cid);

        my $now = Yandex::DateTime->now();
        do_mass_insert_sql(PPC(cid => $cid), "REPLACE INTO deleted_banners (bid, deleteTime) VALUES %s",
                           [map {[$_, $now]} @$bids]);

        my %ids_type = (
            bid => $bids,
            pid => $pids,
            cid => $cid,
            mbid => $mbids
        );
        for my $pair (pairs DELETE_RULES) {
            my $rule = $pair->value;
            next unless @$rule;

            my $key = $pair->key;
            my ($tables, $table_key, %where);
            if (ref $rule->[0] eq 'ARRAY') {
                $table_key = $rule->[1];
                $tables = $rule->[0];
                %where = %{$rule->[2] || {}};
            } else {
                $table_key = $key;
                $tables = $rule;
            }

            for my $table (@$tables) {
                do_delete_from_table(PPC(cid => $cid), $table, where => {$table_key => $ids_type{$key}, %where});
            }
        }

        delete_camp_hierarchical_multipliers($cid);

        delete_shard(bid => $bids);
        delete_shard(pid => $pids);
        delete_shard(mediaplan_bid => $mbids) if @$mbids;
    } elsif(camp_kind_in(type => $camp->{mediaType}, "media")) {

        do_sql(PPC(cid => $cid), qq!
                DELETE mcb_phrases
                  FROM mcb_phrases, media_groups
                 WHERE mcb_phrases.mgid = media_groups.mgid
                   AND media_groups.cid = ?
            !, $cid);

        do_sql(PPC((cid => $cid)), qq!
                DELETE media_banners, media_groups
                  FROM media_banners, media_groups
                 WHERE media_banners.mgid = media_groups.mgid
                   AND media_groups.cid = ?
            !, $cid);
    }

    # удаляем визитки вместе с адресами.
    VCards::delete_vcard_from_db($vcards_to_delete, skip_org_details => 1);
    # спорный момент - орг-детали вместе с визитками подчистить может не получится, т.к. там uid определяется из визитки (может не совпасть)
    OrgDetails::clean_org_details(uid => $uid);

    delete_shard(cid => $cid);

    return 1;
}

=head2 unservice_orders_in_balance

    Рассервисировать заказы в Балансе, если они там есть,
    т. е. перезаписать ManagerUID = 0
    Принимает на вход ссылку на массив cid-ов

=cut
sub unservice_orders_in_balance {
    my $cids = shift;

    return undef unless $cids && ref($cids) eq 'ARRAY' && @$cids;

    my @reqs;
    my $balance_response;

    # выбираем сервисируемые кампании
    my $managed_camps = get_hashes_hash_sql(
            PPC(cid => $cids), ["
            SELECT c.cid, c.name, c.ProductID, u.ClientID, c.wallet_cid
                , c.AgencyID
                , ccmc.new_cid
                , ccmc.old_cid
            FROM campaigns c
            LEFT JOIN users u on c.uid = u.uid
            LEFT JOIN currency_convert_money_correspondence ccmc ON ccmc.ClientID = c.ClientID AND ccmc.old_cid = c.cid",
            WHERE => { 'c.cid' => $cids, _OR => {'c.ManagerUID__gt' => 0, 'c.AgencyUID__gt' => 0 }}]
        );

    if (%$managed_camps) {
        # выбираем существующие в Балансе заказы
        my $balance_orders_info = Yandex::Balance::balance_get_orders_info([ keys %$managed_camps ]) // [];
        if (@$balance_orders_info) {
            # для существующих заказов определяем EngineID
            my @balance_cids = map {$_->{ServiceOrderID}} @$balance_orders_info;
            my @product_ids = uniq map { $managed_camps->{$_}->{ProductID} } @balance_cids;
            my $product_to_engine_id = {};
            foreach my $product_id (@product_ids) {
                my $product = product_info(ProductID => $product_id);
                $product_to_engine_id->{$product_id} = $product->{EngineID};
            }

            foreach my $cid (@balance_cids) {
                # формируем запросы в Баланс
                my $camp_data = $managed_camps->{$cid};
                my $r = {
                    ServiceID => $product_to_engine_id->{$camp_data->{ProductID}},
                    ProductID => $camp_data->{ProductID},
                    ServiceOrderID => $cid,
                    ClientID => $camp_data->{ClientID},
                    Text => $camp_data->{name},
                    # здесь важно повторить логику вычисления группового заказа, как это сделано в create_campaigns_balance,
                    # иначе есть риск отвязать кампанию от общего счета, который может оказаться неотключаемым
                    GroupServiceOrderID => ($camp_data->{new_cid} && $camp_data->{new_cid} != $camp_data->{old_cid}) ? $camp_data->{new_cid} : $camp_data->{wallet_cid},
                    ManagerUID => 0,    # снимаем с сервисирования менеджером
                    # а агентство, если было - оставляем
                    ($camp_data->{AgencyID} ? (AgencyID => $camp_data->{AgencyID}) : ()),
                };
                push @reqs, $r;
            }
            my $OPERATOR_UID = 0;
            $balance_response = balance_create_update_orders($OPERATOR_UID, \@reqs);
            die "can't unservice orders in Balance" unless $balance_response;
        }
    }

    return $balance_response;
}

=head2 get_mcb_camp_min_shows($cid)

    Получить минимальный заказ для МКБ кампании.

=cut
sub get_mcb_camp_min_shows {
    my ($cid) = @_;

    my ($targeting, $ClientID, $ProductID) = get_one_line_array_sql(PPC(cid => $cid), "
            SELECT c.geo, u.ClientID, c.ProductID
              FROM campaigns c
              JOIN users u on u.uid = c.uid
             WHERE c.cid = ?
            ", $cid);

    return get_mcb_geo_min_shows([$targeting], {ClientID => $ClientID, product_type => product_info(ProductID => $ProductID)->{product_type}});
}

=head2 validate_pay_camp

    Проверяет возможность оплаты кампании. Возвращает либо текст ошибки, либо undef.
    Кампании "общий счет" можно оплачивать всегда.

    Позиционные параметры:
    - $uid
    - $cid
    - $total — ссылка на скаляр, в который (если указан) будет записано суммарное количество денег, положенных на данную кампанию
    - $name — ссылка на скаляр, в который (если указан) будет записано название кампании
    Именованные параметры:
    - post_moderated_only — если истина, то оплата разрешается только для кампаний, принятых на пост-модерации

    my $error = validate_pay_camp($uid, $cid, $total, $name, $rbac, post_moderated_only => 1);

=cut

sub validate_pay_camp
{
    my ($uid, $cid, $total, $name, $rbac, %O) = @_;

    my $camp_params = get_one_line_sql(PPC(uid => $uid), q!
        SELECT c.uid, c.statusModerate, c.statusEmpty, c.sum, c.name, IFNULL(co.statusPostModerate, 'New') statusPostModerate
             , c.type
        FROM campaigns c
        LEFT JOIN camp_options co ON c.cid = co.cid
        WHERE c.cid = ?
    !, $cid);

    return iget("Неверный номер кампании (%s), повторно залогиньтесь.", $cid) if ($camp_params->{uid} != $uid);

    if ($camp_params->{type} ne 'wallet') {
        return iget("Кампания %s не промодерирована.", $cid) if
            ($camp_params->{statusModerate} ne 'Yes' && ! rbac_is_scampaign($rbac, $cid) && ! rbac_is_agencycampaign($rbac, $cid))
            || ($O{post_moderated_only} && $camp_params->{statusPostModerate} ne 'Accepted');
        return iget('Неверный номер кампании (%s).', $cid) if $camp_params->{statusEmpty} ne 'No';
    }

    $$total = $camp_params->{sum} if defined $total;
    $$name = $camp_params->{name} if defined $name;

    return undef;
}

=head2 convert_dates_for_template

    Преобразует даты начала и окончания в переданных кампаниях из формата, используемого в БД, в форматы, используемые в шаблонах.

    Под форматом, используемом в БД, понимается использование ключей start_time и finish_time с MySQL-совместимой датой или
    датой и временем (YYYY-mm-DD, YYYYmmDD, YYYY-mm-DD HH::MM::SS) в качестве значений.
    Под форматом, используемом в шаблонах, понимаются:
        - ключи start_date и finish_date со значениями даты в формате YYYY-mm-DD
        - ключи yyyy, mm и dd со значениями года, номера месяца и даты начала кампании (только при использовании with_old_start_date_format)

    На вход принимает ссылку на хеш с описанием кампании или ссылку на массив с хешами кампаний и именованные параметры
    keep_source_data и with_old_start_date_format.

    Предполагается, что в новом коде convert_dates_for_template будет использоваться непосредственно перед отправкой данных в шаблон,
    а весь серверный код будет оперировать с датами в формате, используемом в БД.
    Для совместимости в функциях получения данных о кампаниях (get_user_camp|get_user_mediaplan|get_user_camps|get_user_camps_by_sql|CheckCreateCamp|...)
    оставлено преобразование даты в старый формат (т.к. раньше они возвращали его) с сохранением формата БД.
    После перевода всех потребителей этих функций на работу с БД-форматом и преобразовании времени перед отправкой в шаблон, из get_* функций
    преобразование нужно отрывать. В идеале преобразовния должны быть только на границе шаблон<->серверный код, а именно в начале контроллера и
    перед обработкой шаблона.

    $camp = {
            ...
        start_time  => '2001-02-03 00:00:00',
        finish_time => '2004-05-06',
            ...
    };
    convert_dates_for_template($camp, keep_source_data => 1);
    $camp == {
            ...
        start_time   => '2001-02-03 00:00:00',    # сохранилось благодаря keep_source_data
        finish_time  => '20040506',               # сохранилось благодаря keep_source_data
        start_date   => '2001-02-03',
        finish_date  => '2004-05-06',
        yyyy         => '2001',                   # из-за указания with_old_start_date_format
        mm           => '02',                     # из-за указания with_old_start_date_format
        dd           => '03',                     # из-за указания with_old_start_date_format
            ...
    }

    convert_dates_for_template(\@camps, keep_source_data => 1, with_old_start_date_format => 1);

=cut

sub convert_dates_for_template {
    my ($camps, %O) = @_;

    $camps = [$camps] if ref($camps) ne 'ARRAY';

    for my $camp (@$camps) {
        my $type = $camp->{type} || $camp->{mediaType} || $camp->{media_type} || get_camp_type(cid => $camp->{cid});
        for my $field ( camp_kind_in(type => $type, 'base', 'media') ? qw/start finish/ : qw/start/ ) {
            my $datetime = $camp->{"${field}_time"};
            delete $camp->{"${field}_time"} unless $O{keep_source_data};
            if ($datetime && $datetime =~ /^([1-9]\d{3})-?(\d{2})-?(\d{2})/) {
                $camp->{"${field}_date"} = "$1-$2-$3";
                if ( $field eq 'start' && $O{with_old_start_date_format} ) {
                    hash_merge $camp, { yyyy => $1, mm => $2, dd => $3 };
                }
            } else {
                $camp->{"${field}_date"} = undef;
            }
        }
    }
}

=head2 convert_dates_for_db

    Преобразует даты начала и окончания в переданных кампаниях из формата, используемого в шаблонах, в форматы, используемые при сохранении в БД.
    Что понимается под форматами можно прочитать в описании convert_dates_for_template.

    На вход принимает ссылку на хеш с описанием кампании или ссылку на массив с хешами кампаний и именованные параметры
    keep_source_data и with_old_start_date_format.

    $camp = {
            ...
        start_date  => '2001-02-03',
        finish_date => '2004-05-06',
        type        => 'text',
            ...
    };
    convert_dates_for_db($camp, keep_source_data => 1);
    $camp == {
            ...
        start_date   => '2001-02-03',             # сохранилось благодаря keep_source_data
        finish_date  => '2004-05-06',             # сохранилось благодаря keep_source_data
        start_time   => '2001-02-03 00:00:00',
        finish_time  => '2004-05-06 00:00:00',
            ...
    }

    $camp = {
            ...
        yyyy        => 2011,
        mm          => 02,
        dd          => 03,
        type        => 'mcb',
            ...
    };
    convert_dates_for_db($camp, with_old_start_date_format => 1);
    $camp == {
            ...
        start_time   => '2001-02-03 00:00:00',
            ...
    }

    convert_dates_for_db(\@camps, keep_source_data => 1, with_old_start_date_format => 1);

=cut

sub convert_dates_for_db {
    my ($camps, %O) = @_;

    $camps = [$camps] if ref($camps) ne 'ARRAY';

    for my $camp (@$camps) {
        my $type = $camp->{type} || $camp->{mediaType} || $camp->{media_type} || ($camp->{cid} ? get_camp_type(cid => $camp->{cid}) : 'text');
        for my $field ( camp_kind_in(type => $type, 'camp_finish') ? qw/start finish/ : qw/start/ ) {
            my $ts;
            if ( exists $camp->{"${field}_date"} ) {
                my $date = $camp->{"${field}_date"};
                delete $camp->{"${field}_date"} unless $O{keep_source_data};
                $ts = eval { ts_round_day( mysql2unix($date) ) } if $date;
            } elsif ( $field eq 'start' && $O{with_old_start_date_format} && $camp->{yyyy} && $camp->{mm} && $camp->{dd} ) {
                my $date = join '-', map { $camp->{$_} } qw/yyyy mm dd/;
                $ts = eval { ts_round_day( mysql2unix($date) ) } if $date;
                delete @{$camp}{qw/yyyy mm dd/} unless $O{keep_source_data};
            }
            $camp->{"${field}_time"} = $ts ? unix2mysql($ts) : '0000-00-00' if $ts;
        }
    }
}

=head2 is_campaign_finished

    Определяет закончилась ли кампания. Имеет смысл только для текстовых кампаний, т.к. только для них есть дата окончания кампании.
    Возвращает 1, если у кампании задана дата окончания и эта дата уже прошла. И 0 в противном случае.

    Принимает именованные параметры:
        cid          — № кампании,
        finish_time  — время окончания кампании в MySQL-совместимом формате (YYYY-mm-DD, YYYYmmDD, YYYY-mm-DD HH::MM::SS)
    Cid и finish_time можно указывать как по отдельности, так и вместе.
    Но при отсутствии finish_time, время окончания будет браться из БД, так что лучше указывать, если уже есть.

    $is_finished = is_campaign_finished(cid => 123, finish_time => '2011-06-24');

=cut

sub is_campaign_finished {
    my (%O) = @_;

    $O{cid} ||= 0;
    return is_campaign_finished_mass([\%O])->{$O{cid}};
}


=head2 is_campaign_finished_mass

Массовая версия is_campaign_finished

=cut

sub is_campaign_finished_mass {
    my ($camps) = @_;

    return {}  if !@$camps;

    my @cids_wo_finish_time = map {$_->{cid}} grep {!defined $_->{finish_time}} @$camps;
    my $finish_time_by_cid = mass_get_campaign_finish_time(\@cids_wo_finish_time);

    my %result;
    for my $camp (@$camps) {
        my $cid = $camp->{cid};
        my $finish_time;
        if ( defined $camp->{finish_time} ) {
            $finish_time = $camp->{finish_time};
        } elsif (defined $cid) {
            $finish_time = $finish_time_by_cid->{$cid};
        }

        croak "cannot get campaign finish_time"  if !defined $finish_time;

        my $finish_date = mysql_round_day($finish_time);
        $result{$cid} = $finish_date && today() gt $finish_date ? 1 : 0;
    }

    return \%result;
}


=head2 mass_get_campaign_finish_time

    Принимает на вход пачку cid-ов, возвращает хэш { cid => finish_time, cid => finish_time, ... }

=cut

sub mass_get_campaign_finish_time {
    my ($cids) = @_;

    return {}  if !@$cids;
    return get_hash_sql( PPC( cid => $cids ), ['SELECT cid, finish_time FROM campaigns', where => {cid => SHARD_IDS}]);
}

=head2 campaign_has_deals

Для кампаний массово возвращает признак наличия сделок

=cut

sub campaign_has_deals {
    my ($camps, $type_by_cid) = @_;

    return {}  if !@$camps;

    my @cpm_deals_cids = map {$_->{cid}} grep {$type_by_cid->{$_->{cid}} eq 'cpm_deals'} @$camps;

    my $cids_with_deals = {};
    if (@cpm_deals_cids) {
        $cids_with_deals = get_hash_sql(
            PPC(cid => \@cpm_deals_cids),
            [ 'SELECT DISTINCT cid FROM campaigns_deals', WHERE => {'cid' => SHARD_IDS, 'is_deleted' => 0} ]
        );
    }

    return { map { $_ => 1 } keys %$cids_with_deals };
}

=head2 separate_day_budget

    Преобразует данные о дневном бюджете в кампании из "сырого" (т.е. из данных, выбранных из БД вместе с остальными данными по кампании)
    в структурированный вид (хеш).
    Принимает ссылку на хеш с данными о кампании, в котором дневной бюджет описывается ключами
    day_budget, day_budget_daily_change_count, day_budget_show_mode, day_budget_stop_time.
    Смысл данных в ключах совпадает с таковым в таблицах campaigns и camp_options.
    Изменяет in-place переданный хеш так, что в нём параметры дневного бюджета выделены в структуру:
    {
         sum => # сумма дневного бюджета (текущая или на завтрашний день)
         daily_change_count => # сколько раз за текущие сутки изменялись параметры дневного бюджета для кампании
         show_mode => default|stretched # режим показов
         stop_time => # время приостановки кампании по дневному ограничению бюджета или 0, если кампания не приостановлена
         recommended_sum => # сумма рекомендуемого бюджета (её может не быть)
    }

    $camp->{
        [...]
        day_budget => 123,
        day_budget_daily_change_count = 1,
        day_budget_show_mode => 'default',
        day_budget_stop_time => undef,
        day_budget_recommended_sum => 12.34,
        [...]
    };
    separate_day_budget($camp);
    $camp => {
      [...]
      day_budget => {
          sum => 123,
          daily_change_count => 1,
          show_mode => 'default',
          stop_time => undef,
          recommended_sum => 12.34,
      },
      [...]
    };

=cut

sub separate_day_budget {
    my ($camp) = @_;

    $camp->{day_budget} = {
        sum => delete $camp->{day_budget},
        daily_change_count => delete $camp->{day_budget_daily_change_count},
        show_mode => delete $camp->{day_budget_show_mode},
        stop_time => delete $camp->{day_budget_stop_time},
        recommended_sum => delete $camp->{day_budget_recommended_sum},
    };
}

=head2 save_ab_segment_sections_stat_retargeting_cond

=cut

sub save_ab_segment_sections_stat_retargeting_cond
{
    my ($client_id, $section_ids, $metrika_segments, $existing_segments) = @_;

    if (scalar @$section_ids == 0) {
        return undef;
    }
    my %section_ids_hash = map {$_ => 1} @$section_ids;
    my %segments_by_id = map {$_->{segment_id} => 1} grep {$section_ids_hash{$_->{section_id}}} @$metrika_segments;
    return _save_ab_segment_ret_cond($client_id, \%segments_by_id, $metrika_segments, $existing_segments);
}

=head2 save_ab_segment_retargeting_cond

=cut

sub save_ab_segment_retargeting_cond
{
    my ($client_id, $segments, $metrika_segments, $existing_segments) = @_;

    if (scalar @$segments == 0) {
        return undef;
    }
    my %segments_by_id = map {$_ => 1} @$segments;
    return _save_ab_segment_ret_cond($client_id, \%segments_by_id, $metrika_segments, $existing_segments);
}

sub _save_ab_segment_ret_cond {
    my ($client_id, $segments_by_id, $metrika_segments, $existing_segments) = @_;

    my $segments_ctn = scalar keys %$segments_by_id;
    for my $ret_cond (@$existing_segments) {
        my @cond_segments_ids = @{$ret_cond->get_segments_ids};
        if ($segments_ctn == scalar @cond_segments_ids && all {$segments_by_id->{$_}} @cond_segments_ids) {
            return $ret_cond->id;
        }
    }

    my $ret_cond = Direct::Model::AbSegmentCondition->new(
        id         => 0,
        client_id  => $client_id,
        segments  => [grep {$segments_by_id->{$_->{segment_id}}} @$metrika_segments],
    );
    Direct::AbSegmentConditions->new([$ret_cond])->create();

    push @$existing_segments, $ret_cond;

    return $ret_cond->id;
}

=head2 save_brand_safety_ret_cond($client_id, $categories)

  Сохранение условия для исключения категорий из показа
      $categorie - [id1, id2] список ID категорий (goal_id)

=cut

sub save_brand_safety_ret_cond {
    my ($client_id, $categories) = @_;

    return undef unless $categories && @$categories;

    my $existing_conditions = Direct::BrandSafetyConditions->get_by(client_id => $client_id)->items;
    my $cnt = 0 + @$categories;
    my %look_for_ids = map { $_ => 1 } @$categories;
    my $existing_condition = first {
        my @goals = @{$_->get_using_goal_ids};
        $cnt == @goals
          && all { exists $look_for_ids{$_} } @goals
    } @$existing_conditions;
    return $existing_condition->id if $existing_condition;

    my $condition = Direct::Model::BrandSafetyCondition->new(
        id => 0,
        client_id => $client_id,
        category_ids => $categories
    );
    Direct::BrandSafetyConditions->new([$condition])->create();
    return $condition->id;
}

=head2 camp_save_metrika_counters

 Сохранить список счетчиков метрики для кампании в таблицу metrika_counters
 На входе cid и строка с счетчиками через запятую или пробел, как она приходит из формы
 Из API счётчики приходят разделёнными пробелом

 Сохраняем в две таблицы:
    metrika_counters - по одной записи на каждый счетчик, для conv/metrica_notify.pl
    camp_metrika_counters - одна запись на все счетчики, для bsClientData.pl

=cut

sub camp_save_metrika_counters
{
    my ($cid, $strategy_id, $counters, %opts) = @_;

    $counters //= '';
    $counters =~ s/(^[\s,]+|[\s,]+$)//g;
    my $MAX_METRIKA_COUNTER_ID = 2**31 - 1;
    my @metrika_counters = uniq(grep { is_valid_int($_, 1, $MAX_METRIKA_COUNTER_ID) } (split /[\s,]+/, $counters));

    if ($opts{package_strategy_is_changed}){
        @metrika_counters = @{ get_one_column_sql(PPC(cid => $cid), "select metrika_counter from strategy_metrika_counters where strategy_id = ?", $strategy_id) };
    }

    # если у счетчиков поменялась сортировка, считаем их тоже разными, т.к. порядок важен клиенту
    my $old_metrika_counters = get_one_field_sql(PPC(cid => $cid), "select metrika_counters from camp_metrika_counters where cid = ?", $cid) || '';
    return if ($old_metrika_counters eq join(',', @metrika_counters) && !$opts{need_to_create_new_package});

    my $uid = get_uid(cid => $cid);
    my $client_id = get_clientid(uid => $uid);

    if (scalar @metrika_counters > 0) {
        my $has_ecommerce_by = {};

        # Для перфоманс кампании - вычислим на счетчике признак has_ecommerce
        if (get_camp_type(cid => $cid) eq 'performance') {
            $has_ecommerce_by = MetrikaCounters::check_counters_ecommerce(\@metrika_counters);
        }

        do_delete_from_table(PPC(cid => $cid), 'metrika_counters' ,
                             where => { cid => $cid, metrika_counter__not_in => \@metrika_counters });
        if ($strategy_id){
            do_delete_from_table(PPC(cid => $cid), 'strategy_metrika_counters' ,
                where => { strategy_id => $strategy_id, metrika_counter__not_in => \@metrika_counters });
        }

        my $counter_source_by_id = _get_available_counter_source_by_id($uid, \@metrika_counters);

        my @rows = map { [$cid, $_, $counter_source_by_id->{$_}, $has_ecommerce_by->{$_}] } @metrika_counters;

        my @rows_for_strategies = map { [$strategy_id, $_, $counter_source_by_id->{$_}, $has_ecommerce_by->{$_}] } @metrika_counters;

        do_mass_insert_sql(PPC(cid => $cid), "
            insert into metrika_counters (cid, metrika_counter, source, has_ecommerce) values %s
            on duplicate key update has_ecommerce = values(has_ecommerce)
        ", \@rows);
        if ($strategy_id){
            do_mass_insert_sql(PPC(cid => $cid), "
            insert into strategy_metrika_counters (strategy_id, metrika_counter, source, has_ecommerce) values %s
            on duplicate key update has_ecommerce = values(has_ecommerce)
        ", \@rows_for_strategies);
        }
        do_insert_into_table(PPC(cid => $cid), 'camp_metrika_counters', {
            cid => $cid,
            metrika_counters => join ',', @metrika_counters
        }, on_duplicate_key_update => 1);
    }
    else {
        do_delete_from_table(PPC(cid => $cid), 'metrika_counters',      where => { cid => $cid });
        do_delete_from_table(PPC(cid => $cid), 'camp_metrika_counters', where => { cid => $cid });
        if ($strategy_id){
            do_delete_from_table(PPC(cid => $cid), 'strategy_metrika_counters',      where => { strategy_id => $strategy_id });
        }
    }

    do_update_table(PPC(cid => $cid), 'banners', {statusBsSynced => 'No', LastChange__dont_quote => 'LastChange'}, where => {cid => $cid});

    return;
}

sub _get_available_counter_source_by_id
{
    my ($uid, $counters) = @_;
    my $form_param = [
        uids       => $uid
    ];

    my $counters_extended = MetrikaIntapi::get_counters_extended_list($form_param);

    my $counter_source_by_id = {map { $_->{id} => exists $_->{counter_source} ? $_->{counter_source} : 'unknown'}
        @{@$counters_extended[0]->{counters}} };
    return Stat::Tools::enrich_counter_source_by_id($counters, $counter_source_by_id);
}

sub _get_id_from_client_dialogs
{
    my ($client_id, $dialog_id) = @_;
    return get_one_field_sql(PPC(ClientID => $client_id),
        ['SELECT client_dialog_id FROM client_dialogs c',
            WHERE => {'c.skill_id' => $dialog_id, 'c.ClientID' => $client_id}]);
}

=head2 camp_save_dialog

 Сохранить данные диалога для кампании в таблицу camp_dialogs
 На входе cid и объект диалога после CampaignTools::enrich_camp_dialog или undef для удаления диалога

=cut
sub camp_save_dialog
{
    my ($client_id, $cid, $dialog) = @_;

    if (defined $dialog) {
        my $client_dialog_id = _get_id_from_client_dialogs($client_id, $dialog->{id});

        unless(defined $client_dialog_id) {
            my $client_dialogs = {
                client_dialog_id => get_new_id('client_dialog_id'),
                ClientID    => $client_id,
                skill_id    => $dialog->{id},
                bot_guid    => $dialog->{bot_guid},
                name        => $dialog->{name} || '',
                is_active   => $dialog->{is_active},
                last_sync_time__dont_quote => 'NOW()',
            };
            do_insert_into_table(PPC(ClientID => $client_id), 'client_dialogs', $client_dialogs, ignore => 1);
            $client_dialog_id = _get_id_from_client_dialogs($client_id, $dialog->{id});
        }
        my $camp_dialogs = {
            cid       => $cid,
            client_dialog_id => $client_dialog_id,
        };
        do_insert_into_table(PPC(cid => $cid), 'camp_dialogs', $camp_dialogs, on_duplicate_key_update => 1, key => [qw/cid/]);
    } else {
        do_delete_from_table(PPC(cid => $cid), 'camp_dialogs', where => { cid => $cid });
    }

    do_update_table(PPC(cid => $cid), 'banners', {statusBsSynced => 'No', LastChange__dont_quote => 'LastChange'}, where => {cid => $cid});

    return;
}

=head2 has_broad_match_flag (cid)

    Возвращает 1 в случае, если в кампании выставлен флаг "Показывать по доп. релевантным фразам"
    Иначе возвращает 0.

=cut
sub has_broad_match_flag {
    my $cid = shift;
    return get_one_field_sql(PPC(cid => $cid), "SELECT broad_match_flag = 'Yes' FROM camp_options WHERE cid = ? LIMIT 1", $cid) || 0;
}

=head2 have_banners_stopped_by_metrica

    Определяет есть ли в указанной кампании объявления, остановленные мониторингом Метрики.
    Принимает единственный параметр — номер кампании (cid).
    Возвращает:
        1,     если в кампании есть хотя бы один остановленный баннер
        0,     если в кампании нет баннеров, остановленных мониторингом
    Существование кампании и наличие в ней объявлений не проверяется. В этих случаях возвращается 0.

    $cid = 1234567;
    $have_stopped_banners = have_banners_stopped_by_metrica($cid);
    $have_stopped_banners ==> 1|0

=cut

sub have_banners_stopped_by_metrica {
    my ($cid) = @_;

    my $banners = BS::CheckUrlAvailability::get_monitoring_stopped_banners($cid);

    return @$banners ? 1 : 0;
}
# -----------------------------------------------------------------------------

=head2 init_edit_campaign_tags_form(FORM, uid)

    Заполняет форму для редактирования меток на кампанию.

=cut
sub init_edit_campaign_tags_form {
    my ($FORM, $uid) = @_;
    my $vars = {};
    $vars->{FORM} = $FORM;
    my $campaign = get_camp_info($FORM->{cid}, $uid, short => 1);
    $campaign->{tags} = Tag::get_all_campaign_tags($FORM->{cid});
    $vars->{campaign} = $campaign;
    return $vars;
}

=head2 camp_has_banners

    Определяет есть ли в кампании хоть один баннер.
    Принимает на вход ссылку на хеш с подмножеством полей кампании.

    $camp = {
        cid => 12345, # номер кампании; обязательный
        mediaType => 'text', # тип кампании: text|mcb|...; не обязательный
    };
    $has_banners = camp_has_banners($camp);
    $has_banners => 1|0

=cut

sub camp_has_banners {
    my ($camp) = @_;

    return mass_camps_has_banners([$camp])->{$camp->{cid}};
}

=head2 mass_camps_has_banners

    Определяет для каждой кампании, есть ли в ней хоть один баннер.
    Принимает на вход структуру вида [{ cid => ..., type => ..., mediaType => ... }, ...], cid обязателен.
    На выходе струтура вида { cid => true | false }

=cut

sub mass_camps_has_banners {
    my ($camps) = @_;

    return {} unless scalar @$camps;

    my @text_campaign_cids;
    my @media_campaign_cids;
    foreach my $camp (@$camps) {
        if (camp_kind_in(type => ($camp->{mediaType}||$camp->{type}), 'base')) {
            push @text_campaign_cids, $camp->{cid};
        } else {
            push @media_campaign_cids, $camp->{cid};
        }
    }

    my $text_campaigns = {};
    if (@text_campaign_cids) {
        $text_campaigns = get_hash_sql(
            PPC(cid => \@text_campaign_cids),
            [ 'SELECT DISTINCT cid FROM banners', WHERE => {'cid' => SHARD_IDS} ]
        );
    }

    my $media_campaigns = {};
    if (@media_campaign_cids) {
        $media_campaigns = get_hash_sql(
            PPC(cid => \@media_campaign_cids),
            [ 'SELECT DISTINCT cid FROM media_banners JOIN media_groups USING(mgid)', WHERE => {'cid' => SHARD_IDS} ]
        );
    }

    return { map { $_ => 1 } ( keys %$text_campaigns, keys %$media_campaigns ) };
}


=head2 can_create_camp

   Проверяет - можно ли создать "пустую" кампанию с указанными параметрами

   Именованные параметры:
        client_chief_uid    - uid шефа клиента, для которого создается кампания, обязательный
        agency_uid          - uid представителя агентства (если создается агентская кампании), не обязательный
        manager_uid         - uid менеджера (если создается сервисируемая кампания), не обязательный

    !!! ОБРАТИ ВНИМАНИЕ !!!
        Результат функции логически НЕ соответствует ее названию - функция возвращает 0 (false), если создать
        кампанию можно, и код ошибки (true) если создать кампанию нельзя.


=cut

sub can_create_camp {
    my %O = @_;

    return 2 if $O{type} && $O{type} ne 'cpm_price' && $O{type} ne 'text' && Client::ClientFeatures::social_advertising_feature($O{ClientID});

    my $uid = $O{client_chief_uid};
    return 2 if ! defined $uid;

    my $client_perminfo = get_perminfo( uid => $uid )
        || die "No perminfo for user uid $uid";

    return 2 if ! (has_role( $client_perminfo, $ROLE_CLIENT ) || has_role( $client_perminfo, $ROLE_EMPTY ));

    if ( defined $O{agency_uid} ) {

        my $agency_perminfo = get_perminfo( uid => $O{agency_uid} )
            || die "No perminfo for agency uid $O{agency_uid}";

        return 2 if ! has_role( $agency_perminfo, $ROLE_AGENCY );

        return 'NOT_ENOUGH_FREEDOM'
            if ( $client_perminfo->{agency_uid} // -1 ) ne $O{agency_uid};

    } elsif ( defined $O{manager_uid} ) {

        my $manager_perminfo = get_perminfo( uid => $O{manager_uid} )
            || die "No perminfo for manager uid $O{manager_uid}";

        return 2 if ! has_role( $manager_perminfo, $ROLE_MANAGER );

        # если нет свободы создавать самоходные/сервисируемые кампании у субклиента
        return 'NOT_ENOUGH_FREEDOM' if ! rbac_check_freedom( undef, $uid );

    }
    else {

        # если нет свободы создавать самоходные/сервисируемые кампании у субклиента
        return 'NOT_ENOUGH_FREEDOM' if ! rbac_check_freedom( undef, $uid );

    }

    return 0;
}

=head2 create_empty_camp

   создает "пустую" кампанию (запись в campaigns и camp_options)

   Параметры именованные:
     client_chief_uid   -- UID главного представителя клиента
     ClientID
     agency_uid
     manager_uid
     type               -- тип кампании ('text', 'mcb', 'geo'); по умолчанию text
     client_email       -- обязательно
     client_fio         -- обязательно
     product_type       -- по умолчанию совпадает с type
     currency           -- валюта создаваемой кампании (по умолчанию YND_FIXED)
     domain             -- домен запроса на создание кампании
     cid                -- заранее сгенерированный id кампании (eсли в не пришел - получаем на месте)

=cut

sub create_empty_camp
{
    my %OPT = @_;
    my ($client_chief_uid, $agency_id,     $auid,      $muid, $mediaType, $client_email, $client_fio, $product_type, $currency, $client_id) = @OPT{
      qw/client_chief_uid  agency_id  agency_uid manager_uid        type   client_email   client_fio   product_type   currency    ClientID/};

    $mediaType ||= 'text';
    $product_type ||= $mediaType;

    if (camp_kind_in(type => $mediaType, "with_currency") || is_turkish_mcb($product_type)) {
        die 'no currency given' unless $currency;
    } else {
        # Баян и геоконтекст остаются в у.е.
        $currency = 'YND_FIXED';
    }

    my $quasi_currency_flag = 0;
    if ($currency eq 'KZT') {
        # Для клиентов в тенге испольузем квазивалютный продукт, если стоит флаг
        my $client_data = get_client_data($client_id, [qw/is_using_quasi_currency/]);
        $quasi_currency_flag = 1 if $client_data->{is_using_quasi_currency};
    }

    $agency_id = get_clientid(uid => $auid) if (defined $auid && $auid != 0);
    $agency_id //= 0;

    my $product_id = $OPT{product_id} // product_info(type => $product_type, currency => $currency, quasi_currency => $quasi_currency_flag)->{ProductID};

    # sharding: Получаем предварительный cid.
    my $cid = $OPT{cid} // get_new_id('cid', ClientID => $client_id);

    my %empty_campaign_data = (
        cid => $cid,
        ClientID => $client_id,
        uid => $client_chief_uid,
        ClientID => $client_id,
        AgencyUID => $auid,
        ManagerUID => $muid,
        AgencyID => $agency_id,
        name => $OPT{name} || '',
        statusModerate => $OPT{statusModerate} || 'New',
        sum => 0,
        sum_to_pay => 0,
        currency => $currency,
        start_time__dont_quote => 'NOW()',
        type => $mediaType,
        ProductID => $product_id,
        statusEmpty => $OPT{statusEmpty} || 'Yes',
    );

    my $strategy_id = $OPT{strategy_id} // ($mediaType ne 'wallet' && $mediaType ne 'billing_aggregate')
                      ? Client::ClientFeatures::has_get_strategy_id_from_shard_inc_strategy_id_enabled($client_id)
                          ? get_new_id('strategy_id', ClientID => $client_id)
                          : ($cid + ORDER_ID_OFFSET)
                      : 0;

    my %empty_strategy_data = (
        strategy_id => $strategy_id,
        ClientID => $client_id,
    );

    # заполняем кампанию "общий счет", если счет включен у клиента
    if (camp_kind_in(type => $mediaType, "under_wallet", "billing_aggregate")) {
        my $wallet = get_wallet_camp($client_chief_uid, $agency_id, $currency);
        if ($wallet->{wallet_cid} && $wallet->{is_enabled}) {
            $empty_campaign_data{wallet_cid} = $wallet->{wallet_cid};
            $empty_strategy_data{wallet_cid} = $wallet->{wallet_cid};
        }
    }

    my $is_performance = $mediaType eq 'performance';
    my $is_text = $mediaType eq 'text';
    my $is_mobile_content = $mediaType eq 'mobile_content';
    my $is_cpm_campaign = is_cpm_campaign($mediaType);
    my $is_media = $mediaType eq 'mcb';
    my $is_internal_campaign = is_internal_campaign($mediaType);
    my $default_strategy = $is_performance ? 'autobudget_avg_cpc_per_camp' : $is_cpm_campaign ? 'cpm_default' : 'default';
    my $default_platform = Direct::Model::Campaign->default_platform($mediaType);
    $empty_campaign_data{platform} = $default_platform;
    $empty_campaign_data{strategy_name} = $default_strategy;
    $empty_campaign_data{strategy_data} = to_json {name => $default_strategy, version => $Direct::Strategy::FORMAT_VERSION};
    $empty_campaign_data{attribution_model} = get_attribution_model_default();
    $empty_campaign_data{strategy_id} = $strategy_id;
    hash_copy \%empty_strategy_data, \%empty_campaign_data, qw/strategy_data attribution_model/;
    $empty_strategy_data{type} = $empty_campaign_data{strategy_name};
    $empty_strategy_data{is_public} = 'No';



    do_insert_into_table(PPC(cid => $cid), 'campaigns', \%empty_campaign_data);

    if ($strategy_id) {
        do_insert_into_table(PPC(cid => $cid), 'strategies', \%empty_strategy_data);
        do_insert_into_table(PPCDICT, 'shard_inc_strategy_id', { strategy_id => $strategy_id, ClientID => $client_id }, ignore => 1);
    }

    Client::on_campaign_creation($client_id, $auid, $muid);

    my %camp_options = (
        cid => $cid,
        FIO => $client_fio // '',
        email => $client_email,
        email_notifications => 'paused_by_day_budget,feed_status_change',
    );
    $camp_options{statusPostModerate} = $OPT{statusPostModerate} if defined $OPT{statusPostModerate};

    if ($is_performance) {
        $camp_options{strategy} = $default_strategy;
        do_insert_into_table(PPC(cid => $cid), 'campaigns_performance', {
            cid => $cid
        });
    }

    if ($is_cpm_campaign) {
        $camp_options{strategy} = 'different_places';
    }

    if ($is_text || $is_mobile_content) {
        $camp_options{strategy} = 'different_places';
    }

    if ($is_internal_campaign) {
        do_insert_into_table(PPC(cid => $cid), 'campaigns_internal', {
            cid => $cid
        });
    }

    do_insert_into_table(PPC(cid => $cid), 'camp_options', \%camp_options);

    if ($mediaType eq 'mobile_content') {
        do_insert_into_table(PPC(cid => $cid), 'campaigns_mobile_content', {
            cid => $cid
        });
    }


    return $cid;
}

=head2 get_camp_status_info

    $status_info = get_camp_status_info($camp);

    Возвращаем хэш со статусной информацией.
    $status_info = {
        wait_start                  => undef | 1,
        finished                    => undef | 1,
        money_finished              => undef | 1,
        stopped                     => undef | 1,
        timetarget                  => undef | 'Идут показы' | 'Показы начнутся...',
        moderate                    => undef | 'Sent' | 'Yes' | 'No' | 'Ready' | 'New',
        sum_to_pay                  => undef | 1,
        activation                  => undef | 1,
        no_active_banners           => undef | 1,
        archived                    => undef | 1,
        delayed_arc                 => undef | 'arc' | 'unarc', - запланирована ли архивация/разархивация
        day_budget                  => undef | 1, - приостановлены ли показы по достижению дневного ограничения бюджета
        no_banners                  => undef | 1, - истина, если в кампании нет объявлений
        currency_converted          => undef | 1, - истина, если кампания сконвертирована в реальную валюту
        paused_by_wallet_day_budget => undef | 1, - приостановлены ли показы по достижению дневного ограничения бюджета ОС
        strategy_finished           => undef | 1, - стратегия с произвольным периодом закончилась
        no_deals                    => undef | 1, - нет привязанных сделок у сделочной кампании
    }

=cut

sub get_camp_status_info {
    my ($camp, %O) = @_;

    my $cid = $camp->{cid};
    return get_camp_status_info_mass([$camp], %O)->{$cid};
}


=head2 get_camp_status_info_mass

Массовый вызов get_camp_status_info

=cut

sub get_camp_status_info_mass {
    my ($camps, %O) = @_;

    return {}  if !@$camps;

    my @camps_wo_has_banners = grep {!exists $_->{has_banners}} @$camps;
    my $has_banners_by_cid = mass_camps_has_banners(\@camps_wo_has_banners);

    my @cids_wo_delayed_arc =
        map {$_->{cid}}
        grep {!exists $_->{delayed_arc} || $_->{delayed_arc} && $_->{delayed_arc} !~ /^(?:arc|unarc)$/}
        @$camps;
    my $camp_delayed_arc_by_cid = camp_delayed_arc(\@cids_wo_delayed_arc);

    my %type_by_cid = map {($_->{cid} => $_->{type} || $_->{mediaType} || get_camp_type(cid => $_->{cid}))} @$camps;
    my @cids_wo_has_active_banners =
        map {$_->{cid}}
        grep {(!defined $_->{has_banners} || $_->{has_banners}) && !exists $_->{has_active_banners}}
        @$camps;
    my $has_active_banners_by_cid = Models::Banner::mass_has_camps_active_banners(\@cids_wo_has_active_banners, \%type_by_cid);

    my $is_campaign_finished_by_cid = is_campaign_finished_mass($camps);

    my $campaign_has_deals = campaign_has_deals($camps, \%type_by_cid);

    my %result;
    my @check_day_budget_stop_time_camps;
    for my $camp (@$camps) {
        my $cid = $camp->{cid};

    my $status_info = {
        wait_start        => undef,
        finished          => undef,
        money_finished    => undef,
        stopped           => undef,
        timetarget        => undef,
        moderate          => undef,
        sum_to_pay        => undef,
        activation        => undef,
        no_active_banners => undef,
        archived          => undef,
        delayed_arc       => undef,
        day_budget        => undef,
        no_banners        => undef,
        currency_converted  => undef,
        paused_by_wallet_day_budget => undef,
        strategy_finished => undef,
        no_deals          => undef,
    };

    my $sum = $camp->{sum};
    my $sum_total = $camp->{sum} - $camp->{sum_spent};
    if ($camp->{wallet_cid}) {
        # NB! Описанный здесь способ учета денег на общем счете - некорректный (с самого начала).
        # Он не учитывает перетраты "соседних" по кошельку кампаний (получается, что остаток - завышается,
        # в реальности эта часть денег общего счета уже потрачена другими кампаниями).
        # До "неотключаемого" общего счета - биллинг по ночам "выравнивал" суммы, покрывая перетраты с кошелька.
        # При неотключаемом ОС - этого не происхожит, и у кампаний под кошельком - перманентный "минус" (sum <= sum_spent).
        # Правильный способ расчета остатка по кампании в группе - с использованием get_sum_debt_for_wallets_by_uids, в sums_uni оно учтено.
        # Текущий код - не стоит никуда портировать и править, все места НУЖНО переделать на sums_uni.

        # если кампания подключена к общему счету, то нужно добавить суммы на общем счете

        # НЕ прибавляем сумму на общем счете ВТОРОЙ раз,
        # если сумма на кампании $camp->{sum} уже включает в себя $camp->{wallet_sum}
        unless ($camp->{sum_counted_with_wallet}) {
            $sum += ($camp->{wallet_sum} // 0);
            $sum_total += ($camp->{wallet_sum} //0);
        }

        $sum_total -= ($camp->{wallet_sum_spent} // 0);
    }

    # Поддержка sums_uni
    if ($camp->{sums_uni}) {
        $sum_total = $camp->{sums_uni}->{total};

        # Для некошельков мы добавляем автоовердрафт к основному балансу кампании перед тем, как вычислять статусы
        if (!Campaign::Types::is_wallet_camp(type => ($camp->{mediaType} || $camp->{type}))) {
            $sum_total += $camp->{sums_uni}->{auto_overdraft_addition};
        }
    }

    # при вызове из get_user_camps эти параметры уже есть - не делаем лишних запросов в базу
    my $camp_type = $type_by_cid{$cid};
    my $check_finish_time = camp_kind_in(type => $camp_type, 'base', 'media');

    my $camp_has_banners = exists $camp->{has_banners} ? $camp->{has_banners} : $has_banners_by_cid->{$camp->{cid}};
    $status_info->{no_banners} = 1 unless $camp_has_banners;

    my $camp_delayed_arc = exists $camp->{delayed_arc}
                               && (!$camp->{delayed_arc} || $camp->{delayed_arc} =~ /^(?:arc|unarc)$/)
                                   ? $camp->{delayed_arc} : $camp_delayed_arc_by_cid->{$camp->{cid}};
    if ($camp_delayed_arc) {
        $status_info->{delayed_arc} = $camp_delayed_arc;
    }

    my $strategy = $camp->{strategy_decoded} // from_json ($camp->{strategy_data} || '{}');

    if ($sum_total < $Currencies::EPSILON
            && $camp->{OrderID} != 0 && $sum > $Currencies::EPSILON
    ) {
        $status_info->{money_finished} = 1;
    } elsif ( $sum_total > $Currencies::EPSILON && $camp->{statusShow} eq 'No' ) {
        $status_info->{stopped} = 1;
    } elsif ( $sum_total > $Currencies::EPSILON && $camp->{statusShow} eq 'Yes' && ($camp->{statusModerate} eq 'Yes' || $camp->{statusActive} eq 'Yes') && $camp->{statusPostModerate} ne 'Yes') {
        $status_info->{timetarget} = TimeTarget::timetarget_status($camp->{timeTarget}, $camp->{timezone_id});
        # !!! не очень хорошо, что timetarget возвращает "Идут показы"

        my $start_date = mysql_round_day($camp->{start_time});
        my $strategy_start = mysql_round_day($strategy->{start});
        if (($start_date && today() lt $start_date) ||
            ($strategy_start && today() lt $strategy_start)) {
            $status_info->{wait_start} = 1;
        }

        my $has_active_banners;
        if ( exists $camp->{is_active} ) {
            $has_active_banners = $camp->{is_active};
        } elsif ($camp_has_banners) {
            if ( exists $camp->{has_active_banners} ) {
                $has_active_banners = $camp->{has_active_banners};
            } else {
                $has_active_banners = $has_active_banners_by_cid->{$cid};
            }
        } else {
            $has_active_banners = 0;
        }

        if (! $has_active_banners) {
            $status_info->{no_active_banners} = 1;
        }

        if ($check_finish_time) {
            if ($is_campaign_finished_by_cid->{$cid}) {
                $status_info->{finished} = 1;
            } elsif ($camp->{OrderID}) {
                push @check_day_budget_stop_time_camps, $camp;
            }
        }

        my $strategy_finish = mysql_round_day($strategy->{finish});
        if ($strategy_finish && today() gt $strategy_finish) {
            $status_info->{strategy_finished} = 1;
        }

    } elsif ( $camp->{statusModerate} eq 'Yes' && $camp->{sum_to_pay} > $Currencies::EPSILON && $camp->{statusPostModerate} ne 'Yes') {
        $status_info->{sum_to_pay} = 1;
    }

    if ($camp->{statusModerate} eq 'Yes' && $camp->{statusPostModerate} eq 'Yes') {
        $status_info->{moderate} = 'Sent';
    } else {
        $status_info->{moderate} = $camp->{statusModerate};
    }

    if ( $camp->{sum_to_pay} > $Currencies::EPSILON ) {
        $status_info->{sum_to_pay} = 1;
    }

    # проверяем, совпадает ли statusActive(из БК) с тем что должно быть
    my $statusActive_new = $sum_total > $Currencies::EPSILON && $camp->{statusShow} eq 'Yes' ? 'Yes' : 'No';
    if ($sum_total > $Currencies::EPSILON
        && ( $camp->{statusBsSynced} ne 'Yes'
             || $camp->{statusActive} && $camp->{statusActive} ne $statusActive_new
             || check_mysql_date($camp->{stopTime}) && time - mysql2unix($camp->{stopTime}) < $Settings::TRANSFER_DELAY_AFTER_STOP
         )
        && $camp->{statusPostModerate} eq 'Accepted'
        # костыль для случая, когда все баннеры остановлены и из БК пришел statusActive = 'No', но statusShow = 'Yes'
        && !($status_info->{no_active_banners} && $camp->{statusActive} && $camp->{statusActive} eq 'No' && $camp->{statusBsSynced} eq 'Yes')
    ) {
        $status_info->{activation} = 1;
    }

    if ($camp->{archived} && $camp->{archived} eq 'Yes') {
        $status_info->{archived} = 1;

        if (($camp->{currency} || 'YND_FIXED') eq 'YND_FIXED' && $camp->{currencyConverted} eq 'Yes') {
            $status_info->{currency_converted} = 1;
        }

        $status_info->{delayed_arc} = $camp_delayed_arc;
    }

    if (($camp_type eq 'cpm_deals') && !$campaign_has_deals->{$cid}) {
            $status_info->{no_deals} = 1;
    }

    $result{$cid} = $status_info;
    }

    if (@check_day_budget_stop_time_camps) {
        _calc_paused_by_day_budget_statuses(\%result, \@check_day_budget_stop_time_camps);
    }

    return \%result;
}

=head2 _calc_paused_by_day_budget_statuses($camps)

    Смотрим только на наличие присланного БК времени остановки, статистику за текущий день не проверяем

=cut
sub _calc_paused_by_day_budget_statuses {
    my ($result, $camps) = @_;

    my @check_day_budget_camps;
    # выставляем остановки по дневному бюджету ОС, т.к. они имеют приоритет над остановками по дневному бюджету кампании
    # если по дневному бюджету ОС нет остановки, но у кампании есть свой дневной бюджет, то отмечаем ее в @check_day_budget_camps,
    # чтобы позже проверить ее открутки
    for my $camp (@$camps) {
        my $status_info = $result->{$camp->{cid}};

        if ($camp->{wallet_cid} && defined $camp->{wallet_day_budget} && $camp->{wallet_day_budget} > 0 && $camp->{wallet_day_budget_stop_time} !~ /^0000/ &&
                mysql_round_day($camp->{wallet_day_budget_stop_time}) eq today())
        {
            $status_info->{paused_by_wallet_day_budget} = 1;
        } elsif (defined $camp->{day_budget} && $camp->{day_budget} > 0
                 && $camp->{day_budget_stop_time} && $camp->{day_budget_stop_time} !~ /^0000/ && mysql_round_day($camp->{day_budget_stop_time}) eq today()
        ) {
            $status_info->{day_budget} = 1;
        }
    }
}

=head2 CalcCampStatus

    Вычисляет статус кампании.

    $status = CalcCampStatus($camp, %opt);
    %opt = (
        easy_user =>
    );

=cut

sub CalcCampStatus {
    my ($camp, %opt) = @_;

    my $cid = $camp->{cid};
    return CalcCampStatus_mass([$camp], %opt)->{$cid};
}


=head2 CalcCampStatus_mass

    Массово вычисляет статусы кампаний.

    $status = CalcCampStatus($camps, %opt);
    %opt = (
        easy_user =>
    );

=cut

sub CalcCampStatus_mass
{
    my ($camps, %opt) = @_;

    return {}  if !@$camps;

    # get_camp_status_info
    my $status_info_by_cid = get_camp_status_info_mass($camps);

    my %result;
    for my $camp (@$camps) {
        my $cid = $camp->{cid};
        $result{$cid} = _resolve_campaign_status($camp, $status_info_by_cid->{$cid}, %opt);
    }

    return \%result;
}


# приоритетность статусов в этой функции учитывалась в логике вычисления статусов day_budget и paused_by_wallet_day_budget
# в get_camp_status_info_mass т.к. они вычисляются тяжело. Нужно иметь в виду, если приоритетность будет изменяться
sub _resolve_campaign_status {
    my ($camp, $status_info, %opt) = @_;

    my $status = {};
    my $status_text;
    my $strategy = $camp->{strategy_decoded} // from_json ($camp->{strategy_data} || '{}');
    if ($status_info->{archived}) {

        if ($status_info->{currency_converted}) {
            $status_text = iget("Сконвертирована");
        } else {
            $status_text = iget("Кампания перенесена в архив");
            if ($status_info->{delayed_arc} && $status_info->{delayed_arc} eq 'unarc') {
                $status_text .= ". " . iget("Ожидает разархивирования");
            }
        }

    } else {

        if ($status_info->{no_banners} && (!$status_info->{moderate} || $status_info->{moderate} ne 'New')) {
            $status_text = iget('Нет объявлений');
        } elsif ( $status_info->{no_active_banners} ) {
            $status_text = iget("Нет активных объявлений");
        } elsif ( $status_info->{wait_start} ) {
            if ($strategy->{start}){
                $status_text = join "\x{00A0}", (iget('Ожидает старта стратегии'), mysql2human_date($strategy->{start}));
            } else {
                $status_text = iget('Начало %s', mysql2human_date($camp->{start_time}));
            }
        } elsif ( $status_info->{finished} ) {
            $status_text = iget('Кампания закончилась %s', mysql2human_date($camp->{finish_time}));
            $status->{is_over} = 1;
        } elsif ( $status_info->{strategy_finished} ) {
            if ($strategy->{auto_prolongation}){
                $status_text = iget('Закончился период действия стратегии. Режим автопродления');
            } else {
                $status_text = iget('Закончился период действия стратегии');
            }
        } elsif ( $status_info->{moderate} eq 'Yes' && $status_info->{money_finished} ) {
            $status_text = iget("Средства на счете закончились");
        } elsif ( $status_info->{stopped} ) {
            $status_text = iget("Кампания остановлена");
        } elsif ( $status_info->{paused_by_wallet_day_budget}) {
            if ( $camp->{wallet_day_budget_stop_time} && $camp->{wallet_day_budget_stop_time} !~ /^0000/ ) {
                my $stop_ts = mysql2unix($camp->{wallet_day_budget_stop_time});
                $status_text = iget('Показы приостановлены по дневному ограничению общего счёта в %s (MSK)', unix2human($stop_ts, '%H:%M'));
            } else {
                # недостижимая ветка, должна остаться только предыдущая
                $status_text = iget('Показы приостановлены по дневному ограничению общего счёта ');
            }
        } elsif ( $status_info->{day_budget} ) {
            my $stop_ts;
            $stop_ts = eval { mysql2unix($camp->{day_budget_stop_time}) } if $camp->{day_budget_stop_time};
            if ( $stop_ts ) {
                $status_text = iget('Показы приостановлены по дневному ограничению в %s (MSK)', unix2human($stop_ts, '%H:%M'));
            } else {
                # недостижимая ветка, должна остаться только предыдущая
                $status_text = iget('Показы приостановлены по дневному ограничению');
            }
        } elsif ( $status_info->{timetarget} ) {
            $status_text = $status_info->{timetarget};
        } elsif ( $status_info->{sum_to_pay} && $status_info->{moderate} eq 'Yes' ) {
            $status_text = iget("Ждёт оплаты");
        } elsif ( $status_info->{moderate} ) {
            $status_text = iget($BannersCommon::MODERATE_STATUS{ $status_info->{moderate} });
            if ( $status_info->{sum_to_pay} && !$opt{easy_user} && $status_info->{moderate} ne 'No' ) {
                $status_text .= ". " . iget("Ждёт оплаты");
            } elsif ($status_info->{moderate} eq 'New') {
                $status->{is_draft} = 1;
            }
        }

        if ($status_info->{delayed_arc} && $status_info->{delayed_arc} eq 'arc') {
            $status_text .= ". " . iget("Ожидает архивирования");
        }
    }

    if ( $status_info->{activation} && $status_info->{moderate} eq 'Yes' ) {
        $status_text .= ". " . iget("Идет активизация");
    }

    if ( !$status_info->{finished} && !$status_info->{wait_start} ) {
        my $finish_date = mysql_round_day( $camp->{finish_time} );
        if ( $finish_date ) {
            if ( today() le $finish_date ) {
                $status_text .= '. ' . iget('Дата окончания кампании %s', mysql2human_date($finish_date));
            } else {
                $status_text .= '. ' . iget('Кампания закончилась %s', mysql2human_date($finish_date));
                $status->{is_over} = 1;
            }
        }
    }

    if ($status_info->{no_deals}){
        $status_text .= ". " . iget("Нет привязанных сделок");
    }

    $status->{text} = $status_text;
    if ($status_info) {
        $status->{info} = $status_info;
    }

    return $status;
}

# DIRECT-27454 Округлять дробные остатки на кампаниях до 0,01
# для корректного отображения остатков в интерфейсе приводим остаток к одному центу/копейке,
# если остаток меньше цента/копейки, но больше того, что мы считаем нулем (т.е. $EPSILON'а)
# иначе просто округляем
sub correct_sum_and_total
{
    my ($campaign) = @_;

    my @fields_to_correct = qw/sum wallet_sum total wallet_total/;
    for my $field (@fields_to_correct) {
        if (defined $campaign->{$field}) {
            $campaign->{$field} = round_campaign_sum_field($campaign->{$field});
        }
    }

    # Поддержка sums_uni
    if ($campaign->{sums_uni}) {
        correct_sum_and_total($campaign->{sums_uni});
    }

    return;
}

=head3 round_campaign_sum_field

Выполнить логику, описанную в correct_sum_and_total, над входным значением и вернуть новое значение

=cut

sub round_campaign_sum_field {
    my $sum = shift;
    if (round2s($sum) == 0 && $sum >= $Currencies::EPSILON) {
        $sum = 0.01;
    } else {
        $sum = round2s($sum);
    }
    return $sum;
}

=head2 CheckCreateCamp

    my $camp_info = CheckCreateCamp(
        $uid, $cid, $email, $fio, $phone,
    );

=cut
sub CheckCreateCamp
{
    my ($uid, $cid, $email, $fio, $phone) = @_;

    return undef unless $cid =~ m/^\d+$/;

    my $vars = get_one_line_sql(PPC(uid => $uid), qq{select c.cid
                                              , c.name
                                              , c.ClientID
                                              , DATE_FORMAT(c.start_time, '%Y%m%d000000') start_time
                                              , c.finish_time
                                              , c.statusModerate
                                              , c.statusEmpty
                                              , c.sum + IF(c.wallet_cid, wc.sum, 0) as sum
                                              , c.sum_spent + IF(c.wallet_cid, wc.sum_spent, 0) as sum_spent
                                              , IF(c.wallet_cid, wc.sum, 0) as wallet_sum
                                              , IF(c.wallet_cid, wc.sum_spent, 0) as wallet_sum_spent
                                              , IFNULL(c.shows, 0) as shows
                                              , c.clicks
                                              , c.sum_units
                                              , c.sum_spent_units
                                              , IFNULL(c.currency, 'YND_FIXED') AS currency
                                              , c.statusShow
                                              , c.statusActive
                                              , c.OrderID
                                              , c.sum_to_pay
                                              , c.statusBsSynced
                                              , c.ManagerUID
                                              , c.AgencyUID
                                              , c.AgencyID
                                              , c.DontShow
                                              , c.disabled_ssp
                                              , c.disabled_video_placements
                                              , c.archived
                                              , c.platform
                                              , IFNULL(s.type, '') as strategy_name
                                              , IFNULL(s.strategy_data, '{"name":"default"}') as strategy_data
                                              , s.enable_cpc_hold
                                              , c.autobudget
                                              , c.autobudget_date
                                              , cdmo.now_optimizing_by
                                              , c.autobudgetForecast
                                              , c.autobudgetForecastDate
                                              , c.autoOptimization
                                              , c.timeTarget
                                              , c.timezone_id
                                              , c.statusOpenStat
                                              , c.disabledIps
                                              , c.type as mediaType
                                              , c.ProductID
                                              , c.rf
                                              , c.rfReset
                                              , s.ContextLimit
                                              , c.ContextPriceCoef
                                              , c.attribution_model
                                              , c.ab_segment_stat_ret_cond_id
                                              , c.ab_segment_ret_cond_id
                                              , c.brandsafety_ret_cond_id
                                              , co.statusContextStop
                                              , co.strategy
                                              , co.competitors_domains
                                              , co.banners_per_page
                                              , caq.operation as delayed_arc
                                              , IFNULL(cdc.domains_count, 0) as compaign_domains_count
                                              , c.day_budget
                                              , c.day_budget_show_mode
                                              , co.day_budget_daily_change_count
                                              , co.day_budget_stop_time
                                              , co.mobile_app_goal
                                              , s.meaningful_goals
                                              , co.allowed_page_ids
                                              , c.wallet_cid
                                              , IF(c.wallet_cid, wco.money_warning_value, NULL) as wallet_money_warning_value
                                              , c.opts
                                              , cmc.is_installed_app
                                              , cmc.device_type_targeting
                                              , cmc.network_targeting
                                              , cmc.mobile_app_id
                                              , mc.metrika_counters
                                              , co.brand_survey_id
                                              , (SELECT is_lego_mediaplan FROM mediaplan_stats ms WHERE ms.cid = c.cid ORDER BY create_time DESC LIMIT 1) as is_lego_mediaplan
                                              , wc.day_budget as wallet_day_budget
                                              , wc.day_budget_show_mode as wallet_day_budget_show_mode
                                              , wco.day_budget_stop_time AS wallet_day_budget_stop_time
                                              , cd.client_dialog_id
                                              , cld.skill_id AS dialog_id
                                              , cld.name AS dialog_name
                                              , cf.allowed_frontpage_types
                                              , ci.is_mobile as is_mobile
                                              , ci.restriction_type as restriction_type
                                              , ci.restriction_value as restriction_value
                                              , ci.page_ids as page_ids
                                              , ci.place_id as place_id
                                              , ci.rotation_goal_id as rotation_goal_id
                                           from campaigns c
                                                left join campaigns wc on wc.cid = c.wallet_cid
                                                left join camp_options co on co.cid = c.cid
                                                left join strategies s on c.strategy_id = s.strategy_id
                                                left join camp_options wco on wco.cid = c.wallet_cid
                                                left join camp_operations_queue caq on caq.cid=c.cid
                                                left join camp_domains_count cdc on cdc.cid = c.cid
                                                left join campaigns_mobile_content cmc on cmc.cid = c.cid
                                                left join campaigns_performance cdmo on cdmo.cid = c.cid
                                                left join camp_metrika_counters mc on mc.cid = c.cid
                                                left join camp_dialogs cd on cd.cid = c.cid
                                                left join campaigns_cpm_yndx_frontpage cf on cf.cid = c.cid
                                                left join campaigns_internal ci on ci.cid = c.cid
                                                left join client_dialogs cld on cld.client_dialog_id = cd.client_dialog_id
                                          where c.uid=? and c.cid=?
                                          }, $uid, $cid );
    return undef unless $vars && $vars->{cid};

    _deserialize_camp_fields($vars);
    $vars->{product_type} = product_info(ProductID => $vars->{ProductID})->{product_type};

    convert_dates_for_template($vars, keep_source_data => 1, with_old_start_date_format => 1);

    $vars->{addbanner} = 'Yes' if ($vars->{statusEmpty} eq 'Yes');
    $vars->{total} = int(($vars->{sum} - $vars->{sum_spent}) * 100 + 0.5) / 100;
    $vars->{total_units} = ($vars->{sum_units} // 0) -  ($vars->{sum_spent_units} // 0);
    $vars->{sum} = int($vars->{sum} * 100 + 0.5) / 100;
    $vars->{sum_counted_with_wallet} = 1;
    $vars->{strategy} = campaign_strategy($vars);

    my $failed_to_fetch_metrika_goals;

    my $client_id = get_clientid(uid => $uid);
    hash_merge $vars, CampaignTools::get_campaign_goals($cid, include_multi_goals => Client::ClientFeatures::is_allowed_step_goals_in_strategies($client_id), show_goal_types => 1);

    CampaignTools::actualize_metrika_goals($vars, skip_errors => \$failed_to_fetch_metrika_goals);
    $vars->{failed_to_fetch_metrika} = 1 if $failed_to_fetch_metrika_goals;

    $vars->{MIN_GOALS_ON_CAMPAIGN} = $Settings::MIN_GOALS_ON_CAMPAIGN;

    if (defined $email || defined $fio || defined $phone) {
        my $sth = exec_sql(PPC(uid => $uid), q{select email, fio, phone, valid, sendNews, sendWarn, sendAccNews from users where uid = ?}, $uid );

        if ($sth->rows) {
            ($vars->{email}, $vars->{fio}, $vars->{phone},
             $vars->{valid}, $vars->{sendNews}, $vars->{sendWarn}, $vars->{sendAccNews}) = $sth->fetchrow_array;
        } else {
            $vars->{email} = $email;
            $vars->{fio} = $fio;
            $vars->{phone} = $phone;
        }
        $sth->finish;
    }

    # get data from camp_options
    my $camp_options = get_one_line_sql(PPC(uid => $uid), "select fio, email, valid,
                                                      sendWarn, sendAccNews,
                                                      stopTime,
                                                      money_warning_value,
                                                      sms_time, sms_flags,
                                                      statusMetricaControl,
                                                      status_click_track,
                                                      warnPlaceInterval, camp_description, banners_per_page,
                                                      DATE_FORMAT(last_pay_time,'%Y-%m-%d') as last_pay_time,
                                                      fairAuction = 'Yes' as fairAuction,
                                                      offlineStatNotice = 'Yes' as offlineStatNotice,
                                                      email_notifications,
                                                      statusContextStop,
                                                      statusPostModerate
                                                      , broad_match_flag = 'Yes' as broad_match_flag
                                                      , broad_match_limit
                                                      , broad_match_goal_id
                                                      , minus_words
                                                      , device_targeting
                                                      , content_lang
                                                      , impression_standard_time
                                                      , eshows_banner_rate
                                                      , eshows_video_rate
                                                      , eshows_video_type
                                               from camp_options
                                               where cid = ?", $cid);

    $camp_options->{is_camp_locked} = new LockObject({object_type=>'campaign', object_id=>$cid})->load() ? 1 : 0;
    $camp_options->{minus_words} = MinusWordsTools::minus_words_str2array($camp_options->{minus_words});

    if (ref($camp_options) eq 'HASH') {
        $vars->{sms_flags} = campaign_sms_flags(delete $camp_options->{sms_flags});
        $camp_options->{email_notifications} = {map {$_ => 1} split /\,/, $camp_options->{email_notifications}};
        $camp_options->{device_targeting} = {map {$_ => 1} split /\,/, $camp_options->{device_targeting}};
        hash_merge $vars, $camp_options;
    }
    if(! defined $vars->{warnPlaceInterval} ){$vars->{warnPlaceInterval} = $Settings::DEF_WARN_PLACE_INTERVAL;}
    $vars->{geo} = get_common_geo_for_camp($vars->{cid});
    $vars->{opts} = {map {$_ => 1} split ',', $vars->{opts}};
    if ($vars->{enable_cpc_hold} && $vars->{enable_cpc_hold} eq 'Yes') {
        $vars->{opts}->{enable_cpc_hold} = 1;
    }
    $vars->{hierarchical_multipliers} = JavaIntapi::GetBidModifiers->new(campaign_id => $vars->{cid})->call();
    $vars->{multipliers_meta} = Direct::Validation::HierarchicalMultipliers::get_metadata($vars->{mediaType});

    $vars->{wallet} = {
        day_budget => $vars->{wallet_day_budget},
        day_budget_show_mode => $vars->{wallet_day_budget_show_mode},
    };

    return $vars;
}

=head2 count_campaign_items($cid)

    Подсчитывает количество объектов в кампании в разрезе статусов
    Результат:
        {
            tabclass_wait_count => 10,
            tabclass_off_count => 8,
            tabclass_draft_count => 0,
	    ...
        }

=cut

sub count_campaign_items {

    my $cid = shift;

    my $ppc_shard = PPC(cid => $cid);
    my $items = {};
    if (camp_kind_in(cid => $cid, 'base')) {

        my @tabs = qw/wait arch off active decline draft/;
        my $fields = join ",\n", map {
            my $tab = $_;
            my %condition = Models::AdGroupFilters::get_status_condition($tab, filter => {cid => $cid});
            sprintf 'COUNT(DISTINCT IF(%s, g.pid, null)) %s',
                sql_condition($condition{where}),
                $tab
        } @tabs;
        my $sql = [qq{
            SELECT
                COUNT(DISTINCT g.pid) `all`,
                $fields
            FROM
                phrases g
                LEFT JOIN banners b ON g.pid = b.pid
                LEFT JOIN banner_images bim ON b.bid=bim.bid
                LEFT JOIN adgroups_mobile_content amc ON amc.pid=g.pid
                LEFT JOIN mobile_content mc ON mc.mobile_content_id = amc.mobile_content_id
                LEFT JOIN banners_performance perfb ON b.bid = perfb.bid
                LEFT JOIN perf_creatives perfc ON perfc.creative_id = perfb.creative_id
                LEFT JOIN images im on im.bid = b.bid
                LEFT JOIN (select i_mbp.bid, IF(SUM(i_mbp.statusModerate = "Yes") > 0, "Yes", IF(SUM(i_mbp.statusModerate = "Ready" or i_mbp.statusModerate = "Sent" or i_mbp.statusModerate = "Maybe") > 0, "Ready", "No")) as pageStatusModerate from moderate_banner_pages i_mbp join banners b on i_mbp.bid = b.bid where b.cid = $cid and i_mbp.is_removed = 0 group by b.bid) mbp on mbp.bid = b.bid
                LEFT JOIN banner_turbolandings btl ON btl.bid = b.bid
                LEFT JOIN banners_minus_geo bmg ON b.bid = bmg.bid and bmg.type = "current"
            WHERE g.cid = ?}];
        $items = get_one_line_sql($ppc_shard, $sql, $cid);
        $items->{media} = get_one_field_sql($ppc_shard, "
            SELECT COUNT(*) as media
              FROM mediaplan_banners b
             WHERE b.cid = ?", $cid);

    } elsif (is_media_camp(cid => $cid)) {

        $items = get_one_line_sql($ppc_shard, "
                SELECT SUM(1) as `all`,
                       SUM(IF((g.statusModerate in ('Ready', 'Sent', 'Sending') OR b.statusModerate in ('Ready', 'Sent', 'Sending')) AND b.statusArch='No',1,0)) as `wait`,
                       SUM(IF(b.statusArch='Yes',1,0)) as `arch`,
                       SUM(IF(b.statusShow='No' AND b.statusArch='No',1,0)) as `off`,
                       SUM(IF($MTools::IS_ACTIVE_MEDIA_CLAUSE,1,0)) as `active`,
                       SUM(IF((b.statusModerate='No' OR g.statusModerate='No') AND b.statusArch = 'No',1,0)) as `decline`,
                       SUM(IF(b.statusModerate = 'New' and g.statusModerate = 'New' and b.statusArch = 'No',1,0)) as `draft`
                 FROM media_groups g
                      LEFT JOIN media_banners b USING(mgid)
                 WHERE g.cid = ?",
               $cid);

    }

    return hash_kmap { "tabclass_${_}_count" } $items;
}


=head2 send_camp_to_service

    Переводит кампанию на сервесируемость.
    Если у клиента один менеджер, кампания автоматически переводится к нему
    Иначе - отправляется запрос на сервисирование

    Параметры:
        main_cid - id кампании, которую переводим
        client_chief_uid - uid клиента (главного представителя)
        other_manager_uid - uid менеджера
        options:
            use_offer_method => использовать метод offer&accept для перевода на сервисируемость (работает под менеджером)
            send_other_camps => отправлять на сервисируемость под того же менеджера и другие свободные кампании клиента
            force  => используется для принудительного перевода на сервисируемость
            (если несколько менеджеров и кампания не ожидает перевода ПРОИСХОДИТ ИЗ ПОД СУПЕРПОЛЬЗОВАТЕЛЯ
            В этом случае опция use_offer_method игнорируется.

=cut

sub send_camp_to_service
{
    my (undef, $main_cid, $client_chief_uid, $other_manager_uid, %options) = @_;


    # Если кампания уже сервисируемая или агентская, то ничего не делаем
    return if rbac_is_scampaign(undef, $main_cid) || rbac_is_agencycampaign(undef, $main_cid);

    my $user_info = get_user_data($client_chief_uid, [qw/login ClientID fio email phone/]);
    my $manager_info = get_user_data($other_manager_uid, [qw/fio email login/]);

    my $servicing_manager_uid = Primitives::get_auto_servicing_manager_uid($client_chief_uid);
    if (!$servicing_manager_uid) {
        $servicing_manager_uid = Primitives::get_idm_primary_manager_uid($user_info->{ClientID});
    }

    # Если указана опция force, то забиндим клиента под нужного менеджера
    if ($options{force}) {
        rbac_bind_manager(undef, $other_manager_uid, $client_chief_uid);
    }

    # Если кампания ожадает перевода - то переведем ее на $other_manager_uid, не обращая внимания на auto_servicing_manager_uid
    # Если кампания чистая и auto_servicing_manager_uid == $other_manager_uid, то переводим ее, иначе - переводим в состояние ожидания
    # Если кампания переводится, учитываем параметр send_other_camps

    if ($options{force} || rbac_get_camp_wait_servicing(undef, $main_cid) || ($servicing_manager_uid && $servicing_manager_uid == $other_manager_uid)) {
        my @cids;
        my $camps_info;

        if ($options{send_other_camps}) {
            $camps_info = get_hashes_hash_sql(PPC(uid => $client_chief_uid), [q{
                SELECT c.cid, c.name, c.type
                FROM campaigns c
            }, where => {
                uid => SHARD_IDS, ManagerUID__is_null => 1,
                AgencyUID__is_null => 1,
                archived => 'No', statusEmpty => 'No',
                # mcb не отправляем на авто-сервесирование
                type => ['wallet', 'billing_aggregate', @{get_camp_kind_types('web_edit_base')}]
            }]);
            # $main_cid обязательно должен быть среди (keys %$camps_info)
            push @cids, keys %$camps_info;
        } else {
            push @cids, $main_cid;
            $camps_info = get_hashes_hash_sql(PPC(cid => \@cids), [q{
                SELECT c.cid, c.name, c.type
                FROM campaigns c
            }, where => {cid => SHARD_IDS}]);
        }

        for my $cid (@cids) {
            # Для опции force всегда используем rbac_move_nscamp_to_scamp
            if (rbac_get_camp_wait_servicing(undef, $cid) && !$options{force}) {
                my $error = rbac_accept_servicing(undef, $cid, $client_chief_uid, $other_manager_uid);
                croak "rbac_accept_servicing(undef, $cid, $client_chief_uid, $other_manager_uid) == $error" if $error;
            } else {
                my $error;
                if ($options{use_offer_method} && !$options{force}) {
                    $error = rbac_offer_to_servicing(undef, $cid);
                    croak "rbac_offer_to_servicing(undef, $cid) == $error" if $error;
                    $error = rbac_accept_servicing(undef, $cid, $client_chief_uid, $other_manager_uid);
                    croak "rbac_accept_servicing(undef, $cid, $client_chief_uid, $other_manager_uid) == $error" if $error;
                } else {
                    $error = rbac_move_nscamp_to_scamp(undef, $cid, $other_manager_uid, $client_chief_uid);
                    croak "rbac_move_nscamp_to_scamp(undef, $cid, $other_manager_uid, $client_chief_uid) == $error" if $error;
                }
            }

            # (!!!) Чтобы избежать расхождения данных в RBAC и PPC, проводим все операции для каждой кампании по отдельности
            # (!!!) Т.к. при установленном send_other_camps после применения операций в RBAC для одной, они могут отвалиться для другой
            do_update_table(PPC(cid => $cid), 'campaigns', {
                ManagerUID => $other_manager_uid,
                statusBsSynced => 'No'
            }, where => {cid => SHARD_IDS});

            on_auto_servicing(undef, $cid, $other_manager_uid, $camps_info->{$cid}, $user_info, $manager_info);
        }
    } else {
        my $camp_info = get_one_line_sql(PPC(cid => $main_cid), [q{
            SELECT c.cid, c.name, c.type
            FROM campaigns c
        }, where => {cid => SHARD_IDS}]);

        offer_to_servicing(undef, $main_cid, $other_manager_uid, $camp_info, $user_info, $manager_info);
    }

    return;
}

=head2 on_auto_servicing(undef, $cid, $manager_uid, $camp_info, $user_info, $manager_info)

    Действия над кампанией после того, как ее автоматически повесили на менеджера

    $camp_info = {
        name => ...
        type => ...
    }

    $user_info = {
        ClientID => ...
        email => ...
        phone => ...
        login => ...
        fio => ...
    }

    $manager_info = {
        fio => ...
    }

=cut

sub on_auto_servicing {
    my (undef, $cid, $manager_uid, $camp_info, $user_info, $manager_info) = @_;

    # В случае, если у пользователя были заявки на ПП, меняем у них статус
    process_FA_request_on_set_servicing(undef, $cid);

    campaign_manager_changed(undef, $manager_uid, $cid, $manager_uid);

    my $mailvars = {
        cid           => $cid,
        camp_name     => $camp_info->{name},
        campaign_id   => $cid,
        campaign_name => $camp_info->{name},
        campaign_type => ($camp_info->{type} || 'text'),
        manager_uid   => $manager_uid,
        manager_fio   => $manager_info->{fio},
        user_login    => $user_info->{login},
        client_login  => $user_info->{login},
        client_id     => $user_info->{ClientID},
        client_fio    => $user_info->{fio},
        fio           => $user_info->{fio},
        client_email  => $user_info->{email},
        client_phone  => $user_info->{phone},
    };

    # Посылаем письмо менеджеру
    add_notification(undef, 'auto_servicing', $mailvars);
}

=head2 offer_to_servicing(undef, $cid, $manager_uid, $camp_info, $user_info, $manager_info)

    Зарегистрировать запрос на сервисирование кампании

    $camp_info = {
        name => ...
        type => ...
    }

    $user_info = {
        ClientID => ...
        email => ...
        phone => ...
        login => ...
        fio => ...
    }

    $manager_info = {
        fio => ...
    }
=cut

sub offer_to_servicing {
    my (undef, $cid, $manager_uid, $camp_info, $user_info, $manager_info) = @_;

    my $error = rbac_offer_to_servicing(undef, $cid);
    croak "rbac_offer_to_servicing(undef, $cid) == $error" if $error;

    my $mailvars = {
        cid           => $cid,
        camp_name     => $camp_info->{name},
        campaign_id   => $cid,
        campaign_name => $camp_info->{name},
        campaign_type => ($camp_info->{type} || 'text'),
        manager_uid   => $manager_uid,
        manager_fio   => $manager_info->{fio},
        user_login    => $user_info->{login},
        client_login  => $user_info->{login},
        client_id     => $user_info->{ClientID},
        client_fio    => $user_info->{fio},
        fio           => $user_info->{fio},
        client_email  => $user_info->{email},
        client_phone  => $user_info->{phone},
    };

    # Посылаем письмо менеджеру
    add_notification(undef, 'servicing_request', $mailvars);
}

=head2 notify_managers_about_new_free_camp($rbac, $cid, $client_chief_uid, $client_managers, $camp_info, $user_info)

    Сообщить менеджерам клиента о том, что тот создал себе самостоятельную кампанию

    $client_managers = [
        $manager_uid_1,
        $manager_uid_2,
        ...
    ]

    $camp_info = {
        name => ...
        type => ...
    }

    $user_info = {
        ClientID => ...
        email => ...
        phone => ...
        login => ...
        fio => ...
    }

=cut
sub notify_managers_about_new_free_camp {
    my ($rbac, $cid, $client_chief_uid, $client_managers, $camp_info, $user_info) = @_;

    my $all_managers = overshard group => 'email', get_all_sql(PPC(uid => $client_managers), [
        'SELECT uid, email, MAX(FIO) AS fio FROM users',
        where => {uid => SHARD_IDS}
    ]);
    my $manager_campaigns_count = get_hash_sql(PPC(uid => $client_chief_uid),
        ['SELECT ManagerUID, COUNT(*) FROM campaigns', where => {
            uid => $client_chief_uid, ManagerUID => [map { $_->{uid} } @$all_managers], statusEmpty => 'No',
        }, 'GROUP BY ManagerUID']
    );

    my $mailvars = {
        cid           => $cid,
        campaign_id   => $cid,
        camp_name     => $camp_info->{name},
        campaign_name => $camp_info->{name},
        campaign_type => $camp_info->{type},
        client_login  => $user_info->{login},
        client_fio    => $user_info->{fio},
        client_email  => $user_info->{email},
        client_phone  => $user_info->{phone},
        client_id     => $user_info->{ClientID},
        client_uid    => $client_chief_uid,
        is_serviced   => 0
    };

    for my $row (@$all_managers) {
        next unless $manager_campaigns_count->{$row->{uid}};
        next if rbac_who_is($rbac, $row->{uid}) ne 'manager';

        $mailvars->{manager_fio} = $row->{fio};
        $mailvars->{manager_uid} = $row->{uid};

        Notification::add_notification($rbac, 'new_camp_info', $mailvars);
    }
}

=head2 process_FA_request_on_set_servicing

    Переводит заявку на ПП в статус Converted в случае, если кампания стала сервисируемой.
    Применяется при переходе кампании на сервисируемость.
    Params:
      $cid - номер кампании.

=cut

sub process_FA_request_on_set_servicing
{
    my (undef, $cid) = @_;

    if(rbac_is_scampaign(undef, $cid)){
        do_update_table(PPC(cid => $cid), 'optimizing_campaign_requests', {status => 'Converted'}, where =>{cid => $cid, status=>['New', 'InProcess', 'Ready'] });
    }

}

=head2 change_status_moderate_pay($cid)

    Set flag statusPostModerate to state for pay without blocking
        and if it not decline send order to balance
    Moved to CampaignTools;

=cut

sub change_status_moderate_pay($) {
    my $cid = shift;

    return CampaignTools::change_status_moderate_pay($cid)
}


=head2 send_camp_to_bs($cid)

    Переотправка кампании в БК(отправляются только активные группы из кампании)

=cut

sub send_camp_to_bs {

    my $cid = shift;

    my $camp_data = get_one_line_sql(PPC(cid => $cid),
        "SELECT wallet_cid, type FROM campaigns WHERE cid = ?", $cid);

    # если на кампании привязан общий счет то перепосылаем в БК и его тоже
    do_update_table(PPC(cid => $cid), 'campaigns', {
        statusBsSynced => 'No',
        LastChange__dont_quote => 'LastChange'
    }, where => {cid => [$cid, $camp_data->{wallet_cid} ? $camp_data->{wallet_cid} : ()]});

    if (($camp_data->{type} // '') eq 'mcb') {
        do_sql(PPC(cid => $cid),
            q/UPDATE media_groups g
                JOIN media_banners b USING(mgid)
                 SET b.LastChange=b.LastChange
                   , g.statusBsSynced='No'
                   , b.statusBsSynced='No'
               WHERE g.cid = ?/, $cid
        );
    } else {
        my $groups = Models::AdGroup::get_groups({
            cid => $cid,
            adgroup_types => [qw/base dynamic mobile_content performance mcbanner cpm_banner cpm_video cpm_outdoor internal cpm_yndx_frontpage
                content_promotion_video cpm_indoor cpm_audio content_promotion/],
            tab => 'active'
        }, {only_pid => 1, pure_groups => 1});

        if (@$groups) {
            Models::AdGroup::send_groups_to_bs(
                by_pid => [map {$_->{pid}} @$groups]
            )
        }
    }

    if (($camp_data->{type} // '') eq 'mobile_content') {
        my $mobc_ids = get_one_column_sql(PPC(cid => $cid), [
                                            'SELECT DISTINCT amc.mobile_content_id',
                                            'FROM adgroups_mobile_content amc',
                                            'JOIN phrases p ON p.pid = amc.pid',
                                            'JOIN campaigns c ON c.cid = p.cid',
                                            WHERE => {'c.cid' => $cid},
                                          ]);
        if (@$mobc_ids) {
            do_update_table(PPC(cid => $cid), 'mobile_content',
                                {statusBsSynced => 'No'},
                                where => {
                                    mobile_content_id__int => $mobc_ids,
                                    statusBsSynced__ne => 'No',
                                },
                             );
        }
    }

}

=head2 get_max_bid($cid, $currency)

    Максимальные ставки на кампанию
    {
        price =>
        price_context =>
    }

=cut

sub get_max_bid {
    my ($cid, $currency) = @_;

    return mass_get_max_bids([$cid], {$cid => $currency})->{$cid};
}

sub mass_get_max_bids {
    my ($cids, $cid2currency) = @_;

    return {} unless scalar @$cids;

    foreach my $cid (@$cids) {
        die 'no currency given' unless $cid2currency->{$cid};
    }

    my $bids = get_hashes_hash_sql(
        PPC(cid => $cids),
        [
            "SELECT cid, MAX(price) price, MAX(price_context) price_context FROM bids",
            WHERE => {'cid' => SHARD_IDS},
            "GROUP BY cid"
        ]
    );

    my %result;
    foreach my $cid (@$cids) {
        my $bid = $bids->{$cid} || {};
        my $currency = $cid2currency->{$cid};

        $result{$cid} = {
            map {
                ($_ => $bid->{$_} || get_currency_constant($currency, 'MIN_PRICE'))
            } qw/price price_context/
        };
    }

    return \%result;
}

=head2 restore_manual_prices($cid)

    Восстановить цены после окончания работы автобюджета

    Параметры:
        $cid - номер кампании

    Результат:
        {
            restored_bid_ids => [] массив id ключевых фраз, на которых была восстановлена ручная ставка,
            bid_ids_no_manual_prices => [] массив id ключевых фраз из этой кампании, у которых не было ручных ставок
        }

=cut

sub restore_manual_prices {
    my $cid = shift;

    my $camp_info = get_camp_info($cid, undef, short => 1);
    my $currency = $camp_info->{currency};
    my $is_cpm_campaign = is_cpm_campaign($camp_info->{type});
    my $max_price = get_currency_constant($currency, $is_cpm_campaign ? 'MAX_CPM_PRICE' : 'MAX_PRICE');

    my $bids = get_all_sql(PPC(cid => $cid), '
        SELECT m.id AS manual_bid_id, m.price, m.price_context, p.bid, p.pid, bi.id AS bid_id
            FROM bids bi
            JOIN phrases p ON p.pid = bi.pid
            LEFT JOIN bids_manual_prices m ON m.cid = bi.cid AND m.id = bi.id
        WHERE bi.cid = ?', $cid);

    my @bids_to_restore = grep { $_->{manual_bid_id} } @$bids;
    my @bid_ids_no_manual_prices = map { $_->{bid_id} } grep { !$_->{manual_bid_id} } @$bids;
    my $result = {
        restored_bid_ids => [],
        bid_ids_no_manual_prices => \@bid_ids_no_manual_prices,
    };

    unless (@bids_to_restore) {
        return $result;
    }

    my (@data_for_log_price, %price_data, %price_context_data, @ids);
    for my $row (@bids_to_restore) {
        push @ids, $row->{manual_bid_id};
        $price_data{$row->{manual_bid_id}} = $row->{price};
        $price_context_data{$row->{manual_bid_id}} = min $max_price, $row->{price_context};
        push @data_for_log_price, {
            cid => $cid,
            bid => $row->{bid},
            pid => $row->{pid},
            id => $row->{manual_bid_id},
            type => 'restore_manual_prices',
            price => $row->{price},
            price_ctx => $row->{price_context},
            currency    => $currency,
        };
    }

    LogTools::log_price(\@data_for_log_price);
    for my $chunk (chunks([sort {$a <=> $b} @ids], 5_000)) {
        do_update_table(PPC(cid => $cid), 'bids', {
            price__dont_quote => sql_case('id', hash_cut(\%price_data, $chunk)),
            price_context__dont_quote => sql_case('id', hash_cut(\%price_context_data, $chunk)),
            statusBsSynced => 'No',
            }, where => {cid => $cid, id => $chunk}
        );
    }

    # остальные фразы кампании просто переотправляем в БК, чтобы зафиксировать текущую цены
    do_update_table(PPC(cid => $cid), 'bids',
        { statusBsSynced => 'No' },
        where => {cid => $cid, id__not_in => \@ids},
    );

    do_delete_from_table(PPC(cid => $cid), 'bids_manual_prices', where => {cid => $cid});

    $result->{restored_bid_ids} = \@ids;

    return $result;
}


=head3 _get_order_domains($orderids, shard => N)

    Вспомогательная функция для save_metrika_goals.

    Как только начнет использоваться где-то еще
    - нужно будет переделать поддержку шардинга с $O{shard} на что-то другое.

=cut
sub _get_order_domains {
    my $orderids = shift;
    my %O = @_;

    my $chunk_size = 10_000;
    my $orders_info = {};

    for my $chunk (chunks($orderids, $chunk_size)) {
        hash_merge $orders_info, get_hashes_hash_sql(PPC(shard => $O{shard}), ["select OrderID, c.cid, count(distinct reverse_domain) as domains_count
                                      from campaigns c
                                      join phrases p using(cid)
                                      join banners b using(pid)
                                      ", where => {OrderID => $chunk,
                                                   statusEmpty => 'No',
                                                   BannerID__gt => 0,
                                                   reverse_domain__is_not_null => 1,
                                                   statusArch => 'No',
                                                   'c.type__ne' => 'dynamic' }
                                      , "group by OrderID"]);
        # для динамиков домены считаем отдельно
        my $chunk_rest = [grep { !exists $orders_info->{$_} } @$chunk];
        hash_merge $orders_info, get_hashes_hash_sql(PPC(shard => $O{shard}), ["select OrderID, c.cid, count(distinct ad.main_domain_id) as domains_count
                                      from campaigns c
                                      join phrases p using(cid)
                                      join adgroups_dynamic ad using(pid)
                                      join banners b using(pid)
                                      ", where => {OrderID => $chunk_rest,
                                                   statusEmpty => 'No',
                                                   BannerID__gt => 0,
                                                   main_domain_id__ne => 0,
                                                   statusArch => 'No',
                                                   'c.type' => 'dynamic' }
                                      , "group by OrderID"]);
    }
    return $orders_info;
}

=head2 save_metrika_goals($goals, %O)

    Сохранение целей из метрики по кампаниям

    $goals => {
        OrderID => {
            goal_id => {total => context => }
        }
    }

    Параметры именованные:
        skip_exists - пропускать существующие счетчики (не обновлять)
        shard       - номер шарда, в котором нужно сохранить данные (обязательный параметр) (!)
        log         - объект Yandex::Log, для логгирования происходящего

    NOTE:  если функция начнет использоваться где-то кроме скрипта ppcCampGetGoals.pl
           логику про $O{shard} придется переделать

=cut
sub save_metrika_goals {
    my $goals = shift;
    my %O = @_;

    my $orders = _get_order_domains([keys %$goals], shard => $O{shard});
    my @orders_without_domain = grep { !exists $orders->{$_} } keys %$goals;
    if (@orders_without_domain) {
        my $order2cid = get_orderid2cid(OrderID => \@orders_without_domain);
        for my $oid (keys %$order2cid) {
            $orders->{$oid} = {cid => $order2cid->{$oid}};
        }
    }

    my (@new_camp_metrika_goals, @new_camp_domains_count, @orders_without_cid);
    foreach my $OrderID (keys %$goals) {

        my ($cid, $domains_count) = ($orders->{$OrderID}->{cid}, $orders->{$OrderID}->{domains_count});
        if ($cid) {
            push @new_camp_domains_count, [$cid, $domains_count] if $domains_count;
        } else {
            # сохранять данные по целям (и количеству счетчиков) на нулевой cid - бесполезно
            # ими никто не сможет воспользоваться, логгируем по возможности
            push(@orders_without_cid, $OrderID) if $O{log};
            next;
        }

        my %order_goals = %{$goals->{$OrderID}};
        while (my ($goal_id, $quantity) = each %order_goals) {
            push @new_camp_metrika_goals, [$cid, $goal_id, @{$quantity}{qw/total context/}];
        }
    }

    if (@new_camp_metrika_goals) {
        my $res;
        if ($O{skip_exists}) {
            $res = do_mass_insert_sql(PPC(shard => $O{shard}), "insert ignore into camp_metrika_goals (cid, goal_id, goals_count, context_goals_count)
                                     values %s ", \@new_camp_metrika_goals);
        } else {
            $res = do_mass_insert_sql(PPC(shard => $O{shard}), "insert into camp_metrika_goals (cid, goal_id, goals_count, context_goals_count)
                                     values %s
                                     on duplicate key update
                                        goals_count = values(goals_count)
                                        , context_goals_count = values(context_goals_count)
                                        , stat_date = NOW()
                                    ", \@new_camp_metrika_goals);
        }
        $O{log}->out("saved camp_metrika_goals: affected $res rows") if $O{log};
    }

    if (@new_camp_domains_count) {
        my $res = do_mass_insert_sql(PPC(shard => $O{shard}), "insert into camp_domains_count (cid, domains_count)
                                 values %s
                                 on duplicate key update
                                    domains_count = values(domains_count)
                                ", \@new_camp_domains_count);
        $O{log}->out("saved camp_domains_count: affected $res rows") if $O{log};
    }

    if (@orders_without_cid) {
        # Пишем в лог номера заказов, которые невозможно сохранить
        # Возможно что номер кампании не выбрался из-за того, что все баннеры - заархивированы
        $O{log}->out({orders_without_cid => \@orders_without_cid}) if $O{log};
    }
}

=head2 when_money_on_camp_was

    Заполняет таблицу when_money_on_camp_was
      Запись ($cid, $start_time, $end_time) в таблице означает, что на кампании $cid все время между $start_time и $end_time был ненулевой остаток.
      Особый случай:  $end_time == 2030-01-01 (=="открытый интервал") означает, что остаток ненулевой начиная с $start_time и до текущего момента.
      Для кампании общего счета, проставляем дополнительно по всем кампаниям под счетом

    Вызовы:
      Common::when_money_on_camp_was(cid => $cid, event => 'money_out');    # когда обнаружили, что на кампании кончились деньги

    Примечание: В условиях интервал считается открытым, если дата его окончания не меньше, чем
      $Settings::END_OF_TIME минус 2 дня
      Причины исторические — https://st.yandex-team.ru/DIRECT-69540#1503571337000
      event money_in - отсюда выпилен, так как в перловом коде более не используется. есть в java
=cut

sub when_money_on_camp_was {
    my (%O) = @_;

    my $cid = delete $O{cid};
    die "when_money_on_camp_was: cid needed" if !is_valid_id($cid);

    # если деньги поменялись на кампании счете, то считаем что поменялись на всей группе под счетом
    my @cids = ($cid);
    my $campaigns_in_wallet = get_one_column_sql(PPC(cid => $cid), [
        "select c.cid
         from campaigns wc
           join campaigns c on c.uid = wc.uid and wc.cid = c.wallet_cid
        ", where => {
            'wc.cid' => $cid
            , 'wc.type' => 'wallet'
        }
    ]) || [];

    push @cids, @$campaigns_in_wallet if @$campaigns_in_wallet;

    if ($O{event} eq 'money_out') {
        # Деньги закончились -- закрываем все открытый период по кампании, если такой есть
        do_update_table(PPC(cid => $cid), "when_money_on_camp_was",
                        {interval_end__dont_quote => 'now()'},
                        where => {cid => \@cids, interval_end__gt__dont_quote => "DATE_SUB(date('$Settings::END_OF_TIME'), INTERVAL 2 DAY)"}
            );
    } else {
        die "when_money_on_camp_was: incorrect event '$O{event}'";
    }
}

=head2 count_phrases_campaign($cids, %options)

    Подсчёт количество фраз в кампании

    Параметры:
        $cids - номер(а) кампаний
        %options
            skip_arch => 1 - не учитывать архивные группы(полностью состоящие из архивных баннеров)

    Результат:
        Ссылка на хеш {cid => phrases_quantity}

=cut

sub count_phrases_campaign {

    my ($cids, %options) = @_;

    my ($phrases_qty, $additional_table)
        = $options{skip_arch}
            ? ("COUNT(DISTINCT bi.id)", "JOIN banners b USING(pid)")
            : ("COUNT(*)", "");

    return get_hash_sql(PPC(cid => $cids), [
        "SELECT p.cid, $phrases_qty AS qty
        FROM bids bi
            JOIN phrases p USING(pid)
            $additional_table",
        WHERE => {
            'p.cid' => SHARD_IDS,
            $options{skip_arch} ? ('b.statusArch' => 'No') : ()
        },
        "GROUP BY p.cid"
    ]);
}


=head2 reset_statusAutobudgetShow

    сбросить статусы приостановки показов Автобюджетом

=cut
sub reset_statusAutobudgetShow
{
    my ($cid, %O) = @_;

    if ($O{is_wallet}) {
        return do_sql(PPC(cid => $cid), [
                   "UPDATE campaigns wc JOIN campaigns c ON (c.ClientID = wc.ClientID AND c.wallet_cid = wc.cid) JOIN phrases p ON p.cid = c.cid
                    SET p.LastChange=p.LastChange
                         , p.statusAutobudgetShow='Yes'
                    ", WHERE => {'wc.cid' => $cid, 'p.statusAutobudgetShow' => 'No'},
               ]
            );
    } else {
        return do_sql(PPC(cid => $cid), [
                   "UPDATE phrases p
                    SET p.LastChange=p.LastChange
                         , p.statusAutobudgetShow='Yes'
                    ", WHERE => {cid => $cid, 'p.statusAutobudgetShow' => 'No'},
               ]
            );
    }
}

=head2 stop_camp

Помечает кампанию как остановленную и рассылает уведомления.

    my $error_text_or_undef = stop_camp($uid, $cid, %opts);

=cut

sub stop_camp
{
    my ($uid, $cid, %opts) = @_;

    return iget("Неверный номер кампании, повторно залогиньтесь!") if get_owner(cid => $cid) != $uid;

    my ($status_show, $camp_type, $finish_time, $source) =
        get_one_line_array_sql(PPC(cid => $cid), ["select statusShow, type, finish_time, source from campaigns", where => {cid => $cid}]);
    if ((($status_show // '') eq 'No') || ($source eq 'zen')) {
        # не надо трогать остановленные кампании и кампани Дзена
        return undef;
    }

    my $campaigns_to_stop = get_all_sql(PPC(cid => $cid), 'SELECT c.cid, c.type, c.finish_time FROM subcampaigns sc JOIN campaigns c ON sc.cid = c.cid WHERE sc.master_cid = ?', $cid);
    push @$campaigns_to_stop, {
        cid => $cid,
        type => $camp_type,
        finish_time => $finish_time,
    };

    my $cids = [map { $_->{cid} } @$campaigns_to_stop];

    foreach my $campaign (@$campaigns_to_stop) {
        if (($campaign->{type} // '') eq 'cpm_price') {
            if (!(
                    $opts{has_operator_super_control}
                    || $opts{has_operator_manager_control}
                    || $opts{has_operator_support_control}
                    || is_campaign_finished(cid => $campaign->{cid}, finish_time => $campaign->{finish_time})
               )) {
                return iget("Нет прав для остановки кампании с фиксированным CPM");
            }
        }
    }

    update_campaigns_for_stop($cids);

    mail_notification('camp', 'c_status', $cid, 'start', 'stop', $uid);

    return undef;
}


=head2 update_campaigns_for_stop

    Обновить данные кампаний в БД и инвалидировать агрегированные статусы

=cut
sub update_campaigns_for_stop {
    my $cids = shift;
    my $update_statuses_before = Models::Banner::get_update_before();

    do_update_table(PPC(cid => $cids), 'campaigns', {
           statusShow     => 'No',
           statusBsSynced => 'No',
           # TODO - удалить start_time, т.к. это условие уже не актуально
           start_time__dont_quote => 'start_time',
           LastChange__dont_quote => 'now()'
       }, where => { cid => $cids });
    do_update_table(PPC(cid => $cids), 'camp_options', { stopTime => 'now()' }, where => { cid => $cids }, dont_quote => [ 'stopTime' ] );
    update_campaign_statuses_is_obsolete($cids, $update_statuses_before);
}


=head2 resume_camp

Пытается возобновить показы по кампании и рассылает уведомления об этом.

    my $error_text_or_undef = resume_camp($uid, $cid, %opts);
    has_operator_super_control - есть ли у оператора права супера

=cut
sub resume_camp
{
    my ($uid, $cid, %opts) = @_;
    my $client_id = get_clientid(uid => $uid);

    my ($c_uid, $archived, $ab_segment_ret_cond_id, $camp_type, $finish_time) = get_one_line_array_sql(PPC(cid => $cid), "SELECT uid, archived, ab_segment_ret_cond_id, type, finish_time from campaigns where cid = ?", $cid);
    return iget("Неверный номер кампании, повторно залогиньтесь!") if $c_uid != $uid;
    return iget('Необходимо сначала разархивировать кампанию') if $archived eq 'Yes';

    my $campaigns_to_resume = get_all_sql(PPC(cid => $cid), 'SELECT c.cid, c.ab_segment_ret_cond_id, c.type, c.finish_time FROM subcampaigns sc JOIN campaigns c ON sc.cid = c.cid WHERE sc.master_cid = ?', $cid);
    push @$campaigns_to_resume, {
        cid => $cid,
        ab_segment_ret_cond_id => $ab_segment_ret_cond_id,
        type => $camp_type,
        finish_time => $finish_time,
    };

    my $cids = [map { $_->{cid} } @$campaigns_to_resume];
    my $is_cpm_banner_campaign_disabled = Client::ClientFeatures::is_feature_cpm_banner_campaign_disabled_enabled($client_id);

    foreach my $campaign (@$campaigns_to_resume) {
        if ($campaign->{type} eq 'cpm_price') {
            my $package_id = get_one_field_sql(PPC(cid => $campaign->{cid}), ["SELECT package_id FROM campaigns_cpm_price", where => {cid => $campaign->{cid}}]);
            my $available_ad_group_types = get_one_field_sql(PPCDICT, ["SELECT available_ad_group_types FROM cpm_price_packages",
                where => {package_id => $package_id}]);
            my $is_cpm_yndx_frontpage = any { $_ eq 'cpm_yndx_frontpage' } split /\s*,\s*/, $available_ad_group_types;

            if ($is_cpm_yndx_frontpage &&
                    !(
                    $opts{has_operator_super_control}
                    || ($opts{has_operator_manager_control} && !is_campaign_finished(cid => $campaign->{cid}, finish_time => $campaign->{finish_time}))
               )) {
                return iget("Нет прав для возобновления кампании с фиксированным CPM");
            }
        }

        if ($campaign->{ab_segment_ret_cond_id}) {
            my $has_archived_segments = get_one_field_sql(PPC(cid => $campaign->{cid}), [
                    'SELECT 1',
                    'FROM retargeting_goals rg',
                    WHERE => {
                        'rg.ret_cond_id__int' => $campaign->{ab_segment_ret_cond_id},
                        'rg.is_accessible' => 0,
                    },
                    'LIMIT 1',
                ]);
            return iget('Чтобы возобновить показы в кампании %d измените условие таргетинга на экспериментальные сегменты, убрав архивные', $cid) if $has_archived_segments;
        }
        if ($is_cpm_banner_campaign_disabled && is_cpm_campaign{$campaign->{type}}) {
            return iget('Медийная кампания %d не может быть запущена.', $campaign->{cid});
        }
    }

    my $update_statuses_before = Models::Banner::get_update_before();

    do_update_table(PPC(cid => $cids), 'campaigns', {
        statusShow => 'Yes',
        statusBsSynced => 'No',
        LastChange__dont_quote => 'now()'
    }, where => { cid => $cids });

    update_campaign_statuses_is_obsolete($cids, $update_statuses_before);

    mail_notification('camp', 'c_status', $cid, 'stop', 'start', $uid);

    return undef;
}

=head2 get_total_banners_count

    Количество всего баннеров в кампании. Используется для определения надо ли показывать предупреждение о разделении ЕКИ.

=cut
sub get_total_banners_count {
    my $cid = shift;
    return get_one_field_sql(PPC(cid => $cid), "SELECT COUNT(*) FROM banners WHERE cid=?", $cid);
}

# --------------------------------------------------------------------

=head2 validate_camp_mobile_content

Проверка настроек на кампаний с типом мобильный контент (mobile_content)
    device_type_targeting: set('phone','tablet')
    network_targeting: set('wifi','cell')

    push @errors, validate_camp_mobile_content({device_type_targeting => $FORM{device_type_targeting}, network_targeting => $FORM{network_targeting}});

=cut

{
    my %valid_device_types = ('phone' => 1, 'tablet' => 1);
    my %valid_network_targetings = ('wifi' => 1, 'cell' => 1);

sub validate_camp_mobile_content($) {
    my $mobile_content_settings = shift;

    my @errors;

    if (defined $mobile_content_settings->{device_type_targeting}) {
        push @errors, iget("Ошибка в настройке: тип устройства")
            if $mobile_content_settings->{device_type_targeting} eq ""
               || any {! $valid_device_types{$_}} split(/,/, $mobile_content_settings->{device_type_targeting});
    }

    if (defined $mobile_content_settings->{network_targeting}) {
        push @errors, iget("Ошибка в настройке: тип связи")
            if $mobile_content_settings->{network_targeting} eq ""
               || any {! $valid_network_targetings{$_}} split(/,/, $mobile_content_settings->{network_targeting});
    }

    return @errors;
}}

=head2 mass_get_servicing

    Проверяет находится ли кампания на сервисировании или отправлена на сервисирование
    Возвращает хешь вида { cid => 1|0 }

=cut

sub mass_get_servicing($) {
    my ($cids) = @_;

    return get_hash_sql(PPC(cid => $cids), [
                "SELECT c.cid, 1
                   FROM campaigns c
                        LEFT JOIN camps_for_servicing cs on cs.cid = c.cid
                  WHERE (c.ManagerUID > 0 or cs.cid is not null)
                    and ", {'c.cid' => SHARD_IDS}
            ]);
}

=head2 mass_get_source_ids_by_cid
    После конвертации у кампании меняется cid
    Возвращает старый cid по cid'у который получился после конвертации

=cut

sub mass_get_source_ids_by_cid {
    my $client_id = shift;
    my $old_cid_before_currency_converted = get_hash_sql(PPC(ClientID => $client_id),
        ["SELECT new_cid, old_cid FROM currency_convert_money_correspondence",
         WHERE => { ClientID => $client_id } ]
    );
    return $old_cid_before_currency_converted;
}


=head2 my $first_aid_cids = filter_campaigns_for_first_aid($cids)

    Из списка номеров кампаний отобрать те, для которых имеет смысл оказывать "Первую Помощь":
    - ровно один платёж
    - платёж больше лимита

=cut
sub filter_campaigns_for_first_aid {
    my ($cids) = @_;

    my $paid_sum = (new Property($Settings::FIRST_AID_PAID_SUM_LIMIT_PROP))->get();
    unless (defined($paid_sum) && $paid_sum =~ /^\d+$/) {
        $paid_sum = $Settings::FIRST_AID_PAID_SUM_LIMIT_DEFAULT;
    }

    my $currencies_case_sql = Currency::Rate::get_sql_currencies_rates_to_ynd_fixed("c.currency");
    return get_one_column_sql(PPC(cid => $cids), [
                   "SELECT c.cid
                      FROM campaigns c
                           JOIN camp_payments_info cpi on cpi.cid = c.cid
                           LEFT JOIN campaigns cu on (c.uid = cu.uid and c.cid != cu.cid)
                           LEFT JOIN camp_payments_info cpu on (cu.cid = cpu.cid and (
                                   (cpu.last_payment_time < cpi.last_payment_time) or
                                   (cpu.last_payment_time = cpi.last_payment_time and cpu.cid < cpi.cid) or
                                   (cpu.last_payment_time > cpi.last_payment_time and cpu.payments_num > 1)
                           ))",
                     where => {
                         'c.cid' => SHARD_IDS,
                         'cpi.payments_num' => 1,
                         _TEXT => "cpi.last_payment_sum / $currencies_case_sql >= ?"
                     },
                    'GROUP BY c.cid',
                    'HAVING count(cpu.cid) = 0'
                  ], $paid_sum);
}

=head2 campaign_sms_flags

    Из списка смс-флагов кампании (строка, где флаги разделены запятыми)
    получить хеш соответствия { смс_флаг => 1 }

=cut

sub campaign_sms_flags {
    return {map {$_ => 1} split(',', $_[0])};
}

=head2 get_day_budget_stop_history

    Получить статистику остановок кампании/общего счета за последние DAILY_BUDGET_STOP_STATS_DAYS
    Если в какой-то день не было остановок, записи за этот день не будет
    Если в какой-то день было несколько остановок, выводится самая поздняя из них.

    Именованные параметры
        fake_current_date => 'YYYY-MM-DD' - фейковый "текущий день" для использования в юнит тестах, который будет использоваться вместо
                                            mysql функции CURRENT_DATE(). Иначе тест упадет если его вдруг запустят в 23:59:59.999

    Возращает массив строк с датами и временем в mysql формате, отсортированный по убыванию

    my $stop_stats = get_day_budget_stop_history($cid);
    $stop_stats[0] eq '2017-04-21 12:34:56';

=cut

sub get_day_budget_stop_history {
    my ($cid, %O) = @_;

    my $current_date_sql = ($O{fake_current_date} ? sql_quote($O{fake_current_date}) : 'CURRENT_DATE()');
    # константа включает в себя текущий день, поэтому отнимаем от нее единицу
    my $interval_days = $DAILY_BUDGET_STOP_STATS_DAYS - 1;

    return get_one_column_sql(PPC(cid => $cid), ["
            SELECT MAX(stop_time)
            FROM camp_day_budget_stop_history
            ", WHERE => {cid__int => $cid, stop_time__ge__dont_quote => "$current_date_sql - INTERVAL $interval_days DAY"}, "
            GROUP BY DATE(stop_time)
            ORDER BY DATE(stop_time) DESC
        "]);
}

=head2 get_day_budget_notification

    https://wiki.yandex-team.ru/users/aliho/projects/direct/bellrecommendation/#docmd.pm
    Добавить для контроллеров showCamps (список кампаний) + showCamp (страница кампании) новый параметр:
        VARS.daily_budget_notification: {
            period : 7 // кол-во дней, за которые мы смотрим нотификацию
            cids : [<cid>] // массив проблемных кампаний, у которых были остановки по своему дневному бюджету или дневному бюджету общего счета. Максимальное кол-во кампаний у клиента 150 шт ((https://st.yandex-team.ru/DIRECT-76041#1522752016000 анализировали тут))
            main_invoice : true/false // остановка кампаний была по причине ограничений по дневному бюджету общего счета
        }

    Список кампаний cids
        select c.cid cid, c.name, count(*) stop_cnt
        from campaigns c
        join camp_day_budget_stop_history ch on ch.cid = c.cid and ch.stop_time > date_add(now(), interval -DAILY_BUDGET_NOTIFICATION_PERIOD_DAYS day)
        where c.ClientID = 31896137
        group by c.cid, c.name
        having count(*) > DAILY_BUDGET_NOTIFICATION_MIN_STOPPAGES_NUMBER
        order by stop_cnt desc
    , где
        DAILY_BUDGET_NOTIFICATION_PERIOD_DAYS - кол-во дней за которые мы смотрим историю
        DAILY_BUDGET_NOTIFICATION_MIN_STOPPAGES_NUMBER - кол-во остановок одной кампании за период  DAILY_BUDGET_NOTIFICATION_PERIOD_DAYS
    Параметры  DAILY_BUDGET_NOTIFICATION_MIN_STOPPAGES_NUMBER ,  DAILY_BUDGET_NOTIFICATION_PERIOD_DAYS должны храниться в ppc.ppcdict.ppc_properties,
    для этой таблицы есть веб интерфейс для редактирования настроек без релиза

    Значения по умолчанию:
        DAILY_BUDGET_NOTIFICATION_PERIOD_DAYS = 7 (дней)
        DAILY_BUDGET_NOTIFICATION_MIN_STOPPAGES_NUMBER = 7 (кол-во остановок кампании)
=cut

sub _get_day_budget_notification {
    my ($ClientID) = @_;

    my $period = 7;
    my $cid2troubled = _get_day_budget_stop_history_for_notification($ClientID);
    if (%$cid2troubled) {
        return {
            period => $period,
            cids => [grep {$$cid2troubled{$_} ne 'wallet'} keys %$cid2troubled],
            main_invoice => (any {$_ eq 'wallet'} values %$cid2troubled) ? JSON::true : JSON::false,
        }
    } else {
        return undef;
    }

}

sub _get_day_budget_stop_history_for_notification {
    my ($ClientID) = @_;

    my $period = 7;
    return get_hash_sql(PPC(ClientID => $ClientID), ['
            SELECT DISTINCT c.cid, c.type
            FROM camp_day_budget_stop_history cdbsh
            JOIN campaigns c ON c.cid = cdbsh.cid
            JOIN camp_options co ON co.cid = cdbsh.cid
         ', WHERE => {
                ClientID => $ClientID,
                archived => 'No',
                'c.statusShow__ne' => 'No',
                'c.day_budget__gt' => 0,
                'cdbsh.stop_time__gt__dont_quote' => "date_add(now(), interval -$period day)",
                _OR => {
                    'co.day_budget_last_change__is_null' => 1,
                    'cdbsh.stop_time__gt__dont_quote' => 'co.day_budget_last_change',
                },
            }
        ]);
}

=head2 is_cpm_campaign($type)

    По типу кампании определяет, является ли она CPM

=cut

sub is_cpm_campaign($) {
    my $type = shift;
    return (any {$type eq $_} ('cpm_banner', 'cpm_deals', 'cpm_yndx_frontpage', 'cpm_price')) ? 1 : 0;
}

=head2 get_master_cid($cid)

    По cid получить cid мастер-кампании

=cut

sub get_master_cid($) {
    my $cid = shift;

    if (!is_valid_id($cid)) {
        return undef;
    }

    return get_one_field_sql(PPC(cid => $cid), [
        'SELECT master_cid FROM subcampaigns',
        WHERE => {cid => $cid},
    ]);
}

=head2 get_campaign_source($cid)

    По cid вернуть source кампании

=cut

sub get_campaign_source {
    my $cid = shift;

    if (!is_valid_id($cid)) {
        return '';
    }

    return get_one_field_sql(PPC(cid => $cid), [
        'SELECT source FROM campaigns',
        WHERE => {cid => $cid},
    ]) // '';
}

=head2 is_uac_campaign($cid)

    По cid определить, является ли кампания универсальной

=cut

sub is_uac_campaign($) {
    my $cid = shift;

    my $source = get_campaign_source($cid);

    return $source eq 'uac' || $source eq 'widget';
}

=head2 is_internal_autobudget_campaign

    Возвращает является ли кампания автобюджетной кампанией внутренней рекламы

=cut

sub is_internal_autobudget_campaign {
    my $type = shift;
    return $type eq 'internal_autobudget';
}

=head2 is_internal_distrib_camp

    Возвращает является ли кампания дистрибуционной кампанией внутренней рекламы

=cut

sub is_internal_distrib_camp {
    my $type = shift;
    return $type eq 'internal_distrib';
}


=head2 is_internal_free_camp

    Возвращает является ли кампания бесплатной кампанией внутренней рекламы

=cut

sub is_internal_free_camp {
    my $type = shift;
    return $type eq 'internal_free';
}


=head2 is_internal_campaign

Возвращает является ли кампания кампанией внутренней рекламы

=cut

sub is_internal_campaign {
    my $type = shift;
    return is_internal_autobudget_campaign($type) ||
        is_internal_distrib_camp($type) ||
        is_internal_free_camp($type);
}

=head2 has_context_relevance_match_feature

    С учетом типа кампании и настроек клиента проверяет,
    доступен ли расширенный автотаргетинг для данной кампании

=cut

sub has_context_relevance_match_feature($$) {
    my ($campaign_type, $client_id) = @_;

    return 0 if $campaign_type eq 'performance';

    if ($campaign_type eq 'mobile_content') {
        return 1;
    }

    return Client::ClientFeatures::has_context_relevance_match_feature($client_id);
}

=head2 preprocess_meaningful_goals

Подготавливаем список целей для сохранения:
* если нет ничего, кроме вовлечённых сессий, сохраняем пусто

=cut

sub preprocess_meaningful_goals {
    my ($meaningful_goals) = @_;

    if (
        @$meaningful_goals == 1
        && $meaningful_goals->[0]->{goal_id} == $Settings::ENGAGED_SESSION_GOAL_ID
        && !$meaningful_goals->[0]->{value}
    ) {
        return [];
    }

    return $meaningful_goals;
}


=head2 get_default_meaningful_goal

Получить умолчальную ключевую цель для кампании.

Опции:
    cid
    camp_type

=cut

sub get_default_meaningful_goal {
    my (%opt) = @_;

    my $type = $opt{camp_type} || get_camp_type(cid => $opt{cid});
    croak 'Campaign type not defined'  if !$type;

    my $default_goals = {
        text => [ $Settings::ENGAGED_SESSION_GOAL_ID => iget('Вовлеченные сессии') ],
        mobile_content => [ $Settings::DEFAULT_CPI_GOAL_ID => iget('Ассоциированные установки') ],
    };

    my ($goal_id, $goal_name) = @{$default_goals->{$type} || $default_goals->{text}};
    return {
        goal_id => $goal_id,
        name => $goal_name,
        status => 'Active',
        type => 'default',
    };
}


=head2 prefetch_goals
Предзагрузить цели для указанных счетчиков.
Используется для уменьшения запросов в Метрику при добавлении/обновлении кампаний через API

Параметры:
    counters - список счетчиков, для которых надо предзагрузить цели
    uid - uid владельца счетчиков

Результат:
    {
        counter1 => [Direct::Model::MetrikaGoal, ...],
        ...
    }

=cut

sub prefetch_goals {
    my ($counters, $uid) = @_;

    my $user_counters = MetrikaCounters::get_all_uid_reps_counters($uid) // [];
    return  _get_goals_by_counter( [ uniq @$counters, @$user_counters],
        no_cache => 0,
        skip_errors => 1,
    );
}

=head2 prefetch_meaningful_goals_data

Предзагрузить данные для валидации ключевых целей.
Результат можно передать в get_available_meaningful_goals.

Параметры:
    counters
    cids

Результат - хеш с ключами
    goals_by_counter
    counters_by_cid
    turbolanding_counters_by_cid

=cut

sub prefetch_meaningful_goals_data {
    my (%opt) = @_;

    my %result;
    my @all_counters = @{$opt{counters} || []};

    if (my $cids = $opt{cids}) {
        $result{counters_by_cid} = _get_counters_by_cid($cids);
        push @all_counters, map {@$_} values %{$result{counters_by_cid}};

        $result{turbolanding_counters_by_cid} = _get_turbolanding_counters_by_cid($cids);
        push @all_counters, map {keys %$_} values %{$result{turbolanding_counters_by_cid}};
    }

    @all_counters = uniq @all_counters;
    $result{goals_by_counter} = _get_goals_by_counter(\@all_counters);

    return \%result;
}


sub _get_counters_by_cid {
    my ($cids) = @_;

    my $items = get_all_sql(PPC(cid => $cids), [
            'SELECT cid, metrika_counter
            FROM metrika_counters',
            WHERE => { cid => $cids },
        ]);

    my %result;
    for my $item (@$items) {
        push @{$result{$item->{cid}}}, $item->{metrika_counter};
    }
    return \%result;
}


sub _get_turbolanding_counters_by_cid {
    my ($cids) = @_;
    my $items = get_all_sql(PPC(cid => $cids), [
            'SELECT cid, metrika_counter, metrika_counters_json
            FROM camp_turbolanding_metrika_counters
            JOIN banner_turbolandings USING(cid, bid)
            JOIN turbolandings USING(tl_id)',
            WHERE => { cid => $cids },
        ]);

    my %result;
    for my $item (@$items) {
        $result{$item->{cid}}->{$item->{metrika_counter}} = $item->{metrika_counters_json};
    }
    return \%result;
}


sub _get_goals_by_counter {
    my ($counters, %opt) = @_;

    my $goals = MetrikaCounters::get_counters_goals($counters,
        no_cache            => $opt{no_cache} // 1,
        skip_errors         => $opt{skip_metrika_errors},
        get_steps           => 1,
    );

    return $goals;
}


=head2 get_available_meaningful_goals

Получить список ключевых целей, доступных для выбора в кампании.

Отдаём цели,
 + привязанные к доступным счётчикам кампании
 + автоцели, привязанные к недоступным счётчикам кампании, если указана опция unavailable_auto_goals_allowed
 + привязанные к счётчикам турболендингов кампании
 + по которым есть статистика кампании

Опции:
    camp_type
    camp_counters - новый список счётчиков кампании - если собираемся его менять
                    (принадлежность счётчиков тут не проверяем!)
    skip_metrika_errors - не падать на ошибках из Метрики
    prefetched_data - предварительно загруженные данные в формате prefetch_meaningful_goals_data
    uid
    unavailable_auto_goals_allowed - разрешено ли использовать недоступные автоцели

=cut

sub get_available_meaningful_goals {
    my ($cid, %opt) = @_;

    my $camp_counters = $opt{camp_counters};
    if (!$camp_counters && $cid) {
        my $counters_data = $opt{prefetched_data}
            ? $opt{prefetched_data}->{counters_by_cid}
            : _get_counters_by_cid([$cid]);
        $camp_counters = $counters_data->{$cid};
    }

    my @tl_counters;
    my $selected_goal;
    my $type = $opt{camp_type} || '';
    if ($cid) {
        my $tl_counters_data = $opt{prefetched_data}
            ? $opt{prefetched_data}->{turbolanding_counters_by_cid}
            : _get_turbolanding_counters_by_cid([$cid]);
        my $tl_info = $tl_counters_data->{$cid};
        @tl_counters = keys %$tl_info;

        $type ||= get_camp_type(cid => $cid);
        if ($type eq 'mobile_content') {
            for my $counter_id (@tl_counters) {
                my $counter = first {$_->{id} == $counter_id} @{from_json($tl_info->{$counter_id})};
                next if !$counter;
                # FIXME: temporary heuristic: use 3rd goal - Form page - Send data button click
                $selected_goal = $counter->{selected_goal} || $counter->{goals}->[3];
            }
        }
    }

    my %counter_type = (
        (map {$_ => 'turbolanding'} @tl_counters),
        (map {$_ => 'campaign'} @{$camp_counters || []}),
    );

    my %result;
    my $has_default_goal;
    if (%counter_type) {
        my $goals_by_counter = $opt{prefetched_data}
            ? $opt{prefetched_data}->{goals_by_counter}
            : _get_goals_by_counter([keys %counter_type],
                skip_metrika_errors => $opt{skip_metrika_errors},
            );

        my $counter_source_by_id;
        my $allow_use_counter_without_access_by_id;
        my %available_counters_hash;
        if ($opt{uid}) {
            my $available_counters = MetrikaCounters::get_all_uid_reps_counters($opt{uid},
                skip_errors => $opt{skip_metrika_errors});
            %available_counters_hash = map {$_ => 1} @{$available_counters};
        }
        my $unavailable_goals_allowed = $opt{clientId}
            && Client::ClientFeatures::has_direct_unavailable_goals_allowed($opt{clientId});
        for my $counter (keys %counter_type) {
            my $is_counter_available = !$opt{uid} || exists $available_counters_hash{$counter};
            for my $goal (@{$goals_by_counter->{$counter} || []}) {
                my $is_goal_available = $is_counter_available;
                if (!$is_goal_available && $unavailable_goals_allowed) {
                    $allow_use_counter_without_access_by_id //=
                        Stat::Tools::get_allow_use_counter_without_access_by_id([keys %counter_type]);
                    $is_goal_available = $allow_use_counter_without_access_by_id->{$counter};
                }
                # todo выпилить в https://st.yandex-team.ru/DIRECT-164684
                if (!$is_goal_available && $opt{unavailable_auto_goals_allowed}) {
                    if ($goal->{goal_source} eq 'auto' || $goal->{goal_type} eq 'ecommerce') {
                        $is_goal_available = 1;
                    } else {
                        if (!$counter_source_by_id) {
                            $counter_source_by_id = Stat::Tools::get_all_counter_source_by_id([keys %counter_type]);
                        }
                        $is_goal_available = any { $counter_source_by_id->{$counter} eq $_ } @Stat::Tools::TECHNICAL_COUNTERS_SOURCE;
                    }
                }
                if ($is_goal_available) {
                    $result{$goal->goal_id} = {
                        goal_id => $goal->goal_id,
                        name => $goal->goal_name,
                        status => $goal->goal_status,
                        type => $counter_type{$counter},
                    };
                    if ($selected_goal && $selected_goal == $goal->goal_id) {
                        $result{$goal->goal_id}->{is_default_goal} = 1;
                        $has_default_goal = 1;
                    };
                }
            }
        }
    }

    my $default_goal = get_default_meaningful_goal(camp_type => $type);
    $default_goal->{is_default_goal} = 1  if !$has_default_goal;
    $result{$default_goal->{goal_id}} = $default_goal;

    if ($cid) {
        my $stat_goals = Stat::Tools::orders_goals(cid => $cid);
        for my $goal (@$stat_goals) {
            next if $goal->{status} ne 'Active';
            $result{$goal->{goal_id}} //= hash_merge {type => 'statistics'}, hash_cut $goal, qw/goal_id name status/;
        }

    }

    return \%result;
}


=head2 prepare_brand_lift_experiment

Подготовка Brand-lift эксперимента.

Возвращает пару: id эксперимента и id цели главного сегмента.

=cut

sub prepare_brand_lift_experiment {
    my ($ulogin, $cid, $counters) = @_;
    croak 'Invalid params' if !$ulogin || !$cid || !$counters;

    my $profile = Yandex::Trace::new_profile('audience:brand_lift_experiment');

    my $experiment_params = {
        name => "Brand-lift $cid",
        counter_ids => $counters,
        segments => [
            {name => "A", start => 0, end => $BRAND_LIFT_EXPERIMENT_THRESHOLD},
            {name => "B", start => $BRAND_LIFT_EXPERIMENT_THRESHOLD, end => 100},
        ],
    };

    my $aud_api = Yandex::Audience->new();
    my $experiment = $aud_api->create_experiment($experiment_params, $ulogin);
    my $experiment_id = $experiment->{experiment_id};
    my $segment_goal_id = $Yandex::Audience::SEGMENT_GOAL_ID_SHIFT + $experiment->{segments}->[0]->{segment_id};
    $aud_api->set_experiment_grant($experiment_id, $BRAND_LIFT_SURVEYS_LOGIN, "view");

    return ($experiment_id, $segment_goal_id);
}

=head2 prevalidate_cpm_strategy

  Предварительная проверка CPM стратегий при создании кампании
  Проверяет значения в полях от которых зависят настройки стратегии
  В отличие от основной валидации, обязательно должна пройти до создания кампании в БД
  Иначе в случае ошибки в этом месте, кампания создастся со statusEmpty: Yes
  И при попытке обновить ее с правильными значениями получим ошибку "Нет прав" от RBAC

  Возвращает список ошибок

=cut

sub prevalidate_cpm_strategy {
    my ($form, $strategy, $client_id) = @_;

    my $strategy_obj = strategy_from_strategy_app_hash($strategy);
    my @errors;

    my $camp_obj = _get_quasi_campaign($form);
    my %opt = (
        has_edit_avg_cpm_without_restart_enabled => Client::ClientFeatures::has_edit_avg_cpm_without_restart_feature($client_id)
    );

    if ($strategy->{net} && $strategy->{net}{finish}) {
        $camp_obj->start_date($form->{start_time});
        $camp_obj->finish_date($form->{finish_time});
        my $error_finish = Direct::Validation::Strategy::validate_finish($strategy->{net}{finish}, $camp_obj, $strategy_obj);
        my $error_start = Direct::Validation::Strategy::validate_start($strategy->{net}{start}, $camp_obj, $strategy_obj, %opt);
        push @errors, $error_finish->description if $error_finish;
        push @errors, $error_start->description if $error_start;
    }
    if ($camp_obj->campaign_type eq 'cpm_yndx_frontpage' && $strategy->{net} && $strategy->{net}{avg_cpm}) {
        $camp_obj->allowed_frontpage_types($form->{allowed_frontpage_types});
        $camp_obj->geo(geo_changes_to_string($form->{json_geo_changes}, undef, $client_id));
        $camp_obj->client_id($client_id);
        my $error = Direct::Validation::Strategy::validate_frontpage_avg_cpm($strategy->{net}{avg_cpm}, $camp_obj, $strategy_obj);
        push @errors, $error->description if $error;
    }

    return @errors;
}

=head2 is_strategy_use_meaningful_goals_optimization($strategy)

    Использует ли стратегия оптимизацию по ключевым целям

=cut

sub is_campaign_strategy_use_meaningful_goals_optimization {
    my ($strategy) = @_;

    foreach (qw/search net/) {
            if (defined $strategy->{$_}{goal_id} &&
                $strategy->{$_}{goal_id} == $Settings::MEANINGFUL_GOALS_OPTIMIZATION_GOAL_ID) {
                return 1;
            }
        }
    return 0;
}

=head2 is_allowed_to_use_value_from_metrika($strategy)

    Доступно ли в стратегии использовать метрику как источник для дохода

=cut

sub is_allowed_to_use_value_from_metrika {
    my ($strategy) = @_;

    if (!defined $strategy) {
        return 0;
    }

    foreach (qw/search net/) {
        if (defined $strategy->{$_}{name} &&
            $strategy->{$_}{name} eq "autobudget_crr") {
            return 1;
        }
    }
    return 0;
}

=head2 get_internal_campaign_place_id

    Получить по cid place_id кампании внутренней рекламы из campaigns_internal
    Действительно ли кампания существует и является кампанией внутренней рекламы, не проверяет,
    поведение, если не является, не гарантируется. Текущая реализация возвращает undef.

=cut

sub get_internal_campaign_place_id {
    my ($cid) = @_;

    return get_one_field_sql( PPC( cid => $cid ), [
        'SELECT place_id FROM campaigns_internal',
        WHERE => { cid => $cid },
    ] );
}

=head2 prepare_for_show_camp_options_params (vars)

    Преобразовать данные по некоторым параметрам из формата БД в формат фронта.
    Изменяет входные данные.

=cut
sub prepare_for_show_camp_options_params {
    my $vars = shift;

    my $camp_type = $vars->{mediaType} || '';
    if (any {$camp_type eq $_ } qw/cpm_deals cpm_banner/) {
        $vars->{impression_standard_time} = (defined $vars->{impression_standard_time} &&
                                             $vars->{impression_standard_time} eq $IMPRESSION_STANDARD_TIME_YANDEX) ? 'yandex' : 'mrc';
    }

    if ($camp_type eq 'cpm_banner') {
        $vars->{eshows_banner_rate} = (defined $vars->{eshows_banner_rate} && $vars->{eshows_banner_rate} == $ESHOWS_BANNER_RATE_OFF) ? 0 : 1;
        $vars->{eshows_video_rate} = (defined $vars->{eshows_video_rate} && $vars->{eshows_video_rate} == $ESHOWS_VIDEO_RATE_OFF) ? 0 : 1;
        $vars->{eshows_video_type} = (defined $vars->{eshows_video_type} &&
                                      $vars->{eshows_video_type} eq $ESHOWS_VIDEO_TYPE_COMPLETES) ? $ESHOWS_VIDEO_TYPE_COMPLETES : $ESHOWS_VIDEO_TYPE_LONG_CLICKS;
    }

}

=head2 update_campaign_statuses_is_obsolete

    инвалидировать агрегированные статусы для кампаний (будет отображаеться статус "Обрабатывается"

    update_before время раньше которого обновленные записи мы сбрасываем, т.е. если какой-то
    процесс успел обновить статус у объекта параллельно нашему, то его изменения мы уже не станем помечать
    is_obsolete = 1. Для этого в нашем процессе, перед операциями над объектом надо заметить время

=cut

sub update_campaign_statuses_is_obsolete {
    my ($cids, $update_before) = @_;
    die 'Missing required parameter: update_before' unless $update_before;

    do_update_table(PPC(cid => $cids), 'aggr_statuses_campaigns',
        { is_obsolete => '1', updated__dont_quote => 'NOW()' },
        where => {'cid' => SHARD_IDS, 'updated__lt' => $update_before}
    );
}

=head2 get_geoproduct_campaigns

    возращает кампании, у которых есть группы cpm_geoproduct или cpm_geo_pin

=cut

sub get_geoproduct_campaigns {
    my ($cids) = @_;

    return get_one_column_sql(PPC(cid => $cids), [
            "SELECT cid FROM phrases p",
            WHERE => { cid => SHARD_IDS, adgroup_type => [ qw/cpm_geoproduct cpm_geo_pin/ ] },
            "GROUP BY cid"
    ]);
}

=head2 get_campaign_ids_with_only_one_group_type($group_type, $cids)

    Получить  кампании, у которых есть только группы cpm_audio/cpm_indoor/cpm_outdoor
    Параметры:
        $group_type -- тип группы
        $cids -- список id кампаний
    Результат:
        массив id-ников кампаний

=cut

sub get_campaign_ids_with_only_one_group_type {
    my ($group_type, $cids) = @_;

    return get_one_column_sql(PPC(cid => $cids), [
            "SELECT cid FROM phrases p",
            WHERE => { 'p.cid' => SHARD_IDS, 'p.adgroup_type' => $group_type },
            "AND NOT EXISTS (SELECT 1 FROM phrases p2
                WHERE => { 'p2.adgroup_type' <> ${group_type} }
                AND p.cid = p2.cid)
            GROUP BY cid"
    ]);
}


=head2 mass_is_universal_campaign

    Принимает на вход список cid. Возвращает хеш вида:
      {
        <cid1> => 0,
        <cid2> => 1,
        ...
      }
    Значения:
        1 - универсальная кампания
        0 - не UC

=cut

sub mass_is_universal_campaign {
    my ($cids) = @_;

    return {} unless @$cids;

    my $universal_cids = get_one_column_sql(PPC(cid => $cids), ['SELECT cid FROM campaigns',
        where => {cid => SHARD_IDS, source => ['uac', 'widget']}]);
    my $result = { map { $_ => 1 } @$universal_cids };
    for my $cid (@$cids) {
        $result->{$cid} = 0 unless exists $result->{$cid};
    }

    return $result;
}

=head2 update_and_get_total_camp_copy_ela

    Принимает на вход uid оператора и время, потраченное на копирование кампании
    Обновляет суммарное время копирования за период на клиенте и возвращает сохраненное значение

=cut

sub update_and_get_total_camp_copy_ela {
    my ($operator_uid, $ela) = @_;

    my $period = 7 * 86400; #можно вынести в ppcproperty

    return 0 unless $operator_uid;

    my $perminfo = Rbac::get_perminfo( uid => $operator_uid );
    # Обработку кампаний поставленных на копирование менеджерами не пессимизируем
    return 0 unless $perminfo->{role} eq 'client';

    my $current_time = time;
    my $total_ela_info = _get_total_camp_copy_ela($perminfo->{ClientID}, for_update => $ela > 0 ? 1 :0);

    my $saved_total_ela = $total_ela_info->{'value'};
    my $saved_time = $total_ela_info->{'time'} // $current_time;

    my $time_after_previos_saving = $current_time - $saved_time;

    my $actual_ela = $ela + $saved_total_ela * ($time_after_previos_saving < $period ? (1 - $time_after_previos_saving/$period) : 0);
    if ($ela > 0){
        _update_total_camp_copy_ela($perminfo->{ClientID}, $actual_ela, $current_time);
    }

    return $actual_ela;
}

sub _get_total_camp_copy_ela {
    my ($client_id, %opt) = @_;
    my $for_update = ($opt{for_update} // 0) ? 'FOR UPDATE' : '';

    my $stored = get_one_field_sql(PPC(ClientID => $client_id),
            ['SELECT camp_copy_ela FROM clients_options', WHERE => {ClientID => $client_id}, $for_update]
    ) // '';

    my ($ela, $stored_time) = split /:/, $stored;

    return {
        'value' => $ela // 0,
        'time' => $stored_time,
    }
}

sub _update_total_camp_copy_ela {
    my ($client_id, $actual_ela, $current_time) = @_;

    my $joined_value = sprintf '%.02f:%s', $actual_ela // 0, $current_time // 0;

    do_update_table(PPC(ClientID => $client_id), 'clients_options', {camp_copy_ela => $joined_value},
            where => {ClientID => $client_id});
}

sub get_strategies {
    my ($client_id, $where) = @_;

    return get_hashes_hash_sql(PPC(ClientID => $client_id),
        ["SELECT strategy_id,
                 type,
                 strategy_data,
                 ContextLimit,
                 attribution_model,
                 day_budget,
                 day_budget_show_mode,
                 day_budget_daily_change_count,
                 day_budget_last_change,
                 enable_cpc_hold,
                 meaningful_goals,
                 is_public,
                 archived FROM strategies", where => $where]);
}

=head2 get_campaigns_type_by_strategy_id

    Получить тип кампании, привязанной к данному пакету.
    Дотаточно получить только одну запись, поскольку все кампании в пакете должны быть одного типа

=cut

sub get_campaigns_type_by_strategy_id {
    my ($strategy_id, $cid) = @_;

    return get_one_column_sql( PPC( cid => $cid ), [
        'SELECT type FROM campaigns',
        WHERE => { strategy_id => $strategy_id }
    ] );
}

1;
