package Campaign::Const;

=head1 NAME

    Campaign::Const

=head1 DESCRIPTION
    
    константы для кампаний (в основном из БК)

=cut

use warnings;
use strict;
use Carp;

use utf8;

use base qw/Exporter/;
our @EXPORT = qw//;
my @_EXPORT_BASE = (@EXPORT, qw/
    get_page_ids_by_page_types
/);
my @_EXPORT_ENUMS = qw/@PAGE_TYPE_ENUM/;
our @EXPORT_OK = ( @_EXPORT_BASE, @_EXPORT_ENUMS);
our %EXPORT_TAGS = (
    'base' => \@_EXPORT_BASE,
    'enums' => \@_EXPORT_ENUMS );

my %PAGE_TYPE_TO_PAGE_IDS = (
    frontpage => [345620, 674114, 1638690, 1638708, 1654537],
    frontpage_mobile => [349254, 674124, 1638693, 1638711, 1654534, 1654540],
    browser_new_tab  => [526194, 526196, 674134, 674137],
);
our @PAGE_TYPE_ENUM = keys %PAGE_TYPE_TO_PAGE_IDS;

=head2 get_page_ids_by_page_types($page_name)

Получить ссылку на массив из типов, входящих в надтип по условию ИЛИ

=cut
sub get_page_ids_by_page_types(@) {
    my ($page_types) = @_;
    my @page_ids;
    for my $page_type (@$page_types) {
        if ($PAGE_TYPE_TO_PAGE_IDS{$page_type}) {
            push @page_ids, @{ $PAGE_TYPE_TO_PAGE_IDS{$page_type} }
        } else {
            croak "Page type is not exist";
        }
    }

    return \@page_ids;
}

1;
