package Campaign::RelatedKeywordsBudgets;
use Direct::Modern;

use Yandex::DateTime;

use Campaign;
use Stat::CustomizedArray::StreamedExt;

=head2 get_related_keywords_budgets
    Для заданных OrderId возвращает процент расхода бюджета на показы по ДРФ (DIRECT-63232)
    Вызов: get_related_keywords_budgets(from => 'YYYY-MM-DD', to => 'YYYY-MM-DD', order_ids => [OrderID, OrderID, OrderID, ...])
    Возвращает hashref:
    {
        OrderID => {percent => процент_расхода_бюджета, empty_days => количество_дней_без_показов_по_ДРФ},
        ...
    }
    Если за указанный период общий расход средств по кампании нулевой - для нее возвращается OrderID => undef
=cut

sub get_related_keywords_budgets {
    my (%in) = @_;

    my ($from, $to, $order_ids) = @in{qw/from to order_ids/};
    state $query_options = {
         options => {no_spec_and_all_prefix => 1, totals_separate => 1,},
         group_by => ['contexttype', 'date'], date_aggregation_by => 'day',
    };
    my $days_total = date($to)->delta_days(date($from))->delta_days();
    my %result;
    foreach my $order_id (@$order_ids){
        $result{$order_id} = undef;
        my $st_ext = Stat::CustomizedArray::StreamedExt->new();
        $st_ext->set_report_parameters(start_date => $from, end_date => $to, oid => $order_id, %$query_options);
        my $stat = $st_ext->generate_streamed_ext();
        my $total_sum = $stat->{totals}->{sum};
        next unless ($total_sum > 0);
        my ($days, $sum) = (0, 0);
        foreach my $item (@{$stat->{data_array}}){
                next unless ($item->{contexttype} eq 'auto-added-phrases');
                $days++;
                $sum += $item->{sum};
        }
        my $percent = ($sum/$total_sum)*100;
        $result{$order_id} = {
                percent => $percent < 100 ? $percent : 100,
                sum => $sum,
                total => $total_sum,
                $days < $days_total ? (empty_days => $days_total - $days) : (),
        };
    }

    return \%result;
}

1;
