#!/usr/bin/perl

=head1 NAME
    
    CheckShardMetabaseId

=head1 DESCRIPTION

    Expired by 2013-12-31.
    Модуль содержит функции, которые позволяют проверять изменения в создании записей с четными/нечетными idшниками в таблицах.
    Главное назначение: использование в миграциях при переходе на шардинг (создание id в метабазе).
    После запуска шардинга следует удалить (ориентировочно: конец 2013 года).

=cut

package CheckShardMetabaseId;

use warnings;
use strict;

use Yandex::DBTools;
use Settings;
use base qw/Exporter/;

my %tables;
=head2 get_count_lines

    Вычисляет количество четных/нечетных записей таблице.

=cut
sub get_count_lines {
  my ($field, $is_odd, $max_value) = @_;
  return get_one_field_sql(PPC, "SELECT COUNT($field) FROM $tables{$field} WHERE $field > ? AND $field % 2 = ?", $max_value, $is_odd ? 1 : 0);
}

=head2

    Проверка всех таблиц из %tables, что перестали создаваться записи с четными/нечетными idшниками.

=cut
sub check {
    my ($is_odd, $tables, $log) = @_;
    %tables = %$tables;
    $is_odd = $is_odd ? 1 : 0;

    # Время для сна.
    my $sleep_time = 1*60;

    my %max_values;
    my %even_values;
    foreach my $f (keys(%tables)) {
      $max_values{$f} = get_one_field_sql(PPC, "SELECT MAX($f) FROM $tables{$f}");
    }

    $log->out("Waiting for $sleep_time seconds...(1 / 2)");
    sleep ($sleep_time);
    foreach my $f (keys(%tables)) {
      $even_values{$f} = get_count_lines($f, $is_odd, $max_values{$f});
    }

    $log->out("Waiting for $sleep_time seconds... (2 / 2)");
    sleep ($sleep_time);
    my @errors;
    foreach my $f (keys(%tables)) {
      push @errors, $tables{$f} if (get_count_lines($f, $is_odd, $max_values{$f}) != $even_values{$f});
    }

    if (@errors) {
        $log->out(sprintf( "FAIL - %s", join ", ", @errors));
        exit;
    }
    $log->out("OK");

}

1;
