package Client::CurrencyTeaserData;

use strict;
use warnings;

use Yandex::DBTools;
use Yandex::HashUtils;

use List::MoreUtils qw(any all);

use BalanceWrapper;
use Settings;

=head2 $MODIFY_TEASER_SHOW_PERCENT_PROPERTY_NAME

    На какой процент переходящих без копирования клиентов показываем тизер
    Копирующимся -- показываем всем

=cut

our $MODIFY_TEASER_SHOW_PERCENT_PROPERTY_NAME = 'currency_convert_teaser_modify_show_percent';

=head2 $CURRENCY_CONVERT_TEASER_DEFAULT_PERCENT

    Умолчательный процент, на который включаем тизер переходящим без копирования клиентам

=cut

our $CURRENCY_CONVERT_TEASER_DEFAULT_PERCENT = 10;

=head2 $PARALLEL_LEVEL_PROPERTY_NAME

    Имя проперти, в которой хранится количество потоков для ppcFetchClientMulticurrencyTeaserData.pl
    Количество потоков из неё применяется к каждому шарду, т.е. общее число потоков будет умноженным на число шардов
    Её значение записывается из интерфейса через внутренний отчёт

=cut

our $PARALLEL_LEVEL_PROPERTY_NAME = 'FetchClientMulticurrencyTeaserData_parallel_level';

=head2 $DEFAULT_PARALLEL_LEVEL

    Умолчальное количество потоков для ppcFetchClientMulticurrencyTeaserData.pl

=cut

our $DEFAULT_PARALLEL_LEVEL = 1;

# Белоруские клиенты, которых можно конвертировать в бел. рубли (платили российскими рублями)
my @RUB_BELARUS_CLIENTIDS = (
    1125362, 1218157, 9294218, 2090533, 2554995, 2311761, 2282578, 3995734, 2198318, 2868755, 9921068, 3072464, 9909904, 2904201, 2720596, 3035462, 3382799, 3054028, 10255116, 4221831,
    1125947, 1218863, 10661398, 1116885, 2555232, 7822231, 2282660, 10634714, 10621131, 2757598, 12540658, 3072483, 3409649, 3007786, 2720616, 3115330, 3384970, 19495233, 12519485, 4222863,
    1588272, 1223152, 1412608, 1454382, 2555820, 2442688, 2200519, 10637293, 10621347, 2758521, 4317126, 3073604, 3413992, 3007888, 2720658, 3115986, 3386857, 2841686, 12523608, 4283991,
    1590122, 10980329, 1414140, 1203825, 2556420, 2267942, 2200975, 4011740, 10624366, 2758513, 4318638, 3075846, 2697228, 3007960, 2722904, 3116390, 3669346, 2847055, 9568447, 5374042,
    550242, 2232313, 1415380, 7396290, 2560497, 2315398, 2204533, 11988954, 2380369, 2760976, 4356715, 3151712, 2701727, 3009830, 2724801, 3372681, 2832949, 2848000, 9884933, 5375046,
    768197, 2232520, 1416803, 1493086, 2961363, 2856027, 5029359, 7061202, 2381738, 2761766, 4684154, 3161362, 2790585, 3010069, 2725218, 3373344, 2833444, 2848121, 9885802, 5378388,
    819840, 2234666, 1853544, 1494298, 2962782, 2856539, 10945324, 4049822, 2291548, 3239865, 4685251, 3161731, 2794194, 3012792, 2811482, 3201425, 2834005, 2945999, 9885945, 4323321,
    819865, 1845847, 1855062, 1284916, 2963526, 2856615, 10947051, 9946213, 21851962, 3242030, 9584519, 3255193, 2500390, 3013131, 2812477, 3449742, 2834710, 2947919, 9889762, 9553838,
    819944, 1850088, 2079086, 1287229, 2963628, 2856622, 10947996, 9946615, 7449990, 3244323, 4489815, 3255212, 2414332, 3014518, 2815215, 3453975, 2835610, 2948133, 3532445, 9553908,
    820400, 2021937, 847295, 21880429, 2963858, 2856881, 8224884, 9946669, 7452680, 3808339, 10915356, 3257227, 2414936, 3014656, 2815930, 3308506, 2835984, 2948146, 3535169, 9554052,
    822265, 2024441, 933445, 1545680, 2964017, 2862710, 8226466, 11499027, 7452939, 3811681, 11488827, 9912268, 2895785, 3014692, 2816054, 3311409, 2837405, 2948183, 3535809, 9554244,
    946340, 1930146, 933669, 1648951, 2964128, 2862713, 10639542, 14125926, 4178015, 3610009, 11491583, 9912678, 2896131, 5498333, 2816983, 3313162, 2838011, 2948286, 10598976, 9554306,
    946728, 1931446, 977865, 1328547, 2964228, 2862948, 3983453, 11736469, 5047443, 2972707, 11967355, 9912873, 2896328, 3093318, 2817112, 2825851, 2838652, 2948596, 3775341, 9554515,
    996447, 1934374, 982832, 1329513, 2964921, 2863092, 3984964, 9592623, 5047624, 2973109, 11969287, 9913048, 2897654, 3093457, 2916087, 2827609, 2838837, 2950251, 3780850, 9554638,
    997854, 7378055, 2084765, 1329507, 1616513, 2863176, 3985995, 9593416, 9939347, 9927611, 11969461, 9914230, 2898215, 3093667, 2916986, 2827692, 2839027, 3136995, 5513404, 9557778,
    1555417, 7799456, 2085856, 1329522, 1617064, 2863282, 21861848, 9593882, 9940943, 9927711, 13128595, 9914438, 3000717, 3093838, 2917001, 2828532, 2839109, 3137176, 5515037, 5527725,
    1555981, 1970833, 1107685, 1337395, 1678970, 2863627, 3997733, 15203385, 9941920, 9928358, 13130518, 9914474, 3001407, 3094058, 2917065, 2828619, 2839104, 3141945, 8532985, 10589032,
    1083214, 350305, 1108540, 1338057, 10962372, 7409430, 4001968, 16212724, 9942545, 9928896, 13130878, 9915539, 3001516, 3094175, 2918886, 2829306, 2839195, 9574938, 15942754, 4412096,
    1921562, 793891, 1156621, 7855299, 2422072, 2389219, 4002433, 15713283, 9943226, 9930685, 15193909, 12537249, 3005599, 3096290, 2919082, 2831564, 2839472, 9579050, 15942761, 17543484,
    1808045, 431559, 1192926, 1351339, 2423352, 7837222, 4069845, 16905254, 5483288, 3061216, 18222772, 2692620, 3005624, 3097965, 2919194, 2831785, 2746958, 9579749, 12852190, 10894747,
    5447042, 510594, 1232488, 10318654, 2424211, 7838631, 4806286, 4297171, 5485054, 3062775, 18224067, 2780353, 3087922, 3180147, 2921113, 2832422, 2748974, 3327530, 11481769, 12841621,
    5448463, 540083, 1236226, 9615271, 9966203, 2448107, 4039253, 4341080, 4343129, 8188790, 4632032, 2781726, 3088271, 7496020, 2921299, 2733862, 2749005, 3397382, 3901800, 12842199,
    5448487, 844659, 1236265, 9616030, 9969515, 2276300, 9951317, 10935253, 4343319, 2769068, 16459482, 2782746, 3090603, 4197285, 19513919, 2734540, 2749037, 9898224, 3904022, 12843381,
    1832786, 969745, 1236591, 9616267, 1724244, 2277437, 9951432, 10936799, 4344646, 2769427, 20540618, 2784527, 3090800, 2716527, 3022099, 2736499, 2749091, 9900667, 3917597, 11228833,
    1838055, 1017902, 1236689, 9616705, 1727454, 2278531, 9951448, 2111037, 10282755, 2769434, 17330910, 2784739, 3090838, 2802994, 3026672, 2736604, 2936530, 7506597, 3924005, 11228834,
    1877050, 1101833, 3574367, 9618779, 1386170, 10957290, 9951611, 2111040, 12547842, 2770676, 18845831, 2786302, 3345093, 2803258, 3026966, 2736659, 2938556, 3515974, 11958439, 11706717,
    1877640, 2027053, 1487147, 9618780, 10312425, 8235900, 9952169, 2111099, 4371109, 7465054, 2586830, 2495281, 3345152, 2803445, 3108677, 2736908, 2940053, 2520021, 21821009, 19840952,
    1878568, 2028580, 1487310, 2952330, 10314489, 12578045, 9952596, 2133732, 9586722, 2979789, 2687179, 2495347, 14104177, 2804161, 3109593, 2736920, 2940281, 2520647, 21822612, 18213068,
    1879074, 1229184, 1568603, 2954598, 1780300, 2118996, 9952752, 2133930, 9588045, 2979823, 2771981, 2409396, 14105614, 2804282, 3110220, 2737026, 2940424, 2521046, 2526656, 18213946,
    2353338, 1260197, 1570237, 2956233, 1782984, 2121464, 9953329, 2457067, 9588293, 2982713, 2772598, 2411431, 14105771, 2805805, 3112513, 2737032, 2941782, 3525138, 2526957, 18427348,
    2355854, 1534003, 1639408, 1374750, 9611816, 2124012, 9953954, 11985223, 9588453, 2983826, 2773710, 2412526, 3268725, 2909451, 3112842, 2931865, 3042881, 19486549, 19480237, 18427624,
    2301641, 1563646, 1304941, 1374742, 9611819, 2124362, 9954158, 2206017, 9589000, 2983844, 2775715, 2413291, 3271856, 2909586, 3113476, 2932116, 3044553, 19486685, 10251921, 12232051,
    2304371, 1564347, 1604854, 1772150, 9611853, 2124986, 12568727, 2207096, 10615261, 2984332, 2777064, 2889172, 3272373, 2911591, 3296194, 2932237, 3044595, 19489437, 10252485, 15186199,
    2304994, 1438407, 1606096, 1772508, 9612766, 2170537, 4099085, 2209703, 10617004, 2872796, 2777698, 2889207, 3171886, 2914285, 3950243, 2932251, 3044674, 10262256, 9880667, 13118010,
    2305187, 1439218, 1902437, 1775220, 9612776, 2174384, 10296785, 2210230, 4486766, 2877477, 2401412, 2889270, 3173060, 19518500, 3953553, 2932988, 3046962, 10262952, 9880770, 13120004,
    2306625, 1440970, 2034907, 3234658, 9614525, 9605318, 10299013, 2183526, 4486793, 2878915, 2404145, 2889400, 3174759, 3101423, 3953982, 2933091, 3047423, 10263781, 10590595, 18632556,
    2552083, 1601947, 9977643, 1907445, 9614529, 9605689, 5473907, 2184096, 11971191, 3064281, 2404160, 2892689, 3174924, 3103573, 3194846, 2933397, 3049216, 9569673, 10593087, 18633731,
    2010825, 7381701, 9978376, 1907782, 9615155, 9606188, 9597974, 2184177, 15955169, 3064313, 2407460, 21828508, 3175017, 3103905, 3196089, 2933534, 3129272, 9570306, 12847432, 14776959,
    7365320, 7382621, 1665859, 1752646, 1408933, 9606492, 9599488, 8932932, 11253997, 3067326, 2881639, 21828693, 3176873, 3106437, 3198339, 2933579, 3133103, 9570844, 12848731, 17322780,
    1956070, 7385483, 1371216, 10651832, 1797548, 2047092, 9600235, 2397945, 11493371, 3069551, 2883668, 21829903, 21826876, 3106627, 3198912, 2933805, 3133429, 9572914, 8149252, 5062857,
    1592543, 1326508, 1710901, 527470, 7843344, 2047578, 4132507, 2401358, 12253473, 3070392, 2883854, 2993641, 12530075, 3014793, 3198997, 2933927, 3133688, 12525209, 11711876, 22521436,
    1592652, 1326801, 1710976, 486873, 7844891, 2450556, 4133706, 2238880, 12255921, 3247542, 2884001, 2995047, 9900778, 3015193, 3199177, 2934064, 3135718, 9890256, 3910877, 4644299,
    501686, 1326864, 1710981, 486879, 7845084, 2452640, 4136943, 2240388, 13132169, 3615067, 2884294, 2996785, 9901688, 3015513, 3365838, 2934302, 3216420, 9891590, 3912350, 11943765,
    557002, 1328211, 1711141, 486963, 7401989, 7418105, 4145965, 2242380, 13132680, 8564989, 2886637, 2998900, 9902687, 3015691, 3368764, 19501596, 3217301, 9892890, 3976379, 7543390,
    870717, 1658654, 1742006, 486979, 7402428, 7420322, 4166987, 2113738, 4582318, 3144387, 2886861, 3000079, 9902816, 3015841, 3494694, 19501711, 3217734, 9893709, 13122276, 9548524,
    916132, 1343122, 1769082, 487594, 7402623, 7420703, 4167073, 2118854, 16208393, 3147601, 2886943, 13394593, 9903008, 3015977, 4385922, 3035574, 3218091, 7510097, 13123461, 9548936,
    1986710, 1344312, 1400447, 810039, 2848454, 10952565, 4169705, 2463876, 17335315, 3148216, 7476661, 3079835, 9903022, 3017268, 2817778, 3036303, 3218290, 3643344, 2534470, 9549590,
    1004157, 12599096, 1402068, 856209, 2848455, 10953760, 5367650, 2464532, 4677502, 3150352, 21836733, 7484734, 9905160, 3017307, 2818040, 3036774, 3218674, 3643421, 7524605, 9550395,
    5451367, 9625775, 1404690, 1703367, 2848509, 9954476, 19265676, 2465629, 2225267, 3150848, 2987011, 3165895, 9905498, 3017492, 2818902, 3036956, 3220056, 3769824, 7525315, 9552517,
    5451825, 9627352, 2150263, 1030418, 2848763, 9954690, 17562211, 2140686, 2229342, 3150872, 2987391, 3166841, 3483170, 3020019, 2821358, 3037001, 3220974, 3770781, 3552290, 9552917,
    5451954, 1737090, 2152461, 1454668, 2849072, 9954832, 17564701, 2140717, 2257152, 3150881, 2987419, 3167027, 2508743, 3020073, 2821783, 3040048, 3314010, 3771259, 3553093, 4420396,
    5452166, 2361769, 2155602, 1458120, 2849126, 9957984, 13418252, 2140737, 2259398, 9923330, 2988572, 3168495, 2703850, 3020053, 2822037, 3040237, 3314336, 10599915, 4273623, 4420964,
    1080875, 2363658, 1857508, 1118104, 2849876, 12573368, 4430047, 7443290, 2295373, 9924154, 2988725, 3169757, 2707627, 3020221, 2822095, 3040905, 3317661, 4091006, 12509504, 9869164,
    1965310, 1706446, 1857950, 1651330, 2850418, 2105535, 4430088, 13411176, 2297140, 9924465, 2988727, 3170778, 2707900, 3020260, 2822690, 3122736, 3510802, 4093434, 7529012, 9869214,
    2060679, 1706742, 1949887, 1656180, 2850465, 2162638, 4430136, 11976212, 2298403, 9925010, 2988720, 3261290, 2707959, 3020616, 2727729, 3123138, 2751023, 8536750, 7529068, 9869769,
    2062701, 1896594, 543309, 1208715, 2852295, 2168706, 4430199, 2188005, 9933225, 9926536, 2988722, 3264459, 2707988, 3289779, 2733323, 3123201, 2751650, 14099228, 7531951, 9871275,
    2062936, 1896831, 809300, 1829272, 2855089, 10301984, 4430222, 2189234, 9936571, 4050639, 2988745, 3338029, 2796726, 3189166, 2733602, 3123361, 2752152, 14100780, 2543863, 9873034,
    10986249, 1896905, 1615320, 1246473, 2965015, 10303639, 13880478, 2190065, 9937093, 5055875, 2988744, 3338070, 2799398, 3189247, 2733680, 3126320, 2752442, 3872560, 19465767, 17540149,
    7874741, 1898034, 473792, 7398958, 2965043, 9601571, 4328608, 2193107, 9937543, 4186044, 2989318, 9906261, 2799797, 3190093, 2925249, 3127245, 2752565, 10909801, 3560055, 17759527,
    1883557, 1898173, 478440, 1525168, 2967277, 9601767, 4333447, 10625277, 9937638, 4378199, 2990114, 9906575, 2800004, 3191063, 3030059, 3210095, 2752888, 10912575, 10248856, 17760989,
    1923950, 1899045, 480013, 1432748, 2968957, 9602045, 10940197, 2246884, 7460906, 9917311, 2991712, 9906677, 2800219, 3192241, 3031566, 3213943, 2752998, 4018267, 9877174, 14082272,
    562001, 9981747, 480774, 1435817, 2969523, 9602941, 10942217, 2249447, 2567537, 9918555, 2992012, 9906862, 2802587, 3364300, 3032089, 3213944, 3050546, 11245297, 4217750, 10234569,
    832396, 9984129, 1822175, 1385442, 2385047, 9603115, 5043155, 2252329, 2568579, 9918697, 2992082, 9906960, 2901500, 3486710, 3032293, 3214230, 3050819, 11245793, 4217893, 10890417,
    834522, 5460204, 1574104, 1580385, 2387628, 9603173, 4139723, 2195917, 2864478, 9920173, 3070826, 9907703, 2901513, 3490566, 3032461, 3214440, 3050932, 11486361, 4220333, 11462626,
    1091123, 5460629, 2089193, 1580669, 2387877, 9604902, 7429559, 2196705, 2865310, 9920180, 3071683, 9908293, 2901690, 2719569, 3034646, 3456827, 3050941, 11961886, 4220922, 11705163,
    1473906, 5461822, 2089819, 1316179, 2309668, 9605016, 3989791, 2198234, 2867796, 9920650, 3072401, 9908506, 2901704, 2720607, 3034869, 3460207, 3053717, 11963844, 4221263, 18206971,
    4646530, 9542426, 14059541, 21547864, 11909337, 19790261, 18370228, 10522503, 5754307, 18553759, 9778280, 6055732, 8026081, 6700801, 15338515, 18086050, 9404946, 9393352, 14827989, 11068140,
    4651058, 10571434, 4854496, 15424556, 13079772, 9500507, 12174687, 19775414, 5756159, 18760678, 9778605, 10485223, 13270026, 6700862, 6866203, 11579177, 9407245, 9393523, 14830197, 11541566,
    13112570, 4892518, 4817843, 15427498, 17504221, 9500957, 22276163, 5631723, 12770012, 20458034, 12137263, 6090244, 9436480, 6701190, 21686761, 11579420, 13946614, 9395704, 21979449, 11544616,
    4691979, 10226043, 4820691, 16421691, 19421717, 9503534, 12446236, 5633560, 9476555, 5590514, 20851320, 9447066, 9436862, 6701242, 21687320, 9415220, 9728049, 9395831, 15776249, 11784013,
    19257454, 15918497, 4820714, 18601892, 17728355, 9821290, 13063521, 10173978, 9478447, 7627776, 20852137, 9447140, 9437907, 6701288, 21687478, 9415228, 9728488, 9716392, 17390759, 21968219,
    14567853, 12828175, 13828688, 17298346, 21538197, 9821525, 15401712, 10174381, 5816586, 5877100, 5961930, 9449954, 9439974, 6702071, 21687779, 10104775, 9729036, 9718591, 17611223, 13456346,
    14978120, 12828971, 9529795, 18810750, 20283123, 9821550, 16139939, 10175615, 5818125, 5878295, 11140613, 9450815, 9441371, 6702121, 18516668, 10105844, 9731200, 9718931, 17614477, 15767821,
    21380433, 19826612, 9847265, 18812824, 15414507, 9822485, 16398944, 10175625, 9795630, 5883268, 11141564, 9450983, 9757101, 9753048, 21060281, 10107997, 7171874, 9719330, 21421556, 16508030,
    17319542, 11931353, 9848763, 20707870, 15418456, 9822878, 16835040, 11644920, 9795879, 5883286, 19753221, 15089186, 9761364, 9754104, 22014103, 10109885, 7173942, 11081496, 21425784, 18472116,
    4725850, 11935152, 9850829, 5558927, 18594471, 9823149, 17276882, 12437355, 5941475, 9462917, 10149815, 7114512, 9761847, 9756766, 22404261, 9739430, 14841711, 11318938, 18480698, 22554556,
    22517242, 18196079, 9851590, 5559849, 20498024, 9823327, 5415917, 13052613, 5941784, 9463481, 15097877, 9770616, 6721442, 6725504, 22596440, 9740963, 19330794, 11319263, 18482061, 22554579,
    7546866, 18616687, 9852028, 14050373, 17288260, 9825002, 5416389, 13055456, 10510875, 9464954, 11379295, 9771902, 6721589, 11353103, 7665121, 6966994, 20400913, 12966481, 20386220, 22554824,
    9544972, 18618991, 10214631, 4932451, 17290764, 10189299, 5421761, 13559227, 10512937, 9465920, 11381982, 9141867, 6721641, 10123951, 7665202, 6969303, 20603415, 11557930, 22563017, 22555040,
    9545003, 16181624, 10216726, 7572764, 17291046, 10189694, 5332595, 14304192, 19767287, 9466458, 11617758, 11848651, 6722839, 10124597, 8007003, 13493550, 21993146, 10083816, 7706306, 7296376,
    9545227, 16182271, 4836480, 4972855, 20698145, 10191780, 5333569, 14508995, 10164965, 9466735, 11860125, 12130261, 11362128, 10125031, 10461059, 19972983, 12978625, 10084118, 9385936, 20579727,
    9545324, 12486079, 14345063, 10552495, 5166275, 15138972, 5425449, 21511028, 10165835, 9466737, 6004090, 13523691, 10126273, 11595048, 10463082, 15566011, 12980232, 10084835, 12069887, 7207506,
    9546257, 21367234, 11922136, 12807824, 15886848, 12451284, 5425832, 21512519, 10167326, 9467068, 13997693, 14474265, 10127448, 11833474, 10464215, 15802087, 17627011, 10086066, 9709195, 9065407,
    4234560, 13609324, 11922995, 15898242, 15888305, 12451657, 5427545, 15393299, 10167846, 9467159, 14279340, 14475606, 10128886, 11835960, 6599489, 15804574, 15047200, 10086324, 9709289, 9374268,
    4237345, 13841357, 14752788, 15899274, 15889589, 12452293, 5428885, 15630180, 10168128, 9467372, 18121772, 15357407, 10129273, 6808762, 6623343, 22201330, 16314384, 10086379, 9709910, 9374695,
    9863359, 22690446, 19237599, 9836541, 15889727, 10848801, 9490148, 16825682, 15112884, 9785340, 17680005, 15832268, 10130367, 13505556, 6625248, 22587530, 16531258, 10086428, 9710507, 9697755,
    9863415, 4748285, 18818698, 9839398, 5314044, 13069130, 9490399, 5693904, 11871435, 9786269, 6079906, 15834882, 11836624, 13506594, 11106944, 18922606, 16752603, 10086867, 9710758, 12330357,
    9865552, 4781382, 21360478, 9839939, 5317202, 11897796, 9810797, 19195064, 11874190, 10500581, 15841259, 17669047, 11838749, 13508551, 11107014, 6998344, 17403528, 10088192, 10737305, 12332819,
    9867340, 13360806, 20300921, 9520268, 20894847, 18583872, 9811101, 19197550, 20024397, 10501142, 16582188, 6500810, 13007071, 13970410, 11107399, 7678895, 17405260, 10088212, 12958993, 10729133,
    4427747, 14065220, 4867503, 9520465, 20895011, 22474928, 9812691, 20475321, 14500383, 10503287, 17239002, 20439089, 13009124, 12386275, 6683878, 10452674, 17405922, 14627488, 11068269, 7165617,
    4429202, 9852948, 4867526, 9520900, 9828956, 15405019, 5605027, 22266853, 15623821, 10503808, 18962206, 18325577, 13010202, 6835189, 11345636, 10453447, 7222819, 14629353, 11071556, 10061654,
    4481609, 9853473, 16170707, 20905642, 9829162, 15405822, 5605557, 5808505, 20251103, 11143561, 21715316, 6541665, 12388274, 16081072, 11346328, 7998179, 10754158, 14630161, 11546347, 11302383,
    10577703, 9854026, 4912053, 14540882, 9829362, 16404697, 19782265, 17479630, 16814813, 11145742, 20446766, 21704384, 12391431, 16081291, 9741654, 7999399, 11083734, 14630366, 11549364, 11536749,
    14076895, 9854105, 4916092, 10204966, 9830097, 16842509, 20880404, 18358962, 16815100, 5954962, 20449727, 21707338, 12391884, 14461168, 9742197, 10100007, 11084627, 21030911, 11549559, 11537758,
    17755863, 9856733, 4956362, 10207139, 9830664, 17278489, 20881006, 5899138, 16817844, 10156597, 5965339, 19369374, 14466160, 14462425, 9742447, 10100719, 11085310, 14831804, 11786642, 11539866,
    17758498, 10565255, 5549642, 10207931, 10194795, 17278509, 10182043, 7607373, 17914548, 15101570, 6085375, 7644039, 14467064, 14663252, 9742457, 10102663, 11087611, 14832912, 11789233, 11541101,
    4570991, 10566015, 5554781, 10863168, 10199079, 7592061, 10182989, 9479128, 18349290, 15104445, 9453651, 9443136, 16085329, 14666544, 9743088, 10102843, 11327208, 14836116, 10074198, 14200919,
    4571850, 10568169, 16645603, 5116568, 15144914, 7592434, 10183033, 9482807, 6157921, 11383513, 9454141, 9444675, 16086184, 14869242, 9743259, 10103400, 11565442, 21428676, 10075950, 13452986,
    4573541, 9532557, 16864321, 11912722, 19217611, 7592900, 15128238, 9483010, 7622529, 11622573, 9454566, 9446198, 19155381, 19352821, 9745114, 9412203, 11804164, 20591253, 14209479, 14812904,
    10230348, 9532937, 17307430, 12465172, 17499891, 7593174, 5628473, 9483202, 12765211, 5995330, 9455349, 6663108, 14871499, 17653891, 6738460, 9412325, 11805285, 20792356, 15298736, 16721435,
    10230724, 9533358, 8850285, 5129549, 12453713, 7595457, 13056302, 5588597, 9468687, 11863132, 9455390, 13276183, 17659046, 15341678, 10110657, 9412904, 19694514, 22570423, 21972416, 16721667,
    10231749, 9533382, 13350320, 21540878, 12456720, 7595597, 13057247, 5588684, 9468909, 13999326, 10492286, 9762313, 15587830, 15343345, 10110832, 9734496, 10091531, 17620075, 15535689, 17596303,
    15923087, 9534287, 13353414, 21542225, 10540897, 7595732, 21517902, 5588736, 9468928, 14286055, 9142246, 9762776, 15822354, 15343908, 10110887, 13488335, 10091677, 18484441, 15536789, 17597423,
    10888545, 9534605, 10557064, 16420069, 10852943, 10534830, 20040597, 10515707, 9469389, 14488230, 9777341, 9763529, 15822491, 15819404, 10112818, 13950901, 10091852, 9081347, 14822764, 18258280,
    12831771, 9534835, 10558469, 5396514, 11423793, 5298067, 14312021, 10516094, 9471096, 6070650, 20847263, 9765982, 15824893, 21691903, 10112875, 14642981, 10092439, 7975486, 14824271, 18464137,
    11698567, 9535088, 4792914, 5396922, 11665071, 5299775, 14025183, 10519202, 9471131, 6071927, 11135231, 6690317, 16778904, 18727157, 11825147, 21249114, 10093192, 7978141, 15771761, 18464356,
    4615845, 9535500, 4793381, 20504792, 11901489, 8461646, 5646109, 10827860, 9473381, 6072626, 11372896, 6690529, 20427268, 6883396, 13729568, 12981324, 13476859, 9388014, 16513666, 18464601,
    18625750, 4946406, 15903084, 5155829, 20280565, 10840628, 15398086, 10828208, 5825253, 15370638, 11373880, 6690637, 17432265, 6400072, 13961295, 12982808, 9400795, 9391331, 17169132, 22157805,
    16188042, 4987449, 9523956, 14044909, 21530286, 11175895, 16391364, 10168854, 5828681, 20242492, 10143710, 6690738, 19358295, 6446854, 12103075, 15320151, 9403260, 9712043, 17384272, 20571449,
    13369576, 15909945, 9525229, 14045245, 21532084, 11413197, 15634793, 10171540, 10507505, 16589542, 10144260, 6690917, 18734007, 6447158, 12105323, 15324119, 9403610, 9712980, 7205733, 7227926,
    4695208, 15913525, 9526251, 13340428, 17944089, 20887327, 20263032, 10171963, 12148748, 17680743, 11613752, 6690998, 22608810, 6487761, 20199710, 20404372, 7176689, 9713790, 17607868, 12051633,
    4697844, 12822980, 9526642, 13343136, 18166760, 11891187, 16610904, 5639100, 11150800, 16803685, 11614401, 6691098, 6954663, 6488172, 20202888, 17630814, 9723342, 9714443, 21223566, 9695951,
    16442428, 12825644, 4826456, 8840151, 5347954, 11895050, 16613262, 5639394, 11151666, 18341914, 11853571, 6796178, 7656796, 10469149, 17645028, 17855545, 9723929, 9715255, 20381163, 7954691,
    13610483, 11210272, 9841903, 12801339, 5352868, 14028608, 16614271, 15116515, 20861341, 18550750, 11854528, 6796839, 6393976, 10777542, 15064372, 16317293, 9724145, 9715654, 19105594, 12945347,
    13845753, 11449345, 9842651, 12801638, 15651452, 5327057, 16828838, 15120295, 19760834, 18755896, 12134705, 6796880, 6441567, 9426820, 15330626, 22582793, 9724377, 9715742, 22557017, 19665084,
    14564274, 14553785, 9842673, 5307045, 15653876, 19787911, 16829292, 11636946, 15109724, 18757953, 13526710, 6796905, 6480882, 11349052, 15333372, 22583243, 9724699, 9716175, 22557317, 15280651,
    14565492, 5546754, 9843608, 13580053, 16629424, 14521717, 16832653, 11637813, 10160309, 20452082, 14479890, 12393538, 10472027, 11350116, 15806390, 22583488, 9725201, 12961824, 22558333, 11295980,
    14566012, 5547742, 9845088, 13813423, 22087517, 14723436, 5669793, 11640435, 10161865, 22049989, 14685982, 12394449, 9433320, 11827305, 15808442, 22583617, 9725282, 12964566, 7707748, 11774952,
    14769616, 18192652, 9846225, 14536964, 17283141, 10187243, 19198661, 13048853, 10162802, 5600688, 18117854, 12395461, 9434195, 11829579, 21680665, 22583686, 9726113, 11551305, 7711792, 15520347,
    14972802, 22687900, 9846227, 9831633, 17284201, 10188008, 19198699, 13550431, 11387733, 5602136, 16100743, 12397858, 9434271, 18093797, 21681931, 18292951, 19325107, 11554619, 9702405, 16497601,
    22512236, 18403687, 10210088, 9833951, 14033443, 10188589, 22267933, 5661623, 11630393, 7630900, 16101395, 12398226, 9434947, 13502670, 17421223, 16754690, 21990708, 10078436, 9703893, 14193908,
    22515905, 19241324, 10210703, 9834846, 14037422, 9496697, 18152976, 21506012, 5987751, 5774964, 14888301, 13016053, 9435737, 13965960, 6867164, 7994698, 20392800, 10078615, 12062026, 14194136,
    4730946, 21362069, 10210795, 20902513, 13331303, 9498621, 18365715, 16126417, 5990243, 5779578, 15835228, 14468248, 9435848, 16079472, 6868813, 11566702, 21662133, 10078888, 12066197, 16718362,
    4733294, 12479561, 10214199, 9513503, 13332109, 9499763, 5891712, 16820812, 13040680, 5842241, 6497986, 14675211, 9436076, 12997395, 6895216, 11567101, 22183926, 10079001, 12334457, 14400691,
    8867520, 22502008, 4842169, 14737891, 5356439, 17488221, 5897281, 16822381, 13300624, 5884900, 17671729, 16090137, 6673891, 12111390, 13250141, 10093930, 15314039, 10079258, 7164457, 13205925,
    17529056, 16178026, 11918735, 14738173, 15884790, 19204640, 7606884, 17260823, 17464572, 9458020, 18330972, 18526843, 6700155, 12379202, 6898125, 10095232, 17625264, 10080034, 7165081, 14806804,
    9231183, 16431329, 13090412, 14738584, 13573518, 9817348, 5433722, 17261615, 14004959, 9458217, 18332453, 18738714, 6700214, 12380316, 6902857, 10095614, 18281238, 10081364, 12677204, 13908702,
    17751410, 16650070, 14544314, 14741450, 13804232, 9819796, 8449051, 17262891, 14288527, 9459369, 19373594, 19363617, 6700332, 14657578, 8002781, 10095642, 18699024, 10082367, 10068134, 13910997,
    9862699, 17092878, 14546201, 10201163, 14318248, 9819924, 9486495, 21735066, 14289101, 9459383, 22037059, 19365248, 6700399, 14862503, 10457443, 10096807, 16308094, 10082727, 10070994, 17368654,
    14072296, 8111153, 19231052, 15147527, 14731594, 20484900, 9488031, 5814839, 15375269, 9460234, 6555362, 6873660, 6700459, 17648383, 10458414, 13480453, 16745966, 10082793, 10072078, 17813781,
    9538657, 4788568, 17513715, 12460794, 17495499, 17714544, 9488056, 18357935, 17250792, 9460333, 7638908, 22223178, 6700513, 15069417, 6957185, 13483529, 17397589, 15304016, 11065554, 22543898,
    9540522, 13357297, 4861344, 11907474, 19212699, 21751854, 10519939, 5709715, 17909707, 9462293, 6016922, 6440323, 6700683, 15336321, 18084479, 9404353, 7982829, 14827383, 11067398, 22544430,
    10405058, 14191652, 12931139, 18657040, 7245160, 11516804, 10034549, 18647909, 10031359, 13884196, 9662256, 10019185, 10684643, 10014675, 19620880, 10010770, 10004268, 9999725, 12607878, 9631599,
    12318460, 13440045, 12933748, 22533235, 9679086, 20347920, 10036151, 13424366, 10031471, 11509681, 9663331, 10019826, 10685430, 10016965, 11010362, 9649903, 10006525, 9999857, 13142166, 9632607,
    12322794, 13674680, 10712505, 22533819, 19649732, 13429895, 15262207, 13426614, 10031831, 20543656, 10690370, 10019846, 12907516, 10018035, 11011424, 12900140, 10006645, 10356779, 9994823, 9633132,
    7952579, 7290443, 10046366, 7301771, 10041258, 13660907, 15499536, 13888581, 10031999, 17789195, 12912215, 10019899, 12907975, 7335580, 11011540, 12900761, 10363953, 15970122, 9994913, 9633677,
    7264148, 21396295, 10047337, 7301883, 10041266, 13892895, 16003019, 13889778, 10033662, 18229419, 12913064, 10019911, 15231246, 7337533, 10007878, 15983961, 9644874, 9636015, 10351866, 9633817,
    7264996, 21396448, 10047369, 20556543, 10042751, 13896401, 16477946, 13892039, 12916849, 7748697, 15236175, 10019953, 12283141, 9651581, 10007908, 21910059, 13156424, 9637611, 10352131, 8625074,
    15276470, 7301212, 16489472, 20557565, 12312482, 18236923, 16916912, 7314162, 15496230, 7921844, 15236458, 10021206, 19629069, 12902757, 10008715, 11004655, 7775119, 9639966, 10353679, 19602697,
    16273503, 20562293, 16708518, 20755423, 15504111, 22526413, 21614450, 7930258, 15998876, 12293033, 11018621, 10021701, 12624829, 16237233, 10008762, 11007767, 7775998, 7891601, 10353849, 9989056,
    10051664, 20760396, 16708787, 7736786, 15504358, 22529769, 11513513, 19643092, 16470419, 11025556, 11020136, 7332581, 11016465, 15988815, 10009283, 11008106, 7895008, 7894388, 7888628, 9990322,
    16929939, 7242194, 16923850, 7940887, 15504905, 7739994, 7277082, 19644167, 16690526, 19636772, 11020251, 9659131, 11017908, 12006643, 10009318, 14144258, 9997998, 11991724, 7786910, 7360928,
    16932803, 9680882, 14596235, 7942101, 16700215, 12031985, 7280261, 10029490, 16691297, 10023883, 19631710, 9659155, 10013393, 7769284, 10009591, 12892815, 9998546, 8632699, 12599887, 7361594,
    21625472, 9684532, 20139538, 21946989, 16703667, 7250118, 17796032, 10029507, 17133225, 12638316, 8657266, 9660133, 10013698, 7905294, 10009598, 10002389, 9999491, 21902031, 12601912, 7364199,
    14190900, 19657179, 20142368, 7244754, 7271082, 7250122, 18022130, 10029688, 13423527, 9660813, 10018397, 10376866, 10013740, 8647521, 10010255, 10002703, 9999661, 19608531, 10347565,
    409480, 2457820, 1034116, 4040291, 1857496, 1557503, 1264046, 1271036, 1281916, 1206149, 14030050, 832182, 1118074, 977821, 1975218, 2408256, 5307272, 6598917, 1991443, 1409204,
    410424, 2397563, 496681, 4655807, 1789872, 1558024, 1506636, 1491630, 1284648, 1206226, 5327433, 832547, 1122153, 978967, 2119350, 3264601, 5345751, 6599355, 1991952, 1797325,
    410456, 2400532, 993491, 4655875, 1950875, 1177059, 1509007, 1568189, 1289592, 1829693, 10188685, 834509, 1170125, 1233901, 2174494, 8549211, 5405387, 6662486, 2233531, 7845482,
    410812, 2321368, 498087, 11446314, 1951333, 1177927, 1509662, 1569016, 1289595, 1244882, 18779001, 835710, 1170906, 1567842, 2046114, 3410920, 8091987, 6817617, 1891096, 2366068,
    496871, 2143263, 507754, 9838046, 1952390, 1180859, 1509790, 1569633, 1289598, 1248307, 5981050, 1142635, 1248756, 1308631, 2046875, 8166061, 5315871, 6867013, 1891132, 2263723,
    533201, 2252434, 486876, 8819963, 2089815, 1054554, 1510394, 1570365, 1289600, 1248523, 13042535, 919534, 1529000, 1445638, 2450042, 3480042, 5317482, 7671111, 1967784, 2266258,
    772423, 2382093, 486881, 6157221, 1276424, 1055812, 1531730, 1571022, 1289579, 1499559, 13037103, 964850, 1127895, 1446087, 2105049, 5502578, 17501165, 8003831, 1482250, 2308739,
    903287, 2296561, 486965, 7629805, 1280538, 1056655, 1534689, 1572332, 1289580, 1499667, 11622962, 965299, 1129902, 1903418, 2168004, 4197534, 5347579, 6967100, 7384696, 3606185,
    1085499, 3249133, 489032, 6760128, 1294625, 1061169, 1560381, 1537632, 1289615, 1503739, 13035993, 966678, 822233, 1815922, 5030162, 3489423, 5349995, 10102088, 1362221, 2392524,
    2355581, 3249548, 489037, 15217927, 1295093, 1069472, 1560416, 1304214, 1289616, 1503745, 6080069, 966775, 860929, 1402004, 3934605, 3370262, 8821352, 15322448, 1363903, 7841590,
    2301797, 5054212, 492688, 497318, 1295644, 1216077, 1441873, 1304235, 1289626, 1503792, 9775755, 1222973, 861997, 2150108, 4021843, 3496256, 5366864, 7680724, 1365238, 2445678,
    412022, 4588423, 954960, 1587338, 1296486, 1085411, 1624613, 1304224, 1293362, 1503776, 19376391, 839973, 907711, 2153343, 4072967, 3449053, 5299693, 7172096, 1366382, 2274004,
    415159, 4632865, 1106184, 1728783, 1649680, 1806558, 1628065, 1304225, 1293654, 1503782, 9771568, 841957, 1057226, 2155307, 4073228, 3450905, 5301873, 7143616, 1366771, 2274402,
    501226, 3824541, 474290, 1059715, 1328573, 1836144, 1322957, 1304227, 1294533, 1503810, 9771690, 843228, 1917704, 1610343, 4041631, 3456959, 5327031, 7144041, 1735929, 2277920,
    1137913, 3265592, 531505, 1215677, 1329666, 1878374, 1324313, 1304247, 1295463, 1528663, 11364011, 925005, 1923576, 1820704, 4042721, 3314078, 5419893, 9401988, 2360345, 2169796,
    959895, 2414765, 548400, 1836711, 1331479, 1132126, 1328150, 1305122, 1295874, 1431248, 12386383, 929246, 5447971, 1163827, 4042914, 3389008, 5332864, 7177052, 5460771, 2174138,
    424179, 3420930, 548466, 2008796, 1332371, 1136620, 1635978, 1305124, 1299112, 1379682, 19354624, 1150760, 1836497, 2093513, 4118769, 3392201, 5336065, 9723625, 1761868, 2047053,
    566523, 3362125, 949191, 2008825, 1340287, 999018, 1658304, 1444156, 1299685, 1385545, 15819820, 972083, 1979237, 1114062, 4246463, 3392542, 5427581, 7690977, 2145608, 2450296,
    878863, 3485674, 950969, 1987161, 1692823, 999031, 1661744, 1447020, 1300120, 1309022, 12110518, 975094, 1955794, 1448668, 4434550, 3514277, 5649584, 9081823, 1810485, 7417950,
    878935, 3366398, 952479, 1988286, 1697200, 999159, 1661755, 1447640, 1300149, 1309819, 9744505, 1052021, 827725, 1272949, 4435179, 3321980, 10174565, 15304636, 1853201, 7422048,
    1218197, 3461531, 1039464, 1181593, 1349383, 999190, 1342717, 1448008, 1300340, 1313832, 13959444, 1052887, 828524, 1287372, 4139373, 4085222, 8058141, 14620837, 1855206, 2105717,
    792066, 7499388, 1058781, 2060646, 1354920, 1042021, 1342811, 1604951, 1300842, 1314119, 14839480, 1098360, 912828, 1294743, 7431451, 3524361, 9478051, 7210589, 3571275, 2067048,
    513527, 3772263, 1070915, 1145109, 1717177, 1042837, 1360864, 1902233, 1301180, 1314206, 11558695, 1098439, 959740, 1335778, 3990749, 5506843, 6093679, 9062271, 1512707, 2179421,
    540588, 3899916, 2051562, 875134, 1721311, 1183610, 1361114, 1665911, 1544000, 1314813, 14834430, 1099703, 7874856, 9617730, 3995606, 4092405, 8053789, 9374110, 1491298, 2200420,
    1052054, 3647698, 1959652, 880530, 1671420, 1184924, 1365407, 1367734, 1545183, 1581330, 19643320, 1101887, 7373475, 1419201, 4076502, 8149782, 5987624, 7169151, 1570978, 7425025,
    1264139, 3862012, 1136951, 1043903, 1867897, 1467474, 1736149, 1368304, 1648813, 1616396, 11022572, 1227235, 875577, 1550071, 4028578, 3979184, 6165427, 9366266, 1445742, 3940082,
    1603524, 3976932, 778498, 1092977, 898776, 1062336, 1737471, 1368567, 1649534, 1617028, 11015014, 847921, 917670, 1551653, 4033918, 4218628, 5594945, 9689013, 2036448, 4003001,
    9296466, 3551295, 1000571, 1223897, 899313, 1067144, 1739201, 1368736, 1330260, 1620120, 12896531, 933684, 920264, 895629, 4121950, 4321094, 9465960, 7942771, 1770451, 5369891,
    799827, 4273897, 561130, 1993098, 902609, 1076097, 1706648, 1372926, 1330247, 1620172, 1125321, 934086, 960922, 898181, 4175335, 9554727, 5951977, 7244980, 2150544, 5372825,
    845967, 7543640, 785234, 1993761, 986371, 1076241, 1412377, 1692525, 1330264, 1727661, 1127057, 935224, 1009067, 899096, 4668673, 4413392, 5992368, 7270505, 1858144, 4435022,
    2087102, 4420308, 834233, 1994250, 986486, 1076396, 1811779, 1712892, 1330268, 1389619, 1127148, 936454, 1089925, 940799, 4336163, 11950326, 5995539, 7746778, 1860159, 4435153,
    442613, 4650412, 1143479, 1994720, 1246555, 1079478, 1812283, 1715188, 1330279, 1390532, 1130564, 977804, 2021185, 943394, 2108246, 7542474, 5997742, 7285228, 1948583, 5040497,
    448376, 4727822, 877128, 1850577, 1433021, 1081316, 1785192, 1741351, 1330284, 1778992, 823188, 1106266, 7378355, 944306, 2461659, 4227391, 6071853, 7317872, 1951138, 7060854,
    519625, 4988006, 961936, 2021398, 1408566, 1081364, 1022112, 1742204, 1330286, 1756401, 859949, 1163911, 1968974, 990221, 2466105, 4231710, 5600462, 7325935, 1574615, 4812368,
    519989, 5554197, 1043708, 1935020, 1976938, 1138903, 1023528, 1743785, 1330287, 1872498, 862618, 1165234, 1970666, 1119070, 2466156, 4232129, 5775599, 7755784, 1450122, 4813881,
    522196, 5092841, 1046743, 1892261, 1978136, 1140111, 1024131, 1814639, 1330296, 1396035, 865214, 1165368, 839579, 1119296, 2469617, 9243158, 20849041, 10022629, 1453346, 4335895,
    806748, 5113833, 1096124, 969522, 2042706, 1144977, 1024868, 1818932, 1330309, 1396305, 865196, 1112899, 841615, 1121373, 2142202, 4557043, 6110909, 7335731, 1517228, 2457385,
    807544, 5181544, 791641, 1099967, 2004307, 1008781, 1025541, 1861254, 1330310, 1397600, 905849, 1113993, 843952, 1121374, 2191657, 4650597, 6370252, 7904637, 1519365, 2181472,
    464899, 5418355, 844881, 1100647, 2163949, 1011448, 1105453, 1611055, 1334282, 1405486, 906642, 1114888, 884641, 1121377, 2212682, 4652795, 6085302, 8276951, 1272854, 2286894,
    467488, 5892949, 968236, 2028270, 2178091, 1042998, 1108208, 1821040, 1337368, 21871688, 990742, 1240926, 929102, 1121378, 2216503, 5529403, 6117754, 9313502, 1277534, 2116431,
    478209, 5595086, 969056, 1226511, 2461701, 1047134, 1155284, 1578354, 1337660, 5371940, 991743, 810604, 1146804, 1121379, 2216580, 4426709, 6564632, 7353960, 1494919, 2189471,
    1114875, 5769205, 1097761, 1535491, 2398227, 1047211, 1155312, 1112824, 1349644, 4290320, 1177711, 811588, 974719, 7852491, 7452590, 8128307, 8034865, 8630926, 1281940, 2190278,
    1114915, 6405525, 1103132, 1437486, 2246490, 1090779, 1155596, 1113169, 1351211, 4328274, 1180252, 811575, 1052428, 1168121, 4181573, 8132101, 5976372, 7358309, 1288585, 2243750,
    1198407, 6598300, 1764536, 1662119, 2197084, 1090895, 1157582, 1113858, 1353600, 3990061, 1069306, 811593, 1102918, 1173582, 4181611, 4572280, 6558116, 8622595, 1290486, 2249109,
    1773607, 6625614, 932999, 1366359, 1127149, 1092530, 1157656, 1114508, 1357545, 4623534, 1072053, 811595, 1103563, 1210770, 4181604, 8868299, 7646251, 7361185, 1543349, 7447716,
    942940, 9741988, 976761, 1734869, 1127248, 1218303, 1192840, 1116265, 1357839, 4587192, 1072815, 811596, 1103577, 1826903, 4181661, 4768280, 8026728, 1557085, 1649585, 2196137,
    2420106, 7156902, 978103, 1894167, 1127322, 1218846, 1193663, 1117125, 1379367, 3333950, 1083881, 811598, 2029380, 1828098, 4181725, 4772159, 7121588, 1923294, 1335664, 2196646,
    1397458, 7290255, 2038713, 1894496, 1585239, 1219244, 1194112, 1449030, 1773055, 3481537, 1085846, 811600, 2031211, 7396988, 4181794, 4774459, 6600416, 5444130, 1355503, 2218451,
    7402311, 7904671, 1769404, 1938171, 1586522, 1221287, 1232518, 1450178, 1773050, 3482404, 1134101, 811601, 2031217, 1430691, 4343463, 4977385, 6746330, 5447462, 1775020, 2218507,
    2265534, 495545, 805407, 1939002, 1588137, 1253160, 1233619, 1452719, 1747258, 3445565, 1134279, 811603, 1228734, 1384075, 4444474, 4980600, 6389609, 1878955, 1905803, 2293148,
    2311565, 582332, 806052, 1941247, 1588654, 1253336, 1233756, 1454131, 1747805, 10259369, 825346, 811604, 1228714, 1319017, 4483153, 5075656, 7127430, 2355024, 1905797, 5484403,
    2441260, 1041244, 578117, 1809613, 1462561, 1254901, 1235173, 1521578, 1751474, 3917442, 829060, 811607, 7865378, 7817703, 4483660, 4747870, 6721414, 2356986, 1908650, 4343013,
    2314989, 1075190, 1112557, 1853418, 1462642, 1484765, 1235185, 1197632, 1552122, 5376265, 829873, 811581, 7865410, 1386622, 4672030, 4776751, 6721959, 2303566, 1747812, 4444798,
    2274514, 498493, 1112558, 1789016, 990801, 1012707, 1236736, 1201486, 990399, 5378827, 869932, 811611, 1257833, 1392960, 4676335, 4782773, 6722072, 2305338, 2157111, 4445058,
    2277645, 498650, 1114376, 2079894, 991704, 1014456, 1237503, 1203316, 1027623, 5527375, 909954, 815897, 1626689, 2429610, 2227191, 4819603, 6722298, 2306371, 1867037, 4372853,
    2125117, 1077723, 1288881, 1946947, 992953, 1017751, 1511199, 1239493, 1027808, 11470770, 912333, 852441, 1325267, 2429932, 2294991, 4913127, 6722314, 2012314, 1504340, 4677148,
    3791124, 837733, 1865254, 1158843, 993016, 1047951, 1511583, 1239807, 1028612, 4467831, 956661, 855531, 1656675, 2263913, 3607919, 5550849, 6394405, 7367910, 1524168, 7457373,
    3983692, 1043588, 1868397, 1192963, 995513, 1048328, 1512458, 1241000, 1028762, 4232884, 957580, 857181, 8966449, 7825341, 3614721, 8851610, 6610655, 1985179, 1382661, 2225089,
    4035448, 844680, 811803, 1511704, 1034770, 1048762, 1515334, 1242702, 1032441, 10559756, 1000232, 857287, 1735087, 2273120, 5493526, 4763718, 6701078, 5452376, 1385015, 2229100,
    4041438, 845112, 815103, 1604555, 1036624, 1053450, 1516155, 1243955, 1033243, 4799247, 1067652, 896244, 1413230, 2373939, 5057314, 4766366, 6701125, 5452738, 1310908, 2295676,
    4027941, 1050281, 983581, 1899757, 1037234, 1098410, 1264606, 1273864, 1455960, 4861714, 1067986, 896306, 1417133, 7409061, 4266916, 4832624, 6701379, 5453569, 2420102, 2296776,
    4050150, 1051581, 985409, 2037263, 1037524, 1226557, 1265974, 1275517, 1122555, 4861728, 1077317, 897018, 1852497, 2389197, 4267006, 14546866, 6701480, 2015100, 8240161, 3243216,
    4126011, 1019933, 989084, 1665171, 1038722, 1259253, 1267189, 1275574, 1123209, 5566367, 1079130, 943345, 1785953, 7827332, 4587780, 5087156, 6701752, 1881831, 1389102, 3244794,
    5481364, 476325, 1031324, 1710991, 1039554, 1259279, 1269757, 1496844, 1169865, 5122061, 831636, 984744, 2080621, 7837520, 4313728, 4925629, 6702033, 1883400, 1914025, 3818642,
    4169838, 575922, 1874661, 1768348, 1039679, 1260911, 1269847, 1279894, 1170778, 5217510, 831707, 985677, 849868, 7838491, 3333103, 5401287, 10121205, 1924491, 1395754, 3246037,
    2457451, 487988, 8948681, 2150644, 1557260, 1263752, 1270106, 1280342, 1171540, 9828959, 831700, 1117885, 931572, 2445300, 8553584, 5275537, 6811426, 1478500, 1409033, 3248564,
    5054992, 5389975, 5332536, 9062982, 1843496, 1824779, 1978000, 3519222, 1466573, 1132464, 1884924, 2021947, 1531657, 1941458, 1105333, 1901161, 1789209, 1520924, 1348779, 1868620,
    4377962, 5390825, 5333842, 7720566, 2015489, 1576363, 2098883, 4084189, 904982, 1133888, 1924570, 2023059, 1531660, 1760326, 1106292, 1901163, 1791160, 1197621, 1349345, 1548955,
    4267127, 5393450, 5336637, 7217572, 2018605, 1578113, 1999891, 5506977, 906830, 1136456, 1924975, 2023548, 1531642, 1411807, 1107141, 1902498, 1792920, 1199128, 1349784, 1552139,
    4586980, 4718094, 7596921, 7951665, 1881890, 1117039, 2005082, 3846098, 908466, 1137044, 1925603, 1930250, 1531669, 1411810, 1107199, 1905011, 1794092, 1201448, 1349792, 858187,
    4589218, 4772537, 5427902, 7264928, 1884688, 1448990, 2047477, 4019085, 909578, 825617, 831486, 1932722, 1532581, 1411812, 1107534, 1904994, 1949664, 1238848, 1351402, 1702887,
    4495718, 4982261, 5686207, 7265037, 1926062, 1520176, 2048596, 3898807, 951861, 826682, 831475, 1934279, 1532616, 1411825, 1107718, 1905016, 1949716, 1242910, 1352441, 1704082,
    4630522, 5074004, 5686660, 7298243, 876810, 1239856, 2050332, 3776828, 992753, 826703, 831476, 1934422, 1532620, 1411828, 1156985, 1905042, 1949973, 1242977, 1355078, 897190,
    4631748, 5184542, 5845085, 7300837, 1008097, 1493003, 2451751, 3911477, 994617, 826738, 831479, 1935426, 1532605, 1412280, 1158019, 1905050, 1952513, 1243427, 1355437, 897192,
    2404010, 5243072, 5891133, 7730270, 1009547, 1281825, 2102827, 3553671, 995277, 826708, 831489, 1935695, 1560598, 1414756, 1159340, 1631623, 1610976, 1273513, 1355460, 897198,
    3258115, 12823692, 13053690, 7947020, 1217716, 1283837, 2064197, 3555172, 995303, 826747, 835466, 1889649, 1560715, 1414896, 1192864, 1631610, 1612243, 1273809, 1355876, 897199,
    3258632, 5076602, 5653316, 9051129, 1220427, 1290412, 2175576, 4220060, 1036883, 826714, 1144350, 1889778, 1562136, 1415467, 1235364, 1631635, 1612809, 1276734, 1355961, 897201,
    2410927, 5104428, 5655487, 7301829, 1993219, 1546400, 2176605, 4281830, 1041260, 826716, 1145277, 1892053, 1563483, 1809065, 1512340, 1631645, 1820522, 1277091, 1357719, 897203,
    3262186, 5545524, 5693741, 7244426, 2234327, 1697909, 2176832, 4413276, 1732542, 827440, 875666, 1892171, 1563852, 1811798, 1513180, 1631681, 1821041, 1277318, 1359637, 900949,
    3340628, 5545676, 7077311, 16703010, 1845726, 1347729, 2177169, 4639223, 1733165, 910553, 875667, 1892831, 1436803, 1812162, 1515420, 1631672, 1823767, 1277305, 1359716, 939007,
    3411287, 7562277, 7077513, 7932715, 2022364, 1671310, 2177688, 4724933, 1734441, 916148, 917069, 2069889, 1437370, 1812206, 1266349, 1631691, 1824391, 1277323, 1359835, 939285,
    2414457, 8855946, 5899908, 7257022, 2023395, 1774700, 2179089, 4727556, 1558702, 916988, 917888, 2070682, 1438377, 1852213, 1266397, 1631718, 1824760, 1493242, 1359820, 940639,
    2414529, 4787862, 5809830, 7321136, 2024243, 2157964, 2281925, 4826677, 1559447, 955708, 920122, 2072499, 1625040, 1853934, 1269926, 1631723, 1824754, 1496094, 1359822, 940741,
    3269051, 4821717, 5811914, 7923425, 1931619, 2160348, 2283654, 5556516, 1174777, 955954, 920148, 2072632, 1625320, 1783375, 1270868, 1631734, 1824777, 1498218, 1359840, 944128,
    3272779, 4913589, 5706561, 7332304, 2069770, 1420740, 2283707, 5345804, 1179582, 955968, 920150, 2073566, 1598372, 1784989, 1486073, 1633102, 1824899, 1279858, 1719834, 944997,
    13628376, 5550093, 5819833, 9656002, 844567, 1422830, 4120313, 5347083, 1180767, 955996, 920171, 2073695, 1601052, 1789048, 1486120, 1662350, 1824911, 1282438, 1720006, 983988,
    3419661, 5551768, 6294988, 15231432, 885729, 1548394, 5370046, 5353787, 1054824, 956964, 920846, 1967912, 1601045, 1789096, 1486482, 1664325, 1824892, 1282488, 1720562, 984101,
    5503130, 5554928, 8054196, 7760620, 1013287, 1549583, 5370088, 5418448, 1055824, 959405, 963292, 1481881, 1601046, 1789090, 1486623, 1367109, 1824894, 1284886, 1721309, 984409,
    3430756, 5555760, 5761134, 7763694, 1015159, 1552877, 4294156, 5333252, 1055814, 1985507, 963354, 1483216, 1601072, 1789109, 1486604, 1367424, 1824920, 1288306, 1374040, 986731,
    3284250, 7569641, 5767966, 7340590, 1015252, 856536, 4076761, 5338827, 1056671, 999019, 966138, 1484599, 1603534, 1789133, 1487720, 1370347, 1824926, 1288424, 1378523, 989209,
    3287318, 4766697, 5953794, 7770448, 1047881, 938917, 4814390, 7600017, 1059320, 1000257, 966288, 838667, 1323962, 1789152, 1489952, 1710980, 1824942, 1288583, 1773660, 1027926,
    3363676, 4794448, 6073506, 7905107, 2029759, 1455624, 2111032, 5424570, 1071386, 1003738, 1005251, 838654, 1324006, 1789180, 1491257, 1710984, 1824956, 1290244, 1906050, 1027941,
    3363864, 4863367, 5598041, 8643578, 1258950, 1455780, 2206370, 5428011, 1073158, 1004026, 1006442, 840773, 1324320, 1789163, 1491261, 1710992, 1160198, 1290429, 1907462, 1028062,
    3363920, 4878027, 5837018, 9644507, 1263806, 1457892, 2209533, 5637088, 1074201, 1041896, 1010793, 841479, 1324322, 2078384, 1491262, 1710995, 1166768, 1290805, 1909682, 1029294,
    3367250, 4891434, 6005020, 7893945, 1534044, 1460613, 2398409, 5701414, 1075178, 1041901, 1011041, 844538, 1324326, 2078651, 1491277, 1711018, 1166774, 1291229, 1747184, 1030367,
    3370866, 4971213, 6077044, 9304571, 1563294, 1118267, 2116578, 5981398, 1212792, 1181646, 1011875, 844969, 1324349, 2078676, 1491310, 1711019, 1576065, 1293026, 1748608, 1033757,
    3371281, 5096225, 5784134, 7357755, 1441431, 1118809, 2139482, 6021238, 1216183, 1186597, 1091754, 844953, 1324331, 2078661, 1491312, 1711029, 1576953, 1294648, 1748689, 1033760,
    3494023, 5112213, 7635058, 8987966, 1626938, 1122611, 7443351, 5769738, 1083221, 1186741, 1094712, 926914, 1324354, 2078664, 1491315, 1711052, 1577608, 1294670, 1748706, 1454670,
    4384491, 5113747, 6007627, 1128874, 7385273, 1650813, 2191800, 5785043, 1084388, 1186866, 1095558, 929806, 1324343, 2078686, 1491316, 1711055, 1577647, 1294671, 1748727, 1455356,
    3449256, 5130664, 6007999, 820472, 1325937, 1654434, 2243467, 6534338, 1084846, 1468463, 1095688, 930995, 1326078, 2078688, 1491722, 1711058, 1577811, 1294651, 1748729, 1457181,
    3461523, 7576460, 9454582, 865177, 1326764, 1500167, 2343563, 6667177, 1084926, 1470350, 1096520, 1150902, 1326174, 2078670, 1491943, 1711069, 1578210, 1294658, 1750619, 1458318,
    3384111, 5274046, 6532271, 949719, 1657250, 1503238, 2249694, 6873842, 1085525, 1471045, 1190381, 969649, 1658234, 2078694, 1567484, 1746672, 1578526, 1294659, 1751278, 1458829,
    4393720, 5276060, 6054431, 991621, 1346747, 1504061, 2254913, 7126511, 1087215, 1062521, 1190621, 971725, 1658482, 2078851, 1567503, 1746716, 2088013, 1294662, 1751482, 1118388,
    3313886, 8839972, 6056511, 997463, 1366643, 1430503, 2197026, 6837145, 1087992, 1065262, 1191536, 974357, 1658680, 2080015, 1567507, 1746718, 2088327, 1294665, 1751926, 1118976,
    7500207, 5307466, 6056907, 1059327, 2359869, 1385444, 2223704, 7014938, 1088020, 1065327, 1474239, 974909, 1341580, 2080022, 1567509, 1746721, 2088377, 1295439, 2156767, 1121907,
    3525159, 5307854, 6538432, 1215911, 1707205, 1319136, 2382993, 7172681, 1088055, 1067190, 1474721, 1014448, 1345148, 847847, 1567537, 1746724, 2089615, 1298903, 2156919, 1121971,
    3535896, 13582210, 6548120, 1923522, 5457117, 2422227, 2293549, 7686036, 1088289, 1067311, 1479224, 1014565, 1346380, 849669, 1567552, 1746730, 2090911, 1299006, 2157561, 1123165,
    8156169, 14741102, 6557962, 1834622, 1939431, 1724789, 4183556, 7181035, 1917771, 1068103, 1219156, 1015593, 1346946, 849938, 1568243, 1746738, 2093274, 1300387, 2157620, 1123679,
    5513070, 11906159, 13979248, 1835052, 1759140, 1389460, 2256521, 7231252, 1808006, 1068171, 1219272, 1048287, 1363688, 934257, 1569650, 1746711, 2093486, 1300869, 2160166, 1124649,
    5514627, 5165563, 6610062, 1837914, 1764577, 1391511, 2261253, 7234038, 1833964, 1076922, 1219340, 1097519, 1364081, 934924, 1570923, 1746743, 2093725, 1301362, 2161584, 1650988,
    5514912, 7584254, 6878432, 2354789, 2149310, 1780838, 2295424, 7287876, 1835192, 1077043, 1221647, 1097976, 1364688, 938017, 1537809, 1746755, 1112842, 1301540, 2161884, 1651039,
    3849238, 5224751, 7656848, 2355195, 1412486, 1872211, 3245302, 7244787, 1878504, 1077393, 1222143, 1098282, 1365137, 976124, 1642522, 1768142, 1114168, 1546269, 1422500, 1651778,
    7524732, 5281273, 6444361, 2301398, 1809288, 1409067, 3249034, 7761101, 2353989, 1077708, 1222304, 1102001, 1365139, 976125, 1305046, 1770239, 1115194, 1644369, 1424478, 1655223,
    5374860, 5347559, 6834867, 2051897, 2078889, 1800443, 4587033, 7770435, 2354143, 1080151, 1223888, 1102823, 1365156, 976129, 1305470, 1815093, 1116176, 1644494, 1427235, 1655418,
    5375457, 5350255, 6885697, 2052531, 1942023, 2365735, 4678929, 7354122, 2356619, 1080197, 1251408, 1226369, 1365157, 976293, 1305783, 1816596, 1116607, 1647550, 1427468, 1655942,
    5375526, 7589377, 6398483, 2052534, 1942044, 2370772, 4540691, 7795060, 2301233, 1960061, 1253743, 1226608, 1365161, 978171, 1305829, 1819295, 1450411, 1647795, 1427503, 1173301,
    5379507, 5231549, 6492041, 2052573, 1109266, 2266143, 2407918, 1125446, 2303027, 1966051, 1254271, 1227193, 1365163, 979854, 1306565, 1398957, 1452441, 1649447, 1428150, 1173486,
    5527659, 5357992, 6662276, 2010089, 1153194, 2311433, 3264411, 1127312, 2303063, 1840266, 1255319, 1257882, 1739952, 1942271, 1306675, 1402835, 1454096, 1328294, 1428171, 1204122,
    5528704, 5319874, 6764615, 2010980, 1156471, 2311447, 5503071, 1127795, 2304583, 1842239, 1256231, 1259040, 1681228, 1944852, 1306677, 1402951, 1454099, 1329310, 1428175, 1207855,
    4597649, 7592238, 6894053, 1978643, 1194631, 2311471, 3425135, 1129922, 2306956, 1844377, 1256565, 1259093, 1705077, 1946368, 1306689, 1403509, 1454083, 1330543, 1428177, 1827965,
    7543152, 7596645, 6626316, 1956621, 1571815, 2311456, 3430564, 1585295, 2051953, 2015383, 1991547, 1260364, 1705269, 1947910, 1306679, 1404415, 1454127, 1334741, 1428161, 1828903,
    4226189, 5175349, 6955577, 1957460, 1538234, 2311482, 3359008, 1586547, 2052513, 2018019, 1991990, 1260889, 1707538, 1020365, 1307639, 2153034, 1454161, 1340268, 1862915, 1245793,
    4421588, 5176185, 6998431, 824715, 1308599, 2312097, 3432285, 1586611, 2052591, 2020101, 1992613, 1261481, 1893642, 1022124, 1308681, 2153150, 1454165, 1340417, 1867152, 1247744,
    4559062, 5183301, 7014022, 825807, 1445915, 2312169, 3954145, 1586722, 2052658, 2058601, 1993485, 1261975, 1896882, 1024719, 1308881, 2155220, 1454186, 1340559, 1867400, 1248253,
    4645662, 5241315, 7685227, 828890, 1630283, 2268848, 3367018, 1586736, 2009058, 2058920, 2233163, 1262049, 1897549, 1025187, 1444219, 2155292, 1454188, 1340613, 1868522, 1249269,
    13377055, 5296591, 7222958, 830716, 1370309, 2270627, 3499657, 1588234, 2011011, 2060709, 2233495, 1262072, 1897640, 1026706, 1444769, 1858404, 1454392, 1340760, 1868524, 1249654,
    4725939, 5300091, 7227754, 1000204, 1692494, 2318212, 4383954, 1589853, 2013663, 2062897, 2233647, 1262374, 1898122, 2083023, 1445533, 1861759, 1517137, 1340835, 1868529, 1500152,
    7548782, 5302522, 7690497, 1001395, 1713984, 2318232, 3374111, 1461500, 1983953, 2063058, 2234441, 1506704, 1937831, 2085047, 1445639, 1861920, 1517283, 1340869, 1868532, 1501051,
    9865852, 8082730, 7140885, 1467314, 1815061, 2389407, 3455817, 1462630, 1955930, 1882984, 2234957, 1508461, 1939340, 2085630, 1446266, 1789194, 1517399, 1694911, 1868559, 1523311,
    4474950, 8084040, 7707969, 1961453, 2152697, 1973866, 3670586, 1463732, 1958688, 1882989, 1844960, 1508884, 1940904, 2087191, 1447333, 1789196, 1518032, 1347666, 1868584, 1525005,
    4571251, 5327741, 7294210, 1962035, 1794146, 1974000, 3389418, 1463859, 1592132, 1884769, 1845736, 1509697, 1941084, 2087871, 1447574, 1789199, 1518503, 1348311, 1868597, 1525335,
    5389941, 5330088, 7210091, 1842116, 1950183, 1975137, 3465958, 1464628, 1592732, 1884810, 2021850, 1531655, 1941162, 1103842, 1603684, 1789202, 1519621, 1348543, 1868599, 1526154,
    1526157, 1869270, 2001051, 2456970, 4184336, 5103392, 7224675, 1250952, 3308332, 1264654, 5381756, 1938637, 1454713, 2255551, 6699977, 3455889, 2293445, 1435829, 1354787, 1817622,
    1526145, 1872752, 2001061, 2457165, 5048786, 4867667, 9055500, 1435458, 8494438, 1270756, 5216454, 1760379, 1455683, 2256415, 9755167, 3456109, 3342008, 1435811, 1377297, 1695179,
    1526159, 1396366, 2001066, 2457261, 9939525, 5550138, 7766057, 1579828, 5825873, 1639263, 5224434, 2145624, 1460161, 2259245, 9123758, 3456955, 3345240, 1435837, 1377323, 1580374,
    1526149, 1397125, 2001078, 2457793, 2226132, 4832781, 1464647, 1581162, 9082789, 1446337, 7589995, 1414060, 1650515, 2261145, 6404799, 4391540, 3347885, 1435843, 1379019, 2147991,
    1527936, 1405366, 2001086, 2460275, 2226193, 4876577, 1466652, 1388310, 7786127, 1662362, 5233414, 1854622, 1501539, 2261397, 6625042, 3515215, 3439913, 1435821, 1498527, 1567652,
    1433143, 1405653, 2001087, 2205986, 2229996, 5402538, 1036788, 1388410, 2233310, 1367675, 10191878, 1788348, 1430587, 2294932, 6961455, 4086618, 3384536, 1800392, 1525240, 2421631,
    1433164, 1405648, 2001696, 2206053, 2255187, 5404197, 1557840, 1404888, 1809035, 1371789, 5242195, 2079721, 1431930, 2296801, 10100649, 4019364, 3321189, 2272900, 1431643, 2178452,
    1434622, 1405669, 2119300, 2206465, 2258271, 5158424, 1179015, 1406262, 2085361, 1816191, 11895378, 2081333, 1432038, 8185715, 7041781, 3534876, 4084568, 1977830, 1579624, 4070537,
    1435525, 1405664, 2119929, 2206547, 2259287, 5224400, 1179511, 2315766, 1444793, 1401904, 5844545, 1942205, 1381686, 3622478, 7156218, 3849305, 3639063, 2050703, 1616844, 4118865,
    1435927, 1405666, 2121167, 2207302, 2260340, 5314513, 1059277, 2109884, 1604515, 2154399, 5432691, 1944340, 1309115, 4266590, 7208015, 3918252, 3528005, 1959884, 1621866, 4289934,
    1379947, 1405674, 2123776, 2208669, 2260903, 5314514, 1087079, 2258097, 1330325, 2155304, 5825879, 1946963, 1314700, 4587211, 7217401, 3977996, 3930401, 2023280, 1758043, 4295358,
    1379950, 1405692, 2039992, 2210011, 2295210, 5168707, 1088054, 993297, 1313101, 1792280, 8769955, 7385965, 1319130, 4497278, 7268552, 3978603, 4778796, 1735205, 1408937, 4142835,
    1379964, 1405679, 2042703, 2182564, 2295327, 10190900, 1919757, 1212298, 1313233, 1792506, 6999155, 1511180, 1617043, 13638385, 16926695, 4218184, 15908861, 2155709, 1409249, 4049809,
    1379953, 1405682, 2170786, 2183116, 2295348, 5235254, 1876117, 1087624, 1316873, 1112347, 9074571, 1515429, 1618301, 8551976, 15997823, 9246437, 5283691, 1874781, 1410435, 4125711,
    1379955, 1405747, 2173996, 2184300, 2296554, 5326116, 2052166, 1879348, 1318094, 1114253, 11064031, 1568134, 1621771, 3868367, 7764667, 8520483, 5419908, 4488482, 2269636, 4297209,
    1381433, 1405748, 2126487, 2184510, 2298176, 5327258, 999087, 1080864, 2175802, 1454439, 7049914, 1640332, 1397188, 3417007, 7769335, 4502119, 5832388, 4488518, 2047117, 2207179,
    1381536, 1405753, 2002715, 2186366, 3812609, 18371601, 1063283, 1227653, 3414181, 1204037, 7946611, 1446148, 1409001, 4199094, 1923390, 4555132, 15780989, 4188171, 2398538, 4446575,
    1382944, 1405764, 2003424, 2398927, 3620244, 5335686, 2020226, 1510615, 3272917, 1275175, 12034880, 1446339, 7842913, 3289070, 1957209, 4637624, 7712837, 3444291, 3384671, 4185349,
    1309858, 1405775, 2004023, 2399717, 5054384, 5426580, 1091776, 1450232, 3364825, 1275298, 7928606, 2034205, 2265670, 3359574, 2059245, 4470516, 7714196, 4470916, 1891675, 4630364,
    1310885, 1405809, 2005644, 2288554, 2402702, 16829020, 1191289, 1300718, 3831510, 1277178, 7284753, 1665362, 2267707, 3364223, 2085098, 4686503, 7720083, 7121542, 1322880, 3359918,
    1579340, 1406460, 2006162, 2288646, 2404384, 16830572, 1217971, 1314338, 3521108, 1283504, 7756032, 1367701, 7823307, 3486109, 3572611, 4427187, 9635344, 1565355, 1354696, 3445626,
    1580013, 1408340, 2045872, 2237495, 3829504, 5842347, 1253270, 1070753, 3915875, 1293268, 7337182, 1370242, 2390042, 3491149, 1371430, 4573320, 8625448, 1287684, 1360375, 4392717,
    1580050, 1408342, 2045992, 2237877, 3332902, 5890482, 1017156, 2357624, 4653102, 1294409, 1732061, 1370369, 2447001, 3501405, 1757732, 4768723, 1878224, 1296171, 1321546, 3786224,
    1583774, 1408343, 2451483, 2237920, 3333535, 6079885, 1017901, 7374321, 1264345, 1296222, 1554735, 1370542, 2274111, 4393110, 2443359, 5242771, 1957021, 1319405, 2390732, 5379934,
    1584256, 1408706, 2102714, 2239266, 2412619, 9774542, 1019543, 1192477, 1264381, 1302821, 1557378, 1370841, 2279152, 3519510, 2283650, 4870502, 1883312, 1391419, 7872455, 4321636,
    1315898, 1410765, 2104851, 2239433, 3411506, 7644559, 1097510, 1223898, 1267269, 1332308, 1918150, 1692416, 2119336, 3529683, 2238233, 4913796, 1884806, 3335168, 1713536, 4323175,
    1316632, 1801464, 2105951, 2240219, 2414715, 7653156, 1101658, 1253945, 1160991, 1334951, 1803763, 1742567, 2172043, 3960075, 2192994, 4916018, 1222163, 1586824, 1767272, 4226953,
    1316787, 2431367, 2105972, 2242061, 2418372, 9436319, 1259182, 1256616, 1275391, 1336907, 1877215, 1742668, 2127786, 5515031, 3312993, 4928946, 1994401, 1586889, 1519792, 4893538,
    1316790, 2432082, 2106032, 2117623, 3267950, 6441219, 1510342, 2234567, 1288098, 1635144, 1878619, 1743682, 2129075, 3555030, 3912613, 4969157, 1844781, 1589576, 1374696, 4787672,
    1316793, 2370982, 2106120, 2463963, 3282067, 6806698, 1532315, 2024252, 1340130, 1351221, 2355191, 1398770, 2002773, 3555174, 5528684, 5092960, 1483042, 1733696, 7400227, 4767567,
    1316796, 2263814, 2163002, 2141615, 3425446, 16076176, 1563391, 1364453, 1250192, 1359098, 2009452, 1403331, 2050397, 4282707, 4228956, 5272767, 1224765, 1477285, 7400230, 5398031,
    1316798, 2265539, 2163008, 2190008, 3444885, 6405206, 1626714, 1415643, 1406265, 1359955, 1595404, 1403452, 2450024, 5376543, 5334877, 5334054, 1226093, 1479458, 1915765, 1586323,
    1316776, 2265944, 2163011, 2190112, 3494078, 6622611, 1341691, 1265106, 1463096, 10315432, 1467286, 1404321, 7417856, 5378318, 1726717, 5688313, 1228636, 1930247, 2279380, 1462273,
    1316778, 2387952, 2163014, 2190541, 3494066, 7000724, 1342407, 1199782, 1558994, 1722041, 1965104, 2155776, 2067749, 4225102, 2356799, 5695227, 1228655, 1531792, 2000980, 1464624,
    1316804, 2308498, 2163023, 2190691, 3450757, 7211212, 1362220, 1908183, 1179092, 1374678, 2058828, 1611085, 2176722, 4645054, 2357267, 5762990, 1438403, 1533336, 2039786, 1732801,
    1316852, 2308633, 2163028, 2190699, 3450759, 10020376, 1364921, 1248361, 1086220, 1374702, 2058995, 1612767, 3934060, 4233699, 2021963, 5836567, 1622100, 1533501, 2102730, 1919935,
    1318483, 2312190, 2163035, 2190705, 3450794, 12619646, 976881, 2273960, 1086762, 1379366, 2059258, 1576919, 3935075, 8867130, 7797392, 8416694, 1622361, 1533683, 7464703, 1919912,
    1320680, 2313329, 2163041, 2190715, 3450818, 10000129, 1103758, 2274593, 2356669, 1747310, 2061492, 2091040, 4133645, 4892223, 7798450, 6539332, 1623107, 1441713, 7484707, 1978365,
    1321211, 2270731, 2163045, 2190727, 4392133, 2233405, 1193670, 1999985, 1136755, 1423945, 1884355, 1520089, 5369018, 4746572, 1897632, 6540271, 1635780, 1341655, 4386612, 1468954,
    1321206, 2273024, 2163107, 2190735, 3314475, 2030801, 1512735, 2200996, 5456104, 1119566, 1927338, 1520854, 5369015, 4747300, 1939784, 6601876, 1705028, 1341695, 3700879, 1925119,
    1321252, 2273079, 2163109, 2190746, 3314509, 1938078, 1303778, 2110190, 1467363, 1122273, 1990845, 1493084, 4327807, 4780184, 1640416, 6948813, 1783345, 1345533, 4274249, 1925102,
    1616882, 2314751, 2163110, 2190758, 3314532, 1906037, 1444174, 2252277, 1080619, 1652079, 2232970, 1284858, 3947855, 4988542, 1832019, 6800889, 1515941, 1346780, 16403775, 1845802,
    1620298, 2315376, 2164630, 2190766, 3314534, 2161349, 1367737, 2378269, 2019503, 1206559, 1849754, 1284893, 3996051, 5545549, 8241971, 7974032, 1308878, 1347425, 5848084, 2023994,
    1676368, 2372171, 2164673, 2190770, 3314537, 4330814, 1710718, 2416187, 2019530, 1246635, 2021994, 1284987, 4076773, 5546760, 3599168, 7978420, 1743941, 1347442, 5656001, 1481044,
    1676572, 2391918, 2165138, 2190771, 3314567, 4125970, 1114045, 3396436, 1883195, 1314818, 1892683, 1285019, 2133644, 4753792, 3600377, 7713443, 1744869, 1736166, 5900134, 1735489,
    1679144, 2446889, 2064502, 2212340, 3314576, 4335187, 1240740, 4094443, 1145118, 1620730, 8972439, 1285029, 2460181, 5561357, 2178253, 7290691, 1815502, 2147097, 5983051, 2362339,
    2422066, 1973408, 2064992, 2212479, 3315800, 7458059, 1242758, 4557417, 1096202, 2421800, 8972570, 1286930, 2207371, 5397935, 4071990, 8684802, 1820668, 1413983, 22034997, 2362766,
    1725592, 1973940, 2067117, 2214215, 3388052, 2412996, 1272653, 4699367, 1220337, 2421827, 8972677, 1289279, 2181946, 5398387, 5472357, 8684964, 1518401, 1415056, 6719865, 1683426,
    1725770, 2096523, 2067318, 2214251, 3392491, 3291179, 1492859, 5333223, 1222926, 2421830, 8972876, 1292260, 2183153, 5218085, 4241448, 8685671, 1519463, 1809408, 6965953, 2147989,
    1726076, 2099159, 2175322, 2214453, 3462412, 3292498, 1283206, 6811787, 1254260, 1395891, 8973018, 1292433, 2287174, 5313365, 4168151, 7315205, 1240410, 1511675, 7173425, 1855609,
    1726876, 2277382, 2175461, 2217931, 4084665, 3449227, 1347859, 7248669, 1966263, 5028028, 8973163, 1299711, 2237421, 5347495, 4289498, 7258102, 1240411, 1515414, 7211287, 2081914,
    1726879, 2277402, 2176541, 2218042, 3960654, 3519708, 1348537, 7899144, 1146746, 5474166, 2069858, 1300465, 2237457, 5354151, 2238682, 2051797, 1287019, 1537777, 7952016, 1511340,
    1389026, 2277434, 2179060, 2243773, 3918136, 3973029, 1349299, 1228696, 1148978, 2194628, 1483943, 1302903, 2237828, 5331250, 2240353, 2147590, 1293690, 1447421, 7939939, 1566535,
    1390283, 2277447, 2284222, 2248219, 3855528, 3978537, 1349440, 1192640, 1149226, 4182122, 1532328, 1329742, 2239867, 5687246, 2243950, 1853006, 1334205, 1447609, 1835947, 1902845,
    1778606, 2277452, 2200242, 2343600, 4323309, 8137977, 1357682, 1240676, 1101059, 2261273, 1560602, 8956533, 2138450, 5894545, 5487853, 1511033, 1339527, 1367438, 1904233, 1862285,
    1778849, 2277476, 2200882, 2249162, 4468121, 5390575, 1357923, 1358495, 1103529, 2409393, 1437540, 1374069, 2192923, 5894777, 4344931, 1369128, 1696832, 1576740, 1765213, 1610920,
    1781102, 2277482, 5475875, 2196923, 5382792, 5251173, 1379220, 1421371, 1224325, 3414698, 1624812, 1374440, 7068612, 5754377, 4624611, 1371334, 1773210, 1543801, 1823214, 1519623,
    1782507, 2277491, 4134476, 2197838, 9548234, 5357645, 1748987, 1501850, 1257851, 3500466, 1323133, 1907360, 2212625, 9163749, 4590652, 1276821, 1455481, 1339298, 2394831, 1542809,
    1912238, 2277495, 5367598, 2198192, 4235861, 7591996, 1422455, 1098549, 1532262, 7517387, 1325905, 1908792, 8930743, 5947899, 3825389, 1541772, 1831754, 1339393, 2254211, 1644476,
    1915802, 2277628, 4813224, 2198958, 4517781, 5329728, 984759, 1443474, 1563301, 5513472, 1326137, 2156877, 2246255, 5987978, 3264379, 2161503, 1831870, 1339485, 4455773, 1717375,
    1915963, 2277623, 4128203, 2220551, 4519064, 11635169, 988471, 1329517, 1437599, 7521305, 1326711, 1421342, 2194297, 6160711, 3338450, 1678259, 1244538, 1339498, 3372780, 1460795,
    1756167, 2277652, 4342517, 2221887, 4570105, 7117478, 1120986, 1329534, 1344655, 3783885, 1326903, 1422947, 2194582, 6006790, 3411973, 1408516, 1244608, 1339505, 3301447, 1498370,
    1756486, 2277656, 2110220, 2222117, 4892645, 6499872, 1122051, 2265860, 1364748, 3784067, 1735016, 1429001, 2223851, 6090231, 2414359, 4104409, 1432589, 1351312, 3929303, 1619551,
    1756818, 1998322, 2111290, 2223479, 4981060, 6741553, 1124460, 2277221, 5460689, 7522915, 2359981, 1429089, 2380641, 6429740, 3287540, 4033040, 1433117, 1351334, 4506345, 2420136,
    1757839, 2001040, 2112160, 2291416, 4746682, 9435657, 1172470, 2277807, 2145727, 5378651, 2360052, 1867916, 2291508, 7122120, 3489737, 2242508, 1435263, 1351368, 1637856, 2421740,
    1758014, 2001048, 2134261, 2292017, 4989990, 7685096, 1244748, 3268144, 1809568, 4643603, 5459279, 1703587, 4185007, 9444046, 3307719, 2216483, 1435806, 1351352, 1712881, 1977581,
    2094929, 1969326, 2107419, 20531525, 7929425, 3513279, 1807240, 1770031, 1863309, 7988068, 2050121, 2081944, 2119183, 2107050, 2217215, 5630947, 4814561, 4415233, 7669272, 8431554,
    2119188, 1969318, 2110395, 9867015, 10029030, 3671463, 1807300, 1770060, 1863371, 7975344, 2397989, 2081952, 2119265, 2107095, 2243414, 5987707, 4128565, 4415421, 13499241, 7119401,
    2123571, 1970227, 2111179, 4733053, 7756316, 3960353, 1807675, 1770110, 1864576, 14813584, 3455234, 2081950, 2119310, 2109425, 2243967, 6072276, 2135218, 4646170, 6968313, 9741895,
    2043153, 1970358, 2462437, 4773174, 12020375, 3911096, 1807813, 1770147, 1830947, 12318273, 4092547, 2082312, 2119373, 2109428, 2249353, 6896155, 2135356, 4427775, 13489488, 7933532,
    2171832, 1970519, 2207529, 4978835, 1762270, 4410424, 1808001, 1770151, 1831575, 12319489, 5393474, 2082315, 2120493, 2109473, 2193936, 7984380, 2206362, 4481807, 6995942, 7831018,
    2451061, 1971637, 2182844, 4987645, 1791446, 4726214, 1808041, 1770234, 1832243, 17366581, 4780019, 2082318, 2120528, 2112317, 2194298, 7952601, 2184586, 4518083, 7005588, 4698096,
    2106083, 1971769, 2185876, 4819654, 2308459, 4567417, 1833021, 1770254, 1777651, 7735044, 7952434, 2084976, 2121405, 2133909, 2194488, 7244314, 8931673, 5391440, 7684796, 6998212,
    2180570, 7802231, 2321932, 21553581, 2315480, 4573221, 1833245, 1770270, 1781278, 7246985, 2356970, 2085144, 2121559, 2135032, 2194501, 2301391, 2242289, 5394375, 7686583, 5372195,
    2282629, 5460196, 2142592, 4765931, 2217856, 4892912, 1833900, 1770316, 1781878, 16918266, 2302037, 2085179, 2124319, 2135148, 2197661, 2156400, 2116237, 7550870, 10093033, 8216563,
    4333502, 3561931, 2189456, 4795272, 2217884, 4779772, 1836007, 1770328, 1913225, 7311337, 2305243, 2085203, 2124345, 2135153, 2197698, 2388237, 2190641, 8866071, 7982331, 2210228,
    4034008, 3566826, 2193218, 4826195, 2297165, 4792764, 1836404, 1770338, 1915305, 7315215, 2054943, 2085406, 2169222, 2135298, 2220376, 2125020, 2247485, 4892068, 7145614, 7476632,
    4337175, 2078075, 2212831, 18604860, 8190087, 4883428, 1837450, 1770371, 1756903, 15991591, 2054911, 2085533, 2169293, 2135324, 2220444, 2127581, 2222583, 4937559, 14835766, 7476743,
    2138421, 2078855, 2248179, 4885662, 5054765, 5092870, 1876399, 1770376, 1870709, 7361939, 2054964, 2085551, 2169473, 2135374, 2220469, 2177078, 4183345, 4747371, 9075679, 7476841,
    2143349, 2081839, 2252587, 15899399, 3866244, 8834870, 1876437, 1814955, 1796921, 7364682, 2054992, 2085763, 2169893, 2135384, 2220961, 2110417, 4444447, 9533816, 7053559, 7485137,
    2218331, 2035256, 7447398, 5129789, 10257506, 5354130, 1876623, 1815053, 1797285, 3983264, 2055001, 2086331, 2170892, 2136379, 2222270, 2136181, 4372135, 9217077, 7958850, 3494712,
    2218377, 2036177, 4182802, 5398057, 11956840, 5318956, 1876629, 1816361, 1798085, 3849001, 2055008, 2086598, 2174089, 2136482, 2222309, 2247420, 4580884, 4841073, 14199204, 4391619,
    2292598, 2036285, 4183626, 5164274, 5067734, 5299252, 1880216, 1817487, 1798366, 4780388, 2058451, 2087171, 2125669, 2205850, 2291747, 2378454, 4625955, 4915491, 7214485, 4084988,
    4484196, 2036509, 4342664, 7585047, 8123432, 5326509, 1957333, 1857802, 1798936, 7572765, 2058560, 2150428, 2126437, 2207097, 2293114, 3421186, 7457721, 5550962, 7233784, 3910995,
    2229289, 2150659, 4626043, 5217928, 7598719, 5327284, 1840212, 1858277, 1798959, 5290791, 2058593, 2150609, 2126923, 2207869, 4482402, 3359904, 2230405, 4792826, 9364765, 4273962,
    2295003, 2152869, 4672458, 5607223, 5922081, 5421321, 1840570, 1859556, 2042897, 5754967, 2058649, 2150637, 2128133, 2208843, 2224977, 3499329, 2261005, 4931741, 7948299, 9532777,
    2296687, 2093656, 2260982, 8063331, 9773302, 5336349, 1843131, 1859571, 7396448, 6352053, 2058880, 2152466, 2128164, 2209037, 2226382, 4747813, 3812151, 13341962, 7299210, 16164497,
    3259806, 8245171, 2296624, 9165544, 6567594, 5890773, 1843599, 1860043, 7836949, 9457153, 2058932, 2152620, 2129281, 2209707, 2229029, 5115951, 3812593, 5308977, 7942657, 5216054,
    3868112, 2156980, 2297073, 15106539, 6824875, 5897486, 1843770, 1789412, 3982058, 2071468, 2060493, 2152659, 2129303, 2209770, 2259461, 7109646, 3246207, 5404372, 7946851, 5273114,
    2414000, 2424193, 3245936, 5594485, 6856275, 5683222, 1883531, 1789692, 8219861, 2086110, 2060862, 2152803, 2129740, 2209824, 2296908, 6449285, 3248554, 5404905, 7738939, 5222501,
    2418293, 7409487, 3248601, 5834429, 6489251, 5827202, 1884610, 1790503, 16687124, 2150516, 2060867, 2152846, 2129804, 2209868, 2296930, 7664927, 4377714, 5405949, 7933197, 9829883,
    3429737, 2447997, 4380329, 6409325, 6935573, 5876765, 1924007, 1790755, 4296231, 2239018, 2060893, 2152949, 2129825, 2210407, 2298296, 7173286, 4679052, 5350485, 12305911, 7591798,
    3286785, 1973386, 4490286, 5784128, 9738227, 5878422, 1844994, 1791202, 7443945, 2249402, 2060899, 2152971, 2129841, 2185691, 2417603, 9403569, 4489867, 5353072, 7927404, 19202317,
    3447996, 1973610, 4495409, 6495213, 9393476, 8052247, 1845031, 1791369, 7447461, 2015805, 2060886, 2153872, 2129856, 2185717, 7500320, 7253624, 7478000, 7587903, 7257494, 5898508,
    3459962, 1976687, 3257617, 8036368, 16489334, 5995112, 1845063, 1792598, 7450459, 3791905, 2060906, 2153902, 2129889, 2186369, 4598878, 4475289, 3824728, 5302122, 7924080, 7607420,
    3391763, 1976883, 3333831, 6055937, 1730240, 5996432, 1847681, 1794029, 4448011, 4329318, 2061288, 2153987, 2048478, 2186399, 4639184, 4835686, 3258477, 5302264, 9328138, 7607493,
    3464163, 2095802, 2410709, 7118217, 1836773, 8039390, 1848389, 1949467, 4370845, 3945516, 2061496, 2154247, 2048519, 2186443, 4639802, 10188580, 7483550, 5333995, 7764215, 5982560,
    4085899, 2096692, 3411812, 7122192, 2353926, 8039582, 1935446, 1952421, 3613777, 4483445, 2062057, 2154500, 2048523, 2398910, 9553423, 9658501, 3261281, 7596760, 7767320, 6295187,
    3528319, 2098857, 3415561, 6948726, 2307025, 8039627, 1935677, 1820404, 4350765, 3821759, 2062046, 2090698, 2048542, 2401260, 4470795, 7871759, 3341031, 7599964, 7904666, 5826100,
    4093446, 2274892, 3344756, 7131114, 5451420, 8041793, 1888827, 1820981, 4387405, 4190831, 2063074, 2091024, 2048531, 2237499, 4422749, 2233667, 3341157, 9813271, 9641517, 5991403,
    4272323, 2279064, 3346095, 21689697, 2018039, 6117706, 1889463, 1823067, 4091589, 4381767, 2063044, 2093621, 2048574, 2240244, 4477452, 2235178, 3349284, 5648707, 9303850, 14484344,
    4469557, 2001440, 3349108, 6482982, 2031554, 6567597, 1890377, 1823493, 4095945, 3867007, 2063079, 2093690, 2048582, 2240391, 4522255, 7377977, 5502814, 5845851, 7354355, 6055468,
    4936376, 2119301, 7494838, 8015615, 1813157, 6119998, 1890499, 1823772, 4096178, 3412926, 2231523, 2093719, 2048590, 2240393, 5545503, 7378950, 3362985, 5631842, 2147855, 6380891,
    5157388, 2124661, 3288950, 6812661, 1902464, 6865885, 1892164, 1826135, 7517019, 3481141, 2231731, 2093751, 2048614, 2241573, 4821756, 5457616, 3363975, 5632959, 2157729, 6538641,
    6002847, 2169292, 3291834, 6488703, 2152674, 8377520, 1893604, 1771528, 7517546, 3292090, 2233523, 2093821, 2048735, 2112872, 4890834, 2145571, 3954092, 9171715, 2376845, 6550112,
    6555968, 2171601, 3953050, 6492509, 1915221, 7011454, 1894457, 1771587, 3847973, 3954715, 2070465, 2156545, 2101832, 2113798, 5218205, 2076987, 3374617, 5585984, 2121049, 7121570,
    6607967, 2125423, 3495408, 9741835, 1915243, 6962825, 1896512, 1771604, 3933515, 3370594, 2070794, 2156779, 2102006, 2116278, 5224148, 2153948, 3318794, 7084269, 2125301, 6864648,
    7017375, 2126974, 3499291, 18507217, 2004958, 7179834, 1899057, 1771754, 7524050, 3832714, 2070800, 2157754, 2103318, 2116342, 5318849, 2089145, 3319050, 5812452, 2106259, 6739347,
    1558458, 2127675, 4384418, 9739164, 2284034, 9396748, 1808815, 1771819, 4273861, 3453127, 2072091, 2157853, 2103358, 2116387, 5302659, 7814292, 3393196, 5755162, 15201367, 6960972,
    1838623, 2129767, 4385275, 7000314, 3983774, 7295560, 1808909, 1771858, 4325820, 3312082, 2072189, 2158110, 2103448, 2116705, 5329831, 8612919, 3466617, 15112915, 2111087, 6961203,
    1840398, 2006364, 3371936, 7013054, 4035815, 7207875, 1811665, 1771882, 4465189, 3315934, 2072284, 2160537, 2103450, 2117533, 5433078, 9616959, 3466779, 11629112, 2205983, 10100939,
    1884288, 2101457, 3450947, 6940375, 7058372, 7720547, 1812409, 1771903, 4417853, 4401364, 2072301, 2160571, 2103481, 2117811, 5632528, 2156996, 3515045, 5833692, 2139968, 15799414,
    1506588, 2103468, 3307974, 7141357, 4134563, 7955266, 1899546, 1772080, 8128145, 3640977, 2074237, 2161353, 2103503, 2117988, 7130871, 7849775, 7499389, 5996342, 12839401, 7013157,
    1506806, 2105621, 3455946, 9084468, 4028256, 7948157, 1899697, 1772107, 10568630, 3784577, 2074259, 2161917, 2103587, 2118054, 7131280, 7399357, 7509889, 5997778, 4884354, 7044717,
    1506931, 2163037, 3317906, 9393704, 4814829, 7253725, 1900726, 1772154, 14732717, 3888401, 2074248, 7400528, 2104555, 2138100, 7410267, 7406484, 8159499, 7630224, 7879318, 19655167,
    1938449, 2066233, 3400518, 7975350, 2214073, 7765175, 1900999, 1772186, 9820931, 4207139, 2074287, 2264095, 2105478, 2138808, 2098228, 7408366, 3642751, 8042860, 2052657, 10029133,
    2096497, 2067458, 3958970, 9382801, 2290780, 7339362, 1904934, 1772191, 17275073, 4499247, 2145665, 2264336, 2106215, 2140669, 4042482, 10957599, 3958772, 5784974, 2069919, 7350237,
    2114071, 2067446, 11963969, 7210348, 4484263, 1724330, 1769681, 1772217, 10505648, 4481661, 2146921, 2384818, 2106230, 2140993, 5476512, 8234896, 3648814, 6532431, 2160271, 7354402,
    3284520, 2176965, 3536242, 7211253, 3406437, 1795504, 1769686, 1772237, 16591328, 4769699, 2147840, 2387709, 2106308, 2142140, 3989640, 2169235, 3777909, 6118366, 7842425, 3996576,
    3314159, 2177399, 3847803, 9376279, 7472416, 1879140, 1769695, 1772459, 5590245, 4765269, 2147858, 2311662, 2163092, 2189347, 2213878, 2129286, 8534536, 7117923, 7421646, 7455458,
    2054667, 2281771, 3918984, 7052846, 4379491, 2160390, 1769734, 1772469, 16586425, 5314406, 2148910, 2442800, 2064648, 2189400, 2221083, 7420827, 3919267, 6379659, 2248865, 5959267,
    2056926, 2283905, 8151554, 7165894, 4314740, 2191872, 1769739, 1772495, 16587443, 5227387, 2078668, 2270281, 2065744, 2190057, 4580390, 2179075, 3786132, 6539251, 2251059, 6532078,
    2009492, 3933667, 3550959, 7231829, 3329919, 3268708, 1769747, 1773766, 8416011, 3574288, 2078720, 2314802, 2067151, 2212331, 3280587, 3985028, 3856016, 6559195, 4578417, 6564727,
    7367150, 3982411, 4274686, 7234593, 4197666, 1707736, 1769823, 1774951, 7112646, 2125391, 2078832, 2318677, 2067461, 2212505, 4197821, 3996828, 3555692, 6600522, 3430695, 6548626,
    1988658, 5473961, 3555127, 7290937, 3359662, 1639386, 1769854, 1776410, 6114391, 2209124, 2078875, 2445107, 2069194, 2213018, 8162684, 4071510, 5378666, 6663529, 3444857, 6430358,
    2063026, 4148629, 3560279, 7267586, 3490887, 1639392, 1769855, 1777073, 9773247, 4673403, 2078901, 2094501, 2069189, 2213803, 3874068, 4036275, 8140861, 6742491, 3519407, 6613703,
    2022844, 4148858, 21381305, 7268637, 4384346, 1639417, 1769877, 1905593, 7644414, 3360219, 2078928, 2095080, 2069246, 2214400, 5375201, 9595843, 5523260, 6437091, 4287686, 7179644,
    2069931, 4140911, 4225407, 14178914, 3453984, 1642541, 1769907, 1906864, 6603234, 7521187, 2080159, 2095151, 2176962, 2215288, 4365441, 4148512, 12844768, 6800189, 5325954, 7214762,
    1968847, 3996185, 4421734, 7274657, 3500018, 1629180, 1769957, 1907254, 6664734, 5317446, 2080391, 2096640, 2200475, 2215554, 5382419, 4295137, 4549572, 6338923, 9819621, 7332860,
    1968952, 4049665, 5382073, 7251653, 4393558, 1711013, 1769943, 1909606, 10129154, 7647954, 2080423, 2278925, 2201648, 2215737, 4427147, 3805646, 5065975, 6610488, 5332732, 2354713,
    1969152, 4175782, 18628279, 16478264, 4393979, 1803128, 1769982, 1910515, 12374069, 2058964, 2080460, 2119045, 2201730, 2215742, 5404926, 4049434, 4599712, 6835305, 5423964, 2072003,
    1969198, 4342043, 4652469, 7317131, 3664142, 1806496, 1770049, 1862734, 9740394, 2078417, 2081874, 2119159, 2201776, 2217179, 5232077, 4814043, 7542736, 6890038, 16604755, 7846526,
    2367646, 3602083, 7931775, 2444568, 3934602, 3364485, 2423040, 2465531, 3272473, 5397576, 3528066, 8035390, 4699314, 4642549, 7987012, 15090059, 9913820, 9742709, 21016347, 9827148,
    2163850, 7837626, 7251416, 2199848, 3805434, 3390773, 3606889, 3370583, 3272644, 5272900, 4363628, 6378137, 4774204, 5381699, 17182723, 6607813, 9552920, 14185056, 9614428, 16604127,
    2203468, 3985003, 15500829, 4100165, 2462005, 3462241, 4003120, 3307787, 3418570, 5240995, 4473203, 6387324, 4784436, 4650095, 10075392, 6287752, 14561923, 10000748, 9614847, 10461985,
    2203503, 7058911, 10029437, 4100221, 2397579, 3526442, 2469339, 4969444, 3426721, 5649598, 4738085, 8026389, 5404658, 4704319, 9065622, 7008038, 13337102, 18194484, 13369869, 10459134,
    4036503, 7430260, 7332866, 4242467, 2246633, 3742340, 2252125, 9981892, 3496008, 4988709, 4780190, 7125567, 7593569, 4235672, 7230368, 7207240, 9823988, 12575719, 9863894, 22583032,
    4138028, 8221651, 12621783, 4430125, 3283828, 3854553, 2252139, 8249339, 3372160, 5308835, 4791482, 7126321, 5959679, 4659193, 7247117, 5810709, 10189957, 11490336, 14722642, 12331864,
    5481234, 7074868, 7340416, 4050397, 3288704, 3786200, 2252283, 3596742, 3460764, 7399589, 4825976, 6442159, 7226903, 7555184, 7271150, 3444308, 15403338, 10223225, 21868328, 20152499,
    2192858, 9923571, 7353914, 2191536, 3311738, 8151892, 7446543, 8224999, 3461351, 7838152, 5316897, 6636439, 7718986, 4748540, 9315950, 4715648, 14025783, 10185098, 10933982, 15514168,
    2253244, 8561069, 2308371, 2214070, 3315056, 9878550, 7450225, 4148231, 3513716, 3984157, 5632207, 7172382, 7354778, 4775766, 7794969, 7980815, 16786875, 20040301, 9936639, 10028097,
    2382725, 2410875, 7409647, 2246323, 4219610, 11465820, 5047767, 4432323, 4086426, 4020611, 5814947, 7173706, 9298967, 4781338, 7410450, 10018585, 16079993, 11138173, 11967581, 12603885,
    2226483, 9900900, 4020330, 2249243, 5314122, 7548917, 9939319, 2462140, 3536813, 4578690, 5939919, 7153779, 5477067, 4988807, 3945892, 9544774, 10458780, 11851305, 21380044, 10094252,
    9936753, 3954631, 2143260, 2249644, 7217044, 5391447, 3616607, 3402569, 3546479, 3816911, 6094560, 7947913, 4342192, 5102900, 3821683, 9536021, 10090804, 14239722, 9844433, 11082197,
    3821582, 3501617, 4581667, 4486825, 2357785, 4730948, 4378328, 8189231, 3550074, 4196638, 5875720, 8279697, 4447394, 4784378, 8534857, 10183434, 14630658, 11072732, 20707980, 14189598,
    4185918, 8163762, 3261692, 2229046, 2161198, 8123197, 4270372, 4188373, 4218570, 5376363, 6135324, 7889239, 3622716, 4787168, 14985300, 16828091, 15500798, 20755204, 13054915, 9716982,
    4595920, 3917287, 3271762, 3244261, 7406678, 8112221, 4312305, 3490524, 4226168, 5063124, 6119859, 4072278, 5570074, 4788293, 4745095, 15807987, 9656770, 10162773, 20867898, 9618374,
    4492628, 8139398, 7496696, 3244334, 2439281, 8101048, 13865130, 3368800, 4557415, 4739783, 14475704, 4808659, 5445532, 4821249, 4777925, 10012164, 9643596, 9545027, 19344055, 10268044,
    3280781, 12832227, 9481396, 4265040, 2441435, 7592330, 3447895, 3775074, 4707190, 4892373, 6601929, 4438951, 7367746, 5551078, 9843615, 10072344, 9943224, 9545264, 10089347, 16708948,
    3491153, 13107783, 5700819, 4319208, 2315634, 15403159, 4391293, 9868859, 4821848, 5174328, 6448553, 4178013, 5453083, 5554726, 5018923, 10031014, 9901503, 12333029, 16712768, 15430215,
    3392864, 9226858, 5776592, 3258193, 2371241, 8066965, 7502905, 5391790, 5130533, 5353190, 4199690, 4380214, 3566041, 4891261, 5214146, 19138265, 17087247, 10329418, 20558286, 15512001,
    3462063, 7563253, 8044129, 3489364, 2395003, 8062756, 3536880, 4735054, 7112225, 7746714, 4420412, 3951988, 3566132, 4891360, 5330072, 19272430, 9843825, 13406604, 9912628, 9830427,
    3510079, 10560431, 5959029, 3291139, 2443100, 9164705, 3647484, 4739374, 6567712, 7760854, 4826733, 3952139, 3571568, 4929168, 5648427, 12969298, 14738459, 12826441, 12827123, 9907300,
    3396610, 9844518, 6078893, 3371608, 2444336, 10166005, 8156830, 4893246, 7647476, 3940614, 6846282, 4217755, 8241330, 4969145, 18357821, 10951287, 14732898, 11901808, 13424582, 11549876,
    3630663, 22664886, 7130455, 4384671, 2165260, 5995913, 3556961, 4946200, 6954607, 2402325, 2465878, 5448547, 3605874, 5093661, 5816448, 10463389, 9728235, 9760044, 12975583, 9953814,
    3766114, 12458341, 7970556, 3375343, 2176770, 6872500, 3561136, 7562295, 6449821, 2402767, 2475096, 4327484, 3934678, 5096032, 6158022, 13977675, 11087890, 9644076, 12807684, 9916640,
    3656649, 7607608, 7211570, 3501280, 5039490, 6910515, 5375845, 4793246, 7000052, 3280947, 2412790, 4330797, 4003136, 5131191, 5831984, 9754597, 15238409, 10998391, 21895221, 9903742,
    4502225, 18774360, 2146712, 3664461, 4669174, 8016644, 5378534, 4877516, 6992806, 3281015, 4009585, 4282186, 4805095, 5156119, 6077564, 13567041, 9535477, 15677612, 13638294, 17505965,
    4232308, 5753966, 3600869, 3665349, 2399799, 8391837, 4365879, 5095969, 7140655, 3370663, 3407496, 4638537, 4101330, 5216989, 6374881, 9952741, 9545269, 14743347, 19394047, 10168342,
    5382665, 5946219, 2126303, 3634127, 2217949, 8391980, 5381288, 5114064, 7052141, 3456865, 3970725, 4469118, 4135781, 5273724, 6547421, 13415679, 9854606, 16809475, 13496733, 10962955,
    4737211, 8790492, 2285263, 3872590, 7451146, 9742842, 9545839, 5345514, 7297306, 3526641, 5347538, 9242406, 4332036, 5310950, 6551366, 9901546, 22015404, 20774313, 16100373, 10269470,
    4767773, 5769524, 2204913, 3535317, 4373409, 15325328, 9868043, 5403306, 8247015, 3526707, 5350909, 4428016, 4029891, 5314334, 9403102, 15392703, 12327779, 14389473, 16099549, 14465390,
    4872801, 5878349, 2209051, 3848150, 4580349, 7998750, 4733274, 5225660, 7400278, 3560779, 7206362, 4478343, 4030323, 5348465, 12323658, 19759139, 9545196, 14993250, 15768413, 10116728,
    4863277, 8780659, 3550536, 3912264, 4684311, 6962504, 7562980, 5347568, 4148409, 4717050, 7332379, 7554643, 4335147, 5356528, 7942439, 15109296, 9855918, 16164263, 9955864, 14659245,
    5155487, 7112418, 7425833, 4221759, 3283679, 7006022, 4874975, 5630770, 4140055, 7998897, 3467314, 4766968, 7457433, 5361978, 7366522, 11626255, 10217560, 17377359, 10252035, 10113116,
    5283738, 6381199, 3432042, 4221821, 3401259, 7017111, 4827963, 5597926, 2250696, 3569107, 5479319, 5092452, 8187547, 5234576, 7418624, 9776072, 10219173, 9530676, 13114620, 11068106,
    5167333, 7644001, 3450160, 4573710, 3518681, 12976393, 4929910, 5774788, 4497271, 5306364, 4472610, 5397592, 7474190, 5242183, 4430670, 11361627, 10213447, 11620670, 22520136, 16587685,
    7077004, 7646300, 5512169, 4734497, 3524468, 7988355, 5131234, 5782709, 3296851, 4146788, 13346463, 6019088, 5055465, 5335650, 7445478, 10101228, 9615763, 9955184, 15409605, 12403987,
    9478319, 6644455, 4787892, 4766668, 4322547, 14834032, 5397207, 7655874, 3371582, 3815242, 6075166, 6601228, 5055509, 5607387, 5052357, 20401379, 11706602, 14542987, 9474919, 16951127,
    9160859, 7130919, 7566257, 4930351, 4478715, 7974285, 5397894, 8759059, 10251970, 3776184, 5031546, 6800347, 4190345, 5690824, 5665818, 11082322, 17732273, 19205606, 13040821, 11617329,
    5947123, 7659975, 5559205, 5667015, 5413571, 7973542, 5350962, 6831229, 3911206, 3701001, 4119837, 8011684, 4377336, 5637356, 5687764, 10077413, 14725931, 16584681, 12402286, 13401653,
    5591217, 7660852, 4885245, 6409713, 5419026, 7203294, 5298999, 6961360, 4219832, 5063995, 3991317, 7052717, 4587706, 5899726, 5582568, 10042400, 13053459, 11424613, 14461200, 12518304,
    6883442, 7668768, 5330099, 2431309, 5764664, 7164971, 5303591, 7205567, 9436424, 7538957, 4184482, 7314364, 4495551, 5584049, 5661899, 14793758, 14413405, 15317345, 15527070, 12461261,
    6623837, 9094042, 5422269, 4099986, 6114284, 9376243, 5329884, 12043383, 16508816, 5381865, 5056859, 7896842, 3823837, 5702221, 5662480, 12925743, 18261924, 10078947, 16696530, 13557155,
    6894926, 7172228, 5665354, 3371831, 6866870, 9060840, 8444966, 9039672, 12929526, 5400782, 3524716, 4335877, 8179067, 7616239, 7613260, 19640930, 13437668, 10164980, 13890124, 11877869,
    21243520, 7222964, 7646930, 3321778, 7214877, 7221030, 5684264, 4099973, 7276223, 5339273, 7872665, 3315288, 3264249, 5867751, 5947989, 9657673, 10041412, 18549268, 12911414, 13029199,
    7717544, 7688927, 2302829, 3850762, 7291251, 9052156, 7081277, 3449807, 11007880, 5313883, 7825736, 3642107, 3345638, 5940138, 5998332, 15981269, 9630816, 10648578, 19613052, 11596033,
    7264639, 7180657, 2224620, 3912345, 2188999, 7264557, 9167596, 3307131, 2393373, 5319435, 7417063, 3920982, 3296224, 7619399, 6017358, 12608143, 12847282, 22033527, 12826926, 21685106,
    7746828, 9082925, 4496226, 5192948, 2282516, 9355417, 8794640, 3530292, 3940258, 5327697, 3934700, 4519242, 3296271, 5824149, 6723165, 9542289, 9837363, 11074044, 14820347, 15498133,
    7257545, 7974372, 3410913, 4913739, 7879589, 18236224, 5824135, 3649480, 4035136, 5583995, 4671787, 6446350, 3370707, 8790664, 6883501, 9845799, 13333464, 13556356, 9455357, 13553841,
    7317918, 9392352, 2417597, 5226654, 7880518, 8664517, 5593929, 3249462, 2293135, 6556452, 4198414, 6456330, 3371664, 5767314, 6616539, 14459278, 9758978, 19378069, 9446491, 13679432,
    7770287, 7152655, 3785426, 2301670, 7873511, 7756916, 6070923, 5315712, 2293141, 6610267, 3444142, 6740416, 3492718, 5879915, 6866426, 9711925, 16711812, 11859421, 11830324, 20724193,
    9997349, 7156611, 3892125, 2302876, 7801818, 7758776, 7112673, 2394572, 2293145, 6723808, 3513084, 7156976, 3449379, 6071445, 6867361, 9645775, 12915099, 13503753, 9400566, 14548196,
    7367287, 7291647, 3859809, 2230932, 7817000, 7759941, 6055112, 2465213, 5312971, 7173931, 8159092, 3212999, 3449521, 5776712, 7703921, 9938076, 9995949, 21058222, 10078974, 16814553,
    7367319, 7294637, 3860504, 2363177, 7818937, 10017255, 6865002, 3626293, 5428213, 7156024, 8533905, 3515600, 3449620, 5931860, 7277350, 15922316, 9918004, 10081951, 9995603, 16590563,
    7374133, 7717061, 4819373, 2389929, 8242387, 7769001, 7679973, 3357475, 2306683, 7293862, 3560375, 7853331, 4393613, 5933107, 3571542, 10452304, 9926799, 22557049, 9454193, 15504558,
    7871338, 7169712, 6865225, 2447989, 7825896, 7769018, 7019113, 4002360, 2387672, 7916455, 10894042, 3996865, 4083754, 6045051, 3896888, 16536477, 17995397, 15744074, 19458815, 15505092,
    7381534, 7230404, 2303722, 2248042, 8225780, 7770390, 7148394, 4814713, 2387710, 4344254, 5547318, 3997135, 3770237, 8034948, 5299334, 9627635, 9554425, 18443952, 9542600, 19625680,
    3562800, 7231578, 3573136, 2222353, 4046834, 7776925, 7214551, 4125761, 3604985, 4582595, 5176784, 4021130, 3978605, 6430696, 5482258, 9629133, 21386022, 14922139, 14016659, 19624577,
    7387838, 9061401, 2429725, 4497140, 8212487, 7787007, 9366714, 4126892, 3945710, 4582683, 7083671, 4177483, 3561458, 6858551, 15205256, 9613208, 9852730, 10156012, 16598198, 17590247,
    7810630, 7233696, 2266202, 5344573, 3613700, 3322003, 7256974, 4249980, 2456750, 4582727, 8053468, 4385707, 4286877, 6817875, 22673696, 9936745, 21366121, 9557265, 10665750, 18597467,
    7810767, 7731436, 2270687, 5338719, 8185530, 6946887, 12609557, 4669718, 4497097, 5501911, 6073732, 5512857, 8141169, 6817889, 5937214, 9937816, 14501371, 9855542, 12310118, 15495103,
    7396658, 7947167, 2315450, 6741581, 8913354, 7382148, 7784548, 4621785, 3899707, 3357468, 6077382, 4222206, 8881706, 7012384, 5937349, 9923894, 9457439, 10305005, 10883833, 18633672,
    7402604, 7267412, 2373181, 2363258, 4314654, 7384961, 2356589, 4628527, 5379694, 3444878, 6077676, 5374850, 4601783, 7681910, 6114470, 9926389, 14469502, 9546118, 9848442, 18324355,
    7403111, 7246956, 2394361, 2371443, 8178231, 3572535, 2451865, 7481210, 4239589, 3312222, 6117384,

    484968, 487190, 510786, 811609, 837049, 1015664, 1112250, 1167629, 1228490, 1492686, 1672991, 2049353, 2410512, 822099, 2918258, 2067011, 2013606, 1394684, 2247448, 2194092,
    2051645, 1826230, 1703852, 2392008, 2106085, 1899155, 1742447, 1742336, 1642825, 1695300, 1994474, 1814011, 1992268, 2071611, 2778946, 1719437, 1769091, 1952601, 1930012, 2111501,
    2465955, 2117576, 1710960, 1711014, 1710994, 1655713, 1834779, 1772143, 3027801, 3027821, 3027629, 3021620, 3007138, 3005883, 3005565, 2982287, 2998785, 1733538, 1737252,
    2243752, 2243760, 2243777, 2243791, 2243805, 2974914, 2145674, 2093731, 2071438, 2071441, 1871090, 1905413, 1958962, 2252228, 2184443, 2110412, 2127659, 2127676, 2127782, 2136194,
    2136197, 2136199, 2141857, 2154565, 2060259, 2934773, 3104390, 2109644, 2881576, 1986545, 2209168, 2226239, 2199160, 2175834, 2146738, 2315492, 2308491, 2303725, 2184539, 2169842,
    2149634, 2430076, 3116007, 2464616, 2394327, 2298574, 2273105, 2380864, 2272944, 2168982, 2178926, 2237580, 2317341, 2388494, 2415264, 2141972, 2262851, 2476458, 2278524, 2297200,
    2305178, 407470, 465740, 464654, 113017,
);

=head2 fetch_client_multicurrency_teaser_data($client_id, $agency_id, %params)

    Обновляет в таблице client_firm_country_currency кешированную информацию о доступных для клиента при переходе валют и стран.

    Параметры позиционные:
        $client_id - ID клиента (или агентства)
        $agency_id - ID агентства клиента
    Параметры именованные:
        firm_country_currency_data_ref - ссылка на скаляр, в который нужно сохранить полученные данные о странах/валютах
        balance_timeout     - таймаут на запрос к балансу

    Client::CurrencyTeaserData::fetch_client_multicurrency_teaser_data($client_id, $agency_id);
    Client::CurrencyTeaserData::fetch_client_multicurrency_teaser_data($client_id, $agency_id, firm_country_currency_data_ref => \$country_currency_data, balance_timeout => 320);

=cut

sub fetch_client_multicurrency_teaser_data {
    my ($client_id, $agency_id, %O) = @_;

    my $new_data = BalanceWrapper::get_firm_country_currency($client_id, AgencyID => $agency_id, currency_filter => 1, timeout => $O{balance_timeout});
    die "error fetching teaser data for ClientID $client_id" unless defined $new_data;

    # Для белорусов, плативших в рублях, получаем все доступные валюты, чтобы убедиться, что среди них есть BYN, и оставляем только BYN
    if ((   (all { $_->{region_id} == $geo_regions::BY } @$new_data)
            && (any { $_->{currency} eq 'RUB' } @$new_data))
        || any {$client_id == $_} @RUB_BELARUS_CLIENTIDS)
    {
        $new_data = [];
        my $firm_country_currency_data = BalanceWrapper::get_firm_country_currency($client_id, AgencyID => $agency_id, timeout => $O{balance_timeout});
        for my $row (@$firm_country_currency_data) {
            if ($row->{currency} eq 'BYN' && $row->{region_id} == $geo_regions::BY) {
                push @$new_data, $row;
            }
        }
    }

    if ($O{firm_country_currency_data_ref}) {
        ${$O{firm_country_currency_data_ref}} = $new_data;
    }

    my %new_data_for_diff = map { $_->{currency} . ':' . $_->{region_id} => 1 } @$new_data;

    my $current_data = get_all_sql(PPC(ClientID => $client_id), 'SELECT country_region_id, currency FROM client_firm_country_currency WHERE ClientID = ?', $client_id);
    my %current_data_for_diff = ($current_data && @$current_data) ? map { $_->{currency} . ':' . $_->{country_region_id} => 1 } @$current_data : ();

    my $changes = hash_diff \%current_data_for_diff, \%new_data_for_diff;
    if ($changes && %$changes) {
        my @new_data;
        while ( my($key, $not_deleted) = each %$changes ) {
            my ($currency, $region_id) = split /:/, $key, 2;
            my %table_data = (ClientID => $client_id, country_region_id => $region_id, currency => $currency);
            if ($not_deleted) {
                # группируем вставку новых данных, чтобы уменьшить число SQL-запросов
                push @new_data, \%table_data;
            } else {
                # не группируем удаления исходя из предположения о редкости удаления и нежелания усложнять код
                do_delete_from_table(PPC(ClientID => $client_id), 'client_firm_country_currency', where => \%table_data);
            }
        }
        if (@new_data) {
            my @data_to_insert = map { [$_->{ClientID}, $_->{country_region_id}, $_->{currency}] } @new_data;
            do_mass_insert_sql(PPC(ClientID => $client_id), 'INSERT IGNORE INTO client_firm_country_currency (ClientID, country_region_id, currency) VALUES %s', \@data_to_insert);
        }
    }

    # время изменения обновляем даже если ничего не изменилось: оно используется для регулярного переобхода и определения свежести
    do_insert_into_table(PPC(ClientID => $client_id), 'client_teaser_data_lastupdate',
        { ClientID => $client_id, last_update__dont_quote => 'NOW()' },
        on_duplicate_key_update => 1, key => 'ClientID',
    );
}

=head2 can_be_modify_converted

    По списку доступных клиенту стран и валют из Баланса определяет можно ли клиента конвертировать без копирования

    $can_be_modify_converted = Client::CurrencyTeaserData::can_be_modify_converted($country_currency_data);

=cut

sub can_be_modify_converted {
    my ($country_currency_data) = @_;

    return any { $_->{currency} eq 'RUB' && $_->{convert_type_modify} } @$country_currency_data;
}

1;
