
#######################################################################
#  Direct.Yandex.ru
#
#  Common
#  Common functions
#
#  $Id$
#
#######################################################################

=head1 NAME

Common - Common functions

=head1 DESCRIPTION

Common functions

=cut

package Common;
## no critic (TestingAndDebugging::RequireUseStrict)
## no critic (TestingAndDebugging::RequireUseWarnings)

BEGIN {
    use vars qw($VERSION @ISA @EXPORT @EXPORT_OK %EXPORT_TAGS);
    require Exporter;

    # set the version for version checking
    $VERSION     = 2.00;
    @ISA         = qw(Exporter);
    @EXPORT      = qw( );
    %EXPORT_TAGS = (
        globals => [ qw(
                        $AUTO_BROKER_INCREASE

                        $CAMP_ACTIVE_SQL

                        %CAMPS_SORT
                       )
                   ],
        subs    => [ qw(
            validate_domains

            save_price_form
            save_price
            mass_get_favorite_camps
            favorite_camp
            validate_camp
            get_user_banner
            get_user_banner_list
            get_user_camp
            get_user_camps
            get_user_camps_by_sql
            prepare_user_camps_by_sql_params
            get_agency_camps
            get_user_camps_name_only
            get_managers_list
            order_camp

            mass_resume_banners
            unarc_camp
            mass_unarchive_banners
            camps_add_rbac_actions
            calc_adgroups_prices
            get_banner_with_prices_from_form
            get_camp_banners_status
            get_camps_banners_lang
            check_mcb_geo_min_shows
            validate_common_geo
            banner_search_params
            get_user_count_mails

            get_agency_client_vars
            get_agencies_client_vars

            get_manager_shards
            get_agency_shards

            sms_time2string

            send_banners_to_moderate

            set_optimize_camps_vars

            get_campaigns_with_context_limit

            change_uid

            convert_spell_js

            calc_topay_sum
            round_easy_topay_sum

            ajax_adgroup_phrases_filter

            get_captcha_freq

            update_camp_auto_optimization

            populate_report_vars
            calc_banners_count_per_page
            get_user_camps_stat

            mix_manager_data
            mix_agency_data

            get_places
        ) ]
    );

    Exporter::export_ok_tags('globals', 'subs');
}

use vars @{$EXPORT_TAGS{globals}};

use strict;
use warnings;
use feature q/state/;
use Carp qw/longmess croak/;
use Yandex::Clone qw/yclone/;

use Settings;
use Primitives;
use PrimitivesIds;
use URLDomain;
use TTTools;
use IpTools;
use LogTools;
use TextTools;
use ShardingTools;
use Tools;
use Yandex::HTTP;
use Yandex::DBTools;
use Yandex::DBShards;
use Yandex::Overshard;
use Yandex::SendMail;
use MailNotification;
use RBACElementary;
use RBACDirect;
use Currencies;
use Currency::Rate;
use VCards;
use Sitelinks;
use Yandex::Trace;
use Yandex::TimeCommon;
use BalanceWrapper;
use Client;
use ServicedClient;
use User;
use AutoBroker;
use Forecast;
use Stat::OrderStatDay;
use Yandex::I18n;
use MTools;
use TimeTarget;
use Yandex::HashUtils;
use Yandex::ListUtils qw(xisect xuniq xminus chunks xsort);
use Yandex::ScalarUtils;
use Yandex::Interpolate;
use Yandex::Retry;
use Yandex::Runtime;
use Yandex::Validate;
use LockObject;
use Yandex::MirrorsTools::Hostings qw/strip_www/;
use Yandex::URL qw/get_top_level_domain strip_protocol/;
use Property;

use Moderate::Settings;
use Moderate::JSONRPC::Client;

use BannersCommon;
use BannerTemplates;
use Campaign;
use CampaignTools;
use Campaign::Types;
use CampAutoPrice::Common;
use MobileApps;
use PhraseText;
use PhrasePrice;
use PlacePrice;
use Pokazometer qw/safe_pokazometer/;
use Mediaplan;
use Yandex::IDN qw(is_valid_email);
use Tag;
use Direct::ResponseHelper;
use DeviceTargeting qw/is_valid_device_targeting/;
use WalletUtils;
use Direct::Validation::HierarchicalMultipliers qw/validate_hierarchical_multipliers/;
use Direct::AdGroups2::Performance;
use Direct::Banners::Performance;
use Direct::Banners qw//;
use Direct::Bids::BidRelevanceMatch;
use Direct::PerformanceFilters;
use Direct::Model::AdGroupPerformance;
use Direct::Model::Creative;
use Direct::Validation::BannersPerformance qw//;
use Direct::Validation::Banners;
use Direct::Validation::Bids;
use Direct::Validation::Campaigns qw/validate_campaign_internal_distrib validate_campaign_internal_free validate_copy_campaigns_for_client/;
use Direct::Validation::Domains qw//;
use Direct::Validation::Keywords qw//;
use Reports::Offline::Postview qw//;

use POSIX qw(strftime floor ceil LONG_MAX);
use URI::Escape qw/uri_escape_utf8/;
use HTTP::Request;
use HTTP::Headers;
use MetrikaCounters;
use ADVQ6;

use Models::AdGroup;
use Models::Campaign qw/filter_full_campaigns/;
use Models::CampaignOperations;
use Models::Banner;

use Moderate::Tools;
use Moderate::ReModeration;

use geo_regions;
use GeoTools;
use Stat::OrderStatDay;
use utf8;
use List::Util qw/max min minstr sum/;
use List::MoreUtils qw/uniq all any none pairwise/;
use JSON qw/from_json/;
use Yandex::IDN;
use Yandex::DateTime;
use BannerFlags;
use Campaign::Const qw/@PAGE_TYPE_ENUM/;
use JavaIntapi::GetUserInfo;

use CheckAdv;
use BS::TrafaretAuction;
use Agency;

$AUTO_BROKER_INCREASE = 1.30;    # коэффициент, вычисляющий предлагаемую по умолчанию цену клика в автоброкере

# различные куски SQL (пока здесь, но нужно думать)
# для кампаний внутренней рекламы в sum и sum_spent пока всегда нули. Изменится в DIRECT-92956
our $CAMP_ACTIVE_SQL = "IF(((c.sum - c.sum_spent + IF(c.wallet_cid, wc.sum - wc.sum_spent, 0) > $Currencies::EPSILON) OR c.type IN ('internal_free','internal_distrib')) AND c.statusShow = 'Yes','Yes', 'No')";
our $CAMP_ACTIVE_SQL_MEDIA = "IF(c.sum - c.sum_spent > $Currencies::EPSILON and c.statusShow = 'Yes', 'Yes', 'No')";

# кампания остановленна и её можно архивировать
our $CAMP_STOPPED_SQL = "
    c.statusShow = 'No'
    AND (NOT c.lastShowTime OR DATE_ADD(c.lastShowTime, INTERVAL $Settings::MINUTES_AFTER_LAST_SHOW_FOR_ARC_CAMP MINUTE) < NOW())
    AND (NOT c.OrderID OR NOT co.stopTime OR DATE_ADD(co.stopTime, INTERVAL $Settings::MINUTES_AFTER_LAST_SHOW_FOR_ARC_CAMP MINUTE) < NOW())
";

my @BIDS_FIELDS = qw/id phrase norm_phrase numword price place cid modtime PhraseID statusModerate warn statusBsSynced
    optimizeTry showsForecast is_suspended pid/;

my $BIDS_FIELDS_STR = join ', ', @BIDS_FIELDS, 'autobudgetPriority', 'price_context';

my $CPM_OVERLAY_ADDITION_LAYOUT_ID_MIN = 351;
my $CPM_OVERLAY_ADDITION_LAYOUT_ID_MAX = 400;

=head2 save_prices

    обновление цен на кампании, на входе uid и данные формы {%FORM}

    $error = save_prices($uid, $prices, $options);

    $options - не обязательные опции:
        dont_clear_auto_price_queue  => 1 -- не чистить очередь на изменение цен на кампании,
                                             используется при вызове из скрипта обрабатывающего эту очередь

=cut

sub save_prices
{
    my ($uid, $prices, $options) = @_;

    $options = {} unless $options;

    my ($clause, $campaign);

    if (defined $prices->{phrase_ids}){
        $clause->{'bi.id'} = $prices->{phrase_ids};
    }
    if (defined $prices->{cid}){
        $clause->{'p.cid'} = $prices->{cid};
        $campaign = get_camp_info($prices->{cid}, $uid, short => 1);
    }

    my $fields = 'bi.id, p.statusModerate, p.pid, p.cid, bi.price, bi.price_context, bi.phrase
            , bi.place, IFNULL(bi.autobudgetPriority,3) autobudgetPriority
            , p.statusPostModerate, bi.statusModerate bi_statusModerate, p.PriorityID, bi.PhraseID';
    my $join = 'JOIN phrases p using(pid)';

    my $rows = get_all_sql(PPC(uid => $uid), [qq/SELECT $fields FROM bids bi $join WHERE/, $clause]);
    my $pid2bid = Primitives::get_main_banner_ids_by_pids(uniq map {$_->{pid}} @$rows);
    # DIRECT-67610
    #my ($adgroups) = Models::AdGroup::get_groups_gr({pid=>[keys %$pid2bid], adgroup_types => [qw/base dynamic mobile_content/]});

    my $result = [];
    #foreach my $adgroup (@$adgroups) {
    #    next unless $adgroup->{banners_quantity} && $adgroup->{banners_arch_quantity} >= $adgroup->{banners_quantity};
    #    push @$result, iget("Группа объявлений № %s находится в архиве - редактирование ставок невозможно", $adgroup->{pid});
    #}
    #return $result if @$result;

    # Что апдейтим id => { place => , price => }
    my (%bids_update);
    my (@data_for_log_price);
    my $data_for_mail_notification;

    for my $row (@$rows) {
        my $id = $row->{id};
        my $price = $prices->{$row->{id}};
        if ($campaign) {
            hash_merge $row, $campaign;
        } else {
            my $campaign = get_camp_info($row->{cid}, $uid, short => 1);
            hash_merge $row, $campaign;
        }

        next unless defined($price->{price}) || defined $price->{price_context};

        my $invalid_prices_cnt=0;
        my $currency = $row->{currency} || 'YND_FIXED';
        if (defined($price->{price})) {
            if ($campaign->{platform} eq 'context') {
                # если показы на поиске отключены, не меняем ставку на поиске и не валидируем значение, которое уже лежит в БД
                $price->{price} = $row->{price};
            } else {
                if (validate_phrase_price($price->{price}, $currency)) {
                    $prices->{"price_errors"}->{$id} = $price->{price};
                    $invalid_prices_cnt++;
                }
            }
        }
        if (defined($price->{price_context})) {
            if (($campaign->{strategy} || '') ne 'different_places') {
                # если стратегия не ручная, или показы на РСЯ отключены, не меняем ставку РСЯ и не валидируем значение, которое уже лежит в БД
                $price->{price_context} = $row->{price_context};
            } else {
                my $validation_result = ($campaign->{type} &&  Campaign::is_cpm_campaign($campaign->{type}))
                    ? validate_cpm_price($price->{price_context}, $currency)
                    : validate_phrase_price($price->{price_context}, $currency);
                if ($validation_result) {
                    $prices->{"price_context_errors"}->{$id} = $price->{price_context};
                    $invalid_prices_cnt++;
                }
            }
        }

        unless ($invalid_prices_cnt ) {
            my $p = round2s((!defined $price->{price} || $campaign->{platform} eq 'context') ? $row->{price} : $price->{price});
            my $p_context = round2s(
                (   ! defined $price->{price_context}
                    || ($campaign->{strategy} || '') ne 'different_places'
                )
                    ? $row->{price_context} : $price->{price_context});
            my $new_bid_data = {
                place      => (defined $price->{price} && $row->{price} != $price->{price}) ? calcPlace( $p, $price->{guarantee}, $price->{premium} ) : $row->{place},
                price      => $p,
                price_context => $p_context,
                autobudgetPriority => defined $price->{autobudgetPriority}
                                      ? validate_priority($price->{autobudgetPriority})
                                      : $row->{autobudgetPriority}
            };
            next if
                abs( $new_bid_data->{price}         - $row->{price} )              < $Currencies::EPSILON &&
                abs( $new_bid_data->{price_context} - ($row->{price_context}||0) ) < $Currencies::EPSILON &&
                $new_bid_data->{place} &&
                $new_bid_data->{place}              == $row->{place} &&
                $new_bid_data->{autobudgetPriority} == $row->{autobudgetPriority};

            $bids_update{ $id } = $new_bid_data;

            push @data_for_log_price, {
                cid       => $row->{cid},
                pid       => $row->{pid},
                id        => $id,
                type      => 'update2',
                price     => $p,
                price_ctx => $p_context,
                currency  => $campaign->{currency},
            };

            # if change price
            if ($p && abs($p - $row->{price}) > $Currencies::EPSILON) {
                push @$data_for_mail_notification, {
                    object     => 'phrase',
                    event_type => 'ph_price',
                    object_id  => $pid2bid->{$row->{pid}},
                    old_text   => $row->{price},
                    new_text   => $p,
                    uid        => $uid,
                };
            }

            if ($p_context && abs($p_context - $row->{price_context}) > $Currencies::EPSILON) {
                push @$data_for_mail_notification, {
                    object     => 'phrase',
                    event_type => 'ph_price_ctx',
                    object_id  => $pid2bid->{$row->{pid}},
                    old_text   => $row->{price_context},
                    new_text   => $p_context,
                    uid        => $uid,
                };
            }
        }

    }

    mass_mail_notification($data_for_mail_notification);

    LogTools::log_price(\@data_for_log_price);
    if (! $options->{dont_clear_auto_price_queue} && @data_for_log_price) {
        clear_auto_price_queue($prices->{cid});
    }
    # Теперь обновляем bids
    my @bids_to_update = sort { $a <=> $b } keys %bids_update;
    while ( @bids_to_update ) {
        my @bids_chunk = splice @bids_to_update, 0, 1000;

        do_in_transaction {
           my $ids_to_update = get_one_column_sql(PPC(uid => $uid), [
                   'SELECT id FROM bids',
                   WHERE => {
                       id => \@bids_chunk,
                       statusModerate => ['Yes', 'New'],
                   },
                   'FOR UPDATE',
               ]);
            return if !@$ids_to_update;

            do_update_table(PPC(uid => $uid), bids => {
                    warn => 'Yes',
                    statusBsSynced => 'No',
                    place__dont_quote => sql_case(id => {map {$_ => $bids_update{$_}{place}} @$ids_to_update}, default__dont_quote => 'place'),
                    price__dont_quote => sql_case(id => {map {$_ => $bids_update{$_}{price}} @$ids_to_update}, default__dont_quote => 'price'),
                    price_context__dont_quote => sql_case(id => {map {$_ => $bids_update{$_}{price_context}} @$ids_to_update}, default__dont_quote => 'price_context'),
                    autobudgetPriority__dont_quote => sql_case(id => {map {$_ => $bids_update{$_}{autobudgetPriority}} @$ids_to_update}, default__dont_quote => 'autobudgetPriority'),
                },
                where => {id => $ids_to_update},
            );
        };
    }

    return @$result ? $result : undef;
}

=head2 save_price_for_relevance_match
    Обновление ставок бесфразного таргетинга на группе
=cut

sub save_price_for_relevance_match {
    my ($client_chief_uid, $adgroup_id, $price_data, $adgroups_cache) = @_;

    die 'adgroup_id required' unless $adgroup_id;
    $adgroups_cache //= {};
    my %filter = (pid => $adgroup_id);
    $filter{id} = $price_data->{phrase_ids} if defined $price_data->{phrase_ids};

    my $bids_for_update = Direct::Bids::BidRelevanceMatch->get_by(%filter);
    return [iget('Не удалось найти обновляемые условия нацеливания.')] unless @{$bids_for_update->items};

    my $adgroup = $adgroups_cache->{$adgroup_id} // Direct::AdGroups2->get_by(adgroup_id => $adgroup_id, extended => 1)->items->[0];
    $adgroups_cache->{$adgroup_id} //= $adgroup;

    for my $bid (@{$bids_for_update->items}) {
        $adgroup //= $bid->adgroup;
        $bid->old($bid->clone);
        my $new_data = $price_data->{$bid->id};
        next unless $new_data;
        $bid->price($new_data->{price}) if defined $new_data->{price};
        $bid->price_context($new_data->{price_context}) if defined $new_data->{price_context};
        $bid->autobudget_priority($new_data->{autobudgetPriority}) if defined $new_data->{autobudgetPriority};
        $bid->is_suspended($new_data->{is_suspended}) if defined $new_data->{is_suspended};
    }
    # Для обновления надо выставить группу на объекте Bid'а
    $_->adgroup($adgroups_cache->{$_->adgroup_id}) foreach @{$bids_for_update->items};

    my $vr = Direct::Validation::Bids::validate_relevance_matches_for_adgroup(
        $bids_for_update->items,
        $adgroup,
        Models::Campaign::get_user_camp_gr($client_chief_uid, $adgroup->campaign_id, {no_groups => 1, without_multipliers => 1})
    );

    if (!$vr->is_valid) {
        $vr->process_descriptions(
            price => { field =>  iget('Цена на поиске') },
            price_context => { field =>  iget('Цена на сети') },
            autobudget_priority => { field => iget('Приоритет ставки') },
        );
        return $vr->get_error_descriptions;
    }
    $bids_for_update->update();

    return;
}

=pod
    обновление цен на кампании, на входе uid и данные формы {%FORM}

    $error = save_campaign_price($uid, $raw_b, $options);

    $options - не обязательные опции:
        dont_clear_auto_price_queue  => 1 -- не чистить очередь на изменение цен на кампании,
                                             используется при вызове из скрипта обрабатывающего эту очередь

=cut

sub save_price_form
{
    my ($uid, $raw_b, $options) = @_;

    my %prices;
    my $is_relevance_match = ($raw_b->{type} // '') eq 'relevance_match' ? 1 : 0;
    $prices{$raw_b->{id}} = hash_cut $raw_b, qw/price price_context autobudgetPriority/;
    $prices{$raw_b->{id}}->{guarantee} = $raw_b->{json_guarantee};
    $prices{$raw_b->{id}}->{premium} = $raw_b->{json_premium};
    $prices{phrase_ids} = [$raw_b->{id}];
    $prices{cid} = $raw_b->{cid};
    my $adgroup_id = $raw_b->{adgroup_id};
    return $is_relevance_match ? save_price_for_relevance_match($uid, $adgroup_id, \%prices) : save_prices($uid, \%prices, $options);
}


#======================================================================

=head2 get_agency_client_vars(rbac, uid)

    Getting agency variables by uid

=cut

sub get_agency_client_vars
{
    my ($rbac, $uid) = @_;

    my $vars = get_agencies_client_vars($rbac, [$uid]);

    return $vars->{$uid};
}

=head2 get_agencies_client_vars(rbac, uids)

    Getting agencies variables by uids

=cut

sub get_agencies_client_vars
{
    my ($rbac, $uids) = @_;

    return undef unless $uids && scalar @$uids;

    my $result;
    my $uid2clientid = rbac_get_agencies_clientids_by_uids( $uids) || {};

    my $vars = get_all_sql(PPC(ClientID => [uniq values %$uid2clientid]), ["SELECT ClientID, name as agency_name, agency_url, agency_status
                                         FROM clients
                                        WHERE",
                                        {
                                            ClientID => SHARD_IDS
                                        }]);

    my $clientid2vars;
    foreach my $v (@$vars) {
        $clientid2vars->{$v->{ClientID}} = $v;
    }

    my $uid2rep_type = rbac_get_agencies_rep_types($uids);

    foreach my $uid (@$uids) {
        my $line = $clientid2vars->{ $uid2clientid->{$uid} };

        $line->{agency_rep_type} = $uid2rep_type->{$uid};
        $line->{agency_client_id} = $uid2clientid->{$uid};

        $result->{$uid} = $line;
    }

    return $result;
}

=head2 mass_get_favorite_camps(rbac, uids)

    Возвращает важные кампании представителя клиента

=cut

sub mass_get_favorite_camps {
    my $uid = shift;
    my $favorite_camps = { map {$_->{cid} => 1} @{ get_all_sql(PPC(uid => $uid),
            "select cid from user_campaigns_favorite where uid = ?", $uid) }
    };
    return $favorite_camps;
}

#-----------------------------------------------------------

=head2 favorite_camp

    save favorite campaign for client rep

    favorite_camp($rep_uid, $cid, 1); # save camp to favorite
    favorite_camp($rep_uid, $cid, 0); # delete camp from favorite

=cut

sub favorite_camp
{
    my ($uid, $cid, $favorite_camp) = @_;

    if ($favorite_camp) {
        do_insert_into_table(PPC(uid => $uid), 'user_campaigns_favorite', {uid => $uid, cid => $cid}, ignore => 1);
    } else {
        do_delete_from_table(PPC(uid => $uid), 'user_campaigns_favorite', where => {uid => $uid, cid => $cid});
    }
}

=head2 validate_domains(domains_str)

    Проверка доменом-площадок РСЯ, на которых запрещены показы объявлений в кампании

=cut

sub validate_domains
{
    my ($domains_text, %options) = @_;
    my @domains = grep {defined $_} split /\s*,\s*/, $domains_text;

    $options{skip_blacklist_size_limit} = 1;
    my $vr = Direct::Validation::Domains::validate_disabled_domains(\@domains, %options);
    return if $vr->is_valid;

    $vr->process_descriptions(__generic => {field => iget("'Отключенные площадки'")});
    return join '; ' => @{$vr->get_error_descriptions};

=old

    my @errors;
    for my $d (@domains) {
        # предполагаем, что в названии площадки домен - только до первого пробела, а дальше могут быть пояснения
        $d =~ s/ \s .+ $ //xms;
        my $d_ascii = Yandex::IDN::idn_to_ascii($d);
        # удаляем www. для всех доменов, кроме доменов общего пользования
        if ($d_ascii !~ /(^|\.)(pp|ac|boom|msk|spb|nnov)\.ru|(net|org|com|int|edu)\.[-a-z]+$/i) {
            $d_ascii = strip_www($d_ascii);
	    }
        if ( !Yandex::IDN::is_valid_domain($d_ascii) ) {
            push @errors, "$d - " . iget("неправильный формат домена");
            # часть яндексовских доменов запрещать нельзя (DIRECT-11313)
        } elsif ( $d_ascii =~ /^((m|www)\.)?((direct)\.)?(yandex|ya)\.[a-z]+$/i  || lc($d_ascii) eq 'xn--d1acpjx3f.xn--p1ai' ||
            lc($d_ascii) =~ /^((go|www|)\.)?mail\.ru/) {
            push @errors, "$d - " . iget("отключать показы на площадке %s нельзя", $d);
        } elsif ( $d_ascii =~ /^(\*\.)?((pp|ac|boom|msk|spb|nnov)\.ru|(net|org|com|int|edu)\.[-a-z]+)$/i ) {
            push @errors, "$d - " . iget("для этого домена можно блокировать только третий уровень");
        } elsif ( length($d) >= 255 ) {
            push @errors, "$d - " . iget("превышена максимально допустимая длина домена");
        }
    }

    return unless scalar @errors;
    return join('; ' => @errors);

=cut
}



=head2 validate_disabledIps($ips)

    Проверка списка заблокированных IP-адресов, $ips список адресов разделенных запятой или пробелами

=cut

sub validate_disabledIps {
    my $IP_addresses_text = shift;
    my @IP_addresses = grep {$_} split /[\s,]+/, $IP_addresses_text;
    return validate_disabledIps_arrayref(\@IP_addresses);
}

=head2 validate_disabledIps_arrayref(\@ips)

    Проверка списка заблокированных IP-адресов,

=cut

sub validate_disabledIps_arrayref {
    my $IP_addresses = shift;
    my $errors = '';
    my @incorrect_format;
    my @private_networks;
    my @unblockable_ips;

    for my $i (@$IP_addresses){
        if ( $i !~ /^([0-9]{1,3})\.([0-9]{1,3})\.([0-9]{1,3})\.([0-9]{1,3})$/ ) {
            push @incorrect_format, "$i";
        } else {
            my $ok;
            $ok = 1;
            ## no critic (Freenode::DollarAB)
	        foreach my $b ($1, $2, $3, $4) {
                 $ok=$ok && ($b<=255) && !(($b>0)&&($b=~/^0/));
	        }
	        if (!$ok) {
                push @incorrect_format, "$i";
            } elsif (is_ip_in_list($i, $Settings::PRIVATE_NETWORKS)) {
                push @private_networks, "$i";
	        } elsif (is_ip_in_list($i, $Settings::UNBLOCKABLE_IPS)) {
                push @unblockable_ips, "$i";
            }
	    }
    }
    $errors .= iget("Формат IP-адреса указан неверно:") . " " . join(', ', @incorrect_format) . "\n" if ( @incorrect_format );
    $errors .= iget("Нельзя запрещать адреса из частных подсетей:") . " " . join(', ', @private_networks) . "\n" if ( @private_networks );
    $errors .= iget("IP-адреса из подсети Яндекса в список запрещенных вносить не нужно. Показы и клики с этих IP-адресов в статистике кампаний не учитываются:") . " " . join(', ',  @unblockable_ips) . "\n" if ( @unblockable_ips );
    my $MAX_IP_QNTY=25; #По-хорошему, надо сделать единое определение константы $MAX_IP_QNTY для здесь и для javascript (popupdisabledIps.html)
    if (scalar(@$IP_addresses) > $MAX_IP_QNTY) {
        $errors .= iget("Превышено допустимое количество (%s) запрещенных IP-адресов.", $MAX_IP_QNTY) . "\n";
    }
    return $errors;
}

sub _validate_sms_notification {
    my ($model) = @_;
    my @errors;
    my ($time_from, $time_to);
    my $multiplicity = 15;
    if (defined $model->{sms_time_hour_from} && defined $model->{sms_time_min_from}) {
        push @errors, iget("Время начала периода отправки SMS задано неверно")
            unless _is_valid_sms_time($model->{sms_time_hour_from}, $model->{sms_time_min_from});
        if (_is_valid_sms_time($model->{sms_time_hour_from}, $model->{sms_time_min_from})) {
            push @errors, iget("Минуты времени начала периода отправки SMS должны быть кратны %s", $multiplicity)
                if  $model->{sms_time_min_from} % $multiplicity != 0;
        }
    }
    if (defined $model->{sms_time_hour_to} && defined $model->{sms_time_min_to}) {
        push @errors, iget("Время окончания периода отправки SMS задано неверно")
            unless _is_valid_sms_time($model->{sms_time_hour_to}, $model->{sms_time_min_to});
        if (_is_valid_sms_time($model->{sms_time_hour_to}, $model->{sms_time_min_to})) {
            push @errors, iget("Минуты времени окончания периода отправки SMS должны быть кратны %s", $multiplicity)
                if  $model->{sms_time_min_to} % $multiplicity != 0;
        }
    }
    return \@errors;
}

sub _is_valid_sms_time {
    my ($hour, $min) = @_;
    return 0 unless (($hour =~ /^\d+$/) && ($min =~ /^\d+$/));
    return (($hour >= 0 && $hour <= 23 && $min >= 0 && $min <= 59) || ($hour == 24 && $min == 0));
}


sub _validate_email_notification {
    my ($model) = @_;
    my @errors;
    if (exists $model->{money_warning_value}) {
        push @errors, iget("Минимальный баланс, при уменьшении до которого отправляется уведомление должен быть от 1 до 50 %")
            if ($model->{money_warning_value} // 0) < 1 || ($model->{money_warning_value} // 0) > 50
    }
    if (exists $model->{warnPlaceInterval}) {
        push @errors, iget("Периодичность проверки позиции объявления может быть: 15, 30 или 60 минут")
            if ($model->{warnPlaceInterval} // '') !~ /(15|30|60)/;
    }
    return \@errors;
}

=head2

    Параметры именованные
        currency -- валюта для новой кампании
        ...
        new_camp  -- флаг. Должен быть выставлен при проверке совсем новой кампании (без cid'а)
        is_api -- проверка вызывается из АПИ (для использования транслокального дерева АПИ)
        ...

=cut

sub validate_camp
{
    my ($c, $uid, $client_id, %OPT) = @_;
    need_list_context();

    Campaign::convert_dates_for_db($c, keep_source_data => 1, with_old_start_date_format => 1);

    my @errors_arr;

    if ($OPT{new_camp}) {
        my $camp_limit_error = check_add_client_campaigns_limits(ClientID => $client_id);
        if ($camp_limit_error) {
            push @errors_arr, $camp_limit_error;
        }
    }

    push @errors_arr, Models::Campaign::validate_campaign_name($c->{name});

    if (! $c->{mediaType} || camp_kind_in(type => $c->{mediaType}, "web_edit_base")) {
        if (! $c->{email}){
            push(@errors_arr, iget('В поле "Уведомления" не указан e-mail')) ;
        } else {
            if (is_valid_email($c->{email})) {
                push @errors_arr, iget('Превышена допустимая длина email') if length $c->{email} > 255;
            } else {
                push @errors_arr, iget('Неправильный формат e-mail');
            }
        }
    }

    if ($c->{mediaType}
        && camp_kind_in(type => $c->{mediaType}, "internal")) {
        my $vres = undef;
        if (Campaign::is_internal_distrib_camp($c->{mediaType})) {
            $vres = validate_campaign_internal_distrib($c, $OPT{operator_uid});
        }
        if (Campaign::is_internal_free_camp($c->{mediaType})) {
            $vres = validate_campaign_internal_free($c, $OPT{operator_uid});
        }

        if ($vres && !$vres->is_valid) {
            $vres->process_descriptions();
            my @internal_camps_errors = map {$_->description} @{$vres->get_errors};
            push @errors_arr, @internal_camps_errors;
        }
    }

    # DIRECT-64789: костыль до рефакторинга - дропаем невалидный fio
    if (defined $c->{fio} &&  $c->{fio} gt '') {
        my @errors_arr_;
        push @errors_arr_, iget('Превышена допустимая длина имени клиента') if length $c->{fio} > 255;
        push(@errors_arr_, iget('Имя клиента содержит спецсимволы')) if $c->{fio} && ( $c->{fio} =~ /[<>]/ || $c->{fio} =~ /(\P{print})/ );
        push(@errors_arr_, iget('Имя клиента пусто (одни пробелы)')) if $c->{fio} && $c->{fio} =~ m/^\s*$/;
        delete $c->{fio}  if @errors_arr_;
    }

    my $start_ts;
    if ( $c->{start_time} ) {
        $start_ts = eval { ts_round_day( mysql2unix($c->{start_time}) ) };
        push(@errors_arr, iget('Дата старта кампании указана неверно')) unless $start_ts;
    } else {
        push(@errors_arr, iget('Вы должны указать дату старта кампании'));
    }

    if ( !$c->{mediaType} || camp_kind_in(type => $c->{mediaType}, "web_edit_base")) {
        my $finish_ts;
        if ( $c->{finish_time} && $c->{finish_time} !~ /^0000-00-00/ ) {
            # дата окончания кампании может быть не задана
            # время окончания, равное 0000-00-00, означает, что дата окончания кампании не указана
            # это не ошибка, хотя с точки зрения времени значение и не валидно
            $finish_ts = eval { ts_round_day( mysql2unix($c->{finish_time}) ) };
            push(@errors_arr, iget('Дата окончания кампании указана неверно')) unless $finish_ts;
        }

        if ( $start_ts && $finish_ts && $finish_ts < $start_ts ) {
            push(@errors_arr, iget('Дата окончания не может быть меньше Даты начала'));
        }

        # Проверяем, что дата окончания ещё не прошла, только в том случае, когда она изменилась
        # Это нужно, чтобы пользователь имел возможность что-нибудь поменять в старой закончившейся
        # кампании, не запуская её снова
        if ( $finish_ts ) {
            my $old_finish_ts;
            if ( $c->{cid} ) {
                my $old_finish_time = get_one_field_sql(PPC(cid => $c->{cid}), q{SELECT finish_time FROM campaigns WHERE cid = ?}, $c->{cid});
                $old_finish_ts = eval { ts_round_day( mysql2unix($old_finish_time) ) } if $old_finish_time;
            }
            my $is_finish_time_changed = !$old_finish_ts || ($old_finish_ts && $old_finish_ts != $finish_ts) ? 1 : 0;
            if ( $is_finish_time_changed && $finish_ts < ts_round_day(time) ) {
                push(@errors_arr, iget('Дата окончания не может быть меньше текущей даты'));
            }
        }
    }

    my $disabledIps_errors;
    $disabledIps_errors = validate_disabledIps($c->{disabledIps}) if defined $c->{disabledIps};
    push(@errors_arr, $disabledIps_errors) if $disabledIps_errors;

    push(@errors_arr, iget('системная ошибка: неправильный cid кампании')) unless $OPT{new_camp} || $c->{cid} =~ m/^\d+$/;

    my $allow_extended_timetarget = ! $OPT{is_easy} && ( ! $c->{autobudget} || $c->{autobudget} eq 'No' );

    if (my @timetarget_errors = TimeTarget::validate_timetarget($c, $allow_extended_timetarget, $client_id, $OPT{has_new_min_days_limit_flag})) {
        return join ', ', @timetarget_errors;
    }

    $c->{ClientID} = $client_id unless $c->{ClientID};
    my $validate_common_geo_options = $OPT{is_api} ? {tree => 'api'} : {ClientID => $c->{ClientID}};
    if (defined $c->{geo}) {
        # Если установлен Единый регион, то надо проверить этот регион на совместимость с языком кампании.
        hash_copy $validate_common_geo_options, $c, qw/content_lang/;
        my @errors = validate_common_geo($c->{cid}, $c->{geo}, $validate_common_geo_options);
        push(@errors_arr, @errors) if @errors;
    } else {
        # Если Единого региона нет, то проверяем язык на совместимость на региона в группах.
        my @common_lang_errors;
        @common_lang_errors = validate_common_lang($c->{cid}, $c->{content_lang}, $validate_common_geo_options) if defined $c->{content_lang};
        push(@errors_arr, @common_lang_errors) if @common_lang_errors;
    }

    # Проверка на валидность отключённых площадок
    my $client_limits;
    if (defined $c->{DontShow} || defined $c->{disabled_video_placements}) {
        $client_limits = get_client_limits($client_id);
    }

    if (defined $c->{DontShow}) {
        if ($c->{mediaType} && $c->{mediaType} eq 'content_promotion'){
             push(@errors_arr, iget('Для текущего типа кампании нельзя указать запрещенные площадки'));
        } else {
        my @platforms = split /\s*,\s*/ => $c->{DontShow} || '';
        my $vr = Direct::Validation::Domains::validate_disabled_domains(
            \@platforms,
            disable_any_domains_allowed => Client::ClientFeatures::has_disable_any_domains_allowed_feature($client_id),
            disable_mail_ru_domain_allowed => Client::ClientFeatures::has_disable_mail_ru_domain_allowed_feature($client_id),
            disable_number_id_and_short_bundle_id_allowed => Client::ClientFeatures::has_disable_number_id_and_short_bundle_id_allowed_feature($client_id),
            blacklist_size_limit => $client_limits->{general_blacklist_size_limit}
        );
        if (!$vr->is_valid()) {
            $vr->process_descriptions(__generic => {field => iget("'Отключенные площадки'")});
            push @errors_arr, $vr->get_first_error_description;
        }
    }
    }

    if (defined $c->{disabled_video_placements}) {
        my $client_limits = get_client_limits($client_id);
        my $vr = Direct::Validation::Domains::validate_disabled_video_placements(
            $c->{disabled_video_placements},
            disable_any_domains_allowed => Client::ClientFeatures::has_disable_any_domains_allowed_feature($client_id),
            disable_mail_ru_domain_allowed => Client::ClientFeatures::has_disable_mail_ru_domain_allowed_feature($client_id),
            disable_number_id_and_short_bundle_id_allowed => Client::ClientFeatures::has_disable_number_id_and_short_bundle_id_allowed_feature($client_id),
            blacklist_size_limit=>$client_limits->{video_blacklist_size_limit}
        );
        if (!$vr->is_valid()) {
            $vr->process_descriptions(__generic => {field => iget("'Отключенные видео площадки'")});
            push @errors_arr, $vr->get_first_error_description;
        }
    }

    if ($c->{competitors_domains}){
        if ($c->{mediaType} && $c->{mediaType} eq 'content_promotion'){
             push(@errors_arr, iget('Для текущего типа кампании нельзя указать список доменов конкурентов'));
        } else {
        for my $domain ( grep {$_} split(/[\s,]+/, $c->{competitors_domains}) ){
            unless(Yandex::IDN::is_valid_domain($domain)){
                push(@errors_arr, iget("Некорректный домен в списке доменов конкурентов: %s", $domain))
            }
        }
    }
    }

    if ($c->{broad_match_flag}) {
        push(@errors_arr, iget('Неправильно задан расход на поиске Яндекса по дополнительным релевантным фразам'))
            if ($c->{broad_match_limit} < $Campaign::BROAD_MATCH_LIMIT_MIN || $c->{broad_match_limit} > $Campaign::BROAD_MATCH_LIMIT_MAX);
        if (Direct::Validation::Campaigns::validate_broad_match_goal_id($c->{broad_match_goal_id}, $c->{cid})) {
            # Используем кастомный текст (DIRECT-63199)
            push @errors_arr, iget('Цели, используемые в настройках Дополнительных фраз, удалены или стали недоступны для Директа');
        }
    }

    my @metrika_counters_error = Models::Campaign::validate_campaign_metrika_counters(
            $c->{metrika_counters}, $c->{mediaType}, $uid, $OPT{operator_uid}
    );
    my $camp_counters = [split /[\s,]+/ => ($c->{metrika_counters} // '')];

    if (@metrika_counters_error) {
        push @errors_arr, @metrika_counters_error;
    } else {
        # Нет необходимости проверять цели если counters невалидные
        my $strategy_uses_meaningful_goals = Campaign::is_campaign_strategy_use_meaningful_goals_optimization($c->{json_strategy});
        my $is_allowed_to_use_value_from_metrika = Campaign::is_allowed_to_use_value_from_metrika($c->{json_strategy});
        if ($c->{meaningful_goals} || $strategy_uses_meaningful_goals) {
            my $currency = $c->{currency} || $OPT{currency};
            my $vr = Direct::Validation::Campaigns::validate_meaningful_goals(
                $c->{meaningful_goals},
                $c->{cid},
                camp_type                             => $c->{mediaType},
                camp_counters                         => $camp_counters,
                currency                              => $currency,
                check_availability_to_use_in_strategy => $strategy_uses_meaningful_goals,
                is_allowed_to_use_value_from_metrika  => $is_allowed_to_use_value_from_metrika,
            );
            if (!$vr->is_valid) {
                $vr->process_descriptions(__generic => {field => iget("'Ключевые цели'")});
                push @errors_arr, map {$_->description} @{$vr->get_errors};
            }
        }
    }

    if (my $survey_id = $c->{brand_survey_id}) {
        if (!@$camp_counters) {
            push @errors_arr, iget("Для опроса необходимо указать счётчик");
        }
        # no validation here, just rough boundaries
        if (length($survey_id) < 10 || length($survey_id) > 80) {
            push @errors_arr, iget("Некорректный id опроса");
        }
    }

    if ($c->{allowed_page_ids}) {
        # ничто из ниже перечисленного не должно срабатывать ввиду логики конвертацию запроса,
        # валидация сделана на случай если конвертацию кто-то сломает
        if(!ref $c->{allowed_page_ids} eq 'ARRAY' || !@{$c->{allowed_page_ids}}) {
            push @errors_arr, iget('Неправильно задан список площадок допустимых к показу');
        } elsif (!all {/^(\d+)$/ && $_ > 0 } @{$c->{allowed_page_ids}}) {
            push @errors_arr, iget('Неправильно задан id площадки');
        }
    }

    # Проверка таргетинга на устройства
    if (defined $c->{device_targeting}) {
        push(@errors_arr, iget('Указан некорректный таргетинг на устройства')) unless is_valid_device_targeting($c->{device_targeting});
    }

    if (defined $c->{brandSafetyCategories}) {
        my $is_valid = all { is_valid_id($_) && Primitives::get_goal_type_by_goal_id($_) eq 'brandsafety' } @{$c->{brandSafetyCategories}};
        push @errors_arr, iget('Категории Brand Safety заданы не правильно') unless $is_valid;
    }

    if ( $c->{mediaType} eq 'mobile_content' ) {
        if ( defined $c->{mobile_app_id} ) {
            if ( !$OPT{new_camp} && $OPT{campaign_has_mobile_app}) {
                push(@errors_arr, iget('К кампании уже привязано мобильное приложение'));
            } elsif ( $c->{mobile_app_id} && !MobileApps::is_mobile_app_present( $client_id, $c->{mobile_app_id} ) ) {
                push(@errors_arr, iget('Нет такого мобильного приложения'));
            }
        } elsif ( ($OPT{new_camp} || !$OPT{campaign_has_mobile_app}) ) {
            push(@errors_arr, iget('Мобильное приложение не задано'));
        }
    } else {
        if ( defined $c->{mobile_app_id} ) {
            push(@errors_arr, iget('Связывание с мобильным приложением поддерживается только для кампаний рекламы мобильных приложений'));
        }
    }

    if (exists $c->{hierarchical_multipliers}) {
        my $allowed_cpm_multipliers = {
            map { $_ => 1 } qw /
                ab_segment_multiplier
                banner_type_multiplier
                inventory_multiplier
            /, HierarchicalMultipliers::get_expression_multiplier_types()
        };
        if ($c->{mediaType}
            && ( Campaign::is_cpm_campaign($c->{mediaType}) || Campaign::is_internal_campaign($c->{mediaType}))
            && any { !$allowed_cpm_multipliers->{$_} } keys %{$c->{hierarchical_multipliers}}
        ) {
            if (Campaign::is_cpm_campaign($c->{mediaType})) {
                push(@errors_arr, iget('Для CPM-кампаний нельзя указывать данные типы корректировок'));
            } else {
                push(@errors_arr, iget('Для внутренней рекламы нельзя указывать данные типы корректировок'));
            }
        } else {
            my $vr = validate_hierarchical_multipliers($c->{mediaType} // 'text', $c->{ClientID} // get_clientid(uid => $uid), $c->{hierarchical_multipliers});
            if (!$vr->is_valid) {
                push @errors_arr, map { $_->description  } @{$vr->get_errors};
            }
        }
    }

    if (exists $c->{device_type_targeting} || exists $c->{network_targeting}) {
        push @errors_arr, validate_camp_mobile_content(hash_cut($c, qw/device_type_targeting network_targeting/));
    }

    push(@errors_arr, validate_camp_media_options(@_)) if camp_kind_in(type => $c->{mediaType}, "media");

    my $sms_notification_errors = _validate_sms_notification($c);
    push @errors_arr, @$sms_notification_errors;
    my $email_notification_errors = _validate_email_notification($c);
    push @errors_arr, @$email_notification_errors;

    if ($c->{mediaType} && (Campaign::is_cpm_campaign($c->{mediaType}) || Campaign::is_internal_campaign($c->{mediaType}))) {
        my $vr = Direct::Validation::Campaigns::validate_cpm_frequency($c->{rf}, $c->{rfReset});
        if (!$vr->is_valid) {
            $vr->process_descriptions(frequency => {field => iget("'Частота показов'")}, period => {field => iget("'Дни'")});
            push @errors_arr, $vr->get_first_error_description;
        }
    }

    if ($c->{attribution_model}) {
        if ($c->{mediaType} && $c->{mediaType} eq 'mobile_content') {
            push(@errors_arr, iget('Для РМП-кампаний нельзя указывать модель атрибуции'));
        }
        my %attribution_model_check_hash = map {$_ => 1} @Direct::Model::Campaign::ATTRIBUTION_MODELS;
        if (!exists $attribution_model_check_hash{$c->{attribution_model}}) {
            push(@errors_arr, iget('Указана некорректная модель атрибуции'));
        }
    }

    for my $field (qw/broad_match_flag broad_match_limit broad_match_goal_id DontShow competitors_domains hierarchical_multipliers/){
        if ($c->{mediaType} && $c->{mediaType} eq 'cpm_yndx_frontpage' && $c->{$field}) {
            push(@errors_arr, iget("Поля $field не должно существовать"));
        }
    }

    if ($c->{mediaType} && $c->{mediaType} eq 'cpm_yndx_frontpage') {
        if ( ! $c->{allowed_frontpage_types} ) {
            push(@errors_arr, iget('Версия сайта не указана'));
        }
        for my $frontpage_type (@{$c->{allowed_frontpage_types}} ) {
            if (none { $_ eq  $frontpage_type} @PAGE_TYPE_ENUM) {
                push(@errors_arr, iget('Версия сайта содержит неверное значение перечисления'));
            }
        }
    }

    if ($c->{mediaType} && $c->{mediaType} eq 'content_promotion') {
        my $content_promotion_type = CampaignTools::get_content_promotion_content_type($c->{cid});
        if (($content_promotion_type eq 'service' && !Client::ClientFeatures::has_content_promotion_services_allowed_feature($client_id))
            ||
            ($content_promotion_type eq 'eda' && !Client::ClientFeatures::has_eda_content_promotion_interface_feature($client_id))
           ) {
            push(@errors_arr, iget('Кампанию данного типа нельзя редактировать через интерфейс Директа'));
        }
    }

    return @errors_arr;
}


=head2 get_user_banner

    Возвращает один баннер

    $options->{skip_bs_prices} - don't fetch prices from bs

=cut

sub get_user_banner
{
    my ($uid, $bid, $options) = @_;

    my @banners_list = get_user_banner_list($uid, [$bid], $options);
    return scalar(@banners_list) ? $banners_list[0] : undef;
}

sub get_user_banner_list
{
    my ($uid, $bids, $options) = @_;

    $options ||= {};
    unless ( ref $bids eq 'ARRAY' && @$bids && $uid ) {
        return;
    }


    my %BANNERS_OPT = map {$_ => $options->{$_}} qw/get_phrases_statuses not_use_own_stat no_pokazometer_data fairAuction get_all_phrases ctx_from_bs/;
    my $search_options = { uid => $uid,
                           bid => $bids,
                         };
    hash_merge $search_options, hash_cut $options, [qw/adgroup_types/];

    my ($banners) = get_banners(    $search_options,
                                    {
                                      get_add_camp_options => 1,
                                      get_auction => !$options->{skip_bs_prices},
                                      %BANNERS_OPT,
                                      get_tags => $options->{get_tags},
                                      camp_bs_queue_status => $options->{camp_bs_queue_status},
                                    });
    return if ( !defined $banners || ! scalar @{$banners});


    for my $banner (@$banners) {

        my @phrases = @{$banner->{phrases} || []};

        # хак, поскольку эти параметры отличались у старых версий get_user_camp и get_user_banner
        # TODO привести к единообразию со сбором их в get_banners или compile_banner_params
        $banner->{phr} = $banner->{phrases};
        $banner->{phrases} = join ',', map{ $_->{phrase}} @phrases;
    }

    return @$banners;
}

=head2 get_user_camp

    извлекает из базы кампанию вместе с объявлениями

    Параметры
      uid
      cid
      login_rights
      search_options => {
                            bid - ссылка на массив
                            context
                            phrase
                            pid - идентификатор группы
                            group_name - название группы
                            no_banners
                            tab
                            page
                            adgroup_types - массив типов групп, которые необходимо выбирать (["base", "dynamic", "mobile_content"])
                        }
      options => {
                     not_use_own_stat
                     banners_num
                     optimal_banners_num
                     no_pokazometer_data - не запрашивать данные из показометра
                     easy_user
                     get_auction - получать данные торгов из БК (по умолчанию == 1)
                     get_auction_for_search_stop_too — получать данные торгов даже для кампаний с отключенным поиском
                     client_nds -- значение НДС в процентах для клиента-владельца кампании
                                   если указано, все денежные значения будут скорректированы к без-НДСному варианту
                     client_discount -- текущая скидка клиента в процентах
                                        если указан, total и sum будут с учётом скидочного бонуса (сумма которого вернётся в поле bonus)
                     add_banner_oversized_warnings -- добавить флаг предупреждения в баннер, если длина фраз в нем превышает лимит
                     pass_empty_groups => 1 | 0 - выбирать группы без баннеров и представлять их как пустык баннеры {} (по умолчанию 1)
                     get_multiplier_stats => 1 | 0 - выбирать доп. статистику для различных корректировок. (детали в HierarchicalMultipliers::adjustment_bounds())
                     detailed_retargeting_warnings => 1 | 0 - при 1 в ключе {warnings} баннеров будут предупреждения для ретаргетингов в виде хеша
                                                              {text => $text, link => $support_href}
                     show_goal_types => дополнительно возвращать в campaign_goals типы целей (goal_type) и информацию о родительских целях (parent_goal_id)
                 }

    Сколько объявлений извлекается
        если указано $search_options->{no_banners} -- никакие
        если указаны $search_options->{bid} (строка через разделитель) -- только они
        если указана $search_options->{page} (нумерация с 1) -- объявления, попадающие на эту страницу
        иначе -- все

    Сколько объявлений попадает на страницу
        $options->{banners_num}, если указано
        если не указано -- то campaigns.banners_per_page
        если не выставлено -- то $options->{optimal_banners_num}. Может вычисляться как calc_banners_count_per_page(cid)).
            Но странная это система, высчитывать оптимальное количество объявлений где-то снаружи...
            угу, и в медиапланах тот же код снаружи вызывается.
        если не высчитывается -- то $Settings::DEFAULT_BANNERS_ON_PAGE штук.

    Кроме того, в хеше-результате будут
        optimal_banners_on_page -- наша рекомендация, по сколько объявлений на страницу показывать
        banners_on_page -- сколько на самом деле объявлений на страницу сейчас показываем

=cut

sub get_user_camp
{
    my ( $uid, $cid, $login_rights, $search_options, $options ) = @_;

    my $ppc_shard = PPC(cid => $cid);

    $search_options ||= {};
    $options ||= {};

    my @camps;

    return undef unless $cid =~ m/^\d+$/;

    my %getcampinfo_options = map { $_ => $options->{$_} } grep { exists $options->{$_} } qw/client_nds client_discount/;
    my $vars = get_camp_info($cid, $uid, %getcampinfo_options);

    return undef unless $vars && ref($vars) eq 'HASH' && $vars->{cid};
    if ($vars->{till_date}) {
        if ($vars->{autobudget_date} ne '0000-00-00') {
            # задана желаемая дата окончания показов
            $vars->{till_date} = minstr($vars->{till_date},$vars->{autobudget_date});
        }
        $vars->{till_date} = TTTools::format_date($vars->{till_date});
    }

    # после замены sql запроса, который был здесь на get_camp_info, некоторые переменные приходят под другими именами, или в другом формате,
    # в качестве временного решения - переименование и изменени формата
    # TODO привести к единообразию
    $vars->{cname} = $vars->{name};
    $vars->{mediaType} = $vars->{type};
    $vars->{start_time} =~ s/[^\d]//g;
    #####

    $vars->{is_camp_locked} = new LockObject({object_type=>'campaign', object_id=>$cid})->load() ? 1 : 0;
    if( $vars->{autobudget} eq 'Yes' ){
        $vars->{manual_autobudget_sum} =
            get_one_field_sql($ppc_shard, "select manual_autobudget_sum from camp_options where cid = ?", $cid);
        $vars->{manual_autobudget_sum} ||= $vars->{strategy_decoded}->{sum};

    }

    # сбрасываем Brand Lift, если он является скрытым и у оператора нет нужной фичи
    my $is_brand_lift_hidden_enabled = Client::ClientFeatures::get_is_brand_lift_hidden_enabled($login_rights->{ClientID});
    undef $vars->{brand_survey_id} if $vars->{opts}->{is_brand_lift_hidden} && !$is_brand_lift_hidden_enabled;

    hash_merge $vars, CampaignTools::get_campaign_goals($cid, get_goal_types => $options->{goal_types},
        include_multi_goals => Client::ClientFeatures::is_allowed_step_goals_in_strategies($vars->{ClientID}), show_goal_types => $options->{show_goal_types});
    $vars->{campaign}->{meaningful_goals} = delete $vars->{meaningful_goals};

    $vars->{optimal_banners_on_page} = $options->{optimal_banners_num} || $Settings::DEFAULT_BANNERS_ON_PAGE;
    # В некоторых местах шаблоны в клиентской части уже берут optimal_groups_on_page, вычисляем.
    $vars->{optimal_groups_on_page} = $options->{optimal_banners_num} || $Settings::DEFAULT_GROUPS_ON_PAGE;

    my $banners_on_page = $vars->{banners_on_page} = $options->{banners_num} || $vars->{banners_per_page} || $vars->{optimal_banners_on_page};

    $vars->{original_sum} = $vars->{sum};
    $vars->{original_sum_spent} = $vars->{sum_spent};

    $vars->{total} = $vars->{sum} - $vars->{sum_spent};
    $vars->{total} += $vars->{wallet_total} if $vars->{wallet_total};
    $vars->{sum} += $vars->{wallet_sum} if $vars->{wallet_sum};
    # специальный флажок, указывающий, что к суммам самой кампании уже добавлены суммы кошелька.
    # нужен для правильной работы get_camp_status_info
    $vars->{sum_counted_with_wallet} = 1 if $vars->{wallet_sum};

    $vars->{ctr} = ($vars->{shows} && $vars->{clicks}) ? sprintf("%.2f", $vars->{clicks} / $vars->{shows} * 100)  : 0;
    $vars->{av} = ($vars->{clicks} && $vars->{sum_spent}) ? sprintf("%.2f", $vars->{sum_spent} / $vars->{clicks}) : "0.00";

    Campaign::convert_dates_for_template($vars, keep_source_data => 1, with_old_start_date_format => 1);
    if ($vars->{day_budget} && $vars->{day_budget} > 0 && $vars->{OrderID} && $vars->{OrderID} > 0) {
        $vars->{spent_today} = Stat::OrderStatDay::get_order_spent_today($vars->{OrderID});
    }
    $vars->{strategy} = Campaign::campaign_strategy($vars);

    # TODO $vars->{campaign}->{$key} = delete $vars->{$key} if exists $vars->{$key};
    # т.е. удалять ключи с верхнего уровня. Нужна доработка в шаблоне, иначе ломается что-то,
    # например, DIRECT-12543: отображение автобюджетных кампаний
    # кроме шаблонов, надо проверить что удаляемые поля не требуются в CalcCampStatus
    for my $key (
        @Campaign::STRATEGY_FILEDS,
        qw/day_budget_stop_time day_budget_daily_change_count spent_today currency experiment_id brand_survey_id attribution_model/,
        # старые поля стратегии нужны на вёрстке
        qw/autobudget_sum autobudget_bid autobudget_avg_bid autobudget_limit_clicks autobudget_goal_id dontShowYacontext/,
    ) {
        $vars->{campaign}->{$key} =  $vars->{$key} if exists $vars->{$key};
    }
    for my $key (qw/count_all_context_goals status_click_track metrika_counters/) {
        $vars->{campaign}->{$key} = delete $vars->{$key} if exists $vars->{$key};
    }
    # для уницикации с результатом Models::Campaign::get_user_camp_gr
    $vars->{campaign}->{$_} = $vars->{opts}->{$_} ? 1 : 0 for qw/no_title_substitute enable_cpc_hold no_extended_geotargeting is_virtual has_turbo_smarts is_alone_trafaret_allowed require_filtration_by_dont_show_domains has_turbo_app is_universal is_new_ios_version_enabled is_skadnetwork_enabled/;
    delete $vars->{opts};

    hash_merge $vars, count_campaign_items($cid);

    my $sql_part;
    if (!$search_options->{bid} && !$search_options->{tag}) {
    # если указаны $search_options->{bid} (строка через запятую) -- извлекаются только они

        if (!defined $search_options->{tab} && $vars->{tabclass_active_count} == 0 && $vars->{tabclass_decline_count} == 0) {
            $search_options->{tab} = 'all';
        } elsif (!defined $search_options->{tab} && $vars->{tabclass_active_count} == 0) {
            $search_options->{tab} = 'decline';
        }
        $vars->{tab} = $search_options->{tab};
    } else {
        delete $search_options->{tab};
    }

    $vars->{campaign}->{mediaType} = $vars->{mediaType};
    $vars->{campaign}->{tags} = Tag::get_all_campaign_tags($vars->{cid});
    $vars->{campaign}->{untagged_banners_num} = Tag::get_untagged_groups_num($vars->{cid});

    $vars->{money_type} = check_block_money_camp($vars) ? 'blocked' : 'real';
    $vars->{status} = CalcCampStatus($vars, %{hash_cut($options, qw/easy_user/)});
    $vars->{campaign}->{timetarget_coef} = TimeTarget::timetarget_current_coef($vars->{timeTarget}, $vars->{timezone_id});

    my %WARNPLACES;

    if ( !$search_options->{no_banners} ) {

        my ($limit, $offset) = (undef, undef);
        if ( $search_options->{page} && $search_options->{page} =~ /^\d+$/) {
            $limit = $banners_on_page;
            $offset = ($banners_on_page * ($search_options->{page} - 1));
        }

        my $adgroup_types = $search_options->{adgroup_types};
        unless ($adgroup_types) {
            if ($vars->{type} eq 'text') {
                # динамические группы пока по умолчанию не обрабатываем
                $adgroup_types = ["base"];
            } else {
                $adgroup_types = get_camp_supported_adgroup_types(type => $vars->{type});
            }
        }

        my $banners_search_options = hash_merge {
            uid => $uid,
            cid => $cid,
            limit => $limit,
            offset => $offset,
            adgroup_types => $adgroup_types
        }, hash_cut($search_options, qw/bid context phrase pid group_name tab is_bs_rarely_loaded disabled_geo_only/);

        my $banners_options = hash_merge {
            get_auction => (defined $options->{get_auction} ? $options->{get_auction} : 1),
            get_auction_for_search_stop_too => $options->{get_auction_for_search_stop_too},
            get_add_camp_options => 1,
            camp_spent_today => $vars->{spent_today},
            device_targeting => $vars->{device_targeting},
            pass_empty_groups => $options->{pass_empty_groups} // 1,
            get_multiplier_stats => $options->{get_multiplier_stats},
            # получать данные по цене, показам, кликам из БК(для стратегии "отдельное размещение")
            ($vars->{strategy}->{name}||'') eq 'different_places'
                ? (ctx_from_bs => 1, get_all_phrases => 1)
                : (ctx_from_bs => 0)
        }, $options;

        if (Campaign::is_cpm_campaign($vars->{mediaType}) || Campaign::is_internal_campaign($vars->{mediaType})) {
            $banners_options->{get_auction} = 0;
            $banners_options->{get_auction_for_search_stop_too} = 0;
            $banners_options->{no_pokazometer_data} = 1;
        }

        # если указаны метки - выбирать объявления с метками, добавляем условие в поиск баннеров
        if ($search_options->{tag}) {
            $banners_search_options->{tag_id} = $search_options->{tag};
            $vars->{is_search_tags} = 1;
        }
        $banners_options->{get_tags} = 1;

        # TODO: кажется здесь нужна проверка на тип кампании - иначе для МКБ лишние действия совершаем
        my ($banners, $selected_banners_num) = BannersCommon::get_banners($banners_search_options, $banners_options);

        $vars->{tabclass_search_count} = $vars->{all_banners_num} = $selected_banners_num;
        $vars->{pages_num} = int(1 + ($selected_banners_num - 1) / $banners_on_page);

        my @bids = grep {$_} map {$_->{bid}} @$banners;
        my $mod_edited_banners = is_banner_edited_by_moderator_multi(\@bids);

        for my $banner (@{$banners}) {
            if ($vars->{mediaType} ne "mcbanner") {
                # Функция недавно изменена и принимает на вход группы. Так как тут групп еще нет, то составляем входной хеш
                BannerFlags::get_retargeting_warnings_flags( {banners => [$banner]}, detailed => $options->{detailed_retargeting_warnings} );
            }

            # проверяем, был ли баннер отредактирован модератором
            $banner->{is_edited_by_moderator} = $banner->{bid} && $mod_edited_banners->{$banner->{bid}};

            for ( $banner->{bid} ? @{$banner->{phrases}} : () ){
                $_->{place} = PlacePrice::set_new_place_style($_->{place});
                if ( $_->{place} && $_->{place} > 0 && $_->{place} > calcPlace($_->{price}, $_->{guarantee}, $_->{premium}) ) {
                    $WARNPLACES{"_".$banner->{bid}."_".$_->{id}} = $_->{place};
                }
            }

            # хак, вследствие отличия параметров у старых версий get_user_camp и get_user_banner
            # TODO как-то объединить эти параметры в одной функции: get_banners или compile_banner_params
            $banner->{geo_exception} = CheckAdv::check_banner_for_regions($banner->{flags}, geo => $banner->{geo}, ClientID => $vars->{ClientID});

            if ($options->{add_banner_oversized_warnings}) {
                $banner->{is_banner_oversized} = Models::AdGroup::is_group_oversized($banner, client_id => $vars->{ClientID});

                my @bare_phrases = map {$_->{phrase}} @{$banner->{phrases}};
                my $phrase_errors = Direct::Validation::Keywords::base_validate_keywords(\@bare_phrases)->get_errors();
                $banner->{does_phrase_exceed_max_length} = any {$_->name eq 'MaxLength'} @$phrase_errors;
                $banner->{does_phrase_exceed_max_words} = any {$_->name eq 'MaxWords'} @$phrase_errors;
                $banner->{does_phrase_exceed_word_max_length} = any {$_->name eq 'MaxKeywordLength'} @$phrase_errors;
                $banner->{does_phrase_exceed_minus_word_max_length} = any {$_->name eq 'MaxMinusWordLength'} @$phrase_errors;
            }
        }

        $vars->{banners} = $banners if scalar @{$banners};
        # устанавливаем has_banners только если выбрали хотя бы один баннер. если мы не выбрали баннеров, то это ещё не значит, что их нет.
        $vars->{has_banners} = 1 if @{$banners};
        $vars->{warnplaces} = keys %WARNPLACES;
        $vars->{warnplaces_str} = "( {".join(",", map {"\"$_\" : ".$WARNPLACES{$_}} (keys %WARNPLACES))."} )";

        #   Если медийная рекламная кампания
        if ( is_media_camp(type => $vars->{mediaType}) ) {
            #   Выбираем группы баннеров
            $vars->{media_groups} = [ get_media_groups(
                {
                    cid         => $vars->{cid},
                    no_banners  => 0,
                    mediaType   => $vars->{mediaType},
                    tab         => $search_options->{tab},
                }
            ) ];
        }
    }

    if (Campaign::is_cpm_campaign($vars->{mediaType})) {
        $vars->{is_cpv_strategies_enabled} = CampaignTools::is_cpv_strategies_enabled($cid);
    }
    if ($vars->{mediaType} eq 'mcb') {
        $vars->{last_month_shows} = get_one_field_sql( $ppc_shard, "SELECT sum(last_month_shows) from media_groups where cid = ?", $vars->{cid})||0;
        $vars->{lowMonthShowsNoPay} = ($vars->{last_month_shows} and $vars->{last_month_shows} < get_min_month_media_shows(cid => $vars->{cid})) ? 1 : 0 ;
    }

    $vars->{media}{count} = get_one_field_sql( $ppc_shard, "SELECT count(*) FROM mediaplan_banners WHERE cid = ?" , $cid );
    $vars->{exceed_limit_banners} = check_add_client_groups_limits({cid => $cid, new_groups => 1});

    # set constants
    $vars->{MIN_PHRASE_RANK_WARNING} = $Settings::MIN_PHRASE_RANK_WARNING;
    $vars->{MAX_PHRASE_RANK_WARNING} = $Settings::MAX_PHRASE_RANK_WARNING;

    my $limits = get_client_limits($vars->{ClientID});
    $vars->{MAX_BANNER_LIMIT} = $limits->{banner_count_limit};
    $vars->{MAX_KEYWORD_LIMIT} = $limits->{keyword_count_limit};
    $vars->{campaign}->{attribution_model} = get_attribution_model_or_default_by_type($vars);

    return $vars;
}

#-----------------------------------------------------------------------------------------------------

=head2 banner_search_params(\%FORM)

    Формирование хеша параметров поиска баннеров для get_user_camp по данным формы
    Если параметров нет - возвращаем пустой хэш

=cut
sub banner_search_params {
    my ($form, $login_rights) = @_;
    return {} unless defined $form->{search_by};
    my $search_banner;
    if ($form->{search_by} eq 'num' && defined $form->{search_banner} && $form->{search_banner} =~ /\d/) {
        $search_banner = {bid => [ grep {is_valid_int($_, 1, LONG_MAX)} split /\D+/, $form->{search_banner} ]};

        # проверяем, нет ли номеров картинок среди bids
        if ($login_rights->{super_control} || $login_rights->{support_control} || $login_rights->{superreader_control}) {
            my $image_bids = get_hash_sql(PPC(bid => $search_banner->{bid}), ["select image_id, bid from banner_images bim", where => { image_id => SHARD_IDS }]);
            if (%$image_bids) {
                # убираем image_ids, добавляем bids
                $search_banner->{bid} = [ @{(xminus $search_banner->{bid}, [ keys %$image_bids ])}, values %$image_bids ];
            }
        }
    } elsif ($form->{search_by} eq 'context' && defined $form->{search_banner}) {
        $search_banner = {context => $form->{search_banner}};
    } elsif ($form->{search_by} eq 'phrase' && defined $form->{search_banner}) {
        $search_banner = {phrase => $form->{search_banner}};
    } elsif ($form->{search_by} eq 'filter' && defined $form->{search_banner}) {
        my @filter_names = grep { $_ } map { smartstrip2($_) } split /,/, $form->{search_banner};
        my @pids;
        if (@filter_names) {
            # поиск по названию фильтра в performance-кампаниях
            my $filters_by_adgroups = Direct::PerformanceFilters->get_by(
                cid => $form->{cid},
                filter => {'bpf.name__rlike' => join('|', @filter_names)},
            )->items_by("adgroup_id");
            push @pids, keys %{$filters_by_adgroups};
        }
        $search_banner = {pid => \@pids};
    } elsif ($form->{search_by} eq 'group' && defined $form->{search_banner}) {
        # Поиск по группе, по номеру или названию
        if ($form->{search_banner} =~ /^\s*(\d[0-9, ]*)\s*$/) {
            my @pids = split /\D+/, $form->{search_banner};
            push @pids, @{get_one_column_sql(PPC(cid => $form->{cid}), [
                "SELECT pid FROM phrases", WHERE => {cid => $form->{cid}, group_name__contains => $1},
            ])};
            $search_banner = {pid => [grep { is_valid_int($_, 1, LONG_MAX) } @pids]},
        } else {
            $search_banner = {group_name => $form->{search_banner}};
        }
    } elsif ($form->{search_by} eq 'group_attributes') {
        # Поиск по параметрам группы - статусу и/или флагу "мало показов"
        my ($search_rarely_loaded, $search_status) = @$form{qw/search_rarely_loaded search_status/};
        $search_status //= $form->{search_status_json};
        $search_status = [split /\s*,\s*/, $search_status] if !ref $search_status && $search_status =~/,/;
        $search_banner->{is_bs_rarely_loaded} = 1 if $search_rarely_loaded;
        # Для фильтрации по статусу используем Models::AdGroupFilters.
        # В get_groups tab раскроется в список условий и в запрос добавятся таблицы, нужные для проверки этих условий
        $search_banner->{tab} = $search_status if $search_status;
    }
    return $search_banner || {};
}

#-----------------------------------------------------------------------------------------------------

=head2 result

  {
    count => # количество кампаний найденных по where
    campaigns =>
      # ref to array
      [
        # hash with data of our campaing
        {
          cid => ...,
          name => 'asd',
          ....
        },
        # another campaing
        {
          cid => ...,
          ...
        },
        ....
      ]
     wallet_campaigns => [список кампаний кошельков]
  }

  input params:
    %OPT => (
        users_first   # ...

        only_count    # вернуть только количество кампаний
        default_order # сортировка по умолчанию
        order_by      # перечень полей для сортировки
        +order_by     # инкрементируемый перечень полей для сортировки
        limit
        offset
        convert_yes_no_fields -- поля Yes/No превращать в 0/1 (TODO со временем хорошо бы сделать дефолтным режимом работы)
        mediaType     # выбирать кампании только указанного типа/типов (text/mcb/geo/...)
        BS_active     # выбирать только кампании, отправленные в БК (т.е. с OrderID)
        no_subjects   # не выбирать подлежащие кампании (т.е. выбирать только кампании без master_cid в subcampaigns)
        archived => 'Yes'|'No'
        agency_client_id # фильтровать по агентству (по ClientID)
        currency_archived => 1|0 # 1 => будут возвращены кампании из специального архива (оставшиеся в у.е. после конвертации клиента)
                                 # по умолчанию вернутся кампании, не входящие в специальный архив
        client_nds -- значение НДС в процентах для клиента-владельца кампании
                      если указано, все денежные значения будут скорректированы к без-НДСному варианту
        client_discount -- текущая скидка клиента в процентах
                           если указан, total и sum будут с учётом скидочного бонуса (сумма которого вернётся в поле bonus)
        client_currencies => валюты клиента (в виде, возвращаемом функцией get_client_currencies)
                             нужно для отделения кампаний из специального архива (с валютой, отличной от рабочей валюты клиента)
                             функция умеет получать валюты и сама, но лучше передавать их извне

        with_strategy_object => Вернуть стратегию в виде объекта (хеша), а не в виде строки (из Primitives::detect_strategy)

        can_pay_before_moderation => может ли клиент производить оплату до модерации
    )

=cut

sub get_user_camps
{
    my ( $uid, %OPT ) = @_;
    my $opt_vars = {
                mediaType => 'c.type',
                archived => 'c.archived',
    };

    my $only_count = delete $OPT{only_count};
    $OPT{default_order}  = ['c.cid asc'];
    my $order_offset_limit = get_order_offset_limit_sql(\%OPT);
    my %opt_where = map {$opt_vars->{$_} => $OPT{$_}} grep {defined $opt_vars->{$_}} keys %OPT;
    $opt_where{'c.OrderID' . ($OPT{BS_active} ? '__gt' : '')} = 0 if exists $OPT{BS_active};
    $opt_where{'sc.master_cid__is_null'} = 1 if $OPT{no_subjects};

    my $user_info = get_user_data($uid, [qw/login email fio ClientID/]);

    my %currency_archived_condition = (
        'c.type' => get_camp_kind_types('with_currency'),
        _OR => {'c.currency' => 'YND_FIXED', 'c.currency__is_null' => 1}
    );
    if ($OPT{currency_archived}) {
        $opt_where{'c.archived'} = 'Yes';
        $opt_where{_AND} = \%currency_archived_condition;
    } else {
        my $client_currencies = $OPT{client_currencies} || get_client_currencies($user_info->{ClientID}, allow_initial_currency => 1, uid => $uid);
        if ($client_currencies->{work_currency} ne 'YND_FIXED') {
            $opt_where{_NOT} = \%currency_archived_condition;
        }
    }

    # если запросили text-кампании, то дополнительно достаем и wallet-кампании
    if (ref($opt_where{"c.type"}) eq 'ARRAY' && grep {$_ eq 'text'} @{$opt_where{"c.type"}}) {
        push @{$opt_where{"c.type"}}, 'wallet';
    }

    # отдаем по агентству
    if ($OPT{agency_client_id}) {
        $opt_where{'c.AgencyID'} = $OPT{agency_client_id};
    }

    my $camps = get_all_sql(PPC(uid => $uid), [qq{select SQL_CALC_FOUND_ROWS c.cid, c.name, DATE_FORMAT(c.start_time, '%Y%m%d000000') start_time, c.finish_time,
                                       c.statusModerate, c.sum, c.sum_to_pay, c.sum_spent, c.sum - c.sum_spent AS total,
                                       IF(IFNULL(wwc.is_sum_aggregated, "No") = "Yes", c.sum_balance, c.sum) AS sum_balance,
                                       c.sum_spent_units, c.sum_units, (c.sum_units - c.sum_spent_units) as total_units,
                                       c.statusShow, c.statusActive, c.OrderID, c.shows, c.clicks, c.sum_last,
                                       c.ManagerUID, c.AgencyUID, c.statusNoPay, c.statusBsSynced, c.archived,
                                       c.timeTarget, c.timezone_id, co.email, c.statusOpenStat, c.autoOptimization,
                                       c.autobudget, c.autobudget_date,
                                       c.type as mediaType,
                                       c.platform, c.strategy_name, c.strategy_data,
                                       c.rf, c.rfReset, co.camp_description,
                                       IFNULL(c.currency, 'YND_FIXED') currency,
                                       sc.master_cid,
                                       co.stopTime,
                                       co.statusContextStop
                                       , co.statusPostModerate
                                       , co.broad_match_flag
                                       , co.broad_match_goal_id
                                       , IFNULL(c.AgencyID, 0) as AgencyID
                                       , co.statusMetricaControl
                                       , co.strategy
                                       , co.money_warning_value
                                       , co.email_notifications
                                       , co.meaningful_goals
                                       , co.sms_flags
                                       , co.sms_time
                                       , co.status_click_track
                                       , co.mediaplan_status
                                       , (SELECT 1 FROM mediaplan_stats ms WHERE ms.cid = c.cid and ms.create_time >= now() - interval 3 month LIMIT 1) is_new_mediaplan
                                       , IF (c.disabledIps IS NULL, 0, 1) as disabledIpsDefined
                                       , IF (c.DontShow IS NULL, 0, 1) as DontShowDefined
                                       , c.day_budget, c.day_budget_show_mode, co.day_budget_daily_change_count, co.day_budget_stop_time
                                       , (SELECT 1 FROM banners b WHERE b.cid = c.cid LIMIT 1) has_banners
                                       , (SELECT 1 FROM mediaplan_banners mb WHERE mb.cid = c.cid LIMIT 1) has_mediaplan_banners
                                       , (SELECT 1 FROM banners b JOIN phrases ph using(pid)
                                                          WHERE $MTools::IS_ACTIVE_CLAUSE
                                                                AND b.statusArch = 'No'
                                                                AND b.cid = c.cid LIMIT 1 ) is_active
                                       , caq.operation as delayed_arc
                                       , c.ProductID
                                       , c.ContextLimit, c.ContextPriceCoef
                                       , c.uid, u.ClientID
                                       , mc.metrika_counters
                                       , c.currencyConverted
                                       , $Common::CAMP_STOPPED_SQL as camp_stopped
                                       , c.wallet_cid
                                       , IF(c.wallet_cid > 0, 1, 0) as wallet_is_enabled
                                       , wc.day_budget as wallet_day_budget
                                       , wco.day_budget_stop_time as wallet_day_budget_stop_time
                                       , IFNULL(wc.sum, 0) as wallet_sum
                                       , IFNULL(wc.sum_spent, 0) as wallet_sum_spent
                                       , IFNULL(wc.sum_last, 0) as wallet_sum_last
                                       , IFNULL(wc.sum_to_pay, 0) as wallet_sum_to_pay
                                       , IFNULL(wc.sum - wc.sum_spent, 0) wallet_total
                                       , c.opts
                                       , cexp.experiment_id
                                       , co.brand_survey_id
                                       , fc.allowed_frontpage_types
                                       , cp.status_approve
                                from campaigns c
                                       join users u on u.uid = c.uid
                                  left join campaigns wc on c.wallet_cid = wc.cid
                                  left join subcampaigns sc on c.cid = sc.cid
                                  left join camp_options co on c.cid = co.cid
                                  left join camp_options wco on wc.cid = wco.cid
                                  left join wallet_campaigns wwc on (wwc.wallet_cid = IF(c.type = 'wallet', c.cid, c.wallet_cid))
                                  left join camp_operations_queue caq on caq.cid = c.cid
                                  left join camp_metrika_counters mc on mc.cid = c.cid
                                  left join campaigns_experiments cexp on cexp.cid = c.cid
                                  left join campaigns_cpm_yndx_frontpage fc on c.cid = fc.cid
                                  left join campaigns_cpm_price cp on c.cid = cp.cid
                                  },
                                where => {
                                    'c.uid' => $uid,
                                    'c.statusEmpty__ne' => 'Yes',
                                    %opt_where
                                },
                                $order_offset_limit]);

    my $campaigns_count = select_found_rows( PPC(uid => $uid) );
    return {count=>$campaigns_count} if ($only_count);

    mix_manager_data($camps);
    mix_agency_data($camps);

    my @day_budget_camps = grep {($_->{day_budget} || 0) > 0 && $_->{OrderID}} @$camps;
    if (@day_budget_camps && !$OPT{without_spent_today}) {
        # для кампаний с дневным бюджетом массово получаем сегодняшнююю открутку
        my $spent = Stat::OrderStatDay::get_order_spent_today_multi([map {$_->{OrderID}} @day_budget_camps]);
        $_->{spent_today} = $spent->{$_->{OrderID}} || undef for @day_budget_camps;
    }

    my (@campaigns, @wallet_campaigns, %enabled_wallet_campaigns);

    # для медийных кампаний массово вычисляем нужные аттрибуты
    my @media_camps = grep {is_media_camp(type => $_->{mediaType})} @$camps;
    if (@media_camps) {
        my @media_cids = map {$_->{cid}} @media_camps;
        my %has_banners = map {$_ => 1} @{get_one_column_sql(PPC(uid => $uid), [
                                        "SELECT distinct g.cid
                                           FROM media_groups g
                                                JOIN media_banners b ON b.mgid = g.mgid",
                                    WHERE => {'g.cid' => \@media_cids}
                                    ])};
        my %is_active = map {$_ => 1} @{get_one_column_sql(PPC(uid => $uid), ["
                                                        select c.cid
                                                          from campaigns c
                                                               join media_groups g on g.cid = c.cid
                                                               join media_banners b on b.mgid = g.mgid",
                                                         where =>  {
                                                             'c.cid' => \@media_cids,
                                                             'b.statusArch' => 'No',
                                                             _TEXT => $MTools::IS_ACTIVE_MEDIA_CLAUSE,
                                                        }
                                                    ])};
        my $last_month_shows = get_hash_sql(PPC(uid => $uid), [
                                                "SELECT cid, sum(last_month_shows)
                                                   FROM media_groups",
                                                WHERE => {
                                                    cid => \@media_cids,
                                                },
                                                "GROUP BY cid"
                                            ]);
        for my $camp (@media_camps) {
            my $cid = $camp->{cid};
            $camp->{has_banners} = $has_banners{$cid};
            $camp->{is_active} = $is_active{$cid};
            $camp->{last_month_shows} = $last_month_shows->{$cid} || 0;
        }
    }

    # Получим сумму задолженности для общего счета по всем входящим в него кампаниям
    my $sum_debt_all = WalletUtils::get_sum_debt_for_wallets_by_uids([$uid]);
    # вычисляем sums_uni, заранее, т.к. в при неотключаемом ОС - это единственная корректно вычисленная сумма
    # которой можно пользоваться для определения остатка/статуса кампании
    if (@$camps) {
        my $clients_info = Client::get_clients_auto_overdraft_info([uniq map { $_->{ClientID} } @$camps]);
        for my $camp (@$camps) {
            # если будет тормозить - можно прицепить к одному из двух циклов по @$camps выше.
            WalletUtils::calc_camp_uni_sums_with_wallet($camp, $sum_debt_all, $clients_info->{$camp->{ClientID}});
        }
    }
    # массово вычисляем статусы
    my $cid2camp_status = Campaign::CalcCampStatus_mass($camps);

    foreach my $camp (@$camps) {
        my $cid = $camp->{cid};
        Campaign::_deserialize_camp_fields($camp);

        if ( $OPT{convert_yes_no_fields} ){
            for my $field (qw/statusOpenStat/){
                $camp->{$field} = ($camp->{$field} && $camp->{$field} eq 'Yes') ? 1 : 0;
            }
        }

        my $product = product_info(ProductID => $camp->{ProductID});
        hash_copy $camp, $product, qw/product_type Price NDS/;

        if (is_media_camp(type => $camp->{mediaType})) {
            $camp->{lowMonthShowsNoPay} = ($camp->{last_month_shows} and $camp->{last_month_shows} < get_min_month_media_shows(product_type => $product->{product_type})) ? 1 : 0;
        }

        if ($OPT{with_strategy_object}) {
            $camp->{strategy} = Campaign::_compose_campaign_strategy_object($camp);
        } else {
            $camp->{strategy} = detect_strategy($camp);
            my $search_strategy = detect_search_strategy($camp);
            $camp->{search_strategy} = $search_strategy if $search_strategy;
        }

        # calc_camp_uni_sums_with_wallet (до вызова которой нельзя удалять ндс и добавлять бонус) была вызвана выше в отдельном цикле.
        campaign_remove_nds_and_add_bonus($camp, %{hash_cut \%OPT, qw/client_nds client_discount/});

        $enabled_wallet_campaigns{ $camp->{wallet_cid} } = 1 if $camp->{wallet_cid};
        $camp->{wallet_is_enabled} += 0; # convert to int

        Campaign::convert_dates_for_template($camp, keep_source_data => 1, with_old_start_date_format => 1);

        $camp->{status} = $cid2camp_status->{$cid};
        $camp->{pay} = $camp->{statusModerate} eq 'Yes' ? 1 : 0;
        # check if campaign just paid
        $camp->{show} = $camp->{statusShow};
        $camp->{clicks} ||= '-';
        # Сохраняем логин
        $camp->{login} = $user_info->{login};
        $camp->{user_email} = $user_info->{email};
        $camp->{user_fio} = $user_info->{fio};

        my $camp_status = $camp->{statusShow} eq 'Yes'
                          && $camp->{OrderID}
                          && $camp->{archived} eq 'No';

        $camp->{product_type} ||= product_info(cid => $camp->{cid})->{product_type};
        $camp->{mediaTypeHuman} = get_human_media_type($camp->{product_type});

        $camp->{is_active} = $camp_status && $camp->{is_active};
        $camp->{future_camp} = 1 if !$camp->{has_banners} && $camp->{sum} < 0.01 ;

        if ($camp->{mediaType} eq 'wallet' || $camp->{wallet_cid} == 0) {
            # тип денег определяем только для кампаний кошельков или для кампаний без кошельков
            $camp->{money_type} = check_block_money_camp($camp) ? 'blocked' : 'real';
        }

        $camp->{sms_flags} = {map {$_ => 1} split ',', delete $camp->{sms_flags}};
        my ($sms_hour_from, $sms_min_from, $sms_hour_to, $sms_min_to) = string2sms_time($camp->{sms_time});
        $camp->{sms_hour_from} = $sms_hour_from + 0;
        $camp->{sms_hour_to} = $sms_hour_to + 0;
        my %_sms_min2indx = (0 => 0, 15 => 1, 30 => 2, 45 => 3);
        $camp->{sms_min_from} = $_sms_min2indx{$sms_min_from + 0};
        $camp->{sms_min_to} = $_sms_min2indx{$sms_min_to + 0};

        $camp->{email_notifications} = {map {$_ => 1} split ',', delete $camp->{email_notifications}};

        $camp->{opts} = {map {$_ => 1} split ',', $camp->{opts}};

        if ($camp->{mediaType} eq 'wallet') {
            push @wallet_campaigns, $camp;
            $campaigns_count--;

            # Для общих счётов нужен общий остаток с учетом кампаний с задолженностью под счётом
            # Workaround для обратной совместимости, внутри sums_uni уже есть искомая цифра
            $camp->{total} = $camp->{sums_uni}->{total};

            # Добавим кошелек в список разрешенных, даже если нет кампании на него ссылающихся
            $enabled_wallet_campaigns{ $camp->{cid} } = 1 if $OPT{can_pay_before_moderation};
        } else {
            push @campaigns, $camp;
        }
    }

    return {
        campaigns => \@campaigns,
        count => $campaigns_count,
        wallet_campaigns => [grep { $enabled_wallet_campaigns{$_->{cid}} } @wallet_campaigns],
    };
}

=head2 set_optimize_camps_vars (uid, vars, options)

    Проверка возможности пользования услугой первой помощи.
    Модифицируется хэш vars.

    Параметры:
        uid - Идентификатор пользователя,
        vars - хэш, который должен содержать поле campaigns,
        options
            domain - домен интерфейса пользователя
            automatic - флаг, который равен true в случае необходимости вызова автоматических заявок.
            client_currencies -- валюты клиента {work_currency => 'RUB'}

=cut

sub set_optimize_camps_vars {
    my $uid = shift;
    my $vars = shift;
    my %options = @_;

    my $hand_show_teaser = ((User::get_one_user_field($uid, 'show_fa_teaser') || '') eq 'Yes');

    if ($options{domain}) {
        my $tld = get_top_level_domain($options{domain}) || '';
        if ($hand_show_teaser) {
            # Если есть галка показа тизера на ПП, то все равно не показывать, если это com.tr
            return if (grep {$tld eq $_} @Mediaplan::DISALLOW_TEASER_DOMAIN);
        } else {
            # Если галки показа тизера на ПП нет, то все равно не показывать, только есть это не ru или by
            return unless (grep {$tld eq $_} @Mediaplan::ALLOW_TEASER_DOMAIN);
        }
    }
    my $is_serv_client = ServicedClient::is_user_serviced($uid);

    my $no_enable_optimize_camps = 0;
    my $active_banners_count = 0;
    # получаем список кампаний для которых оптимизация доступна
    my $zero_money_border = 0.01;
    my $potenc_camps = get_all_sql(PPC(uid => $uid), "
                        SELECT c.cid
                               , c.sum - c.sum_spent + IF(c.wallet_cid, wc.sum - wc.sum_spent, 0) sum_rest
                               , c.statusModerate
                               , co.statusPostModerate
                               , c.AgencyUID
                          FROM campaigns c
                               left join campaigns wc on wc.cid = c.wallet_cid
                               left join camp_options co on co.cid = c.cid
                         WHERE c.uid = ?
                           AND c.statusEmpty = 'No'
                           AND (c.shows > 0 OR c.sum - c.sum_spent + IF(c.wallet_cid, wc.sum - wc.sum_spent, 0) >= ?)
                           AND c.type = 'text'
                         ", $uid, $zero_money_border);

    my $is_agency_client = scalar grep {$_->{AgencyUID}} @$potenc_camps;

    if (!@{$potenc_camps}
     || @{$potenc_camps} > $Settings::MAX_COUNT_CAMPS_FIRST_AID
     || !(grep {$_->{sum_rest} >= $zero_money_border} @{$potenc_camps})
     || $is_serv_client) {
        $no_enable_optimize_camps = 1;
    } else {
        # считаем число баннеров
        $active_banners_count = get_one_field_sql(PPC(uid => $uid), ['SELECT count(*)
                                                     FROM
                                                        phrases p
                                                        JOIN banners b USING(pid)
                                                    WHERE', {'p.cid' => [map {$_->{cid}} @$potenc_camps]}, '
                                                    GROUP BY p.cid
                                                   HAVING count(*) > ?'], $Settings::MAX_COUNT_BANNERS_FIRST_AID);
    }

    if($is_agency_client || !@{$vars->{campaigns} || []}){
        $no_enable_optimize_camps = 1;
    } else {
        # смотрим была ли уже оптимизация
        # получаем список кампаний которые были оптимизированны. количество может быть > 1
        my $optimized_cids_result = get_all_sql(PPC(uid => $uid), "
                        SELECT c.cid, o.status, o.is_automatic, o.req_type, co.statusPostModerate,
                            if(o.create_time >= now() - interval 3 month, 1, 0) is_new_optimizing_request
                          FROM campaigns c
                               left join camp_options co using(cid)
                               JOIN optimizing_campaign_requests o ON o.cid = c.cid
                         WHERE c.uid = ?
                           AND c.statusEmpty = 'No'
                           AND o.status NOT IN ('AcceptDeclined', 'Converted')
                           AND co.statusPostModerate != 'Yes'
                         ", $uid);
        my %optimized_cids;
        for(@$optimized_cids_result){
            $optimized_cids{$_->{cid}} = {cid => $_->{cid}, status => $_->{status}, is_automatic => $_->{is_automatic}, req_type => $_->{req_type}, is_new_optimizing_request => $_->{is_new_optimizing_request}};
        }

        # высталяем флаг optimized у кампаний для отображения флажка около кампании в пользовательском интерфейсе
        if (@$optimized_cids_result) {
            for(@{$vars->{campaigns}}){
                if (exists $optimized_cids{$_->{cid}}){
                    $_->{optimized} = 1;
                    $_->{optimized_status} = $optimized_cids{$_->{cid}}->{status};
                    $_->{is_new_optimizing_request} = $optimized_cids{$_->{cid}}->{is_new_optimizing_request};
                }
            }
            $vars->{optimize_camp}->{already_optimized} = @$optimized_cids_result ? 1 : 0;

        } else {
            $vars->{optimize_camp}->{to_much_banners} = $active_banners_count if ($active_banners_count && !$no_enable_optimize_camps);
        }
    }

    my @pcamps = filter_full_campaigns(grep {$_->{sum_rest} >= $zero_money_border}  @{$potenc_camps});
    my %pcamps;
    if ($options{automatic}) {
        # Проверяем на корректность языка. У пользователя могут быть только русские и английские баннеры.
        my $cids_langs = Common::get_camps_banners_lang([map {$_->{cid}} @pcamps]);
        %pcamps = map {$_->{cid} => $_} grep {Mediaplan::is_allow_FA_lang($cids_langs->{$_->{cid}})} @pcamps;
    } else {
        %pcamps = map {$_->{cid} => $_} @pcamps;
    }
    my $show_teaser;
    if (scalar(values(%pcamps)) && !$vars->{optimize_camp} || $hand_show_teaser) {
        # Всем кампаниям, которые могут быть оптимизированы проставляем соответствующий флаг.
        foreach my $camp (@{$vars->{campaigns}}) {
            $camp->{may_be_optimized} = 1 if $pcamps{$camp->{cid}};
            $show_teaser = 1;
        }
    }

    $vars->{optimize_camp}->{no_enable_optimize_camps} = $no_enable_optimize_camps if $no_enable_optimize_camps;

    if (!$vars->{optimize_camp} && $show_teaser
        && $hand_show_teaser && any {$_->{statusPostModerate} eq 'Accepted'} values %pcamps) {
        $vars->{optimize_camp}->{show_teaser} = 1;
    }

    $vars->{optimize_camp}->{req_type} = 'FirstAid';
}


=head2 expose_cid_to_search_where($cids)

    По номерам кампаний построить условия их выборки.
    Для кампаний-кошельков список кампаний раскрывается до всех кампаний под этим кошельком

    Результат:
        \%where - хеш с условиями для выборки

=cut

sub expose_cid_to_search_where {
    my $cids = shift;

    my $camps_types = Campaign::Types::get_camp_type_multi(cid => $cids);
    my $wallet_cids = [uniq grep {$camps_types->{$_} eq 'wallet'} keys %$camps_types];
    my $non_wallet_cids = [uniq grep {$camps_types->{$_} ne 'wallet'} @$cids];

    my %where;
    if (@$wallet_cids && @$non_wallet_cids) {
        $where{'_OR'} = [
            'c.cid' => $non_wallet_cids,
            'c.wallet_cid' => $wallet_cids
        ];
    } elsif (@$non_wallet_cids) {
        $where{'c.cid'} = $non_wallet_cids;
    } elsif (@$wallet_cids) {
        $where{'c.wallet_cid'} = $wallet_cids;
    }

    return \%where;
}

#-----------------------------------------------------------------------------------------------------

=head2 get_user_camps_by_sql

  {
    count => # количество кампаний найденных по where
    campaigns =>
      # ref to array
      [
        # hash with data of our campaign
        {
          cid => ...,
          name => 'asd',
          ....
        },
        # another campaign
        {
          cid => ...,
          ...
        },
        ....
      ]
  }

  input params:
    $opts => {
        users_first   # ...
        form          # form

        only_count    # вернуть только количество кампаний
        default_order # сортировка по умолчанию
        order_by      # перечень полей для сортировки
        +order_by     # инкрементируемый перечень полей для сортировки
        limit
        offset
        convert_yes_no_fields -- поля Yes/No превращать в 0/1 (TODO со временем хорошо бы сделать дефолтным режимом работы)
        currencyConverted => 'Yes'|'No'
        client_nds -- значение НДС в процентах для всех владельцев кампании (только если заранее известно, что все кампании принадлежат одному клиенту)
                      если указано, все денежные значения будут скорректированы к без-НДСному варианту
        client_discount -- текущая скидка клиента в процентах (только если заранее известно, что все кампании принадлежат одному клиенту)
                           если указан, total и sum будут с учётом скидочного бонуса (сумма которого вернётся в поле bonus)
        remove_nds -- если 1, то суммы на кампаниях будут без НДС. НДС клиентов возьмёт из базы.
        add_discount_bonus -- если 1, то total и sum будут включать в себя скидочный бонус (сумма которого вернётся в поле bonus)
                              Скидку клиентов возьмёт из базы.
        shard          -- номер шарда, в котором следует искать, если применимо. В части кода sql_where идет как строка.
                          Также, не всегда очевидно, из запроса какой шард надо использовать, так как поля иногда приходят как u.uid (не просто uid) или c.cid (не просто cid)
        total_with_wallet -- считать суммы на кампании с подключенным общим счетом
        include_empty_campaigns -- выбирать также пустые (statusEmpty) кампании
        dont_calc_status -- не вычислять статус ($camp->{status})
        dont_calc_has_active_banners -- не вычислять has_active_banners
    }

=cut

sub get_user_camps_by_sql
{
    my ($sql_where, $opts) = @_;
    $opts ||= {};

    my %shard = %{$opts->{shard}};

    die "No Shard is defined" unless %shard;

    my $users_first     = delete $opts->{users_first}     || 0;
    my $form            = delete $opts->{form}            || {};
    my $join            = delete $opts->{join}            || '';
    my $shard           = delete $opts->{shard}           || {};
    my $strategy_fields = delete $opts->{strategy_fields} || '';

    die "No Shard is defined" unless %$shard;

    my $only_count = delete $opts->{only_count};
    $opts->{default_order}  = ['c.ManagerUID desc','c.uid asc'];
    if ( $opts->{group_by_currency} ){
        $opts->{'+order_by'} ||= [];
        unshift @{$opts->{'+order_by'}}, sql_expr_for_currency_sorting('c.currency');
    }
    my $order_offset_limit_sql = get_order_offset_limit_sql($opts);
    my $order_offset_limit_offset_to_limit_sql = get_order_offset_limit_sql(hash_merge {}, $opts, {offset => 0, $opts->{limit} ? (limit => ($opts->{offset} || 0) + $opts->{limit}) : ()});
    my $order_offset_limit = get_order_offset_limit($opts);

    my %opt_where;
    if (!$opts->{include_empty_campaigns}) {
        $opt_where{'c.statusEmpty__ne'} = 'Yes';
    }
    if (defined $opts->{currencyConverted}) {
        $opt_where{'c.currencyConverted'} = $opts->{currencyConverted};
    }

    my $tables = $users_first ? 'users u JOIN campaigns c ON c.uid = u.uid' : 'campaigns c JOIN users u ON c.uid = u.uid';
    my $sharded_ppc = PPC(%$shard);
    my $is_one_shard_only = @{$sharded_ppc->{dbnames}} <= 1 ? 1 : 0;

    my $select_fields = '';
    if (@{$order_offset_limit->{order_by}}) {
        for (my $i = 0; $i < @{$order_offset_limit->{order_by}}; $i++) {
            $select_fields .= ", $order_offset_limit->{order_by}->[$i]->{field} as _o$i\n";
        }
    }

    my $camps_list = get_all_sql($sharded_ppc, [qq/SELECT SQL_CALC_FOUND_ROWS STRAIGHT_JOIN
                                       c.cid, c.name, DATE_FORMAT(c.start_time, '%Y%m%d000000') start_time, c.finish_time, c.statusModerate,
                                       IFNULL(c.currency, 'YND_FIXED') AS currency,
                                       c.sum, c.sum_to_pay, c.sum_spent,
                                       c.sum - c.sum_spent as total,
                                       c.sum_spent_units, c.sum_units, (c.sum_units - c.sum_spent_units) as total_units,
                                       c.wallet_cid,
                                       IF(c.wallet_cid > 0, 1, 0) as wallet_is_enabled,
                                       IF(c.wallet_cid > 0, wc.sum, 0) as wallet_sum,
                                       IF(c.wallet_cid > 0, wc.sum_spent, 0) as wallet_sum_spent,
                                       IF(c.wallet_cid > 0, wc.sum - wc.sum_spent, 0) as wallet_total,
                                       IF(c.wallet_cid > 0, wc.sum_last, 0) as wallet_sum_last,
                                       IF(c.wallet_cid > 0, wc.sum_to_pay, 0) as wallet_sum_to_pay,
                                       c.statusShow, c.statusActive, c.OrderID, c.shows, c.clicks, c.sum_last,
                                       c.platform, c.strategy_name, c.strategy_data,
                                       c.uid, c.archived,
                                       u.login, u.fio user_fio, u.email user_email,
                                       c.rf, c.rfReset,
                                       c.statusNoPay, c.statusBsSynced
                                       , c.timeTarget, c.timezone_id, c.statusOpenStat, c.autoOptimization
                                       , c.autobudget
                                       , c.autobudget_date
                                       , c.ContextLimit
                                       , c.ContextPriceCoef
                                       , c.type
                                       , c.type as mediaType
                                       , u.ClientID
                                       , c.ManagerUID
                                       , c.AgencyUID
                                       , IFNULL(c.AgencyID, 0) as AgencyID
                                       , c.strategy_id
                                       , co.FIO
                                       , co.email
                                       , co.stopTime
                                       , co.minus_words
                                       , co.statusPostModerate
                                       , co.placement_types
                                       , co.broad_match_flag
                                       , co.broad_match_goal_id
                                       , co.broad_match_limit
                                       , co.statusContextStop
                                       , co.statusMetricaControl
                                       , co.strategy
                                       , co.warnPlaceInterval
                                       , co.money_warning_value
                                       , co.sendWarn
                                       , co.sendAccNews
                                       , co.sms_flags
                                       , co.sms_time
                                       , co.eshows_video_type
                                       , co.status_click_track
                                       , co.fairAuction = 'Yes' fairAuction
                                       , caq.operation as delayed_arc
                                       , c.disabledIps
                                       , c.DontShow
                                       , IF (c.disabledIps IS NULL, 0, 1) as disabledIpsDefined
                                       , IF (c.DontShow IS NULL, 0, 1) as DontShowDefined
                                       , c.disabled_ssp
                                       , c.ProductID
                                       , c.day_budget, c.day_budget_show_mode, co.day_budget_daily_change_count, co.day_budget_stop_time
                                       , wc.day_budget as wallet_day_budget
                                       , wco.day_budget_stop_time as wallet_day_budget_stop_time
                                       , c.currencyConverted
                                       , c.opts
                                       , cmc.is_installed_app
                                       , cmc.device_type_targeting
                                       , cmc.network_targeting
                                       , cmc.mobile_app_id
                                       , c.lastShowTime
                                       , c.attribution_model
                                       , c.ab_segment_ret_cond_id
                                       , c.ab_segment_stat_ret_cond_id
                                       , perf_camp.now_optimizing_by
                                       , $Common::CAMP_STOPPED_SQL as camp_stopped
                                       , co.meaningful_goals
                                       , ccp.status_approve
                                       $strategy_fields
                                       $select_fields
                                  from $tables
                                       LEFT JOIN camp_options co on co.cid = c.cid
                                       left join camp_operations_queue caq on caq.cid=c.cid
                                       left join campaigns wc on c.wallet_cid = wc.cid
                                       left join camp_options wco on wc.cid = wco.cid
                                       left join wallet_campaigns on c.wallet_cid = wallet_campaigns.wallet_cid
                                       left join campaigns_mobile_content cmc on cmc.cid = c.cid
                                       left join campaigns_performance perf_camp on perf_camp.cid = c.cid
                                       left join campaigns_cpm_price ccp on ccp.cid = c.cid
                                       $join
                                  /,
                                 where => hash_merge ($sql_where, \%opt_where),
                                    ($is_one_shard_only ? $order_offset_limit_sql : $order_offset_limit_offset_to_limit_sql)]);
    unless ($is_one_shard_only) {
        $camps_list = overshard(
            @{$order_offset_limit->{order_by}} ?
            (order => [map
                { my $i = $_;
                  my $item = $order_offset_limit->{order_by}->[$i];
                  (lc($item->{dir}) eq 'desc' ? '-' : '')
                  . "_o$i"
                  . (($item->{field} =/(^|\W)(cid|uid|ClientID|sum|sum_spent|shows|clicks|sum_last)(\W|$)/i
                      && (!$camps_list
                          || !@$camps_list
                          || !exists $camps_list->[0]->{"_o$i"}
                          || $camps_list->[0]->{"_o$i"} !~ /[^\d\.e\-\+]/i
                        )
                    ) ? ':num' : '')
                } (0 .. $#{$order_offset_limit->{order_by}})
            ]) : (),
            $order_offset_limit->{offset} ? (offset => $order_offset_limit->{offset}) : (),
            $order_offset_limit->{limit} ? (limit => $order_offset_limit->{limit}) : (),
            $camps_list
        );
    }
    my @arr;
    my $campaigns_count = select_found_rows($sharded_ppc);

    return {count=>$campaigns_count} if ($only_count);

    my $camps_uids = [uniq map { $_->{uid} } @$camps_list];
    # Получим сумму задолженности для общего счета по всем входящим в него кампаниям
    my $sum_debt_all = WalletUtils::get_sum_debt_for_wallets_by_uids($camps_uids);

    my $camp_has_banners = mass_camps_has_banners($camps_list);

    my @camps_with_banners = grep { $camp_has_banners->{ $_->{cid} } } @$camps_list;
    my $camp_has_active_banners;
    if (! $opts->{dont_calc_has_active_banners}) {
        $camp_has_active_banners = Models::Banner::mass_has_camps_active_banners(
            [ map { $_->{cid} } @camps_with_banners ],
            { map { $_->{cid} => $_->{mediaType} || $_->{type} } @camps_with_banners } );
    }

    #Получим uid-ы фрилансеров, для кампаний сопровождаемых клиентов
    my $fl_uid_by_uid = RBACDirect::mass_get_uid_of_related_freelancer($camps_uids);
    my $user_info_by_fl_id;
    #Если есть кампании под фрилансера - получим для фрилансеров user_info
    if (keys %$fl_uid_by_uid){
        $user_info_by_fl_id = Primitives::get_users_list_info([values %$fl_uid_by_uid]);
    }

    my (%client_nds_cache, %client_discount_cache);
    my $clients_info;
    if (@$camps_list) {
        $clients_info = Client::get_clients_auto_overdraft_info([uniq map { $_->{ClientID} } @$camps_list]);
    }

    if (!$opts->{without_spent_today}) {
        my @camps_to_calc_spent = grep { $_->{day_budget} && $_->{day_budget} > 0 && $_->{OrderID} && $_->{OrderID} > 0 } @$camps_list;
        my $orders_spent_today = Stat::OrderStatDay::get_order_spent_today_multi([map { $_->{OrderID} } @camps_to_calc_spent]);
        foreach my $camp ( @camps_to_calc_spent ) {
            $camp->{spent_today} = $orders_spent_today->{$camp->{OrderID}};
        }
    }

    foreach my $camp ( @$camps_list ) {
        Campaign::_deserialize_camp_fields($camp);

        #Для кампаний под фрилансером добавим freelancer_info
        if ($fl_uid_by_uid->{$camp->{uid}}){
            $camp->{freelancer_info} = $user_info_by_fl_id->{$fl_uid_by_uid->{$camp->{uid}}}
        }

        if ( $opts->{convert_yes_no_fields} ){
            for my $f (qw/statusOpenStat/){
                $camp->{$f} = $camp->{$f} eq 'Yes' ? 1 : 0;
            }
        }

        my $product = product_info(ProductID => $camp->{ProductID});
        hash_copy $camp, $product, qw/product_type/;

        $camp->{strategy} = detect_strategy($camp);
        my $search_strategy = detect_search_strategy($camp);
        $camp->{search_strategy} = $search_strategy if $search_strategy;

        my $client_id = $camp->{ClientID};

        WalletUtils::calc_camp_uni_sums_with_wallet($camp, $sum_debt_all, $clients_info->{$camp->{ClientID}});

        if ($camp->{currency} ne 'YND_FIXED') {
            my ($client_nds, $client_discount);
            if ($opts->{remove_nds}) {
               $client_nds_cache{$client_id} = get_client_NDS($client_id) unless exists $client_nds_cache{$client_id};
               $client_nds = $client_nds_cache{$client_id};
            } else {
                $client_nds = $opts->{client_nds};
            }
            if ($opts->{add_discount_bonus}) {
               $client_discount_cache{$client_id} = get_client_discount($client_id) unless exists $client_discount_cache{$client_id};
               $client_discount = $client_discount_cache{$client_id};
            } else {
                $client_discount = $opts->{client_discount};
            }
            campaign_remove_nds_and_add_bonus($camp, client_nds => $client_nds, client_discount => $client_discount, sums_with_include_nds => $opts->{sums_with_include_nds});
        }

        if ($opts->{total_with_wallet} && $camp->{wallet_cid}) {
            $camp->{total} = $camp->{wallet_total} + $camp->{total};
            $camp->{sum} = $camp->{wallet_sum} + $camp->{sum};
            $camp->{sum_spent} = $camp->{wallet_sum_spent} + $camp->{sum_spent};
            # специальный флажок, указывающий, что к суммам самой кампании уже добавлены суммы кошелька.
            # нужен для правильной работы get_camp_status_info
            $camp->{sum_counted_with_wallet} = 1;
        }

        Campaign::convert_dates_for_template($camp, keep_source_data => 1, with_old_start_date_format => 1);

        $camp->{has_banners} = $camp_has_banners->{ $camp->{cid} };
        if ( $camp->{has_banners} && !$opts->{dont_calc_has_active_banners}) {
            $camp->{has_active_banners} = $camp_has_active_banners->{ $camp->{cid} };
        }

        $camp->{status} = CalcCampStatus($camp) unless $opts->{dont_calc_status};
        $camp->{pay} = $camp->{statusModerate} eq 'Yes' ? 1 : 0;
        # check if campaign just paid
        $camp->{add_money} = $form->{"sum_$camp->{cid}"};
        $camp->{product_type} ||= product_info(cid => $camp->{cid})->{product_type};
        $camp->{mediaTypeHuman} = get_human_media_type($camp->{product_type});
        if ( $camp->{mediaType} eq 'mcb' ) {
            $camp->{last_month_shows} = get_one_field_sql( PPC(uid => $camp->{uid}), "SELECT sum(last_month_shows) from media_groups where cid = ?", $camp->{cid})||0;
            $camp->{lowMonthShowsNoPay} = ($camp->{last_month_shows} and $camp->{last_month_shows} < get_min_month_media_shows(cid => $camp->{cid})) ? 1 : 0;
        }

        $camp->{strategy} = detect_strategy($camp);
        $camp->{wallet_is_enabled} += 0; # convert to int
        $camp->{opts} = {map {$_ => 1} split ',', $camp->{opts}};

        $camp->{minus_words} = MinusWordsTools::minus_words_str2array($camp->{minus_words});

        $camp->{attribution_model} = get_attribution_model_or_default_by_type($camp);

        push @arr, $camp;
    }
    return { campaigns=>\@arr, count=>$campaigns_count };
}

=head2 get_user_camps_for_yamoney

    список кампаний, пригодных для оплаты ЯД-ом
    с нетривиальной сортировкой

=cut

sub get_user_camps_for_yamoney {
    my ($client_chief_uid) = @_;

    my %where_cond = (
        'c.uid' => $client_chief_uid,
        'c.type' => 'text',
        'c.archived' => 'No',
        'c.statusNoPay' => 'No',
        _OR => {'c.statusModerate' => 'Yes', 'c.ManagerUID__gt' => 0},
        'c.AgencyUID__is_null' => 1,
        'u.ClientID__gt' => 0,
    );
    my @order_by = (
        q|IF(c.statusShow = 'Yes', 0, 1)|,
        q|IF(c.sum >= 0.01, 0, 1)|,
        q|(c.sum - c.sum_spent) / IF(c.sum_last > 0, c.sum_last, 1)|,
        q|DATE(c.lastShowTime) DESC|,
        q|c.start_time DESC|,
    );
    my $user_camps = get_user_camps_by_sql(\%where_cond, {order_by => \@order_by, shard => {uid => $client_chief_uid}});
    my $campaigns = $user_camps->{campaigns};

    for my $camp (@$campaigns) {
        # нужно ли подсвечивать нехватку средств
        $camp->{sum_rest} = $camp->{total};
        $camp->{money_warn}
            = $camp->{sum_last} > 0 && $camp->{sum} > 0 && $camp->{sum_rest} > 0
              && $camp->{sum_rest} / $camp->{sum_last} < 0.1;
    }
    return $campaigns;
}

#-------------------------------------------------------------------------------

=head2 get_agency_camps

  достаем все кампании всех не архивных клиентов по агентству.
  используется только в cmd_showSubClientCamps

  {
    count => # количество кампаний найденных по where
    capmaigns =>
      # ref to array
      [
        # hash with data of our campaing
        {
          cid => ...,
          name => 'asd',
          ....
        },
        # another campaing
        {
          cid => ...,
          ...
        },
        ....
      ]
  }

  input params:
    $opts => {
        users_first   # ...

        only_count    # вернуть только количество кампаний
        default_order # сортировка по умолчанию
        order_by      # перечень полей для сортировки
        +order_by     # инкрементируемый перечень полей для сортировки
        limit
        offset
    }

=cut

sub get_agency_camps
{
    my ($form, $agency_chief_uid, $agencies_uids, $subclients_uids, $archived, $opts) = @_;

    my $only_count = delete $opts->{only_count};

    my $postsort; # Флажок постсортировки (используется для сортировки по суммам, в том числе в разных валютах)
    my ($order_offset_limit_sql, $order_offset_limit_offset_to_limit_sql, $order_offset_limit);
    my $select_fields = '';
    if (defined $form->{sort} && any { $form->{sort} eq $_ } qw/sum total/) {
        $postsort = 1;
        $order_offset_limit = get_order_offset_limit($opts);
    } else {
        $opts->{default_order}  = ['c.cid asc'];
        $opts->{'+order_by'} ||= [];
        unshift @{$opts->{'+order_by'}}, sql_expr_for_currency_sorting('c.currency'); # верхняя сортировка -- по валюте
        $order_offset_limit_sql = get_order_offset_limit_sql($opts);
        $order_offset_limit_offset_to_limit_sql = get_order_offset_limit_sql(hash_merge {}, $opts, {offset => 0, $opts->{limit} ? (limit => ($opts->{offset} || 0) + $opts->{limit}) : ()});
        $order_offset_limit = get_order_offset_limit($opts);

        if (@{$order_offset_limit->{order_by}}) {
            for (my $i = 0; $i < @{$order_offset_limit->{order_by}}; $i++) {
                $select_fields .= ", $order_offset_limit->{order_by}->[$i]->{field} as _o$i\n";
            }
        }
    }

    my %shard_cond = (shard => 'all');
    my %where = ();

    # Если это не МКБ, то считать еще и кампании типа общий счет
    $where{'c.type'} = $opts->{mediaType} if $opts->{mediaType};
    if (!camp_kind_in(type => 'mcb', $opts->{mediaType}) || ! $only_count) {
        $where{'c.type'} = get_camp_kind_types($opts->{mediaType},'wallet');
    }

    if ( ref $subclients_uids eq 'ARRAY' && @{$subclients_uids} ) {
        %shard_cond = (uid => $subclients_uids);
        $where{'u.uid'} = SHARD_IDS;
    }
    my $sharded_ppc = PPC(%shard_cond);
    my $is_one_shard_only = dbnames($sharded_ppc) <= 1 ? 1 : 0;

    my $camps_list = get_all_sql($sharded_ppc, [qq{select SQL_CALC_FOUND_ROWS
                                       c.cid
                                       , c.name
                                       , DATE_FORMAT(c.start_time, '%Y%m%d000000') start_time
                                       , c.finish_time
                                       , c.statusModerate
                                       , IFNULL(c.currency, 'YND_FIXED') AS currency
                                       , c.sum
                                       , c.sum_to_pay
                                       , c.sum_spent
                                       , c.sum - c.sum_spent AS total
                                       , c.wallet_cid
                                       , IF(c.wallet_cid, wc.sum, 0) as wallet_sum
                                       , IF(c.wallet_cid, wc.sum_spent, 0) as wallet_sum_spent
                                       , IF(c.wallet_cid, wc.sum + wc.sum_spent, 0) as wallet_total
                                       , c.sum_spent_units
                                       , c.sum_units
                                       , (c.sum_units - c.sum_spent_units) as total_units
                                       , c.statusShow
                                       , c.statusActive
                                       , c.OrderID
                                       , c.shows
                                       , c.clicks
                                       , c.sum_last
                                       , c.uid
                                       , u.login login
                                       , u.fio user_fio
                                       , u.email user_email
                                       , c.statusNoPay
                                       , c.statusBsSynced
                                       , c.timeTarget
                                       , c.timezone_id
                                       , c.statusOpenStat
                                       , c.autoOptimization
                                       , c.type as mediaType
                                       , c.platform
                                       , IFNULL(s.type, 'default') as strategy_name
                                       , IFNULL(s.strategy_data, '{"name":"default"}') as strategy_data
                                       , c.rf
                                       , c.rfReset
                                       , co.stopTime
                                       , c.archived
                                       , co.statusPostModerate
                                       , co.broad_match_flag
                                       , co.broad_match_goal_id
                                       , caq.operation as delayed_arc
                                       , co.statusContextStop
                                       , co.statusMetricaControl
                                       , IF (c.disabledIps IS NULL, 0, 1) as disabledIpsDefined
                                       , IF (c.DontShow IS NULL, 0, 1) as DontShowDefined
                                       , c.ProductID
                                       , c.day_budget
                                       , c.day_budget_show_mode
                                       , co.day_budget_daily_change_count
                                       , co.day_budget_stop_time
                                       , wc.day_budget as wallet_day_budget
                                       , wco.day_budget_stop_time as wallet_day_budget_stop_time
                                       , c.currencyConverted
                                       , c.ManagerUID
                                       , c.AgencyUID
                                       , u.ClientID
                                       , $Common::CAMP_STOPPED_SQL as camp_stopped
                                       $select_fields
                                from campaigns c
                                     left join campaigns wc on wc.cid = c.wallet_cid
                                     left join agency_lim_rep_clients alrc on alrc.ClientID = c.ClientID
                                     join users u on c.uid = u.uid
                                     left join camp_options co on co.cid = c.cid
                                     left join camp_options wco on wco.cid = c.wallet_cid
                                     left join agency_client_relations acr on acr.agency_client_id = c.AgencyID
                                                                          and acr.client_client_id = u.ClientID
                                     left join camp_operations_queue caq on caq.cid=c.cid
                                     left join strategies s on c.strategy_id = s.strategy_id},
                                     where => { _OR => { 'c.AgencyUID' => $agencies_uids, _AND => { 'c.AgencyUID' => $agency_chief_uid, 'alrc.agency_uid' => $agencies_uids } },
                                               'c.statusEmpty__ne' => 'Yes',
                                               'c.type__ne' => 'geo',
                                               'c.archived' => ($archived ? "Yes" : "No"),
                                               %where },
                                               "AND IFNULL(acr.client_archived, 'No') = 'No'",
                                    !$postsort ? ($is_one_shard_only ? $order_offset_limit_sql : $order_offset_limit_offset_to_limit_sql) : (),
                                ]
                      );
    my @arr;
    my $campaigns_count = select_found_rows($sharded_ppc);
    return {count=>$campaigns_count} if ($only_count);

    if (!$postsort && @$camps_list && !$is_one_shard_only) {
        $camps_list = overshard(@{$order_offset_limit->{order_by}} ? (order => [map {
                                                                                        my $i = $_;
                                                                                        my $item = $order_offset_limit->{order_by}->[$i];
                                                                                        (lc($item->{dir}) eq 'desc'
                                                                                            ? '-' : '') .
                                                                                        "_o$i" .
                                                                                        (($item->{field} =~ /(^|\W)(cid|uid|ClientID|sum|sum_spent|shows|clicks|sum_last|sum_units|total_units)(\W|$)/i &&
                                                                                          (!$camps_list || !@$camps_list || !exists $camps_list->[0]->{"_o$i"} || $camps_list->[0]->{"_o$i"} !~ /[^\d\.e\-\+]/i))
                                                                                            ? ':num' : '')
                                                                                    } (0 .. $#{$order_offset_limit->{order_by}})]) : (),
                                $order_offset_limit->{offset} ? (offset => $order_offset_limit->{offset}) : (),
                                $order_offset_limit->{limit} ? (limit => $order_offset_limit->{limit}) : (),
                                $camps_list);
    }

    my @multicurrency_client_ids = uniq map { $_->{ClientID} } grep { $_->{currency} ne 'YND_FIXED' } @$camps_list;
    my $clients_nds = mass_get_client_NDS(\@multicurrency_client_ids);
    my $clients_discounts = mass_get_client_discount(\@multicurrency_client_ids);

    # Получим сумму задолженностей для общих счетов клиентов по всем входящим в него кампаниям
    my $sum_debt_all;
    if (ref($subclients_uids) eq 'ARRAY' && @$subclients_uids) {
        $sum_debt_all = WalletUtils::get_sum_debt_for_wallets_by_uids($subclients_uids);
    } else {
        $sum_debt_all = WalletUtils::get_sum_debt_for_wallets_by_uids([map { $_->{uid} } @$camps_list]);
    }

    my $clients_info;
    if (@$camps_list) {
        $clients_info = Client::get_clients_auto_overdraft_info([uniq map { $_->{ClientID} } @$camps_list]);
    }
    foreach my $camp ( @$camps_list ) {
        my $client_id = $camp->{ClientID};

        WalletUtils::calc_camp_uni_sums_with_wallet($camp, $sum_debt_all, $clients_info->{$camp->{ClientID}});
        campaign_remove_nds_and_add_bonus($camp, client_nds => $clients_nds->{$client_id}, client_discount => $clients_discounts->{$client_id});

        my $product = product_info(ProductID => $camp->{ProductID});
        hash_copy $camp, $product, qw/product_type/;

        $camp->{pay} = $camp->{statusModerate} eq 'Yes' ? 1 : 0;
        $camp->{strategy} = detect_strategy($camp);
        if ($camp->{day_budget} && $camp->{day_budget} > 0 && $camp->{OrderID} && $camp->{OrderID} > 0) {
            $camp->{spent_today} = Stat::OrderStatDay::get_order_spent_today($camp->{OrderID});
        }
        # check if campaign just paid
        $camp->{status} = CalcCampStatus($camp);
        $camp->{show} = $camp->{statusShow};
        $camp->{clicks} = $camp->{clicks} || '-';
        $camp->{add_money} = $form->{"sum_$camp->{cid}"};
        $camp->{mediaTypeHuman} = get_human_media_type($camp->{product_type});
        if ($camp->{mediaType} eq 'mcb') {
            $camp->{last_month_shows} = get_one_field_sql( PPC(cid => $camp->{cid}), "SELECT sum(last_month_shows) from media_groups where cid = ?", $camp->{cid})||0;
            $camp->{lowMonthShowsNoPay} = ($camp->{last_month_shows} and $camp->{last_month_shows} < get_min_month_media_shows(cid => $camp->{cid})) ? 1 : 0;
        }

        if ($camp->{mediaType} ne 'wallet') {
            push @arr, $camp;
        } else {
            $campaigns_count--;
        }
    }

    # Постсортировка по суммам и остаткам в разных валютах
    if ($postsort && @arr) {
        my $field = $form->{sort};
        my $coef = $form->{reverse} ? -1 : 1;
        if ($field eq 'sum') {
            # Сортировка по "было" должна учитывать еще и остаток на ОС
            @arr = xsort { $coef * convert_currency(($_->{sums_uni}->{sum} + $_->{sums_uni}->{wallet_total}), $_->{sums_uni}->{currency}, 'RUB', with_nds => 1) } @arr;
        } elsif ($field eq 'total') {
            @arr = xsort { $coef * convert_currency($_->{sums_uni}->{total}, $_->{sums_uni}->{currency}, 'RUB', with_nds => 1) } @arr;
        }
        @arr = @{overshard(
            $order_offset_limit->{offset} ? (offset => $order_offset_limit->{offset}) : (),
            $order_offset_limit->{limit} ? (limit => $order_offset_limit->{limit}) : (),
            \@arr,
        )};
    }

    return {campaigns => \@arr, count => $campaigns_count};
}

#-------------------------------------------------------------------------------

=head2 get_agency_shards

    возвращает ссылку на массив, содержащий номера шардов в которых "живут" клиенты данного представителя агенства

    Параметры:
        $rbac -- из контроллера
        $uid -- представитель агенства, по чьим клиентам нужно определить номера шардов

=cut

sub get_agency_shards
{
    my ($rbac, $uid) = @_;
    my $clients_uids = rbac_get_subclients_uids($rbac, $uid);
    my @shards = grep {$_} values %{get_shard_multi('uid', $clients_uids)};
    return [uniq @shards];
}

#-------------------------------------------------------------------------------

=head2 get_manager_shards

    возвращает ссылку на массив, содержащий номера шардов в которых "живут" клиенты данного менеджера

    Параметры:
        $rbac -- из контроллера
        $uid -- менеджер, по чьим клиентам нужно определить номера шардов

=cut

sub get_manager_shards
{
    my ($rbac, $uid) = @_;
    my $clients_uids = rbac_get_clients_of_manager($rbac, $uid);
    my @shards = grep {$_} values %{get_shard_multi('uid', $clients_uids)};
    return [uniq @shards];
}


#-----------------------------------------------------------

=head2 get_user_camps_name_only($uid, $options)

    Список кампаний клиента с очень краткой информацией:
        номер, название, суммы, тип (текстовая/медийная)

    Для выпадающих списков быстрого перехода, выбора кампании для выгрузки в эксель и т.п.

    Параметры:
        $uid -- uid главного представителя
        $options  -- дополнительные параметры
            rbac         => $rbac,    # $rbac из DoCmd, для фильтрации по собственнику
            owned_by_uid => $UID,     # если указан -- выберутся только кампании, доступные $UID. Необходим $options->{rbac}.
            mediaType    => 'text'    # если указан -- выберутся только кампании с таким значением поля type
            editable_by  => $uid,     #
            cids => [$cid1,$cid2,...] # выбрать ограниченное подмножество кампаний
            client_nds   => 18,       # значение НДС в процентах для клиента-владельца кампании
                                      # если указано, все денежные значения будут скорректированы к без-НДСному варианту
            client_discount => 10,    # текущая скидка клиента в процентах
                                      # если указан, total и sum будут с учётом скидочного бонуса (сумма которого вернётся в поле bonus)
            add_statusEmpty_Yes => 1, # можно выбирать еще и пустые кампании
            add_archived => 1,        # выбрать так же и архивные кампании
            no_ecom_uc => 1           # не выбирать Ecom UC кампании

    Результат:
        ссылка на массив (ссылка на пустой массив, если кампаний не нашлось)

    Пример:
    my $client_nds = get_client_NDS($client_id);
    my $client_discount = get_client_discount($client_id);
    my $options = {rbac => $rbac, owned_by_uid => $UID, mediaType => 'text', client_nds => $client_nds, client_discount => $client_discount};
    $vars->{camps_name_only} = get_user_camps_name_only($c->client_chief_uid, $options);

=cut

sub get_user_camps_name_only
{
    my ($uid, $options) = @_;

    die 'invalid uid given: ' . str($uid) unless $uid && ref($uid) eq '';

    $options ||= {};

    my %cond;
    if ( $options->{cids} ) {
        $cond{"c.cid"} = $options->{cids};
    }
    if ( $options->{editable_by} ) {
        my $cids_for_edit = rbac_get_campaigns_for_edit($options->{rbac}, $options->{editable_by}, $uid);
        $cond{"c.cid"} = ($cond{"c.cid"}) ? xisect($cond{"c.cid"}, $cids_for_edit) : $cids_for_edit;
    }
    if( $options->{mediaType} ) {
        # по одному типу расширить до группы типов
        $cond{"c.type"} = expand_camp_type($options->{mediaType}, ["web_edit_base", "media"]);
    }
    else {
        $cond{"c.type"} = get_camp_kind_types("web_edit_base", "media");
    }

    unless ($options->{add_statusEmpty_Yes}) {
        $cond{"c.statusEmpty__ne"} = 'Yes';
    }
    $cond{"c.archived"} = 'No' unless $options->{add_archived};

    if ($options->{no_ecom_uc}) {
        $cond{"c.metatype__ne"} = 'ecom';
    }

    my $result = get_all_sql(PPC(uid => $uid),
                                  ["select c.cid, c.name,
                                    c.sum + IF(c.wallet_cid > 0, wc.sum, 0) as sum,
                                    c.sum_spent + IF(c.wallet_cid > 0, wc.sum_spent, 0) as sum_spent,
                                    c.sum_spent_units, c.sum_units, (c.sum_units - c.sum_spent_units) as total_units,
                                    IFNULL(c.currency, 'YND_FIXED') AS currency,
                                    c.type as mediaType,
                                    c.statusModerate,
                                    c.statusEmpty
                                    from campaigns c
                                      left join campaigns wc on c.wallet_cid = wc.cid
                                      left join subcampaigns sc_m on c.cid = sc_m.cid
                                    ",
                                    where => {
                                        "c.uid" => SHARD_IDS,
                                        "c.type__ne" => 'wallet',
                                        "sc_m.master_cid__is_null" => 1,
                                        %cond,
                                    },
                                    "order by cid asc"]);

    $result ||= [];

    for my $camp (@$result) {
        $camp->{total} = $camp->{sum} - $camp->{sum_spent};
        campaign_remove_nds_and_add_bonus($camp, %{hash_cut $options, qw/client_nds client_discount/});
    }

    if( $options->{owned_by_uid} ){
        my $cids = [map {$_->{cid}} @$result];
        my $owned_camps = @$cids ? rbac_check_owner_of_camps($options->{rbac}, $options->{owned_by_uid}, $cids) || {} : {};
        @$result = grep { $owned_camps->{$_->{cid}} } @$result;
    }

    return $result;
}

sub get_managers_list
{
    my $rbac = shift;

    my $managers = rbac_get_all_managers($rbac)||[];

    my $users = get_all_sql(PPC(uid => $managers), ["select", join (',', 'uid', @{$User::USER_TABLES{users}->{fields}}), "from users",
                                                  where => {"uid" => SHARD_IDS}, "order by fio"]);
    return overshard(order => 'fio', $users);
}

sub order_camp($$$$;$)
{
    my (undef, $uid, $cid, $post_moderate, $options) = @_;

    die "Incorrect cid, uid: $cid, $uid" if get_owner(cid => $cid) != $uid;

    if (is_media_camp(cid => $cid)) {
        # отправляем медийные объявления на модерацию
        do_sql(PPC(cid => $cid),
              "UPDATE media_groups g
                      JOIN media_banners b ON g.mgid = b.mgid
              SET g.statusModerate = 'Ready'
                , b.statusModerate = 'Ready'
              WHERE g.cid = ?", $cid);
    } else {
        my $bids = $options->{bids} || get_one_column_sql(PPC(cid => $cid), ["SELECT bid FROM banners", WHERE => {cid => $cid}]);
        send_banners_to_moderate($bids, {
            moderate_whole_group => 1,
            post_moderate => $post_moderate && $post_moderate eq 'Yes',
        });
    }
    do_update_table(PPC(cid => $cid), 'campaigns', {statusModerate => 'Ready', statusBsSynced => 'No'}, where => {cid => $cid});

    my ($mgid, $product_id) = get_one_line_array_sql(PPC(cid => $cid), "select mg.mgid, c.ProductID
                                                    from campaigns c
                                               left join media_groups mg on c.cid = mg.cid
                                                   where c.cid = ?", $cid);
    my $prod_type = product_info(ProductID => $product_id)->{product_type};
    if ($mgid && $prod_type && is_package_mcb($prod_type)) {
        do_insert_into_table(PPC(cid => $cid), 'media_auto_moderate', {mgid => $mgid, auto_moderate => 1}, ignore => 1);
    }
    return undef;
}

=head2 _parse_bs_23

    парсинг ответа крутилки /rank/23
    на выходе - ссылка на массив баннеров
    используется для поиска по фразе и получения объявлений конкурентов

=cut

sub _parse_bs_23 {
    my $content = shift;
    my @lines = split /\n/, $content;
    my @res;
    while(@lines) {
        shift @lines && next if $lines[0] =~ /^\d+$/;
        my %row;
        @row{qw/id place BannerID PhraseID price min_price disable_an tragic BroadPhraseID OrderID/} = split ',', (shift(@lines)//'');
        @row{qw/rank ectr pectr rshows rclicks pshows pclicks/} = split ',', (shift(@lines)//'');
        push @res, \%row;
    }
    return \@res;
}


=head2 _arc_camp

    Архивация кампании.
    Внутренняя ф-ция, которая архивирует кампании, выдает ошибку, если на кампании с привязанным кошельком есть минус.

    Если кампания "тяжёлая" и не установлена опция force - не выполняем архивацию, а ставим запрос в очередь
    Позиционные параметры:
    - uid
    - cid
    Именованные параметры:
    - force, логический
    - archived_is_error, логический -- ошибка если кампания уже заархивирована
    - archive_non_stopped, логический -- архивировать кампании, на которых statusShow = 'Yes', используется из ppcArchiveOldCampaigns.pl
    - UID - опциональный параметр. Если проставлен, то передаётся в queue_camp_operation.

=cut
sub _arc_camp($$;%)
{
    my ($uid, $cid, %OPT) = @_;

    my $cids = get_one_column_sql(PPC(cid => $cid), 'SELECT cid FROM subcampaigns WHERE master_cid = ?', $cid);
    push @$cids, $cid;

    my $camps = get_hashes_hash_sql(PPC(cid => $cids), ["
        SELECT c.cid
             , c.sum - c.sum_spent as total
             , c.archived
             , c.statusModerate
             , c.type
             , $Common::CAMP_STOPPED_SQL as camp_stopped
        FROM campaigns c
          JOIN camp_options co ON c.cid = co.cid",
        WHERE => {
          'c.cid' => SHARD_IDS,
          'c.uid' => $uid,
    }]);

    my @non_archived = grep { $_->{archived} ne 'Yes' } values %$camps;
    if (!scalar @non_archived && $OPT{archived_is_error}) {
        return (0, iget("Невозможно заархивировать архивную кампанию"));
    }

    foreach my $camp (@non_archived) {
        return (0, iget("Невозможно заархивировать кампанию с деньгами")) if $camp->{total} >= $Currencies::EPSILON;
        return (0, iget("Невозможно заархивировать кампанию общий счет")) if $camp->{type} eq 'wallet';
        return (0, iget("Невозможно заархивировать биллинговый агрегат")) if $camp->{type} eq 'billing_aggregate';
        return (0, iget("Для архивации кампания должна быть остановлена и с момента остановки и последнего показа должно пройти не менее %s минут", $Settings::MINUTES_AFTER_LAST_SHOW_FOR_ARC_CAMP))
            if !$OPT{archive_non_stopped}
                && !$camp->{camp_stopped}
                && ($camp->{statusModerate} ne 'New')
                && camp_kind_in(type => $camp->{type}, 'web_edit_base');
    }

    $cids = [map { $_->{cid} } @non_archived];

    my $update_statuses_before = Models::Banner::get_update_before();

    if (!$OPT{force} && is_campaign_heavy($cids)) {
        my $params = {};
        if ($OPT{UID}) {
            $params->{UID} = $OPT{UID};
        }
        queue_camp_operation('arc', $cids, params => $params);
        update_campaign_statuses_is_obsolete($cids, $update_statuses_before);
        return 1;
    }

    LogTools::log_messages("arc_camp", "cids=@$cids");

    my $ppc_shard = PPC(cid => $cids);

    do_update_table($ppc_shard, 'campaigns', {
        archived => 'Yes',
        statusShow => 'No',
        statusBsSynced => 'No',
        LastChange__dont_quote => 'NOW()',
    }, where => {
        cid => $cids,
    });

    # p.LastChange=p.LastChange используется, чтобы при этом апдейте не изменилось
    # значение timestamp-поля (дефолтное поведение MySQL для timestamp-полей)
    # statusActive меняем т.к. БК архивирует ресурсы в архивных заказах и после разархивации их надо перепосылать, чтобы показы возобновились
    do_update_table($ppc_shard, 'banners b join phrases p on p.pid = b.pid', {
        'b.LastChange__dont_quote' => 'now()',
        'p.LastChange__dont_quote' => 'p.LastChange',
        'p.statusShowsForecast' => 'Archived',
        'b.statusActive' => 'No',
    }, where => {
        'p.cid' => $cids,
    });

    # Переносим bids в bids_arc
    my $bid_ids = get_one_column_sql($ppc_shard, [ 'SELECT id FROM bids', WHERE => { cid => $cids } ]) || [];
    state $sleep_coef_prop = new Property('arc_campaign_sleep_coef');
    while ( my @ids = splice(@$bid_ids, 0, 2000) ) {
        relaxed times => ($sleep_coef_prop->get(60) // 1), sub {
            do_in_transaction {
                do_sql($ppc_shard, [ "REPLACE INTO bids_arc ($BIDS_FIELDS_STR) SELECT $BIDS_FIELDS_STR FROM bids", where => { cid => $cids, id => \@ids } ]);
                do_sql($ppc_shard, [ 'DELETE FROM bids', where => { cid => $cids, id => \@ids } ]);
            };
        };
    }

    Mediaplan::close_request_first_aid($cids, undef, 'AcceptDeclined');

    update_campaign_statuses_is_obsolete($cids, $update_statuses_before);

    return 1;
}

=head2 unarc_camp

    Разрхивация кампании.
    Если кампания "тяжёлая" и не установлена опция force - не выполняем разархивацию, а ставим запрос в очередь
    Позиционные параметры:
    - uid
    - cid
    Именованные параметры:
    - force, логический
    - UID - опциональный параметр. Если проставлен, то передаётся в queue_camp_operation.

=cut

sub unarc_camp {
    my ($uid, $cid, %OPT) = @_;

    my $cids = get_one_column_sql(PPC(cid => $cid), 'SELECT cid FROM subcampaigns WHERE master_cid = ?', $cid);
    push @$cids, $cid;

    my %camps;
    foreach my $cur_cid (@$cids) {
        my $camp = get_camp_info($cur_cid, $uid, short => 1);
        if (!$camp->{cid}) {
            return 0;
        }

        if (!camp_kind_in(type => $camp->{type}, 'non_currency_convert')) {
            my $client_currencies = get_client_currencies($camp->{ClientID});

            # не даём разархивировать кампании, пережившие переход клиента на мультивалютность,
            # оставшиеся при этом в у.е. (они либо были сконвертированы, либо оставлены в архиве)
            if ($client_currencies->{work_currency} ne $camp->{currency}) {
                die "Cannot unarc campaign $cur_cid because of invalid currency: work_currency = $client_currencies->{work_currency}; campaign currency = $camp->{currency}";
            }
        }

        if (!(camp_kind_in(type => $camp->{type}, 'base')) && !is_media_camp(type => $camp->{type})) {
            die "campaign $cur_cid has unknown type $camp->{type} for unarc_camp";
        }

        $camps{$cur_cid} = $camp;
    }

    $cids = [grep { $camps{$_}->{archived} ne 'No' } @$cids];

    my $update_statuses_before = Models::Banner::get_update_before();

    if (!$OPT{force} && is_campaign_heavy($cids)) {
        my $params = {};
        if ($OPT{UID}) {
            $params->{UID} = $OPT{UID};
        }
        queue_camp_operation('unarc', $cids, params => $params);
        update_campaign_statuses_is_obsolete($cids, $update_statuses_before);
        return 1;
    }

    foreach my $cur_cid (@$cids) {
        my $ppc_shard = PPC(cid => $cur_cid);
        my $cur_camp = $camps{$cur_cid};

        LogTools::log_messages("unarc_camp", "cid=$cur_cid");

        my $need_recalc_price_context = ($cur_camp->{autobudget} eq 'No')
            && (!$cur_camp->{strategy} || $cur_camp->{strategy} ne 'different_places')
            && ($cur_camp->{ContextPriceCoef} != 100);

        my $need_update_network_params = ($cur_camp->{autobudget} eq 'Yes')
            && ($cur_camp->{ContextPriceCoef} != 100 || $cur_camp->{ContextLimit} != 0);

        my $currency_min_price = $Currencies::_CURRENCY_DESCRIPTION{$cur_camp->{currency}}->{MIN_PRICE};

        my $ap_sql = $cur_camp->{autobudget} eq 'Yes'
            ? 'ifnull(autobudgetPriority, 3) as autobudgetPriority'
            : 'autobudgetPriority';

        my $context_price_coef = $cur_camp->{ContextPriceCoef};

        my $price_context_sql = $need_recalc_price_context
            ? "GREATEST(price * $context_price_coef / 100," . $currency_min_price . ") as price_context"
            : "price_context";
        my @bids_fields = (@BIDS_FIELDS, $ap_sql, $price_context_sql);
        my $bids_fields_str = join ', ', @bids_fields;

        if (camp_kind_in(type => $cur_camp->{type}, 'base')) {
            # Переносим bids_arc в bids
            my $pids = get_one_column_sql($ppc_shard, 'SELECT distinct pid FROM bids_arc WHERE cid = ?', $cur_cid) || [];
            for my $pids_chunk (chunks($pids, 200)) {
                do_in_transaction {
                    do_sql($ppc_shard, [
                            "REPLACE INTO bids ($BIDS_FIELDS_STR) SELECT $bids_fields_str FROM bids_arc",
                            where => { cid => $cur_cid, pid => $pids_chunk },
                            "FOR UPDATE",
                        ]);
                    do_sql($ppc_shard, [ 'DELETE FROM bids_arc', where => { cid => $cur_cid, pid => $pids_chunk } ]);
                };
            }

            # получаем полный список всех баннеров кампании (без черновиков)
            my $banners = get_all_sql($ppc_shard, q/
                SELECT b.bid, b.domain, vc.phone
                FROM banners b
                    JOIN phrases p USING(pid)
                    LEFT JOIN vcards vc ON vc.vcard_id = b.vcard_id
                WHERE p.cid = ? AND b.statusModerate != 'New'
                /, $cur_cid);
            my @bids = map { $_->{bid} } @{$banners // []};

            if ($banners && @$banners) {
                # проверим, есть ли хотя бы к одному домену или телефону записи на модерации
                my (%domains, %phones);
                for my $banner ( @$banners ) {
                    $domains{ $banner->{domain} } = undef if $banner->{domain};
                    if ( $banner->{phone} ) {
                        my $phone_hash = parse_phone($banner->{phone});
                        my $phone = join '', map { $phone_hash->{$_} } qw/country_code city_code phone/;
                        $phones{ $phone } = undef if $phone;
                    }
                }
                my $has_no_moderation_records = eval { check_domain_phone_on_moderate([keys %domains], [keys %phones], $uid) };
                if ( !defined $has_no_moderation_records) {
                    my $msg = 'error checking domains ' . join(',', keys %domains) .' and phones ' . join(',', keys %phones) .
                              " from campaign with CID $cur_cid belonging to user with UID $uid for records in moderation: $@";
                    send_alert(Carp::longmess($msg), 'unarc_camp moderation error');
                    # если по какой-то причине не можем проверить наличие записей на модерации, считаем, что их нет
                    $has_no_moderation_records = 1;
                }
                if ( !$has_no_moderation_records ) {
                    # хотя бы к одному домену или телефону разархивируемой кампании есть записи на модерации
                    # поэтому отправим кампанию целиком на перемодерацию (контент сайта мог измениться, лицензии истечь и т.п.)
                    send_banners_to_moderate(\@bids);
                    do_sql($ppc_shard, q/UPDATE campaigns SET statusModerate = "Ready", start_time=start_time WHERE cid = ? AND uid = ?/, $cur_cid, $uid);
                }
            }

            if (!$need_recalc_price_context && !$need_update_network_params) {
                do_sql($ppc_shard, "update campaigns set archived='No',start_time=start_time, statusBsSynced='No', LastChange = now() where cid=? and uid=?", $cur_cid, $uid);
            } elsif ($need_recalc_price_context) {
                do_sql($ppc_shard, "update campaigns c
                    join camp_options co on c.cid=co.cid
                    set c.archived='No',
                        c.start_time=start_time,
                        c.statusBsSynced='No',
                        c.ContextLimit=0,
                        c.ContextPriceCoef=100,
                        c.LastChange = now(),
                        co.strategy=if(c.platform = 'both', 'different_places', NULL)
                    where c.cid=? and c.uid=?", $cur_cid, $uid);
            } else {
                do_sql($ppc_shard, "update campaigns set archived='No',start_time=start_time, statusBsSynced='No', ContextLimit=0, ContextPriceCoef=100, LastChange = now() where cid=? and uid=?", $cur_cid, $uid);
            }

            fix_statusModerate_for_ess_moderation(\@bids);

            # Обновляем banners.LastChange, чтобы не заархивировать по старости
            # также переотправляем все ресурсы в БК, т.к. ресурсы для баннеров из архивных кампаний они выкидывают
            do_sql( $ppc_shard, "UPDATE banners b
                                  join phrases p on p.pid = b.pid
                              SET b.LastChange = now()
                                , p.LastChange=p.LastChange
                                , b.statusBsSynced = 'No'
                                , p.statusBsSynced = 'No'
                                , p.statusShowsForecast='New'
                            WHERE p.cid = ?", $cur_cid );

            do_sql($ppc_shard, 'insert ignore into mod_export_candidates set cid = ?', $cur_cid);
        } else {
            do_sql($ppc_shard, "update campaigns set archived='No',start_time=start_time, statusBsSynced='No' where cid=? and uid=?", $cur_cid, $uid );
            # Обновляем медийные баннеры и группы
            do_sql( $ppc_shard, "UPDATE media_banners b
                                  join media_groups g on b.mgid = g.mgid
                              SET b.LastChange = now()
                                , b.statusBsSynced = 'No'
                                , g.statusBsSynced = 'No'
                            WHERE g.cid = ?", $cur_cid );
        }
        update_campaign_statuses_is_obsolete([$cur_cid], $update_statuses_before);
    }

    return 1;
}


=head2 mass_unarchive_banners(uid, bids_arr)

    Разархивирует объявления, проверяет необходимость перемодерации

    Возвращает информацию о разархивированных объектах в виде хеша:
   {
     updated_bids => { bid => 1 }  - идентификаторы обработанных баннеров (bid), value всегда 1
     updated_pids => { pid => banners_count } - идентификаторы обработанных групп (pid) и количество обновленных баннеров в группе.
   }
=cut

sub mass_unarchive_banners($%)
{
    my ($uid, %O) = @_;

    my $result = {};
    my %where;
    if ($O{bids}) {
        $where{'b.bid'} = $O{bids};
    } elsif ($O{pids}) {
        $where{'g.pid'} = $O{pids};
    } else {
        return $result;
    }
    my $update_before = Models::Banner::get_update_before();

    my @shard = choose_shard_param(\%where, ['pid', 'bid'], set_shard_ids => 1);
    my $banners = get_hashes_hash_sql(PPC(@shard), ["
        SELECT b.bid, b.pid, b.banner_type, b.statusArch, (b.statusModerate = 'New') AS is_draft, b.domain, vc.phone, c.archived as campArch, c.ClientID
        FROM
            phrases g
            JOIN campaigns c ON c.cid = g.cid
            JOIN banners b ON b.pid = g.pid
            LEFT JOIN vcards vc ON vc.vcard_id = b.vcard_id
    ", where => \%where]);

    my @bids_to_unarchive = grep {
        $banners->{$_}{'statusArch'} eq 'Yes'
    } grep {
        $banners->{$_}{'campArch'} eq 'No'
    } grep {
        !Models::Banner::is_cpm_banner($banners->{$_}{'banner_type'}) ||
        !Client::ClientFeatures::is_feature_cpm_banner_campaign_disabled_enabled($banners->{$_}{'ClientID'})
    } (keys %$banners);

    fix_statusModerate_for_ess_moderation(\@bids_to_unarchive);

    my $moderate_whole_group = (scalar(@bids_to_unarchive) == scalar(keys %$banners))? 1 : 0;

    if (@bids_to_unarchive) {
        my @bids_moderate = grep { !$banners->{$_}{is_draft} && $banners->{$_}{banner_type} ne 'performance' } @bids_to_unarchive;

        if (@bids_moderate) {
            # если хотя бы к одному домену или телефону есть записи на модерации,
            # то отправляем разархивированный баннер на повторную модерацию

            my @phones = uniq map {$banners->{$_}{phone}} grep { $banners->{$_}{phone} } @bids_moderate;
            @phones = map { my $phone_hash = parse_phone($_); join '', map { $phone_hash->{$_} } qw/country_code city_code phone/ } @phones;

            my @domains = uniq map { $banners->{$_}{domain} } grep { $banners->{$_}{domain} } @bids_moderate;

            my $has_no_moderation_records = eval { check_domain_phone_on_moderate(\@domains, \@phones, $uid) };

            if (!defined $has_no_moderation_records) {
                $has_no_moderation_records = 1;

                my $domains_list = @domains ? join(", ", @domains) : '';
                my $phones_list = @phones ? join(", ", @phones) : '';
                my $bids_list = join ", ", @bids_moderate;

                my $msg = "error checking domain $domains_list and phone $phones_list from banner with bid $bids_list belonging to user with UID $uid for records in moderation: $@";
                send_alert(Carp::longmess($msg), 'mass_unarchive_banners moderation error');
            }

            if (!$has_no_moderation_records) {
                send_banners_to_moderate(\@bids_moderate, {moderate_whole_group => $moderate_whole_group});
            }
        }
        foreach (@bids_to_unarchive) {
            $result->{updated_bids}->{$_} = 1;
            $result->{updated_pids}->{$banners->{$_}->{pid}}++ if ($O{pids});
        }
        my $pids_to_unarchive = [uniq map { $banners->{$_}->{pid} } @bids_to_unarchive];

        do_sql(PPC(bid => \@bids_to_unarchive), ["update banners b inner join phrases p ON b.pid = p.pid set b.statusArch = 'No', b.statusBsSynced='No', b.LastChange = NOW(), p.statusBsSynced = 'No'", where => { 'b.bid' => SHARD_IDS }]);

        Models::Banner::update_banner_statuses_is_obsolete(\@bids_to_unarchive, $update_before);
        Models::Banner::update_adgroup_statuses_is_obsolete($pids_to_unarchive, $update_before);
    }

    return $result;
}

=head2 check_domain_phone_on_moderate(domains_arr, phones_arr, uid)

    Делает запрос на модерацию - проверка необходимости модерации разархивирующихся баннеров

=cut

sub check_domain_phone_on_moderate($$$)
{
    my ($domains, $phones, $uid) = @_;

    my $json_rpc_object = Moderate::JSONRPC::Client->new(
        Moderate::Tools::get_moderation_jsonrpc_url({use_cache => 1}),
        {timeout => 10}
    );
    my $data = $json_rpc_object->checkUserDomains({
        domains => ($domains || []),
        phones => ($phones || []),
        uid => $uid,
        client_id => $uid ? get_clientid(uid => $uid) : undef
    });

    if (!defined $data) {
        die "JsonRPC Fault (moderate.checkUserDomains)";
    }
    return $data;
}

#-----------------------------------------------------------------

=head2 camps_add_rbac_actions

delete unnecessary item from actions (from rbac)
and add to $vars (all camps)
fields to add: actions, pactions, noaction, allow_edit_camp

=head3 use

 camps_add_rbac_actions($rbac, $login_rights, get_user_camps($slave_uid)->{campaigns}, $UID);

=head3 $ref_to_actions format

 $actions - ref to array of hashes:
 [
    {text => "Включить",              cmd => "resumeCamp"},
    {text => "Остановить",            cmd => "stopCamp"},
    {text => "Посмотреть статистику", cmd => "showCampStat"},
    {text => "Оплатить",              cmd => "pay"},
    {text => "Архивировать",          cmd => "campArc"},
    {text => "Удалить",               cmd => "delCamp"}
    {text => "Копировать",               cmd => "copyCampClient"}
 ]

=cut

sub camps_add_rbac_actions($$$$)
{
    my ($rbac, $login_rights, $campaigns, $UID) = @_;

    $UID = RBACDirect::rbac_replace_freelancer_by_client_via_cids($rbac, $UID, [map {$_->{cid}} @$campaigns])
        if $login_rights->{is_freelancer};
    my $is_super_manager = $login_rights->{is_super_manager} ? 1 : 0;
    my $is_super_reader  = $login_rights->{superreader_control} ? 1 : 0;
    my $is_super  = $login_rights->{super_control} ? 1 : 0;
    my $all_rbac_actions = rbac_get_campaigns_actions($UID, $is_super_manager, $campaigns);
    my $role = rbac_who_is($rbac, $UID);
    my $is_any_client = $role =~ /client$/ ? 1 : 0;

    my %user_info_cache;

    my @camps_with_delete = grep { any {$_->{cmd} eq 'delCamp'} @{$all_rbac_actions->{$_->{cid}}->{actions} || []} } @$campaigns;
    my $is_camps_deletetable = mass_is_camp_deletable_by_hash(\@camps_with_delete);

    my @cids = map { $_->{cid} } @$campaigns;
    my $geoproduct_campaigns = Campaign::get_geoproduct_campaigns(\@cids);
    my %is_geoproduct_campaign = map { $_ => 1 } @$geoproduct_campaigns;

    my @content_promotion_cids = map { $_->{cid} } grep { $_->{mediaType} eq 'content_promotion' } @$campaigns;
    my $content_promotion_types = CampaignTools::mass_get_content_promotion_content_type(\@content_promotion_cids);

    my $client_client_id = get_clientid(uid => $login_rights->{client_chief_uid});
    my $has_cpm_geoproduct_enabled = Client::ClientFeatures::has_cpm_geoproduct_enabled($client_client_id);
    my $has_cpm_deals_allowed_feature = Client::ClientFeatures::has_cpm_deals_allowed_feature($client_client_id);
    my $has_content_promotion_video_allowed_feature = Client::ClientFeatures::has_content_promotion_video_allowed_feature($client_client_id);
    my $has_content_promotion_collection_allowed_feature = Client::ClientFeatures::is_feature_content_promotion_collection_enabled($client_client_id);

    for my $camp (@$campaigns) {
        my $rbac_camp_info = $all_rbac_actions->{$camp->{cid}};
        my $rbac_actions = $rbac_camp_info->{actions};
        my $archived = defined $camp->{archived} && $camp->{archived} eq 'Yes';
        for my $item (@$rbac_actions) {

            # Копировать
            if ($item->{cmd} eq 'copyCampClient'&&
                !$archived &&
                $camp->{has_banners} &&
                camp_kind_in(type => $camp->{mediaType}, "copyable_by_client")
            )
            {
                $camp->{action}->{ $item->{cmd} } = $item->{text};
            }

            # Включить
            if ($item->{cmd} eq 'resumeCamp' &&
                !$archived &&
                ($camp->{show} // 'Yes') eq 'No' &&
				(!$is_any_client || camp_kind_in(type => $camp->{mediaType}, "web_edit_base")) &&
                ($camp->{mediaType} ne 'cpm_price' || $is_super)
				)
            {
                $camp->{action}->{ $item->{cmd} } = $item->{text};
            }

            # Остановить
            if (($item->{cmd}//'') eq 'stopCamp' &&
                !$archived &&
                !($role =~ /agency/ && is_package_mcb($camp->{product_type})) &&
                ($camp->{show}//'') eq 'Yes' &&
				(!$is_any_client || camp_kind_in(type => $camp->{mediaType}, "web_edit_base")) &&
                ($camp->{mediaType} ne 'cpm_price' || $is_super)
			   )
            {
                $camp->{action}->{ $item->{cmd} } = $item->{text};
            }

            # Посмотреть статистику
            if ($item->{cmd} eq 'showCampStat' && $camp->{OrderID} != 0)
            {
                $camp->{action}->{ $item->{cmd} } = $item->{text};
            }

            # Параметры
            if ($item->{cmd} eq 'editCamp' && !$archived)
            {
                $camp->{action}->{ $item->{cmd} } = $item->{text};
            }

            # просмотр параметров
            if ($item->{cmd} eq 'showCampSettings')
            {
                $camp->{action}->{ $item->{cmd} } = $item->{text};
            }

            # Оплатить
            if ($item->{cmd} eq 'pay'
                && $camp->{statusNoPay} ne 'Yes'
                && ! $archived
                && ! $camp->{wallet_cid}
                && ($camp->{pay} || $rbac_camp_info->{is_scampaign} || $rbac_camp_info->{is_agencycampaign})
                && ($camp->{statusModerate} eq 'Yes'
                    || $role =~ m/^(manager|super)$/
                    || camp_kind_in(type => $camp->{mediaType}, "web_edit_base")
                   )
               )
            {
                if ($camp->{sum} > 0) {
                    $camp->{action}->{ $item->{cmd} } = iget('Доплатить');
                }
                else {
                    $camp->{action}->{ $item->{cmd} } = $item->{text};
                }
            }

            # Архивировать/Разархивировать
            if ($item->{cmd} eq 'campArc' && $archived && $camp->{mediaType} ne 'cpm_price') {
                if (($has_cpm_geoproduct_enabled || !$is_geoproduct_campaign{$camp->{cid}})
                    && ($has_cpm_deals_allowed_feature || $camp->{mediaType} ne 'cpm_deals')
                    && ($camp->{mediaType} ne 'content_promotion'
                        || !$content_promotion_types->{$camp->{cid}}
                        || ($content_promotion_types->{$camp->{cid}} ne 'video' && $content_promotion_types->{$camp->{cid}} ne 'collection')
                        || ($has_content_promotion_video_allowed_feature && $content_promotion_types->{$camp->{cid}} eq 'video')
                        || ($has_content_promotion_collection_allowed_feature && $content_promotion_types->{$camp->{cid}} eq 'collection'))) {
                    $camp->{action}->{campUnarc} = iget('Разархивировать');
                }
            } elsif ($item->{cmd} eq 'campArc'
                     && (
                            ( exists $camp->{sums_uni} && (($camp->{sums_uni}->{sum} // 0) - ($camp->{sums_uni}->{sum_spent} // 0) < $Currencies::EPSILON))
                         || (!exists $camp->{sums_uni} && ($camp->{total} // 0) - ($camp->{wallet_total} // 0) < $Currencies::EPSILON)
                        )
                     && (! ($camp->{optimized} && $camp->{optimized_status} =~ /^(?:New|InProcess|Ready)$/)) # если не было оптимизации или оптимизация закончена
                     && ($camp->{camp_stopped} || !camp_kind_in(type => $camp->{mediaType}, 'web_edit_base'))
                     && ($camp->{mediaType} ne 'cpm_price')
                    )
            {
                $camp->{action}->{ $item->{cmd} } = $item->{text};
            }

            # Lookup - view only
            if ($item->{cmd} eq 'Lookup')
            {
                $camp->{action}->{ $item->{cmd} } = $item->{text};
            }

            # Удалить
            if ($item->{cmd} eq 'delCamp' && $is_camps_deletetable->{$camp->{cid}}) {
                $camp->{action}->{ $item->{cmd} } = $item->{text};
            }

            if ($item->{cmd} eq 'remoderateCamp'
                && $camp->{statusModerate} ne 'New'
                && $camp->{archived} ne 'Yes')
            {
                $camp->{action}->{ $item->{cmd} } = $item->{text};
            }

            # установить цены для всей кампании (на кампании на которую есть право редактирования)
            if (camp_kind_in(type => $camp->{mediaType}, "web_edit_base")
                && ($camp->{autobudget} || '') ne 'Yes'
                && $item->{cmd} eq 'editCamp'
                && !camp_kind_in(type => $camp->{mediaType}, "old_web_no_support")
               )
            {
                # разрешаем или на кампании на которой когда либо были деньги или саппортам/суперам на всех кампаниях
                if ($camp->{sum} > 0 || $role =~ m/^(super|support)$/) {
                    $camp->{action}->{setAutoPrice} = {text => iget('Цена')};
                }
            }

            # массовое включение видеодополнений
            if (
                (! defined $camp->{action}->{ajaxSetAutoResources}) &&
                ($item->{cmd} eq 'editCamp' || $is_super_reader)
                && camp_kind_in(type => $camp->{mediaType}, "auto_resources")
                && !$archived
                # видео-дополнения для РМП разрешаем только внутренним ролям
                && !($camp->{mediaType} eq 'mobile_content' && $role !~ m/^(manager|super)$/)
            ) {
                $camp->{action}->{ajaxSetAutoResources} = iget("Видеодополнения");
            }

            # массовое редактирование счетчиков метрики
            if (
                (! defined $camp->{action}->{editMetrikaCounters}) &&
                ($item->{cmd} eq 'editCamp' || $is_super_reader) && !$archived &&
                    $camp->{mediaType} !~ /^(mcb|mobile_content)$/)
            {
                $camp->{action}->{editMetrikaCounters} = iget("Изменить счетчик метрики");
            }

            # offerServicing
            if ($item->{cmd} eq 'offerServicing' && !$archived)
            {
                $camp->{paction}->{ $item->{cmd} } = $item->{text};
            }

            # AcceptServicing
            if ($item->{cmd} eq 'AcceptServicing')
            {
                $camp->{paction}->{ $item->{cmd} } = $item->{text};
            }

            # allow transfer money subclient
            if ($item->{cmd} eq 'allow_transfer_money_subclient') {
                $camp->{paction}->{ $item->{cmd} } = $item->{text};
            }

            # pseudo actions
            if ($item->{cmd} =~ /^(?:serviced|other_manager_serviced|agency_serviced)$/ ) {
                $camp->{paction}->{ $item->{cmd} } = $item->{text};
                $camp->{paction}->{ "$item->{cmd}_info" } = exists $user_info_cache{$item->{text}}
                        ? $user_info_cache{$item->{text}}
                        : ($user_info_cache{$item->{text}} ||= get_user_info($item->{text}));
            }
            if ($item->{cmd} eq 'agency_serviced_lim_reps') {
                $camp->{paction}->{ $item->{cmd} } = $item->{text};
                $camp->{paction}->{ "$item->{cmd}_info" } = [
                    map { exists $user_info_cache{$_} ? $user_info_cache{$_}
                        : ($user_info_cache{$_} ||= get_lim_rep_info($_)) } @{$item->{text}}
                ];
            }

        } # / for (@$rbac_actions)
        $camp->{noaction} = 1 unless exists $camp->{action};
        $camp->{allow_edit_camp} = $rbac_camp_info->{allow_edit_camp};
    } # / for $camp (@$campaigns)

    return;
}

=head2 calc_adgroups_prices

    Посчитать цены для новых фраз групп

    Параметры позиционные
        $campaign или [$campaign1, campaign2...] — хеш с данными о кампании или массив хешей с данными о кампаниях

    Параметры именованные
        not_use_common_stat -- флаг, выставляется в случае мультикопирования объявлений (интересно, а почему при одиночном копировании -- нет?)
        ContextPriceCoef -- рассчет цены на контекст в проценте от цены на поиске
        ContextPriceCoef_from_campaign -- брать ContextPriceCoef из объекта $campaign
        update_shows_forecast_in_db => (0|1), по-умолчанию - 1, если 0 - прогноз показов по фразам в структуре с которой ходим в торги обновляется,
                                                                         не смотря на статус актуальности прогноза в БД, и не обновляется в БД
        only_new_phrases_price_calc => (0|1), по-умолчанию - 0, если 1 - прогноз показов, ставки из торгов, и расчет цен делаем только для новых фраз
                                                                         (без id). Не совместима с опцией update_shows_forecast_in_db = 1

=cut

sub calc_adgroups_prices {
    # phrases - список хешей уже существующих фраз (есть phrase и phrase_old)
    # geo, broker_price
    # currency
    # На выходе Phrases

    my ($campaigns, %OPT) = @_;

    $campaigns = [$campaigns] if ref $campaigns ne 'ARRAY';
    my $not_use_common_stat = $OPT{not_use_common_stat} || 0;
    my $update_shows_forecast_in_db = $OPT{update_shows_forecast_in_db} // 1;
    my $only_new_phrases_price_calc = $OPT{only_new_phrases_price_calc} // 0;

    if ($only_new_phrases_price_calc && $update_shows_forecast_in_db) {
        die "options only_new_phrases_price_calc=1 and update_shows_forecast_in_db=1 is incompatible";
    }

    for my $campaign (@$campaigns) {
        my $currency = $campaign->{currency};
        die 'no currency given' unless $currency;
        my $min_price_constant = get_currency_constant($currency, 'DEFAULT_PRICE');
        my $max_price_constant = get_currency_constant($currency, 'MAX_PRICE');
        my $default_price = $campaign->{autobudget} eq 'Yes'
            ? $min_price_constant : $max_price_constant;

        my $ContextPriceCoef = $OPT{ContextPriceCoef_from_campaign}
                                ? ($campaign->{strategy}->{name} ne 'different_places'
                                        ? $campaign->{ContextPriceCoef}
                                        : undef)
                                : $OPT{ContextPriceCoef};

        BannersCommon::enrich_image_banners($campaign->{groups});
        foreach my $group (@{$campaign->{groups}}) {
            my %MD5;
            # в хеш собираем только фразы, встречающиеся без id (новые)
            my %MD5NEW;
            foreach my $phrase (@{$group->{phrases}}) {
                my $props = get_phrase_props($phrase->{phrase});
                next unless $props;
                $MD5{$props->{md5}} = {
                    props => $props,
                    phrase => $phrase,
                    id => $phrase->{id},
                };
                unless ($phrase->{id}) {
                    $MD5NEW{$props->{md5}} = undef;
                }
            }

            # Фразы по id
            my $phrase_by_id = {map { $_->{id} => $_ } grep {$_->{id}}  @{$group->{phrases}}};

            # Общая цена, или 0 если цены не равны
            my $common_price;
            my %old_ph;

            # параметры для BS::TrafaretAuction для расчета цены на поиске
            $campaign->{camp_rest} = round2s(($campaign->{sum}//0) - ($campaign->{sum_spent}//0));
            my $is_geo_or_domain_changed = defined $group->{geo_old} && $group->{geo_old} eq $group->{geo} &&
                                           any {$_->{domain_old} eq $_->{domain}} grep {defined $group->{domain_old}} @{$group->{banners}};
            foreach my $phrase ( @{$group->{phrases}} ) {

                # пересчитываем md5 на случай смены леммера
                if ($phrase->{phrase_old}) {
                    hash_merge $phrase, hash_cut get_phrase_props($phrase->{phrase_old}), qw/md5/;
                    if ( defined $phrase->{md5} && defined $MD5{$phrase->{md5}} ) {
                        if ($phrase->{phrase_old} ne $MD5{$phrase->{md5}}->{props}->{phrase}) {
                            $phrase->{flag_new} = 1;
                        } else {
                            # на случай, если сделали из одной фразы несколько с помощью "|"
                            $phrase->{phrase} = $phrase->{phrase_old};
                        }

                        $old_ph{$phrase->{md5}} = $phrase;
                    }
                }
                if ( !defined $common_price ) {
                    $common_price = $phrase->{price};
                } elsif ( $phrase->{price} && $common_price != $phrase->{price} ) {
                    $common_price = 0;
                }
            }
            undef $common_price if $campaign->{strategy}->{name} eq 'different_places';

            my @phrases;
            # хэш для связывания, из него будут удаляться ключи в процессе
            # old_ph остаётся неизменным для определения старых фраз
            my %bind_phrases = %old_ph;
            foreach my $md5 (keys %MD5) {
                my $old_phrase;

                # Сначала связываемся по md5, затем по id
                if (exists $bind_phrases{$md5}) {
                    $old_phrase = $bind_phrases{$md5};
                    delete $bind_phrases{$md5};
                    delete $phrase_by_id->{$old_phrase->{id}};
                } elsif (defined $MD5{$md5}->{id} and exists  $phrase_by_id->{$MD5{$md5}->{id}}) {
                    $old_phrase = $phrase_by_id->{$MD5{$md5}->{id}};
                    delete $phrase_by_id->{$MD5{$md5}->{id}};
                    delete $bind_phrases{$old_phrase->{md5}};
                }

                if( $not_use_common_stat ) {
                    $old_phrase->{PriorityID} = 0;
                    $old_phrase->{BannerID} = 0;
                    $old_phrase->{PhraseID} = 0;
                }

                my $price = $old_phrase->{price} || $common_price || $default_price;
                my $price_context = $ContextPriceCoef ? phrase_price_context($price, $ContextPriceCoef, $currency) : $min_price_constant;
                push @phrases, hash_merge(
                    {}, $old_phrase, {
                        numword => $MD5{$md5}->{props}->{numword},

                        price => $price,
                        price_context => $price_context,

                        autobudgetPriority => $old_phrase->{autobudgetPriority} || 3,
                        PriorityID => $old_phrase->{PriorityID} || 0,
                        BannerID => $old_phrase->{BannerID} || 0,
                        PhraseID => $old_phrase->{PhraseID} || 0,
                        phrase => $MD5{$md5}->{props}->{phrase},
                        phr => $MD5{$md5}->{props}->{phrase}, # Параметр передается исключительно для trafaret_auction, пока trafaret_auction не перепишем, убирать параметр нельзя.
                        phrase_unglued_suffix => $MD5{$md5}->{phrase}->{phrase_unglued_suffix},
                        norm_phrase => $MD5{$md5}->{props}->{norm_phrase},
                        md5 => $md5,
                        id => $old_phrase->{id}||0,
                        declined => $MD5{$md5}->{props}->{declined},
                        fixation => $MD5{$md5}->{phrase}->{fixation},
                        phraseIdHistory => $MD5{$md5}->{phrase}->{phraseIdHistory},
                        showsForecast => $old_phrase->{showsForecast},
                        rank => $MD5{$md5}->{phrase}->{rank},
                    }
                );
            }

            $group->{_phrases} = \@phrases;
            $group->{_common_price} = $common_price;
            $group->{_old_ph} = \%old_ph;

            # Разбираем PH
            if ( @phrases ) {
                # Считаем цены
                my $fake_banners = $group->{banners};

                my $bs_banner = yclone(Models::AdGroup::get_main_banner($group));

                hash_merge $bs_banner,
                    Models::Banner::_copy_to_banner($group, $Models::Banner::banner_fields{group}),
                    # для РМП дополнительно подливаем данные о таргетинге на тип/ос устройств
                    $group->{adgroup_type} eq 'mobile_content'
                        ? Models::Banner::_copy_to_banner($group, $Models::Banner::banner_fields{adgroup_mobile_content})
                        : (),
                    # для старой схемы
                    Models::Banner::_copy_to_banner($group, $Models::Banner::banner_fields{camp}),
                    # для новой схемы
                    Models::Banner::_copy_to_banner($campaign, $Models::Banner::banner_fields{camp}),
                    {
                        phrases => \@phrases,
                        camp_rest => $campaign->{camp_rest},
                        timetarget_coef => TimeTarget::timetarget_current_coef($bs_banner->{timeTarget}, $bs_banner->{timezone_id}),
                        no_extended_geotargeting => $campaign->{no_extended_geotargeting},
                    };
                if ($group->{adgroup_type} eq 'mobile_content') {
                    $bs_banner->{filter_domain} = $group->{mobile_content}->{publisher_domain} || Yandex::IDN::idn_to_ascii($group->{mobile_content}->{store_app_id});
                } else {
                    $bs_banner->{filter_domain} = get_filter_domain($bs_banner->{domain});
                }

                # запоминаем исходную фразу и приклеиваем минус-слова от расклейки,
                # чтобы получить правильные прогноз показов и данные торгов
                for my $phrase (@{$bs_banner->{phrases}}) {
                    $phrase->{_phrase} = $phrase->{phrase};
                    $phrase->{phrase} = ($phrase->{phrase} // '') . ($phrase->{phrase_unglued_suffix} // '');
                }

                $bs_banner->{_MD5NEW} = \%MD5NEW;

                $group->{_bs_banner} = $bs_banner;
            }
        }
    }

    # ходим за прогнозом показов в ADVQ и за ставками в торги
    my @all_bs_banners = grep { $_ } map { $_->{_bs_banner} } map { @{$_->{groups}} } @$campaigns;

    if ($only_new_phrases_price_calc) {
        for my $bs_banner (@all_bs_banners) {
            next unless @{$bs_banner->{phrases} // []};
            $bs_banner->{_all_phrases} = $bs_banner->{phrases};
            $bs_banner->{phrases} = [grep { !defined $_->{md5} || exists $bs_banner->{_MD5NEW}->{$_->{md5}} } @{$bs_banner->{_all_phrases}}];
        }
    }

    if ($update_shows_forecast_in_db) {
        # TODO: performance: перейти на массовые запросы
        Models::AdGroup::update_phrases_shows_forecast(\@all_bs_banners, timeout => 5);
    } else {
        # обновляем прогноз показов не смотря на статус, и не обновляя прогноз в БД
        advq_get_phrases_shows_multi(\@all_bs_banners, timeout => 5);
    }

    my @all_bs_auction_banners = ();
    for my $bs_banner (@all_bs_banners) {
        if ($bs_banner->{is_bs_rarely_loaded} || $bs_banner->{ad_type} eq 'image_ad' && !$bs_banner->{title}) {
            my $default_price = get_currency_constant($bs_banner->{currency}, 'DEFAULT_PRICE');
            my $fake_bs_response = {
                bid_price => int($default_price * 1e6),
                amnesty_price => int($default_price * 1e6),
            };
            for my $ph (@{$bs_banner->{phrases}}) {
                $ph->{guarantee} = $ph->{premium} = [($fake_bs_response) x 4];
                $ph->{nobsdata} = 1;
            }
        }
        else {
            push @all_bs_auction_banners, $bs_banner;

        }
    }
    trafaret_auction(\@all_bs_auction_banners) if @all_bs_auction_banners;

    for my $bs_banner (@all_bs_banners) {
        $bs_banner->{phrases} = delete $bs_banner->{_all_phrases} if exists $bs_banner->{_all_phrases};
    }

    for my $campaign (@$campaigns) {
        my $currency = $campaign->{currency};
        die 'no currency given' unless $currency;
        my $max_show_bid = get_currency_constant($currency, 'MAX_SHOW_BID');
        my $default_price = get_currency_constant($currency, 'DEFAULT_PRICE');

        my $ContextPriceCoef = $OPT{ContextPriceCoef_from_campaign}
                                ? ($campaign->{strategy}->{name} ne 'different_places'
                                        ? $campaign->{ContextPriceCoef}
                                        : undef)
                                : $OPT{ContextPriceCoef};

        for my $group (@{$campaign->{groups}}) {
            my $common_price = $group->{_common_price};
            if (@{ $group->{_phrases} }) {
                my $bs_banner = $group->{_bs_banner};
                # возвращаем фразу
                for my $phrase (@{$bs_banner->{phrases}}) {
                    if (exists $phrase->{_phrase}) {
                        $phrase->{phrase} = delete $phrase->{_phrase};
                    }
                }

                my %old_ph = %{$group->{_old_ph}};
                for my $p ( @{$group->{_phrases}} ) { # После trafaret_auction @phrases дополнились данными из БК
                    if ( defined $old_ph{$p->{md5}}->{md5} ) {
                        $p->{price_context} = $old_ph{$p->{md5}}->{price_context} || $default_price;
                        $p->{phrase_old} = $old_ph{$p->{md5}}->{phrase_old};
                    } else {
                        # Вычисляем цену
                        next if $only_new_phrases_price_calc && $p->{md5} && !exists $bs_banner->{_MD5NEW}->{$p->{md5}};

                        my $price;
                        if ( $campaign->{autobudget} eq 'Yes' ) {
                            $price = $default_price;
                        } elsif ( $common_price ) {
                            $price = $common_price;
                        } else {
                            # Если там что-то было
                            $price = $p->{nobsdata} || $p->{banner_without_text}
                                ? $default_price
                                : ($p->{guarantee}->[0]->{bid_price}*$AUTO_BROKER_INCREASE)/1e6;
                            $price = $max_show_bid if $price > $max_show_bid;
                        }
                        $p->{flag_new} = 1;
                        $p->{price} = currency_price_rounding($price, $currency, up => 1);
                        $p->{price_context} = phrase_price_context($p->{price}, $ContextPriceCoef, $currency);

                        next if $p->{nobsdata};

                        my $autobroker_params = hash_merge {
                                                        price => $p->{price},
                                                        camp_rest => $campaign->{camp_rest},
                                                        day_budget => $campaign->{day_budget},
                                                        spent_today => $campaign->{spent_today},
                                                        strategy_no_premium => $campaign->{strategy_decoded}->{name} eq 'no_premium'
                                                                ? $campaign->{strategy_decoded}->{place}
                                                                : undef,
                                                        autobudget => $campaign->{autobudget},
                                                        autobudget_bid => $campaign->{strategy_decoded}->{bid},
                                                        min_price => $p->{min_price},
                                                        currency => $currency,
                                                        banner_without_text => $p->{banner_without_text},
                                                    },
                                                    AutoBroker::parse_prices($p);

                        $p->{broker} = AutoBroker::calc_price($autobroker_params)->{broker_price};
                    }
                    $p->{$_} ||= 0 for qw/ctx_shows ctx_clicks ctx_ctr/;
                }
            }
            $group->{phrases} = $group->{_phrases};

            # цену broker_price выводим в окошке цены для всего баннера
            if ( $common_price ) {
                $group->{broker_price} = $common_price;
            } else {
                delete $group->{broker_price};
            }

            delete $group->{$_} for qw/_phrases _bs_banner _common_price _old_ph/;
        }

        if ($campaign->{strategy}->{name} eq 'different_places') {
            my @take_pokazometer = grep { !$_->{is_bs_rarely_loaded} } @{$campaign->{groups}};
            safe_pokazometer(\@take_pokazometer, net => 'context', get_all_phrases => 1) if @take_pokazometer;
        }
    }
}


=head2 get_camp_banners_status

    получить информацию о статусах баннеров кампании

    в sql-условии намеренно оставлена избыточная конструкция
        $MTools::IS_ACTIVE_CLAUSE
        && not (b.statusPostModerate='Yes' and ph.statusPostModerate='Yes' and (IFNULL(b.href,'') != '' or b.phoneflag='Yes))
    для упрощения последующего рефакторинга

    на момент написания
        $IS_ACTIVE_CLAUSE = qq| (
                                    ph.statusPostModerate='Yes' AND b.statusPostModerate='Yes' AND (IFNULL(b.href,'') != '' OR b.phoneflag = 'Yes')
                                    OR  b.statusActive='Yes'
                                 ) AND b.statusShow='Yes' |;
    т.е. вышеназванная конструкция редуцируется до
        b.statusActive = 'Yes' AND b.statusShow = 'Yes'
        && not (b.statusPostModerate='Yes' and ph.statusPostModerate='Yes' and (IFNULL(b.href,'') != '' or b.phoneflag='Yes))

=cut

sub get_camp_banners_status {
    my ($cid) = @_;

    return { running_unmoderated => 0 } unless $cid;

    my ($group, $total) = get_groups({
        cid => $cid, tab => 'running_unmoderated',
        limit => 1, offset => 0
    }, {pure_groups => 1, only_pid => 1});

    return {running_unmoderated => $total || 0};
}

#-----------------------------------------------------------


=head2 check_mcb_geo_min_shows

    Проверить, что заказанное количество показов не меньше установленного минимума (минимум зависит от геотаргетинга и типа продукта). Если нет, то вернуть текст предупреждения.

=cut

sub check_mcb_geo_min_shows($$$) {
    my ($form, $vars, $opt) = @_;

    return undef if $vars->{mediaType} ne 'mcb';

    my $reason;

    $form->{geo} = refine_geoid($form->{geo}, \$vars->{geoflag}, {ClientID => $opt->{ClientID}, tree => $opt->{tree}});

    my ($old_min_shows, $old_reg) = get_mcb_geo_min_shows([$vars->{geo}], {ClientID => $opt->{ClientID}, tree => $opt->{tree}, product_type => $opt->{product_type}});
    my ($new_min_shows, $new_reg) = get_mcb_geo_min_shows([$form->{geo}], {ClientID => $opt->{ClientID}, tree => $opt->{tree}, product_type => $opt->{product_type}});

    if ( ($vars->{last_pay_time}||'2008-08-30') ge '2008-09-01' and ($vars->{sum_units}||0) < $new_min_shows and $new_min_shows > $old_min_shows ) {
        if (is_turkish_mcb($opt->{product_type})) {
            # сейчас для турецкого МКБ ограничение везде одинаковые, однако в будущем может понадобиться новый текст предупреждения
            $reason = iget("Медийная кампания может показываться только при сумме баланса от %d тыс. показов", $new_min_shows/1000);
        } else {
            $reason = iget("Медийные кампании, оплаченные после 1 сентября 2008 года, могут показываться на %s регион только при сумме баланса от %d тыс. показов",
                        ($new_reg eq 'moscow' ? 'московский' : 'северо-западный'),
                        $new_min_shows/1000);
        }
    }

    return $reason;
}


=head2 @errors = validate_common_geo($cid, $new_geo, $opt);

    Проверка, можно ли установить указанный единый таргетинг кампании
    Именованные параметры:
        ClientID -- клиент, для использования из интерфейса
        tree -- использование транслокального дерева (для АПИ)

=cut
sub validate_common_geo($$$) {
    my ($cid, $new_geo, $opt) = @_;
    return () if !$cid || !defined $new_geo;

    my $translocal_opt = $opt->{ClientID} ? {ClientID => $opt->{ClientID}} : {tree => $opt->{tree}};
    if (get_camp_type(cid => $cid) eq 'performance') {
        my $creatives = get_all_sql(PPC(cid => $cid),
            ["SELECT pc.sum_geo
            FROM phrases p
            JOIN banners_performance bp USING(pid)
            JOIN perf_creatives pc USING (creative_id)",
            WHERE => {'p.cid' => $cid},
            "GROUP BY pc.creative_id"]);

        my $adgroup = new Direct::Model::AdGroupPerformance->new(geo => $new_geo);
        for my $creative (@{Direct::Model::Creative->from_db_hash_multi($creatives)}) {
            my $geo_error = Direct::Validation::BannersPerformance::validate_creative_geo($creative, $adgroup, translocal_opts => $translocal_opt);
            if ($geo_error) {
                return iget('Геотаргетинг кампании шире списка стран её cмарт-баннеров');
            }
        }
    } else {
        my $camp_content_lang = content_lang_to_save($opt->{content_lang});
        my %langs;

        if ($camp_content_lang) {
            $langs{$camp_content_lang} = 1;
        } else {
            # определяем язык объявлений
            my $camp_lang = get_camps_banners_lang($cid)->{$cid};
            %langs = %$camp_lang if $camp_lang;
        }

        delete $langs{ru};
        if (keys(%langs) > 1) {
            return iget('Тексты некоторых объявлений написаны на украинском или казахском или турецком языках, установить единый географический таргетинг невозможно.');
        } elsif ($langs{uk} && !is_targeting_in_region($new_geo, $geo_regions::UKR, $translocal_opt)) {
            return iget('Тексты некоторых объявлений написаны на украинском языке, единый географический таргетинг должен быть установлен на Украину.');
        } elsif ($langs{kk} && !is_targeting_in_region($new_geo, $geo_regions::KAZ, $translocal_opt)) {
            return iget("Вами установлен регион для показа объявлений: %s. Пожалуйста, установите один географический регион «Казахстан» (отключите все остальные регионы), поскольку текст объявления написан на казахском языке.", get_geo_names($new_geo));
        } elsif ($langs{tr} && !is_targeting_in_region($new_geo, $geo_regions::TR, $translocal_opt)) {
            return iget('Тексты некоторых объявлений написаны на турецком языке, единый географический таргетинг должен быть установлен на Турцию.');
        } elsif ($langs{be} && !is_targeting_in_region($new_geo, $geo_regions::BY, $translocal_opt)) {
            return iget('Тексты некоторых объявлений написаны на белорусском языке, единый географический таргетинг должен быть установлен на Беларусь.');
        }
    }
    return ();
}

=head2 validate_common_lang

    Проверка, можно ли установить указанный единый язык кампании
    Именованные параметры:
        ClientID -- клиент, для использования из интерфейса
        tree -- использование транслокального дерева (для АПИ)

=cut

sub validate_common_lang {
    my ($cid, $new_lang, $opt) = @_;
    return () if !$cid || get_camp_type(cid => $cid) eq 'performance';
    my $translocal_opt = $opt->{ClientID} ? {ClientID => $opt->{ClientID}} : {tree => $opt->{tree}};

    $new_lang = content_lang_to_save($new_lang);
    my $banners = Direct::Banners->get_by(campaign_id=>$cid);

    my @errors_arr;
    my $pids = [uniq map {$_->adgroup_id} @{$banners->items}];
    my $geos = get_hash_sql(PPC(pid => $pids), ['SELECT pid, geo FROM phrases', where=>{pid=>$pids}]);
    my $error;
    foreach my $banner (@{$banners->items}) {
        $banner->adgroup($banner->adgroup_class->new(id => $banner->adgroup_id, geo => $geos->{$banner->adgroup_id}));
        $error = Direct::Validation::Banners::validate_banner_geo_targeting($banner, $banner->adgroup->geo, $new_lang);
        last if $error;
    }

    return $error ? ($error->text) : ();

}

=head2 get_camps_banners_lang

    Определяет для каждой камании какие в баннерах используются языки.
    Возвращает хеш вида:
    {cid_1 => {'ru' => 5, 'tr' => 3, 'en' => 7},
     cid_2 => {...}
    }

=cut
sub get_camps_banners_lang {
    my ($cids) = @_;

    my $banners = Direct::Banners->get_lang_banners(campaign_id => $cids)->items;
    my %langs;
    for my $banner (@$banners) {
        $langs{$banner->campaign_id}->{$banner->detect_lang}++;
    }
    return \%langs;
}

#-----------------------------------------------------------

=head2 get_user_count_mails

    my $user_count_mails = get_user_count_mails($rbac, $UID, $uid);

=cut

sub get_user_count_mails
{
    my ($rbac, $UID, $uid) = @_;

    my %emails;
    my $user_email = get_one_user_field($uid, 'email');
    $emails{$user_email} = 1 if $user_email;

    my $camps = [];
    my $cids = rbac_get_campaigns_for_edit($rbac, $UID, $uid);

    my $camps_emails = [];
    if (@$cids) {
        $camps_emails = get_one_column_sql(PPC(uid => $uid), ["select distinct IFNULL(o.email, u.email) as email
                                                   from campaigns c
                                                     join users u on c.uid = u.uid
                                                     left join camp_options o on c.cid = o.cid
                                                  "
                                                  , where => {
                                                                 'c.cid' => $cids
                                                                 , 'c.uid' => $uid
                                                                 , statusEmpty => 'No'
                                                                 , archived => 'No'
                                                             }
                                                 ]
                                          ) || [];
    }

    if (@$camps_emails) {
        $emails{$_} = 1 for @$camps_emails;
    }

    return scalar keys %emails; # get count
}

#-----------------------------------------------------------

=head2 send_banners_to_moderate

    Посылаем список баннеров на модерацию(функция работает с adgroup, посылаются все баннеры из группы на модерацию)

    send_banners_to_moderate([bid1, bid2, ...], options);
    Не завершенные группы не отправляются на модерацию.

    options - хеш:
        moderate_whole_group => true по умолчанию: отправлять на модерацию всю группу переданного банера, или только баннер
        skip_mobile_content => (0|1), если 1 - не переотправлять на модерацию мобильный контент (у него нету статуса Черновик, и он модерируется один раз,
                                               без привязки к группе/баннеру, потому есть смысл его перемодерировать только при вручную требуемой перемодерации)
        filter_by_status_moderate => [qw/Sent Sending/] - отправлять на модерацию только объекты которые находятся в соотв. статусе модерации
        moderate_accept => 1 - автомодерация баннеров
        moderate_accept_skip => \@adgroup_types - пропускать автомодерацию баннеров из групп этих типов

    При отправке на модерацию конкретного баннера (moderate_whole_group => 0) - условия не отправляются

=cut

sub send_banners_to_moderate
{
    my $bids = shift;
    my $options = shift;

    $options = {} unless $options;
    $options->{moderate_whole_group} //= 1;

    state $enable_content_promotion_auto_moderation //= Property->new('content_promotion_auto_moderation');
    state $enable_cpm_geoproduct_auto_moderation //= Property->new('cpm_geoproduct_auto_moderation');
    state $enable_cpm_geo_pin_auto_moderation //= Property->new('cpm_geo_pin_auto_moderation');
    state $enable_content_promotion_collection_auto_moderation //= Property->new('content_promotion_collection_auto_moderation');
    my $cpm_geoproduct_auto_moderation = $enable_cpm_geoproduct_auto_moderation->get(60) // 0;
    my $cpm_geo_pin_auto_moderation = $enable_cpm_geo_pin_auto_moderation->get(60) // 0;
    my %content_promotion_auto_moderation_by_content_type = (
        video => $enable_content_promotion_auto_moderation->get(60) // 0,
        collection => $enable_content_promotion_collection_auto_moderation->get(60) // 0,
        service    => 1,
        eda        => 1,
    );

    my $status_filter = ($options->{filter_by_status_moderate} && @{$options->{filter_by_status_moderate}})
                            ? $options->{filter_by_status_moderate}
                            : undef;


    return unless ref($bids) eq 'ARRAY' && @$bids;

    my @adgroup_types = qw/base dynamic mobile_content performance mcbanner cpm_banner cpm_video cpm_outdoor cpm_yndx_frontpage content_promotion_video cpm_indoor cpm_audio cpm_geoproduct cpm_geo_pin content_promotion cpm_geo_pin/;

    my %automoderate_skip = map {$_ => 1} @{$options->{moderate_accept_skip} || []};
    my %automoderate_type =
        map {$_ => 1}
        grep {$options->{moderate_accept} && !$automoderate_skip{$_}}
        @adgroup_types;

    my ($base_groups, $performance_groups) = ([], []);
    {
        my $pids = get_pids(bid => $bids);
        my $groups = get_groups({
            pid => $pids,
            adgroup_types => \@adgroup_types,
        }, {
            only_creatives => 1,
            pass_empty_groups => 0
        });
        for my $group (@$groups) {
            next unless $group->{is_completed_group} || $options->{do_not_take_into_account_group_completeness};
            if ($group->{adgroup_type} eq 'performance') {
                if (grep { $_->{real_banner_type} eq 'performance_main' } @{ $group->{banners} }) {
                    push @$base_groups, $group;
                } else {
                    push @$performance_groups, $group;
                }
            } else {
                push @$base_groups, $group;
            }
        }
     }

    # Модерация перфоманс баннеров делается через Direct::Banners::Performance
    if (@$performance_groups) {
        my @bids_performance = map { $_->{bid} } map { @{$_->{banners}} } @$performance_groups;
        my $obj_banners = Direct::Banners::Performance->get(\@bids_performance);
        my $id2adgroup = Direct::AdGroups2::Performance->get([uniq map { $_->adgroup_id } @{$obj_banners->items}], extended => 1)->items_by;
        $_->adgroup($id2adgroup->{$_->adgroup_id}) for @{$obj_banners->items};
        $obj_banners->moderate;
        return 1 if !@$base_groups;
    }

    my %bids_map = map { $_ => 1 } @$bids;
    my (@bids_to_moderate, @bids_to_auto_moderate, @bids_not_to_moderate,  @creative_bids_to_moderate, @post_moderate, %mobile_content_moderate);
    my (@pids_to_moderate);
    my (%cids, %user_allow_post, %skip_cpm_price_pids);

    my $clientId_to_uid = get_key2clientid(uid => [map {$_->{uid}} @$base_groups]);

    foreach my $group (@$base_groups) {
        unless (exists $user_allow_post{$group->{uid}}) {
            $user_allow_post{$group->{uid}} =
                (get_one_field_sql(PPC(uid => $group->{uid}), "select statusPostmoderate from users_options where uid = ?", $group->{uid}) || 'No') eq 'Yes';
        }
        if ($group->{camp_type} eq 'cpm_price') {
            #запрещаем перемодерировать дефолтные группы в кампаниях, которые показываются (status_show), заапрувлены (status_approve) и корректно созданы (status_correct)
            if (!defined $skip_cpm_price_pids{$group->{pid}}) {
                my $is_default_group = get_one_field_sql(PPC(uid => $group->{uid}),
                    "select priority from adgroup_priority where pid = ?", $group->{pid}) == $Settings::DEFAULT_CPM_PRICE_ADGROUP_PRIORITY;
                my ($status_show, $status_approve, $status_correct) = get_one_line_array_sql(PPC(uid => $group->{uid}),
                    "select c.statusShow, ccp.status_approve, ccp.status_correct
                    from campaigns c
                    join campaigns_cpm_price ccp using(cid)
                     where c.cid = ?", $group->{cid});
                if ($is_default_group && $status_show eq 'Yes' && $status_approve eq 'Yes' && $status_correct eq 'Yes') {
                    $skip_cpm_price_pids{$group->{pid}} = 1;
                } else {
                    $skip_cpm_price_pids{$group->{pid}} = 0;
                }
            }
            if ($skip_cpm_price_pids{$group->{pid}}) {
                next;
            }
        }
        my $clientId = $clientId_to_uid->{$group->{uid}};
        ## no critic (Freenode::DollarAB)
        foreach my $b (@{$group->{banners}}) {
            next unless $options->{moderate_whole_group} || $bids_map{$b->{bid}};
            push @post_moderate, [$b->{bid}] if $user_allow_post{$group->{uid}};

            my $banner_auto_moderation = ($group->{camp_type} eq 'content_promotion' &&
                $content_promotion_auto_moderation_by_content_type{$group->{content_promotion_content_type}})
                                      || ($b->{adgroup_type} eq 'cpm_geoproduct' && $cpm_geoproduct_auto_moderation)
                                      || ($b->{adgroup_type} eq 'cpm_geo_pin' && $cpm_geo_pin_auto_moderation);
            # Автопринятие оверлейных баннеров
            if (defined $b->{creative_layout_id}
                && $b->{creative_layout_id} >= $CPM_OVERLAY_ADDITION_LAYOUT_ID_MIN
                && $b->{creative_layout_id} <= $CPM_OVERLAY_ADDITION_LAYOUT_ID_MAX) {
                $banner_auto_moderation = 1;
            }

            if ($banner_auto_moderation) {
                push @bids_not_to_moderate, $b->{bid};
            } else {
                push @bids_to_moderate, $b->{bid};
                push @bids_to_auto_moderate, $b->{bid}  if $automoderate_type{$b->{adgroup_type}};
            }
            if (!$banner_auto_moderation) {
                push @creative_bids_to_moderate, $b->{bid};
            }
        }
        $cids{$group->{cid}} = 1;
        push @pids_to_moderate, $group->{pid};

        if (!$options->{skip_mobile_content} && $group->{mobile_content_id}) {
            push @{$mobile_content_moderate{$group->{uid}}}, $group->{mobile_content_id};
        }
    }

    return 0 unless @bids_to_moderate || @bids_not_to_moderate;

    my $update_statuses_before = Models::Banner::get_update_before();

    my $cids_to_moderate = [keys %cids];
    do_update_table(PPC(cid => $cids_to_moderate), 'campaigns', {statusModerate => 'Ready'},
                        where => {cid => SHARD_IDS, statusModerate => ['New', 'No']});

    if (@pids_to_moderate && $options->{moderate_whole_group}) {
        do_sql(PPC(pid => \@pids_to_moderate), [q{
                UPDATE
                    phrases g
                    LEFT JOIN adgroups_dynamic gd ON (g.adgroup_type = 'dynamic' AND gd.pid = g.pid)
                    LEFT JOIN adgroups_performance ad_perf ON (g.adgroup_type = 'performance' AND ad_perf.pid = g.pid)
                SET
                    g.statusModerate = 'Ready',
                    g.statusPostModerate = IF(statusPostModerate = 'Rejected', 'Rejected', 'No'),
                    g.LastChange = g.LastChange,
                    gd.statusBlGenerated = 'Processing',
                    ad_perf.statusBlGenerated = 'Processing'
            }, WHERE => {
                'g.pid' => SHARD_IDS,
                ($status_filter ? ('g.statusModerate' => $status_filter) : ()),
        }]);

        foreach_shard uid => [keys %mobile_content_moderate], sub {
            my ($shard, $uids) = @_;
            do_update_table(PPC(shard => $shard), 'mobile_content', {
                statusIconModerate => 'Ready'
            }, where => {
                mobile_content_id => [map { @{$mobile_content_moderate{$_}} } @$uids],
                $status_filter ? (statusIconModerate => $status_filter) : ()
            });
        };
    }

    return 1 unless @bids_to_moderate;

    my $ppc_shard = PPC(bid => \@bids_to_moderate);
    my $status_filter_sql = $status_filter ? '(' . (join ',', map { sql_quote($_) } @$status_filter) . ')' : '';

    if ($options->{pre_moderate} && @bids_to_moderate) {
        Moderate::ReModeration->set_pre_moderation_flag(\@bids_to_moderate);
    }

    if ($options->{moderate_accept} && @bids_to_auto_moderate) {
        Moderate::ReModeration->set_auto_moderation_flag(\@bids_to_auto_moderate);
    }

    # при отправке с фильтрацией по статусам учитываем следующую логику:
    # если переотправляется сам баннер - то переотправляются и все его подобъекты (визитка и сайтлинки)
    # используем do_sql, поскольку важен порядок в котором перечислены поля в set
    do_sql($ppc_shard, [qq/UPDATE banners SET
                                  LastChange = LastChange,/,
                            join(', ',
                        'phoneflag = ' .
                                    sprintf("IF(vcard_id is not null %s, 'Ready', phoneflag)",
                                             $status_filter_sql ?
                                             "and (statusModerate in $status_filter_sql or phoneflag in $status_filter_sql)" :
                                             '' ),
                        'statusSitelinksModerate = '.
                                    sprintf("IF(sitelinks_set_id is not null %s, 'Ready', statusSitelinksModerate)",
                                             $status_filter_sql ?
                                             "and (statusModerate in $status_filter_sql or statusSitelinksModerate in $status_filter_sql)" :
                                             '' ),
                        'statusModerate = '. ($status_filter_sql ?
                                              "IF(statusModerate IN $status_filter_sql, 'Ready', statusModerate)" :
                                              "'Ready'"),
                        "statusPostModerate = IF(statusPostModerate = 'Rejected', 'Rejected',
                                                 IF(statusModerate = 'Ready', 'No', statusPostModerate) )"
                                ), where => {bid => SHARD_IDS,
                                             $status_filter ? (
                                                _OR => [statusModerate => $status_filter,
                                                        _AND => {vcard_id__is_not_null => 1,
                                                                 phoneflag => $status_filter},
                                                        _AND => {sitelinks_set_id__is_not_null => 1,
                                                                 statusSitelinksModerate => $status_filter},
                                                       ]
                                                ) : ()}]);


    for my $banner_table (qw/banner_images images banners_performance banner_display_hrefs
                             banner_turbolandings banner_logos banner_buttons banner_multicard_sets/) {
        my $shard_cond = $ppc_shard;
        if ($banner_table eq 'banners_performance') {
            if (@creative_bids_to_moderate){
                $shard_cond = PPC(bid => \@creative_bids_to_moderate);
            }
        }

        do_update_table($shard_cond, $banner_table,
          {statusModerate => 'Ready'},
          where => {
              bid => SHARD_IDS,
              ($banner_table eq 'banner_images' ? (statusShow => 'Yes') : ()),
              ($status_filter ? (statusModerate => $status_filter) : ()),
          });
    }

    do_update_table($ppc_shard, 'perf_creatives pc join banners_performance bp on bp.creative_id = pc.creative_id',
        {'pc.statusModerate' => 'Ready'},
        where => {
            'bp.bid' => SHARD_IDS,
            'pc.creative_type' => 'bannerstorage',
            'pc.statusModerate__in' => [ qw( New Error ) ],
        });

    if (!$status_filter || !all { /Sending|Sent/ } @$status_filter) {
        Direct::Banners::mark_deleted_moderate_banner_pages(bid => \@bids_to_moderate, check_status => 1);
    }

    if (!$status_filter || !all { /Sending|Sent/ } @$status_filter) {
        Direct::Banners::delete_minus_geo(bid => \@bids_to_moderate, check_status => 1);
    }

    do_mass_insert_sql($ppc_shard,
                        'INSERT IGNORE post_moderate(bid) VALUES %s',
                        \@post_moderate) if $options->{post_moderate} && @post_moderate;

    return 1;
}

=head2 fix_statusModerate_for_ess_moderation

    Ess модерация требует чтобы появилось событие - переход объекта в Ready. После разархивации статус объектов может остаться в Sending, и такие объекты не будут
    отправлены на модерацию

=cut

sub fix_statusModerate_for_ess_moderation {
    my ($bids) = @_;

    if (!@$bids) {
        return;
    }

    # Переводим Ready в Sent чтобы потом перевести обратно в Ready, нужно чтобы ess увидел событие
    _fix_statusModerate_for_unarchived_objects($bids, ['Ready'], 'Sent');

    send_banners_to_moderate($bids, {moderate_whole_group => 1,
                                      filter_by_status_moderate => [qw/Sending Sent/],
                                      do_not_take_into_account_group_completeness => 1});
}

sub _fix_statusModerate_for_unarchived_objects {
    my ($bids, $fromStatuses, $toStatus) = @_;

    my $ppc_shard = PPC(bid => $bids);

    my $from_statuses_str = join(',',  map { sql_quote($_) } @$fromStatuses);
    my $to_status_str = sql_quote($toStatus);

    my $banner_sql_template = qq/UPDATE banners
                                 SET
                                      LastChange = LastChange,
                                      phoneflag = IF(vcard_id is not null and (phoneflag in ({from})), '{to}', phoneflag),
                                      statusSitelinksModerate = IF(sitelinks_set_id is not null and (statusSitelinksModerate in ({from})), '{to}', statusSitelinksModerate),
                                      statusModerate = IF(statusModerate IN ({from}), '{to}', statusModerate)/;

    $banner_sql_template =~ s/{from}/$from_statuses_str/g;
    $banner_sql_template =~ s/{to}/$toStatus/g;

    do_sql($ppc_shard, [ $banner_sql_template, where => {bid => SHARD_IDS} ]);

    for my $banner_table (qw/banner_images images banners_performance banner_display_hrefs banner_turbolandings phrases/) {
        do_update_table($ppc_shard, $banner_table,
          {statusModerate => $toStatus},
          where => {
              bid => SHARD_IDS,
              statusModerate => $fromStatuses,
          });
    }

}

#-----------------------------------------------------------

=head2 get_user_camps_stat($uid)

Возвращаяет мини-статистику по кампаниям пользователя

Результат: хеш с полями

    wallet_cid
    noarch_cnt              => 1,      # количество неархивных кампаний у пользователя
    arch_cnt                => 5,      #   --//--   архивных     --//--
    dynamic_campaigns_count
    performance_campaigns_count
    mcbanner_campaigns_count
    cpm_banner_campaigns_count
    cpm_deals_campaigns_count
    cpm_yndx_frontpage_campaigns_count
    internal_distrib_count
    internal_free_count
    content_promotion_count

=cut

sub get_user_camps_stat {
    my ($uid, $options) = @_;

    my $stat = get_one_line_sql(PPC(uid => $uid), [q{
                                            SELECT SUM(archived = 'No') AS noarch_cnt,
                                                   SUM(archived = 'Yes') AS arch_cnt,
                                                   SUM(c.type = 'dynamic') AS dynamic_campaigns_count,
                                                   SUM(c.type = 'performance') AS performance_campaigns_count,
                                                   SUM(c.type = 'mcbanner') AS mcbanner_campaigns_count,
                                                   SUM(c.type = 'cpm_banner') AS cpm_banner_campaigns_count,
                                                   SUM(c.type = 'cpm_deals') AS cpm_deals_campaigns_count,
                                                   SUM(c.type = 'cpm_yndx_frontpage') AS cpm_yndx_frontpage_campaigns_count,
                                                   SUM(c.type = 'internal_distrib') AS internal_distrib_campaigns_count,
                                                   SUM(c.type = 'internal_free') AS internal_free_campaigns_count,
                                                   SUM(c.type = 'content_promotion') AS content_promotion_campaigns_count,
                                                   SUM(c.type = 'cpm_price') AS cpm_price_campaigns_count,
                                                   group_concat(if(wallet_cid > 0, c.wallet_cid, null)) AS wallet_cid
                                            FROM users u
                                            INNER JOIN users uc ON u.ClientID = uc.ClientID
                                            INNER JOIN campaigns c ON uc.uid = c.uid},
                                            WHERE => {
                                                'u.uid' => $uid,
                                                'u.ClientID__gt' => 0,
                                                'c.statusEmpty' => 'No',
                                                'c.type' => get_camp_kind_types("web_edit_base"),
                                                # сконвертированные кампании не учитываем вообще
                                                _NOT => [
                                                    # такой же кусок условия есть в Client::get_client_campaign_count
                                                    'c.currencyConverted' => 'Yes',
                                                    _TEXT => 'IFNULL(c.currency, "YND_FIXED") = "YND_FIXED"',
                                                ],
                                            }]);

    return $stat;
}

#-----------------------------------------------------------

=head2 get_campaigns_with_context_limit($options)

    Все поля $options необязательные.

    $options = {
        manager_uid => ,
        agency_uid => ,
        login => ,
        client_uid => ,
        client_id => ,
        order_id => ,
        cid => ,
        limit => || 1000,
    }

=cut
{
    my %DEF_PARAMS = (
        manager_uid => 'c.ManagerUID',
        agency_uid => 'c.AgencyUID',
        login => 'u.login',
        client_uid => 'u.uid',
        client_id => 'u.ClientID',
        order_id => 'c.OrderID',
        cid => 'c.cid',
    );

    my %SORT_NAMES = (
        unlimited => 1,
        limited => 2,
        unchecked => 3,
        standard => 0,
    );

sub get_campaigns_with_context_limit
{
    my ($options) = @_;

    return undef unless scalar grep {$options->{$_}} keys %$options;

    my $quoted = {};
    foreach my $k (grep {defined $options->{$_}} keys %$options) {
        $quoted->{$k} = join ",", map {sql_quote($_)} split(/,/, $options->{$k});
    }

    my @conds = ("c.archived != 'Yes'"
                    , "c.statusEmpty != 'Yes'"  # непустые кампании
                    , "c.OrderID > 0"           # кампании побывавшие в БК
                    , "c.type='text'"           # кампании с текстовыми объявлениями
                    , "c.ManagerUID > 0"        # сервисируемые кампании
                    , map {"$DEF_PARAMS{$_} in (".$quoted->{$_}.")"}
                     grep {defined $DEF_PARAMS{$_} && defined $options->{$_}}
                     keys %$quoted );

    if ($options->{active_camps}) {
        # кампании с деньгами
        push @conds, "(c.sum - c.sum_spent) > 0.01";
    }

    my $i_sql = join(" AND ", @conds) || "1";

    my $sql = "select u.uid, u.ClientID, u.login, c.cid, c.OrderID, c.ManagerUID, c.AgencyUID
                      , c.sum, c.sum_spent
                      , c.platform
                      , IFNULL(s.ContextLimit, 0) as ContextLimit
                      , c.ContextPriceCoef
                      , u.fio
                 from campaigns c
                      left join users u using(uid)
                      left join strategies s on c.strategy_id = s.strategy_id
                where $i_sql";

    #print STDERR "SQL:$sql";

    my $data = get_all_sql(PPC(shard => 'all'), $sql) || [];
    foreach my $dt (@$data) {
        if ($dt->{platform} eq 'search') {

            $dt->{sort_flag} = $SORT_NAMES{unchecked};
            $dt->{type} = 'unchecked';

        } elsif ($dt->{platform} ne 'search'
                    && ($dt->{ContextLimit} > 0
                            && $dt->{ContextLimit} < 100
                            || $dt->{ContextPriceCoef} != 100)
        ) {
            $dt->{sort_flag} = $SORT_NAMES{limited};
            $dt->{type} = 'limited';

        } elsif ($dt->{platform} ne 'search' && $dt->{ContextLimit} == 255) {

            $dt->{sort_flag} = $SORT_NAMES{unlimited};
            $dt->{type} = 'unlimited';

        } else {
            $dt->{sort_flag} = $SORT_NAMES{standard};
            $dt->{type} = 'standard';
        }
    }

    return [sort {$b->{sort_flag} <=> $a->{sort_flag}} @$data];
}
}

# ---------------------------------------------------------------------------------------------------------------------------


=head2 change_uid

    change uid in db (campaigns, banners, media banners ...)

    Если почему-то оказалось , что кампания сохранилась не на главного представителя, а на какого-то другого (этого не должно быть, но иногда бывает) --
    можно поменять uid на всех кампаниях/объявлениях (с визитками и медиапланами) неглавного представителя.
    Все кампании с uid 111 переписываем на uid 222, в корне рабочей копии с нужной конфигурацией:
        perl -Iprotected -ME -le 'change_uid(PPC, 111, 222);'
    Важно! Сначала надо посмотреть в базе, какие именно кампании попадают под условие. И перед применением на production попробовать на dev/devtest

    Используется при изменении главного представителя клиента, переносе всех кампаний и объединении клиентов.

=cut

sub change_uid($$)
{
    my ($old_uid, $new_uid) = @_;

    croak "Users MUST be at the same shard. Please, move it before." if (get_shard(uid => $new_uid) != get_shard(uid => $old_uid));
    foreach my $r (qw/campaigns vcards org_details/) {
        do_update_table(PPC(uid => $old_uid), $r, {uid => $new_uid}, where => {uid => $old_uid});
    }
    #не используем do_update_table из-за необходимости в update ignore
    do_sql(PPC(uid => $old_uid), "update ignore user_campaigns_favorite set uid = ? where uid = ?", $new_uid, $old_uid);
    do_update_table(PPCDICT, 'xls_reports',  {uid => $new_uid}, where => {uid => $old_uid});
}


# ---------------------------------------------------------------------------------------------------------------------------

=head2 get_competitors

  Получает из БК список конкурентов по списку фраз
  Для:
    * попапа "Объявления конкурентов"
    * поиска объявлений по фразе
    * в отчётах антиспама

  $options = {
    nocid        => 123456,     # не выбирать объявления из этой кампании
    geo          => '225,-213', # сделать выборку для указанного региона
    tmpl_process => 1,          # подставлять в шаблонное объявление запрос?
    strict_phrase => 1,         # поиск по строгому соответствию
    limit =>                    # ограничение на количество возвращаемых фраз
    translocal_opts => ...      # ссылка на хэш, с настройками транслокальности
  }

  для showCompetitors (объявления конкурентов): { nocid => $cid, geo => $geo, tmpl_process => 1, limit => 100 }

=cut
sub get_competitors
{
    my ($req, $options) = @_;

    my $O = {};
    hash_merge($O, $options);
    $O->{$_} ||= 0 for qw/nocid tmpl_process/;

    my $orderid = 0;
    $orderid = get_orderid(cid => $O->{nocid}) || 0 if $O->{nocid};

    my @params = ();
    # Создаём запрос для крутилки
    for my $tmp (@$req){
        $tmp =~ s/[\r\n,]/ /g;
        $tmp =~ s/"//g;
        my @tarr = split(/ /, $tmp);
        for my $iter  (0..$#tarr) {
            $tarr[$iter] =~ s/(\S)-(\S)/$1 $2/g if ($tarr[$iter] !~ /^-/);
        }
        $tmp = join(' ', @tarr);

        my $rest;
        if ($tmp =~ /^\#/) {
            $tmp =~ s/#//g;
            $rest = 'cycid:'.$tmp;
        } else {
            $rest = "text:" . ($O->{strict_phrase} ? q{~} : q{}) . uri_escape_utf8($tmp);
        }

        push @params, "target=0,$orderid,0:0,".$rest;
    }

    if ($options->{geo}) {
        (my $geo = $options->{geo}) =~ s/,/%0A/g;
        push @params, "reg-id=$geo";
    }

    if ($options->{get_all_ads}) {
        push @params, "all-ads-full=1";
    }

    my $que = join '&', @params;
    my $url = join('?', $Settings::BS_COMPETITORS_SEARCH_URL, $que);
    my $headers = HTTP::Headers->new(Host => $Settings::BSRANK_HOST);

    my $profile = Yandex::Trace::new_profile('common:get_competitors', tags => 'http_get');
    my $content = http_get($url, timeout => 5, default_headers => $headers);
    undef $profile;

    my ($sql_fields, $sql_tables) = ("","");
    $sql_fields .= ", bi.phrase" if $O->{tmpl_process};
    my $sql =
        "SELECT b.title, b.title_extension, b.href, b.domain, b.body, c.uid, b.bid, b.pid
                , b.BannerID, bi.PhraseID
                , p.cid
                , p.geo
                , vc.phone
                $sql_fields
           FROM banners b
                JOIN phrases p ON p.pid = b.pid
                JOIN bids bi ON bi.pid = b.pid
                JOIN campaigns c on c.cid = p.cid
                LEFT JOIN campaigns wc ON c.wallet_cid = wc.cid
                LEFT JOIN vcards vc ON vc.vcard_id = b.vcard_id
                $sql_tables
        ";

    my @banners;
    if ($content) {
        my $cnt = 0;
        my @competitors =
            map {$_->{pos} = $cnt++; $_}
            xuniq {$_->{BannerID}}
            grep {is_valid_int($_->{BannerID}, 1) && is_valid_int($_->{PhraseID}, 1)}
            @{_parse_bs_23($content)};

        if ($O->{limit} && $O->{limit} > 0) {
            @competitors = grep { ($_->{pos} // 0) < $O->{limit} } @competitors;
        }

        my %banner_id2bs = map {$_->{BannerID} => $_} @competitors;

        foreach_shard OrderID => \@competitors, chunk_size => 1000, sub {
            my ($shard, $competitors_chunk) = @_;
            my $rows = get_all_sql(PPC(shard => $shard), [
                                       $sql,
                                       WHERE => join(" OR ", map {"b.BannerID = $_->{BannerID} AND bi.PhraseID = $_->{PhraseID}"} @$competitors_chunk)
                                   ]
                );

            for my $banner_line (xuniq {"$_->{BannerID},$_->{PhraseID}"} @$rows) {
                if( $O->{tmpl_process}) {
                    $banner_line = hash_merge $banner_line, add_banner_template_fields($banner_line, [$banner_line]);
                }

                if ($O->{translocal_opts}) {
                    $banner_line->{geo} = GeoTools::modify_translocal_region_before_show($banner_line->{geo}, $O->{translocal_opts});
                }
                $banner_line->{region} = get_geo_names( $banner_line->{geo}, ', ' );

                $banner_line->{bs_info} = $banner_id2bs{$banner_line->{BannerID}};
                $banner_line->{price} = sprintf("%.2f", $banner_line->{bs_info}->{price} / 1000000);
                push @banners, $banner_line;
            }
        };

    }

    @banners = sort {$a->{bs_info}{pos} <=> $b->{bs_info}{pos}} @banners;

    my @manager_or_agency = xuniq {$_} map { $_->{ManagerUID} || $_->{AgencyUID} || () } @banners;
    my $users_data = get_users_data(\@manager_or_agency, [qw/uid login fio email/]);

    enrich_data(\@banners, using => 'ManagerUID', map_fields => {email => 'memail', login => 'mlogin', fio => 'mfio'}, sub { return $users_data });
    enrich_data(\@banners, using => 'AgencyUID', map_fields => {email => 'aemail', login => 'alogin', fio => 'afio'}, sub { return $users_data });

    return \@banners;
}

=head2 get_bids_by_phrase_text

  Получает из БК список id банеров по списку фраз
  для поиска объявлений по фразе

  принимает список текстов фраз
  возвращает список id банеров (banners.bid)

  my $bids = get_bids_by_phrase_text(['phrase text 1', 'phrase_text 2', ...])
  $bids: [bid1, bid2, bid3, ...]
=cut
sub get_bids_by_phrase_text {
    my ($req) = @_;

    my @phrase_text_list = ();
    for my $tmp (@$req) {
        next unless defined $tmp;
        $tmp =~ s/[\s\,\"]+/ /g;
        $tmp =~ s/(^\s+|\s+$)//g;
        next unless $tmp =~ /\S+/;
        next if $tmp =~ /^\#/;

        my @tarr = split /\s+/, $tmp;
        for my $text (@tarr) {
            $text =~ s/(\S)-(\S)/$1 $2/g if ($text !~ /^-/);
        }
        $tmp = join(' ', @tarr);

        push @phrase_text_list, uri_escape_utf8($tmp);
    }

    my @result;
    foreach my $text (@phrase_text_list) {
        my $url = sprintf("%s?bansearch-type=phrase&text=%s", $Settings::BS_FULLTEXT_SEARCH_URL, $text);
        my $headers = HTTP::Headers->new(Host => $Settings::BSRANK_HOST);

        my $profile = Yandex::Trace::new_profile('common:get_bids_by_phrase_text', tags => 'http_get');
        my $content = http_get($url, timeout => 5, default_headers => $headers);
        undef $profile;
        next unless $content;

        my $json_result = eval { from_json($content) };
        next if $@ || !$json_result || !$json_result->{banners};

        my @bids = grep {is_valid_id($_)} map {$_->{bid}} @{ $json_result->{banners} };
        push @result, @bids;
    }
    return \@result;
}

sub convert_spell_js
{
    my $result = shift;

    my $spell_result = [];
    if (defined $result->{error}) {
        foreach my $w (@{$result->{error}}) {
            push @$spell_result, {
                w => $w->{word} || '',
                s => $w->{s} || [],
            };
        }
    }
    return $spell_result;
}

=head2 round_easy_topay_sum( topay => 50, conv_unit_rate => 130 )

    Округляет сумму рекомендуемого платежа, чтобы она была красивой в нужных ден.единицах и удобной в у.е.

    Параметры:
        topay          -- рекомендуемая сумма платежа в у.е.
        conv_unit_rate -- курс у.е.

    Результат:
        рекомендуемая сумма платежа в национальной валюте

    Важно! Сумма пересчитывается из у.е. в национальную валюту!

    Для валютных клиентов conv_unit_rate == 1 и функция только округляет сумму до целого.
    multicurrency: если будет валюта, у которой дробные части существенны, то логику придётся менять.

=cut
sub round_easy_topay_sum
{
    my %options = @_;

    return POSIX::ceil($options{topay} * $options{conv_unit_rate}) unless int($options{conv_unit_rate}) == $options{conv_unit_rate};

    my $rsum = int $options{topay};

    # делаем сумму удобной в у.е...
    $rsum = 10*int(($rsum + 10)/10) if $rsum !~ /^\d+0$/;

    # ... и красивой в национальной валюте
    $rsum *= $options{conv_unit_rate};

    my $n = $options{conv_unit_rate} >= 20 ? 2 : 1; # Сколько нулей хотим видеть в конце суммы?

    if( $rsum !~ /^\d+0{$n,}$/ ) {
        my $pow_10 = 10 ** $n;
        $rsum = $pow_10 * int(($rsum + $pow_10)/$pow_10);
    }

    return $rsum;
}

# ---------------------------------------------------------------------------------------------------------------------------

=head2 ajax_adgroup_phrases_filter

    Очищаем структуры перед отправкой в шаблон при ajax-запросе для обновления ставок со страницы статистики
    или фраз со страницы просмотра кампании

=cut

sub ajax_adgroup_phrases_filter
{
    my $phrases = shift;
    my %options = @_;

    my @fields = qw/cid bid id PhraseID/;

    if ($options{filter_price}) {
        push @fields, qw/premium guarantee price
        autobudgetPriority numword
        price_for_coverage pokazometer_data price_context
        nobsdata price_for_mcbanner traffic_volume
        /;
    }

    if ($options{filter_retargetings}) {
        push @fields, qw/ret_cond_id ret_id/;
    }

    if ($options{filter_phrase}) {
        push @fields, qw/clicks Ctr ctx_clicks Shows context_scope
                         phrase phrase_unglued_suffix norm_phrase
                         fixation is_suspended/;
    }

    return [map {hash_cut $_, @fields} @$phrases];
}

# ---------------------------------------------------------------------------------------------------------------------------

=head2 calc_topay_sum

    Вычисляет, какую сумму показать пользователю на странице оплаты ("платеж по умолчанию")

    Принимает именованные параметры:
        campaign -- ссылка на хеш, описывающий кампанию, возвращаемый Campaign::get_camp_info
        c -- объект DirectContext
        not_resident -- 1 (НЕ резидент) или 0 (резидент; по умолчанию)
        dont_use_forecast -- опционально, для Профи-кампаний. Если флаг выставлен -- для topay суммы не будет учитываться прогноз расходов

    Возвращает ссылку на хеш :
        {
            daily_sum => 1234, # сумма дневных трат
            topay => 1234, # итоговый "платёж по умолчанию"
            topay_from_forecast => 500,    # только для текстовых кампаний.
                                          # Независимо от наличия dont_use_forecast -- подсказка платежа, которую мы дали бы исходя ТОЛЬКО из прогноза
                                          # если dont_use_forecast не выставлен, и клиент обычный, не Беззаботный -- то topay = topay_from_suggest
        }

    Огород с хешом вместо одного возвращаемого числа сделан потому,
    что кажется, что хочется, чтобы оба эти значения попадали в логи, чтобы по ним считать какие-нибудь циферки к презентации.

=cut

sub calc_topay_sum
{
    my (%O) = @_;

    die 'invalid campaign data' unless $O{campaign} && ref($O{campaign}) eq 'HASH' && is_valid_int($O{campaign}{cid}, 0) && $O{campaign}{currency};
    die 'invalid DirectContext object' unless $O{c} && $O{c}->isa('DirectContext');

    my $camp = $O{campaign};
    my $cid = $camp->{cid};
    my $res = {};

    my $currency = $camp->{currency};
    die 'no currency in campaign' unless $currency;

    my $topay = get_currency_constant($currency, 'DIRECT_DEFAULT_PAY');
    my $min_pay = get_currency_constant($currency, 'MIN_PAY');

    my $is_media = ($camp->{mediaType}||'text') ne 'text';

    if ( is_media_camp(type => $camp->{type}) ) {
        # Медийная кампания
        $topay = POSIX::ceil(get_mcb_camp_min_shows($cid) / 1000);
    } else {
        # Текстовая кампания

        # учитываем прогноз расходов на неделю
            my $price = get_one_field_sql(PPC(cid => $cid), "SELECT MAX(price) FROM bids WHERE cid = ?", $cid) || 0;
            $price = sprintf('%.2f', $price);
            $topay = max($topay, $price);

            my $weekly_expence_forecast;
            if ($camp->{autobudget} && $camp->{autobudget} eq 'Yes') {
                $weekly_expence_forecast = $camp->{strategy_decoded}->{sum};
            } else {
                $weekly_expence_forecast = Stat::OrderStatDay::get_camp_bsstat_forecast([$cid], $currency)->{$cid} * 7;
            }

            my $pay_suggest_from_forecast = int min($weekly_expence_forecast, get_currency_constant($currency, 'MAX_TOPAY_SUGGEST'));
            $pay_suggest_from_forecast = max($pay_suggest_from_forecast, $min_pay);

            # хитрое округление до целых цифр. гранулярность зависит от величины суммы
            my $q = $pay_suggest_from_forecast <= 70 ? 5: $pay_suggest_from_forecast <= 300 ? 25 : 50 ;
            $pay_suggest_from_forecast = (int(($pay_suggest_from_forecast - 1) / $q) + 1 ) * $q;
            $res->{topay_from_forecast} = $pay_suggest_from_forecast;

            unless($O{dont_use_forecast}){
                # если подсказка от прогноза увеличивает topay -- используем ее (и для простых, и для Беззаботных)
                $topay = max($topay, $pay_suggest_from_forecast);
            }
    }

    $topay = max($topay, $min_pay);

    $res->{topay} = $topay;

    return $res;
}

=head2 get_captcha_freq({karma=>123, captcha_freq => 122, is_autobanned => 'Yes'})

    Считает кол-во запросов для показа страницы с капчей
        на основе кармы, настроек пользователя в Директе и автобана за превышение числа фраз.

    Если пользователь явно не робот - то можно в инетрфейсе Директа поставить большое кол-во запросов для показа каптчи и снять галочку на автобан
    Если пользователь робот - то считаем частоту капчи в зависимости от кармы (от паспорта) или баним автоматически при превышении числа фраз

    Изменение не линейное, а сегментарное согласно @Settings::KARMA_LIMITS.

=cut

sub get_captcha_freq
{
    my $data = shift;

    my $captcha_freq = 0;
    if ($data->{captcha_freq}) {
        $captcha_freq = $data->{captcha_freq};
    } elsif ($data->{karma}) {
        $captcha_freq = int interpolate_const($data->{karma}, @Settings::KARMA_CONST_LIMITS);
    }
    # забаненым пользователям показываем каптчу не реже раза в $Settings::AUTOBAN_CAPTCHA_FREQ запросов
    if ($data->{is_autobanned} && $data->{is_autobanned} eq 'Yes' && ($captcha_freq > $Settings::AUTOBAN_CAPTCHA_FREQ || !$captcha_freq) ) {
        $captcha_freq = $Settings::AUTOBAN_CAPTCHA_FREQ;
    }

    return $captcha_freq;
}


=head2 calc_banners_count_per_page

# Вычисляем отпимальное количество объявлений на странице
# результат - число, общее для всех вкладок страницу управления ставками и страницы медиаплана
#
# оцениваем стоимость отрисовки страницы :  P_page = P_head + N_banners * P_banner + Nphrases *P_phrase
# нормальная по времени отрисовки страница стоит P_head + norm_bpp * (P_banner+P_phrase*norm_ppb) = P_norm
#
# оптимальнео количество баннеров на странице можно вычислить так:
# bpp = (P_norm - P_header)/(P_banner + P_phrase * (N_phrases/N_banners))

=cut
sub calc_banners_count_per_page($) {
    my $cid = shift;

    my $P_head      = 50;   # стоимость отрисовки обвязки
    my $P_banner    = 3;    # стоимость баннера
    my $P_phrase    = 1;    # стоимость фразы

    my $norm_bpp    = 20;   # оптимальное колисество баннеров на странице
    my $norm_ppb    = 5;    # при указанном количестве фраз на баннер

    my $P_norm      = $P_head + $norm_bpp * ($P_banner + $P_phrase * $norm_ppb);


    my $vars = get_one_line_sql(PPC(cid => $cid), "
            SELECT
                (select count(*) from banners where cid = ?) as banners_count,
                (select count(*) from bids where cid = ?) as bids_count,
                (select count(*) from mediaplan_banners where cid = ?) as mediaplan_banners_count,
                (select count(*) from mediaplan_bids where cid = ?) as mediaplan_bids_count
            ", (map {$cid} 1..4));

    my $cnt =  min 20, max(1,  int( ($P_norm - $P_head)/($P_banner + $P_phrase * ($vars->{bids_count}+$vars->{mediaplan_bids_count})/(($vars->{banners_count} + $vars->{mediaplan_banners_count})||1) ) ));

    return nice_int($cnt);
}



=head2 update_camp_auto_optimization(cid, chief-uid, new-flag, %OPT)

    Check and update campaigns.autoOptimization

    $client_chief_uid это не тот uid, которому принадлежит кампания. Это UID агентства/менеджера, если кампания создаётся ими.

    %OPT = (
        dont_send_notification => 1,    # не писать письма об изменениях
    );

=cut

sub update_camp_auto_optimization
{
    my ($cid, $client_chief_uid, $auto_optimization, %OPT) = @_;

    $auto_optimization ||= 'No';

    my ($is_value_changed, $prev_value);
    if ($OPT{dont_send_notification}) {
        # оптимизация: если нам не надо писать письмо, то предыдущее значение нас не интересует. обновляем всегда и экономим один запрос
        $is_value_changed = 1;
    } else {
        # предыдущее значение хорошо бы пробрасывать снаружи
        my $camp_info = get_camp_info($cid, undef, short => 1);
        $prev_value = $camp_info->{autoOptimization};
        $is_value_changed = ($prev_value && $prev_value ne $auto_optimization) ? 1 : 0;
    }

    if ($is_value_changed) {
        do_update_table(PPC(cid => $cid), 'campaigns', {autoOptimization => $auto_optimization, statusBsSynced => 'No'}, where => {cid => SHARD_IDS});

        if (! $OPT{dont_send_notification}) {
            mail_notification('camp', 'c_autooptimisation', $cid, $prev_value, $auto_optimization, $client_chief_uid);
        }
    }

    return 1;
}

=head2 populate_report_vars(vars, reports)

    Ф-ция заполняет переданную ей ссылку на хеш переменными, которые необходимы
    для отображения списка готовых отчетов (любого из существующих сейчас 3 типов)

=cut
sub populate_report_vars {
    my ($vars, $reports) = @_;

    my $sign = $vars->{FORM}->{sort_reverse} ? -1 : 1;
    if ($vars->{FORM}->{sort} && $vars->{FORM}->{sort} eq 'format') {
        @$reports = sort { -($sign*($a->{type} cmp $b->{type}) || $a->{create_time} cmp $b->{create_time} ) } @$reports;
    } else {
        @$reports = sort { -($sign*($a->{create_time} cmp $b->{create_time}) || $a->{type} cmp $b->{type}) } @$reports;
    }

    my $banners_per_page = ($vars->{FORM}->{bpp} and $vars->{FORM}->{bpp} =~ m/^10|20|30|50$/) ? $vars->{FORM}->{bpp} : 10;
    my $page = ($vars->{FORM}->{page} and $vars->{FORM}->{page} =~ m/^\d+$/) ? $vars->{FORM}->{page} : 1;

    $vars->{pages_num}  = ceil ( (scalar @$reports) / $banners_per_page );
    $vars->{page}       = $page = min $vars->{pages_num}, $page;
    $vars->{all_banners_num}    = scalar @$reports;
    $vars->{banners_per_page}   = $banners_per_page;

    my $cnt = 0;
    if ( scalar @$reports ) {
        $vars->{reports} = [ map { $_->{camps} = [grep {m/\d+/} split /\D+/, $_->{cids}];
                                   $_->{report_name} = iget_or($_->{report_name}); $_} splice @$reports, ($page-1)*$banners_per_page, $banners_per_page ];

        my $processing_postview_reports_count = 0;
        my @cids = uniq (map {@{$_->{camps}}} @{$vars->{reports}});
        my $cnames = get_hash_sql(PPC(cid => \@cids), ["SELECT cid, name FROM campaigns", WHERE => { cid => SHARD_IDS }]);
        for my $report (@{$vars->{reports}}) {
            $report->{camp_names} = [map {$cnames->{$_}." (№ $_)"} @{$report->{camps}}];
            if ($report->{type} eq $Reports::Offline::Postview::POSTVIEW_REPORT_TYPE && $Reports::Offline::Postview::PROCESSING_STATUSES{$report->{status}}) {
                $processing_postview_reports_count++;
            }
        }

        $vars->{isCreatePostviewDisabled} = 1 if ($processing_postview_reports_count >= $Reports::Offline::Postview::PROCESSING_REPORTS_LIMIT);
    }
}

=head2

Конфиуграционный хеш для сортировки

=cut

our %CAMPS_SORT = (
    # префиксные поля для сортировки
    _prefix => {
        direct =>  [],
        'reverse' => [],
    },
    # постфиксные поля для сортировки
    _suffix => {
        direct =>  ['c.archived desc', "$CAMP_ACTIVE_SQL desc", 'c.statusActive asc', 'c.start_time asc', 'c.cid asc', ],
        'reverse' => ['c.archived desc', "$CAMP_ACTIVE_SQL asc", 'c.statusActive desc', 'c.start_time desc','c.cid desc', ],
    },

    # ключ для дефолтной cортировки
    _default => 'cid',

    # перечень полей для простой сортировки
    ( map { $_=> { direct=> ["c.$_ asc"], 'reverse'=> ["c.$_ desc"] } } qw/name start_time cid clicks sum sum_units/ ),
    login => { direct=> ['u.login asc'], 'reverse' => ['u.login desc'], },
    total => { direct=> ['c.sum - c.sum_spent'], 'reverse' => ['-(c.sum - c.sum_spent)'], },
    mediaType => {direct => ['c.type asc', 'c.ProductID asc'], 'reverse' => ['c.type desc', 'c.ProductID desc']},
    total_units => {
        direct => ['c.sum_units - c.sum_spent_units asc'],
        reverse => ['c.sum_units - c.sum_spent_units desc'],
    },

    # статус: все значимые флаги в кучу
    'status.text' => {
        direct => [ map {"$_ asc"} qw/ c.archived c.statusActive c.statusBsSynced c.statusModerate co.statusPostModerate / ],
        reverse => [ map {"$_ desc"} qw/ c.archived c.statusActive c.statusBsSynced c.statusModerate co.statusPostModerate / ],
    },

    # сложная сортировка - отличается тем, что внутри нет ключа "direct".
    settings => {
        dontShowYacontext    => { 'direct' => ['c.platform asc'],       'reverse' => ['c.platform desc'], },
        statusOpenStat       => {
            'direct' => ["IF(c.type = 'text', c.statusOpenStat, 'Yes') desc"],
            'reverse' => ["IF(c.type = 'text', c.statusOpenStat, 'Yes') asc"],
        },

        autoOptimization     => { 'direct' => ['c.autoOptimization desc'],        'reverse' => ['c.autoOptimization asc'], },
        broad_match_flag     => {
            'direct' => ["IF(c.platform = 'context' OR c.type != 'text', 'No', co.broad_match_flag) desc"],
            'reverse' => ["IF(c.platform = 'context' OR c.type != 'text', 'No', co.broad_match_flag) asc"],
        },
        statusMetricaControl => { 'direct' => ['co.statusMetricaControl asc'], 'reverse' => ['co.statusMetricaControl desc'], },
        statusContextStop    => { 'direct' => ['co.statusContextStop desc'],    'reverse' => ['co.statusContextStop asc'], },
        strategy_no_premium  => {
            'direct' => ["IF(c.strategy_name='no_premium', c.strategy_data->>'\$.place', NULL) desc"],
            'reverse' => ["IF(c.strategy_name='no_premium', c.strategy_data->>'\$.place', NULL) asc"],
        },

        sNoPremium           => {
            'direct' => ["IF(c.strategy_name='no_premium', IF (ifnull(co.strategy, '') != 'different_places', 0, 1), 2)"],
            'reverse' => ["IF(c.strategy_name='no_premium', IF (ifnull(co.strategy, '') != 'different_places', 2, 1), 0)"],
        },

        sOptimizeClicksWeekBudget => {
            'direct' => [
                "IF(c.strategy_name='autobudget', IF(ifnull(c.strategy_data->>'\$.goal_id', '')='', 0, 1), 1) asc",
            ],
            'reverse' => [
                "IF(c.strategy_name='autobudget', IF(ifnull(c.strategy_data->>'\$.goal_id', '')='', 0, 1), 1) desc",
            ],
        },

        sOptimizeCpaWeekBudget => {
            'direct' => [
                "IF(c.strategy_name='autobudget', IF(ifnull(c.strategy_data->>'\$.goal_id', '')!='', 0, 1), 1) asc",
            ],
            'reverse' => [
                "IF(c.strategy_name='autobudget', IF(ifnull(c.strategy_data->>'\$.goal_id', '')!='', 0, 1), 1) desc",
            ],
        },

        sAutobudget => {
            'direct' => [
                "IF(c.strategy_name='autobudget', 0, 1) asc",
            ],
            'reverse' => [
                "IF(c.strategy_name='autobudget', 0, 1) desc",
            ],
        },
        sAutobudgetAvgClick => {
            'direct' => [
                "IF (c.strategy_name='autobudget_avg_click' AND IFNULL(co.strategy, '') != 'different_places', c.strategy_data->>'\$.avg_bid', 0) desc",
            ],
            'reverse' => [
                "IF (c.strategy_name='autobudget_avg_click' AND IFNULL(co.strategy, '') != 'different_places', c.strategy_data->>'\$.avg_bid', 0) asc",
            ],
        },
        sOptimizeClicksAvgClick => {
            'direct' => [
                "IF (c.strategy_name='autobudget_avg_click' AND IFNULL(co.strategy, '') != 'different_places', c.strategy_data->>'\$.avg_bid', 0) desc",
            ],
            'reverse' => [
                "IF (c.strategy_name='autobudget_avg_click' AND IFNULL(co.strategy, '') != 'different_places', c.strategy_data->>'\$.avg_bid', 0) asc",
            ],
        },
        sAutobudgetAvgCpa => {
            'direct' => [
                "IF (IFNULL(co.strategy, '') != 'different_places', c.strategy_data->>'\$.avg_cpa', 0) desc",
            ],
            'reverse' => [
                "IF (IFNULL(co.strategy, '') != 'different_places', c.strategy_data->>'\$.avg_cpa', 0) asc",
            ],
        },
        sOptimizeCpaAvgCpa => {
            'direct' => [
                "IF (IFNULL(co.strategy, '') != 'different_places', c.strategy_data->>'\$.avg_cpa', 0) desc",
            ],
            'reverse' => [
                "IF (IFNULL(co.strategy, '') != 'different_places', c.strategy_data->>'\$.avg_cpa', 0) asc",
            ],
        },
        sAutobudgetRoi => {
            'direct' => [
                "IF (c.strategy_name='autobudget_roi', c.strategy_data->>'\$.roi_coef', NULL) desc",
            ],
            'reverse' => [
                "IF (c.strategy_name='autobudget_roi', c.strategy_data->>'\$.roi_coef', NULL) asc",
            ],
        },
        sAutobudgetWeekBundle => {
            'direct' => [
                "IF (IFNULL(co.strategy, '') != 'different_places', c.strategy_data->>'\$.limit_clicks', 0) desc",
            ],
            'reverse' => [
                "IF (IFNULL(co.strategy, '') != 'different_places', c.strategy_data->>'\$.limit_clicks', 0) asc",
            ],
        },
        sOptimizeClicksWeekBundle => {
            'direct' => [
                "IF (IFNULL(co.strategy, '') != 'different_places', c.strategy_data->>'\$.limit_clicks', 0) desc",
            ],
            'reverse' => [
                "IF (IFNULL(co.strategy, '') != 'different_places', c.strategy_data->>'\$.limit_clicks', 0) asc",
            ],
        },
        sDefault => {
            'direct' => ["IF (c.strategy_name IN('default','cpm_default'), IF (ifnull(co.strategy, '') != 'different_places', 0, 1), 2)"],
            'reverse' => ["IF (c.strategy_name IN('default','cpm_default'), IF (ifnull(co.strategy, '') != 'different_places', 2, 1), 0)"],
        },
        sDifferentPlaces => {
            'direct' => ["IF(co.strategy = 'different_places', 0, 1)"],
            'reverse' => ["IF(co.strategy = 'different_places', 1, 0)"],
        },
        sAutobudgetMaxReach => {
            'direct' => [ "IF(c.strategy_name='autobudget_max_reach', 0, 1) asc", ],
            'reverse' => [ "IF(c.strategy_name='autobudget_max_reach', 0, 1) desc", ],
        },
        sAutobudgetMaxImpressions => {
            'direct' => [ "IF(c.strategy_name='autobudget_max_impressions', 0, 1) asc", ],
            'reverse' => [ "IF(c.strategy_name='autobudget_max_impressions', 0, 1) desc", ],
        },
        sAutobudgetMaxReachCustomPeriod => {
            'direct' => [ "IF(c.strategy_name='autobudget_max_reach_custom_period', 0, 1) asc", ],
            'reverse' => [ "IF(c.strategy_name='autobudget_max_reach_custom_period', 0, 1) desc", ],
        },
        sAutobudgetMaxImpressionsCustomPeriod => {
            'direct' => [ "IF(c.strategy_name='autobudget_max_impressions_custom_period', 0, 1) asc", ],
            'reverse' => [ "IF(c.strategy_name='autobudget_max_impressions_custom_period', 0, 1) desc", ],
        },
        sAutobudgetAvgCpv => {
            'direct' => [ "IF(c.strategy_name='autobudget_avg_cpv', 0, 1) asc", ],
            'reverse' => [ "IF(c.strategy_name='autobudget_avg_cpv', 0, 1) desc", ],
        },
        sAutobudgetAvgCpvCustomPeriod => {
            'direct' => [ "IF(c.strategy_name='autobudget_avg_cpv_custom_period', 0, 1) asc", ],
            'reverse' => [ "IF(c.strategy_name='autobudget_avg_cpv_custom_period', 0, 1) desc", ],
        },
        sPeriodFixBid => {
            'direct' => [ "IF(c.strategy_name='period_fix_bid', 0, 1) asc", ],
            'reverse' => [ "IF(c.strategy_name='period_fix_bid', 0, 1) desc", ],
        },
        DontShow => { 'direct' => ['IF (c.DontShow is NULL, 1, 0)'], 'reverse' => ['IF (c.DontShow is NULL, 0, 1)'], },
        disabledIps => { 'direct' => ['IF (c.disabledIps is NULL, 1, 0)'], 'reverse' => ['IF (c.disabledIps is NULL, 0, 1)'], },
    },
);



=head2 prepare_user_camps_by_sql_params

Подготовить параметры order by, limit, offset для sql

Входные параметры:

$vars - параметры для шаблона, куда добавим onpage, page, offset
$opts => {
    FORM # ссылка на хеш с данными переданной формы
	{
		onpage             # количество элементов на странице
		page               # номер страницы
		sort               # ключ сортировки
		reverse            # инвертировать сортировку
		${sort_key}_sorted # ключ глубокой сортировка
	}
    SORT # ссылка на конфигурационный хеш с параметрами сортировки
}



=cut

sub prepare_user_camps_by_sql_params {
    my ( $vars, $opts ) = @_;

    my %FORM = %{ delete $opts->{FORM} || {} };
    my %SORT = %{ delete $opts->{SORT} || {} };

    my $sort_key = $FORM{'sort'} || $SORT{_default};
    my $rev_key = $FORM{'reverse'} ? 'reverse' : 'direct';

    my %order_by;
	my $sort_folder = $SORT{$sort_key}{$rev_key}
			? $SORT{$sort_key}
			: $SORT{$sort_key}{$FORM{"${sort_key}_sorted"}}
	;

	if ( $sort_folder && $sort_folder->{$rev_key} ) {
        %order_by = ( order_by => [
			@{$SORT{_prefix}{$rev_key}},
            @{$sort_folder->{$rev_key}},
			@{$SORT{_suffix}{$rev_key}},
		] );
    }

    $vars->{onpage} = ( $FORM{onpage} && $FORM{onpage} =~ /^\d+$/ && $FORM{onpage} <= 10000 && $FORM{onpage} >= 1 )
                ? $FORM{onpage} : 100;
    $vars->{page} = ( $FORM{page} && $FORM{page} =~ /^\d+$/ ) ? $FORM{page} : 1;
    $vars->{offset} = ($vars->{page}-1)*$vars->{onpage};

    return { limit => $vars->{onpage}, offset => $vars->{offset}, %order_by };

}


=head2 get_client_allowed_country_currency

    $allowed_country_currency_data = Common::get_client_allowed_country_currency(
        is_for_agency => 1|0, # нужны ли страны/валюты для агентства_или_субклиентов ИЛИ для самостоятельных/сервисируемых
        agency_client_id => ($FORM{type} eq 'subclient' ? $agency_client_id : undef),
        firm_country_currency_data => $firm_country_currency_data,
        is_direct => $c->is_direct,
        uid => ($FORM{type} // '' ) ne 'subclient' ? $client_uid : undef,
    );

    $allowed_country_currency_data => {
        countries => [
            { region_id => '84',  name_ru => 'США',  name_ua => 'США',  name_tr => 'Birleşik Devletler',  name_en => 'United States',     },
            [...]
        ],
        countries_currencies => {
            $region_id1 => ['RUB', 'USD', 'KZT', ...],
            $region_id2 => [...],
            [...]
            other => ['EUR', 'TRY', ...],
        },
    };

=cut

sub get_client_allowed_country_currency {
    my (%O) = @_;

    my $agency_client_id = $O{agency_client_id};
    my $firm_country_currency_data = $O{firm_country_currency_data};

    my $countries = \@geo_regions::COUNTRY_REGIONS;

    my $countries_currencies;   # region_id => ['RUB', 'USD', ...]
    if (!defined $O{is_for_agency}) {
        die 'is_for_agency parameter is mandatory';
    } elsif ($O{is_for_agency}) {
        $countries_currencies = Currencies::get_currencies_by_country_hash_for_agency($O{uid}, $agency_client_id);
    } else {
        $countries_currencies = Currencies::get_currencies_by_country_hash_not_for_agency($O{uid});
    }

    # Баян и Геоконтекст остаются в фишках
    if (!$O{is_direct}) {
        for my $currencies (values %$countries_currencies) {
            push @$currencies, 'YND_FIXED';
        }
    }

    if ($firm_country_currency_data) {
        # у существующих клиентов (есть ClientID) даём выбирать только доступные по мнению Баланса сочетания валюта-страна
        # т.к. у него уже могут быть плательщики и оплаты в других странах/валютах
        my %country2allowedcurrency;    # region_id => ['RUB', 'USD', ...]
        for my $country_currency (@$firm_country_currency_data) {
            push @{$country2allowedcurrency{$country_currency->{region_id}}}, $country_currency->{currency};
        }

        # Баян и Геоконтекст остаются в фишках
        if (!$O{is_direct}) {
            for my $currencies (values %country2allowedcurrency) {
                push @$currencies, 'YND_FIXED';
            }
        }

        # отсекаем страны, которых нет в ответе Баланса
        $countries = [grep {exists $country2allowedcurrency{$_->{region_id}}} @$countries];
        my @allowed_country_region_ids = uniq map {$_->{region_id}} @$countries;
        $countries_currencies = hash_cut $countries_currencies, @allowed_country_region_ids;
        # отсекаем валюты, которых нет в ответе Баланса для соответствующих стран
        while (my($region_id, $region_countries_list) = each %{$countries_currencies}) {
            my $resulting_currencies = xisect($region_countries_list, $country2allowedcurrency{$region_id});
            if ($resulting_currencies && scalar(@$resulting_currencies) > 0) {
                $countries_currencies->{$region_id} = $resulting_currencies;
            } else {
                # если страны пересекаются, а валюты для них нет, то и страну такую выбирать нельзя
                delete $countries_currencies->{$region_id};
            }
        }
    }

    if ($agency_client_id) {
        my $allowed_currencies = get_agency_allowed_currencies_hash($agency_client_id, is_direct => $O{is_direct});
        # при создании клиентов агентств не спрашиваем страну
        $countries = [0];
        # оставляем только те валюты, которые доступны и самому клиенту, и агентству
        my %client_currency = map { $_ => 1 } uniq map { @$_ } values %$countries_currencies;
        $countries_currencies = {0 => [grep { $client_currency{$_} } keys %$allowed_currencies]};
    }

    return {countries => $countries, countries_currencies => $countries_currencies};
}

=head2 get_cached_balance_country_currency

    Возвращает результат вызова Yandex::Balance::balance_get_firm_country_currency для заданных $client_id, $agency_id c currency_filter => 1:
        $firm_country_currency_data = get_cached_balance_country_currency($client_id, $agency_id);

    Результат вызова Yandex::Balance::balance_get_firm_country_currency кешируется по паре $client_id, $agency_id
    и при повторном вызове get_cached_balance_country_currenc с теми же параметрами будет возвращено закешированное значение.


=cut

sub get_cached_balance_country_currency {
    my ($client_id, $agency_id) = @_;

    state $cache = {};

    my $key = join ':', $client_id//'-', $agency_id//'-';

    unless( $cache->{$key} ){
        $cache->{$key} = BalanceWrapper::get_firm_country_currency(
            $client_id,
            AgencyID => $agency_id,
            currency_filter => 1,
        );
    }

    return $cache->{$key};
}


=head2 get_country_and_currency_from_balance
    По данным из баланса определяет страну и валюту клиента, так же возвращает полные списки валют и стран найденных в датасете, вовращенном  Balance.GetFirmCountryCurrency
    $country_and_currency = get_country_and_currency_from_balance( $ClientID, $AgencyID)

    $country_and_currency => {
        countries  => [84, 225, 159 ...],
        currencies => ['USD', 'RUR' ...],
        country  => 84,    # region_id,  если из баланса получили больше/меньше одной страны поле отсутствует
        currency => 'USD', # код валюты, если из баланса получили больше/меньше одной валюты поле отсутствует
    }

=cut

sub get_country_and_currency_from_balance {
    my ($client_id, $agency_id) = @_;

    my $firm_country_currency_data = get_cached_balance_country_currency($client_id, $agency_id) || [];

    my (@countries, @currencies);
    foreach (@$firm_country_currency_data) {
        push @countries, $_->{region_id};
        push @currencies, $_->{currency};
    }
    @countries  = uniq @countries;
    @currencies = uniq @currencies;

    return {
        countries  => \@countries,
        currencies => \@currencies,
        scalar @countries  == 1 ? ( country  => $countries[0])  : (),
        scalar @currencies == 1 ? ( currency => $currencies[0]) : (),
    }
}


=head2 mix_manager_data(\@campaigns)

    В список хэшей вида { ManagerUID => $uid } домешиваем manager_fio

=cut

sub mix_manager_data {
    my $campaigns = shift;
    enrich_data($campaigns, using => 'ManagerUID', sub {
        my $manager_uids = shift;
        my $managers = get_hashes_hash_sql(PPC(uid => $manager_uids),
            ["select uo.uid as ManagerUID, uo.FIO as manager_fio from users uo",
            where => { uid => SHARD_IDS }]
        );
        return $managers;
    });
    return;
}


=head2 mix_agency_data(\@campaigns)

    В список хэшей вида { AgencyID => $uid } домешиваем agency_name, agency_fio агентства

=cut

sub mix_agency_data {
    my $campaigns = shift;
    enrich_data($campaigns, using => 'AgencyID', sub {
        my $agency_ids = shift;
        my $agencies = get_hashes_hash_sql(PPC(ClientID => $agency_ids),
            ["select cl.ClientID as AgencyID,
                cl.name as agency_name, ua.FIO as agency_fio
                from clients cl join users ua on ua.uid = cl.chief_uid",
            where => { "cl.ClientID" => SHARD_IDS } ]);
        return $agencies;
    });
    return;
}

=head2 get_places

    Берет все позиции с ценам, используется только в DoCmdAdmin::cmd_listWarnPlace.
    Вынесена сюда из PlacePrice из-за циклической зависимости модулей (использует BS::TrafaretAuction)

=cut

sub get_places
{
    my ($arr) = @_;
    return if ! defined $arr || ! @$arr;

    my %arrgeo;
    for my $r ( @$arr ) {
        push @{ $arrgeo{"$r->{OrderID}:$r->{geo}:$r->{domain}:$r->{title}:$r->{body}"} }, $r;
    }

    my @banners;
    while(my ($geo_domain, $phrases) = each %arrgeo) {
        my ($OrderID, $geo, $domain, $title, $body) = split ':', $geo_domain;
        my $banner = hash_cut $arrgeo{$geo_domain}->[0],
                       qw/OrderID geo title body currency pid cid adgroup_type filter_domain
                          phone statusShowsForecast no_extended_geotargeting
                          is_bs_rarely_loaded banner_type/;
        $banner->{phrases} = [map {$_->{phr} = $_->{phrase}; $_} @$phrases];
        push @banners, $banner;
    }

    trafaret_auction(\@banners);

    my $result_places = {};
    ## no critic (Freenode::DollarAB)
    for my $b (@banners) {
        for my $p (@{$b->{phrases}}) {
            my $new_place = calcPlace($p->{price}, $p->{guarantee}, $p->{premium});
            $result_places->{$p->{id}} = $new_place;
        }
    }

    return $result_places;
}

=begin internal_details

# !!! subs_placing -- примечания

    ToDo при перемещении функции my_sub из OldModule в NewModule:

    * переместить функцию и ее описание
    * убрать my_sub из списка экспорта в OldModule (если была)
    * добавить my_sub в список экспорта в NewModule (если надо)
    * use NewModule (если еще нет) везде, где есть вызовы my_sub
    * OldModule::my_sub --> NewModule::my_sub
    * добавить нужные use в NewModule (все, какие нужны для работы my_sub) -- хуже всего автоматизировано
    * юнит-тесты
      * OldModule/my_sub.t --> NewModule/my_sub.t
      * use OldModule --> use NewModule
      * OldModule::my_sub --> NewModule::my_sub
      * svn propdel svn:mergeinfo unit_tests/NewModule (по результатам теста unit_tests/repos/prop_mergeinfo.t)
      * убедиться, что все юнит-тесты проходят нормально
    * попросить тестировщиков хотя бы бегло пройтись по соответствующей функциональности

    expiration date: 1 февраля 2010

=end internal_details

=cut

=head2 is_offer_accepted

    Получение флага оферты

=cut

sub is_offer_accepted {
    my ($uid) = @_;
    my $user_info = eval { JavaIntapi::GetUserInfo
        ->new(user_id => $uid)
        ->call();
    };
    warn $@ if  $@;

    return $user_info->{is_offer_accepted} // 0;
}

1;
