package Currency::Texts;

=head1 NAME

    Currency::Texts

=head1 DESCRIPTION

    Модуль для текстов, зависящих от валюты. Характерный пример -- фразы "оплатить кампанию в <название валюты>"

=cut

use strict;
use warnings;

use Storable qw/dclone/;

use base 'Exporter';
our @EXPORT = qw/get_currency_text/;

use Yandex::I18n;

use utf8;

our %_CURRENCY_TEXTS_DESCRIPTION = (
    pay_in => {
        YND_FIXED => iget_noop('Оплатить'), # для условных единиц пишем просто "Оплатить" ( по крайней мере пока )
        RUB => iget_noop('Оплатить в российских рублях'),
        UAH => iget_noop('Оплатить в украинских гривнах'),
        USD => iget_noop('Оплатить в долларах США'),
        EUR => iget_noop('Оплатить в евро'),
        KZT => iget_noop('Оплатить в тенге'),
        CHF => iget_noop('Оплатить в швейцарских франках'),
        TRY => iget_noop('Оплатить в турецких лирах'),
        BYN => iget_noop('Оплатить в белорусских рублях'),
        GBP => iget_noop('Оплатить в фунтах стерлингов'),
    },
    my_new_campaigns_in => {
        YND_FIXED => iget_noop('Мои новые кампании в у.е.'),
        RUB => iget_noop('Мои новые кампании в российских рублях'),
        UAH => iget_noop('Мои новые кампании в украинских гривнах'),
        USD => iget_noop('Мои новые кампании в долларах США'),
        EUR => iget_noop('Мои новые кампании в евро'),
        KZT => iget_noop('Мои новые кампании в тенге'),
        CHF => iget_noop('Мои новые кампании в швейцарских франках'),
        TRY => iget_noop('Мои новые кампании в турецких лирах'),
        BYN => iget_noop('Мои новые кампании в белорусских рублях'),
        GBP => iget_noop('Мои новые кампании в фунтах стерлингов'),
    },
    client_new_campaigns_in => {
        YND_FIXED => iget_noop('Новые кампании клиента в у.е.'),
        RUB => iget_noop('Новые кампании клиента в российских рублях'),
        UAH => iget_noop('Новые кампании клиента в украинских гривнах'),
        USD => iget_noop('Новые кампании клиента в долларах США'),
        EUR => iget_noop('Новые кампании клиента в евро'),
        KZT => iget_noop('Новые кампании клиента в тенге'),
        CHF => iget_noop('Новые кампании клиента в швейцарских франках'),
        TRY => iget_noop('Новые кампании клиента в турецких лирах'),
        BYN => iget_noop('Новые кампании клиента в белорусских рублях'),
        GBP => iget_noop('Новые кампании клиента в фунтах стерлингов'),
    },
    convert_from_conv_units_into => {
        YND_FIXED => undef, # такая константа нигде требоваться не должна
        RUB => iget_noop('Конвертация из «у.е.» в российские рубли'),
        UAH => iget_noop('Конвертация из «у.е.» в украинские гривны'),
        USD => iget_noop('Конвертация из «у.е.» в доллары США'),
        EUR => iget_noop('Конвертация из «у.е.» в евро'),
        KZT => iget_noop('Конвертация из «у.е.» в тенге'),
        CHF => iget_noop('Конвертация из «у.е.» в швейцарские франки'),
        TRY => iget_noop('Конвертация из «у.е.» в турецкие лиры'),
        BYN => iget_noop('Конвертация из «у.е.» в белорусские рубли'),
        GBP => iget_noop('Конвертация из «у.е.» в фунты стерлингов'),
    },
    convert_all_campaigns_into => {
        YND_FIXED => undef, # такая константа нигде требоваться не должна
        RUB => iget_noop('Перевести все кампании в российские рубли'),
        UAH => iget_noop('Перевести все кампании в украинские гривны'),
        USD => iget_noop('Перевести все кампании в доллары США'),
        EUR => iget_noop('Перевести все кампании в евро'),
        KZT => iget_noop('Перевести все кампании в тенге'),
        CHF => iget_noop('Перевести все кампании в швейцарские франки'),
        TRY => iget_noop('Перевести все кампании в турецкие лиры'),
        BYN => iget_noop('Перевести все кампании в белорусские рубли'),
        GBP => iget_noop('Перевести все кампании в фунты стерлингов'),
    },
    now_converting_from_conv_units_into => {
        YND_FIXED => undef, # такая константа нигде требоваться не должна
        RUB => iget_noop('Идёт переход из «у.е.» в российские рубли'),
        UAH => iget_noop('Идёт переход из «у.е.» в украинские гривны'),
        USD => iget_noop('Идёт переход из «у.е.» в доллары США'),
        EUR => iget_noop('Идёт переход из «у.е.» в евро'),
        KZT => iget_noop('Идёт переход из «у.е.» в тенге'),
        CHF => iget_noop('Идёт переход из «у.е.» в швейцарские франки'),
        TRY => iget_noop('Идёт переход из «у.е.» в турецкие лиры'),
        BYN => iget_noop('Идёт переход из «у.е.» в белорусские рубли'),
        GBP => iget_noop('Идёт переход из «у.е.» в фунты стерлингов'),
    },
    click_price_after_convert => {
        YND_FIXED => undef, # такая константа нигде требоваться не должна
        RUB => iget_noop('Цена клика после перехода в российские рубли'),
        UAH => iget_noop('Цена клика после перехода в украинские гривны'),
        USD => iget_noop('Цена клика после перехода в доллары США'),
        EUR => iget_noop('Цена клика после перехода в евро'),
        KZT => iget_noop('Цена клика после перехода в тенге'),
        CHF => iget_noop('Цена клика после перехода в швейцарские франки'),
        TRY => iget_noop('Цена клика после перехода в турецкие лиры'),
        BYN => iget_noop('Цена клика после перехода в белорусские рубли'),
        GBP => iget_noop('Цена клика после перехода в фунты стерлингов'),
    },
    multicurrency_teaser_title => {
        YND_FIXED => undef, # такая константа нигде требоваться не должна
        RUB => iget_noop('Ведите ваши кампании в рублях'),
        UAH => iget_noop('Ведите ваши кампании в украинских гривнах'),
        USD => iget_noop('Ведите ваши кампании в долларах США'),
        EUR => iget_noop('Ведите ваши кампании в евро'),
        KZT => iget_noop('Ведите ваши кампании в тенге'),
        CHF => iget_noop('Ведите ваши кампании в швейцарских франках'),
        TRY => iget_noop('Ведите ваши кампании в турецких лирах'),
        BYN => iget_noop('Ведите ваши кампании в белорусских рублях'),
        GBP => iget_noop('Ведите ваши кампании в фунтах стерлингов'),
    },
    convert_finished_successfully => {
        YND_FIXED => undef, # такая константа нигде требоваться не должна
        RUB => iget_noop('Перевод на российские рубли успешно завершен'),
        UAH => iget_noop('Перевод на украинские гривны успешно завершен'),
        USD => iget_noop('Перевод на доллары США успешно завершен'),
        EUR => iget_noop('Перевод на евро успешно завершен'),
        KZT => iget_noop('Перевод на тенге успешно завершен'),
        CHF => iget_noop('Перевод на швейцарские франки успешно завершен'),
        TRY => iget_noop('Перевод на турецкие лиры успешно завершен'),
        BYN => iget_noop('Перевод на белорусские рубли успешно завершен'),
        GBP => iget_noop('Перевод на фунты стерлингов успешно завершен'),
    },
    new_campaign_in => {
        YND_FIXED => undef, # такая константа нигде требоваться не должна
        RUB => iget_noop('Новая кампания в российских рублях'),
        UAH => iget_noop('Новая кампания в украинских гривнах'),
        USD => iget_noop('Новая кампания в долларах США'),
        EUR => iget_noop('Новая кампания в евро'),
        KZT => iget_noop('Новая кампания в тенге'),
        CHF => iget_noop('Новая кампания в швейцарских франках'),
        TRY => iget_noop('Новая кампания в турецких лирах'),
        BYN => iget_noop('Новая кампания в белорусских рублях'),
        GBP => iget_noop('Новая кампания в фунтах стерлингов'),
    },
    account_currency_convert_finished => {
        YND_FIXED => undef, # такая константа нигде требоваться не должна
        RUB => iget_noop('Перевод аккаунта в российские рубли завершен'),
        UAH => iget_noop('Перевод аккаунта в украинские гривны завершен'),
        USD => iget_noop('Перевод аккаунта в доллары США завершен'),
        EUR => iget_noop('Перевод аккаунта в евро завершен'),
        KZT => iget_noop('Перевод аккаунта в тенге завершен'),
        CHF => iget_noop('Перевод аккаунта в швейцарские франки завершен'),
        TRY => iget_noop('Перевод аккаунта в турецкие лиры завершен'),
        BYN => iget_noop('Перевод аккаунта в белорусские рубли завершен'),
        GBP => iget_noop('Перевод аккаунта в фунты стерлингов завершен'),
    },
    account_currency_convert_finished_detailed => {
        YND_FIXED => undef, # такая константа нигде требоваться не должна
        RUB => iget_noop('Перевод вашего аккаунта %s в валюту российские рубли успешно завершен'),
        UAH => iget_noop('Перевод вашего аккаунта %s в валюту украинские гривны успешно завершен'),
        USD => iget_noop('Перевод вашего аккаунта %s в валюту доллары США успешно завершен'),
        EUR => iget_noop('Перевод вашего аккаунта %s в валюту евро успешно завершен'),
        KZT => iget_noop('Перевод вашего аккаунта %s в валюту тенге успешно завершен'),
        CHF => iget_noop('Перевод вашего аккаунта %s в валюту швейцарские франки успешно завершен'),
        TRY => iget_noop('Перевод вашего аккаунта %s в валюту турецкие лиры успешно завершен'),
        BYN => iget_noop('Перевод вашего аккаунта %s в валюту белорусские рубли успешно завершен'),
        GBP => iget_noop('Перевод вашего аккаунта %s в валюту фунты стерлингов успешно завершен'),
    },
    account_currency_convert_finished_short => {
        YND_FIXED => undef, # такая константа нигде требоваться не должна
        RUB => iget_noop('Аккаунт %s переведен в российские рубли'),
        UAH => iget_noop('Аккаунт %s переведен в украинские гривны'),
        USD => iget_noop('Аккаунт %s переведен в доллары США'),
        EUR => iget_noop('Аккаунт %s переведен в евро'),
        KZT => iget_noop('Аккаунт %s переведен в тенге'),
        CHF => iget_noop('Аккаунт %s переведен в швейцарские франки'),
        TRY => iget_noop('Аккаунт %s переведен в турецкие лиры'),
        BYN => iget_noop('Аккаунт %s переведен в белорусские рубли'),
        GBP => iget_noop('Аккаунт %s переведен в фунты стерлингов'),
    },
    now_you_use_new_currency => {
        YND_FIXED => undef, # такая константа нигде требоваться не должна
        RUB => iget_noop('Теперь для ведения всех ваших рекламных кампаний будут использоваться российские рубли'),
        UAH => iget_noop('Теперь для ведения всех ваших рекламных кампаний будут использоваться украинские гривны'),
        USD => iget_noop('Теперь для ведения всех ваших рекламных кампаний будут использоваться доллары США'),
        EUR => iget_noop('Теперь для ведения всех ваших рекламных кампаний будет использоваться евро'),
        KZT => iget_noop('Теперь для ведения всех ваших рекламных кампаний будут использоваться казахстанские тенге'),
        CHF => iget_noop('Теперь для ведения всех ваших рекламных кампаний будет использоваться швейцарские франки'),
        TRY => iget_noop('Теперь для ведения всех ваших рекламных кампаний будут использоваться турецкие лиры'),
        BYN => iget_noop('Теперь для ведения всех ваших рекламных кампаний будут использоваться белорусские рубли'),
        GBP => iget_noop('Теперь для ведения всех ваших рекламных кампаний будут использоваться фунты стерлингов'),
    },
    your_client_currency_convert_finished => {
        YND_FIXED => undef, # такая константа нигде требоваться не должна
        RUB => iget_noop('Перевод Вашего клиента %s (%s) в российские рубли завершен'),
        UAH => iget_noop('Перевод Вашего клиента %s (%s) в украинские гривны завершен'),
        USD => iget_noop('Перевод Вашего клиента %s (%s) в доллары США завершен'),
        EUR => iget_noop('Перевод Вашего клиента %s (%s) в евро завершен'),
        KZT => iget_noop('Перевод Вашего клиента %s (%s) в тенге завершен'),
        CHF => iget_noop('Перевод Вашего клиента %s (%s) в швейцарские франки завершен'),
        TRY => iget_noop('Перевод Вашего клиента %s (%s) в турецкие лиры завершен'),
        BYN => iget_noop('Перевод Вашего клиента %s (%s) в белорусские рубли завершен'),
        GBP => iget_noop('Перевод Вашего клиента %s (%s) в фунты стерлингов завершен'),
    },
    your_client_currency_convert_successfully_finished => {
        YND_FIXED => undef, # такая константа нигде требоваться не должна
        RUB => iget_noop('Перевод Вашего клиента %s (%s) в российские рубли успешно завершен'),
        UAH => iget_noop('Перевод Вашего клиента %s (%s) в украинские гривны успешно завершен'),
        USD => iget_noop('Перевод Вашего клиента %s (%s) в доллары США успешно завершен'),
        EUR => iget_noop('Перевод Вашего клиента %s (%s) в евро успешно завершен'),
        KZT => iget_noop('Перевод Вашего клиента %s (%s) в тенге успешно завершен'),
        CHF => iget_noop('Перевод Вашего клиента %s (%s) в швейцарские франки успешно завершен'),
        TRY => iget_noop('Перевод Вашего клиента %s (%s) в турецкие лиры успешно завершен'),
        BYN => iget_noop('Перевод Вашего клиента %s (%s) в белорусские рубли успешно завершен'),
        GBP => iget_noop('Перевод Вашего клиента %s (%s) в фунты стерлингов успешно завершен'),
    },
    convert_start_at => {
        YND_FIXED => undef, # такая константа нигде требоваться не должна
        RUB => iget_noop('Перевод всех кампаний в рубли начнется автоматически после %s'),
        UAH => undef, # такая константа нигде требоваться не должна
        USD => undef, # такая константа нигде требоваться не должна
        EUR => undef, # такая константа нигде требоваться не должна
        KZT => undef, # такая константа нигде требоваться не должна
        CHF => undef, # такая константа нигде требоваться не должна
        TRY => undef, # такая константа нигде требоваться не должна
        BYN => undef, # такая константа нигде требоваться не должна
        GBP => undef, # такая константа нигде требоваться не должна
    },
    api_locked_during_currency_converted => {
        YND_FIXED => undef, # такая константа нигде требоваться не должна
        RUB => iget_noop('Доступ к кампаниям закрыт на время перехода в российские рубли'),
        UAH => iget_noop('Доступ к кампаниям закрыт на время перехода в украинские гривны'),
        USD => iget_noop('Доступ к кампаниям закрыт на время перехода в доллары США'),
        EUR => iget_noop('Доступ к кампаниям закрыт на время перехода в евро'),
        KZT => iget_noop('Доступ к кампаниям закрыт на время перехода в тенге'),
        CHF => iget_noop('Доступ к кампаниям закрыт на время перехода в швейцарские франки'),
        TRY => iget_noop('Доступ к кампаниям закрыт на время перехода в турецкие лиры'),
        BYN => iget_noop('Доступ к кампаниям закрыт на время перехода в белорусские рубли'),
        GBP => iget_noop('Доступ к кампаниям закрыт на время перехода в фунты стерлингов'),
    },
    pay_specific => {
        YND_FIXED => undef, # такая константа нигде требоваться не должна
        RUB => iget_noop('Особенности платежей в российских рублях'),
        UAH => iget_noop('Особенности платежей в украинских гривнах'),
        USD => iget_noop('Особенности платежей в долларах США'),
        EUR => iget_noop('Особенности платежей в евро'),
        KZT => iget_noop('Особенности платежей в тенге'),
        CHF => iget_noop('Особенности платежей в швейцарских франках'),
        TRY => iget_noop('Особенности платежей в турецких лирах'),
        BYN => iget_noop('Особенности платежей в белорусских рублях'),
        GBP => iget_noop('Особенности платежей в фунтах стерлингов'),
    },
    work_specific => {
        YND_FIXED => undef, # такая константа нигде требоваться не должна
        RUB => iget_noop('Особенности работы в %sроссийских рублях%s'),
        UAH => iget_noop('Особенности работы в %sукраинских гривнах%s'),
        USD => iget_noop('Особенности работы в %sдолларах США%s'),
        EUR => iget_noop('Особенности работы в %sевро%s'),
        KZT => iget_noop('Особенности работы в %sтенге%s'),
        CHF => iget_noop('Особенности работы в %sшвейцарских франках%s'),
        TRY => iget_noop('Особенности работы в %sтурецких лирах%s'),
        BYN => iget_noop('Особенности работы в %sбелорусских рублях%s'),
        GBP => iget_noop('Особенности работы в %sфунтах стерлингов%s'),
    },
);

=head2 get_currency_text

    Возвращает текст с указанным идентификатором для переданной валюты.
    Текст возвращается локализованным в текущий язык, iget() вызывать не надо.

    $text = get_currency_text($currency, $name);
    $text = get_currency_text($currency, $name, $iget_opt1, $iget_opt2, ...);

    $text = get_currency_text('EUR', 'pay_in'); # $text => 'Оплатить в евро'

=cut

sub get_currency_text {
    my ($currency, $name, @iget_opts) = @_;

    die "can't get currency text $name for currency $currency" if (!exists $_CURRENCY_TEXTS_DESCRIPTION{$name} || ! exists $_CURRENCY_TEXTS_DESCRIPTION{$name}->{$currency});
    my $text = $_CURRENCY_TEXTS_DESCRIPTION{$name}->{$currency};
    if (defined $text) {
        return iget($text, @iget_opts);
    } else {
        return undef;
    }
}

=head2 get_currency_texts_description_for_js

    Возвращает словарь с различными текстовыми описаниями действий с валютами
        для использования в js. Ожидается, что будет использоваться в функции
        u.currencies.getText (на замену перловой get_currency_text)

=cut
sub get_currency_texts_description_for_js {
    my %currency_texts_description_for_js = %{ dclone(\%_CURRENCY_TEXTS_DESCRIPTION) };
    return \%currency_texts_description_for_js;
}

1;
