use warnings;
use strict;

package DBLog;

=head1 NAME

DBLog - функции для работы (записи, чтения) логов в БД


=cut

use base qw/Exporter/;

use Settings;

use LogTools;

use utf8;

our @EXPORT = qw(
    log_balance
);

=head2 log_balance

    log_balance($ClientID, $uid, $cid, $sum, $tid, $type, $currency);

=cut

sub log_balance {
    my ($ClientID, $uid, $cid, $sum, $sum_delta, $tid, $type, $currency) = @_;

    LogTools::log_campaign_balance([{
        ClientID => $ClientID,
        cid => $cid,
        sum => $sum,
        sum_delta => $sum_delta,
        tid => $tid,
        # logtime получит значение за счёт DEFAULT CURRENT_TIMESTAMP у поля
            type => $type,
            currency => $currency,
    }]);
}

1;

