package DevTools;

use strict;
use warnings;
use utf8;

use Plack::UTF8Request;
use Sys::Hostname;

use Yandex::Trace;

use Settings;
use DoCmd;
use HttpTools;
use CSRFCheck;
use PrimitivesIds;

sub process_query
{
    my ($UID, $query) = @_;


    my $login = get_login(uid => $UID);
    my $uri = '/registered/main.'.get_csrf_token($UID).'.pl';

    $ENV{HTTP_USER_AGENT} = 'bot';
    $ENV{REQUEST_METHOD} = 'GET';
    $ENV{QUERY_STRING} = $query;
    $ENV{DOCUMENT_ROOT} = "$Settings::ROOT/data";
    my $r = Plack::UTF8Request->new({
        REQUEST_METHOD => 'GET',
        REMOTE_ADDR => '95.108.174.122',
        HTTP_USER_AGENT => $ENV{HTTP_USER_AGENT},
        SCRIPT_NAME => $uri,
        PATH_INFO => $uri,
        REQUEST_URI => "$uri?$query",
        QUERY_STRING => $query,
        SERVER_NAME => 'direct.yandex.ru',
        SERVER_PORT => 80,
        SERVER_PROTOCOL => 'HTTP/1.0',
    });

    {
        no warnings;
        *Plack::UTF8Request::pnotes = sub {
            return {
                uid => $UID,
                user_login => $login,
            }->{$_[1]};
        };
        *Plack::UTF8Request::headers_out = *Plack::UTF8Request::err_headers_out = sub {
            return bless {}, "FakeHeadersOut";
        };
        *Plack::UTF8Request::status = *Plack::UTF8Request::no_cache = sub {
            return 1;
        };
        #*Plack::UTF8Request::hostname = \&Plack::Request::remote_host;
        *Plack::UTF8Request::hostname = sub { Sys::Hostname::hostname(); };
        *FakeHeadersOut::set = sub {
            return 1;
        };
        *HttpTools::get_all_cookies = sub {
            return {
                yandex_login => $login,
                yandexuid => 111,
            };
        };
        *DoCmd::parse_form = sub {
            return %{multiform2directform($r->parameters)};
        };
        *HttpTools::parse_multivalue_form = sub {
            return [$r->parameters, multiform2directform($r->parameters)];
        };
        *DoCmd::is_ip_in_networks = sub {1};
        *TTTools::get_svn_info = sub {return undef};
    }

    my $trace = Yandex::Trace->new(method => 'main', service => 'direct.perl.web');
    return DoCmd::do_direct_cmd($r);
}

1;
