package Direct::AbSegmentConditions;

use Mouse;

use Direct::Modern;
use Carp qw/croak/;

use Direct::Model::AbSegmentCondition::Manager;

use Settings;

extends 'Direct::RetargetingConditions';

has '+items' => (is => 'ro', isa => 'ArrayRef[Direct::Model::AbSegmentCondition]');

=head2 manager_class
=head2 manager
=cut

sub manager_class { 'Direct::Model::AbSegmentCondition::Manager' }
sub manager { $_[0]->manager_class->new(items => $_[0]->items) }

sub get_by {
    my ($class, $key, $vals, %options) = @_;

    return $class->SUPER::get_by($key, $vals, %options, filter => {retargeting_conditions_type => 'ab_segments'});
}

sub update {
    my ($self) = @_;
    croak 'update operation not supported for ab segments';
}

sub delete {
    my ($self) = @_;
    croak 'delete operation not supported for ab segments';
}
1;
