package Direct::AdGroups2::CpmBanner;

use Mouse;
use Direct::Modern;

extends 'Direct::AdGroups2';

use Direct::Model::AdGroupCpmBanner;
use Direct::Model::AdGroupCpmBanner::Manager;

has '+items' => (isa => 'ArrayRef[Direct::Model::AdGroupCpmBanner]');

=head2 manager_class
=cut

sub manager_class { 'Direct::Model::AdGroupCpmBanner::Manager' }

=head2 get($adgroup_ids, %options)

Аналогичен Direct::AdGroups2->get с adgroup_type => 'cpm_banner'.

=cut

sub get {
    my ($class, $adgroup_ids, %options) = @_;
    $class->SUPER::get($adgroup_ids, %options, adgroup_type => 'cpm_banner');
}

=head2 get_by($key, $vals, %options)

Аналогичен Direct::AdGroups2->get_by с adgroup_type => 'cpm_banner'.

=cut

sub get_by {
    my ($class, $key, $vals, %options) = @_;
    $class->SUPER::get_by($key, $vals, %options, adgroup_type => 'cpm_banner');
}

=head2 create($uid)

Создание списка групп текстовых объявлений в БД для пользователя $uid.

=cut

sub create {
    my ($self, $uid) = @_;

    $self->set_client_id_by_uid($uid);
    $self->prepare_create($uid);
    $self->prepare_logging('create', uid => $uid);
    $self->manager->create();
    $self->do_logging();

    return;
}

=head2 update($uid, %options)

Обновление списка групп объявлений в БД для пользователя $uid.
%options аналогичны prepare_update.

=cut

sub update {
    my ($self, $uid, %options) = @_;

    $self->set_client_id_by_uid($uid);
    $self->prepare_update(%options);
    $self->prepare_logging('update', uid => $uid);
    $self->manager->update();
    $self->do_logging();

    return;
}

1;
