package Direct::AdGroups2::Dynamic;

use Mouse;
use Direct::Modern;

extends 'Direct::AdGroups2';

use Direct::Model::AdGroupDynamic;
use Direct::Model::AdGroupDynamic::Manager;

use Exporter qw/import/;

has '+items' => (isa => 'ArrayRef[Direct::Model::AdGroupDynamic]');

=head2 manager_class
=cut

sub manager_class { 'Direct::Model::AdGroupDynamic::Manager' }

=head2 get($adgroup_ids, %options)

Аналогичен Direct::AdGroups2->get с adgroup_type => 'dynamic'.

=cut

sub get {
    my ($class, $adgroup_ids, %options) = @_;
    $class->SUPER::get($adgroup_ids, %options, adgroup_type => 'dynamic');
}

=head2 get_by($key, $vals, %options)

Аналогичен Direct::AdGroups2->get_by с adgroup_type => 'dynamic'.

=cut

sub get_by {
    my ($class, $key, $vals, %options) = @_;
    $class->SUPER::get_by($key, $vals, %options, adgroup_type => 'dynamic');
}

=head2 create($uid)

Создание списка групп динамических объявлений в БД для пользователя $uid.

=cut

sub create {
    my ($self, $uid) = @_;

    $self->set_client_id_by_uid($uid);
    $self->prepare_create($uid);
    $self->prepare_logging('create', uid => $uid);
    $self->manager->create();
    $self->do_logging();

    return;
}

=head2 prepare_update(%options)

Подготовка списка групп динамических объявлений к обновлению.
%options унаследованы от родительского метода.

=cut

sub prepare_update {
    my ($self, %options) = @_;

    $self->SUPER::prepare_update(%options);

    for my $adgroup (@{$self->items}) {
        # feed_id не меняется
        croak "Cannot change feed_id on dynamic adgroup" if $adgroup->is_feed_id_changed;

        if ($adgroup->is_main_domain_changed) {
            # При изменении основного домена сбросим статус синхронизации с БК и обновим last_change
            $adgroup->status_bs_synced('No');
            $adgroup->do_update_last_change(1);

            # Обновим статус генерации фраз в BannerLand
            if ($adgroup->status_moderate ne 'New' && $adgroup->status_bl_generated eq 'No') {
                $adgroup->status_bl_generated('Processing');
            }
        }

        # Сброс statusBsSynced означает, что нужно также сбросить этот статус на всех баннерах в группе
        if ($adgroup->is_status_bs_synced_changed && $adgroup->status_bs_synced eq 'No') {
            $adgroup->do_bs_sync_banners(1);
        }
    }

    return $self;
}

=head2 update($uid, %options)

Обновление списка групп динамических объявлений в БД для пользователя $uid.
%options аналогичны prepare_update.

=cut

sub update {
    my ($self, $uid, %options) = @_;

    $self->set_client_id_by_uid($uid);
    $self->prepare_update(%options);
    $self->prepare_logging('update', uid => $uid);
    $self->manager->update();
    $self->do_logging();

    return;
}

1;
